/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.sharedcontent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentWithPath;

public class VirtualFolderContent
extends SharedContentWithPath {
    protected static final String TYPE = "VirtualFolder";
    private String name;
    private List<SharedContent> childs;
    private boolean addToMediaLibrary;

    public VirtualFolderContent(String name, List<SharedContent> childs) {
        this(null, name, childs, true);
    }

    public VirtualFolderContent(String parent, String name, List<SharedContent> childs) {
        this(parent, name, childs, true);
    }

    public VirtualFolderContent(String parent, String name, List<SharedContent> childs, boolean addToMediaLibrary) {
        this.setParent(parent);
        this.name = name;
        this.childs = childs;
        this.addToMediaLibrary = addToMediaLibrary;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setChilds(List<SharedContent> value) {
        this.childs = value;
    }

    public List<SharedContent> getChilds() {
        return this.childs;
    }

    public void setAddToMediaLibrary(boolean value) {
        this.addToMediaLibrary = value;
    }

    public boolean isAddToMediaLibrary() {
        return this.addToMediaLibrary;
    }

    public List<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        if (this.childs != null) {
            for (SharedContent sharedContent : this.childs) {
                FolderContent folder;
                if (!(sharedContent instanceof FolderContent) || (folder = (FolderContent)sharedContent).getFile() == null) continue;
                result.add(folder.getFile());
            }
        }
        return result;
    }

    public List<VirtualFolderContent> getVirtualFolders() {
        ArrayList<VirtualFolderContent> result = new ArrayList<VirtualFolderContent>();
        if (this.childs != null) {
            for (SharedContent sharedContent : this.childs) {
                if (!(sharedContent instanceof VirtualFolderContent)) continue;
                VirtualFolderContent virtualFolder = (VirtualFolderContent)sharedContent;
                result.add(virtualFolder);
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isExternalContent() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (super.equals(o) && o instanceof VirtualFolderContent) {
            VirtualFolderContent other = (VirtualFolderContent)o;
            if (this.childs == null) {
                if (other.childs != null) {
                    return false;
                }
            } else {
                if (other.childs == null || other.childs.size() != this.childs.size()) {
                    return false;
                }
                for (int i = 0; i < this.childs.size(); ++i) {
                    if (this.childs.get(i).equals(other.childs.get(i))) continue;
                    return false;
                }
            }
            return this.addToMediaLibrary == other.addToMediaLibrary && (this.name == null && other.name == null || this.name != null && this.name.equals(other.name));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 83 * hash + Objects.hashCode(this.name);
        hash = 83 * hash + Objects.hashCode(this.childs);
        hash = 83 * hash + (this.addToMediaLibrary ? 1 : 0);
        return hash;
    }
}

