/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.sharedcontent;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTypeAdapter
implements JsonSerializer<File>,
JsonDeserializer<File> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedContentConfiguration.class);

    @Override
    public JsonElement serialize(File src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.getAbsolutePath());
    }

    @Override
    public File deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        File file = new File(json.getAsJsonPrimitive().getAsString());
        try {
            FilePermissions permissions = FileUtil.getFilePermissions(file);
            if (!permissions.isBrowsable()) {
                LOGGER.warn("Insufficient permission to read folder \"{}\": {}", (Object)file.getAbsolutePath(), (Object)permissions.getLastCause());
            }
            return file;
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Folder not found: {}", (Object)e.getMessage());
            return null;
        }
    }
}

