/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.search;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.movie.MovieShortResultsSchema;
import java.util.HashMap;

public class SearchMovieEndpoint
extends Endpoint {
    private static final String V3_SEARCH_MOVIE_ENDPOINT = "/3/search/movie";
    private final String searchQuery;
    private boolean includeAdult;
    private String language;
    private int page;
    private int primaryReleaseYear;
    private String region;
    private int year;

    public SearchMovieEndpoint(TMDbClient tmdbClient, String searchQuery) {
        super(tmdbClient);
        this.searchQuery = searchQuery;
    }

    public SearchMovieEndpoint includeAdultContent(boolean value) {
        this.includeAdult = value;
        return this;
    }

    public SearchMovieEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public SearchMovieEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public SearchMovieEndpoint setPrimaryReleaseYear(int value) {
        this.primaryReleaseYear = value;
        return this;
    }

    public SearchMovieEndpoint setRegion(String value) {
        this.region = value.toUpperCase();
        return this;
    }

    public SearchMovieEndpoint setYear(int value) {
        this.year = value;
        return this;
    }

    public MovieShortResultsSchema getResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("query", this.searchQuery);
        SearchMovieEndpoint.addQueryBoolean(query, "include_adult", this.includeAdult, false);
        SearchMovieEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        SearchMovieEndpoint.addQueryNumber(query, "page", this.page);
        SearchMovieEndpoint.addQueryNumber(query, "primary_release_year", this.primaryReleaseYear);
        SearchMovieEndpoint.addQueryString(query, "region", this.region);
        SearchMovieEndpoint.addQueryNumber(query, "year", this.year);
        return this.tmdbClient.get(V3_SEARCH_MOVIE_ENDPOINT, MovieShortResultsSchema.class, query);
    }
}

