/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.keyword;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.keyword.KeywordAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.keyword.KeywordDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.keyword.KeywordMoviesResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KeywordEndpoint
extends Endpoint {
    private static final String V3_KEYWORD_ENDPOINT = "/3/keyword/";
    private static final String MOVIES_ENDPOINT = "/" + String.valueOf((Object)KeywordAppendToResponse.MOVIES);
    private final long keywordId;
    private final List<KeywordAppendToResponse> appendToResponse = new ArrayList<KeywordAppendToResponse>();
    private String language;

    public KeywordEndpoint(TMDbClient tmdbClient, long keywordId) {
        super(tmdbClient);
        this.keywordId = keywordId;
    }

    public KeywordEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public KeywordEndpoint appendToResponse(KeywordAppendToResponse ... values) {
        if (values != null) {
            KeywordAppendToResponse[] keywordAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                KeywordAppendToResponse value = keywordAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public KeywordDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        KeywordEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        KeywordEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        return this.tmdbClient.get(V3_KEYWORD_ENDPOINT + this.keywordId, KeywordDetailsSchema.class, query);
    }

    public KeywordMoviesResponseSchema getMovies() {
        HashMap<String, String> query = new HashMap<String, String>();
        KeywordEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_KEYWORD_ENDPOINT + this.keywordId + MOVIES_ENDPOINT, KeywordMoviesResponseSchema.class, null);
    }
}

