/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.universalmediaserver.tmdbapi.TMDbException;
import com.universalmediaserver.tmdbapi.TMDbRateLimiter;
import com.universalmediaserver.tmdbapi.endpoint.account.AccountIdV4Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.AccountV3Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.account.AccountV4Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.auth.AuthEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.authentication.AuthenticationEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.certification.CertificationEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.collection.CollectionEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.company.CompanyEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.configuration.ConfigurationEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.credit.CreditEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.find.FindEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.find.FindExternalSource;
import com.universalmediaserver.tmdbapi.endpoint.genre.GenreEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.keyword.KeywordEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListIdV4Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListV4Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.movie.MovieEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.movie.MovieIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.network.NetworkEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.person.PersonEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.person.PersonIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.review.ReviewEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.search.SearchEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.trending.TrendingEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.trending.TrendingTimeWindow;
import com.universalmediaserver.tmdbapi.endpoint.tv.TvEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.TvIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.episode.TvEpisodeIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.episode.TvEpisodeTvIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.episodegroup.TvEpisodeGroupEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.season.TvSeasonIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.season.TvSeasonTvIdEndpoint;
import com.universalmediaserver.tmdbapi.endpoint.watchproviders.WatchProvidersEndpoint;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.media.MediaTypeInterface;
import com.universalmediaserver.tmdbapi.schema.media.MediaTypeInterfaceDeserializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TMDbClient {
    private static final String DEFAULT_BASE_URL = "https://api.themoviedb.org";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)MediaTypeInterface.class), new MediaTypeInterfaceDeserializer()).create();
    private String apiKey;
    private String accessToken;
    private String baseUrl;
    private String defaultLanguage;
    private String readToken;
    private String guestSessionId;
    private String sessionId;
    private String lastBody;
    private boolean testing;

    public TMDbClient() {
        this(DEFAULT_BASE_URL, null);
    }

    public TMDbClient(String apiKeyOrReadToken) {
        this(DEFAULT_BASE_URL, apiKeyOrReadToken);
    }

    public TMDbClient(String baseUrl, String apiKeyOrReadToken) {
        this.baseUrl = baseUrl;
        if (apiKeyOrReadToken != null && apiKeyOrReadToken.length() > 32) {
            this.readToken = apiKeyOrReadToken;
        } else {
            this.apiKey = apiKeyOrReadToken;
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getGuestSessionId() {
        return this.guestSessionId;
    }

    public String getLastBody() {
        return this.lastBody;
    }

    public String getReadToken() {
        return this.readToken;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getVersion() {
        return this.readToken != null ? 4 : 3;
    }

    public void setAccessToken(String value) {
        this.accessToken = value;
    }

    public void setApiKey(String value) {
        this.apiKey = value;
    }

    public void setBaseUrl(String value) {
        this.baseUrl = value;
    }

    public void setDefaultLanguage(String value) {
        this.defaultLanguage = value;
    }

    public void setGuestSessionId(String value) {
        this.guestSessionId = value;
    }

    public void setReadToken(String value) {
        this.readToken = value;
    }

    public void setSessionId(String value) {
        this.sessionId = value;
    }

    public void setTesting(boolean value) {
        this.testing = value;
    }

    public AccountV3Endpoint account() {
        return new AccountV3Endpoint(this);
    }

    public AccountV4Endpoint accountV4() {
        return new AccountV4Endpoint(this);
    }

    public AccountIdV4Endpoint accountV4(String accountId) {
        return new AccountIdV4Endpoint(this, accountId);
    }

    public AuthEndpoint auth() {
        return new AuthEndpoint(this);
    }

    public AuthenticationEndpoint authentication() {
        return new AuthenticationEndpoint(this);
    }

    public CertificationEndpoint certification() {
        return new CertificationEndpoint(this);
    }

    public CollectionEndpoint collection(long collectionId) {
        return new CollectionEndpoint(this, collectionId);
    }

    public CompanyEndpoint company(long companyId) {
        return new CompanyEndpoint(this, companyId);
    }

    public CreditEndpoint credit(String creditId) {
        return new CreditEndpoint(this, creditId);
    }

    public ConfigurationEndpoint configuration() {
        return new ConfigurationEndpoint(this);
    }

    public FindEndpoint find(String externalId, FindExternalSource externalSource) {
        return new FindEndpoint(this, externalId, externalSource);
    }

    public GenreEndpoint genre() {
        return new GenreEndpoint(this);
    }

    public KeywordEndpoint keyword(long keywordId) {
        return new KeywordEndpoint(this, keywordId);
    }

    public ListV4Endpoint listV4(String name, String iso639Part1) {
        return new ListV4Endpoint(this, name, iso639Part1);
    }

    public ListIdV4Endpoint listV4(long listId) {
        return new ListIdV4Endpoint(this, listId);
    }

    public MovieEndpoint movie() {
        return new MovieEndpoint(this);
    }

    public MovieIdEndpoint movie(long movieId) {
        return new MovieIdEndpoint(this, movieId);
    }

    public NetworkEndpoint network(long networkId) {
        return new NetworkEndpoint(this, networkId);
    }

    public PersonEndpoint person() {
        return new PersonEndpoint(this);
    }

    public PersonIdEndpoint person(long personId) {
        return new PersonIdEndpoint(this, personId);
    }

    public ReviewEndpoint review(String reviewId) {
        return new ReviewEndpoint(this, reviewId);
    }

    public SearchEndpoint search(String searchQuery) {
        return new SearchEndpoint(this, searchQuery);
    }

    public TrendingEndpoint trending(TrendingTimeWindow timeWindow) {
        return new TrendingEndpoint(this, timeWindow);
    }

    public TvEndpoint tv() {
        return new TvEndpoint(this);
    }

    public TvIdEndpoint tv(long tvId) {
        return new TvIdEndpoint(this, tvId);
    }

    public TvEpisodeIdEndpoint tvEpisode(long episodeId) {
        return new TvEpisodeIdEndpoint(this, episodeId);
    }

    public TvEpisodeTvIdEndpoint tvEpisode(long tvId, long seasonNumber, long episodeNumber) {
        return new TvEpisodeTvIdEndpoint(this, tvId, seasonNumber, episodeNumber);
    }

    public TvEpisodeGroupEndpoint tvEpisodeGroup(String episodeGroupId) {
        return new TvEpisodeGroupEndpoint(this, episodeGroupId);
    }

    public TvSeasonTvIdEndpoint tvSeason(long tvId, long seasonNumber) {
        return new TvSeasonTvIdEndpoint(this, tvId, seasonNumber);
    }

    public TvSeasonIdEndpoint tvSeason(long seasonId) {
        return new TvSeasonIdEndpoint(this, seasonId);
    }

    public WatchProvidersEndpoint watchProviders() {
        return new WatchProvidersEndpoint(this);
    }

    public <T> T get(String endpoint, Class<T> resultClass, Map<String, String> query) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).GET().build();
            return this.getResult(request, resultClass);
        }
        catch (TMDbException ex) {
            Logger.getLogger(TMDbClient.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public <T> T post(String endpoint, Class<T> resultClass, Map<String, String> query, String postData) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).POST(HttpRequest.BodyPublishers.ofString(postData)).build();
            return this.getResult(request, resultClass);
        }
        catch (TMDbException ex) {
            Logger.getLogger(TMDbClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public <T> T put(String endpoint, Class<T> resultClass, Map<String, String> query, String postData) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).PUT(HttpRequest.BodyPublishers.ofString(postData)).build();
            return this.getResult(request, resultClass);
        }
        catch (TMDbException ex) {
            Logger.getLogger(TMDbClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public <T> T delete(String endpoint, Class<T> resultClass, Map<String, String> query) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).DELETE().build();
            return this.getResult(request, resultClass);
        }
        catch (TMDbException ex) {
            Logger.getLogger(TMDbClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private <T> T getResult(HttpRequest request, Class<T> resultClass) throws TMDbException {
        try {
            int requestId = TMDbRateLimiter.getRequestId();
            return this.getResult(requestId, request, resultClass);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private <T> T getResult(int requestId, HttpRequest request, Class<T> resultClass) throws InterruptedException, TMDbException {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            int statusCode = response.statusCode();
            if (this.testing) {
                this.lastBody = body;
            }
            if (statusCode >= 200 && statusCode < 300) {
                T t = GSON.fromJson(body, resultClass);
                return t;
            }
            try {
                StatusSchema status;
                try {
                    status = GSON.fromJson(body, StatusSchema.class);
                }
                catch (JsonSyntaxException ex) {
                    status = new StatusSchema();
                    status.setStatusCode(statusCode);
                    status.setStatusMessage(body);
                }
                throw new TMDbException(statusCode + ": TMDb status" + String.valueOf(status.getStatusCode()) + ": " + status.getStatusMessage());
            }
            catch (IOException ex) {
                throw new TMDbException("Error while sending the request", ex);
            }
        }
        finally {
            TMDbRateLimiter.setRequestEnd(requestId);
        }
    }

    private HttpRequest.Builder getBuilder(String endpoint, Map<String, String> query) throws TMDbException {
        URI requestUri;
        URI contextURI;
        StringBuilder urlBuilder = new StringBuilder();
        if (query == null) {
            query = new HashMap<String, String>();
        }
        if (!query.containsKey("api_key")) {
            query.put("api_key", this.apiKey);
        }
        for (Map.Entry<String, String> param : query.entrySet()) {
            String value = param.getValue();
            if (value == null || value.trim().length() <= 0) continue;
            urlBuilder.append(urlBuilder.isEmpty() ? "?" : "&");
            String key = param.getKey();
            value = URLEncoder.encode(value, StandardCharsets.UTF_8);
            urlBuilder.append(key).append("=").append(value);
        }
        urlBuilder.insert(0, endpoint);
        try {
            contextURI = new URI(this.baseUrl);
        }
        catch (URISyntaxException ex) {
            throw new TMDbException("Base url '" + this.baseUrl + "' malformed", ex);
        }
        try {
            requestUri = contextURI.resolve(urlBuilder.toString());
        }
        catch (IllegalArgumentException ex) {
            throw new TMDbException("Request url malformed", ex);
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(requestUri).setHeader("Content-Type", "application/json;charset=utf-8").setHeader("accept", "application/json");
        if (this.accessToken != null) {
            builder.setHeader("Authorization", "Bearer " + this.accessToken);
        } else if (this.readToken != null) {
            builder.setHeader("Authorization", "Bearer " + this.readToken);
        }
        return builder;
    }
}

