/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.wmf;

import com.twelvemonkeys.imageio.plugins.wmf.WMF;
import com.twelvemonkeys.imageio.plugins.wmf.WMFImageReader;
import com.twelvemonkeys.imageio.plugins.wmf.WMFProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public final class WMFImageReaderSpi
extends ImageReaderSpiBase {
    public WMFImageReaderSpi() {
        super(new WMFProviderInfo());
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && WMFProviderInfo.WMF_READER_AVAILABLE && WMFImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("input == null");
        }
        try {
            imageInputStream.mark();
            for (byte by : WMF.HEADER) {
                byte by2 = (byte)imageInputStream.read();
                if (by == by2) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new WMFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Windows Meta File (WMF) image reader";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (!WMFProviderInfo.WMF_READER_AVAILABLE) {
            IIOUtil.deregisterProvider(serviceRegistry, this, clazz);
        }
    }
}

