/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

final class XS24Chunk
extends IFFChunk {
    private byte[] data;
    int width;
    int height;

    XS24Chunk(int n) {
        super(1481847348, n);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        this.width = dataInput.readUnsignedShort();
        this.height = dataInput.readUnsignedShort();
        dataInput.readShort();
        int n = this.width * this.height * 3;
        if (n > this.chunkLength - 6) {
            throw new IIOException("Bad XS24 chunk: " + this.width + " * " + this.height + " * 3 > chunk length (" + this.chunkLength + ")");
        }
        this.data = new byte[n];
        dataInput.readFully(this.data);
        for (int i = 0; i < this.chunkLength - n - 6; ++i) {
            dataInput.readByte();
        }
    }

    @Override
    void writeChunk(DataOutput dataOutput) {
        throw new InternalError("Not implemented: writeChunk()");
    }

    @Override
    public String toString() {
        return super.toString() + "{thumbnail=" + this.data.length + '}';
    }

    public BufferedImage thumbnail() {
        BufferedImage bufferedImage = ImageTypeSpecifiers.createFromBufferedImageType(5).createBufferedImage(this.width, this.height);
        bufferedImage.getRaster().setDataElements(0, 0, this.width, this.height, this.data);
        return bufferedImage;
    }
}

