# ==============================================================================
# title			:TheeMahn's O/S Builder
# description		:Builds Ultimate Edition Operating Systems.
# author		:theemahn <theemahn@ultimateedition.info>
# date			:09/25/2015
# version		:1.9.5
# usage			:tmosb --help
# manual		:man tmosb
# notes			:See change-log below for further information.
# ==============================================================================
# Change-log:
#		1.8.8:	Initial public release
#
#		1.8.9:	Internal test release.
#
# 		1.9.0:	Public release, added aditional DE (Desktop Environments)
#			Added support for foreign Architectures PPC and ARM
#			Multitude of bug fixes
#
#		1.9.1	Bug fixes, added ability to set the default desktop
#			environment (DE).
#
#		1.9.2	Bug squashing release, introduced internal --BUILDALL -YES
# 			Will build all x86 and x64 based Operating systems back to back.
#
#			Initated the anti-malware initive, there will be no
#			spyware and will write code to not only remove malicous
#			software, but increase end user privacy.
#
#		1.9.3	No change
#
#		1.9.4	No change
#
#		1.9.5	Added new O/S's up to 4.9
# ==============================================================================
# Version Control

APPNAME="TheeMahn O/S Builder"
PROGNAME="tmosb"
VERSION="2.0.3"
BUILDDATE="10/31/2018"
WEBSITE="os-builder.com"
AUTHOR="TheeMahn"

import sys
from PyQt4 import QtGui, QtCore
import subprocess


try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    def _fromUtf8(s):
	return s

try:
    _encoding = QtGui.QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
	return QtGui.QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
	return QtGui.QApplication.translate(context, text, disambig)

class Ui_tmosb(object):
    def setupUi(self, tmosb):
	tmosb.setObjectName(_fromUtf8("tmosb"))
	tmosb.setWindowModality(QtCore.Qt.WindowModal)
	tmosb.setEnabled(True)
	tmosb.resize(400, 310)
	sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
	sizePolicy.setHorizontalStretch(0)
	sizePolicy.setVerticalStretch(0)
	sizePolicy.setHeightForWidth(tmosb.sizePolicy().hasHeightForWidth())
	tmosb.setSizePolicy(sizePolicy)
	icon = QtGui.QIcon()
	icon.addPixmap(QtGui.QPixmap(_fromUtf8("/usr/share/ultimate_edition/tmosb.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
	tmosb.setWindowIcon(icon)
	self.centralwidget = QtGui.QWidget(tmosb)
	self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
	self.groupBox = QtGui.QGroupBox(self.centralwidget)
	self.groupBox.setGeometry(QtCore.QRect(0, 60, 551, 271))
	self.groupBox.setCheckable(False)
	self.groupBox.setObjectName(_fromUtf8("groupBox"))
	self.MATE = QtGui.QCheckBox(self.groupBox)
	self.MATE.setGeometry(QtCore.QRect(30, 30, 82, 21))
	self.MATE.setChecked(True)
	self.MATE.setObjectName(_fromUtf8("MATE"))
	self.KDE = QtGui.QCheckBox(self.groupBox)
	self.KDE.setGeometry(QtCore.QRect(30, 60, 82, 21))
	self.KDE.setObjectName(_fromUtf8("KDE"))
	self.XFCE = QtGui.QCheckBox(self.groupBox)
	self.XFCE.setGeometry(QtCore.QRect(30, 90, 82, 21))
	self.XFCE.setObjectName(_fromUtf8("XFCE"))
	self.LXDE = QtGui.QCheckBox(self.groupBox)
	self.LXDE.setGeometry(QtCore.QRect(30, 120, 82, 21))
	self.LXDE.setObjectName(_fromUtf8("LXDE"))
	self.GNOME = QtGui.QCheckBox(self.groupBox)
	self.GNOME.setGeometry(QtCore.QRect(30, 150, 82, 21))
	self.GNOME.setObjectName(_fromUtf8("GNOME"))
	self.MATE_2 = QtGui.QCheckBox(self.groupBox)
	self.MATE_2.setGeometry(QtCore.QRect(240, 30, 91, 21))
	self.MATE_2.setChecked(False)
	self.MATE_2.setObjectName(_fromUtf8("MATE_2"))
	self.MATE_3 = QtGui.QCheckBox(self.groupBox)
	self.MATE_3.setGeometry(QtCore.QRect(240, 60, 82, 21))
	self.MATE_3.setChecked(False)
	self.MATE_3.setObjectName(_fromUtf8("MATE_3"))
	self.MATE_4 = QtGui.QCheckBox(self.groupBox)
	self.MATE_4.setGeometry(QtCore.QRect(240, 90, 106, 21))
	self.MATE_4.setChecked(False)
	self.MATE_4.setObjectName(_fromUtf8("MATE_4"))
	self.MATE_5 = QtGui.QCheckBox(self.groupBox)
	self.MATE_5.setGeometry(QtCore.QRect(240, 120, 82, 21))
	self.MATE_5.setChecked(False)
	self.MATE_5.setObjectName(_fromUtf8("MATE_5"))
	self.MATE_6 = QtGui.QCheckBox(self.groupBox)
	self.MATE_6.setGeometry(QtCore.QRect(240, 150, 91, 21))
	self.MATE_6.setChecked(False)
	self.MATE_6.setObjectName(_fromUtf8("MATE_6"))
	self.MATE_7 = QtGui.QCheckBox(self.groupBox)
	self.MATE_7.setGeometry(QtCore.QRect(30, 180, 182, 21))
	self.MATE_7.setChecked(False)
	self.MATE_7.setObjectName(_fromUtf8("MATE_7"))
    self.MATE_8 = QtGui.QCheckBox(self.groupBox)
    self.MATE_8.setGeometry(QtCore.QRect(240, 180, 191, 21))
	self.MATE_8.setChecked(False)
	self.MATE_8.setObjectName(_fromUtf8("MATE_8"))
	self.verticalLayoutWidget = QtGui.QWidget(self.centralwidget)
	self.verticalLayoutWidget.setGeometry(QtCore.QRect(0, 0, 400, 51))
	self.verticalLayoutWidget.setObjectName(_fromUtf8("verticalLayoutWidget"))
	self.verticalLayout = QtGui.QVBoxLayout(self.verticalLayoutWidget)
	self.verticalLayout.setMargin(0)
	self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
	self.lbl = QtGui.QLabel(self.verticalLayoutWidget)
	self.lbl.setObjectName(_fromUtf8("lbl"))
	self.verticalLayout.addWidget(self.lbl)
	self.combo = QtGui.QComboBox(self.verticalLayoutWidget)
	self.combo.setObjectName(_fromUtf8("combo"))
	self.verticalLayout.addWidget(self.combo)
        self.combo.addItem('ultimate-edition-3.6-x86-lite.iso')
        self.combo.addItem('ultimate-edition-3.6-x64-lite.iso')
        self.combo.addItem('ultimate-edition-3.6-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-3.6-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-3.6-x86-server.iso')
        self.combo.addItem('ultimate-edition-3.6-x64-server.iso')
        self.combo.addItem('ultimate-edition-3.6-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.6-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.6-x64.iso')
        self.combo.addItem('ultimate-edition-3.6-x86.iso')
        self.combo.addItem('ultimate-edition-3.6-armel.iso')
        self.combo.addItem('ultimate-edition-3.6-armhf.iso')
        self.combo.addItem('ultimate-edition-3.6-armel.img')
        self.combo.addItem('ultimate-edition-3.6-armhf.img')
        self.combo.addItem('ultimate-edition-3.6-powerpc.iso')
        self.combo.addItem('ultimate-edition-3.7-x86-lite.iso')
        self.combo.addItem('ultimate-edition-3.7-x64-lite.iso')
        self.combo.addItem('ultimate-edition-3.7-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-3.7-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-3.7-x86-server.iso')
        self.combo.addItem('ultimate-edition-3.7-x64-server.iso')
        self.combo.addItem('ultimate-edition-3.7-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.7-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.7-x64.iso')
        self.combo.addItem('ultimate-edition-3.7-x86.iso')
        self.combo.addItem('ultimate-edition-3.7-armel.iso')
        self.combo.addItem('ultimate-edition-3.7-armhf.iso')
        self.combo.addItem('ultimate-edition-3.7-armel.img')
        self.combo.addItem('ultimate-edition-3.7-armhf.img')
        self.combo.addItem('ultimate-edition-3.7-powerpc.iso')
        self.combo.addItem('ultimate-edition-3.8-x86-lite.iso')
        self.combo.addItem('ultimate-edition-3.8-x64-lite.iso')
        self.combo.addItem('ultimate-edition-3.8-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-3.8-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-3.8-x86-server.iso')
        self.combo.addItem('ultimate-edition-3.8-x64-server.iso')
        self.combo.addItem('ultimate-edition-3.8-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.8-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.8-x64.iso')
        self.combo.addItem('ultimate-edition-3.8-x86.iso')
        self.combo.addItem('ultimate-edition-3.8-armel.iso')
        self.combo.addItem('ultimate-edition-3.8-armhf.iso')
        self.combo.addItem('ultimate-edition-3.8-armel.img')
        self.combo.addItem('ultimate-edition-3.8-armhf.img')
        self.combo.addItem('ultimate-edition-3.8-powerpc.iso')
        self.combo.addItem('ultimate-edition-3.9-x86-lite.iso')
        self.combo.addItem('ultimate-edition-3.9-x64-lite.iso')
        self.combo.addItem('ultimate-edition-3.9-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-3.9-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-3.9-x86-server.iso')
        self.combo.addItem('ultimate-edition-3.9-x64-server.iso')
        self.combo.addItem('ultimate-edition-3.9-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.9-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-3.9-x64.iso')
        self.combo.addItem('ultimate-edition-3.9-x86.iso')
        self.combo.addItem('ultimate-edition-3.9-armel.iso')
        self.combo.addItem('ultimate-edition-3.9-armhf.iso')
        self.combo.addItem('ultimate-edition-3.9-armel.img')
        self.combo.addItem('ultimate-edition-3.9-armhf.img')
        self.combo.addItem('ultimate-edition-3.9-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.0-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.0-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.0-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.0-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.0-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.0-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.0-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.0-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.0-x64.iso')
        self.combo.addItem('ultimate-edition-4.0-x86.iso')
        self.combo.addItem('ultimate-edition-4.0-armel.iso')
        self.combo.addItem('ultimate-edition-4.0-armhf.iso')
        self.combo.addItem('ultimate-edition-4.0-armel.img')
        self.combo.addItem('ultimate-edition-4.0-armhf.img')
        self.combo.addItem('ultimate-edition-4.0-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.1-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.1-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.1-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.1-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.1-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.1-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.1-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.1-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.1-x64.iso')
        self.combo.addItem('ultimate-edition-4.1-x86.iso')
        self.combo.addItem('ultimate-edition-4.1-armel.iso')
        self.combo.addItem('ultimate-edition-4.1-armhf.iso')
        self.combo.addItem('ultimate-edition-4.1-armel.img')
        self.combo.addItem('ultimate-edition-4.1-armhf.img')
        self.combo.addItem('ultimate-edition-4.1-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.2-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.2-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.2-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.2-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.2-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.2-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.2-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.2-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.2-x64.iso')
        self.combo.addItem('ultimate-edition-4.2-x86.iso')
        self.combo.addItem('ultimate-edition-4.2-armel.iso')
        self.combo.addItem('ultimate-edition-4.2-armhf.iso')
        self.combo.addItem('ultimate-edition-4.2-armel.img')
        self.combo.addItem('ultimate-edition-4.2-armhf.img')
        self.combo.addItem('ultimate-edition-4.2-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.3-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.3-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.3-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.3-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.3-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.3-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.3-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.3-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.3-x64.iso')
        self.combo.addItem('ultimate-edition-4.3-x86.iso')
        self.combo.addItem('ultimate-edition-4.3-armel.iso')
        self.combo.addItem('ultimate-edition-4.3-armhf.iso')
        self.combo.addItem('ultimate-edition-4.3-armel.img')
        self.combo.addItem('ultimate-edition-4.3-armhf.img')
        self.combo.addItem('ultimate-edition-4.3-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.4-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.4-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.4-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.4-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.4-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.4-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.4-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.4-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.4-x64.iso')
        self.combo.addItem('ultimate-edition-4.4-x86.iso')
        self.combo.addItem('ultimate-edition-4.4-armel.iso')
        self.combo.addItem('ultimate-edition-4.4-armhf.iso')
        self.combo.addItem('ultimate-edition-4.4-armel.img')
        self.combo.addItem('ultimate-edition-4.4-armhf.img')
        self.combo.addItem('ultimate-edition-4.4-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.5-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.5-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.5-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.5-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.5-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.5-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.5-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.5-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.5-x64.iso')
        self.combo.addItem('ultimate-edition-4.5-x86.iso')
        self.combo.addItem('ultimate-edition-4.5-armel.iso')
        self.combo.addItem('ultimate-edition-4.5-armhf.iso')
        self.combo.addItem('ultimate-edition-4.5-armel.img')
        self.combo.addItem('ultimate-edition-4.5-armhf.img')
        self.combo.addItem('ultimate-edition-4.5-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.6-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.6-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.6-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.6-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.6-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.6-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.6-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.6-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.6-x64.iso')
        self.combo.addItem('ultimate-edition-4.6-x86.iso')
        self.combo.addItem('ultimate-edition-4.6-armel.iso')
        self.combo.addItem('ultimate-edition-4.6-armhf.iso')
        self.combo.addItem('ultimate-edition-4.6-armel.img')
        self.combo.addItem('ultimate-edition-4.6-armhf.img')
        self.combo.addItem('ultimate-edition-4.6-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.7-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.7-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.7-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.7-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.7-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.7-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.7-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.7-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.7-x64.iso')
        self.combo.addItem('ultimate-edition-4.7-x86.iso')
        self.combo.addItem('ultimate-edition-4.7-armel.iso')
        self.combo.addItem('ultimate-edition-4.7-armhf.iso')
        self.combo.addItem('ultimate-edition-4.7-armel.img')
        self.combo.addItem('ultimate-edition-4.7-armhf.img')
        self.combo.addItem('ultimate-edition-4.7-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.8-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.8-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.8-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.8-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.8-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.8-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.8-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.8-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.8-x64.iso')
        self.combo.addItem('ultimate-edition-4.8-x86.iso')
        self.combo.addItem('ultimate-edition-4.8-armel.iso')
        self.combo.addItem('ultimate-edition-4.8-armhf.iso')
        self.combo.addItem('ultimate-edition-4.8-armel.img')
        self.combo.addItem('ultimate-edition-4.8-armhf.img')
        self.combo.addItem('ultimate-edition-4.8-powerpc.iso')
        self.combo.addItem('ultimate-edition-4.9-x86-lite.iso')
        self.combo.addItem('ultimate-edition-4.9-x64-lite.iso')
        self.combo.addItem('ultimate-edition-4.9-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-4.9-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-4.9-x86-server.iso')
        self.combo.addItem('ultimate-edition-4.9-x64-server.iso')
        self.combo.addItem('ultimate-edition-4.9-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.9-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-4.9-x64.iso')
        self.combo.addItem('ultimate-edition-4.9-x86.iso')
        self.combo.addItem('ultimate-edition-4.9-armel.iso')
        self.combo.addItem('ultimate-edition-4.9-armhf.iso')
        self.combo.addItem('ultimate-edition-4.9-armel.img')
        self.combo.addItem('ultimate-edition-4.9-armhf.img')
        self.combo.addItem('ultimate-edition-4.9-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.0-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.0-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.0-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.0-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.0-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.0-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.0-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.0-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.0-x64.iso')
        self.combo.addItem('ultimate-edition-5.0-x86.iso')
        self.combo.addItem('ultimate-edition-5.0-armel.iso')
        self.combo.addItem('ultimate-edition-5.0-armhf.iso')
        self.combo.addItem('ultimate-edition-5.0-armel.img')
        self.combo.addItem('ultimate-edition-5.0-armhf.img')
        self.combo.addItem('ultimate-edition-5.0-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.1-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.1-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.1-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.1-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.1-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.1-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.1-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.1-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.1-x64.iso')
        self.combo.addItem('ultimate-edition-5.1-x86.iso')
        self.combo.addItem('ultimate-edition-5.1-armel.iso')
        self.combo.addItem('ultimate-edition-5.1-armhf.iso')
        self.combo.addItem('ultimate-edition-5.1-armel.img')
        self.combo.addItem('ultimate-edition-5.1-armhf.img')
        self.combo.addItem('ultimate-edition-5.1-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.2-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.2-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.2-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.2-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.2-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.2-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.2-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.2-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.2-x64.iso')
        self.combo.addItem('ultimate-edition-5.2-x86.iso')
        self.combo.addItem('ultimate-edition-5.2-armel.iso')
        self.combo.addItem('ultimate-edition-5.2-armhf.iso')
        self.combo.addItem('ultimate-edition-5.2-armel.img')
        self.combo.addItem('ultimate-edition-5.2-armhf.img')
        self.combo.addItem('ultimate-edition-5.2-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.3-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.3-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.3-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.3-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.3-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.3-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.3-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.3-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.3-x64.iso')
        self.combo.addItem('ultimate-edition-5.3-x86.iso')
        self.combo.addItem('ultimate-edition-5.3-armel.iso')
        self.combo.addItem('ultimate-edition-5.3-armhf.iso')
        self.combo.addItem('ultimate-edition-5.3-armel.img')
        self.combo.addItem('ultimate-edition-5.3-armhf.img')
        self.combo.addItem('ultimate-edition-5.3-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.4-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.4-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.4-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.4-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.4-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.4-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.4-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.4-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.4-x64.iso')
        self.combo.addItem('ultimate-edition-5.4-x86.iso')
        self.combo.addItem('ultimate-edition-5.4-armel.iso')
        self.combo.addItem('ultimate-edition-5.4-armhf.iso')
        self.combo.addItem('ultimate-edition-5.4-armel.img')
        self.combo.addItem('ultimate-edition-5.4-armhf.img')
        self.combo.addItem('ultimate-edition-5.4-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.5-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.5-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.5-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.5-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.5-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.5-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.5-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.5-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.5-x64.iso')
        self.combo.addItem('ultimate-edition-5.5-x86.iso')
        self.combo.addItem('ultimate-edition-5.5-armel.iso')
        self.combo.addItem('ultimate-edition-5.5-armhf.iso')
        self.combo.addItem('ultimate-edition-5.5-armel.img')
        self.combo.addItem('ultimate-edition-5.5-armhf.img')
        self.combo.addItem('ultimate-edition-5.5-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.6-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.6-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.6-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.6-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.6-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.6-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.6-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.6-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.6-x64.iso')
        self.combo.addItem('ultimate-edition-5.6-x86.iso')
        self.combo.addItem('ultimate-edition-5.6-armel.iso')
        self.combo.addItem('ultimate-edition-5.6-armhf.iso')
        self.combo.addItem('ultimate-edition-5.6-armel.img')
        self.combo.addItem('ultimate-edition-5.6-armhf.img')
        self.combo.addItem('ultimate-edition-5.6-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.7-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.7-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.7-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.7-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.7-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.7-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.7-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.7-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.7-x64.iso')
        self.combo.addItem('ultimate-edition-5.7-x86.iso')
        self.combo.addItem('ultimate-edition-5.7-armel.iso')
        self.combo.addItem('ultimate-edition-5.7-armhf.iso')
        self.combo.addItem('ultimate-edition-5.7-armel.img')
        self.combo.addItem('ultimate-edition-5.7-armhf.img')
        self.combo.addItem('ultimate-edition-5.7-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.8-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.8-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.8-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.8-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.8-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.8-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.8-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.8-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.8-x64.iso')
        self.combo.addItem('ultimate-edition-5.8-x86.iso')
        self.combo.addItem('ultimate-edition-5.8-armel.iso')
        self.combo.addItem('ultimate-edition-5.8-armhf.iso')
        self.combo.addItem('ultimate-edition-5.8-armel.img')
        self.combo.addItem('ultimate-edition-5.8-armhf.img')
        self.combo.addItem('ultimate-edition-5.8-powerpc.iso')
        self.combo.addItem('ultimate-edition-5.9-x86-lite.iso')
        self.combo.addItem('ultimate-edition-5.9-x64-lite.iso')
        self.combo.addItem('ultimate-edition-5.9-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-5.9-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-5.9-x86-server.iso')
        self.combo.addItem('ultimate-edition-5.9-x64-server.iso')
        self.combo.addItem('ultimate-edition-5.9-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.9-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-5.9-x64.iso')
        self.combo.addItem('ultimate-edition-5.9-x86.iso')
        self.combo.addItem('ultimate-edition-5.9-armel.iso')
        self.combo.addItem('ultimate-edition-5.9-armhf.iso')
        self.combo.addItem('ultimate-edition-5.9-armel.img')
        self.combo.addItem('ultimate-edition-5.9-armhf.img')
        self.combo.addItem('ultimate-edition-5.9-powerpc.iso')
        self.combo.addItem('ultimate-edition-6.0-x86-lite.iso')
        self.combo.addItem('ultimate-edition-6.0-x64-lite.iso')
        self.combo.addItem('ultimate-edition-6.0-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-6.0-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-6.0-x86-server.iso')
        self.combo.addItem('ultimate-edition-6.0-x64-server.iso')
        self.combo.addItem('ultimate-edition-6.0-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-6.0-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-6.0-x64.iso')
        self.combo.addItem('ultimate-edition-6.0-x86.iso')
        self.combo.addItem('ultimate-edition-6.0-armel.iso')
        self.combo.addItem('ultimate-edition-6.0-armhf.iso')
        self.combo.addItem('ultimate-edition-6.0-armel.img')
        self.combo.addItem('ultimate-edition-6.0-armhf.img')
        self.combo.addItem('ultimate-edition-6.0-powerpc.iso')
        self.combo.addItem('ultimate-edition-6.1-x86-lite.iso')
        self.combo.addItem('ultimate-edition-6.1-x64-lite.iso')
        self.combo.addItem('ultimate-edition-6.1-x86-gamers.iso')
        self.combo.addItem('ultimate-edition-6.1-x64-gamers.iso')
        self.combo.addItem('ultimate-edition-6.1-x86-server.iso')
        self.combo.addItem('ultimate-edition-6.1-x64-server.iso')
        self.combo.addItem('ultimate-edition-6.1-x86-minimal-server.iso')
        self.combo.addItem('ultimate-edition-6.1-x64-minimal-server.iso')
        self.combo.addItem('ultimate-edition-6.1-x64.iso')
        self.combo.addItem('ultimate-edition-6.1-x86.iso')
        self.combo.addItem('ultimate-edition-6.1-armel.iso')
        self.combo.addItem('ultimate-edition-6.1-armhf.iso')
        self.combo.addItem('ultimate-edition-6.1-armel.img')
        self.combo.addItem('ultimate-edition-6.1-armhf.img')
        self.combo.addItem('ultimate-edition-6.1-powerpc.iso')
	# self.connect(self.combo, QtCore.SIGNAL('activated(QString)'), self.combo_chosen)
	self.build = QtGui.QPushButton(self.centralwidget)
	self.build.setGeometry(QtCore.QRect(210, 265, 90, 23))
	self.build.setCheckable(False)
	self.build.setChecked(False)
	self.build.setAutoDefault(False)
	self.build.setDefault(False)
	self.build.setFlat(False)
	self.build.setObjectName(_fromUtf8("build"))
	self.ExitButton = QtGui.QPushButton(self.centralwidget)
	self.ExitButton.setGeometry(QtCore.QRect(300, 265, 90, 23))
	icon = QtGui.QIcon.fromTheme(_fromUtf8("exit"))
	self.ExitButton.setIcon(icon)
	self.ExitButton.setObjectName(_fromUtf8("ExitButton"))

	self.lineEdit = QtGui.QLineEdit(self.centralwidget)
	self.lineEdit.setGeometry(QtCore.QRect(0, 255, 181, 22))
	self.lineEdit.setObjectName(_fromUtf8("lineEdit"))
	self.label = QtGui.QLabel(self.centralwidget)
	self.label.setGeometry(QtCore.QRect(0, 240, 52, 14))
	self.label.setObjectName(_fromUtf8("label"))
	tmosb.setCentralWidget(self.centralwidget)
	self.statusbar = QtGui.QStatusBar(tmosb)
	self.statusbar.setObjectName(_fromUtf8("statusbar"))
	tmosb.setStatusBar(self.statusbar)

	self.retranslateUi(tmosb)
#	self.ui.QtCore.QObject.connect(self.ExitButton, QtCore.SIGNAL(_fromUtf8("clicked()")), tmosb.close)
	QtCore.QMetaObject.connectSlotsByName(tmosb)

    def retranslateUi(self, tmosb):
	tmosb.setWindowTitle(_translate("tmosb", "TheeMahn\'s O/S Builder", None))
	self.groupBox.setTitle(_translate("tmosb", "Optional Desktop Environments", None))
	self.MATE.setText(_translate("tmosb", "MATE", None))
	self.KDE.setText(_translate("tmosb", "KDE", None))
	self.XFCE.setText(_translate("tmosb", "XFCE", None))
	self.LXDE.setText(_translate("tmosb", "LXDE", None))
	self.GNOME.setText(_translate("tmosb", "GNOME", None))
	self.MATE_2.setText(_translate("tmosb", "RAZORQT", None))
	self.MATE_3.setText(_translate("tmosb", "UNITY", None))
	self.MATE_4.setText(_translate("tmosb", "CINNAMON", None))
	self.MATE_5.setText(_translate("tmosb", "TOUCH", None))
	self.MATE_6.setText(_translate("tmosb", "AWESOME", None))
	self.MATE_7.setText(_translate("tmosb", "PANTHEON", None))
    	self.MATE_8.setText(_translate("tmosb", "BUDGIE", None))
	self.lbl.setText(_translate("tmosb", "Operating System to Build:", None))
	self.build.setText(_translate("tmosb", "Build", None))
	self.ExitButton.setText(_translate("tmosb", "E&xit", None))
	self.lineEdit.setText(_translate("tmosb", "MATE", None))
	self.lbl.setText(_translate("tmosb", "tmosb --build ultimate-edition-2.6-x86-lite.iso", None))
	self.lbl.setVisible(False)
	self.lineEdit.setVisible(False)

    def combo_chosen(self, text):
	"""
	Handler called when a distro is chosen from the combo box
	"""
	self.lbl.setText(text)
	 #self.lbl.setText(text)

    def BUILD(self, button):
	words=self.lblb.text()
	#IsChecked=self.MATE.checkState()
	print words


	#ex = " ".join(self.lblb.text)
	print('"%s" was clicked' % self.lbl.text())
	"""
	Handler called when a distro is chosen from the combo box
	"""
	#subprocess.call(['open', '-W', '-a', 'Terminal.app', 'tmosb', '--args'])

	#subprocess.call(['open', '-W', '-a', 'Terminal.app', self.lbl.text, self.lblb.text])


if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    tmosb = QtGui.QMainWindow()
    ui = Ui_tmosb()
    ui.setupUi(tmosb)
    tmosb.show()
    sys.exit(app.exec_())

