#!/usr/bin/env bash
# This script was auto generated using the code-cleanup package http://forumubuntusoftware.info/viewtopic.php?f=23&t=9480
# ==============================================================================
# title			:conky-builder
# description	:Builds a Conky skeleton based on hardware detected.
# author		:theemahn <theemahn@ultimateedition.info>
# date			:3/06/2018
# version		:1.30
# usage			:conky-builder --help
# manual		:man conky-builder
# notes			:See change-log below for further information.
# ==============================================================================
# Change-log:

# 1.0	initial public release

# 1.1	internal release

# 1.2	internal release

# 1.3	internal release

# 1.4	Added distribution detection, added resolution detection
#	to set fonts and sizes.

# 1.05	Added version compliance for deb based releases
#	Added better networking detection / wireless support.
#	Added memory output to compare against pae based kernels.
#	Added 800 X 600 support, how did I miss this resolution?
#	Added initial support for Ultimate Player (dynamically)
#	Added support for all network interface detection / Active.
#	Never have I seen this implementation.  I try to think outside of
#	the box please report issues.
#	Added support for Ultimate Edition 2.6.4 and 3.1 detection
#	Added dynamic Wireless support.
#	Added CPU Temp / Fan speeds also dynamic.

# 1.06	Added Radio tray to the mix
#	Initiated the anti-cron job mode of thinking, execi can be executed
#	w/o the need for a cron job.  Let's base this on the end users CPU.
#	Added no Internet means do not propagate - includes wireless.
#	The same across the board when I am done and hopefully will not
#	require a cron job.64bit

# 1.07	Initiated real-time information, across issues I have set forth.
#	Set CPU Temp to display info real-time based on end users processor. A
#	single core CPU will not be updated as fast as a quad for example
#	please see timeslices in my code.
#	Set fan speed accordingly as above.

# 1.08	Split the Conky builder for Ultimate Player info
#	May integrate the info as a function later.
#	Added progress bar for current playing track.
#	All info for Ultimate Player is now real-time.

# 1.09	First initial deb based release

# 1.10	Internal release for Ultimate Edition 3.01
#	Fixed improper spacing when closing Ultimate Player.

# 1.11	Fixed improper CPU detection on some Intel based processors.
#	Began writing weather location / detection via users IP address.
#	the above will be a fairly difficult procedure. Query to a API driven
#	Geo-positioning map to obtain location based on zip code, once obtained
#	a query to another API   driven site noaa.gov.  Will require no user
#	interaction.

# 1.12	Added support for 12.04 precise (Ultimate Edition 3.4 & 3.5) based releases.

# 1.13	Corrected colors to be only 1 color for now, easier reading on most wallpapers.
#	Will eventually write it to detect theme and set colors appropriately.

# 1.14	Added GPU and Main-board temp detection routines.
#	Added initial dual monitor detection / setup routine.
#	Added ppp0 network detection to the mix, thanks Seedo Eldho Paul
#	Added Hard-disk temperature detection, this was a rough one to sift
#	though and match with the drives.

# 1.15	Internal release to Ultimate Edition 3.5
#	Fixed Garbling of GPU / CPU Temp
#	Adjusted Colors to coincide with Ultimate Edition 3.5 Theme
#	Removed Lua usage. Thanks Mr. Breeg and Goliath for testing

# 1.16	Set colors in CLI so errors etc. Stand out.
#	Added additional distribution detection routines (debugging currently)
#	No sense in having to re-write conky builder every-time I build a new OS.
#	Display album art if Ultimate Player is Jamming.
#	Major code clean up, I am a slob ;)
#	Updated distribution logo
#	Mass updates to resolution detection routine. Simple once again becomes
#	complex thanks to addition of the artwork from Ultimate Player.

# 1.17	Adjusted output of information to comply with screen width.
#	Detection of USB drives - no output of temperature.
#	Detection of NAS drives - no output of temperature.
#	Added 1280 X 800 resolution; thanks, tanmay.01
#	Adjusted Temp detection routines let's not waste space.
#	Dual monitors now displayed @0 pixels from the top.
#	Took debugging into my own hands on temps.
#	Smartly built displaying of temp info into columns.
#	If no Swap. No Swap info reported in Conky. Save precious screen resources.
#	Reduced top processes to 3.
#	Adjusted diskio activity and network activity bars to coincide in length.

# 1.18	Added NFS based Network Attached Storage detection.

# 1.19	Ran code-clean and bashdepends on this script, dependencies adjusted.

# 1.20	Added Video card detection
#	Changed colors to coincide with colors of Ultimate Edition 3.4 series
#	Added Raid array detection

# 1.21	Point to point protocol issue gone?  Thanks again Seedo
# 	Implemented enhanced color / bar graphs.
#	Added 1366 X 768 resolution, thanks again Seedo

# 1.22	Check for install of hddtemp. Set as recommended in deb not required
#	Fixed errors spitting out when checking temp of USB / NAS drives.
#	Adjusted colors for Ultimate Edition 4.0
#	Adjusted mountpoints to strip username if applicable (12.10+ changed this)
#	Added check for SUID for hddtemp
#	Added Hard drive size detection & total filesystem capacity output info
#	Added Detecttion of root filesystem

# 1.23	Added support for 1920X2280 Dual monitor vertical orientation.
#	Ran code through bash script maker. Now has help and version system.

# 1.24	Added support for 1920X2400 Dual monitor vertical orientation.
#	Added better WiFi support (multiple adapters simotaneously supported).
#	Added full Ultimate Player detection.
# 	Ran software through code-cleanup package.
#	Added eyecandy functions.
#	Adjusted dependancies conky-all | conky-std, lm-sensors now recomended
#
# 1.25	Added initial support for 4K monitors.
#
# 1.26	Added support for Pithos (Pandora Client)
#		Added support for Clementine Media Player
#		Set recomends in control to recomend media | players
#		Cleaned up code.
#
# 1.27	Initiated NFS / Samba mounted hardware detection
#
# 1.28	Set compatability with KDE 5 (Ultimate Edition 5.7)
#
# 1.29  Added better detection of NAS (Network Attached Storage)
#
# 1.30  Added better detection of hard mounted USB devices.
#	   Better detection of CPU Resonation on Multi-core CPUS.
#	   Updated Media player detection.
#	   Added GPU Temp detection / population
#	   Added CPU Temp detection / population
#
# 1.31	Added support for Dual 4K monitors.
#		Added dependancy on glxinfo.
#
# 1.32	Adjusted Network Detection / reporting.
#		Cleaned up the CLI (Columize)
#
# =============== End Change-log ===================== #
# set -x <<- Enable for Debugging purposes

# Modify the below information to correlate with the software you are designing.
PROGNAME="conky-builder"
PROGRAMMER="theemahn"
BUILDDATE="05/02/2024"
VERSION="1.38"
WEBSITE="os-builder.com"
AUTHOR="TheeMahn"
EMAIL="<$AUTHOR@$WEBSITE>"
APPNAME="Conky Builder"

source /usr/share/ultimate_edition/ultimate-common

# Monitor Data
shopt -u nullglob
declare -a MONITORS=();
declare -i NMONITORS;
WASIFS="$IFS"
IFS=$'\n'
MONITOR=$(type -p xrandr)
if [[ "${MONITOR}" ]]; then
	MONITORS=$(xrandr -q | grep " connected" | cut -d "(" -f1 | cut -d "+" -f1)
	NMONITORS=$(echo "${MONITORS[@]}" | wc -l)
	MONITORS=($MONITORS)
fi
IFS="${WASIFS}"

# Begin programming here.
#set Base, hi-light color & header please adjust colors in hex and font to your liking
#http://simple.wikipedia.org/wiki/List_of_colors
BASE='${color #ffffff}${font Liberation:style=normal:pixelsize='${FONTSIZE}'}' #Atomic Tangerine
HILIGHT='${color #ffff00}${font Liberation:style=normal:pixelsize='${FONTSIZE}'}' #Yellow
HEADER='${color #00ffff}${font Liberation:style=Bold:pixelsize='${FONTSIZE}'}' #Cyan
BAR='${color #ffd700}' #Gold

############### You Should not have to edit anything below #############

if [[ -f /usr/bin/ultimate-player ]]; then
	ULTIMATEPLAYER='/usr/bin/ultimate-player'
fi
UPSCRIPT='~.config/Ultimate-Player/UP.sh'

# Dual monitors?
declare -i Dual

# Set hard-coded variables
ISHDDTEMP=$(type -p hddtemp)
ISHDDEXEC="NO"
SENSORS=$(type -p sensors)

Main() {
	VersionDump
	# Set default Operating System in case of failure
	OS='Ultimate Edition'

	# See if user has hddtemp installed, and more importantly has proper permissions
	# to execute it via user non-root (SUID).  If not inform the user how to fix it.
	# This stops: /dev/sda3: open: Permission denied errors.
	if [[ "${ISHDDTEMP}" ]]; then
		SSTATS=$(stat -c %A ${ISHDDTEMP} | sed 's/...\(.\).\+/\1/')
		if [[ "$SSTATS" == "s" ]]; then
			Encapsulate "Congradulations, hddtemp is properly configured. Temperature information will be populated"
			ISHDDEXEC="YES"
		fi
	else
		if ! [[ "${ISARCH}" ]]; then
			Encapsulate "${WARN}Warning: hddtemp is not installed, sudo apt-get install hddtemp"
		else
			Encapsulate "${WARN}Warning: hddtemp is not installed, sudo pacman -Syuu hddtemp"
		fi
	fi
	if ! [[ "${ISARCH}" ]]; then
		if [[ "${ISHDDEXEC}" == "NO" && "${ISHDDTEMP}" ]]; then
			Error "Error: SUID for hddtemp is not set, sudo dpkg-reconfigure hddtemp"
		fi
	fi
	Center "Operating system information"

	#Detect code-base / Distribution
	OS=$(lsb_release -i | sed -n 's/^Distributor ID:[ \t]*\(.*\)/\1/p')
	DISTREL=$(lsb_release -r | sed -n 's/^Release:[ \t]*\(.*\)/\1/p')
	DISTDESC=$(lsb_release -d | sed -n 's/^Description:[ \t]*\(.*\)/\1/p')
	CODEBASE=$(cat /etc/lsb-release | grep -i 'DISTRIB_CODENAME=' | sed "s/DISTRIB_CODENAME=//g")
	if [[ "${CODEBASE}" ]]; then
		Encapsulate "Codebase detected: ${CODEBASE}"
	fi
	if [[ "${DISTDESC}" ]]; then
		Encapsulate "Dist Description: ${DISTDESC}"
	fi
	# detect if release is odd or even.
	if ! [[ "${ISARCH}" ]]; then
		EVENODD=$(dpkg -l | grep -i "kubuntu-desktop")
		if [[ "${EVENODD}" != "" ]]; then
			Encapsulate "Kubuntu base: detected - odd number release"
		else
			Encapsulate "Kubuntu base not detected - even number release"
		fi
	fi

	
	#TESTING ABOVE
	DISTRO="${OS} ${DISTREL}"
	OS="${DISTRO}"
	if [[ "${DISTRO}" ]]; then
		Encapsulate "Distro detected: ${DISTRO}"
	fi

	# Attempt to advance the script.  No sense having the user edit this script
	# if we can obtain the information without user intervention.
	Center "Hardware Information"
	DISP=$(printf '[%s]\n' "${DISPLAY}" "${XAUTHORITY}" | grep ":0")
	if [[ "${MONITORS}" ]]; then
		res=$(xrandr -q | grep 'current' | cut -d"," -f2 | sed 's/current//g' | sed 's/ //g')
	else
		Error "This is most likely a server.  Display information will not be gathered."
		SERVER=1
	fi

	# set defaults in case user has an unknown resolution. Better too small then too
	# large
	GRAPHWIDTH=320 #size of box in pixels
	FONTSIZE=8 #default font size
	SZE=64
	DUAL=0
	AHW=52
	AARTY=44
	GRAPHWIDTH=260
	FONTSIZE=7
	if [[ "${MONITORS}" ]]; then
		Encapsulate "Monitors detected ${NMONITORS}:"
		for EACH in "${MONITORS[@]}"
		do
			Encapsulate "${EACH}"
		done
		Encapsulate "Detected current resolution: ${res}"
	fi

	case "${res}" in
		11400x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Tripple 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		7620x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		7560x2160)
		DUAL=1
		AHW=160
		AARTY=220
		GRAPHWIDTH=1024
		FONTSIZE=24
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		6660x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		6340x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5828x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5700x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=16
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5636x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=28
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5120x1440)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=1024
		FONTSIZE=14
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3840x1440)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=600
		FONTSIZE=18
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5120x1600)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=600
		FONTSIZE=18
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		5760x1620)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=600
		FONTSIZE=18
		Encapsulate "Dual 4K monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3780x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=840
		FONTSIZE=24
		Encapsulate "4K monitor detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3840x2160)
		DUAL=1
		AHW=110
		AARTY=180
		GRAPHWIDTH=840
		FONTSIZE=24
		Encapsulate "4K monitor detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3840x1200)
		# Tested known good
		DUAL=1
		AHW=76
		AARTY=76
		GRAPHWIDTH=440
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking full advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3840x1080)
		# Tested known good
		DUAL=1
		AHW=88
		AARTY=98
		GRAPHWIDTH=640
		FONTSIZE=14
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3839x1080)
		# Tested known good
		DUAL=1
		AHW=88
		AARTY=98
		GRAPHWIDTH=640
		FONTSIZE=16
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3200x1800)
		DUAL=1
		AHW=88
		AARTY=98
		GRAPHWIDTH=640
		FONTSIZE=16
		Encapsulate "HiFi monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3200x1200)
		DUAL=0
		AHW=88
		AARTY=98
		GRAPHWIDTH=640
		FONTSIZE=16
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3200x1024)
		# Tested known good
		DUAL=1
		AHW=90
		AARTY=80
		GRAPHWIDTH=520
		FONTSIZE=14
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3360x900)
		# Tested known good
		DUAL=1
		AHW=78
		AARTY=74
		GRAPHWIDTH=480
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		3200x960)
		# Tested known good
		DUAL=1
		AHW=78
		AARTY=74
		GRAPHWIDTH=480
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		2560x1440)
		DUAL=1
		AHW=78
		AARTY=74
		GRAPHWIDTH=480
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1920x2400)
		DUAL=1
		AHW=78
		AARTY=74
		GRAPHWIDTH=480
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1920x2280)
		DUAL=1
		AHW=78
		AARTY=74
		GRAPHWIDTH=480
		FONTSIZE=12
		Encapsulate "Dual monitors detected. Taking advantage of extra screen resources."
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1920x1200)
		# Tested; known Good.
		AHW=84
		AARTY=84
		GRAPHWIDTH=600
		FONTSIZE=14
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1920x1080)
		# Tested; known Good.
		AHW=69
		AARTY=90
		GRAPHWIDTH=600
		FONTSIZE=12
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1600x1200)
		# Tested; known Good.
		AHW=84
		AARTY=84
		GRAPHWIDTH=550
		FONTSIZE=14
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1680x1050)
		# Tested; known Good.
		AHW=84
		AARTY=84
		GRAPHWIDTH=550
		FONTSIZE=14
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1680x945)
		# Tested; known Good.
		AHW=84
		AARTY=84
		GRAPHWIDTH=550
		FONTSIZE=14
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1440x900)
		# Tested known good
		AHW=66
		AARTY=75
		GRAPHWIDTH=420
		FONTSIZE=12
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1400x1050)
		# unknown
		AHW=75
		AARTY=70
		GRAPHWIDTH=420
		FONTSIZE=11
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1366x768)
		# Tested known good
		AHW=75
		AARTY=70
		GRAPHWIDTH=420
		FONTSIZE=11
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1280x1024)
		# Tested known good
		AHW=75
		AARTY=71
		GRAPHWIDTH=400
		FONTSIZE=11
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1280x960)
		# Tested known good
		AHW=75
		AARTY=71
		GRAPHWIDTH=400
		FONTSIZE=11
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1280x720)
		# Tested known good
		AHW=64
		AARTY=56
		GRAPHWIDTH=340
		FONTSIZE=9
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1152x864)
		# Tested known good
		AHW=64
		AARTY=56
		GRAPHWIDTH=340
		FONTSIZE=9
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		1024x768)
		# Tested known good
		AHW=64
		AARTY=56
		GRAPHWIDTH=340
		FONTSIZE=9
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		800x600)
		# Tested known good
		AHW=52
		AARTY=44
		GRAPHWIDTH=260
		FONTSIZE=7
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		832x624)
		# Tested known good
		AHW=52
		AARTY=48
		GRAPHWIDTH=300
		FONTSIZE=8
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		720x400)
		GRAPHWIDTH=180
		FONTSIZE=6
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		640x480)
		GRAPHWIDTH=180
		FONTSIZE=6
		Encapsulate "Setting font size to ${FONTSIZE} and graph width to ${GRAPHWIDTH}" ;;
		*)
	esac

	#set Base, hi-light color & header please adjust colors in hex and font to your liking
	#http://simple.wikipedia.org/wiki/List_of_colors
	BASE='${color #ffffff}${font Liberation:style=normal:pixelsize='${FONTSIZE}'}' #Atomic Tangerine
	HILIGHT='${color #ffff00}${font Liberation:style=normal:pixelsize='${FONTSIZE}'}' #Yellow
	HEADER='${color #00ffff}${font Liberation:style=Bold:pixelsize='${FONTSIZE}'}' #Cyan
	BAR='${color #ffd700}' #Gold

	############### You Should not have to edit anything below #############

	#Calculate v offset based on Fonts / pixelsize
	VOFF=$((FONTSIZE+6))
	ALEFT=$((FONTSIZE/4))
	INDENT=$((FONTSIZE/2))
	BARZ=$((GRAPHWIDTH/2))
	BOFFSET=$((FONTSIZE/3))
	TICON=$((FONTSIZE/5))
	BPER=$((GRAPHWIDTH/100*75))
	SBAR=$((GRAPHWIDTH/100*20))
	LOGO=$((FONTSIZE*2))
	SZE=$((LOGO*2))
	LOGO=$((LOGO - 5))
	BPER=$((BPER - 10))
	AARTX=$((GRAPHWIDTH - ${AHW}))
	#Encapsulate "Logo Size: ${SZE}"

	#Get CPU model / info
	BOGOMIPS=$(lscpu | grep -i 'bogomips' | cut -d ":" -f2 | cut -d "=" -f1 | sed "s/ //g")
	RESONATION=$(lscpu | grep -i 'cpu max Mhz' | cut -d ":" -f2 | sed "s/ //g" | cut -d "." -f1)
	if [[ "${UID}" == "0" ]]; then
		CPUMAX=$(dmidecode -t 4 | grep -i "Max Speed:" | cut -d":" -f2)
	fi
	if ! [[ "${RESONATION}" ]]; then
		RESONATION=$(lscpu | grep -i 'CPU MHz' | cut -d ":" -f2 | sed "s/ //g")
	fi
	PROC=$(cat /proc/cpuinfo | grep -m1 'model name' | sed -e 's/.*: //' | uniq)
	if [[ "${CPUMAX}" ]]; then
		Encapsulate "Processor: ${PROC} resonating at ${RESONATION} Mhz /${CPUMAX} (Base/Max) (BogoMips: ${BOGOMIPS})"
	else
		if [[ "${BOGOMIPS}" ]]; then
			Encapsulate "Processor: ${PROC} resonating at ${RESONATION} Mhz (BogoMips: ${BOGOMIPS})"
		else
			Encapsulate "Processor: ${PROC} resonating at ${RESONATION} Mhz"
		fi
	fi

	#GPU(S) active only
	INSTALLED=$(type -p glxinfo)
	if [[ "${INSTALLED}" ]]; then
		GPU=$(glxinfo | grep -E "OpenGL renderer string" | head -1 | cut -d ":" -f2 | cut -d "(" -f1)
	fi
	#check Architecture set 32 bit default
	ARCHITECTURE="32 Bit"

	# Kernel
	KERNEL=$(uname -a | cut -d " " -f3)
	
	#
	# Check for x86_64 (Test 1) - some O/S's use the -i switch
	#
	CARCH=$(uname -i | grep -i "x86_64")
	if [ "${CARCH}" == "x86_64" ]; then
		ARCHITECTURE="64 Bit"
	fi

	#
	# Check for x86_64 (Test 2) - some OSs (ie. Gentoo) return Processor manufacturer
	#rather than architecture with "uname -i"
	#
	if [ "`uname -a|grep x86_64`" != "" ]; then
		ARCHITECTURE="64 Bit"
	fi

	# Report to user
	if [[ "${ARCHITECTURE}" ]]; then
		Encapsulate "${ARCHITECTURE} O/S detected."
	fi
	if [[ "${KERNEL}" ]]; then
		Encapsulate "Kernel: ${KERNEL}"
	fi
	# Count number of processor cores
	CORES=1 #Set default
	CORES=$(cat /proc/cpuinfo | grep "processor" | sed '/model/d' | wc -l)

	# Lets's not choke the end users CPU if they have limited resources.
	TIMESLICES=$(( 12 / ${CORES}))

	# Report findings
	Encapsulate "${CORES} CPU core(s) Detected."
	TCORES="${CORES}"
	if [[ "${CORES}" -gt 16 ]]; then
		Encapsulate "Greater then 16 core / threads detected, setting 4 cores wide to save room on the screen."
	fi
	Encapsulate "Update interval set: ${TIMESLICES} seconds"
	declare -i MEMTOTAL
	declare -i SWAPTOTAL
	if [[ "${GPU}" ]] then
		Encapsulate "Active GPU detected as ${GPU}"
	fi
	MEMTOTAL=$(cat /proc/meminfo | grep -i "MemTotal" | cut -d":" -f2 | cut -d "k" -f1)
	GIGS=$(free -m -h | grep -i "mem:" | awk '{print $2}')
	SWAPTOTAL=$(cat /proc/meminfo | grep -i "SwapTotal" | sed "s/ //g" | cut -d ':' -f2 | cut -d "k" -f1)
	SWAPGIG=$(free -m -h | grep -i "swap" | awk '{print $2}')

	#Convert to comma seperated values...Memory
	if [[ "${MEMTOTAL}" && "${GIGS}" ]]; then
		MEMSIZE=$(printf "%'.3f\n" "${MEMTOTAL}")
		MEMORY=$(echo "${MEMSIZE}" | cut -d. -f1)
		Encapsulate "Memory: ${MEMORY},000 bytes (${GIGS})"
	else
		Error "Cannot retrieve memory information..."
	fi

	#Convert to comma seperated values...Swap space
	if [[ "${SWAPTOTAL}" && "${SWAPGIG}" ]]; then
		MEMSIZE=$(printf "%'.3f\n" "${SWAPTOTAL}")
		SWAPMEMORY=$(echo "${MEMSIZE}" | cut -d. -f1)
		Encapsulate "Swap Space: ${SWAPMEMORY},000 bytes (${SWAPGIG})"
	else
		Error "No Swap? Cannot retrieve Swap information, conky will not be populated."
	fi
	Center "Network info"
	NetInfo "$@"
	#Detect "Active" network and propigate Network Xfer bar
	#ACTIVE=`ifconfig | grep -B 1 inet | head -1 | awk '{print $1}'`
	#Wireless?
	#wlan=$(cat /sys/class/net/wlan0/operstate)
	#enet=$(cat /sys/class/net/eth0/operstate)

	#Hardline?
	#if [[ $enet == 'up' ]]; then
	#${ACTIVE}='eth0'
	#fi

	#Wireless
	#if [[ $wlan == 'up' ]]; then
	#ACTIVE='wlan0'
	#fi

	#Dual monitors?
	if [[ "${DUAL}" == 0 ]]; then
		GAPX=15
		GAPY=30
	else
		GAPX=15
		GAPY=0
	fi

	#Create conky skelaton
echo '#Use XFT?
use_xft yes
xftfont Liberation:style=normal:pixelsize='${FONTSIZE}'
xftalpha 0.8
text_buffer_size 2048

# Update interval in seconds
update_interval 1

# This is the number of times Conky will update before quitting.
# Set to zero to run forever.
total_run_times 0

# Create own window instead of using desktop (required in nautilus)
own_window yes
own_window_transparent yes
own_window_type normal
own_window_class conky-semi
own_window_class normal
own_window yes
own_window_type normal
own_window_transparent yes
own_window_hints undecorated,below,skip_taskbar,skip_pager
own_window_argb_visual yes
own_window_argb_value 100

#own_window_hints undecorated,below,sticky,skip_taskbar,skip_pager

# Use double buffering (reduces flicker, may not work for everyone)
double_buffer yes

# Minimum size of text area -adjust if you would like to user smaller fonts etc.
minimum_size '${GRAPHWIDTH}' 0
maximum_width '${GRAPHWIDTH}'
max_user_text 16384
default_bar_size '${BPER}' 5

# Draw shades?
draw_shades no
default_color 0a3f6d #ffffff

# Draw outlines?
draw_outline no
# Draw borders around text
draw_borders no

# Stippled borders?
stippled_borders 0

# border width
border_width 1

# Text alignment, other possible values are commented
#alignment top_left
alignment top_right
#alignment bottom_left
#alignment bottom_right

# Gap between borders of screen and text
# same thing as passing -x at command line
gap_x '${GAPX}'
gap_y '${GAPY}'

#Default weather to fahrenheit, please change the below if you prefer celcius.
temperature_unit fahrenheit

# -- Lua Load -- # - removed in conky builder > 1.15
#lua_load ~/.draw_bg.lua
#lua_draw_hook_pre draw_bg

# -- Album art fix -- #
imlib_cache_size 0
' > ~/.conkyrc

	echo 'TEXT' >> ~/.conkyrc

	# Begin system info output
	echo '${image /usr/share/ultimate_edition/logo.png -p '${BARZ}','${LOGO}' -s '${SZE}'x'${SZE}'}'${HEADER}'SYSTEM ${hr 2 }'${BASE} >> ~/.conkyrc
	echo '${alignr}'${DISTDESC}' - ${alignr}$kernel '${ARCHITECTURE} >> ~/.conkyrc
	echo '${alignr}'$USER'@$nodename' >> ~/.conkyrc
	echo -n '${goto '${INDENT}'}${voffset '${TICON}'}${font StyleBats:pixelsize='${FONTSIZE}'}k${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}Processes: ${PROCESSES}' >> ~/.conkyrc
	echo '${alignr}${voffset '${TICON}'}${font StyleBats:pixelsize='${FONTSIZE}'}q${font}Uptime: ${uptime}' >> ~/.conkyrc

	# Hit sensors to see if temperature(s) are detected / reported.
	Encapsulate "SCANNING MOTHERBOARD FOR TEMP SENSOR(S)..."
	if [[ "${SENSORS}" ]]; then
		CPUTEMP=$(sensors -f | grep -i "temp1" | cut -d ":" -f2 | cut -d "+" -f2 | cut -d"(" -f1 | head -1 2> /dev/null)
		GPUTEMP=$(sensors -f | grep -i "edge" | cut -d ":" -f2 | cut -d "+" -f2 | cut -d"(" -f1 | head -1 2> /dev/null)
		MEMTEMP=$(sensors -f | grep -i "mem:" | cut -d ":" -f2 | cut -d "+" -f2 | cut -d"(" -f1 | head -1 2> /dev/null)
		if [[ "${DISP}" ]]; then
			VIDCARD=$(glxinfo | grep -m 1 'renderer string' | sed 's/OpenGL renderer string: //g' | awk '{print $1, $2, $3, $4, $5, $6}' 2> /dev/null)
		fi
		MBTEMP=$(sensors -f | grep -m 1 "MB Temp" | cut -d: -f2| sed "s/ //g" | sed "s/+//g" | cut -d"(" -f1 2> /dev/null)
		FANSPEED=$(sensors -f | grep -m 1 "CPU Fan Speed"| cut -d: -f2 | sed "s/ //g" | sed "s/+//g" | cut -d"(" -f1 2> /dev/null)
		Center "Motherboard Sensors"
		CColumnize -t 'SENSOR' 'DETECTED' 'READING'
		FullBar
		EVEN=0
		echo -n ${BASE} >> ~/.conkyrc
		#CPUTEMP="" #set for debugging purposes
		if [[ "${CPUTEMP}" != "" ]]; then
			echo -n '${goto '${INDENT}'}${voffset '${TICON}'}${font Stylebats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${goto '${VOFF}'}'${PROC}'${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${goto '${VOFF}'}${alignr}CPU TEMP:  ${alignr}${execi 0 sensors -f | grep -i "temp1" | cut -d ":" -f2 | cut -d "+" -f2 | cut -d"(" -f1 | head -1 2> /dev/null}' >> ~/.conkyrc
			EVEN=1
			CColumnize 'CPUTEMP' 'YES' "${CPUTEMP}"
		else
			CColumnize 'CPUTEMP' 'NO' "N/A"
			EVEN=0
		fi
		echo "${BASE}" >> ~/.conkyrc
		echo '${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}CPU Usage:  ${freq}MHz X '${TCORES}'${alignr}${cpu cpu0}% '${BAR}' ${cpubar cpu0 '${INDENT}','${SBAR}'}' >> ~/.conkyrc

		#FANSPEED="" #set for debugging purposes

		if [[ "${FANSPEED}" != "" ]]; then
			if [[ "${EVEN}" == "0" ]]; then
				echo -n ${BASE}'${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}F${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}Fan speed: '${HILIGHT} >> ~/.conkyrc
				echo -n '${execi '${TIMESLICES}' sensors -f| grep -m -1 "CPU Fan Speed"|cut -d: -f2|sed "s/ //g"|sed "s/+//g" | cut -d"(" -f1}' >> ~/.conkyrc
				CColumnize 'FANSPEED' 'YES' "${FANSPEED}"
				EVEN=1 # Set switch so next detected can be set on the same line.
			else
				echo -n ${BASE}'Fan Speed: '${HILIGHT} >> ~/.conkyrc
				echo '${execi '${TIMESLICES}' sensors -f | grep -m 1 "CPU Fan Speed"|cut -d: -f2|sed "s/ //g"|sed "s/+//g" | cut -d"(" -f1}' >> ~/.conkyrc
				CColumnize 'FANSPEED' 'YES' "${FANSPEED}"
				EVEN=0 # End of the line doe no use the -n with echo above.
			fi
		else
			CColumnize 'FANSPEED' 'NO' "N/A (Water cooled?)"
		fi

		#GPUTEMP="" #set for debugging purposes
		#GPU TEMP?
		VIDCARD="${GPU}"
		if [[ "${GPUTEMP}" != "" ]]; then
			if [[ "${EVEN}" == "0" ]]; then
				if [[ "${VIDCARD}" == "" ]]; then
					echo -n ${BASE}GPU:${GPU}'${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}Y${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}GPU Temp: '${HILIGHT} >> ~/.conkyrc
					echo -n '${alignr}${font}GPU TEMP:${execi '${TIMESLICES}' sensors -f | grep -n "temp1" | head -1 | sed -n 2p | cut -d":" -f3 | cut -d "+" -f2 | awk -F"+" "{print $2}" | cut -d"(" -f1}' >> ~/.conkyrc
					CColumnize 'GPUTEMP' 'YES' "${GPUTEMP}"
					EVEN=1
				else
					echo -n ${BASE}'${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}Y${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}GPU: '${VIDCARD}': '${HILIGHT} >> ~/.conkyrc
					echo -n '${alignr}${font}GPU TEMP:${execi '${TIMESLICES}' sensors -f | grep -n "temp1" | head -1 | sed -n 2p | cut -d":" -f3 | cut -d "+" -f2 | awk -F"+" "{print $2}" | cut -d"(" -f1}' >> ~/.conkyrc
					CColumnize 'GPUTEMP' 'YES' "${GPUTEMP}"
					EVEN=1
				fi
			else
				if [[ "${VIDCARD}" == "" ]]; then
					echo -n '${font}${alignr}GPU Temp: '${HILIGHT} >> ~/.conkyrc
					echo '${execi '${TIMESLICES}' sensors -f | grep -n "temp1" | head -1| sed -n 2p | cut -d":" -f3 | cut -d "+" -f2 | awk -F"+" "{print $2}" | cut -d"(" -f1}' >> ~/.conkyrc
					CColumnize 'GPUTEMP' 'YES' "${GPUTEMP}"
					EVEN=0
				else
					echo -n ${BASE}'${goto '${INDENT}'}${voffset '${TICON}'}${font Stylebats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}${goto '${VOFF}'}'${VIDCARD}'${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${goto '${VOFF}'}${alignr}GPU TEMP:  ${alignr}${execi '${TIMESLICES}' sensors -f | grep -i "edge" | head -1 | cut -d ":" -f2 | cut -d "+" -f2 | cut -d"(" -f1}' >> ~/.conkyrc
					echo "${BASE}" >> ~/.conkyrc
					CColumnize 'GPUTEMP' 'YES' "${GPUTEMP}"
					EVEN=0
				fi

			fi
		else
			CColumnize 'GPU' 'NO' "N/A (Water cooled?)"
		fi

		#MBTEMP="" #set for debugging purposes
		#Main-board Temp?
		if [[ "${MBTEMP}" != "" ]]
			then
			if [[ "${EVEN}" == "0" ]]; then
				echo -n '${goto '${INDENT}'}${font StyleBats:pixelsize='${FONTSIZE}'}{font}F${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}MB Temp: '${HILIGHT} >> ~/.conkyrc
				echo '${execi '${TIMESLICES}' sensors -f|grep -m 1 "MB Temp" | cut -d: -f2| sed "s/ //g" | sed "s/+//g" | cut -d"(" -f1}' >> ~/.conkyrc
				CColumnize 'MAINBOARD' 'YES' "${MBTEMP}"
				EVEN=1
			else
				echo -n '${font}${alignr}MB Temp: '${HILIGHT} >> ~/.conkyrc
				echo '${execi '${TIMESLICES}' sensors -f|grep -m 1 "MB Temp" | cut -d: -f2| sed "s/ //g" | sed "s/+//g" | cut -d"(" -f1}' >> ~/.conkyrc
				CColumnize 'MAINBOARD' 'YES' "${MBTEMP}"
				EVEN=0
			fi
		else
			CColumnize 'MAINBOARD' 'NO' "N/A (Water cooled?)"
		fi

		# Close out TEMPS with a line.
		echo ${HEADER}'CORES${hr 2}'${BASE} >> ~/.conkyrc
		# Sensors is NOT installed, inform enduser.
	else
		if ! [[ "${ISARCH}" ]]; then
			Error "Error: Sensors package is not installed, sudo apt-get install lm-sensors."
		else
			Error "Error: Sensors package is not installed, sudo pacman -Syuu lm-sensors."
		fi
		# Closes of need / discovery of temp sensors package
	fi
	FullBar
	# Create a cpubar for each core
	LITERATIONS=$(( "${TCORES}" / 4 ))
	#echo "LITERATIONS: ${LITERATIONS}"
	COUNTER=0
	declare -i BARWIDTH;
	declare -i BARA;
	declare -i BARB;
	declare -i BARC;
	declare -i BARD;
	declare -i BARE;
	declare -i BARF;
	if (( "${TCORES}" % 4 == "0" )); then
		if [[ "${TCORES}" -gt "8" ]]; then
			SEP=2
			BARWIDTH=$(("${GRAPHWIDTH}" / 8))
			BARA=$(("${BARWIDTH}" * 2 + "${SEP}"))
			BARB=$(("${BARA}" + "${BARWIDTH}"+ "${SEP}"))
			BARC=$(("${BARB}" + "${BARWIDTH}"+ "${SEP}"))
			BARD=$(("${BARC}" + "${BARWIDTH}"+ "${SEP}"))
			BARE=$(("${BARD}" + "${BARWIDTH}"+ "${SEP}"))
			BARF=$(("${BARE}" + "${BARWIDTH}"+ "${SEP}"))
			for EACH in 1.."${LITERATIONS}"
			do
				while [[ "${COUNTER}" != "${TCORES}" ]]; do
					COUNTER=$((COUNTER + 1))
					echo -n '${goto 7}${voffset -4}${font StyleBats:pixelsize=14}A${font}${font}Core '${COUNTER}': ${color #ffff00}${goto '${BARWIDTH}'}${cpu '${COUNTER}'}% ${color #ffd700}${cpubar cpu'${COUNTER}' 7,40}${color #ffffff}${goto '${BARA}'}' >> ~/.conkyrc
					COUNTER=$((COUNTER + 1))
					echo -n '${font StyleBats:pixelsize=14} A${font}${font}Core '${COUNTER}': ${color #ffff00}${goto '${BARB}'}${cpu cpu'${COUNTER}'}% ${color #ffd700}${cpubar cpu'${COUNTER}' 7,40}${color #ffffff}${goto '${BARC}'}' >> ~/.conkyrc
					COUNTER=$((COUNTER + 1))
					echo -n '${font StyleBats:pixelsize=14} A${font}${font}Core '${COUNTER}': ${color #ffff00}${goto '${BARD}'}${cpu cpu'${COUNTER}'}% ${color #ffd700}${cpubar cpu'${COUNTER}' 7,40}${color #ffffff}${goto '${BARE}'}' >> ~/.conkyrc
					COUNTER=$((COUNTER + 1))
					echo -n '${font StyleBats:pixelsize=14} A${font}${font}Core '${COUNTER}': ${color #ffff00}${goto '${BARF}'}${cpu cpu'${COUNTER}'}% ${color #ffd700}${cpubar cpu'${COUNTER}' 7,40}${color #ffffff}' >> ~/.conkyrc
					echo '${font Liberation:style=normal:pixelsize=14}'  >> ~/.conkyrc
					#COUNTER=$((COUNTER + 4))
				done
			done
		else
			COUNTER=0
			while [[ "${COUNTER}" != "${CORES}" ]]; do
				COUNTER=$((COUNTER + 1))
				echo '${goto '$INDENT'}${voffset '${TICON}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}Core '${COUNTER}':' ${HILIGHT}'${cpu cpu'${COUNTER}'}% '${BAR}'${alignr}${cpubar cpu'${COUNTER}' '${INDENT}','${BPER}'}'${BASE} >> ~/.conkyrc
			done
		fi
	else
		COUNTER=0
		if [[ "${CORES}" -gt "8" ]]; then
			Encapsulate "Only creating first 8 CPU core bars ${CORES} is not divisable by 4."
			CORES="8"
			while [[  "${COUNTER}" != "${CORES}" ]]; do
				COUNTER=$((COUNTER + 1))
				echo '${goto '$INDENT'}${voffset '${TICON}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}Core '${COUNTER}':' ${HILIGHT}'${cpu cpu'${COUNTER}'}% '${BAR}'${alignr}${cpubar cpu'${COUNTER}' '${INDENT}','${BPER}'}'${BASE} >> ~/.conkyrc
			done
		else
			while [[ "${COUNTER}" != "${CORES}" ]]; do
				COUNTER=$((COUNTER + 1))
				echo '${goto '$INDENT'}${voffset '${TICON}'}${font StyleBats:pixelsize='${FONTSIZE}'}A${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}${font}Core '${COUNTER}':' ${HILIGHT}'${cpu cpu'${COUNTER}'}% '${BAR}'${alignr}${cpubar cpu'${COUNTER}' '${INDENT}','${BPER}'}'${BASE} >> ~/.conkyrc
			done
		fi
	fi

	# Output total memory / usage.
	if ! [[ "${MEMTEMP}" ]]; then
		echo ${HEADER}'${voffset -4}RAM${hr 2 }' >> ~/.conkyrc
	else
		echo ${HEADER}'${voffset -4}RAM '${MEMTEMP}' ${hr 2 }' >> ~/.conkyrc
	fi
	echo -n ${BASE}'${voffset 2}${font VariShapes Solid:pixelsize='${FONTSIZE}'}N${font}Useage: $mem / $memmax ${alignr}$memperc% '${BAR}'${membar '${INDENT}','${SBAR}'}' >> ~/.conkyrc

	# Swap check - no sense in display the info if the user does not have any swap.
	if [[ "${SWAPTOTAL}" != "0" ]]; then
		echo '' >> ~/.conkyrc
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Stylebats:pixelsize='${FONTSIZE}'}j${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'$BASE'Swap: $swap/$swapmax${alignr}$swapperc% '${BAR}'${swapbar '${INDENT}','${SBAR}'}' >> ~/.conkyrc
	else
		echo "" >> ~/.conkyrc
	fi

	# Top Processes / Ram Hogs
	echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}a${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}Highest: ${alignr}CPU	 RAM' >> ~/.conkyrc
	echo '${goto '${VOFF}'}${voffset -5.5}${hr 2}' >> ~/.conkyrc
	echo '${voffset -1}${goto '${VOFF}'}${top name 1}${alignr}${top cpu 1}  ${top mem 1}' >> ~/.conkyrc
	echo '${goto '${VOFF}'}${top name 2}${alignr}${top cpu 2}  ${top mem 2}' >> ~/.conkyrc
	echo '${goto '${VOFF}'}${top name 3}${alignr}${top cpu 3}  ${top mem 3}' >> ~/.conkyrc
	TOTALS=$(df -H --total | grep 'total')
	# File-system(s)
	echo ${HEADER}'FILESYSTEM(s) '${TOTALS}'${hr 2 }'${BASE} >> ~/.conkyrc
	echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}Y${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}Disk I/O: ${diskio}${alignr}'${BAR}'${diskiograph '${LOGO}','${BPER}'}'$BASE >> ~/.conkyrc

	# Detect hard disks & create a bar for each mount point provide info to end user
	# Step one crack out the whip on the SCSI (Sata) channel.

	# HDSIZE=0 future implementation
	# TSPACE=0 future implementation

	# MANUALLY ADD RootFS to the mix, the only one guaranteed to be thier fs ;)
	MOUNTPOINT=$(df / | awk '{print $6}' | sed '1d')
	STRIPPED="RootFS"
	declare -a line=();
	line=$(df | grep -w "/" | sed "/rootfs/d" | cut -d" " -f1)
	#echo "ANALYSING ${EACH}"
	for EACH in "${line[@]}"
	do
	HDSIZE=$(df -H "${EACH}" | sed "1d" | awk '{print $2}')
	if [[ "${ISHDDTEMP}" ]]; then

		# TEST 2 conditions:
		# 1. NON-EXISTANT OUTPUT IE USB HDD / Burner
		# 2. Permissions to hddtemp SUID
		# Catch erronious output, eject it to null and skip smart checks.
		TSTVAR=$(hddtemp "$line" /dev/null 2>&1 | grep -i 'Permission denied')
		if ! [[ $TSTVAR ]]; then
			TSTVAR=$(hddtemp "$line" /dev/null 2>&1 | grep -i "t have a temperature sensor.")
		fi

		# hddtemp permissions are correct and a sensor exists on current drive.
		if ! [[ "$TSTVAR" ]]; then
			HDTEMP=$(hddtemp "$line" --unit=f --numeric 2>/dev/null)
			SMART=$(echo "${HDTEMP}" | grep -v "S.M.A.R.T. not available")
			SENSOR=$(echo "${HDTEMP}" | grep -v "have a temperature sensor")
		fi
	fi
	done
	#TSPACE=$(expr ${TSPACE} + ${HDSIZE})

	# If Temperature was detected populate Conky as well display info to user.
	if [[ "$SMART" != "" &&  "$SENSOR" != "" ]]; then
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${hddtemp '$HDTMP'}°F | ${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'$BASE >> ~/.conkyrc
	else
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'$BASE >> ~/.conkyrc
	fi

	# display the information to end user in pretty columns
	Center "Storage Information"
	CColumnize -t "DEVICE" "MOUNTPOINT" "TEMP" "SIZE"
	FullBar
	if [[ "${HDTEMP}" ]]; then
		CColumnize "rootfs" "/" "${HDTEMP}°F" "${HDSIZE}"
	else
		CColumnize "rootfs" "/" "N/A" "${HDSIZE}"
	fi

	awk '/dev\/sd/ {print $1}' /etc/mtab | sort | while read line
	do
		if [[ "$DEBUG" ]]; then
			echo "DEBUGGING: ${line}"
		fi
		MOUNTPOINT=$(df "${line}" | awk '{ s = ""; for (i = 6; i <= NF; i++) s = s $i " "; print s }' | sed '1d' | sed -e 's/[[:space:]]*$//')
		DISPMOUNTPOINT=$(echo "${MOUNTPOINT}" | sed "s/$USER\///g" | sed "s/\/media\///g" | sed "s/media\///g" | sed "s/\/mnt\///g")
		STRIPPED=$(echo "${MOUNTPOINT}" | sed 's/\/media\///g')
		echo "${MOUNTPOINT}" >> /tmp/mpoint.txt
		if [ "$STRIPPED" = "/" ]; then
			STRIPPED="Root"
		fi

		HDDTMP=$(echo "$line" | sed 's/[0-9]*//g')
		#Future implementation?
		HDSIZE=$(df -H "$line" | sed "1d" | awk '{print $2}')

		#See if hddtemp is installed & SUID executable, if not don't do squat
		if [[ "${ISHDDTEMP}" ]]; then

			# TEST 2 conditions:
			# 1. NON-EXISTANT OUTPUT IE USB HDD / Burner
			# 2. Permissions to hddtemp SUID
			# Catch erronious output, eject it to null and skip smart checks.
			TSTVAR=$(hddtemp "$line" /dev/null 2>&1 |grep 'Permission denied')
			if ! [[ "$TSTVAR" ]]; then
				TSTVAR=$(hddtemp "$line" /dev/null 2>&1 | grep -i "t have a temperature sensor.")
			fi

			# hddtemp permissions are correct and a sensor exists on current drive.
			if ! [[ "$TSTVAR" ]]; then
				HDTEMP=$(hddtemp "$line" --unit=f --numeric)
				SMART=$(echo "${HDTEMP}" | grep -v "S.M.A.R.T. not available")
				SENSOR=$(echo "${HDTEMP}" | grep -v "have a temperature sensor")
			fi
		fi
		#TSPACE=$(expr ${TSPACE} + ${HDSIZE})

		# If Temperature was detected populate Conky as well display info to user.
		if [[ "$SMART" != "" &&  "$SENSOR" != "" ]]; then
			CColumnize "$line" "${DISPMOUNTPOINT}" "${HDTEMP}°F" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${hddtemp '${DISPMOUNTPOINT}'}°F | ${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		else
			CColumnize "$line" "${DISPMOUNTPOINT}" "N/A (USB?)" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		fi
	done;

	# Hard disks continued. HDA/B Etc.?
	awk '/dev\/hd/ {print $1}' /etc/mtab | sort | while read line
	do
		MOUNTPOINT=$(df "${line}" | awk '{print $6}' | sed '1d')
		DISPMOUNTPOINT=$(echo "${MOUNTPOINT}" | sed "s/$USER\///g" | sed "s/\/media\///g" | sed "s/media\///g" | sed "s/\/mnt\///g")
		STRIPPED=$(echo "${MOUNTPOINT}" | sed 's/\/media\///g')
		echo ${MOUNTPOINT} >> /tmp/mpoint.txt

		if [[ $STRIPPED == "/" ]]; then
			STRIPPED="Root"
		fi

		# Hard Drive / USB / Partition: Set temp readings if it applies as per drive."
		HDDTMP=$(echo "$line" | sed 's/[0-9]*//g')
		#See if hddtemp is installed & SUID executable, if not don't do squat
		if [[ "${ISHDDTEMP}" ]]; then

			# TEST 2 conditions:
			# 1. NON-EXISTANT OUTPUT IE USB HDD / Burner
			# 2. Permissions to hddtemp SUID
			# Catch erronious output, eject it to null and skip smart checks.
			TSTVAR=$(hddtemp "$line" /dev/null 2>&1 | grep -i "Permission denied")
			if ! [[ "$TSTVAR" ]]; then
				TSTVAR=$(hddtemp "$line" /dev/null 2>&1 | grep -i "t have a temperature sensor.")
			fi

			# hddtemp permissions are correct and a sensor exists on current drive.
			if ! [[ "$TSTVAR" ]]; then
				HDTEMP=$(hddtemp "$line" --unit=f --numeric)
				SMART=$(echo ${HDTEMP} | grep -v "S.M.A.R.T. not available")
				SENSOR=$(echo "${HDTEMP}" | grep -v "have a temperature sensor")
			fi
		fi

		HDSIZE=$(df -H "$line" | sed "1d" | awk '{print $2}')
		HDTEMP=$(hddtemp "$line" --unit=f --numeric)
		SMART=$(echo "${HDTEMP}" | grep -v "S.M.A.R.T. not available")
		SENSOR=$(echo "${HDTEMP}" | grep -v "have a temperature sensor")
		#TSPACE=$(expr ${TSPACE} + ${HDSIZE})

		# If Temperature was detected populate Conky as well display info to user.
		if [[ "$SMART" != "" &&  "$SENSOR" != "" ]]; then
			CColumnize "$line" "${DISPMOUNTPOINT}" "${HDTEMP}°F" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${hddtemp '${HDTEMP}'}°F | ${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		else
			CColumnize "$line" "${DISPMOUNTPOINT}" "N/A" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		fi
	done;

	# Hard disks continued. RAID MD0 Etc.?
	awk '/dev\/md/ {print $1}' /etc/mtab | sort | while read line
	do
		MOUNTPOINT=$(df "$line" | awk '{print $6}' | sed "1d")
		DISPMOUNTPOINT=$(echo "${MOUNTPOINT}" | sed "s/$USER\///g" | sed "s/\/media\///g" | sed "s/media\///g" | sed "s/\/mnt\///g")
		STRIPPED=$(echo "${MOUNTPOINT}" | sed "s/\/media\///g")
		echo "${MOUNTPOINT}" >> /tmp/mpoint.txt

		if [[ "$STRIPPED" == "/" ]]; then
			STRIPPED="Root"
		fi

		# Hard Drive / USB / Partition: Set temp readings if it applies as per drive."
		HDDTMP=$(echo "$line" | sed "s/[0-9]*//g")
		HDSIZE=$(df -H "$line" | sed "1d" | awk '{print $2}')
		#TSPACE=$(expr ${TSPACE} + ${HDSIZE})

		# If Temperature was detected populate Conky as well display info to user.
		CColumnize "$line" "${DISPMOUNTPOINT}" "N/A" ${HDSIZE}
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc

	done;

	#NVME Drive(s)?
	awk '/dev\/nvme/ {print $1}' /etc/mtab | sort | while read line
	do
		if [[ "$DEBUG" ]]; then
			echo "DEBUGGING: ${line}"
		fi
		MOUNTPOINT=$(df "${line}" | awk '{ s = ""; for (i = 6; i <= NF; i++) s = s $i " "; print s }' | sed '1d' | sed -e 's/[[:space:]]*$//')
		DISPMOUNTPOINT=$(echo "${MOUNTPOINT}" | sed "s/$USER\///g" | sed "s/\/media\///g" | sed "s/media\///g" | sed "s/\/mnt\///g")
		STRIPPED=$(echo "${MOUNTPOINT}" | sed 's/\/media\///g')
		echo "${MOUNTPOINT}" >> /tmp/mpoint.txt
		if [ "$STRIPPED" = "/" ]; then
			STRIPPED="Root"
		fi

		HDDTMP=$(echo "$line" | sed 's/[0-9]*//g')
		INSTALLED=$(type -p nvme)
		if [[ "${INSTALLED}" ]]; then
			SMART=0
			HDTEMP=$(sudo nvme smart-log $line | grep "temp" | cut -d ":" -f2 | cut -d " " -f2)
			if [[ "${HDTEMP}" ]]; then
				SMART=1
				#echo "NVME: $line | TEMP: ${HDTEMP}"
				HDTEMP=$(echo "1.8 * $HDTEMP + 32" | bc)
			fi
		fi
		#Future implementation?
		HDSIZE=$(df -H "$line" | sed "1d" | awk '{print $2}')

		#See if hddtemp is installed & SUID executable, if not don't do squat
		#TSPACE=$(expr ${TSPACE} + ${HDSIZE})

		# If Temperature was detected populate Conky as well display info to user.
		if [[ "$SMART" != "" &&  "$HDTEMP" != "" ]]; then
			CColumnize "$line" "${DISPMOUNTPOINT}" "${HDTEMP}°F" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}'${HDTEMP}°F' | ${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		else
			CColumnize "$line" "${DISPMOUNTPOINT}" "N/A (USB?)" "${HDSIZE}"
			echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}${DISPMOUNTPOINT}' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
		fi
	done;

	# Step 2 NFS based NAS
	# or better yet write a function & eliminate a large chunk of code.
	df -h | awk '/:/ {print $1 "|" $2}' /etc/mtab | while read line
	do
		NET=$(echo "$line" | cut -d "|" -f1)
		NET="${NET##*/}"
		URL="NAS"
		MOUNTPOINT="$URL:$NET"
		MPOINT=$(echo "$line" | cut -d "|" -f2)
		FRIENDLY=$(echo "$MPOINT"  | sed "s/$USER\///g" | sed "s/\/media\///g" | sed "s/media\///g" | sed "s/\/mnt\///g")
		if [[ "$FRIENDLY" ]]; then
			MOUNTPOINT="$MPOINT"
		fi
		SIZE=$(df -h "$MPOINT" | awk '{print $2}' | sed "1d")
		#echo "DEBUGGING: NET:$NET URL:$URL LINE:$line SIZE:$SIZE FRIENDLY:$FRIENDLY"
		STRIPPED=$(echo "${MOUNTPOINT}" | sed "s/\/media\///g")
		echo "${MOUNTPOINT}" >> /tmp/mpoint.txt
		fout=$(echo "$line" | cut -d":" -f1)
		CColumnize "$fout" "$STRIPPED" "N/A" "$SIZE"
		HDDTMP=$(echo "$line" | sed "s/[0-9]*//g")
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}$STRIPPED' ('$fout'): ${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
	done;


	# Step 3 Burners
	awk '/dev\/sr/ {print $1}' /etc/mtab | sort | while read line
	do
		MOUNTPOINT=$(df "$line" | awk "{print $6}" | sed "1d")
		STRIPPED=$(echo "${MOUNTPOINT}" | sed "s/\/media\///g")
		if [ "$STRIPPED" = "/" ]; then
			STRIPPED="Root"
		fi
		CColumnize "$line" "$STRIPPED" "N/A"
		HDDTMP=$(echo "$line" | sed "s/[0-9]*//g")
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}$STRIPPED' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
	done;

	# Step 4 - Why stop there snatch up NAS(s) drives.
	awk '/\/\// {print $2}' /etc/mtab | sort | while read line
	do
		MOUNTPOINT=$(df "$line" | awk '{print $8}' | sed '1d')
		STRIPPED=$(echo "${MOUNTPOINT}" | sed 's/\/media\///g')
		if [[ "$STRIPPED" == "/" ]]; then
			STRIPPED="Root"
		fi
		CColumnize "$line" "$STRIPPED" "N/A"
		# No temp detection via network do not populate TEMP.
		echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}H${font}${voffset -'${ALEFT}'}${goto '${VOFF}'}'${BASE}$STRIPPED' ('$line'):${tab}${fs_free '${MOUNTPOINT}'} / ${fs_size '${MOUNTPOINT}'}${alignr}${fs_used_perc '${MOUNTPOINT}'}% '${BAR}'${fs_bar '${INDENT}','${SBAR}' '${MOUNTPOINT}'}'${BASE} >> ~/.conkyrc
	done;
	FullBar
	TOTALS=$(df -H --total | grep 'total')
	Encapsulate "$TOTALS"
	FullBar
	# Network re-visit...
	if [[ "${ACTIVE}" != "No Inet" ]];then
		echo ${HEADER}'ACTIVE NETWORK: '${ACTIVE}  SPEED: ${SPEED}'${hr 2 }'${HILIGHT} >> ~/.conkyrc

		# Propagate networking information based on active connection
		echo '${voffset 2}${font VariShapes Solid:pixelsize='${FONTSIZE}'}q${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Up: ${upspeed '${ACTIVE}'}'${BAR}'${alignr}${upspeedgraph '${ACTIVE}' '${LOGO}','${BPER}'}'${BAR} >> ~/.conkyrc
		#${voffset -24}${goto '${VOFF}'}Total: ${totalup '${ACTIVE}'}
		echo '${voffset -'${LOGO}'}${goto '${VOFF}'}Total: ${totalup '${ACTIVE}'}' >> ~/.conkyrc
		echo '${voffset -'${ALEFT}'}${font VariShapes Solid:pixelsize='${FONTSIZE}'}Q${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Down: ${downspeed '${ACTIVE}'}'${BAR}'${alignr}${downspeedgraph '${ACTIVE}' '${LOGO}','${BPER}'}'${BAR} >> ~/.conkyrc
		echo '${voffset -'${LOGO}'}${goto '${VOFF}'}Total: ${totaldown '${ACTIVE}'}' >> ~/.conkyrc

		# Provide wireless info if user is using wireless actively.
		if [[ "$wlan" == "up" ]]; then

			#Wireless header
			echo ${HEADER}'Wireless: '${ACTIVE}'${hr 2 }'${HILIGHT} >> ~/.conkyrc

			# ACCESS POINT
			echo '${voffset 2}${font VariShapes Solid:pixelsize='${FONTSIZE}'}-${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Wireless Access Point: ${alignr}${wireless_essid '${ACTIVE}'}' >> ~/.conkyrc

			# Connection strength / signal
			echo '${voffset 2}${font Stylebats:pixelsize='${FONTSIZE}'}Z${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Connection strength: ${alignr}${wireless_link_qual_perc '${ACTIVE}'}%' >> ~/.conkyrc

			# Connection speed
			echo '${voffset 2}${font Stylebats:pixelsize='${FONTSIZE}'}C${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Connection max throughput: ${alignr}${wireless_bitrate '${ACTIVE}'}' >> ~/.conkyrc
		fi

		# echo ${HEADER}'${voffset -'${ALEFT}'}${hr 2}' >> ~/.conkyrc

		# Provide general connection info
		echo -n '${voffset -'${ALEFT}'}${font Poky:pixelsize='${FONTSIZE}'}w${font}${goto '${VOFF}'}${voffset -'${ALEFT}'}Local IP: ${addr '${ACTIVE}'}${alignr}' >> ~/.conkyrc
		echo '${voffset 2}${font Stylebats:pixelsize='${FONTSIZE}'}M${font}TCP Connections: ${tcp_portmon 1 65535 count}' >> ~/.conkyrc
	fi
	echo ${HEADER}'${voffset -'${ALEFT}'}${hr 2}' >> ~/.conkyrc
	# Close out with a thin line at the bottom & the Date / Time
	echo '${goto '${INDENT}'}${voffset '${TICON}'}${font Poky:pixelsize='${FONTSIZE}'}d${voffset -'${ALEFT}'}${goto '${VOFF}'}'${HEADER}'${goto '${VOFF}'}${alignc}${time %H:%M}, ${time %A %d %B}' >> ~/.conkyrc
	echo "${HEADER}" >> ~/.conkyrc
	#'${voffset -'${ALEFT}'}${hr 2}'
	if [[ -f "/tmp/mpoint.txt" ]]; then
		if [[ "$DEBUG" ]]; then
			cat /tmp/mpoint.txt
		fi
		Encapsulate "Cleaning up."
		rm -f "/tmp/mpoint.txt"
	fi
	Notification "Conky builder system detection complete."
	FullBar
	if [[ "${UID}" == "0" ]]; then
		killall -9 conky
	fi
	exit 0 # make sure we exit graciously, we want to add to boot-up with && to allow
	# other processes to continue.  No sense in being a hog and slowing boot time.
}

# Help system - I have re-wrote this section to work with code-cleanup.
Help () {

	if [[ "$2" == "" ]]; then
		VersionDump
		PRAM="ALL"
	else
		if ! [[ $3 ]]; then
			VersionDump
			PRAM="$2"
		else
			PRAM="$2"
		fi
	fi

	case "$PRAM" in
		ALL)
		Center "Usage: $PROGNAME -<-COMMAND> [OPTION]"
		Encapsulate "Mandatory arguments to long options are identical for short options."
		Encapsulate "  possible commands..."
		Encapsulate ""
		Encapsulate "  -h	--help		this help message"
		Encapsulate "  -v	--version	dump version info and exit"
		Encapsulate ""
		Encapsulate "$PROGNAME --help [COMMAND] for further information.";
		FullBar;;
		ALL|v|version)
		Encapsulate ""
		Encapsulate "Usage version;"
		Encapsulate "$PROGNAME -v"
		Encapsulate "Displays $PROGNAME version number and exits.";
		FullBar;;
		ALL|h|help|\?)
		Encapsulate ""
		Encapsulate "Useage Help [COMMAND];"
		Encapsulate "$PROGNAME -h [COMMAND]"
		Encapsulate "Displays this message. For futher information $PROGNAME help [COMMAND]"
		Encapsulate "or refer to the manpages."
		Encapsulate ""
		Encapsulate "man $PROGNAME"
		Encapsulate ""
		Encapsulate "Example: $PROGNAME -h version"
		Encapsulate "Will display help about the command version"
		Fullbar;;
	esac
	exit 0
}

Timer "Start" "${APPNAME}"

case "$1" in
	-h|--help|-\?) Help "$@"; exit 0;;
	-v|--version) VersionDump "$@"; exit 0;;
	*) Main "$@"; exit 0;;
esac


# ==============================================================================
# This code was automatically cleaned up using code-cleanup
# title			:code-cleanup
# description		:Bash code cleanup script
# Author		:root
# date			:10/23/2013
# version		:1.7.2-1
# http://ultimateedition.info/
# ==============================================================================
