#!/bin/bash
# Ultimate Player display script by TheeMahn <theemahn@ultimateedition.info>
#
# requirements: ultimate-player (!), qdbus, radiotray
#

#function (UP)
QDBUS=$(type -p qdbus)
if [[ "${QDBUS}" ]]; then
	APPLICATION=""
	TESTIT=$(qdbus | grep "pithos")
	if [[ "${TESTIT}" ]]; then
		PITHOS=$(qdbus org.mpris.MediaPlayer2.pithos /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata)
	fi
	TESTIT=$(qdbus | grep "clementine")
	if [[ "${TESTIT}" ]]; then
		CLEMENTINE=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata)
	fi
	TESTIT=$(qdbus | grep "strawberry")
	if [[ "${TESTIT}" ]]; then
		STRAWBERRY=$(qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata)
	fi
	TESTIT=$(qdbus | grep "radio")
	if [[ "${TESTIT}" ]]; then
		RADIOTRAY=$(qdbus net.sourceforge.radiotray /net/sourceforge/radiotray getCurrentMetaData)
	fi
	TESTIT=$(qdbus | grep "ultimate")
	if [[ "${TESTIT}" ]]; then
		ULTIMATE=$(qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata)
	fi
fi
case "${1}" in
	pithos)
		if [[ "${PITHOS}" ]]; then
			APPLICATION="pithos"
		fi;;
	clementine)
		if [[ "${CLEMENTINE}" ]]; then
			APPLICATION="clementine"
		fi;;
	strawberry)
		if [[ "${STRAWBERRY}" ]]; then
			APPLICATION="strawberry"
		fi;;
	radiotray)
		if [[ "${RADIOTRAY}" ]]; then
			APPLICATION="radiotray"
		fi;;
	ultimate)
		if [[ "${ULTIMATE}" ]]; then
			APPLICATION="ultimate"
		fi;;
esac
case "${APPLICATION}" in
# PITHOS
	pithos)
		case "${2}" in
			cover) qdbus org.mpris.MediaPlayer2.pithos /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep "xesam:url: " | sed "s/xesam:url: //g";;
			title) qdbus org.mpris.MediaPlayer2.pithos /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep "xesam:title:" | sed "s/xesam:title: //g";;
			album) qdbus org.mpris.MediaPlayer2.pithos /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep "xesam:album:" | sed "s/xesam:album: //g";;
			artist) qdbus org.mpris.MediaPlayer2.pithos /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep "xesam:artist:" | sed "s/xesam:artist: //g";;
		esac;;
# CLEMENTINE
	clementine)
		case "${2}" in
			cover)
			FILENAME=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep artUrl | cut -c 22- | sed "s/ //g")
			if [[ -f "${FILENAME}" ]];then
				cp "${FILENAME}" ~/.config/Ultimate-Player/Current.art
			fi;;
			status)
				status=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.PlaybackStatus)
				if [[ "${STATUS}" == "Paused" ]];	then
					status="Playing"
				fi
				echo ${STATUS};;
			artist) qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep artist | cut -c 15- ;;
			title) qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep title | cut -c 14- ;;
			album) qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep album | cut -c 14- ;;
			year) qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep year | cut -c 12- ;;
			genre) qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep genre | cut -c 14- ;;
			progress)
				curr=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Position)
				tot=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep length)
				total=$( echo "$tot" | cut -c 14- )
				if [[ "$total" != "" ]]; then
					(( progress=curr*100 ))
					(( progress=progress/total ))
				fi
				echo $progress;;
		esac;;
# STRAWBERRY
	strawberry)
		case "${2}" in
			cover)
			FILENAME=$(qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep artUrl | cut -c 22- | sed "s/ //g")
			if [[ -f "${FILENAME}" ]];then
				cp "${FILENAME}" ~/.config/Ultimate-Player/Current.art
			fi;;
			status)
				status=$(qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.PlaybackStatus)
				if [[ "${STATUS}" == "Paused" ]];	then
					status="Playing"
				fi
				echo ${STATUS};;
			artist) qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep artist | cut -c 15- ;;
			title) qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep title | cut -c 14- ;;
			album) qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep album | cut -c 14- ;;
			year) qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep year | cut -c 12- ;;
			genre) qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep genre | cut -c 14- ;;
			progress)
				curr=$(qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Position)
				tot=$(qdbus org.mpris.MediaPlayer2.strawberry /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep length)
				total=$( echo "$tot" | cut -c 14- )
				if [[ "$total" != "" ]]; then
					(( progress=curr*100 ))
					(( progress=progress/total ))
				fi
				echo $progress;;
		esac;;
# RADIO TRAY
	radiotray)
		case "${2}" in
			rplay) qdbus net.sourceforge.radiotray /net/sourceforge/radiotray getCurrentMetaData;;
			rstation) qdbus net.sourceforge.radiotray /net/sourceforge/radiotray net.sourceforge.radiotray.getCurrentRadio;;
		esac;;
# ULTIMATE PLAYER
	ultimate)
		case "${2}" in
			cover)
			FILENAME=$(qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep artUrl | cut -c 22- | sed "s/ //g")
			if [[ -f "${FILENAME}" ]];then
				cp "${FILENAME}" ~/.config/Ultimate-Player/Current.art
			fi;;
			status)
				status=$(qdbus org.mpris.MediaPlayer2.clementine /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.PlaybackStatus)
				if [[ "${STATUS}" == "Paused" ]];	then
					status="Playing"
				fi
				echo ${STATUS};;
			artist) qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep artist | cut -c 15- ;;
			title) qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep title | cut -c 14- ;;
			album) qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep album | cut -c 14- ;;
			year) qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep year | cut -c 12- ;;
			genre) qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /Player org.freedesktop.MediaPlayer.GetMetadata | grep genre | cut -c 14- ;;
			progress)
				curr=$(qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Position)
				tot=$(qdbus qdbus org.mpris.MediaPlayer2.ultimateplayer /org/mpris/MediaPlayer2 org.mpris.MediaPlayer2.Player.Metadata | grep length)
				total=$( echo "$tot" | cut -c 14- )
				if [[ "$total" != "" ]]; then
					(( progress=curr*100 ))
					(( progress=progress/total ))
				fi
				echo $progress;;
		esac;;
esac
