#!/usr/bin/env bash
# shellcheck disable=SC2034

iso_name="ultimate-arch-#DISTTYPELOWER"
iso_label="ULTIMATE_ARCH_$(date +%Y%m)"
iso_publisher="TheeMahn <https://archultimateedition.com/>"
iso_application="Ultimate Edition Arch #DISTTYPEUPPER"
iso_version="$(date +%Y.%m.%d)"
install_dir="arch"
buildmodes=('iso')
bootmodes=('bios.syslinux.mbr' 'bios.syslinux.eltorito' 'uefi-x64.systemd-boot.esp' 'uefi-x64.systemd-boot.eltorito')
arch="x86_64"
pacman_conf="pacman.conf"
airootfs_image_type="squashfs"
airootfs_image_tool_options=('-comp' 'xz' '-Xbcj' 'x86' '-b' '1M' '-Xdict-size' '1M')
file_permissions=(
  ["/etc/shadow"]="0:0:400"
  ["/root"]="0:0:750"
  ["/root/.automated_script.sh"]="0:0:755"
  ["/root/conky-builder.sh"]="0:0:755"
  #["/usr/share/pixmaps/mate-system-monitor/side.png"]="0:0:644"
  ["/etc/pacman.d/hooks/ultimate-hook"]="0:0:755"
  ["/usr/local/bin/choose-mirror"]="0:0:755"
  # ["/etc/skel/.config/autostart/conky_builder.desktop"]="0:0:755"
  # ["/etc/skel/Desktop/Install.desktop"]="0:0:755"
  # ["/usr/bin/ultimate-hooks-misc"]="0:0:755"
  # ["/usr/bin/ultimate-hooks-runner"]="0:0:755"
  # ["/usr/bin/ultimate-reboot-required"]="0:0:755"
  # ["/usr/local/bin/about-os"]="0:0:755"
  # ["/usr/share/libalpm/hooks/ultimate-hooks-runner"]="0:0:755"
  ["/usr/bin/ultimate-hooks-misc"]="0:0:755"
  ["/usr/bin/ultimate-hooks-runner"]="0:0:755"
  ["/usr/bin/ultimate-reboot-required"]="0:0:755"
  # ["/usr/local/bin/ultimate-welcome"]="0:0:755"
  ["/etc/sudoers.d/g_wheel"]="0:0:750"
  ["/etc/sudoers.d/"]="0:0:750"
  # ["/usr/lib/systemd/system-generators/"]="0:0:775"
  # ["/usr/lib/systemd/system/"]="0:0:775"
  ["/home/ultimate/setup"]="0:0:755"
)
