## Submitting MediaElch issues

If you have questions about how to use the MediaElch, please read the 
[FAQ](https://mediaelch.github.io/mediaelch-doc/faq.html) first.
You can find help in following communities:

 - [English] [Kodi Forum](https://forum.kodi.tv/showthread.php?tid=136333)
 - [German] [Kodinerds](https://www.kodinerds.net/index.php/Thread/14560-MediaElch-MediaManager-for-Mac-Linux-Win/)

### Bug Reporting
You can open bugs at https://github.com/Komet/MediaElch/issues

 - Please make sure that your problem is a bug. Ask for help in a community first (see above).
 - Search the existing issues first as your issue might be already reported.
 - Give details about your system (open MediaElch -> `About` -> `Developer`).
 - Describe how to reproduce the issue (if possible).

## Contributing to Source Code

Thanks for wanting to contribute source code to MediaElch! 
Contributing source code is really easy. Please read the
[build instructions][build] first.
Then you can fork this repository, create a new branch, commit and push your
changes and create a pull request.

## Naming Conventions

| What?          | Convention          |
|----------------|---------------------|
| files          | `CamelCase.h`       |
| folders        | `lower_snake_case/` |
| namespace      | `lower_snake_case`  |
| class / struct | `CamelCase`         |
| variable       | `camelCase`         |

## Translations
Please submit translations via [Transifex](https://app.transifex.com/komet/mediaelch/).

[build]: https://mediaelch.github.io/mediaelch-doc/contributing/build/index.html
