; FU_artist_conte.scm
; version 2.7 [gimphelp.org]
; last modified/tested by Paul Sherman
; 05/05/2012 on GIMP-2.8
;
; ------------------------------------------------------------------
; Original information ---------------------------------------------
;
; Conte image script  for GIMP 2.2
; Copyright (C) 2007 Eddy Verlinden <eddy_verlinden@hotmail.com>
; 
; End original information ------------------------------------------
;--------------------------------------------------------------------

(define (FU-conte
			img
			drawable
			brightness
			contrast
			wild?
			canvas?
	)

  (gimp-image-undo-group-start img)

  (let* (
	 (width (car (gimp-drawable-width drawable)))
	 (height (car (gimp-drawable-height drawable)))
	 (old-selection (car (gimp-selection-save img)))
	 (image-type (car (gimp-image-base-type img)))
	 (layer-type (car (gimp-drawable-type drawable)))
	 (layer-tempa (car (gimp-layer-new img width height layer-type "tempa"  100 NORMAL-MODE)))
	 (layer-tempb (car (gimp-layer-new img width height layer-type "tempb"  100 NORMAL-MODE)))
	 (layer-tempc (car (gimp-layer-new img width height layer-type "tempc"  100 NORMAL-MODE)))
	 (layer-tempd (car (gimp-layer-new img width height layer-type "tempd"  100 NORMAL-MODE)))
	 (layer-tempe (car (gimp-layer-new img width height layer-type "tempe"  100 NORMAL-MODE)))
	 (img2 (car (gimp-image-new width height image-type)))
	 (layer-temp2 (car (gimp-layer-new img2 width height layer-type "temp2" 100 NORMAL-MODE)))
        ) 

    (if (eqv? (car (gimp-selection-is-empty img)) TRUE)
        (gimp-drawable-fill old-selection WHITE-IMAGE-FILL)) ; so Empty and All are the same.
    (gimp-selection-none img)
;-------------------------------------------------------
    (if (eqv? (car (gimp-palettes-get-list "conte_ev8")) 0)
    (begin
    (gimp-palette-new "conte_ev8")
    (gimp-palette-add-entry "conte_ev8" "1" '(117 96 91))
    (gimp-palette-add-entry "conte_ev8" "2" '(139 91 87))
    (gimp-palette-add-entry "conte_ev8" "3" '(164 91 85))
    (gimp-palette-add-entry "conte_ev8" "4" '(185 103 89))
    (gimp-palette-add-entry "conte_ev8" "5" '(240 238 239))
    (gimp-palette-add-entry "conte_ev8" "6" '(205 212 220))
    (gimp-palette-add-entry "conte_ev8" "7" '(90 93 100))
    (gimp-palette-add-entry "conte_ev8" "8" '(51 51 51))
    ))
    (if (> (car (gimp-palettes-get-list "conte_ev8 ")) 0)
        (gimp-message "There is/are palette(s) 'conte_ev8 *'. The best is to delete all palettes 'conte_ev8' (in the dialog 'palettes'). A new original will be created the next time this script is activated"))
    (if (> (car (gimp-palettes-get-list "conte_ev8#")) 0)
        (gimp-message "There is/are palette(s) 'conte_ev8#'. The best is to delete all palettes 'conte_ev8' (in the dialog 'palettes'). A new original will be created the next time this script is activated"))
;-------------------------------------------------------
    (gimp-drawable-fill layer-tempa TRANS-IMAGE-FILL)
    (gimp-image-insert-layer img layer-tempa 0 -1)
    (gimp-edit-copy drawable)
    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-tempa 0)))
    (gimp-drawable-fill layer-tempb TRANS-IMAGE-FILL)
    (gimp-image-insert-layer img layer-tempb 0 -1)
    (gimp-edit-copy drawable)
    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-tempb 0)))

    (plug-in-neon 1 img layer-tempa 5.0 0)
    (gimp-invert layer-tempa)
    (gimp-desaturate layer-tempa)

    (gimp-brightness-contrast layer-tempb (* brightness 1.25) (* contrast 1.25))
    (plug-in-gauss 1 img layer-tempb 2.0 2.0 0)
    (gimp-image-insert-layer img layer-tempc 0 -1)
    (gimp-edit-copy layer-tempb)

    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-tempc 0)))
    (plug-in-gimpressionist 1 img layer-tempc "ev_strokes45r.txt")
    (plug-in-dog 1 img layer-tempc 7.0 2.0 TRUE TRUE)
    (gimp-threshold layer-tempc 250 255)

    (gimp-layer-set-mode layer-tempc 3)
    (gimp-layer-set-mode layer-tempb 3)
    (gimp-image-merge-down img layer-tempc 0)
    (set! layer-tempb (car (gimp-image-get-active-layer img)))
    (gimp-image-merge-down img layer-tempb 0)
    (set! layer-tempa (car (gimp-image-get-active-layer img)))
    (gimp-edit-copy layer-tempa)

;    (set! img2 (car (gimp-image-new width height image-type)))
;    (set! layer-temp2 (car (gimp-layer-new img2 width height layer-type "temp2"  100 NORMAL-MODE)))
    (gimp-image-insert-layer img2 layer-temp2 0 -1)
    (gimp-drawable-fill layer-temp2 TRANS-IMAGE-FILL)
    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-temp2 0)))
    (gimp-image-convert-indexed img2 0 4 0 0 0 "conte_ev8")
    (gimp-edit-copy layer-temp2)
    (gimp-image-delete img2)

    (gimp-layer-add-alpha layer-tempa)
    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-tempa 0)))
    (gimp-image-insert-layer img layer-tempd 0 -1)
    (gimp-edit-copy layer-tempa)
    (gimp-floating-sel-anchor (car (gimp-edit-paste layer-tempd 0)))
    (if (eqv? wild? TRUE)
        (begin
    (plug-in-gimpressionist 1 img layer-tempd "graphite2.txt")
      ))
    (gimp-layer-set-mode layer-tempd 19)
    (gimp-image-merge-down img layer-tempd 0)
    (set! layer-tempa (car (gimp-image-get-active-layer img)))

    (if (eqv? canvas? TRUE)
        (begin
    (gimp-image-insert-layer img layer-tempe 0 -1)
    (gimp-context-set-foreground '(234 220 190))
    (gimp-drawable-fill layer-tempe 0)
    (plug-in-apply-canvas 1 img layer-tempe 1 1)
    (gimp-layer-set-mode layer-tempa 9)
    (gimp-image-lower-item img layer-tempe)
    (gimp-image-merge-down img layer-tempa 0)
    (set! layer-tempa (car (gimp-image-get-active-layer img)))
       ))

;-------------------------------------------------------
    (gimp-image-select-item img CHANNEL-OP-REPLACE old-selection)
    (gimp-selection-invert img)
    (if (eqv? (car (gimp-selection-is-empty img)) FALSE) ; both Empty and All are denied
        (begin
        (gimp-edit-clear layer-tempa)
        ))

    (gimp-item-set-name layer-tempa "Conte")
    (gimp-image-select-item img CHANNEL-OP-REPLACE old-selection)
    (gimp-image-remove-channel img old-selection)


    (gimp-image-undo-group-end img)
    (gimp-displays-flush)
  )
)

(script-fu-register
  "FU-conte"
  "<Image>/Script-Fu/Artist/Conte - charcoal crayon"
  "Creates an image that looks like a conte sketch."
  "Eddy Verlinden <eddy_verlinden@hotmail.com>"
  "Eddy Verlinden"
  "2007, juli"
  "RGB*"
  SF-IMAGE      "Image"	            0
  SF-DRAWABLE   "Drawable"          0
  SF-ADJUSTMENT "Brightness"        '(50 -100 100 1 10 0 0)
  SF-ADJUSTMENT "Contrast"          '(80 -100 100 1 10 0 0)
  SF-TOGGLE     "Wild" TRUE
  SF-TOGGLE     "Canvas" TRUE
)
