/* ImageCache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ImageCache.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#define GAME_HUB_PROJECT_CONFIG_PROJECT_NAME "com.github.tkashkin.gamehub"
#define GAME_HUB_UTILS_FS_UTILS_PATHS_CACHE_Home "~/.cache/" GAME_HUB_PROJECT_CONFIG_PROJECT_NAME
#define GAME_HUB_UTILS_FS_UTILS_PATHS_CACHE_Graphics GAME_HUB_UTILS_FS_UTILS_PATHS_CACHE_Home "/graphics"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_UTILS_TYPE_IMAGE_CACHE (game_hub_utils_image_cache_get_type ())
#define GAME_HUB_UTILS_IMAGE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_IMAGE_CACHE, GameHubUtilsImageCache))
#define GAME_HUB_UTILS_IMAGE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_IMAGE_CACHE, GameHubUtilsImageCacheClass))
#define GAME_HUB_UTILS_IS_IMAGE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_IMAGE_CACHE))
#define GAME_HUB_UTILS_IS_IMAGE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_IMAGE_CACHE))
#define GAME_HUB_UTILS_IMAGE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_IMAGE_CACHE, GameHubUtilsImageCacheClass))

typedef struct _GameHubUtilsImageCache GameHubUtilsImageCache;
typedef struct _GameHubUtilsImageCacheClass GameHubUtilsImageCacheClass;
typedef struct _GameHubUtilsImageCachePrivate GameHubUtilsImageCachePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO (game_hub_utils_downloader_download_info_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO, GameHubUtilsDownloaderDownloadInfo))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO, GameHubUtilsDownloaderDownloadInfoClass))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD_INFO, GameHubUtilsDownloaderDownloadInfoClass))

typedef struct _GameHubUtilsDownloaderDownloadInfo GameHubUtilsDownloaderDownloadInfo;
typedef struct _GameHubUtilsDownloaderDownloadInfoClass GameHubUtilsDownloaderDownloadInfoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameHubUtilsImageCacheCacheImageData GameHubUtilsImageCacheCacheImageData;
typedef struct _GameHubUtilsImageCacheLoadData GameHubUtilsImageCacheLoadData;
typedef struct _GameHubUtilsParamSpecImageCache GameHubUtilsParamSpecImageCache;

struct _GameHubUtilsImageCache {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsImageCachePrivate * priv;
};

struct _GameHubUtilsImageCacheClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsImageCache *self);
};

struct _GameHubUtilsImageCacheCacheImageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* prefix;
	gchar* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeArrayList* _tmp2_;
	GFile* remote;
	GFile* _tmp3_;
	GFile* cached;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	GError* e;
	GeeArrayList* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_;
};

struct _GameHubUtilsImageCacheLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* prefix;
	GdkPixbuf* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeArrayList* _tmp2_;
	gchar* cached;
	gchar* _tmp3_;
	GdkPixbuf* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp8_;
	GError* _inner_error0_;
};

struct _GameHubUtilsParamSpecImageCache {
	GParamSpec parent_instance;
};

static gpointer game_hub_utils_image_cache_parent_class = NULL;
VALA_EXTERN gchar* game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX;
gchar* game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX = NULL;
static GeeArrayList* game_hub_utils_image_cache_failed_urls;
static GeeArrayList* game_hub_utils_image_cache_failed_urls = NULL;
VALA_EXTERN gboolean game_hub_application_log_verbose;

VALA_EXTERN gpointer game_hub_utils_image_cache_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_image_cache_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_image_cache (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_image_cache (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_image_cache (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_image_cache (const GValue* value);
VALA_EXTERN GType game_hub_utils_image_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsImageCache, game_hub_utils_image_cache_unref)
VALA_EXTERN GFile* game_hub_utils_image_cache_local_file (const gchar* url,
                                              const gchar* prefix);
VALA_EXTERN gchar* game_hub_utils_md5 (const gchar* s);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
static void game_hub_utils_image_cache_cache_image_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_image_cache_cache_image (const gchar* url,
                                             const gchar* prefix,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gchar* game_hub_utils_image_cache_cache_image_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_image_cache_cache_image_co (GameHubUtilsImageCacheCacheImageData* _data_);
VALA_EXTERN GType game_hub_utils_downloader_download_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownloadInfo, g_object_unref)
VALA_EXTERN void game_hub_utils_downloader_download_file (GFile* remote,
                                              GFile* local,
                                              GameHubUtilsDownloaderDownloadInfo* info,
                                              gboolean preserve_filename,
                                              gboolean queue,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GFile* game_hub_utils_downloader_download_file_finish (GAsyncResult* _res_,
                                                       GError** error);
static void game_hub_utils_image_cache_cache_image_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void game_hub_utils_image_cache_load_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_image_cache_load (const gchar* url,
                                      const gchar* prefix,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN GdkPixbuf* game_hub_utils_image_cache_load_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_image_cache_load_co (GameHubUtilsImageCacheLoadData* _data_);
static void game_hub_utils_image_cache_load_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN void game_hub_utils_image_cache_init (void);
VALA_EXTERN GameHubUtilsImageCache* game_hub_utils_image_cache_new (void);
VALA_EXTERN GameHubUtilsImageCache* game_hub_utils_image_cache_construct (GType object_type);
static void game_hub_utils_image_cache_finalize (GameHubUtilsImageCache * obj);
static GType game_hub_utils_image_cache_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 234 "ImageCache.c"
}

GFile*
game_hub_utils_image_cache_local_file (const gchar* url,
                                       const gchar* prefix)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar** parts = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* ext = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gchar* _tmp24_;
	gchar* hash = NULL;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GFile* result;
#line 34 "../src/utils/ImageCache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 36 "../src/utils/ImageCache.vala"
	if (url == NULL) {
#line 36 "../src/utils/ImageCache.vala"
		_tmp1_ = TRUE;
#line 282 "ImageCache.c"
	} else {
#line 36 "../src/utils/ImageCache.vala"
		_tmp1_ = g_strcmp0 (url, "") == 0;
#line 286 "ImageCache.c"
	}
#line 36 "../src/utils/ImageCache.vala"
	if (_tmp1_) {
#line 36 "../src/utils/ImageCache.vala"
		_tmp0_ = TRUE;
#line 292 "ImageCache.c"
	} else {
		GeeArrayList* _tmp2_;
#line 36 "../src/utils/ImageCache.vala"
		_tmp2_ = game_hub_utils_image_cache_failed_urls;
#line 36 "../src/utils/ImageCache.vala"
		_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, url);
#line 299 "ImageCache.c"
	}
#line 36 "../src/utils/ImageCache.vala"
	if (_tmp0_) {
#line 36 "../src/utils/ImageCache.vala"
		result = NULL;
#line 36 "../src/utils/ImageCache.vala"
		return result;
#line 307 "ImageCache.c"
	}
#line 37 "../src/utils/ImageCache.vala"
	_tmp4_ = _tmp3_ = g_strsplit (url, "?", 0);
#line 37 "../src/utils/ImageCache.vala"
	_tmp5_ = _tmp4_;
#line 37 "../src/utils/ImageCache.vala"
	_tmp5__length1 = _vala_array_length (_tmp3_);
#line 37 "../src/utils/ImageCache.vala"
	_tmp6_ = _tmp5_[0];
#line 37 "../src/utils/ImageCache.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ".", 0);
#line 37 "../src/utils/ImageCache.vala"
	_tmp9_ = _tmp8_;
#line 37 "../src/utils/ImageCache.vala"
	_tmp9__length1 = _vala_array_length (_tmp7_);
#line 37 "../src/utils/ImageCache.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 37 "../src/utils/ImageCache.vala"
	parts = _tmp9_;
#line 37 "../src/utils/ImageCache.vala"
	parts_length1 = _tmp9__length1;
#line 37 "../src/utils/ImageCache.vala"
	_parts_size_ = parts_length1;
#line 38 "../src/utils/ImageCache.vala"
	_tmp11_ = parts;
#line 38 "../src/utils/ImageCache.vala"
	_tmp11__length1 = parts_length1;
#line 38 "../src/utils/ImageCache.vala"
	if (_tmp11__length1 > 1) {
#line 337 "ImageCache.c"
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
#line 38 "../src/utils/ImageCache.vala"
		_tmp12_ = parts;
#line 38 "../src/utils/ImageCache.vala"
		_tmp12__length1 = parts_length1;
#line 38 "../src/utils/ImageCache.vala"
		_tmp13_ = parts;
#line 38 "../src/utils/ImageCache.vala"
		_tmp13__length1 = parts_length1;
#line 38 "../src/utils/ImageCache.vala"
		_tmp14_ = _tmp12_[_tmp13__length1 - 1];
#line 38 "../src/utils/ImageCache.vala"
		_tmp10_ = _tmp14_;
#line 355 "ImageCache.c"
	} else {
#line 38 "../src/utils/ImageCache.vala"
		_tmp10_ = NULL;
#line 359 "ImageCache.c"
	}
#line 38 "../src/utils/ImageCache.vala"
	_tmp15_ = g_strdup (_tmp10_);
#line 38 "../src/utils/ImageCache.vala"
	ext = _tmp15_;
#line 39 "../src/utils/ImageCache.vala"
	_tmp18_ = ext;
#line 39 "../src/utils/ImageCache.vala"
	if (_tmp18_ != NULL) {
#line 369 "ImageCache.c"
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
#line 39 "../src/utils/ImageCache.vala"
		_tmp19_ = ext;
#line 39 "../src/utils/ImageCache.vala"
		_tmp20_ = strlen (_tmp19_);
#line 39 "../src/utils/ImageCache.vala"
		_tmp21_ = _tmp20_;
#line 39 "../src/utils/ImageCache.vala"
		_tmp17_ = _tmp21_ <= 6;
#line 381 "ImageCache.c"
	} else {
#line 39 "../src/utils/ImageCache.vala"
		_tmp17_ = FALSE;
#line 385 "ImageCache.c"
	}
#line 39 "../src/utils/ImageCache.vala"
	if (_tmp17_) {
#line 389 "ImageCache.c"
		const gchar* _tmp22_;
		gchar* _tmp23_;
#line 39 "../src/utils/ImageCache.vala"
		_tmp22_ = ext;
#line 39 "../src/utils/ImageCache.vala"
		_tmp23_ = g_strconcat (".", _tmp22_, NULL);
#line 39 "../src/utils/ImageCache.vala"
		_g_free0 (_tmp16_);
#line 39 "../src/utils/ImageCache.vala"
		_tmp16_ = _tmp23_;
#line 400 "ImageCache.c"
	} else {
#line 39 "../src/utils/ImageCache.vala"
		_g_free0 (_tmp16_);
#line 39 "../src/utils/ImageCache.vala"
		_tmp16_ = NULL;
#line 406 "ImageCache.c"
	}
#line 39 "../src/utils/ImageCache.vala"
	_tmp24_ = g_strdup (_tmp16_);
#line 39 "../src/utils/ImageCache.vala"
	_g_free0 (ext);
#line 39 "../src/utils/ImageCache.vala"
	ext = _tmp24_;
#line 40 "../src/utils/ImageCache.vala"
	_tmp25_ = game_hub_utils_md5 (url);
#line 40 "../src/utils/ImageCache.vala"
	hash = _tmp25_;
#line 41 "../src/utils/ImageCache.vala"
	_tmp26_ = string_to_string (prefix);
#line 41 "../src/utils/ImageCache.vala"
	_tmp27_ = hash;
#line 41 "../src/utils/ImageCache.vala"
	_tmp28_ = string_to_string (_tmp27_);
#line 41 "../src/utils/ImageCache.vala"
	_tmp29_ = ext;
#line 41 "../src/utils/ImageCache.vala"
	_tmp30_ = string_to_string (_tmp29_);
#line 41 "../src/utils/ImageCache.vala"
	_tmp31_ = g_strconcat (_tmp26_, _tmp28_, _tmp30_, NULL);
#line 41 "../src/utils/ImageCache.vala"
	_tmp32_ = _tmp31_;
#line 41 "../src/utils/ImageCache.vala"
	_tmp33_ = game_hub_utils_fs_utils_file (GAME_HUB_UTILS_FS_UTILS_PATHS_CACHE_Graphics, _tmp32_, NULL);
#line 41 "../src/utils/ImageCache.vala"
	_tmp34_ = _tmp33_;
#line 41 "../src/utils/ImageCache.vala"
	_g_free0 (_tmp32_);
#line 41 "../src/utils/ImageCache.vala"
	result = _tmp34_;
#line 41 "../src/utils/ImageCache.vala"
	_g_free0 (hash);
#line 41 "../src/utils/ImageCache.vala"
	_g_free0 (_tmp16_);
#line 41 "../src/utils/ImageCache.vala"
	_g_free0 (ext);
#line 41 "../src/utils/ImageCache.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 41 "../src/utils/ImageCache.vala"
	return result;
#line 450 "ImageCache.c"
}

static void
game_hub_utils_image_cache_cache_image_data_free (gpointer _data)
{
	GameHubUtilsImageCacheCacheImageData* _data_;
	_data_ = _data;
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->url);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->prefix);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->result);
#line 24 "../src/utils/ImageCache.vala"
	g_slice_free (GameHubUtilsImageCacheCacheImageData, _data_);
#line 466 "ImageCache.c"
}

void
game_hub_utils_image_cache_cache_image (const gchar* url,
                                        const gchar* prefix,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GameHubUtilsImageCacheCacheImageData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 24 "../src/utils/ImageCache.vala"
	g_return_if_fail (prefix != NULL);
#line 24 "../src/utils/ImageCache.vala"
	_data_ = g_slice_new0 (GameHubUtilsImageCacheCacheImageData);
#line 24 "../src/utils/ImageCache.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 24 "../src/utils/ImageCache.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_image_cache_cache_image_data_free);
#line 24 "../src/utils/ImageCache.vala"
	_tmp0_ = g_strdup (url);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->url);
#line 24 "../src/utils/ImageCache.vala"
	_data_->url = _tmp0_;
#line 24 "../src/utils/ImageCache.vala"
	_tmp1_ = g_strdup (prefix);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->prefix);
#line 24 "../src/utils/ImageCache.vala"
	_data_->prefix = _tmp1_;
#line 24 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_cache_image_co (_data_);
#line 500 "ImageCache.c"
}

gchar*
game_hub_utils_image_cache_cache_image_finish (GAsyncResult* _res_)
{
	gchar* result;
	GameHubUtilsImageCacheCacheImageData* _data_;
#line 24 "../src/utils/ImageCache.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "../src/utils/ImageCache.vala"
	result = _data_->result;
#line 24 "../src/utils/ImageCache.vala"
	_data_->result = NULL;
#line 24 "../src/utils/ImageCache.vala"
	return result;
#line 516 "ImageCache.c"
}

static void
game_hub_utils_image_cache_cache_image_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GameHubUtilsImageCacheCacheImageData* _data_;
#line 57 "../src/utils/ImageCache.vala"
	_data_ = _user_data_;
#line 57 "../src/utils/ImageCache.vala"
	_data_->_source_object_ = source_object;
#line 57 "../src/utils/ImageCache.vala"
	_data_->_res_ = _res_;
#line 57 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_cache_image_co (_data_);
#line 533 "ImageCache.c"
}

static gboolean
game_hub_utils_image_cache_cache_image_co (GameHubUtilsImageCacheCacheImageData* _data_)
{
#line 44 "../src/utils/ImageCache.vala"
	switch (_data_->_state_) {
#line 44 "../src/utils/ImageCache.vala"
		case 0:
#line 543 "ImageCache.c"
		goto _state_0;
#line 44 "../src/utils/ImageCache.vala"
		case 1:
#line 547 "ImageCache.c"
		goto _state_1;
		default:
#line 44 "../src/utils/ImageCache.vala"
		g_assert_not_reached ();
#line 552 "ImageCache.c"
	}
	_state_0:
#line 46 "../src/utils/ImageCache.vala"
	if (_data_->url == NULL) {
#line 46 "../src/utils/ImageCache.vala"
		_data_->_tmp1_ = TRUE;
#line 559 "ImageCache.c"
	} else {
#line 46 "../src/utils/ImageCache.vala"
		_data_->_tmp1_ = g_strcmp0 (_data_->url, "") == 0;
#line 563 "ImageCache.c"
	}
#line 46 "../src/utils/ImageCache.vala"
	if (_data_->_tmp1_) {
#line 46 "../src/utils/ImageCache.vala"
		_data_->_tmp0_ = TRUE;
#line 569 "ImageCache.c"
	} else {
#line 46 "../src/utils/ImageCache.vala"
		_data_->_tmp2_ = game_hub_utils_image_cache_failed_urls;
#line 46 "../src/utils/ImageCache.vala"
		_data_->_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp2_, _data_->url);
#line 575 "ImageCache.c"
	}
#line 46 "../src/utils/ImageCache.vala"
	if (_data_->_tmp0_) {
#line 46 "../src/utils/ImageCache.vala"
		_data_->result = NULL;
#line 46 "../src/utils/ImageCache.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 46 "../src/utils/ImageCache.vala"
		if (_data_->_state_ != 0) {
#line 46 "../src/utils/ImageCache.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 46 "../src/utils/ImageCache.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 589 "ImageCache.c"
			}
		}
#line 46 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 46 "../src/utils/ImageCache.vala"
		return FALSE;
#line 596 "ImageCache.c"
	}
#line 47 "../src/utils/ImageCache.vala"
	_data_->_tmp3_ = g_file_new_for_uri (_data_->url);
#line 47 "../src/utils/ImageCache.vala"
	_data_->remote = _data_->_tmp3_;
#line 48 "../src/utils/ImageCache.vala"
	_data_->_tmp4_ = game_hub_utils_image_cache_local_file (_data_->url, _data_->prefix);
#line 48 "../src/utils/ImageCache.vala"
	_data_->cached = _data_->_tmp4_;
#line 606 "ImageCache.c"
	{
#line 51 "../src/utils/ImageCache.vala"
		_data_->_tmp5_ = _data_->cached;
#line 51 "../src/utils/ImageCache.vala"
		if (!g_file_query_exists (_data_->_tmp5_, NULL)) {
#line 53 "../src/utils/ImageCache.vala"
			_data_->_tmp6_ = _data_->cached;
#line 53 "../src/utils/ImageCache.vala"
			_data_->_tmp7_ = g_file_get_parent (_data_->_tmp6_);
#line 53 "../src/utils/ImageCache.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 53 "../src/utils/ImageCache.vala"
			_data_->_tmp9_ = !g_file_query_exists (_data_->_tmp8_, NULL);
#line 53 "../src/utils/ImageCache.vala"
			_g_object_unref0 (_data_->_tmp8_);
#line 53 "../src/utils/ImageCache.vala"
			if (_data_->_tmp9_) {
#line 55 "../src/utils/ImageCache.vala"
				_data_->_tmp10_ = _data_->cached;
#line 55 "../src/utils/ImageCache.vala"
				_data_->_tmp11_ = g_file_get_parent (_data_->_tmp10_);
#line 55 "../src/utils/ImageCache.vala"
				_data_->_tmp12_ = _data_->_tmp11_;
#line 55 "../src/utils/ImageCache.vala"
				g_file_make_directory_with_parents (_data_->_tmp12_, NULL, &_data_->_inner_error0_);
#line 55 "../src/utils/ImageCache.vala"
				_g_object_unref0 (_data_->_tmp12_);
#line 55 "../src/utils/ImageCache.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 55 "../src/utils/ImageCache.vala"
					if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 638 "ImageCache.c"
						goto __catch0_g_io_error_exists;
					}
					goto __catch0_g_error;
				}
			}
#line 57 "../src/utils/ImageCache.vala"
			_data_->_tmp13_ = _data_->remote;
#line 57 "../src/utils/ImageCache.vala"
			_data_->_tmp14_ = _data_->cached;
#line 57 "../src/utils/ImageCache.vala"
			_data_->_state_ = 1;
#line 57 "../src/utils/ImageCache.vala"
			game_hub_utils_downloader_download_file (_data_->_tmp13_, _data_->_tmp14_, NULL, FALSE, FALSE, game_hub_utils_image_cache_cache_image_ready, _data_);
#line 57 "../src/utils/ImageCache.vala"
			return FALSE;
#line 654 "ImageCache.c"
			_state_1:
#line 57 "../src/utils/ImageCache.vala"
			_data_->_tmp15_ = game_hub_utils_downloader_download_file_finish (_data_->_res_, &_data_->_inner_error0_);
#line 57 "../src/utils/ImageCache.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 57 "../src/utils/ImageCache.vala"
			_g_object_unref0 (_data_->_tmp16_);
#line 57 "../src/utils/ImageCache.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 57 "../src/utils/ImageCache.vala"
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 666 "ImageCache.c"
					goto __catch0_g_io_error_exists;
				}
				goto __catch0_g_error;
			}
		}
#line 59 "../src/utils/ImageCache.vala"
		_data_->_tmp17_ = _data_->cached;
#line 59 "../src/utils/ImageCache.vala"
		_data_->_tmp18_ = g_file_get_path (_data_->_tmp17_);
#line 59 "../src/utils/ImageCache.vala"
		_data_->result = _data_->_tmp18_;
#line 59 "../src/utils/ImageCache.vala"
		_g_object_unref0 (_data_->cached);
#line 59 "../src/utils/ImageCache.vala"
		_g_object_unref0 (_data_->remote);
#line 59 "../src/utils/ImageCache.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 59 "../src/utils/ImageCache.vala"
		if (_data_->_state_ != 0) {
#line 59 "../src/utils/ImageCache.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 59 "../src/utils/ImageCache.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 690 "ImageCache.c"
			}
		}
#line 59 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 59 "../src/utils/ImageCache.vala"
		return FALSE;
#line 697 "ImageCache.c"
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
#line 49 "../src/utils/ImageCache.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 704 "ImageCache.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 49 "../src/utils/ImageCache.vala"
		_data_->e = _data_->_inner_error0_;
#line 49 "../src/utils/ImageCache.vala"
		_data_->_inner_error0_ = NULL;
#line 64 "../src/utils/ImageCache.vala"
		_data_->_tmp19_ = game_hub_utils_image_cache_failed_urls;
#line 64 "../src/utils/ImageCache.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp19_, _data_->url);
#line 65 "../src/utils/ImageCache.vala"
		if (game_hub_application_log_verbose) {
#line 67 "../src/utils/ImageCache.vala"
			_data_->_tmp20_ = _data_->e;
#line 67 "../src/utils/ImageCache.vala"
			_data_->_tmp21_ = _data_->_tmp20_->message;
#line 67 "../src/utils/ImageCache.vala"
			g_warning ("ImageCache.vala:67: [ImageCache] Error loading image '%s': %s", _data_->url, _data_->_tmp21_);
#line 725 "ImageCache.c"
		}
#line 49 "../src/utils/ImageCache.vala"
		_g_error_free0 (_data_->e);
#line 729 "ImageCache.c"
	}
	__finally0:
#line 49 "../src/utils/ImageCache.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 49 "../src/utils/ImageCache.vala"
		_g_object_unref0 (_data_->cached);
#line 49 "../src/utils/ImageCache.vala"
		_g_object_unref0 (_data_->remote);
#line 49 "../src/utils/ImageCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 49 "../src/utils/ImageCache.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 49 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 49 "../src/utils/ImageCache.vala"
		return FALSE;
#line 746 "ImageCache.c"
	}
#line 70 "../src/utils/ImageCache.vala"
	_data_->result = NULL;
#line 70 "../src/utils/ImageCache.vala"
	_g_object_unref0 (_data_->cached);
#line 70 "../src/utils/ImageCache.vala"
	_g_object_unref0 (_data_->remote);
#line 70 "../src/utils/ImageCache.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 70 "../src/utils/ImageCache.vala"
	if (_data_->_state_ != 0) {
#line 70 "../src/utils/ImageCache.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 70 "../src/utils/ImageCache.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 762 "ImageCache.c"
		}
	}
#line 70 "../src/utils/ImageCache.vala"
	g_object_unref (_data_->_async_result);
#line 70 "../src/utils/ImageCache.vala"
	return FALSE;
#line 769 "ImageCache.c"
}

static void
game_hub_utils_image_cache_load_data_free (gpointer _data)
{
	GameHubUtilsImageCacheLoadData* _data_;
	_data_ = _data;
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->url);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->prefix);
#line 24 "../src/utils/ImageCache.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../src/utils/ImageCache.vala"
	g_slice_free (GameHubUtilsImageCacheLoadData, _data_);
#line 785 "ImageCache.c"
}

void
game_hub_utils_image_cache_load (const gchar* url,
                                 const gchar* prefix,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GameHubUtilsImageCacheLoadData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 24 "../src/utils/ImageCache.vala"
	g_return_if_fail (prefix != NULL);
#line 24 "../src/utils/ImageCache.vala"
	_data_ = g_slice_new0 (GameHubUtilsImageCacheLoadData);
#line 24 "../src/utils/ImageCache.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 24 "../src/utils/ImageCache.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_image_cache_load_data_free);
#line 24 "../src/utils/ImageCache.vala"
	_tmp0_ = g_strdup (url);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->url);
#line 24 "../src/utils/ImageCache.vala"
	_data_->url = _tmp0_;
#line 24 "../src/utils/ImageCache.vala"
	_tmp1_ = g_strdup (prefix);
#line 24 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->prefix);
#line 24 "../src/utils/ImageCache.vala"
	_data_->prefix = _tmp1_;
#line 24 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_load_co (_data_);
#line 819 "ImageCache.c"
}

GdkPixbuf*
game_hub_utils_image_cache_load_finish (GAsyncResult* _res_)
{
	GdkPixbuf* result;
	GameHubUtilsImageCacheLoadData* _data_;
#line 24 "../src/utils/ImageCache.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "../src/utils/ImageCache.vala"
	result = _data_->result;
#line 24 "../src/utils/ImageCache.vala"
	_data_->result = NULL;
#line 24 "../src/utils/ImageCache.vala"
	return result;
#line 835 "ImageCache.c"
}

static void
game_hub_utils_image_cache_load_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GameHubUtilsImageCacheLoadData* _data_;
#line 81 "../src/utils/ImageCache.vala"
	_data_ = _user_data_;
#line 81 "../src/utils/ImageCache.vala"
	_data_->_source_object_ = source_object;
#line 81 "../src/utils/ImageCache.vala"
	_data_->_res_ = _res_;
#line 81 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_load_co (_data_);
#line 852 "ImageCache.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 84 "../src/utils/ImageCache.vala"
	return self ? g_object_ref (self) : NULL;
#line 860 "ImageCache.c"
}

static gboolean
game_hub_utils_image_cache_load_co (GameHubUtilsImageCacheLoadData* _data_)
{
#line 73 "../src/utils/ImageCache.vala"
	switch (_data_->_state_) {
#line 73 "../src/utils/ImageCache.vala"
		case 0:
#line 870 "ImageCache.c"
		goto _state_0;
#line 73 "../src/utils/ImageCache.vala"
		case 1:
#line 874 "ImageCache.c"
		goto _state_1;
		default:
#line 73 "../src/utils/ImageCache.vala"
		g_assert_not_reached ();
#line 879 "ImageCache.c"
	}
	_state_0:
#line 75 "../src/utils/ImageCache.vala"
	if (_data_->url == NULL) {
#line 75 "../src/utils/ImageCache.vala"
		_data_->_tmp1_ = TRUE;
#line 886 "ImageCache.c"
	} else {
#line 75 "../src/utils/ImageCache.vala"
		_data_->_tmp1_ = g_strcmp0 (_data_->url, "") == 0;
#line 890 "ImageCache.c"
	}
#line 75 "../src/utils/ImageCache.vala"
	if (_data_->_tmp1_) {
#line 75 "../src/utils/ImageCache.vala"
		_data_->_tmp0_ = TRUE;
#line 896 "ImageCache.c"
	} else {
#line 75 "../src/utils/ImageCache.vala"
		_data_->_tmp2_ = game_hub_utils_image_cache_failed_urls;
#line 75 "../src/utils/ImageCache.vala"
		_data_->_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp2_, _data_->url);
#line 902 "ImageCache.c"
	}
#line 75 "../src/utils/ImageCache.vala"
	if (_data_->_tmp0_) {
#line 75 "../src/utils/ImageCache.vala"
		_data_->result = NULL;
#line 75 "../src/utils/ImageCache.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 75 "../src/utils/ImageCache.vala"
		if (_data_->_state_ != 0) {
#line 75 "../src/utils/ImageCache.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 75 "../src/utils/ImageCache.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 916 "ImageCache.c"
			}
		}
#line 75 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 75 "../src/utils/ImageCache.vala"
		return FALSE;
#line 923 "ImageCache.c"
	}
#line 81 "../src/utils/ImageCache.vala"
	_data_->_state_ = 1;
#line 81 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_cache_image (_data_->url, _data_->prefix, game_hub_utils_image_cache_load_ready, _data_);
#line 81 "../src/utils/ImageCache.vala"
	return FALSE;
#line 931 "ImageCache.c"
	_state_1:
#line 81 "../src/utils/ImageCache.vala"
	_data_->_tmp3_ = game_hub_utils_image_cache_cache_image_finish (_data_->_res_);
#line 81 "../src/utils/ImageCache.vala"
	_data_->cached = _data_->_tmp3_;
#line 937 "ImageCache.c"
	{
#line 84 "../src/utils/ImageCache.vala"
		_data_->_tmp5_ = _data_->cached;
#line 84 "../src/utils/ImageCache.vala"
		if (_data_->_tmp5_ != NULL) {
#line 84 "../src/utils/ImageCache.vala"
			_data_->_tmp6_ = _data_->cached;
#line 84 "../src/utils/ImageCache.vala"
			_data_->_tmp7_ = gdk_pixbuf_new_from_file (_data_->_tmp6_, &_data_->_inner_error0_);
#line 84 "../src/utils/ImageCache.vala"
			_g_object_unref0 (_data_->_tmp4_);
#line 84 "../src/utils/ImageCache.vala"
			_data_->_tmp4_ = _data_->_tmp7_;
#line 84 "../src/utils/ImageCache.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 84 "../src/utils/ImageCache.vala"
				_g_object_unref0 (_data_->_tmp4_);
#line 955 "ImageCache.c"
				goto __catch0_g_error;
			}
		} else {
#line 84 "../src/utils/ImageCache.vala"
			_g_object_unref0 (_data_->_tmp4_);
#line 84 "../src/utils/ImageCache.vala"
			_data_->_tmp4_ = NULL;
#line 963 "ImageCache.c"
		}
#line 84 "../src/utils/ImageCache.vala"
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp4_);
#line 84 "../src/utils/ImageCache.vala"
		_data_->pixbuf = _data_->_tmp8_;
#line 90 "../src/utils/ImageCache.vala"
		_data_->result = _data_->pixbuf;
#line 90 "../src/utils/ImageCache.vala"
		_g_object_unref0 (_data_->_tmp4_);
#line 90 "../src/utils/ImageCache.vala"
		_g_free0 (_data_->cached);
#line 90 "../src/utils/ImageCache.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 90 "../src/utils/ImageCache.vala"
		if (_data_->_state_ != 0) {
#line 90 "../src/utils/ImageCache.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 90 "../src/utils/ImageCache.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 983 "ImageCache.c"
			}
		}
#line 90 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 90 "../src/utils/ImageCache.vala"
		return FALSE;
#line 990 "ImageCache.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 82 "../src/utils/ImageCache.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 997 "ImageCache.c"
	}
	__finally0:
#line 82 "../src/utils/ImageCache.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 82 "../src/utils/ImageCache.vala"
		_g_free0 (_data_->cached);
#line 82 "../src/utils/ImageCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 82 "../src/utils/ImageCache.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 82 "../src/utils/ImageCache.vala"
		g_object_unref (_data_->_async_result);
#line 82 "../src/utils/ImageCache.vala"
		return FALSE;
#line 1012 "ImageCache.c"
	}
#line 94 "../src/utils/ImageCache.vala"
	_data_->result = NULL;
#line 94 "../src/utils/ImageCache.vala"
	_g_free0 (_data_->cached);
#line 94 "../src/utils/ImageCache.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 94 "../src/utils/ImageCache.vala"
	if (_data_->_state_ != 0) {
#line 94 "../src/utils/ImageCache.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 94 "../src/utils/ImageCache.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1026 "ImageCache.c"
		}
	}
#line 94 "../src/utils/ImageCache.vala"
	g_object_unref (_data_->_async_result);
#line 94 "../src/utils/ImageCache.vala"
	return FALSE;
#line 1033 "ImageCache.c"
}

void
game_hub_utils_image_cache_init (void)
{
	GeeArrayList* _tmp0_;
#line 99 "../src/utils/ImageCache.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 99 "../src/utils/ImageCache.vala"
	_g_object_unref0 (game_hub_utils_image_cache_failed_urls);
#line 99 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_failed_urls = _tmp0_;
#line 1046 "ImageCache.c"
}

GameHubUtilsImageCache*
game_hub_utils_image_cache_construct (GType object_type)
{
	GameHubUtilsImageCache* self = NULL;
#line 24 "../src/utils/ImageCache.vala"
	self = (GameHubUtilsImageCache*) g_type_create_instance (object_type);
#line 24 "../src/utils/ImageCache.vala"
	return self;
#line 1057 "ImageCache.c"
}

GameHubUtilsImageCache*
game_hub_utils_image_cache_new (void)
{
#line 24 "../src/utils/ImageCache.vala"
	return game_hub_utils_image_cache_construct (GAME_HUB_UTILS_TYPE_IMAGE_CACHE);
#line 1065 "ImageCache.c"
}

static void
game_hub_utils_value_image_cache_init (GValue* value)
{
#line 24 "../src/utils/ImageCache.vala"
	value->data[0].v_pointer = NULL;
#line 1073 "ImageCache.c"
}

static void
game_hub_utils_value_image_cache_free_value (GValue* value)
{
#line 24 "../src/utils/ImageCache.vala"
	if (value->data[0].v_pointer) {
#line 24 "../src/utils/ImageCache.vala"
		game_hub_utils_image_cache_unref (value->data[0].v_pointer);
#line 1083 "ImageCache.c"
	}
}

static void
game_hub_utils_value_image_cache_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 24 "../src/utils/ImageCache.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "../src/utils/ImageCache.vala"
		dest_value->data[0].v_pointer = game_hub_utils_image_cache_ref (src_value->data[0].v_pointer);
#line 1095 "ImageCache.c"
	} else {
#line 24 "../src/utils/ImageCache.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1099 "ImageCache.c"
	}
}

static gpointer
game_hub_utils_value_image_cache_peek_pointer (const GValue* value)
{
#line 24 "../src/utils/ImageCache.vala"
	return value->data[0].v_pointer;
#line 1108 "ImageCache.c"
}

static gchar*
game_hub_utils_value_image_cache_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 24 "../src/utils/ImageCache.vala"
	if (collect_values[0].v_pointer) {
#line 1119 "ImageCache.c"
		GameHubUtilsImageCache * object;
		object = collect_values[0].v_pointer;
#line 24 "../src/utils/ImageCache.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "../src/utils/ImageCache.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1126 "ImageCache.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "../src/utils/ImageCache.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1130 "ImageCache.c"
		}
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = game_hub_utils_image_cache_ref (object);
#line 1134 "ImageCache.c"
	} else {
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = NULL;
#line 1138 "ImageCache.c"
	}
#line 24 "../src/utils/ImageCache.vala"
	return NULL;
#line 1142 "ImageCache.c"
}

static gchar*
game_hub_utils_value_image_cache_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	GameHubUtilsImageCache ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "../src/utils/ImageCache.vala"
	if (!object_p) {
#line 24 "../src/utils/ImageCache.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1157 "ImageCache.c"
	}
#line 24 "../src/utils/ImageCache.vala"
	if (!value->data[0].v_pointer) {
#line 24 "../src/utils/ImageCache.vala"
		*object_p = NULL;
#line 1163 "ImageCache.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "../src/utils/ImageCache.vala"
		*object_p = value->data[0].v_pointer;
#line 1167 "ImageCache.c"
	} else {
#line 24 "../src/utils/ImageCache.vala"
		*object_p = game_hub_utils_image_cache_ref (value->data[0].v_pointer);
#line 1171 "ImageCache.c"
	}
#line 24 "../src/utils/ImageCache.vala"
	return NULL;
#line 1175 "ImageCache.c"
}

GParamSpec*
game_hub_utils_param_spec_image_cache (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	GameHubUtilsParamSpecImageCache* spec;
#line 24 "../src/utils/ImageCache.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_UTILS_TYPE_IMAGE_CACHE), NULL);
#line 24 "../src/utils/ImageCache.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "../src/utils/ImageCache.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "../src/utils/ImageCache.vala"
	return G_PARAM_SPEC (spec);
#line 1194 "ImageCache.c"
}

gpointer
game_hub_utils_value_get_image_cache (const GValue* value)
{
#line 24 "../src/utils/ImageCache.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_IMAGE_CACHE), NULL);
#line 24 "../src/utils/ImageCache.vala"
	return value->data[0].v_pointer;
#line 1204 "ImageCache.c"
}

void
game_hub_utils_value_set_image_cache (GValue* value,
                                      gpointer v_object)
{
	GameHubUtilsImageCache * old;
#line 24 "../src/utils/ImageCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_IMAGE_CACHE));
#line 24 "../src/utils/ImageCache.vala"
	old = value->data[0].v_pointer;
#line 24 "../src/utils/ImageCache.vala"
	if (v_object) {
#line 24 "../src/utils/ImageCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_IMAGE_CACHE));
#line 24 "../src/utils/ImageCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = v_object;
#line 24 "../src/utils/ImageCache.vala"
		game_hub_utils_image_cache_ref (value->data[0].v_pointer);
#line 1226 "ImageCache.c"
	} else {
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = NULL;
#line 1230 "ImageCache.c"
	}
#line 24 "../src/utils/ImageCache.vala"
	if (old) {
#line 24 "../src/utils/ImageCache.vala"
		game_hub_utils_image_cache_unref (old);
#line 1236 "ImageCache.c"
	}
}

void
game_hub_utils_value_take_image_cache (GValue* value,
                                       gpointer v_object)
{
	GameHubUtilsImageCache * old;
#line 24 "../src/utils/ImageCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_IMAGE_CACHE));
#line 24 "../src/utils/ImageCache.vala"
	old = value->data[0].v_pointer;
#line 24 "../src/utils/ImageCache.vala"
	if (v_object) {
#line 24 "../src/utils/ImageCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_IMAGE_CACHE));
#line 24 "../src/utils/ImageCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = v_object;
#line 1257 "ImageCache.c"
	} else {
#line 24 "../src/utils/ImageCache.vala"
		value->data[0].v_pointer = NULL;
#line 1261 "ImageCache.c"
	}
#line 24 "../src/utils/ImageCache.vala"
	if (old) {
#line 24 "../src/utils/ImageCache.vala"
		game_hub_utils_image_cache_unref (old);
#line 1267 "ImageCache.c"
	}
}

static void
game_hub_utils_image_cache_class_init (GameHubUtilsImageCacheClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
#line 24 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_parent_class = g_type_class_peek_parent (klass);
#line 24 "../src/utils/ImageCache.vala"
	((GameHubUtilsImageCacheClass *) klass)->finalize = game_hub_utils_image_cache_finalize;
#line 26 "../src/utils/ImageCache.vala"
	_tmp0_ = g_strdup ("images/");
#line 26 "../src/utils/ImageCache.vala"
	game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX = _tmp0_;
#line 1284 "ImageCache.c"
}

static void
game_hub_utils_image_cache_instance_init (GameHubUtilsImageCache * self,
                                          gpointer klass)
{
#line 24 "../src/utils/ImageCache.vala"
	self->ref_count = 1;
#line 1293 "ImageCache.c"
}

static void
game_hub_utils_image_cache_finalize (GameHubUtilsImageCache * obj)
{
	GameHubUtilsImageCache * self;
#line 24 "../src/utils/ImageCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_TYPE_IMAGE_CACHE, GameHubUtilsImageCache);
#line 24 "../src/utils/ImageCache.vala"
	g_signal_handlers_destroy (self);
#line 1304 "ImageCache.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_image_cache_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_utils_value_image_cache_init, game_hub_utils_value_image_cache_free_value, game_hub_utils_value_image_cache_copy_value, game_hub_utils_value_image_cache_peek_pointer, "p", game_hub_utils_value_image_cache_collect_value, "p", game_hub_utils_value_image_cache_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsImageCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_image_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsImageCache), 0, (GInstanceInitFunc) game_hub_utils_image_cache_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_utils_image_cache_type_id;
	game_hub_utils_image_cache_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubUtilsImageCache", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return game_hub_utils_image_cache_type_id;
}

GType
game_hub_utils_image_cache_get_type (void)
{
	static volatile gsize game_hub_utils_image_cache_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_image_cache_type_id__once)) {
		GType game_hub_utils_image_cache_type_id;
		game_hub_utils_image_cache_type_id = game_hub_utils_image_cache_get_type_once ();
		g_once_init_leave (&game_hub_utils_image_cache_type_id__once, game_hub_utils_image_cache_type_id);
	}
	return game_hub_utils_image_cache_type_id__once;
}

gpointer
game_hub_utils_image_cache_ref (gpointer instance)
{
	GameHubUtilsImageCache * self;
	self = instance;
#line 24 "../src/utils/ImageCache.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "../src/utils/ImageCache.vala"
	return instance;
#line 1339 "ImageCache.c"
}

void
game_hub_utils_image_cache_unref (gpointer instance)
{
	GameHubUtilsImageCache * self;
	self = instance;
#line 24 "../src/utils/ImageCache.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "../src/utils/ImageCache.vala"
		GAME_HUB_UTILS_IMAGE_CACHE_GET_CLASS (self)->finalize (self);
#line 24 "../src/utils/ImageCache.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1353 "ImageCache.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

