/* AutoSizeImage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AutoSizeImage.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE (game_hub_ui_widgets_auto_size_image_get_type ())
#define GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImage))
#define GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImageClass))
#define GAME_HUB_UI_WIDGETS_IS_AUTO_SIZE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE))
#define GAME_HUB_UI_WIDGETS_IS_AUTO_SIZE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE))
#define GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImageClass))

typedef struct _GameHubUIWidgetsAutoSizeImage GameHubUIWidgetsAutoSizeImage;
typedef struct _GameHubUIWidgetsAutoSizeImageClass GameHubUIWidgetsAutoSizeImageClass;
typedef struct _GameHubUIWidgetsAutoSizeImagePrivate GameHubUIWidgetsAutoSizeImagePrivate;
enum  {
	GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_0_PROPERTY,
	GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY,
	GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY,
	GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_NUM_PROPERTIES
};
static GParamSpec* game_hub_ui_widgets_auto_size_image_properties[GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GameHubUIWidgetsAutoSizeImage {
	GtkDrawingArea parent_instance;
	GameHubUIWidgetsAutoSizeImagePrivate * priv;
	gboolean* scale;
	gint corner_radius;
};

struct _GameHubUIWidgetsAutoSizeImageClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameHubUIWidgetsAutoSizeImagePrivate {
	gchar* url;
	gchar* url_vertical;
	GdkPixbuf* src;
	GdkPixbuf* src_vertical;
	GdkPixbuf* scaled;
	GdkPixbuf* scaled_vertical;
	gchar* cache_prefix;
	gint cmin;
	gint cmax;
	gfloat ratio;
	GtkOrientation constraint;
	gboolean _scale;
	gboolean _scale_vertical;
};

static gint GameHubUIWidgetsAutoSizeImage_private_offset;
static gpointer game_hub_ui_widgets_auto_size_image_parent_class = NULL;
VALA_EXTERN gchar* game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX;

VALA_EXTERN GType game_hub_ui_widgets_auto_size_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIWidgetsAutoSizeImage, g_object_unref)
VALA_EXTERN void game_hub_ui_widgets_auto_size_image_set_constraint (GameHubUIWidgetsAutoSizeImage* self,
                                                         gint min,
                                                         gint max,
                                                         gfloat ratio,
                                                         GtkOrientation orientation);
static void game_hub_ui_widgets_auto_size_image_load_image (GameHubUIWidgetsAutoSizeImage* self,
                                                     gboolean vertical);
static gboolean game_hub_ui_widgets_auto_size_image_get_is_vertical (GameHubUIWidgetsAutoSizeImage* self);
VALA_EXTERN void game_hub_ui_widgets_auto_size_image_load (GameHubUIWidgetsAutoSizeImage* self,
                                               const gchar* url,
                                               const gchar* url_vertical,
                                               const gchar* cache_prefix);
VALA_EXTERN void game_hub_ui_widgets_auto_size_image_unload (GameHubUIWidgetsAutoSizeImage* self);
VALA_EXTERN void game_hub_utils_image_cache_load (const gchar* url,
                                      const gchar* prefix,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN GdkPixbuf* game_hub_utils_image_cache_load_finish (GAsyncResult* _res_);
static void ____lambda80_ (GameHubUIWidgetsAutoSizeImage* self,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN void game_hub_ui_widgets_auto_size_image_set_source_vertical (GameHubUIWidgetsAutoSizeImage* self,
                                                              GdkPixbuf* value);
static void _____lambda80__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void _____lambda81_ (GameHubUIWidgetsAutoSizeImage* self,
                     GObject* obj,
                     GAsyncResult* res);
VALA_EXTERN void game_hub_ui_widgets_auto_size_image_set_source (GameHubUIWidgetsAutoSizeImage* self,
                                                     GdkPixbuf* value);
static void ______lambda81__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static GtkSizeRequestMode game_hub_ui_widgets_auto_size_image_real_get_request_mode (GtkWidget* base);
static void game_hub_ui_widgets_auto_size_image_real_get_preferred_width_for_height (GtkWidget* base,
                                                                              gint height,
                                                                              gint* minimum_width,
                                                                              gint* natural_width);
static void game_hub_ui_widgets_auto_size_image_real_get_preferred_height_for_width (GtkWidget* base,
                                                                              gint width,
                                                                              gint* minimum_height,
                                                                              gint* natural_height);
static gboolean game_hub_ui_widgets_auto_size_image_real_draw (GtkWidget* base,
                                                        cairo_t* ctx);
static void game_hub_ui_widgets_auto_size_image_cairo_rounded_rectangle (cairo_t* cr,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gdouble width,
                                                                  gdouble height,
                                                                  gdouble radius);
VALA_EXTERN GameHubUIWidgetsAutoSizeImage* game_hub_ui_widgets_auto_size_image_new (void);
VALA_EXTERN GameHubUIWidgetsAutoSizeImage* game_hub_ui_widgets_auto_size_image_construct (GType object_type);
VALA_EXTERN GdkPixbuf* game_hub_ui_widgets_auto_size_image_get_source (GameHubUIWidgetsAutoSizeImage* self);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN GdkPixbuf* game_hub_ui_widgets_auto_size_image_get_source_vertical (GameHubUIWidgetsAutoSizeImage* self);
static void game_hub_ui_widgets_auto_size_image_finalize (GObject * obj);
static GType game_hub_ui_widgets_auto_size_image_get_type_once (void);
static void _vala_game_hub_ui_widgets_auto_size_image_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_game_hub_ui_widgets_auto_size_image_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);

static inline gpointer
game_hub_ui_widgets_auto_size_image_get_instance_private (GameHubUIWidgetsAutoSizeImage* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubUIWidgetsAutoSizeImage_private_offset);
}

void
game_hub_ui_widgets_auto_size_image_set_constraint (GameHubUIWidgetsAutoSizeImage* self,
                                                    gint min,
                                                    gint max,
                                                    gfloat ratio,
                                                    GtkOrientation orientation)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 82 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 84 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->constraint = orientation;
#line 85 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->ratio = ratio;
#line 86 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cmin = min;
#line 87 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cmax = max;
#line 88 "../src/ui/widgets/AutoSizeImage.vala"
	switch (self->priv->constraint) {
#line 88 "../src/ui/widgets/AutoSizeImage.vala"
		case GTK_ORIENTATION_HORIZONTAL:
#line 202 "AutoSizeImage.c"
		{
#line 91 "../src/ui/widgets/AutoSizeImage.vala"
			gtk_widget_set_size_request ((GtkWidget*) self, self->priv->cmin, (gint) (self->priv->cmin * ratio));
#line 92 "../src/ui/widgets/AutoSizeImage.vala"
			break;
#line 208 "AutoSizeImage.c"
		}
#line 88 "../src/ui/widgets/AutoSizeImage.vala"
		case GTK_ORIENTATION_VERTICAL:
#line 212 "AutoSizeImage.c"
		{
#line 95 "../src/ui/widgets/AutoSizeImage.vala"
			gtk_widget_set_size_request ((GtkWidget*) self, (gint) (self->priv->cmin / ratio), self->priv->cmin);
#line 96 "../src/ui/widgets/AutoSizeImage.vala"
			break;
#line 218 "AutoSizeImage.c"
		}
		default:
#line 88 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 223 "AutoSizeImage.c"
	}
#line 98 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = game_hub_ui_widgets_auto_size_image_get_is_vertical (self);
#line 98 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = _tmp0_;
#line 98 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_load_image (self, _tmp1_);
#line 231 "AutoSizeImage.c"
}

void
game_hub_ui_widgets_auto_size_image_load (GameHubUIWidgetsAutoSizeImage* self,
                                          const gchar* url,
                                          const gchar* url_vertical,
                                          const gchar* cache_prefix)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 106 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 106 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (cache_prefix != NULL);
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = self->priv->url;
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
	if (g_strcmp0 (url, _tmp1_) == 0) {
#line 255 "AutoSizeImage.c"
		const gchar* _tmp2_;
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp2_ = self->priv->url_vertical;
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp0_ = g_strcmp0 (url_vertical, _tmp2_) == 0;
#line 261 "AutoSizeImage.c"
	} else {
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp0_ = FALSE;
#line 265 "AutoSizeImage.c"
	}
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp0_) {
#line 108 "../src/ui/widgets/AutoSizeImage.vala"
		return;
#line 271 "AutoSizeImage.c"
	}
#line 109 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_unload (self);
#line 110 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp3_ = g_strdup (url);
#line 110 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url);
#line 110 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->url = _tmp3_;
#line 111 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp4_ = g_strdup (url_vertical);
#line 111 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url_vertical);
#line 111 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->url_vertical = _tmp4_;
#line 112 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp5_ = g_strdup (cache_prefix);
#line 112 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->cache_prefix);
#line 112 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cache_prefix = _tmp5_;
#line 113 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp6_ = game_hub_ui_widgets_auto_size_image_get_is_vertical (self);
#line 113 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp7_ = _tmp6_;
#line 113 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_load_image (self, _tmp7_);
#line 299 "AutoSizeImage.c"
}

static void
____lambda80_ (GameHubUIWidgetsAutoSizeImage* self,
               GObject* obj,
               GAsyncResult* res)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (res != NULL);
#line 123 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = game_hub_utils_image_cache_load_finish (res);
#line 123 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = _tmp0_;
#line 123 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_set_source_vertical (self, _tmp1_);
#line 123 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (_tmp1_);
#line 124 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp2_ = self->priv->src_vertical;
#line 124 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp2_ == NULL) {
#line 126 "../src/ui/widgets/AutoSizeImage.vala"
		game_hub_ui_widgets_auto_size_image_load_image (self, FALSE);
#line 326 "AutoSizeImage.c"
	}
}

static void
_____lambda80__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
	____lambda80_ ((GameHubUIWidgetsAutoSizeImage*) self, source_object, res);
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_unref (self);
#line 339 "AutoSizeImage.c"
}

static void
_____lambda81_ (GameHubUIWidgetsAutoSizeImage* self,
                GObject* obj,
                GAsyncResult* res)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (res != NULL);
#line 136 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = game_hub_utils_image_cache_load_finish (res);
#line 136 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = _tmp0_;
#line 136 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_set_source (self, _tmp1_);
#line 136 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (_tmp1_);
#line 359 "AutoSizeImage.c"
}

static void
______lambda81__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
	_____lambda81_ ((GameHubUIWidgetsAutoSizeImage*) self, source_object, res);
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_unref (self);
#line 371 "AutoSizeImage.c"
}

static void
game_hub_ui_widgets_auto_size_image_load_image (GameHubUIWidgetsAutoSizeImage* self,
                                                gboolean vertical)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 116 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
	if (vertical) {
#line 384 "AutoSizeImage.c"
		const gchar* _tmp2_;
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp2_ = self->priv->url_vertical;
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp1_ = _tmp2_ != NULL;
#line 390 "AutoSizeImage.c"
	} else {
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp1_ = FALSE;
#line 394 "AutoSizeImage.c"
	}
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp1_) {
#line 398 "AutoSizeImage.c"
		const gchar* _tmp3_;
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp3_ = self->priv->url_vertical;
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp0_ = g_strcmp0 (_tmp3_, "") != 0;
#line 404 "AutoSizeImage.c"
	} else {
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp0_ = FALSE;
#line 408 "AutoSizeImage.c"
	}
#line 118 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp0_) {
#line 412 "AutoSizeImage.c"
		GdkPixbuf* _tmp4_;
#line 120 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp4_ = self->priv->src_vertical;
#line 120 "../src/ui/widgets/AutoSizeImage.vala"
		if (_tmp4_ == NULL) {
#line 418 "AutoSizeImage.c"
			const gchar* _tmp5_;
			const gchar* _tmp6_;
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp5_ = self->priv->url_vertical;
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp6_ = self->priv->cache_prefix;
#line 122 "../src/ui/widgets/AutoSizeImage.vala"
			game_hub_utils_image_cache_load (_tmp5_, _tmp6_, _____lambda80__gasync_ready_callback, g_object_ref (self));
#line 427 "AutoSizeImage.c"
		}
	} else {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp8_ = self->priv->url;
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
		if (_tmp8_ != NULL) {
#line 436 "AutoSizeImage.c"
			const gchar* _tmp9_;
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp9_ = self->priv->url;
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 442 "AutoSizeImage.c"
		} else {
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp7_ = FALSE;
#line 446 "AutoSizeImage.c"
		}
#line 131 "../src/ui/widgets/AutoSizeImage.vala"
		if (_tmp7_) {
#line 450 "AutoSizeImage.c"
			GdkPixbuf* _tmp10_;
#line 133 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp10_ = self->priv->src;
#line 133 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp10_ == NULL) {
#line 456 "AutoSizeImage.c"
				const gchar* _tmp11_;
				const gchar* _tmp12_;
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp11_ = self->priv->url;
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp12_ = self->priv->cache_prefix;
#line 135 "../src/ui/widgets/AutoSizeImage.vala"
				game_hub_utils_image_cache_load (_tmp11_, _tmp12_, ______lambda81__gasync_ready_callback, g_object_ref (self));
#line 465 "AutoSizeImage.c"
			}
		}
	}
}

void
game_hub_ui_widgets_auto_size_image_unload (GameHubUIWidgetsAutoSizeImage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 142 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 144 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url);
#line 144 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->url = NULL;
#line 145 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url_vertical);
#line 145 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->url_vertical = NULL;
#line 146 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX;
#line 146 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 146 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->cache_prefix);
#line 146 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cache_prefix = _tmp1_;
#line 147 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_set_source (self, NULL);
#line 148 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_set_source_vertical (self, NULL);
#line 498 "AutoSizeImage.c"
}

static GtkSizeRequestMode
game_hub_ui_widgets_auto_size_image_real_get_request_mode (GtkWidget* base)
{
	GameHubUIWidgetsAutoSizeImage * self;
	GtkSizeRequestMode result;
#line 151 "../src/ui/widgets/AutoSizeImage.vala"
	self = (GameHubUIWidgetsAutoSizeImage*) base;
#line 153 "../src/ui/widgets/AutoSizeImage.vala"
	switch (self->priv->constraint) {
#line 153 "../src/ui/widgets/AutoSizeImage.vala"
		case GTK_ORIENTATION_HORIZONTAL:
#line 512 "AutoSizeImage.c"
		{
#line 155 "../src/ui/widgets/AutoSizeImage.vala"
			result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
#line 155 "../src/ui/widgets/AutoSizeImage.vala"
			return result;
#line 518 "AutoSizeImage.c"
		}
#line 153 "../src/ui/widgets/AutoSizeImage.vala"
		case GTK_ORIENTATION_VERTICAL:
#line 522 "AutoSizeImage.c"
		{
#line 156 "../src/ui/widgets/AutoSizeImage.vala"
			result = GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT;
#line 156 "../src/ui/widgets/AutoSizeImage.vala"
			return result;
#line 528 "AutoSizeImage.c"
		}
		default:
		{
#line 157 "../src/ui/widgets/AutoSizeImage.vala"
			result = GTK_SIZE_REQUEST_CONSTANT_SIZE;
#line 157 "../src/ui/widgets/AutoSizeImage.vala"
			return result;
#line 536 "AutoSizeImage.c"
		}
	}
}

static void
game_hub_ui_widgets_auto_size_image_real_get_preferred_width_for_height (GtkWidget* base,
                                                                         gint height,
                                                                         gint* minimum_width,
                                                                         gint* natural_width)
{
	GameHubUIWidgetsAutoSizeImage * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
#line 161 "../src/ui/widgets/AutoSizeImage.vala"
	self = (GameHubUIWidgetsAutoSizeImage*) base;
#line 163 "../src/ui/widgets/AutoSizeImage.vala"
	if (self->priv->constraint == GTK_ORIENTATION_VERTICAL) {
#line 165 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_natural_width = (gint) (height / self->priv->ratio);
#line 165 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_minimum_width = _vala_natural_width;
#line 558 "AutoSizeImage.c"
	} else {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
#line 169 "../src/ui/widgets/AutoSizeImage.vala"
		GTK_WIDGET_CLASS (game_hub_ui_widgets_auto_size_image_parent_class)->get_preferred_width_for_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), height, &_tmp0_, &_tmp1_);
#line 169 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_minimum_width = _tmp0_;
#line 169 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_natural_width = _tmp1_;
#line 568 "AutoSizeImage.c"
	}
#line 161 "../src/ui/widgets/AutoSizeImage.vala"
	if (minimum_width) {
#line 161 "../src/ui/widgets/AutoSizeImage.vala"
		*minimum_width = _vala_minimum_width;
#line 574 "AutoSizeImage.c"
	}
#line 161 "../src/ui/widgets/AutoSizeImage.vala"
	if (natural_width) {
#line 161 "../src/ui/widgets/AutoSizeImage.vala"
		*natural_width = _vala_natural_width;
#line 580 "AutoSizeImage.c"
	}
}

static void
game_hub_ui_widgets_auto_size_image_real_get_preferred_height_for_width (GtkWidget* base,
                                                                         gint width,
                                                                         gint* minimum_height,
                                                                         gint* natural_height)
{
	GameHubUIWidgetsAutoSizeImage * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
#line 173 "../src/ui/widgets/AutoSizeImage.vala"
	self = (GameHubUIWidgetsAutoSizeImage*) base;
#line 175 "../src/ui/widgets/AutoSizeImage.vala"
	if (self->priv->constraint == GTK_ORIENTATION_HORIZONTAL) {
#line 177 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_natural_height = (gint) (width * self->priv->ratio);
#line 177 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_minimum_height = _vala_natural_height;
#line 601 "AutoSizeImage.c"
	} else {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
#line 181 "../src/ui/widgets/AutoSizeImage.vala"
		GTK_WIDGET_CLASS (game_hub_ui_widgets_auto_size_image_parent_class)->get_preferred_height_for_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), width, &_tmp0_, &_tmp1_);
#line 181 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_minimum_height = _tmp0_;
#line 181 "../src/ui/widgets/AutoSizeImage.vala"
		_vala_natural_height = _tmp1_;
#line 611 "AutoSizeImage.c"
	}
#line 173 "../src/ui/widgets/AutoSizeImage.vala"
	if (minimum_height) {
#line 173 "../src/ui/widgets/AutoSizeImage.vala"
		*minimum_height = _vala_minimum_height;
#line 617 "AutoSizeImage.c"
	}
#line 173 "../src/ui/widgets/AutoSizeImage.vala"
	if (natural_height) {
#line 173 "../src/ui/widgets/AutoSizeImage.vala"
		*natural_height = _vala_natural_height;
#line 623 "AutoSizeImage.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 192 "../src/ui/widgets/AutoSizeImage.vala"
	return self ? g_object_ref (self) : NULL;
#line 632 "AutoSizeImage.c"
}

static gboolean
game_hub_ui_widgets_auto_size_image_real_draw (GtkWidget* base,
                                               cairo_t* ctx)
{
	GameHubUIWidgetsAutoSizeImage * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint width = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint height = 0;
	gint _tmp6_;
	gint _tmp7_;
	GdkPixbuf* img = NULL;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* scaled_img = NULL;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	gboolean _scale_img = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GdkPixbuf* _tmp22_;
	gboolean result;
#line 185 "../src/ui/widgets/AutoSizeImage.vala"
	self = (GameHubUIWidgetsAutoSizeImage*) base;
#line 185 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 187 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 187 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = _tmp0_;
#line 187 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 187 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp3_ = _tmp2_;
#line 187 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_scale (ctx, 1.0 / _tmp1_, 1.0 / _tmp3_);
#line 189 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp4_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 189 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp5_ = _tmp4_;
#line 189 "../src/ui/widgets/AutoSizeImage.vala"
	width = gtk_widget_get_allocated_width ((GtkWidget*) self) * _tmp5_;
#line 190 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp6_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 190 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp7_ = _tmp6_;
#line 190 "../src/ui/widgets/AutoSizeImage.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) self) * _tmp7_;
#line 192 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp8_ = self->priv->src;
#line 192 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 192 "../src/ui/widgets/AutoSizeImage.vala"
	img = _tmp9_;
#line 193 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp10_ = self->priv->scaled;
#line 193 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 193 "../src/ui/widgets/AutoSizeImage.vala"
	scaled_img = _tmp11_;
#line 194 "../src/ui/widgets/AutoSizeImage.vala"
	_scale_img = self->priv->_scale;
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp13_ = game_hub_ui_widgets_auto_size_image_get_is_vertical (self);
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp14_ = _tmp13_;
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp14_) {
#line 710 "AutoSizeImage.c"
		GdkPixbuf* _tmp15_;
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp15_ = self->priv->src_vertical;
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = _tmp15_ != NULL;
#line 716 "AutoSizeImage.c"
	} else {
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = FALSE;
#line 720 "AutoSizeImage.c"
	}
#line 196 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp12_) {
#line 724 "AutoSizeImage.c"
		GdkPixbuf* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
#line 198 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp16_ = self->priv->src_vertical;
#line 198 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp17_ = _g_object_ref0 (_tmp16_);
#line 198 "../src/ui/widgets/AutoSizeImage.vala"
		_g_object_unref0 (img);
#line 198 "../src/ui/widgets/AutoSizeImage.vala"
		img = _tmp17_;
#line 199 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp18_ = self->priv->scaled_vertical;
#line 199 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 199 "../src/ui/widgets/AutoSizeImage.vala"
		_g_object_unref0 (scaled_img);
#line 199 "../src/ui/widgets/AutoSizeImage.vala"
		scaled_img = _tmp19_;
#line 200 "../src/ui/widgets/AutoSizeImage.vala"
		_scale_img = self->priv->_scale_vertical;
#line 747 "AutoSizeImage.c"
	}
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp22_ = img;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp22_ != NULL) {
#line 753 "AutoSizeImage.c"
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp23_ = img;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp25_ = _tmp24_;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp21_ = _tmp25_ > 0;
#line 765 "AutoSizeImage.c"
	} else {
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp21_ = FALSE;
#line 769 "AutoSizeImage.c"
	}
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp21_) {
#line 773 "AutoSizeImage.c"
		GdkPixbuf* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp26_ = img;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp27_ = gdk_pixbuf_get_height (_tmp26_);
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp28_ = _tmp27_;
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp20_ = _tmp28_ > 0;
#line 785 "AutoSizeImage.c"
	} else {
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp20_ = FALSE;
#line 789 "AutoSizeImage.c"
	}
#line 203 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp20_) {
#line 793 "AutoSizeImage.c"
		gint x = 0;
		GdkPixbuf* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint y = 0;
		GdkPixbuf* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		GdkPixbuf* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		GdkPixbuf* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		GdkPixbuf* _tmp72_;
#line 205 "../src/ui/widgets/AutoSizeImage.vala"
		if (_scale_img) {
#line 813 "AutoSizeImage.c"
			gfloat ratio = 0.0F;
			GdkPixbuf* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			GdkPixbuf* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint new_width = 0;
			GdkPixbuf* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint new_height = 0;
			GdkPixbuf* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			gboolean _tmp41_ = FALSE;
			GdkPixbuf* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp29_ = img;
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp30_ = gdk_pixbuf_get_width (_tmp29_);
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp31_ = _tmp30_;
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp32_ = img;
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp33_ = gdk_pixbuf_get_height (_tmp32_);
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp34_ = _tmp33_;
#line 207 "../src/ui/widgets/AutoSizeImage.vala"
			ratio = MIN (((gfloat) width) / _tmp31_, ((gfloat) height) / _tmp34_);
#line 208 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp35_ = img;
#line 208 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp36_ = gdk_pixbuf_get_width (_tmp35_);
#line 208 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp37_ = _tmp36_;
#line 208 "../src/ui/widgets/AutoSizeImage.vala"
			new_width = (gint) (_tmp37_ * ratio);
#line 209 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp38_ = img;
#line 209 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp39_ = gdk_pixbuf_get_height (_tmp38_);
#line 209 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp40_ = _tmp39_;
#line 209 "../src/ui/widgets/AutoSizeImage.vala"
			new_height = (gint) (_tmp40_ * ratio);
#line 211 "../src/ui/widgets/AutoSizeImage.vala"
			if (new_width < width) {
#line 213 "../src/ui/widgets/AutoSizeImage.vala"
				new_height = (gint) ((((gfloat) new_height) / ((gfloat) new_width)) * ((gfloat) width));
#line 214 "../src/ui/widgets/AutoSizeImage.vala"
				new_width = width;
#line 869 "AutoSizeImage.c"
			}
#line 217 "../src/ui/widgets/AutoSizeImage.vala"
			if (new_height < height) {
#line 219 "../src/ui/widgets/AutoSizeImage.vala"
				new_width = (gint) ((((gfloat) new_width) / ((gfloat) new_height)) * ((gfloat) height));
#line 220 "../src/ui/widgets/AutoSizeImage.vala"
				new_height = height;
#line 877 "AutoSizeImage.c"
			}
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp42_ = scaled_img;
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp43_ = gdk_pixbuf_get_width (_tmp42_);
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp44_ = _tmp43_;
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp44_ != new_width) {
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp41_ = TRUE;
#line 889 "AutoSizeImage.c"
			} else {
				GdkPixbuf* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp45_ = scaled_img;
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp46_ = gdk_pixbuf_get_height (_tmp45_);
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp47_ = _tmp46_;
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp41_ = _tmp47_ != new_height;
#line 902 "AutoSizeImage.c"
			}
#line 223 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp41_) {
#line 906 "AutoSizeImage.c"
				GdkPixbuf* _tmp48_;
				GdkPixbuf* _tmp49_;
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_;
				gboolean _tmp52_;
#line 225 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp48_ = img;
#line 225 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp49_ = gdk_pixbuf_scale_simple (_tmp48_, new_width, new_height, GDK_INTERP_HYPER);
#line 225 "../src/ui/widgets/AutoSizeImage.vala"
				_g_object_unref0 (scaled_img);
#line 225 "../src/ui/widgets/AutoSizeImage.vala"
				scaled_img = _tmp49_;
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp51_ = game_hub_ui_widgets_auto_size_image_get_is_vertical (self);
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp52_ = _tmp51_;
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
				if (_tmp52_) {
#line 926 "AutoSizeImage.c"
					GdkPixbuf* _tmp53_;
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp53_ = self->priv->src_vertical;
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp50_ = _tmp53_ != NULL;
#line 932 "AutoSizeImage.c"
				} else {
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp50_ = FALSE;
#line 936 "AutoSizeImage.c"
				}
#line 227 "../src/ui/widgets/AutoSizeImage.vala"
				if (_tmp50_) {
#line 940 "AutoSizeImage.c"
					GdkPixbuf* _tmp54_;
					GdkPixbuf* _tmp55_;
#line 229 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp54_ = scaled_img;
#line 229 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp55_ = _g_object_ref0 (_tmp54_);
#line 229 "../src/ui/widgets/AutoSizeImage.vala"
					_g_object_unref0 (self->priv->scaled_vertical);
#line 229 "../src/ui/widgets/AutoSizeImage.vala"
					self->priv->scaled_vertical = _tmp55_;
#line 951 "AutoSizeImage.c"
				} else {
					GdkPixbuf* _tmp56_;
					GdkPixbuf* _tmp57_;
#line 233 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp56_ = scaled_img;
#line 233 "../src/ui/widgets/AutoSizeImage.vala"
					_tmp57_ = _g_object_ref0 (_tmp56_);
#line 233 "../src/ui/widgets/AutoSizeImage.vala"
					_g_object_unref0 (self->priv->scaled);
#line 233 "../src/ui/widgets/AutoSizeImage.vala"
					self->priv->scaled = _tmp57_;
#line 963 "AutoSizeImage.c"
				}
			}
		}
#line 238 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp58_ = scaled_img;
#line 238 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp59_ = gdk_pixbuf_get_width (_tmp58_);
#line 238 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp60_ = _tmp59_;
#line 238 "../src/ui/widgets/AutoSizeImage.vala"
		x = (width - _tmp60_) / 2;
#line 239 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp61_ = scaled_img;
#line 239 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp62_ = gdk_pixbuf_get_height (_tmp61_);
#line 239 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp63_ = _tmp62_;
#line 239 "../src/ui/widgets/AutoSizeImage.vala"
		y = (height - _tmp63_) / 2;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp64_ = scaled_img;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp65_ = gdk_pixbuf_get_width (_tmp64_);
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp66_ = _tmp65_;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp67_ = scaled_img;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp68_ = gdk_pixbuf_get_height (_tmp67_);
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp69_ = _tmp68_;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp70_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp71_ = _tmp70_;
#line 241 "../src/ui/widgets/AutoSizeImage.vala"
		game_hub_ui_widgets_auto_size_image_cairo_rounded_rectangle (ctx, (gdouble) MAX (x, 0), (gdouble) MAX (y, 0), (gdouble) MIN (_tmp66_, width), (gdouble) MIN (_tmp69_, height), (gdouble) (self->corner_radius * _tmp71_));
#line 242 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp72_ = scaled_img;
#line 242 "../src/ui/widgets/AutoSizeImage.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp72_, (gdouble) x, (gdouble) y);
#line 244 "../src/ui/widgets/AutoSizeImage.vala"
		cairo_clip (ctx);
#line 245 "../src/ui/widgets/AutoSizeImage.vala"
		cairo_paint (ctx);
#line 1009 "AutoSizeImage.c"
	}
#line 248 "../src/ui/widgets/AutoSizeImage.vala"
	result = FALSE;
#line 248 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (scaled_img);
#line 248 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (img);
#line 248 "../src/ui/widgets/AutoSizeImage.vala"
	return result;
#line 1019 "AutoSizeImage.c"
}

static void
game_hub_ui_widgets_auto_size_image_cairo_rounded_rectangle (cairo_t* cr,
                                                             gdouble x,
                                                             gdouble y,
                                                             gdouble width,
                                                             gdouble height,
                                                             gdouble radius)
{
#line 251 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (cr != NULL);
#line 253 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_move_to (cr, x + radius, y);
#line 254 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_arc (cr, (x + width) - radius, y + radius, radius, G_PI * 1.5, G_PI * 2);
#line 255 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_arc (cr, (x + width) - radius, (y + height) - radius, radius, (gdouble) 0, G_PI * 0.5);
#line 256 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_arc (cr, x + radius, (y + height) - radius, radius, G_PI * 0.5, G_PI);
#line 257 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_arc (cr, x + radius, y + radius, radius, G_PI, G_PI * 1.5);
#line 258 "../src/ui/widgets/AutoSizeImage.vala"
	cairo_close_path (cr);
#line 1044 "AutoSizeImage.c"
}

GameHubUIWidgetsAutoSizeImage*
game_hub_ui_widgets_auto_size_image_construct (GType object_type)
{
	GameHubUIWidgetsAutoSizeImage * self = NULL;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	self = (GameHubUIWidgetsAutoSizeImage*) g_object_new (object_type, NULL);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	return self;
#line 1055 "AutoSizeImage.c"
}

GameHubUIWidgetsAutoSizeImage*
game_hub_ui_widgets_auto_size_image_new (void)
{
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	return game_hub_ui_widgets_auto_size_image_construct (GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE);
#line 1063 "AutoSizeImage.c"
}

GdkPixbuf*
game_hub_ui_widgets_auto_size_image_get_source (GameHubUIWidgetsAutoSizeImage* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
#line 48 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = self->priv->src;
#line 50 "../src/ui/widgets/AutoSizeImage.vala"
	result = _tmp0_;
#line 50 "../src/ui/widgets/AutoSizeImage.vala"
	return result;
#line 1079 "AutoSizeImage.c"
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
	dup = g_new0 (gboolean, 1);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
	return dup;
#line 1092 "AutoSizeImage.c"
}

static gpointer
__bool_dup0 (gpointer self)
{
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
	return self ? _bool_dup (self) : NULL;
#line 1100 "AutoSizeImage.c"
}

void
game_hub_ui_widgets_auto_size_image_set_source (GameHubUIWidgetsAutoSizeImage* self,
                                                GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GdkPixbuf* _tmp5_;
#line 52 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 54 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 54 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->src);
#line 54 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->src = _tmp0_;
#line 55 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = self->priv->src;
#line 55 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 55 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->scaled);
#line 55 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->scaled = _tmp2_;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp5_ = self->priv->src;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp5_ != NULL) {
#line 1133 "AutoSizeImage.c"
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp6_ = self->priv->src;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp8_ = _tmp7_;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp4_ = _tmp8_ > 0;
#line 1145 "AutoSizeImage.c"
	} else {
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp4_ = FALSE;
#line 1149 "AutoSizeImage.c"
	}
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp4_) {
#line 1153 "AutoSizeImage.c"
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp9_ = self->priv->src;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp11_ = _tmp10_;
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp3_ = _tmp11_ > 0;
#line 1165 "AutoSizeImage.c"
	} else {
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp3_ = FALSE;
#line 1169 "AutoSizeImage.c"
	}
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp3_) {
#line 1173 "AutoSizeImage.c"
		gboolean* _tmp12_ = NULL;
		gboolean* _tmp13_;
		gboolean* _tmp14_;
		gboolean* _tmp30_;
		gboolean* _tmp31_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp13_ = self->scale;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp14_ = __bool_dup0 (_tmp13_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = _tmp14_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		if (_tmp12_ == NULL) {
#line 1187 "AutoSizeImage.c"
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			GdkPixbuf* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean* _tmp29_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp17_ = self->priv->src;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp19_ = _tmp18_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp19_ > self->priv->cmin) {
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp16_ = TRUE;
#line 1204 "AutoSizeImage.c"
			} else {
				GdkPixbuf* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp20_ = self->priv->src;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp22_ = _tmp21_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp16_ = _tmp22_ > self->priv->cmin;
#line 1217 "AutoSizeImage.c"
			}
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp16_) {
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp15_ = TRUE;
#line 1223 "AutoSizeImage.c"
			} else {
				GdkPixbuf* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				GdkPixbuf* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp23_ = self->priv->src;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp25_ = _tmp24_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp26_ = self->priv->src;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp27_ = gdk_pixbuf_get_height (_tmp26_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp28_ = _tmp27_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp15_ = _tmp25_ != _tmp28_;
#line 1245 "AutoSizeImage.c"
			}
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp29_ = __bool_dup0 (&_tmp15_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_g_free0 (_tmp12_);
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp12_ = _tmp29_;
#line 1253 "AutoSizeImage.c"
		}
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp30_ = _tmp12_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = NULL;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp31_ = _tmp30_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		self->priv->_scale = *_tmp31_;
#line 58 "../src/ui/widgets/AutoSizeImage.vala"
		_g_free0 (_tmp31_);
#line 56 "../src/ui/widgets/AutoSizeImage.vala"
		_g_free0 (_tmp12_);
#line 1267 "AutoSizeImage.c"
	}
#line 60 "../src/ui/widgets/AutoSizeImage.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 52 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_auto_size_image_properties[GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY]);
#line 1273 "AutoSizeImage.c"
}

GdkPixbuf*
game_hub_ui_widgets_auto_size_image_get_source_vertical (GameHubUIWidgetsAutoSizeImage* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
#line 66 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = self->priv->src_vertical;
#line 68 "../src/ui/widgets/AutoSizeImage.vala"
	result = _tmp0_;
#line 68 "../src/ui/widgets/AutoSizeImage.vala"
	return result;
#line 1289 "AutoSizeImage.c"
}

void
game_hub_ui_widgets_auto_size_image_set_source_vertical (GameHubUIWidgetsAutoSizeImage* self,
                                                         GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GdkPixbuf* _tmp5_;
#line 70 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_if_fail (self != NULL);
#line 72 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 72 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->src_vertical);
#line 72 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->src_vertical = _tmp0_;
#line 73 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = self->priv->src_vertical;
#line 73 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 73 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->scaled_vertical);
#line 73 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->scaled_vertical = _tmp2_;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp5_ = self->priv->src_vertical;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp5_ != NULL) {
#line 1322 "AutoSizeImage.c"
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp6_ = self->priv->src_vertical;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp8_ = _tmp7_;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp4_ = _tmp8_ > 0;
#line 1334 "AutoSizeImage.c"
	} else {
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp4_ = FALSE;
#line 1338 "AutoSizeImage.c"
	}
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp4_) {
#line 1342 "AutoSizeImage.c"
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp9_ = self->priv->src_vertical;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp11_ = _tmp10_;
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp3_ = _tmp11_ > 0;
#line 1354 "AutoSizeImage.c"
	} else {
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp3_ = FALSE;
#line 1358 "AutoSizeImage.c"
	}
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
	if (_tmp3_) {
#line 1362 "AutoSizeImage.c"
		gboolean* _tmp12_ = NULL;
		gboolean* _tmp13_;
		gboolean* _tmp14_;
		gboolean* _tmp30_;
		gboolean* _tmp31_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp13_ = self->scale;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp14_ = __bool_dup0 (_tmp13_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = _tmp14_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		if (_tmp12_ == NULL) {
#line 1376 "AutoSizeImage.c"
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			GdkPixbuf* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean* _tmp29_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp17_ = self->priv->src_vertical;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp19_ = _tmp18_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp19_ > self->priv->cmin) {
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp16_ = TRUE;
#line 1393 "AutoSizeImage.c"
			} else {
				GdkPixbuf* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp20_ = self->priv->src_vertical;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp22_ = _tmp21_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp16_ = _tmp22_ > self->priv->cmin;
#line 1406 "AutoSizeImage.c"
			}
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			if (_tmp16_) {
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp15_ = TRUE;
#line 1412 "AutoSizeImage.c"
			} else {
				GdkPixbuf* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				GdkPixbuf* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp23_ = self->priv->src_vertical;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp25_ = _tmp24_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp26_ = self->priv->src_vertical;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp27_ = gdk_pixbuf_get_height (_tmp26_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp28_ = _tmp27_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
				_tmp15_ = _tmp25_ != _tmp28_;
#line 1434 "AutoSizeImage.c"
			}
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp29_ = __bool_dup0 (&_tmp15_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_g_free0 (_tmp12_);
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
			_tmp12_ = _tmp29_;
#line 1442 "AutoSizeImage.c"
		}
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp30_ = _tmp12_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp12_ = NULL;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_tmp31_ = _tmp30_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		self->priv->_scale_vertical = *_tmp31_;
#line 76 "../src/ui/widgets/AutoSizeImage.vala"
		_g_free0 (_tmp31_);
#line 74 "../src/ui/widgets/AutoSizeImage.vala"
		_g_free0 (_tmp12_);
#line 1456 "AutoSizeImage.c"
	}
#line 78 "../src/ui/widgets/AutoSizeImage.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 70 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_auto_size_image_properties[GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY]);
#line 1462 "AutoSizeImage.c"
}

static gboolean
game_hub_ui_widgets_auto_size_image_get_is_vertical (GameHubUIWidgetsAutoSizeImage* self)
{
	gboolean result;
#line 103 "../src/ui/widgets/AutoSizeImage.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "../src/ui/widgets/AutoSizeImage.vala"
	result = self->priv->ratio > ((gfloat) 1);
#line 103 "../src/ui/widgets/AutoSizeImage.vala"
	return result;
#line 1475 "AutoSizeImage.c"
}

static void
game_hub_ui_widgets_auto_size_image_class_init (GameHubUIWidgetsAutoSizeImageClass * klass,
                                                gpointer klass_data)
{
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	game_hub_ui_widgets_auto_size_image_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	g_type_class_adjust_private_offset (klass, &GameHubUIWidgetsAutoSizeImage_private_offset);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) game_hub_ui_widgets_auto_size_image_real_get_request_mode;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget*, gint, gint*, gint*)) game_hub_ui_widgets_auto_size_image_real_get_preferred_width_for_height;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) game_hub_ui_widgets_auto_size_image_real_get_preferred_height_for_width;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) game_hub_ui_widgets_auto_size_image_real_draw;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_ui_widgets_auto_size_image_get_property;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_ui_widgets_auto_size_image_set_property;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_ui_widgets_auto_size_image_finalize;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY, game_hub_ui_widgets_auto_size_image_properties[GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY, game_hub_ui_widgets_auto_size_image_properties[GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY] = g_param_spec_object ("source-vertical", "source-vertical", "source-vertical", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1504 "AutoSizeImage.c"
}

static void
game_hub_ui_widgets_auto_size_image_instance_init (GameHubUIWidgetsAutoSizeImage * self,
                                                   gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv = game_hub_ui_widgets_auto_size_image_get_instance_private (self);
#line 33 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp0_ = game_hub_utils_image_cache_DEFAULT_CACHED_FILE_PREFIX;
#line 33 "../src/ui/widgets/AutoSizeImage.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cache_prefix = _tmp1_;
#line 35 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cmin = 0;
#line 36 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->cmax = 0;
#line 37 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->ratio = (gfloat) 1;
#line 38 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->constraint = GTK_ORIENTATION_HORIZONTAL;
#line 40 "../src/ui/widgets/AutoSizeImage.vala"
	self->scale = NULL;
#line 41 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->_scale = TRUE;
#line 42 "../src/ui/widgets/AutoSizeImage.vala"
	self->priv->_scale_vertical = TRUE;
#line 44 "../src/ui/widgets/AutoSizeImage.vala"
	self->corner_radius = 4;
#line 1537 "AutoSizeImage.c"
}

static void
game_hub_ui_widgets_auto_size_image_finalize (GObject * obj)
{
	GameHubUIWidgetsAutoSizeImage * self;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImage);
#line 27 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url);
#line 28 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->url_vertical);
#line 29 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->src);
#line 30 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->src_vertical);
#line 31 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->scaled);
#line 32 "../src/ui/widgets/AutoSizeImage.vala"
	_g_object_unref0 (self->priv->scaled_vertical);
#line 33 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->priv->cache_prefix);
#line 40 "../src/ui/widgets/AutoSizeImage.vala"
	_g_free0 (self->scale);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	G_OBJECT_CLASS (game_hub_ui_widgets_auto_size_image_parent_class)->finalize (obj);
#line 1564 "AutoSizeImage.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_ui_widgets_auto_size_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUIWidgetsAutoSizeImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_ui_widgets_auto_size_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUIWidgetsAutoSizeImage), 0, (GInstanceInitFunc) game_hub_ui_widgets_auto_size_image_instance_init, NULL };
	GType game_hub_ui_widgets_auto_size_image_type_id;
	game_hub_ui_widgets_auto_size_image_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameHubUIWidgetsAutoSizeImage", &g_define_type_info, 0);
	GameHubUIWidgetsAutoSizeImage_private_offset = g_type_add_instance_private (game_hub_ui_widgets_auto_size_image_type_id, sizeof (GameHubUIWidgetsAutoSizeImagePrivate));
	return game_hub_ui_widgets_auto_size_image_type_id;
}

GType
game_hub_ui_widgets_auto_size_image_get_type (void)
{
	static volatile gsize game_hub_ui_widgets_auto_size_image_type_id__once = 0;
	if (g_once_init_enter (&game_hub_ui_widgets_auto_size_image_type_id__once)) {
		GType game_hub_ui_widgets_auto_size_image_type_id;
		game_hub_ui_widgets_auto_size_image_type_id = game_hub_ui_widgets_auto_size_image_get_type_once ();
		g_once_init_leave (&game_hub_ui_widgets_auto_size_image_type_id__once, game_hub_ui_widgets_auto_size_image_type_id);
	}
	return game_hub_ui_widgets_auto_size_image_type_id__once;
}

static void
_vala_game_hub_ui_widgets_auto_size_image_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	GameHubUIWidgetsAutoSizeImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImage);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	switch (property_id) {
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		case GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		g_value_set_object (value, game_hub_ui_widgets_auto_size_image_get_source (self));
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		case GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		g_value_set_object (value, game_hub_ui_widgets_auto_size_image_get_source_vertical (self));
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 1611 "AutoSizeImage.c"
		default:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 1617 "AutoSizeImage.c"
	}
}

static void
_vala_game_hub_ui_widgets_auto_size_image_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	GameHubUIWidgetsAutoSizeImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UI_WIDGETS_TYPE_AUTO_SIZE_IMAGE, GameHubUIWidgetsAutoSizeImage);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
	switch (property_id) {
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		case GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_PROPERTY:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		game_hub_ui_widgets_auto_size_image_set_source (self, g_value_get_object (value));
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		case GAME_HUB_UI_WIDGETS_AUTO_SIZE_IMAGE_SOURCE_VERTICAL_PROPERTY:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		game_hub_ui_widgets_auto_size_image_set_source_vertical (self, g_value_get_object (value));
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 1643 "AutoSizeImage.c"
		default:
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/ui/widgets/AutoSizeImage.vala"
		break;
#line 1649 "AutoSizeImage.c"
	}
}

