/* Game.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Game.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>
#include <float.h>
#include <math.h>

#define GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR "_gamehub"
#define GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR "overlays"
#define GAME_HUB_DATA_GAME_OVERLAY_BASE "base"
#define GAME_HUB_UTILS_FS_UTILS_OVERLAYS_LIST "overlays.json"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;
typedef struct _GameHubDataRunnablePrivate GameHubDataRunnablePrivate;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())
typedef enum  {
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC_DOWNLOAD
} GameHubDataRunnableInstallerInstallMode;

#define GAME_HUB_DATA_RUNNABLE_INSTALLER_TYPE_INSTALL_MODE (game_hub_data_runnable_installer_install_mode_get_type ())

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
typedef struct _GameHubDataGamePrivate GameHubDataGamePrivate;

#define GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT (game_hub_data_game_achievement_get_type ())
#define GAME_HUB_DATA_GAME_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievement))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))

typedef struct _GameHubDataGameAchievement GameHubDataGameAchievement;
typedef struct _GameHubDataGameAchievementClass GameHubDataGameAchievementClass;

#define GAME_HUB_DATA_GAME_TYPE_STATUS (game_hub_data_game_status_get_type ())
#define GAME_HUB_DATA_GAME_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatus))
#define GAME_HUB_DATA_GAME_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))
#define GAME_HUB_DATA_GAME_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))

typedef struct _GameHubDataGameStatus GameHubDataGameStatus;
typedef struct _GameHubDataGameStatusClass GameHubDataGameStatusClass;

#define GAME_HUB_DATA_GAME_TYPE_OVERLAY (game_hub_data_game_overlay_get_type ())
#define GAME_HUB_DATA_GAME_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay))
#define GAME_HUB_DATA_GAME_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))
#define GAME_HUB_DATA_GAME_IS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_IS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))

typedef struct _GameHubDataGameOverlay GameHubDataGameOverlay;
typedef struct _GameHubDataGameOverlayClass GameHubDataGameOverlayClass;

#define GAME_HUB_DATA_TYPE_GAME_SOURCE (game_hub_data_game_source_get_type ())
#define GAME_HUB_DATA_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSource))
#define GAME_HUB_DATA_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))
#define GAME_HUB_DATA_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_IS_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))

typedef struct _GameHubDataGameSource GameHubDataGameSource;
typedef struct _GameHubDataGameSourceClass GameHubDataGameSourceClass;

#define GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG (game_hub_data_db_tables_tags_tag_get_type ())
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTag))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))

typedef struct _GameHubDataDBTablesTagsTag GameHubDataDBTablesTagsTag;
typedef struct _GameHubDataDBTablesTagsTagClass GameHubDataDBTablesTagsTagClass;

#define GAME_HUB_UTILS_TYPE_FS_OVERLAY (game_hub_utils_fs_overlay_get_type ())
#define GAME_HUB_UTILS_FS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_FS_OVERLAY, GameHubUtilsFSOverlay))
#define GAME_HUB_UTILS_FS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_FS_OVERLAY, GameHubUtilsFSOverlayClass))
#define GAME_HUB_UTILS_IS_FS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_FS_OVERLAY))
#define GAME_HUB_UTILS_IS_FS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_FS_OVERLAY))
#define GAME_HUB_UTILS_FS_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_FS_OVERLAY, GameHubUtilsFSOverlayClass))

typedef struct _GameHubUtilsFSOverlay GameHubUtilsFSOverlay;
typedef struct _GameHubUtilsFSOverlayClass GameHubUtilsFSOverlayClass;
enum  {
	GAME_HUB_DATA_GAME_0_PROPERTY,
	GAME_HUB_DATA_GAME_SOURCE_PROPERTY,
	GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY,
	GAME_HUB_DATA_GAME_ICON_PROPERTY,
	GAME_HUB_DATA_GAME_IMAGE_PROPERTY,
	GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY,
	GAME_HUB_DATA_GAME_INFO_PROPERTY,
	GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY,
	GAME_HUB_DATA_GAME_FULL_ID_PROPERTY,
	GAME_HUB_DATA_GAME_VERSION_PROPERTY,
	GAME_HUB_DATA_GAME_TAGS_PROPERTY,
	GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY,
	GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY,
	GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY,
	GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY,
	GAME_HUB_DATA_GAME_STATUS_PROPERTY,
	GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY,
	GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY,
	GAME_HUB_DATA_GAME_PLAYTIME_PROPERTY,
	GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY,
	GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAYS_ENABLED_PROPERTY,
	GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY,
	GAME_HUB_DATA_GAME_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_game_properties[GAME_HUB_DATA_GAME_NUM_PROPERTIES];
typedef enum  {
	GAME_HUB_DATA_GAME_STATE_UNINSTALLED,
	GAME_HUB_DATA_GAME_STATE_INSTALLED,
	GAME_HUB_DATA_GAME_STATE_DOWNLOADING,
	GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY,
	GAME_HUB_DATA_GAME_STATE_INSTALLING
} GameHubDataGameState;

#define GAME_HUB_DATA_GAME_TYPE_STATE (game_hub_data_game_state_get_type ())
#define _game_hub_data_game_source_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_source_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD (game_hub_utils_downloader_download_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownload))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))

typedef struct _GameHubUtilsDownloaderDownload GameHubUtilsDownloaderDownload;
typedef struct _GameHubUtilsDownloaderDownloadClass GameHubUtilsDownloaderDownloadClass;
#define _game_hub_data_game_status_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_status_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GAME_HUB_UTILS_TYPE_RUN_TASK (game_hub_utils_run_task_get_type ())
#define GAME_HUB_UTILS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTask))
#define GAME_HUB_UTILS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))
#define GAME_HUB_UTILS_IS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_IS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_RUN_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))

typedef struct _GameHubUtilsRunTask GameHubUtilsRunTask;
typedef struct _GameHubUtilsRunTaskClass GameHubUtilsRunTaskClass;
#define _game_hub_utils_run_task_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_unref (var), NULL)))

#define GAME_HUB_DATA_TYPE_TWEAKABLE_GAME (game_hub_data_tweakable_game_get_type ())
#define GAME_HUB_DATA_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGame))
#define GAME_HUB_DATA_IS_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME))
#define GAME_HUB_DATA_TWEAKABLE_GAME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGameIface))

typedef struct _GameHubDataTweakableGame GameHubDataTweakableGame;
typedef struct _GameHubDataTweakableGameIface GameHubDataTweakableGameIface;

#define GAME_HUB_DATA_TWEAKS_TYPE_TWEAK (game_hub_data_tweaks_tweak_get_type ())
#define GAME_HUB_DATA_TWEAKS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweak))
#define GAME_HUB_DATA_TWEAKS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_TWEAK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))

typedef struct _GameHubDataTweaksTweak GameHubDataTweaksTweak;
typedef struct _GameHubDataTweaksTweakClass GameHubDataTweaksTweakClass;

#define GAME_HUB_DATA_TYPE_COMPAT_TOOL (game_hub_data_compat_tool_get_type ())
#define GAME_HUB_DATA_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatTool))
#define GAME_HUB_DATA_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))
#define GAME_HUB_DATA_IS_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_IS_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_COMPAT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))

typedef struct _GameHubDataCompatTool GameHubDataCompatTool;
typedef struct _GameHubDataCompatToolClass GameHubDataCompatToolClass;

#define GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT (game_hub_utils_run_task_result_get_type ())
#define GAME_HUB_UTILS_RUN_TASK_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResult))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))

typedef struct _GameHubUtilsRunTaskResult GameHubUtilsRunTaskResult;
typedef struct _GameHubUtilsRunTaskResultClass GameHubUtilsRunTaskResultClass;
#define _game_hub_utils_run_task_result_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_result_unref (var), NULL)))
typedef struct _GameHubDataGameRunData GameHubDataGameRunData;
typedef struct _GameHubDataGameStatusPrivate GameHubDataGameStatusPrivate;
typedef struct _GameHubDataGameRunOrInstallData GameHubDataGameRunOrInstallData;
typedef struct _GameHubDataGameUpdateGameInfoData GameHubDataGameUpdateGameInfoData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME (game_hub_data_sources_gog_gog_game_get_type ())
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME, GameHubDataSourcesGOGGOGGame))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME, GameHubDataSourcesGOGGOGGameClass))
#define GAME_HUB_DATA_SOURCES_GOG_IS_GOG_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME))
#define GAME_HUB_DATA_SOURCES_GOG_IS_GOG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_GOG_TYPE_GOG_GAME, GameHubDataSourcesGOGGOGGameClass))

typedef struct _GameHubDataSourcesGOGGOGGame GameHubDataSourcesGOGGOGGame;
typedef struct _GameHubDataSourcesGOGGOGGameClass GameHubDataSourcesGOGGOGGameClass;

#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC (game_hub_data_sources_gog_gog_game_dlc_get_type ())
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_DLC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_DLC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLCClass))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC))
#define GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_DLC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLCClass))

typedef struct _GameHubDataSourcesGOGGOGGameDLC GameHubDataSourcesGOGGOGGameDLC;
typedef struct _GameHubDataSourcesGOGGOGGameDLCClass GameHubDataSourcesGOGGOGGameDLCClass;
typedef struct _GameHubDataSourcesGOGGOGGamePrivate GameHubDataSourcesGOGGOGGamePrivate;
typedef struct _GameHubDataSourcesGOGGOGGameDLCPrivate GameHubDataSourcesGOGGOGGameDLCPrivate;

#define GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME (game_hub_data_sources_steam_steam_game_get_type ())
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGame))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGameClass))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGameClass))

typedef struct _GameHubDataSourcesSteamSteamGame GameHubDataSourcesSteamSteamGame;
typedef struct _GameHubDataSourcesSteamSteamGameClass GameHubDataSourcesSteamSteamGameClass;
typedef enum  {
	GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_SAFE,
	GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_UNSAFE,
	GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_RESTRICTED
} GameHubUtilsFSOverlayRootPathSafety;

#define GAME_HUB_UTILS_FS_OVERLAY_TYPE_ROOT_PATH_SAFETY (game_hub_utils_fs_overlay_root_path_safety_get_type ())
typedef struct _GameHubDataGameOverlayPrivate GameHubDataGameOverlayPrivate;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _GameHubDataGameMountOverlaysData GameHubDataGameMountOverlaysData;
typedef struct _GameHubDataGameUmountOverlaysData GameHubDataGameUmountOverlaysData;
typedef struct _GameHubDataGameLoadAchievementsData GameHubDataGameLoadAchievementsData;
enum  {
	GAME_HUB_DATA_GAME_OVERLAY_0_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_REMOVABLE_PROPERTY,
	GAME_HUB_DATA_GAME_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_NUM_PROPERTIES];
#define _game_hub_utils_downloader_download_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_downloader_download_unref (var), NULL)))

#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS (game_hub_utils_downloader_download_status_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatus))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))

typedef struct _GameHubUtilsDownloaderDownloadStatus GameHubUtilsDownloaderDownloadStatus;
typedef struct _GameHubUtilsDownloaderDownloadStatusClass GameHubUtilsDownloaderDownloadStatusClass;
typedef struct _GameHubDataGameParamSpecStatus GameHubDataGameParamSpecStatus;
typedef struct _GameHubDataGameAchievementPrivate GameHubDataGameAchievementPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GameHubDataGameParamSpecAchievement GameHubDataGameParamSpecAchievement;
enum  {
	GAME_HUB_DATA_GAME_STATUS_CHANGE_SIGNAL,
	GAME_HUB_DATA_GAME_TAGS_UPDATE_SIGNAL,
	GAME_HUB_DATA_GAME_NUM_SIGNALS
};
static guint game_hub_data_game_signals[GAME_HUB_DATA_GAME_NUM_SIGNALS] = {0};

struct _GameHubDataRunnable {
	GObject parent_instance;
	GameHubDataRunnablePrivate * priv;
};

struct _GameHubDataRunnableClass {
	GObjectClass parent_class;
	gboolean (*is_supported) (GameHubDataRunnable* self, GameHubDataPlatform* platform, gboolean with_compat);
	void (*install) (GameHubDataRunnable* self, GameHubDataRunnableInstallerInstallMode install_mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	void (*run) (GameHubDataRunnable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	gboolean (*can_be_launched) (GameHubDataRunnable* self, gboolean is_launch_attempt);
	void (*run_with_compat) (GameHubDataRunnable* self, gboolean is_opened_from_menu, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_with_compat_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	GtkFileChooser* (*setup_executable_chooser) (GameHubDataRunnable* self);
	void (*choose_executable) (GameHubDataRunnable* self, gboolean update);
	void (*set_chosen_executable) (GameHubDataRunnable* self, GFile* file, gboolean update);
	void (*save) (GameHubDataRunnable* self);
	void (*update_status) (GameHubDataRunnable* self);
	void (*import) (GameHubDataRunnable* self, gboolean update);
	GFile* (*get_executable) (GameHubDataRunnable* self);
	void (*set_executable) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_work_dir) (GameHubDataRunnable* self);
	void (*set_work_dir) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_default_install_dir) (GameHubDataRunnable* self);
};

struct _GameHubDataGame {
	GameHubDataRunnable parent_instance;
	GameHubDataGamePrivate * priv;
	GameHubDataGameStatus* _status;
	GeeArrayList* overlays;
	gchar* executable_path;
	gchar* work_dir_path;
};

struct _GameHubDataGameClass {
	GameHubDataRunnableClass parent_class;
	void (*uninstall) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*uninstall_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*update_game_info) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_game_info_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*load_achievements) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_achievements_finish) (GameHubDataGame* self, GAsyncResult* _res_);
};

struct _GameHubDataGamePrivate {
	GameHubDataGameSource* _source;
	gchar* _description;
	gchar* _icon;
	gchar* _image;
	gchar* _image_vertical;
	gchar* _info;
	gchar* _info_detailed;
	gchar* _version;
	GeeArrayList* _tags;
	GFile* _installers_dir;
	gboolean _is_installable;
	gchar* _store_page;
	gint64 _last_launch;
	gint64 _playtime_source;
	gint64 _playtime_tracked;
	GameHubUtilsFSOverlay* fs_overlay;
	gchar* fs_overlay_last_options;
	GeeArrayList* _achievements;
};

struct _GameHubDataTweakableGameIface {
	GTypeInterface parent_iface;
	gchar** (*get_tweaks) (GameHubDataTweakableGame* self, gint* result_length1);
	void (*set_tweaks) (GameHubDataTweakableGame* self, gchar** value, gint value_length1);
};

struct _GameHubDataGameRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar** cmd;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint cmd_length1;
	gint _cmd_size_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeHashMap* variables;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GeeHashMap* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** args;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	gchar** _tmp33_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gboolean _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar** _tmp38_;
	GeeHashMap* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar** arg_collection;
	gint arg_collection_length1;
	gint _arg_collection_size_;
	gint arg_it;
	gchar* _tmp46_;
	gchar* arg;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	GeeHashMap* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	GameHubUtilsRunTask* task;
	gchar** _tmp53_;
	gint _tmp53__length1;
	GameHubUtilsRunTask* _tmp54_;
	GameHubUtilsRunTask* _tmp55_;
	GFile* _tmp56_;
	GFile* _tmp57_;
	GFile* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GameHubUtilsRunTask* _tmp61_;
	GameHubUtilsRunTask* _tmp62_;
	GameHubUtilsRunTask* _tmp63_;
	GameHubUtilsRunTask* _tmp64_;
	GameHubUtilsRunTask* _tmp65_;
	gint _tmp66_;
	GameHubDataTweaksTweak** _tmp67_;
	GameHubDataTweaksTweak** _tmp68_;
	gint _tmp68__length1;
	GameHubUtilsRunTask* _tmp69_;
	GameHubUtilsRunTask* _tmp70_;
	GameHubUtilsRunTask* _tmp71_;
	GameHubUtilsRunTaskResult* _tmp72_;
	GameHubUtilsRunTaskResult* _tmp73_;
	gint64 _tmp74_;
	gint64 _tmp75_;
};

struct _GameHubDataGameStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameStatusPrivate * priv;
	GameHubDataGameState state;
	GameHubDataGame* game;
	GameHubUtilsDownloaderDownload* download;
};

struct _GameHubDataGameStatusClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameStatus *self);
};

struct _GameHubDataGameRunOrInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
	gboolean show_compat;
	GameHubDataGameStatus* _tmp0_;
	GameHubDataGameStatus* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GameHubDataGameStatus* _tmp4_;
	GameHubDataGameStatus* _tmp5_;
};

struct _GameHubDataGameUpdateGameInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
};

struct _GameHubDataSourcesGOGGOGGame {
	GameHubDataGame parent_instance;
	GameHubDataSourcesGOGGOGGamePrivate * priv;
};

struct _GameHubDataSourcesGOGGOGGameClass {
	GameHubDataGameClass parent_class;
};

struct _GameHubDataSourcesGOGGOGGameDLC {
	GameHubDataSourcesGOGGOGGame parent_instance;
	GameHubDataSourcesGOGGOGGameDLCPrivate * priv;
	GameHubDataSourcesGOGGOGGame* game;
};

struct _GameHubDataSourcesGOGGOGGameDLCClass {
	GameHubDataSourcesGOGGOGGameClass parent_class;
};

struct _GameHubDataGameOverlay {
	GObject parent_instance;
	GameHubDataGameOverlayPrivate * priv;
	GFile* directory;
};

struct _GameHubDataGameOverlayClass {
	GObjectClass parent_class;
};

struct _GameHubDataGameMountOverlaysData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
	GFile* persist;
	GameHubDataSourcesGOGGOGGame* _tmp0_;
	GameHubDataSourcesGOGGOGGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFile* overlay_dir;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* merged_dir;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* persist_dir;
	GFile* _tmp16_;
	GFile* work_dir;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GeeArrayList* dirs;
	GeeArrayList* _tmp19_;
	GeeArrayList* _overlay_list;
	GeeArrayList* _tmp20_;
	gint _overlay_size;
	GeeArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _overlay_index;
	gint _tmp24_;
	gint _tmp25_;
	GameHubDataGameOverlay* overlay;
	GeeArrayList* _tmp26_;
	gpointer _tmp27_;
	GameHubDataGameOverlay* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GeeArrayList* _tmp31_;
	GameHubDataGameOverlay* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GeeArrayList* _tmp35_;
	GFile* _tmp36_;
	GFile* _tmp37_;
	GameHubUtilsFSOverlay* _tmp38_;
	GameHubUtilsFSOverlay* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GameHubUtilsFSOverlay* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	GameHubUtilsFSOverlay* _tmp47_;
};

struct _GameHubDataGameUmountOverlaysData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
	GameHubDataSourcesGOGGOGGame* _tmp0_;
	GameHubDataSourcesGOGGOGGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GameHubUtilsFSOverlay* _tmp5_;
	GameHubUtilsFSOverlay* _tmp6_;
};

struct _GameHubDataGameLoadAchievementsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataGame* self;
	GeeArrayList* result;
};

struct _GameHubDataGameOverlayPrivate {
	GameHubDataGame* _game;
	gchar* _id;
	gchar* _name;
	gboolean _enabled;
};

struct _GameHubDataGameParamSpecStatus {
	GParamSpec parent_instance;
};

struct _GameHubDataGameAchievement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameAchievementPrivate * priv;
};

struct _GameHubDataGameAchievementClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameAchievement *self);
};

struct _GameHubDataGameAchievementPrivate {
	gchar* _id;
	gchar* _name;
	gchar* _description;
	gboolean _unlocked;
	GDateTime* _unlock_date;
	gchar* _unlock_time;
	gfloat _global_percentage;
	gchar* _image_locked;
	gchar* _image_unlocked;
};

struct _GameHubDataGameParamSpecAchievement {
	GParamSpec parent_instance;
};

static gint GameHubDataGame_private_offset;
static gpointer game_hub_data_game_parent_class = NULL;
VALA_EXTERN GeeArrayList* game_hub_data_db_tables_tags_DYNAMIC_TAGS;
VALA_EXTERN gboolean game_hub_data_runnable_IsLaunched;
static gint GameHubDataGameOverlay_private_offset;
static gpointer game_hub_data_game_overlay_parent_class = NULL;
static gpointer game_hub_data_game_status_parent_class = NULL;
static gint GameHubDataGameAchievement_private_offset;
static gpointer game_hub_data_game_achievement_parent_class = NULL;

VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_runnable_installer_install_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_game_achievement_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_achievement_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_achievement (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_achievement (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_achievement (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_achievement (const GValue* value);
VALA_EXTERN GType game_hub_data_game_achievement_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameAchievement, game_hub_data_game_achievement_unref)
VALA_EXTERN gpointer game_hub_data_game_status_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_status (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_status (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_status (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_data_game_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameStatus, game_hub_data_game_status_unref)
VALA_EXTERN GType game_hub_data_game_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameOverlay, g_object_unref)
VALA_EXTERN gpointer game_hub_data_game_source_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_param_spec_game_source (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_value_set_game_source (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_value_take_game_source (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_value_get_game_source (const GValue* value);
VALA_EXTERN GType game_hub_data_game_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameSource, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_db_tables_tags_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTablesTagsTag, g_object_unref)
VALA_EXTERN GType game_hub_utils_fs_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsFSOverlay, g_object_unref)
VALA_EXTERN void game_hub_data_runnable_save (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_run (GameHubDataRunnable* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_finish (GameHubDataRunnable* self,
                                        GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_update_game_info (GameHubDataGame* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_update_game_info_finish (GameHubDataGame* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_load_achievements (GameHubDataGame* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GeeArrayList* game_hub_data_game_load_achievements_finish (GameHubDataGame* self,
                                                           GAsyncResult* _res_);
VALA_EXTERN GFile* game_hub_data_runnable_get_executable (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_set_executable (GameHubDataRunnable* self,
                                            GFile* value);
VALA_EXTERN GFile* game_hub_data_runnable_get_work_dir (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_set_work_dir (GameHubDataRunnable* self,
                                          GFile* value);
VALA_EXTERN GType game_hub_data_game_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean game_hub_data_db_tables_tags_tag_is_equal (GameHubDataDBTablesTagsTag* first,
                                                    GameHubDataDBTablesTagsTag* second);
static gboolean _game_hub_data_db_tables_tags_tag_is_equal_gee_equal_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
VALA_EXTERN gpointer game_hub_utils_downloader_download_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_param_spec_download (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_value_set_download (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_value_take_download (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_value_get_download (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownload, game_hub_utils_downloader_download_unref)
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_new (GameHubDataGameState state,
                                                      GameHubDataGame* game,
                                                      GameHubUtilsDownloaderDownload* download);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_construct (GType object_type,
                                                            GameHubDataGameState state,
                                                            GameHubDataGame* game,
                                                            GameHubUtilsDownloaderDownload* download);
VALA_EXTERN gboolean game_hub_data_game_has_tag (GameHubDataGame* self,
                                     GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN gboolean game_hub_data_game_has_tag_id (GameHubDataGame* self,
                                        const gchar* tag);
VALA_EXTERN const gchar* game_hub_data_db_tables_tags_tag_get_id (GameHubDataDBTablesTagsTag* self);
VALA_EXTERN GeeArrayList* game_hub_data_game_get_tags (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_add_tag (GameHubDataGame* self,
                                 GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN void game_hub_data_game_remove_tag (GameHubDataGame* self,
                                    GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN void game_hub_data_game_toggle_tag (GameHubDataGame* self,
                                    GameHubDataDBTablesTagsTag* tag);
static void game_hub_data_game_real_save (GameHubDataRunnable* base);
VALA_EXTERN gboolean game_hub_data_db_tables_games_add (GameHubDataGame* game);
VALA_EXTERN void game_hub_data_game_uninstall (GameHubDataGame* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_uninstall_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_);
static void game_hub_data_game_real_run_data_free (gpointer _data);
static void game_hub_data_game_real_run (GameHubDataRunnable* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean game_hub_data_game_real_run_co (GameHubDataGameRunData* _data_);
VALA_EXTERN gboolean game_hub_data_runnable_can_be_launched (GameHubDataRunnable* self,
                                                 gboolean is_launch_attempt);
VALA_EXTERN void game_hub_data_runnable_set_is_running (GameHubDataRunnable* self,
                                            gboolean value);
VALA_EXTERN void game_hub_data_runnable_update_status (GameHubDataRunnable* self);
VALA_EXTERN const gchar* game_hub_data_runnable_get_arguments (GameHubDataRunnable* self);
VALA_EXTERN const gchar* game_hub_data_runnable_get_name (GameHubDataRunnable* self);
VALA_EXTERN GFile* game_hub_data_runnable_get_install_dir (GameHubDataRunnable* self);
VALA_EXTERN gchar** game_hub_utils_parse_args (const gchar* args,
                                   gint* result_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN gchar* game_hub_utils_fs_utils_expand (const gchar* path,
                                       const gchar* file,
                                       GeeHashMap* variables);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void game_hub_data_game_set_last_launch (GameHubDataGame* self,
                                         gint64 value);
VALA_EXTERN gpointer game_hub_utils_run_task_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_run_task (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_run_task (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_run_task (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_run_task (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTask, game_hub_utils_run_task_unref)
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run (gchar** cmd,
                                         gint cmd_length1);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_dir (GameHubUtilsRunTask* self,
                                                  const gchar* dir);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_override_runtime (GameHubUtilsRunTask* self,
                                                               gboolean override_runtime);
VALA_EXTERN GType game_hub_data_tweakable_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweakableGame, g_object_unref)
VALA_EXTERN GType game_hub_data_tweaks_tweak_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweaksTweak, g_object_unref)
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_tweaks (GameHubUtilsRunTask* self,
                                                     GameHubDataTweaksTweak** tweaks,
                                                     gint tweaks_length1);
VALA_EXTERN GType game_hub_data_compat_tool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataCompatTool, g_object_unref)
VALA_EXTERN GameHubDataTweaksTweak** game_hub_data_tweakable_game_get_enabled_tweaks (GameHubDataTweakableGame* self,
                                                                          GameHubDataCompatTool* tool,
                                                                          gint* result_length1);
VALA_EXTERN void game_hub_utils_run_task_run_sync_thread (GameHubUtilsRunTask* self,
                                              gboolean capture_output,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gpointer game_hub_utils_run_task_result_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_result_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_run_task_param_spec_result (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_utils_run_task_value_set_result (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_utils_run_task_value_take_result (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_run_task_value_get_result (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_result_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTaskResult, game_hub_utils_run_task_result_unref)
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_run_sync_thread_finish (GameHubUtilsRunTask* self,
                                                                           GAsyncResult* _res_);
static void game_hub_data_game_run_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN gint64 game_hub_data_game_get_playtime_tracked (GameHubDataGame* self);
VALA_EXTERN gint64 game_hub_data_game_get_last_launch (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_playtime_tracked (GameHubDataGame* self,
                                              gint64 value);
static gboolean ___lambda132_ (GameHubDataGame* self);
static gboolean ____lambda132__gsource_func (gpointer self);
static void game_hub_data_game_run_or_install_data_free (gpointer _data);
VALA_EXTERN void game_hub_data_game_run_or_install (GameHubDataGame* self,
                                        gboolean show_compat,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_run_or_install_finish (GameHubDataGame* self,
                                               GAsyncResult* _res_);
static gboolean game_hub_data_game_run_or_install_co (GameHubDataGameRunOrInstallData* _data_);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_get_status (GameHubDataGame* self);
VALA_EXTERN gboolean game_hub_data_runnable_get_use_compat (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_run_with_compat (GameHubDataRunnable* self,
                                             gboolean is_opened_from_menu,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_with_compat_finish (GameHubDataRunnable* self,
                                                    GAsyncResult* _res_);
static void game_hub_data_game_run_or_install_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install (GameHubDataRunnable* self,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install_finish (GameHubDataRunnable* self,
                                            GAsyncResult* _res_);
static void game_hub_data_game_real_update_game_info_data_free (gpointer _data);
static void game_hub_data_game_real_update_game_info (GameHubDataGame* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean game_hub_data_game_real_update_game_info_co (GameHubDataGameUpdateGameInfoData* _data_);
VALA_EXTERN void game_hub_data_game_update_version (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_version (GameHubDataGame* self,
                                     const gchar* value);
VALA_EXTERN void game_hub_data_game_save_version (GameHubDataGame* self,
                                      const gchar* ver);
VALA_EXTERN GFile* game_hub_utils_fs_utils_mkdir (const gchar* path,
                                      const gchar* file,
                                      GeeHashMap* variables);
VALA_EXTERN GFile* game_hub_data_game_get_file (GameHubDataGame* self,
                                    const gchar* p,
                                    gboolean from_all_overlays);
VALA_EXTERN gboolean game_hub_data_game_get_overlays_enabled (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_game_overlay_get_id (GameHubDataGameOverlay* self);
static void _vala_array_add8 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN void game_hub_data_game_mount_overlays (GameHubDataGame* self,
                                        GFile* persist,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_mount_overlays_finish (GameHubDataGame* self,
                                               GAsyncResult* _res_);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
VALA_EXTERN void game_hub_data_game_enable_overlays (GameHubDataGame* self);
VALA_EXTERN GType game_hub_data_sources_gog_gog_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesGOGGOGGame, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_gog_gog_game_dlc_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesGOGGOGGameDLC, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_steam_steam_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesSteamSteamGame, g_object_unref)
VALA_EXTERN GType game_hub_utils_fs_overlay_root_path_safety_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameHubUtilsFSOverlayRootPathSafety game_hub_utils_fs_overlay_root_path_safety_for (GFile* root);
VALA_EXTERN GameHubDataGameOverlay* game_hub_data_game_overlay_new (GameHubDataGame* game,
                                                        const gchar* id,
                                                        const gchar* name,
                                                        gboolean enabled);
VALA_EXTERN GameHubDataGameOverlay* game_hub_data_game_overlay_construct (GType object_type,
                                                              GameHubDataGame* game,
                                                              const gchar* id,
                                                              const gchar* name,
                                                              gboolean enabled);
VALA_EXTERN void game_hub_data_game_save_overlays (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_game_overlay_get_name (GameHubDataGameOverlay* self);
VALA_EXTERN gboolean game_hub_data_game_overlay_get_enabled (GameHubDataGameOverlay* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void game_hub_data_game_load_overlays (GameHubDataGame* self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json_file (const gchar* path,
                                                 const gchar* file);
VALA_EXTERN JsonObject* game_hub_utils_parser_json_object (JsonNode* root,
                                               gchar** keys,
                                               gint keys_length1);
static void game_hub_data_game_mount_overlays_data_free (gpointer _data);
static gboolean game_hub_data_game_mount_overlays_co (GameHubDataGameMountOverlaysData* _data_);
static void game_hub_data_game_mount_overlays_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN GameHubUtilsFSOverlay* game_hub_utils_fs_overlay_new (GFile* target,
                                                      GeeArrayList* overlays,
                                                      GFile* persist,
                                                      GFile* workdir);
VALA_EXTERN GameHubUtilsFSOverlay* game_hub_utils_fs_overlay_construct (GType object_type,
                                                            GFile* target,
                                                            GeeArrayList* overlays,
                                                            GFile* persist,
                                                            GFile* workdir);
VALA_EXTERN const gchar* game_hub_utils_fs_overlay_get_options (GameHubUtilsFSOverlay* self);
VALA_EXTERN void game_hub_utils_fs_overlay_mount (GameHubUtilsFSOverlay* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void game_hub_utils_fs_overlay_mount_finish (GameHubUtilsFSOverlay* self,
                                             GAsyncResult* _res_);
static void game_hub_data_game_umount_overlays_data_free (gpointer _data);
VALA_EXTERN void game_hub_data_game_umount_overlays (GameHubDataGame* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_umount_overlays_finish (GameHubDataGame* self,
                                                GAsyncResult* _res_);
static gboolean game_hub_data_game_umount_overlays_co (GameHubDataGameUmountOverlaysData* _data_);
static void game_hub_data_game_umount_overlays_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN void game_hub_utils_fs_overlay_umount (GameHubUtilsFSOverlay* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void game_hub_utils_fs_overlay_umount_finish (GameHubUtilsFSOverlay* self,
                                              GAsyncResult* _res_);
static void game_hub_data_game_real_load_achievements_data_free (gpointer _data);
static void game_hub_data_game_real_load_achievements (GameHubDataGame* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean game_hub_data_game_real_load_achievements_co (GameHubDataGameLoadAchievementsData* _data_);
VALA_EXTERN gboolean game_hub_data_game_is_equal (GameHubDataGame* first,
                                      GameHubDataGame* second);
VALA_EXTERN GameHubDataGameSource* game_hub_data_game_get_source (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_runnable_get_id (GameHubDataRunnable* self);
VALA_EXTERN guint game_hub_data_game_hash (GameHubDataGame* game);
VALA_EXTERN gchar* game_hub_data_game_get_full_id (GameHubDataGame* self);
VALA_EXTERN GameHubDataGame* game_hub_data_game_construct (GType object_type);
VALA_EXTERN GameHubDataRunnable* game_hub_data_runnable_construct (GType object_type);
VALA_EXTERN void game_hub_data_game_set_source (GameHubDataGame* self,
                                    GameHubDataGameSource* value);
VALA_EXTERN const gchar* game_hub_data_game_get_description (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_description (GameHubDataGame* self,
                                         const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_icon (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_icon (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_image (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_image (GameHubDataGame* self,
                                   const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_image_vertical (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_image_vertical (GameHubDataGame* self,
                                            const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_info (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_info (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_info_detailed (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_info_detailed (GameHubDataGame* self,
                                           const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_source_get_id (GameHubDataGameSource* self);
VALA_EXTERN const gchar* game_hub_data_game_get_version (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_tags (GameHubDataGame* self,
                                  GeeArrayList* value);
VALA_EXTERN GFile* game_hub_data_game_get_installers_dir (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_installers_dir (GameHubDataGame* self,
                                            GFile* value);
VALA_EXTERN gboolean game_hub_data_game_get_is_installable (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_is_installable (GameHubDataGame* self,
                                            gboolean value);
VALA_EXTERN const gchar* game_hub_data_game_get_store_page (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_store_page (GameHubDataGame* self,
                                        const gchar* value);
VALA_EXTERN void game_hub_data_game_set_status (GameHubDataGame* self,
                                    GameHubDataGameStatus* value);
VALA_EXTERN gint64 game_hub_data_game_get_playtime_source (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_playtime_source (GameHubDataGame* self,
                                             gint64 value);
VALA_EXTERN gint64 game_hub_data_game_get_playtime (GameHubDataGame* self);
VALA_EXTERN GeeArrayList* game_hub_data_game_get_achievements (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_achievements (GameHubDataGame* self,
                                          GeeArrayList* value);
static void g_cclosure_user_marshal_VOID__GAME_HUB_DATA_GAME_STATUS (GClosure * closure,
                                                              GValue * return_value,
                                                              guint n_param_values,
                                                              const GValue * param_values,
                                                              gpointer invocation_hint,
                                                              gpointer marshal_data);
VALA_EXTERN void game_hub_data_game_overlay_set_enabled (GameHubDataGameOverlay* self,
                                             gboolean value);
VALA_EXTERN void game_hub_data_game_overlay_remove (GameHubDataGameOverlay* self);
VALA_EXTERN gboolean game_hub_data_game_overlay_get_removable (GameHubDataGameOverlay* self);
VALA_EXTERN GameHubDataGame* game_hub_data_game_overlay_get_game (GameHubDataGameOverlay* self);
static void __lambda23_ (GameHubDataGameOverlay* self,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN void game_hub_utils_fs_utils_rm (const gchar* path,
                                 const gchar* file,
                                 const gchar* flags,
                                 GeeHashMap* variables);
VALA_EXTERN void game_hub_utils_fs_utils_mv_up (GFile* path,
                                    const gchar* dirname);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void game_hub_data_game_overlay_set_game (GameHubDataGameOverlay* self,
                                          GameHubDataGame* value);
static void game_hub_data_game_overlay_set_id (GameHubDataGameOverlay* self,
                                        const gchar* value);
static void game_hub_data_game_overlay_set_name (GameHubDataGameOverlay* self,
                                          const gchar* value);
static GObject * game_hub_data_game_overlay_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void game_hub_data_game_overlay_finalize (GObject * obj);
static GType game_hub_data_game_overlay_get_type_once (void);
static void _vala_game_hub_data_game_overlay_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_game_hub_data_game_overlay_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN gchar* game_hub_data_game_status_get_description (GameHubDataGameStatus* self);
VALA_EXTERN gboolean game_hub_data_runnable_get_is_running (GameHubDataRunnable* self);
VALA_EXTERN gpointer game_hub_utils_downloader_download_status_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_download_param_spec_status (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_download_value_set_status (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_download_value_take_status (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_download_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownloadStatus, game_hub_utils_downloader_download_status_unref)
VALA_EXTERN GameHubUtilsDownloaderDownloadStatus* game_hub_utils_downloader_download_get_status (GameHubUtilsDownloaderDownload* self);
VALA_EXTERN gchar* game_hub_utils_downloader_download_status_get_description (GameHubUtilsDownloaderDownloadStatus* self);
VALA_EXTERN gchar* game_hub_data_game_status_get_header (GameHubDataGameStatus* self);
static void game_hub_data_game_status_finalize (GameHubDataGameStatus * obj);
static GType game_hub_data_game_status_get_type_once (void);
VALA_EXTERN GameHubDataGameAchievement* game_hub_data_game_achievement_construct (GType object_type);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_id (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_id (GameHubDataGameAchievement* self,
                                            const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_name (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_name (GameHubDataGameAchievement* self,
                                              const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_description (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_description (GameHubDataGameAchievement* self,
                                                     const gchar* value);
VALA_EXTERN gboolean game_hub_data_game_achievement_get_unlocked (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_unlocked (GameHubDataGameAchievement* self,
                                                  gboolean value);
VALA_EXTERN GDateTime* game_hub_data_game_achievement_get_unlock_date (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_unlock_date (GameHubDataGameAchievement* self,
                                                     GDateTime* value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_unlock_time (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_unlock_time (GameHubDataGameAchievement* self,
                                                     const gchar* value);
VALA_EXTERN gfloat game_hub_data_game_achievement_get_global_percentage (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_global_percentage (GameHubDataGameAchievement* self,
                                                           gfloat value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_image_locked (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_image_locked (GameHubDataGameAchievement* self,
                                                      const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_image_unlocked (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_image_unlocked (GameHubDataGameAchievement* self,
                                                        const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_achievement_get_image (GameHubDataGameAchievement* self);
static void game_hub_data_game_achievement_finalize (GameHubDataGameAchievement * obj);
static GType game_hub_data_game_achievement_get_type_once (void);
static void game_hub_data_game_finalize (GObject * obj);
static GType game_hub_data_game_get_type_once (void);
static void _vala_game_hub_data_game_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_game_hub_data_game_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GeeHashMap* game_hub_data_tweaks_tweak_load_tweaks (gboolean refresh);
VALA_EXTERN gboolean game_hub_data_tweaks_tweak_is_enabled (GameHubDataTweaksTweak* self,
                                                GameHubDataTweakableGame* game);
VALA_EXTERN gboolean game_hub_data_tweaks_tweak_is_applicable_to (GameHubDataTweaksTweak* self,
                                                      GameHubDataTweakableGame* game,
                                                      GameHubDataCompatTool* compat_tool);
static void _vala_array_add9 (GameHubDataTweaksTweak** * array,
                       gint* length,
                       gint* size,
                       GameHubDataTweaksTweak* value);
VALA_EXTERN gchar** game_hub_data_tweakable_game_get_tweaks (GameHubDataTweakableGame* self,
                                                 gint* result_length1);
VALA_EXTERN void game_hub_data_tweakable_game_set_tweaks (GameHubDataTweakableGame* self,
                                              gchar** value,
                                              gint value_length1);
static GType game_hub_data_tweakable_game_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_hub_data_game_get_instance_private (GameHubDataGame* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataGame_private_offset);
}

 G_GNUC_NO_INLINE static GType
game_hub_data_game_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_HUB_DATA_GAME_STATE_UNINSTALLED, "GAME_HUB_DATA_GAME_STATE_UNINSTALLED", "uninstalled"}, {GAME_HUB_DATA_GAME_STATE_INSTALLED, "GAME_HUB_DATA_GAME_STATE_INSTALLED", "installed"}, {GAME_HUB_DATA_GAME_STATE_DOWNLOADING, "GAME_HUB_DATA_GAME_STATE_DOWNLOADING", "downloading"}, {GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY, "GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY", "verifying-installer-integrity"}, {GAME_HUB_DATA_GAME_STATE_INSTALLING, "GAME_HUB_DATA_GAME_STATE_INSTALLING", "installing"}, {0, NULL, NULL}};
	GType game_hub_data_game_state_type_id;
	game_hub_data_game_state_type_id = g_enum_register_static ("GameHubDataGameState", values);
	return game_hub_data_game_state_type_id;
}

GType
game_hub_data_game_state_get_type (void)
{
	static volatile gsize game_hub_data_game_state_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_game_state_type_id__once)) {
		GType game_hub_data_game_state_type_id;
		game_hub_data_game_state_type_id = game_hub_data_game_state_get_type_once ();
		g_once_init_leave (&game_hub_data_game_state_type_id__once, game_hub_data_game_state_type_id);
	}
	return game_hub_data_game_state_type_id__once;
}

static gboolean
_game_hub_data_db_tables_tags_tag_is_equal_gee_equal_data_func (gconstpointer a,
                                                                gconstpointer b,
                                                                gpointer self)
{
	gboolean result;
	result = game_hub_data_db_tables_tags_tag_is_equal ((GameHubDataDBTablesTagsTag*) a, (GameHubDataDBTablesTagsTag*) b);
#line 45 "../src/data/Game.vala"
	return result;
#line 1267 "Game.c"
}

gboolean
game_hub_data_game_has_tag (GameHubDataGame* self,
                            GameHubDataDBTablesTagsTag* tag)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
#line 46 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 46 "../src/data/Game.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 48 "../src/data/Game.vala"
	_tmp0_ = game_hub_data_db_tables_tags_tag_get_id (tag);
#line 48 "../src/data/Game.vala"
	_tmp1_ = _tmp0_;
#line 48 "../src/data/Game.vala"
	result = game_hub_data_game_has_tag_id (self, _tmp1_);
#line 48 "../src/data/Game.vala"
	return result;
#line 1289 "Game.c"
}

gboolean
game_hub_data_game_has_tag_id (GameHubDataGame* self,
                               const gchar* tag)
{
	gboolean result;
#line 50 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 50 "../src/data/Game.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 1301 "Game.c"
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp0_;
		gint _t_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _t_index = 0;
#line 52 "../src/data/Game.vala"
		_tmp0_ = self->priv->_tags;
#line 52 "../src/data/Game.vala"
		_t_list = _tmp0_;
#line 52 "../src/data/Game.vala"
		_tmp1_ = _t_list;
#line 52 "../src/data/Game.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 52 "../src/data/Game.vala"
		_tmp3_ = _tmp2_;
#line 52 "../src/data/Game.vala"
		_t_size = _tmp3_;
#line 52 "../src/data/Game.vala"
		_t_index = -1;
#line 52 "../src/data/Game.vala"
		while (TRUE) {
#line 1326 "Game.c"
			gint _tmp4_;
			gint _tmp5_;
			GameHubDataDBTablesTagsTag* t = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GameHubDataDBTablesTagsTag* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
#line 52 "../src/data/Game.vala"
			_t_index = _t_index + 1;
#line 52 "../src/data/Game.vala"
			_tmp4_ = _t_index;
#line 52 "../src/data/Game.vala"
			_tmp5_ = _t_size;
#line 52 "../src/data/Game.vala"
			if (!(_tmp4_ < _tmp5_)) {
#line 52 "../src/data/Game.vala"
				break;
#line 1345 "Game.c"
			}
#line 52 "../src/data/Game.vala"
			_tmp6_ = _t_list;
#line 52 "../src/data/Game.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _t_index);
#line 52 "../src/data/Game.vala"
			t = (GameHubDataDBTablesTagsTag*) _tmp7_;
#line 54 "../src/data/Game.vala"
			_tmp8_ = t;
#line 54 "../src/data/Game.vala"
			_tmp9_ = game_hub_data_db_tables_tags_tag_get_id (_tmp8_);
#line 54 "../src/data/Game.vala"
			_tmp10_ = _tmp9_;
#line 54 "../src/data/Game.vala"
			if (g_strcmp0 (_tmp10_, tag) == 0) {
#line 54 "../src/data/Game.vala"
				result = TRUE;
#line 54 "../src/data/Game.vala"
				_g_object_unref0 (t);
#line 54 "../src/data/Game.vala"
				return result;
#line 1367 "Game.c"
			}
#line 52 "../src/data/Game.vala"
			_g_object_unref0 (t);
#line 1371 "Game.c"
		}
	}
#line 56 "../src/data/Game.vala"
	result = FALSE;
#line 56 "../src/data/Game.vala"
	return result;
#line 1378 "Game.c"
}

void
game_hub_data_game_add_tag (GameHubDataGame* self,
                            GameHubDataDBTablesTagsTag* tag)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
#line 58 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 58 "../src/data/Game.vala"
	g_return_if_fail (tag != NULL);
#line 60 "../src/data/Game.vala"
	_tmp0_ = self->priv->_tags;
#line 60 "../src/data/Game.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, tag)) {
#line 1395 "Game.c"
		GeeArrayList* _tmp1_;
#line 62 "../src/data/Game.vala"
		_tmp1_ = self->priv->_tags;
#line 62 "../src/data/Game.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, tag);
#line 1401 "Game.c"
	}
#line 64 "../src/data/Game.vala"
	_tmp2_ = game_hub_data_db_tables_tags_DYNAMIC_TAGS;
#line 64 "../src/data/Game.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, tag)) {
#line 1407 "Game.c"
		GameHubDataGameStatus* _tmp3_;
#line 66 "../src/data/Game.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 67 "../src/data/Game.vala"
		_tmp3_ = self->_status;
#line 67 "../src/data/Game.vala"
		g_signal_emit (self, game_hub_data_game_signals[GAME_HUB_DATA_GAME_STATUS_CHANGE_SIGNAL], 0, _tmp3_);
#line 68 "../src/data/Game.vala"
		g_signal_emit (self, game_hub_data_game_signals[GAME_HUB_DATA_GAME_TAGS_UPDATE_SIGNAL], 0);
#line 1417 "Game.c"
	}
}

void
game_hub_data_game_remove_tag (GameHubDataGame* self,
                               GameHubDataDBTablesTagsTag* tag)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
#line 71 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 71 "../src/data/Game.vala"
	g_return_if_fail (tag != NULL);
#line 73 "../src/data/Game.vala"
	_tmp0_ = self->priv->_tags;
#line 73 "../src/data/Game.vala"
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, tag)) {
#line 1435 "Game.c"
		GeeArrayList* _tmp1_;
#line 75 "../src/data/Game.vala"
		_tmp1_ = self->priv->_tags;
#line 75 "../src/data/Game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, tag);
#line 1441 "Game.c"
	}
#line 77 "../src/data/Game.vala"
	_tmp2_ = game_hub_data_db_tables_tags_DYNAMIC_TAGS;
#line 77 "../src/data/Game.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, tag)) {
#line 1447 "Game.c"
		GameHubDataGameStatus* _tmp3_;
#line 79 "../src/data/Game.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 80 "../src/data/Game.vala"
		_tmp3_ = self->_status;
#line 80 "../src/data/Game.vala"
		g_signal_emit (self, game_hub_data_game_signals[GAME_HUB_DATA_GAME_STATUS_CHANGE_SIGNAL], 0, _tmp3_);
#line 81 "../src/data/Game.vala"
		g_signal_emit (self, game_hub_data_game_signals[GAME_HUB_DATA_GAME_TAGS_UPDATE_SIGNAL], 0);
#line 1457 "Game.c"
	}
}

void
game_hub_data_game_toggle_tag (GameHubDataGame* self,
                               GameHubDataDBTablesTagsTag* tag)
{
	GeeArrayList* _tmp0_;
#line 84 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 84 "../src/data/Game.vala"
	g_return_if_fail (tag != NULL);
#line 86 "../src/data/Game.vala"
	_tmp0_ = self->priv->_tags;
#line 86 "../src/data/Game.vala"
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, tag)) {
#line 88 "../src/data/Game.vala"
		game_hub_data_game_remove_tag (self, tag);
#line 1476 "Game.c"
	} else {
#line 92 "../src/data/Game.vala"
		game_hub_data_game_add_tag (self, tag);
#line 1480 "Game.c"
	}
}

static void
game_hub_data_game_real_save (GameHubDataRunnable* base)
{
	GameHubDataGame * self;
#line 96 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 98 "../src/data/Game.vala"
	game_hub_data_db_tables_games_add (self);
#line 1492 "Game.c"
}

void
game_hub_data_game_uninstall (GameHubDataGame* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->uninstall) {
#line 28 "../src/data/Game.vala"
		_klass_->uninstall (self, _callback_, _user_data_);
#line 1507 "Game.c"
	}
}

void
game_hub_data_game_uninstall_finish (GameHubDataGame* self,
                                     GAsyncResult* _res_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->uninstall_finish) {
#line 28 "../src/data/Game.vala"
		_klass_->uninstall_finish (self, _res_);
#line 1522 "Game.c"
	}
}

static void
game_hub_data_game_real_run_data_free (gpointer _data)
{
	GameHubDataGameRunData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameRunData, _data_);
#line 1535 "Game.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 28 "../src/data/Game.vala"
	return self ? g_object_ref (self) : NULL;
#line 1543 "Game.c"
}

static void
game_hub_data_game_real_run (GameHubDataRunnable* base,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GameHubDataGame * self;
	GameHubDataGameRunData* _data_;
	GameHubDataGame* _tmp0_;
#line 28 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameRunData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_real_run_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_real_run_co (_data_);
#line 1568 "Game.c"
}

static void
game_hub_data_game_run_finish (GameHubDataRunnable* base,
                               GAsyncResult* _res_)
{
	GameHubDataGameRunData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1578 "Game.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1600 "Game.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1604 "Game.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1610 "Game.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1614 "Game.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1618 "Game.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1626 "Game.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1654 "Game.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1663 "Game.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1677 "Game.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1686 "Game.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1700 "Game.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1709 "Game.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1718 "Game.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 127 "../src/data/Game.vala"
	for (i = 0; i < stack_length; i++) {
#line 127 "../src/data/Game.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 127 "../src/data/Game.vala"
			return TRUE;
#line 1733 "Game.c"
		}
	}
#line 127 "../src/data/Game.vala"
	return FALSE;
#line 1738 "Game.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1757 "Game.c"
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 138 "../src/data/Game.vala"
	if ((*length) == (*size)) {
#line 138 "../src/data/Game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 138 "../src/data/Game.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1772 "Game.c"
	}
#line 138 "../src/data/Game.vala"
	(*array)[(*length)++] = value;
#line 138 "../src/data/Game.vala"
	(*array)[*length] = NULL;
#line 1778 "Game.c"
}

static void
game_hub_data_game_run_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GameHubDataGameRunData* _data_;
#line 151 "../src/data/Game.vala"
	_data_ = _user_data_;
#line 151 "../src/data/Game.vala"
	_data_->_source_object_ = source_object;
#line 151 "../src/data/Game.vala"
	_data_->_res_ = _res_;
#line 151 "../src/data/Game.vala"
	game_hub_data_game_real_run_co (_data_);
#line 1795 "Game.c"
}

static gboolean
___lambda132_ (GameHubDataGame* self)
{
	gboolean result;
#line 157 "../src/data/Game.vala"
	game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) self, FALSE);
#line 157 "../src/data/Game.vala"
	game_hub_data_runnable_IsLaunched = FALSE;
#line 158 "../src/data/Game.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 159 "../src/data/Game.vala"
	result = G_SOURCE_REMOVE;
#line 159 "../src/data/Game.vala"
	return result;
#line 1812 "Game.c"
}

static gboolean
____lambda132__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda132_ ((GameHubDataGame*) self);
#line 156 "../src/data/Game.vala"
	return result;
#line 1822 "Game.c"
}

static gboolean
game_hub_data_game_real_run_co (GameHubDataGameRunData* _data_)
{
#line 110 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 110 "../src/data/Game.vala"
		case 0:
#line 1832 "Game.c"
		goto _state_0;
#line 110 "../src/data/Game.vala"
		case 1:
#line 1836 "Game.c"
		goto _state_1;
		default:
#line 110 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 1841 "Game.c"
	}
	_state_0:
#line 112 "../src/data/Game.vala"
	if (game_hub_data_runnable_can_be_launched ((GameHubDataRunnable*) _data_->self, TRUE)) {
#line 112 "../src/data/Game.vala"
		_data_->_tmp1_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 112 "../src/data/Game.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 112 "../src/data/Game.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 112 "../src/data/Game.vala"
		_data_->_tmp0_ = g_file_query_exists (_data_->_tmp3_, NULL);
#line 112 "../src/data/Game.vala"
		_g_object_unref0 (_data_->_tmp3_);
#line 1856 "Game.c"
	} else {
#line 112 "../src/data/Game.vala"
		_data_->_tmp0_ = FALSE;
#line 1860 "Game.c"
	}
#line 112 "../src/data/Game.vala"
	if (_data_->_tmp0_) {
#line 114 "../src/data/Game.vala"
		game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data_->self, TRUE);
#line 114 "../src/data/Game.vala"
		game_hub_data_runnable_IsLaunched = TRUE;
#line 115 "../src/data/Game.vala"
		game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 117 "../src/data/Game.vala"
		_data_->_tmp4_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 117 "../src/data/Game.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 117 "../src/data/Game.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 117 "../src/data/Game.vala"
		_data_->_tmp7_ = g_file_get_path (_data_->_tmp6_);
#line 117 "../src/data/Game.vala"
		_data_->_tmp8_ = g_new0 (gchar*, 1 + 1);
#line 117 "../src/data/Game.vala"
		_data_->_tmp8_[0] = _data_->_tmp7_;
#line 117 "../src/data/Game.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 117 "../src/data/Game.vala"
		_data_->_tmp9__length1 = 1;
#line 117 "../src/data/Game.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 117 "../src/data/Game.vala"
		_data_->cmd = _data_->_tmp9_;
#line 117 "../src/data/Game.vala"
		_data_->cmd_length1 = _data_->_tmp9__length1;
#line 117 "../src/data/Game.vala"
		_data_->_cmd_size_ = _data_->cmd_length1;
#line 119 "../src/data/Game.vala"
		_data_->_tmp11_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) _data_->self);
#line 119 "../src/data/Game.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 119 "../src/data/Game.vala"
		if (_data_->_tmp12_ != NULL) {
#line 119 "../src/data/Game.vala"
			_data_->_tmp13_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) _data_->self);
#line 119 "../src/data/Game.vala"
			_data_->_tmp14_ = _data_->_tmp13_;
#line 119 "../src/data/Game.vala"
			_data_->_tmp15_ = strlen (_data_->_tmp14_);
#line 119 "../src/data/Game.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 119 "../src/data/Game.vala"
			_data_->_tmp10_ = _data_->_tmp16_ > 0;
#line 1910 "Game.c"
		} else {
#line 119 "../src/data/Game.vala"
			_data_->_tmp10_ = FALSE;
#line 1914 "Game.c"
		}
#line 119 "../src/data/Game.vala"
		if (_data_->_tmp10_) {
#line 121 "../src/data/Game.vala"
			_data_->_tmp17_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 121 "../src/data/Game.vala"
			_data_->variables = _data_->_tmp17_;
#line 122 "../src/data/Game.vala"
			_data_->_tmp18_ = _data_->variables;
#line 122 "../src/data/Game.vala"
			_data_->_tmp19_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) _data_->self);
#line 122 "../src/data/Game.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 122 "../src/data/Game.vala"
			_data_->_tmp21_ = string_replace (_data_->_tmp20_, ": ", " - ");
#line 122 "../src/data/Game.vala"
			_data_->_tmp22_ = _data_->_tmp21_;
#line 122 "../src/data/Game.vala"
			_data_->_tmp23_ = string_replace (_data_->_tmp22_, ":", "");
#line 122 "../src/data/Game.vala"
			_data_->_tmp24_ = _data_->_tmp23_;
#line 122 "../src/data/Game.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp18_, "game", _data_->_tmp24_);
#line 122 "../src/data/Game.vala"
			_g_free0 (_data_->_tmp24_);
#line 122 "../src/data/Game.vala"
			_g_free0 (_data_->_tmp22_);
#line 123 "../src/data/Game.vala"
			_data_->_tmp25_ = _data_->variables;
#line 123 "../src/data/Game.vala"
			_data_->_tmp26_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 123 "../src/data/Game.vala"
			_data_->_tmp27_ = _data_->_tmp26_;
#line 123 "../src/data/Game.vala"
			_data_->_tmp28_ = g_file_get_path (_data_->_tmp27_);
#line 123 "../src/data/Game.vala"
			_data_->_tmp29_ = _data_->_tmp28_;
#line 123 "../src/data/Game.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp25_, "game_dir", _data_->_tmp29_);
#line 123 "../src/data/Game.vala"
			_g_free0 (_data_->_tmp29_);
#line 124 "../src/data/Game.vala"
			_data_->_tmp30_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) _data_->self);
#line 124 "../src/data/Game.vala"
			_data_->_tmp31_ = _data_->_tmp30_;
#line 124 "../src/data/Game.vala"
			_data_->_tmp32_ = 0;
#line 124 "../src/data/Game.vala"
			_data_->_tmp33_ = game_hub_utils_parse_args (_data_->_tmp31_, &_data_->_tmp32_);
#line 124 "../src/data/Game.vala"
			_data_->args = _data_->_tmp33_;
#line 124 "../src/data/Game.vala"
			_data_->args_length1 = _data_->_tmp32_;
#line 124 "../src/data/Game.vala"
			_data_->_args_size_ = _data_->args_length1;
#line 125 "../src/data/Game.vala"
			_data_->_tmp34_ = _data_->args;
#line 125 "../src/data/Game.vala"
			_data_->_tmp34__length1 = _data_->args_length1;
#line 125 "../src/data/Game.vala"
			if (_data_->_tmp34_ != NULL) {
#line 127 "../src/data/Game.vala"
				_data_->_tmp36_ = _data_->args;
#line 127 "../src/data/Game.vala"
				_data_->_tmp36__length1 = _data_->args_length1;
#line 127 "../src/data/Game.vala"
				if (_vala_string_array_contains (_data_->_tmp36_, _data_->_tmp36__length1, "$command")) {
#line 127 "../src/data/Game.vala"
					_data_->_tmp35_ = TRUE;
#line 1984 "Game.c"
				} else {
#line 127 "../src/data/Game.vala"
					_data_->_tmp37_ = _data_->args;
#line 127 "../src/data/Game.vala"
					_data_->_tmp37__length1 = _data_->args_length1;
#line 127 "../src/data/Game.vala"
					_data_->_tmp35_ = _vala_string_array_contains (_data_->_tmp37_, _data_->_tmp37__length1, "${command}");
#line 1992 "Game.c"
				}
#line 127 "../src/data/Game.vala"
				if (_data_->_tmp35_) {
#line 129 "../src/data/Game.vala"
					_data_->_tmp38_ = g_new0 (gchar*, 0 + 1);
#line 129 "../src/data/Game.vala"
					_data_->cmd = (_vala_array_free (_data_->cmd, _data_->cmd_length1, (GDestroyNotify) g_free), NULL);
#line 129 "../src/data/Game.vala"
					_data_->cmd = _data_->_tmp38_;
#line 129 "../src/data/Game.vala"
					_data_->cmd_length1 = 0;
#line 129 "../src/data/Game.vala"
					_data_->_cmd_size_ = _data_->cmd_length1;
#line 130 "../src/data/Game.vala"
					_data_->_tmp39_ = _data_->variables;
#line 130 "../src/data/Game.vala"
					_data_->_tmp40_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 130 "../src/data/Game.vala"
					_data_->_tmp41_ = _data_->_tmp40_;
#line 130 "../src/data/Game.vala"
					_data_->_tmp42_ = _data_->_tmp41_;
#line 130 "../src/data/Game.vala"
					_data_->_tmp43_ = g_file_get_path (_data_->_tmp42_);
#line 130 "../src/data/Game.vala"
					_data_->_tmp44_ = _data_->_tmp43_;
#line 130 "../src/data/Game.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp39_, "command", _data_->_tmp44_);
#line 130 "../src/data/Game.vala"
					_g_free0 (_data_->_tmp44_);
#line 130 "../src/data/Game.vala"
					_g_object_unref0 (_data_->_tmp42_);
#line 2024 "Game.c"
				}
#line 132 "../src/data/Game.vala"
				_data_->_tmp45_ = _data_->args;
#line 132 "../src/data/Game.vala"
				_data_->_tmp45__length1 = _data_->args_length1;
#line 2030 "Game.c"
				{
#line 132 "../src/data/Game.vala"
					_data_->arg_collection_length1 = 0;
#line 132 "../src/data/Game.vala"
					_data_->_arg_collection_size_ = 0;
#line 132 "../src/data/Game.vala"
					_data_->arg_collection = _data_->_tmp45_;
#line 132 "../src/data/Game.vala"
					_data_->arg_collection_length1 = _data_->_tmp45__length1;
#line 132 "../src/data/Game.vala"
					for (_data_->arg_it = 0; _data_->arg_it < _data_->arg_collection_length1; _data_->arg_it = _data_->arg_it + 1) {
#line 132 "../src/data/Game.vala"
						_data_->_tmp46_ = g_strdup (_data_->arg_collection[_data_->arg_it]);
#line 132 "../src/data/Game.vala"
						_data_->arg = _data_->_tmp46_;
#line 2046 "Game.c"
						{
#line 134 "../src/data/Game.vala"
							_data_->_tmp47_ = _data_->arg;
#line 134 "../src/data/Game.vala"
							if (string_contains (_data_->_tmp47_, "$")) {
#line 136 "../src/data/Game.vala"
								_data_->_tmp48_ = _data_->arg;
#line 136 "../src/data/Game.vala"
								_data_->_tmp49_ = _data_->variables;
#line 136 "../src/data/Game.vala"
								_data_->_tmp50_ = game_hub_utils_fs_utils_expand (_data_->_tmp48_, NULL, _data_->_tmp49_);
#line 136 "../src/data/Game.vala"
								_g_free0 (_data_->arg);
#line 136 "../src/data/Game.vala"
								_data_->arg = _data_->_tmp50_;
#line 2062 "Game.c"
							}
#line 138 "../src/data/Game.vala"
							_data_->_tmp51_ = _data_->arg;
#line 138 "../src/data/Game.vala"
							_data_->_tmp52_ = g_strdup (_data_->_tmp51_);
#line 138 "../src/data/Game.vala"
							_vala_array_add7 (&_data_->cmd, &_data_->cmd_length1, &_data_->_cmd_size_, _data_->_tmp52_);
#line 132 "../src/data/Game.vala"
							_g_free0 (_data_->arg);
#line 2072 "Game.c"
						}
					}
				}
			}
#line 119 "../src/data/Game.vala"
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 119 "../src/data/Game.vala"
			_g_object_unref0 (_data_->variables);
#line 2081 "Game.c"
		}
#line 143 "../src/data/Game.vala"
		game_hub_data_game_set_last_launch (_data_->self, g_get_real_time () / 1000000);
#line 144 "../src/data/Game.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 146 "../src/data/Game.vala"
		_data_->_tmp53_ = _data_->cmd;
#line 146 "../src/data/Game.vala"
		_data_->_tmp53__length1 = _data_->cmd_length1;
#line 146 "../src/data/Game.vala"
		_data_->_tmp54_ = game_hub_utils_run (_data_->_tmp53_, (gint) _data_->_tmp53__length1);
#line 146 "../src/data/Game.vala"
		_data_->_tmp55_ = _data_->_tmp54_;
#line 146 "../src/data/Game.vala"
		_data_->_tmp56_ = game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) _data_->self);
#line 146 "../src/data/Game.vala"
		_data_->_tmp57_ = _data_->_tmp56_;
#line 146 "../src/data/Game.vala"
		_data_->_tmp58_ = _data_->_tmp57_;
#line 146 "../src/data/Game.vala"
		_data_->_tmp59_ = g_file_get_path (_data_->_tmp58_);
#line 146 "../src/data/Game.vala"
		_data_->_tmp60_ = _data_->_tmp59_;
#line 146 "../src/data/Game.vala"
		_data_->_tmp61_ = game_hub_utils_run_task_dir (_data_->_tmp55_, _data_->_tmp60_);
#line 146 "../src/data/Game.vala"
		_data_->_tmp62_ = _data_->_tmp61_;
#line 146 "../src/data/Game.vala"
		_data_->_tmp63_ = game_hub_utils_run_task_override_runtime (_data_->_tmp62_, TRUE);
#line 146 "../src/data/Game.vala"
		_data_->_tmp64_ = _data_->_tmp63_;
#line 146 "../src/data/Game.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp62_);
#line 146 "../src/data/Game.vala"
		_g_free0 (_data_->_tmp60_);
#line 146 "../src/data/Game.vala"
		_g_object_unref0 (_data_->_tmp58_);
#line 146 "../src/data/Game.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp55_);
#line 146 "../src/data/Game.vala"
		_data_->task = _data_->_tmp64_;
#line 147 "../src/data/Game.vala"
		if (GAME_HUB_DATA_IS_TWEAKABLE_GAME (_data_->self)) {
#line 149 "../src/data/Game.vala"
			_data_->_tmp65_ = _data_->task;
#line 149 "../src/data/Game.vala"
			_data_->_tmp66_ = 0;
#line 149 "../src/data/Game.vala"
			_data_->_tmp67_ = game_hub_data_tweakable_game_get_enabled_tweaks (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGame), NULL, &_data_->_tmp66_);
#line 149 "../src/data/Game.vala"
			_data_->_tmp68_ = _data_->_tmp67_;
#line 149 "../src/data/Game.vala"
			_data_->_tmp68__length1 = _data_->_tmp66_;
#line 149 "../src/data/Game.vala"
			_data_->_tmp69_ = game_hub_utils_run_task_tweaks (_data_->_tmp65_, _data_->_tmp68_, (gint) _data_->_tmp66_);
#line 149 "../src/data/Game.vala"
			_data_->_tmp70_ = _data_->_tmp69_;
#line 149 "../src/data/Game.vala"
			_game_hub_utils_run_task_unref0 (_data_->_tmp70_);
#line 149 "../src/data/Game.vala"
			_data_->_tmp68_ = (_vala_array_free (_data_->_tmp68_, _data_->_tmp68__length1, (GDestroyNotify) g_object_unref), NULL);
#line 2143 "Game.c"
		}
#line 151 "../src/data/Game.vala"
		_data_->_tmp71_ = _data_->task;
#line 151 "../src/data/Game.vala"
		_data_->_state_ = 1;
#line 151 "../src/data/Game.vala"
		game_hub_utils_run_task_run_sync_thread (_data_->_tmp71_, FALSE, game_hub_data_game_run_ready, _data_);
#line 151 "../src/data/Game.vala"
		return FALSE;
#line 2153 "Game.c"
		_state_1:
#line 151 "../src/data/Game.vala"
		_data_->_tmp72_ = game_hub_utils_run_task_run_sync_thread_finish (_data_->_tmp71_, _data_->_res_);
#line 151 "../src/data/Game.vala"
		_data_->_tmp73_ = _data_->_tmp72_;
#line 151 "../src/data/Game.vala"
		_game_hub_utils_run_task_result_unref0 (_data_->_tmp73_);
#line 153 "../src/data/Game.vala"
		_data_->_tmp74_ = _data_->self->priv->_playtime_tracked;
#line 153 "../src/data/Game.vala"
		_data_->_tmp75_ = _data_->self->priv->_last_launch;
#line 153 "../src/data/Game.vala"
		game_hub_data_game_set_playtime_tracked (_data_->self, _data_->_tmp74_ + (((g_get_real_time () / 1000000) - _data_->_tmp75_) / 60));
#line 154 "../src/data/Game.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 156 "../src/data/Game.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda132__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 112 "../src/data/Game.vala"
		_game_hub_utils_run_task_unref0 (_data_->task);
#line 112 "../src/data/Game.vala"
		_data_->cmd = (_vala_array_free (_data_->cmd, _data_->cmd_length1, (GDestroyNotify) g_free), NULL);
#line 2175 "Game.c"
	}
#line 110 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 110 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 110 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 110 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2185 "Game.c"
		}
	}
#line 110 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 110 "../src/data/Game.vala"
	return FALSE;
#line 2192 "Game.c"
}

static void
game_hub_data_game_run_or_install_data_free (gpointer _data)
{
	GameHubDataGameRunOrInstallData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameRunOrInstallData, _data_);
#line 2204 "Game.c"
}

void
game_hub_data_game_run_or_install (GameHubDataGame* self,
                                   gboolean show_compat,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GameHubDataGameRunOrInstallData* _data_;
	GameHubDataGame* _tmp0_;
#line 28 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameRunOrInstallData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_run_or_install_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	_data_->show_compat = show_compat;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_run_or_install_co (_data_);
#line 2231 "Game.c"
}

void
game_hub_data_game_run_or_install_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_)
{
	GameHubDataGameRunOrInstallData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2241 "Game.c"
}

static void
game_hub_data_game_run_or_install_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GameHubDataGameRunOrInstallData* _data_;
#line 170 "../src/data/Game.vala"
	_data_ = _user_data_;
#line 170 "../src/data/Game.vala"
	_data_->_source_object_ = source_object;
#line 170 "../src/data/Game.vala"
	_data_->_res_ = _res_;
#line 170 "../src/data/Game.vala"
	game_hub_data_game_run_or_install_co (_data_);
#line 2258 "Game.c"
}

static gboolean
game_hub_data_game_run_or_install_co (GameHubDataGameRunOrInstallData* _data_)
{
#line 164 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 164 "../src/data/Game.vala"
		case 0:
#line 2268 "Game.c"
		goto _state_0;
#line 164 "../src/data/Game.vala"
		case 1:
#line 2272 "Game.c"
		goto _state_1;
#line 164 "../src/data/Game.vala"
		case 2:
#line 2276 "Game.c"
		goto _state_2;
#line 164 "../src/data/Game.vala"
		case 3:
#line 2280 "Game.c"
		goto _state_3;
		default:
#line 164 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 2285 "Game.c"
	}
	_state_0:
#line 166 "../src/data/Game.vala"
	_data_->_tmp0_ = game_hub_data_game_get_status (_data_->self);
#line 166 "../src/data/Game.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 166 "../src/data/Game.vala"
	if (_data_->_tmp1_->state == GAME_HUB_DATA_GAME_STATE_INSTALLED) {
#line 168 "../src/data/Game.vala"
		_data_->_tmp2_ = game_hub_data_runnable_get_use_compat ((GameHubDataRunnable*) _data_->self);
#line 168 "../src/data/Game.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 168 "../src/data/Game.vala"
		if (_data_->_tmp3_) {
#line 170 "../src/data/Game.vala"
			_data_->_state_ = 1;
#line 170 "../src/data/Game.vala"
			game_hub_data_runnable_run_with_compat ((GameHubDataRunnable*) _data_->self, _data_->show_compat, game_hub_data_game_run_or_install_ready, _data_);
#line 170 "../src/data/Game.vala"
			return FALSE;
#line 2306 "Game.c"
			_state_1:
#line 170 "../src/data/Game.vala"
			game_hub_data_runnable_run_with_compat_finish ((GameHubDataRunnable*) _data_->self, _data_->_res_);
#line 2310 "Game.c"
		} else {
#line 174 "../src/data/Game.vala"
			_data_->_state_ = 2;
#line 174 "../src/data/Game.vala"
			game_hub_data_runnable_run ((GameHubDataRunnable*) _data_->self, game_hub_data_game_run_or_install_ready, _data_);
#line 174 "../src/data/Game.vala"
			return FALSE;
#line 2318 "Game.c"
			_state_2:
#line 174 "../src/data/Game.vala"
			game_hub_data_runnable_run_finish ((GameHubDataRunnable*) _data_->self, _data_->_res_);
#line 2322 "Game.c"
		}
	} else {
#line 177 "../src/data/Game.vala"
		_data_->_tmp4_ = game_hub_data_game_get_status (_data_->self);
#line 177 "../src/data/Game.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 177 "../src/data/Game.vala"
		if (_data_->_tmp5_->state == GAME_HUB_DATA_GAME_STATE_UNINSTALLED) {
#line 179 "../src/data/Game.vala"
			_data_->_state_ = 3;
#line 179 "../src/data/Game.vala"
			game_hub_data_runnable_install ((GameHubDataRunnable*) _data_->self, GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE, game_hub_data_game_run_or_install_ready, _data_);
#line 179 "../src/data/Game.vala"
			return FALSE;
#line 2337 "Game.c"
			_state_3:
#line 179 "../src/data/Game.vala"
			game_hub_data_runnable_install_finish ((GameHubDataRunnable*) _data_->self, _data_->_res_);
#line 2341 "Game.c"
		}
	}
#line 164 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 164 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 164 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 164 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2352 "Game.c"
		}
	}
#line 164 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 164 "../src/data/Game.vala"
	return FALSE;
#line 2359 "Game.c"
}

static void
game_hub_data_game_real_update_game_info_data_free (gpointer _data)
{
	GameHubDataGameUpdateGameInfoData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameUpdateGameInfoData, _data_);
#line 2371 "Game.c"
}

static void
game_hub_data_game_real_update_game_info (GameHubDataGame* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GameHubDataGameUpdateGameInfoData* _data_;
	GameHubDataGame* _tmp0_;
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameUpdateGameInfoData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_real_update_game_info_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_real_update_game_info_co (_data_);
#line 2393 "Game.c"
}

static void
game_hub_data_game_real_update_game_info_finish (GameHubDataGame* self,
                                                 GAsyncResult* _res_)
{
	GameHubDataGameUpdateGameInfoData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2403 "Game.c"
}

static gboolean
game_hub_data_game_real_update_game_info_co (GameHubDataGameUpdateGameInfoData* _data_)
{
#line 183 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 183 "../src/data/Game.vala"
		case 0:
#line 2413 "Game.c"
		goto _state_0;
		default:
#line 183 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 2418 "Game.c"
	}
	_state_0:
#line 183 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 183 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 183 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 183 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2429 "Game.c"
		}
	}
#line 183 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 183 "../src/data/Game.vala"
	return FALSE;
#line 2436 "Game.c"
}

void
game_hub_data_game_update_game_info (GameHubDataGame* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->update_game_info) {
#line 28 "../src/data/Game.vala"
		_klass_->update_game_info (self, _callback_, _user_data_);
#line 2451 "Game.c"
	}
}

void
game_hub_data_game_update_game_info_finish (GameHubDataGame* self,
                                            GAsyncResult* _res_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->update_game_info_finish) {
#line 28 "../src/data/Game.vala"
		_klass_->update_game_info_finish (self, _res_);
#line 2466 "Game.c"
	}
}

void
game_hub_data_game_update_version (GameHubDataGame* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* file = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
#line 185 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 187 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 187 "../src/data/Game.vala"
	_tmp2_ = _tmp1_;
#line 187 "../src/data/Game.vala"
	if (_tmp2_ == NULL) {
#line 187 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 2496 "Game.c"
	} else {
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 187 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 187 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 187 "../src/data/Game.vala"
		_tmp0_ = !g_file_query_exists (_tmp4_, NULL);
#line 2506 "Game.c"
	}
#line 187 "../src/data/Game.vala"
	if (_tmp0_) {
#line 187 "../src/data/Game.vala"
		return;
#line 2512 "Game.c"
	}
#line 189 "../src/data/Game.vala"
	_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 189 "../src/data/Game.vala"
	_tmp6_ = _tmp5_;
#line 189 "../src/data/Game.vala"
	_tmp7_ = g_file_get_child (_tmp6_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 189 "../src/data/Game.vala"
	_tmp8_ = _tmp7_;
#line 189 "../src/data/Game.vala"
	_tmp9_ = g_file_get_child (_tmp8_, "version");
#line 189 "../src/data/Game.vala"
	_tmp10_ = _tmp9_;
#line 189 "../src/data/Game.vala"
	_g_object_unref0 (_tmp8_);
#line 189 "../src/data/Game.vala"
	file = _tmp10_;
#line 190 "../src/data/Game.vala"
	_tmp12_ = file;
#line 190 "../src/data/Game.vala"
	if (_tmp12_ != NULL) {
#line 2534 "Game.c"
		GFile* _tmp13_;
#line 190 "../src/data/Game.vala"
		_tmp13_ = file;
#line 190 "../src/data/Game.vala"
		_tmp11_ = g_file_query_exists (_tmp13_, NULL);
#line 2540 "Game.c"
	} else {
#line 190 "../src/data/Game.vala"
		_tmp11_ = FALSE;
#line 2544 "Game.c"
	}
#line 190 "../src/data/Game.vala"
	if (_tmp11_) {
#line 2548 "Game.c"
		{
			gchar* ver = NULL;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_;
#line 195 "../src/data/Game.vala"
			_tmp14_ = file;
#line 195 "../src/data/Game.vala"
			_tmp15_ = g_file_get_path (_tmp14_);
#line 195 "../src/data/Game.vala"
			_tmp16_ = _tmp15_;
#line 195 "../src/data/Game.vala"
			g_file_get_contents (_tmp16_, &_tmp17_, NULL, &_inner_error0_);
#line 195 "../src/data/Game.vala"
			_g_free0 (ver);
#line 195 "../src/data/Game.vala"
			ver = _tmp17_;
#line 195 "../src/data/Game.vala"
			_g_free0 (_tmp16_);
#line 195 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "../src/data/Game.vala"
				_g_free0 (ver);
#line 2574 "Game.c"
				goto __catch0_g_error;
			}
#line 196 "../src/data/Game.vala"
			_tmp18_ = ver;
#line 196 "../src/data/Game.vala"
			game_hub_data_game_set_version (self, _tmp18_);
#line 192 "../src/data/Game.vala"
			_g_free0 (ver);
#line 2583 "Game.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
#line 192 "../src/data/Game.vala"
			e = _inner_error0_;
#line 192 "../src/data/Game.vala"
			_inner_error0_ = NULL;
#line 200 "../src/data/Game.vala"
			_tmp19_ = e;
#line 200 "../src/data/Game.vala"
			_tmp20_ = _tmp19_->message;
#line 200 "../src/data/Game.vala"
			g_warning ("Game.vala:200: [Game.update_version] Error while reading version: %s", _tmp20_);
#line 192 "../src/data/Game.vala"
			_g_error_free0 (e);
#line 2603 "Game.c"
		}
		__finally0:
#line 192 "../src/data/Game.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 192 "../src/data/Game.vala"
			_g_object_unref0 (file);
#line 192 "../src/data/Game.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 192 "../src/data/Game.vala"
			g_clear_error (&_inner_error0_);
#line 192 "../src/data/Game.vala"
			return;
#line 2616 "Game.c"
		}
	}
#line 185 "../src/data/Game.vala"
	_g_object_unref0 (file);
#line 2621 "Game.c"
}

void
game_hub_data_game_save_version (GameHubDataGame* self,
                                 const gchar* ver)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* file = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* _inner_error0_ = NULL;
#line 205 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 205 "../src/data/Game.vala"
	g_return_if_fail (ver != NULL);
#line 207 "../src/data/Game.vala"
	game_hub_data_game_set_version (self, ver);
#line 209 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 209 "../src/data/Game.vala"
	_tmp2_ = _tmp1_;
#line 209 "../src/data/Game.vala"
	if (_tmp2_ == NULL) {
#line 209 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 2654 "Game.c"
	} else {
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 209 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 209 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 209 "../src/data/Game.vala"
		_tmp0_ = !g_file_query_exists (_tmp4_, NULL);
#line 2664 "Game.c"
	}
#line 209 "../src/data/Game.vala"
	if (_tmp0_) {
#line 209 "../src/data/Game.vala"
		return;
#line 2670 "Game.c"
	}
#line 211 "../src/data/Game.vala"
	_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 211 "../src/data/Game.vala"
	_tmp6_ = _tmp5_;
#line 211 "../src/data/Game.vala"
	_tmp7_ = g_file_get_child (_tmp6_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 211 "../src/data/Game.vala"
	_tmp8_ = _tmp7_;
#line 211 "../src/data/Game.vala"
	_tmp9_ = g_file_get_child (_tmp8_, "version");
#line 211 "../src/data/Game.vala"
	_tmp10_ = _tmp9_;
#line 211 "../src/data/Game.vala"
	_g_object_unref0 (_tmp8_);
#line 211 "../src/data/Game.vala"
	file = _tmp10_;
#line 212 "../src/data/Game.vala"
	_tmp11_ = file;
#line 212 "../src/data/Game.vala"
	if (_tmp11_ != NULL) {
#line 2692 "Game.c"
		{
			GFile* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
#line 216 "../src/data/Game.vala"
			_tmp12_ = file;
#line 216 "../src/data/Game.vala"
			_tmp13_ = g_file_get_parent (_tmp12_);
#line 216 "../src/data/Game.vala"
			_tmp14_ = _tmp13_;
#line 216 "../src/data/Game.vala"
			_tmp15_ = g_file_get_path (_tmp14_);
#line 216 "../src/data/Game.vala"
			_tmp16_ = _tmp15_;
#line 216 "../src/data/Game.vala"
			_tmp17_ = game_hub_utils_fs_utils_mkdir (_tmp16_, NULL, NULL);
#line 216 "../src/data/Game.vala"
			_tmp18_ = _tmp17_;
#line 216 "../src/data/Game.vala"
			_g_object_unref0 (_tmp18_);
#line 216 "../src/data/Game.vala"
			_g_free0 (_tmp16_);
#line 216 "../src/data/Game.vala"
			_g_object_unref0 (_tmp14_);
#line 217 "../src/data/Game.vala"
			_tmp19_ = file;
#line 217 "../src/data/Game.vala"
			_tmp20_ = g_file_get_path (_tmp19_);
#line 217 "../src/data/Game.vala"
			_tmp21_ = _tmp20_;
#line 217 "../src/data/Game.vala"
			g_file_set_contents (_tmp21_, ver, (gssize) -1, &_inner_error0_);
#line 217 "../src/data/Game.vala"
			_g_free0 (_tmp21_);
#line 217 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2736 "Game.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_;
			const gchar* _tmp23_;
#line 214 "../src/data/Game.vala"
			e = _inner_error0_;
#line 214 "../src/data/Game.vala"
			_inner_error0_ = NULL;
#line 221 "../src/data/Game.vala"
			_tmp22_ = e;
#line 221 "../src/data/Game.vala"
			_tmp23_ = _tmp22_->message;
#line 221 "../src/data/Game.vala"
			g_warning ("Game.vala:221: [Game.update_version] Error while reading version: %s", _tmp23_);
#line 214 "../src/data/Game.vala"
			_g_error_free0 (e);
#line 2758 "Game.c"
		}
		__finally0:
#line 214 "../src/data/Game.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 214 "../src/data/Game.vala"
			_g_object_unref0 (file);
#line 214 "../src/data/Game.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 214 "../src/data/Game.vala"
			g_clear_error (&_inner_error0_);
#line 214 "../src/data/Game.vala"
			return;
#line 2771 "Game.c"
		}
	}
#line 205 "../src/data/Game.vala"
	_g_object_unref0 (file);
#line 2776 "Game.c"
}

static void
_vala_array_add8 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
#line 266 "../src/data/Game.vala"
	if ((*length) == (*size)) {
#line 266 "../src/data/Game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 266 "../src/data/Game.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2791 "Game.c"
	}
#line 266 "../src/data/Game.vala"
	(*array)[(*length)++] = value;
#line 266 "../src/data/Game.vala"
	(*array)[*length] = NULL;
#line 2797 "Game.c"
}

GFile*
game_hub_data_game_get_file (GameHubDataGame* self,
                             const gchar* p,
                             gboolean from_all_overlays)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* path = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GFile** dirs = NULL;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile** _tmp15_;
	gint dirs_length1;
	gint _dirs_size_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GeeHashMap* variables = NULL;
	GeeHashMap* _tmp57_;
	GFile** _tmp58_;
	gint _tmp58__length1;
	GFile* result;
#line 245 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 247 "../src/data/Game.vala"
	if (p == NULL) {
#line 247 "../src/data/Game.vala"
		_tmp1_ = TRUE;
#line 2831 "Game.c"
	} else {
		gint _tmp2_;
		gint _tmp3_;
#line 247 "../src/data/Game.vala"
		_tmp2_ = strlen (p);
#line 247 "../src/data/Game.vala"
		_tmp3_ = _tmp2_;
#line 247 "../src/data/Game.vala"
		_tmp1_ = _tmp3_ == 0;
#line 2841 "Game.c"
	}
#line 247 "../src/data/Game.vala"
	if (_tmp1_) {
#line 247 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 2847 "Game.c"
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 247 "../src/data/Game.vala"
		_tmp4_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 247 "../src/data/Game.vala"
		_tmp5_ = _tmp4_;
#line 247 "../src/data/Game.vala"
		_tmp0_ = _tmp5_ == NULL;
#line 2857 "Game.c"
	}
#line 247 "../src/data/Game.vala"
	if (_tmp0_) {
#line 247 "../src/data/Game.vala"
		result = NULL;
#line 247 "../src/data/Game.vala"
		return result;
#line 2865 "Game.c"
	}
#line 248 "../src/data/Game.vala"
	_tmp6_ = g_strdup (p);
#line 248 "../src/data/Game.vala"
	path = _tmp6_;
#line 249 "../src/data/Game.vala"
	_tmp8_ = path;
#line 249 "../src/data/Game.vala"
	if (!g_str_has_prefix (_tmp8_, "$game_dir/")) {
#line 2875 "Game.c"
		const gchar* _tmp9_;
#line 249 "../src/data/Game.vala"
		_tmp9_ = path;
#line 249 "../src/data/Game.vala"
		_tmp7_ = !g_str_has_prefix (_tmp9_, "/");
#line 2881 "Game.c"
	} else {
#line 249 "../src/data/Game.vala"
		_tmp7_ = FALSE;
#line 2885 "Game.c"
	}
#line 249 "../src/data/Game.vala"
	if (_tmp7_) {
#line 2889 "Game.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 251 "../src/data/Game.vala"
		_tmp10_ = path;
#line 251 "../src/data/Game.vala"
		_tmp11_ = g_strconcat ("$game_dir/", _tmp10_, NULL);
#line 251 "../src/data/Game.vala"
		_g_free0 (path);
#line 251 "../src/data/Game.vala"
		path = _tmp11_;
#line 2900 "Game.c"
	}
#line 253 "../src/data/Game.vala"
	_tmp12_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 253 "../src/data/Game.vala"
	_tmp13_ = _tmp12_;
#line 253 "../src/data/Game.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 253 "../src/data/Game.vala"
	_tmp15_ = g_new0 (GFile*, 1 + 1);
#line 253 "../src/data/Game.vala"
	_tmp15_[0] = _tmp14_;
#line 253 "../src/data/Game.vala"
	dirs = _tmp15_;
#line 253 "../src/data/Game.vala"
	dirs_length1 = 1;
#line 253 "../src/data/Game.vala"
	_dirs_size_ = dirs_length1;
#line 254 "../src/data/Game.vala"
	_tmp16_ = game_hub_data_game_get_overlays_enabled (self);
#line 254 "../src/data/Game.vala"
	_tmp17_ = _tmp16_;
#line 254 "../src/data/Game.vala"
	if (_tmp17_) {
#line 256 "../src/data/Game.vala"
		if (from_all_overlays) {
#line 2926 "Game.c"
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			GFile** _tmp35_;
#line 258 "../src/data/Game.vala"
			_tmp18_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 258 "../src/data/Game.vala"
			_tmp19_ = _tmp18_;
#line 258 "../src/data/Game.vala"
			_tmp20_ = g_file_get_child (_tmp19_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 258 "../src/data/Game.vala"
			_tmp21_ = _tmp20_;
#line 258 "../src/data/Game.vala"
			_tmp22_ = g_file_get_child (_tmp21_, "_overlay");
#line 258 "../src/data/Game.vala"
			_tmp23_ = _tmp22_;
#line 258 "../src/data/Game.vala"
			_tmp24_ = g_file_get_child (_tmp23_, "merged");
#line 258 "../src/data/Game.vala"
			_tmp25_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 258 "../src/data/Game.vala"
			_tmp26_ = _tmp25_;
#line 258 "../src/data/Game.vala"
			_tmp27_ = g_file_get_child (_tmp26_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 258 "../src/data/Game.vala"
			_tmp28_ = _tmp27_;
#line 258 "../src/data/Game.vala"
			_tmp29_ = g_file_get_child (_tmp28_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 258 "../src/data/Game.vala"
			_tmp30_ = _tmp29_;
#line 258 "../src/data/Game.vala"
			_tmp31_ = g_file_get_child (_tmp30_, GAME_HUB_DATA_GAME_OVERLAY_BASE);
#line 258 "../src/data/Game.vala"
			_tmp32_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 258 "../src/data/Game.vala"
			_tmp33_ = _tmp32_;
#line 258 "../src/data/Game.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 258 "../src/data/Game.vala"
			_tmp35_ = g_new0 (GFile*, 3 + 1);
#line 258 "../src/data/Game.vala"
			_tmp35_[0] = _tmp24_;
#line 258 "../src/data/Game.vala"
			_tmp35_[1] = _tmp31_;
#line 258 "../src/data/Game.vala"
			_tmp35_[2] = _tmp34_;
#line 258 "../src/data/Game.vala"
			dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 258 "../src/data/Game.vala"
			dirs = _tmp35_;
#line 258 "../src/data/Game.vala"
			dirs_length1 = 3;
#line 258 "../src/data/Game.vala"
			_dirs_size_ = dirs_length1;
#line 258 "../src/data/Game.vala"
			_g_object_unref0 (_tmp30_);
#line 258 "../src/data/Game.vala"
			_g_object_unref0 (_tmp28_);
#line 258 "../src/data/Game.vala"
			_g_object_unref0 (_tmp23_);
#line 258 "../src/data/Game.vala"
			_g_object_unref0 (_tmp21_);
#line 3003 "Game.c"
			{
				GeeArrayList* _overlay_list = NULL;
				GeeArrayList* _tmp36_;
				gint _overlay_size = 0;
				GeeArrayList* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _overlay_index = 0;
#line 263 "../src/data/Game.vala"
				_tmp36_ = self->overlays;
#line 263 "../src/data/Game.vala"
				_overlay_list = _tmp36_;
#line 263 "../src/data/Game.vala"
				_tmp37_ = _overlay_list;
#line 263 "../src/data/Game.vala"
				_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
#line 263 "../src/data/Game.vala"
				_tmp39_ = _tmp38_;
#line 263 "../src/data/Game.vala"
				_overlay_size = _tmp39_;
#line 263 "../src/data/Game.vala"
				_overlay_index = -1;
#line 263 "../src/data/Game.vala"
				while (TRUE) {
#line 3028 "Game.c"
					gint _tmp40_;
					gint _tmp41_;
					GameHubDataGameOverlay* overlay = NULL;
					GeeArrayList* _tmp42_;
					gpointer _tmp43_;
					GameHubDataGameOverlay* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					GFile* _tmp47_;
					GFile* _tmp48_;
					GFile* _tmp49_;
					GFile* _tmp50_;
					GFile* _tmp51_;
					GFile* _tmp52_;
					GameHubDataGameOverlay* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					GFile* _tmp56_;
#line 263 "../src/data/Game.vala"
					_overlay_index = _overlay_index + 1;
#line 263 "../src/data/Game.vala"
					_tmp40_ = _overlay_index;
#line 263 "../src/data/Game.vala"
					_tmp41_ = _overlay_size;
#line 263 "../src/data/Game.vala"
					if (!(_tmp40_ < _tmp41_)) {
#line 263 "../src/data/Game.vala"
						break;
#line 3057 "Game.c"
					}
#line 263 "../src/data/Game.vala"
					_tmp42_ = _overlay_list;
#line 263 "../src/data/Game.vala"
					_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _overlay_index);
#line 263 "../src/data/Game.vala"
					overlay = (GameHubDataGameOverlay*) _tmp43_;
#line 265 "../src/data/Game.vala"
					_tmp44_ = overlay;
#line 265 "../src/data/Game.vala"
					_tmp45_ = game_hub_data_game_overlay_get_id (_tmp44_);
#line 265 "../src/data/Game.vala"
					_tmp46_ = _tmp45_;
#line 265 "../src/data/Game.vala"
					if (g_strcmp0 (_tmp46_, GAME_HUB_DATA_GAME_OVERLAY_BASE) == 0) {
#line 265 "../src/data/Game.vala"
						_g_object_unref0 (overlay);
#line 265 "../src/data/Game.vala"
						continue;
#line 3077 "Game.c"
					}
#line 266 "../src/data/Game.vala"
					_tmp47_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 266 "../src/data/Game.vala"
					_tmp48_ = _tmp47_;
#line 266 "../src/data/Game.vala"
					_tmp49_ = g_file_get_child (_tmp48_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 266 "../src/data/Game.vala"
					_tmp50_ = _tmp49_;
#line 266 "../src/data/Game.vala"
					_tmp51_ = g_file_get_child (_tmp50_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 266 "../src/data/Game.vala"
					_tmp52_ = _tmp51_;
#line 266 "../src/data/Game.vala"
					_tmp53_ = overlay;
#line 266 "../src/data/Game.vala"
					_tmp54_ = game_hub_data_game_overlay_get_id (_tmp53_);
#line 266 "../src/data/Game.vala"
					_tmp55_ = _tmp54_;
#line 266 "../src/data/Game.vala"
					_tmp56_ = g_file_get_child (_tmp52_, _tmp55_);
#line 266 "../src/data/Game.vala"
					_vala_array_add8 (&dirs, &dirs_length1, &_dirs_size_, _tmp56_);
#line 266 "../src/data/Game.vala"
					_g_object_unref0 (_tmp52_);
#line 266 "../src/data/Game.vala"
					_g_object_unref0 (_tmp50_);
#line 263 "../src/data/Game.vala"
					_g_object_unref0 (overlay);
#line 3107 "Game.c"
				}
			}
		}
#line 269 "../src/data/Game.vala"
		game_hub_data_game_mount_overlays (self, NULL, NULL, NULL);
#line 3113 "Game.c"
	}
#line 271 "../src/data/Game.vala"
	_tmp57_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 271 "../src/data/Game.vala"
	variables = _tmp57_;
#line 272 "../src/data/Game.vala"
	_tmp58_ = dirs;
#line 272 "../src/data/Game.vala"
	_tmp58__length1 = dirs_length1;
#line 3123 "Game.c"
	{
		GFile** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
#line 272 "../src/data/Game.vala"
		dir_collection = _tmp58_;
#line 272 "../src/data/Game.vala"
		dir_collection_length1 = _tmp58__length1;
#line 272 "../src/data/Game.vala"
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 3135 "Game.c"
			GFile* _tmp59_;
			GFile* dir = NULL;
#line 272 "../src/data/Game.vala"
			_tmp59_ = _g_object_ref0 (dir_collection[dir_it]);
#line 272 "../src/data/Game.vala"
			dir = _tmp59_;
#line 3142 "Game.c"
			{
				GeeHashMap* _tmp60_;
				GFile* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				GFile* file = NULL;
				const gchar* _tmp64_;
				GeeHashMap* _tmp65_;
				GFile* _tmp66_;
				gboolean _tmp67_ = FALSE;
				GFile* _tmp68_;
#line 274 "../src/data/Game.vala"
				_tmp60_ = variables;
#line 274 "../src/data/Game.vala"
				_tmp61_ = dir;
#line 274 "../src/data/Game.vala"
				_tmp62_ = g_file_get_path (_tmp61_);
#line 274 "../src/data/Game.vala"
				_tmp63_ = _tmp62_;
#line 274 "../src/data/Game.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp60_, "game_dir", _tmp63_);
#line 274 "../src/data/Game.vala"
				_g_free0 (_tmp63_);
#line 275 "../src/data/Game.vala"
				_tmp64_ = path;
#line 275 "../src/data/Game.vala"
				_tmp65_ = variables;
#line 275 "../src/data/Game.vala"
				_tmp66_ = game_hub_utils_fs_utils_file (_tmp64_, NULL, _tmp65_);
#line 275 "../src/data/Game.vala"
				file = _tmp66_;
#line 276 "../src/data/Game.vala"
				_tmp68_ = file;
#line 276 "../src/data/Game.vala"
				if (_tmp68_ != NULL) {
#line 3178 "Game.c"
					GFile* _tmp69_;
#line 276 "../src/data/Game.vala"
					_tmp69_ = file;
#line 276 "../src/data/Game.vala"
					_tmp67_ = g_file_query_exists (_tmp69_, NULL);
#line 3184 "Game.c"
				} else {
#line 276 "../src/data/Game.vala"
					_tmp67_ = FALSE;
#line 3188 "Game.c"
				}
#line 276 "../src/data/Game.vala"
				if (_tmp67_) {
#line 278 "../src/data/Game.vala"
					result = file;
#line 278 "../src/data/Game.vala"
					_g_object_unref0 (dir);
#line 278 "../src/data/Game.vala"
					_g_object_unref0 (variables);
#line 278 "../src/data/Game.vala"
					dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 278 "../src/data/Game.vala"
					_g_free0 (path);
#line 278 "../src/data/Game.vala"
					return result;
#line 3204 "Game.c"
				}
#line 272 "../src/data/Game.vala"
				_g_object_unref0 (file);
#line 272 "../src/data/Game.vala"
				_g_object_unref0 (dir);
#line 3210 "Game.c"
			}
		}
	}
#line 281 "../src/data/Game.vala"
	result = NULL;
#line 281 "../src/data/Game.vala"
	_g_object_unref0 (variables);
#line 281 "../src/data/Game.vala"
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 281 "../src/data/Game.vala"
	_g_free0 (path);
#line 281 "../src/data/Game.vala"
	return result;
#line 3224 "Game.c"
}

void
game_hub_data_game_enable_overlays (GameHubDataGame* self)
{
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GameHubDataGameOverlay* base_overlay = NULL;
	GameHubDataGameOverlay* _tmp13_;
	GeeArrayList* _tmp38_;
	GameHubDataGameOverlay* _tmp39_;
	GError* _inner_error0_ = NULL;
#line 373 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 375 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (self)) {
#line 3244 "Game.c"
		GameHubDataSourcesGOGGOGGame* _tmp0_;
#line 377 "../src/data/Game.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 377 "../src/data/Game.vala"
		if (_tmp0_ != NULL) {
#line 3250 "Game.c"
			GameHubDataSourcesGOGGOGGame* _tmp1_;
#line 377 "../src/data/Game.vala"
			_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 377 "../src/data/Game.vala"
			game_hub_data_game_enable_overlays ((GameHubDataGame*) _tmp1_);
#line 3256 "Game.c"
		}
#line 378 "../src/data/Game.vala"
		return;
#line 3260 "Game.c"
	}
#line 381 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME (self)) {
#line 381 "../src/data/Game.vala"
		_tmp4_ = TRUE;
#line 3266 "Game.c"
	} else {
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 381 "../src/data/Game.vala"
		_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 381 "../src/data/Game.vala"
		_tmp6_ = _tmp5_;
#line 381 "../src/data/Game.vala"
		_tmp4_ = _tmp6_ == NULL;
#line 3276 "Game.c"
	}
#line 381 "../src/data/Game.vala"
	if (_tmp4_) {
#line 381 "../src/data/Game.vala"
		_tmp3_ = TRUE;
#line 3282 "Game.c"
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 381 "../src/data/Game.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 381 "../src/data/Game.vala"
		_tmp8_ = _tmp7_;
#line 381 "../src/data/Game.vala"
		_tmp3_ = !g_file_query_exists (_tmp8_, NULL);
#line 3292 "Game.c"
	}
#line 381 "../src/data/Game.vala"
	if (_tmp3_) {
#line 381 "../src/data/Game.vala"
		_tmp2_ = TRUE;
#line 3298 "Game.c"
	} else {
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 381 "../src/data/Game.vala"
		_tmp9_ = game_hub_data_game_get_overlays_enabled (self);
#line 381 "../src/data/Game.vala"
		_tmp10_ = _tmp9_;
#line 381 "../src/data/Game.vala"
		_tmp2_ = _tmp10_;
#line 3308 "Game.c"
	}
#line 381 "../src/data/Game.vala"
	if (_tmp2_) {
#line 381 "../src/data/Game.vala"
		return;
#line 3314 "Game.c"
	}
#line 382 "../src/data/Game.vala"
	_tmp11_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 382 "../src/data/Game.vala"
	_tmp12_ = _tmp11_;
#line 382 "../src/data/Game.vala"
	if (game_hub_utils_fs_overlay_root_path_safety_for (_tmp12_) == GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_RESTRICTED) {
#line 382 "../src/data/Game.vala"
		return;
#line 3324 "Game.c"
	}
#line 384 "../src/data/Game.vala"
	_tmp13_ = game_hub_data_game_overlay_new (self, GAME_HUB_DATA_GAME_OVERLAY_BASE, NULL, TRUE);
#line 384 "../src/data/Game.vala"
	base_overlay = _tmp13_;
#line 3330 "Game.c"
	{
		GFileInfo* finfo = NULL;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFileEnumerator* _tmp16_;
#line 388 "../src/data/Game.vala"
		finfo = NULL;
#line 389 "../src/data/Game.vala"
		_tmp14_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 389 "../src/data/Game.vala"
		_tmp15_ = _tmp14_;
#line 389 "../src/data/Game.vala"
		_tmp16_ = g_file_enumerate_children (_tmp15_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
#line 389 "../src/data/Game.vala"
		enumerator = _tmp16_;
#line 389 "../src/data/Game.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 389 "../src/data/Game.vala"
			_g_object_unref0 (finfo);
#line 3351 "Game.c"
			goto __catch0_g_error;
		}
#line 390 "../src/data/Game.vala"
		while (TRUE) {
#line 3356 "Game.c"
			GFileInfo* _tmp17_ = NULL;
			GFileEnumerator* _tmp18_;
			GFileInfo* _tmp19_;
			GFileInfo* _tmp20_;
			GFileInfo* _tmp21_;
			gchar* fname = NULL;
			GFileInfo* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			const gchar* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			GameHubDataGameOverlay* _tmp31_;
			GFile* _tmp32_;
			const gchar* _tmp33_;
			GFile* _tmp34_;
			GFile* _tmp35_;
#line 390 "../src/data/Game.vala"
			_tmp18_ = enumerator;
#line 390 "../src/data/Game.vala"
			_tmp19_ = g_file_enumerator_next_file (_tmp18_, NULL, &_inner_error0_);
#line 390 "../src/data/Game.vala"
			_tmp17_ = _tmp19_;
#line 390 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 390 "../src/data/Game.vala"
				_g_object_unref0 (enumerator);
#line 390 "../src/data/Game.vala"
				_g_object_unref0 (finfo);
#line 3389 "Game.c"
				goto __catch0_g_error;
			}
#line 390 "../src/data/Game.vala"
			_tmp20_ = _tmp17_;
#line 390 "../src/data/Game.vala"
			_tmp17_ = NULL;
#line 390 "../src/data/Game.vala"
			_g_object_unref0 (finfo);
#line 390 "../src/data/Game.vala"
			finfo = _tmp20_;
#line 390 "../src/data/Game.vala"
			_tmp21_ = finfo;
#line 390 "../src/data/Game.vala"
			if (!(_tmp21_ != NULL)) {
#line 390 "../src/data/Game.vala"
				_g_object_unref0 (_tmp17_);
#line 390 "../src/data/Game.vala"
				break;
#line 3408 "Game.c"
			}
#line 392 "../src/data/Game.vala"
			_tmp22_ = finfo;
#line 392 "../src/data/Game.vala"
			_tmp23_ = g_file_info_get_name (_tmp22_);
#line 392 "../src/data/Game.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 392 "../src/data/Game.vala"
			fname = _tmp24_;
#line 393 "../src/data/Game.vala"
			_tmp25_ = fname;
#line 393 "../src/data/Game.vala"
			if (g_strcmp0 (_tmp25_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR) == 0) {
#line 393 "../src/data/Game.vala"
				_g_free0 (fname);
#line 393 "../src/data/Game.vala"
				_g_object_unref0 (_tmp17_);
#line 393 "../src/data/Game.vala"
				continue;
#line 3428 "Game.c"
			}
#line 394 "../src/data/Game.vala"
			_tmp26_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 394 "../src/data/Game.vala"
			_tmp27_ = _tmp26_;
#line 394 "../src/data/Game.vala"
			_tmp28_ = fname;
#line 394 "../src/data/Game.vala"
			_tmp29_ = g_file_get_child (_tmp27_, _tmp28_);
#line 394 "../src/data/Game.vala"
			_tmp30_ = _tmp29_;
#line 394 "../src/data/Game.vala"
			_tmp31_ = base_overlay;
#line 394 "../src/data/Game.vala"
			_tmp32_ = _tmp31_->directory;
#line 394 "../src/data/Game.vala"
			_tmp33_ = fname;
#line 394 "../src/data/Game.vala"
			_tmp34_ = g_file_get_child (_tmp32_, _tmp33_);
#line 394 "../src/data/Game.vala"
			_tmp35_ = _tmp34_;
#line 394 "../src/data/Game.vala"
			g_file_move (_tmp30_, _tmp35_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_NOFOLLOW_SYMLINKS, NULL, NULL, NULL, &_inner_error0_);
#line 394 "../src/data/Game.vala"
			_g_object_unref0 (_tmp35_);
#line 394 "../src/data/Game.vala"
			_g_object_unref0 (_tmp30_);
#line 394 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 394 "../src/data/Game.vala"
				_g_free0 (fname);
#line 394 "../src/data/Game.vala"
				_g_object_unref0 (_tmp17_);
#line 394 "../src/data/Game.vala"
				_g_object_unref0 (enumerator);
#line 394 "../src/data/Game.vala"
				_g_object_unref0 (finfo);
#line 3466 "Game.c"
				goto __catch0_g_error;
			}
#line 390 "../src/data/Game.vala"
			_g_free0 (fname);
#line 390 "../src/data/Game.vala"
			_g_object_unref0 (_tmp17_);
#line 3473 "Game.c"
		}
#line 386 "../src/data/Game.vala"
		_g_object_unref0 (enumerator);
#line 386 "../src/data/Game.vala"
		_g_object_unref0 (finfo);
#line 3479 "Game.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
#line 386 "../src/data/Game.vala"
		e = _inner_error0_;
#line 386 "../src/data/Game.vala"
		_inner_error0_ = NULL;
#line 399 "../src/data/Game.vala"
		_tmp36_ = e;
#line 399 "../src/data/Game.vala"
		_tmp37_ = _tmp36_->message;
#line 399 "../src/data/Game.vala"
		g_warning ("Game.vala:399: [Game.enable_overlays] Error while moving game files to" \
" `base` overlay: %s", _tmp37_);
#line 386 "../src/data/Game.vala"
		_g_error_free0 (e);
#line 3499 "Game.c"
	}
	__finally0:
#line 386 "../src/data/Game.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 386 "../src/data/Game.vala"
		_g_object_unref0 (base_overlay);
#line 386 "../src/data/Game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 386 "../src/data/Game.vala"
		g_clear_error (&_inner_error0_);
#line 386 "../src/data/Game.vala"
		return;
#line 3512 "Game.c"
	}
#line 402 "../src/data/Game.vala"
	_tmp38_ = self->overlays;
#line 402 "../src/data/Game.vala"
	_tmp39_ = base_overlay;
#line 402 "../src/data/Game.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp39_);
#line 403 "../src/data/Game.vala"
	game_hub_data_game_save_overlays (self);
#line 404 "../src/data/Game.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 373 "../src/data/Game.vala"
	_g_object_unref0 (base_overlay);
#line 3526 "Game.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 433 "../src/data/Game.vala"
	return self ? json_object_ref (self) : NULL;
#line 3534 "Game.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 441 "../src/data/Game.vala"
	g_boxed_free (json_node_get_type (), self);
#line 3542 "Game.c"
}

void
game_hub_data_game_save_overlays (GameHubDataGame* self)
{
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* file = NULL;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GFile* _tmp20_;
	JsonNode* root_node = NULL;
	JsonNode* _tmp24_;
	JsonObject* root = NULL;
	JsonObject* _tmp25_;
	JsonObject* overlays_obj = NULL;
	JsonObject* _tmp26_;
	JsonObject* _tmp53_;
	JsonObject* _tmp54_;
	JsonObject* _tmp55_;
	JsonNode* _tmp56_;
	JsonObject* _tmp57_;
	gchar* json = NULL;
	JsonNode* _tmp58_;
	gchar* _tmp59_;
	GError* _inner_error0_ = NULL;
#line 407 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 409 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (self)) {
#line 3584 "Game.c"
		GameHubDataSourcesGOGGOGGame* _tmp0_;
#line 411 "../src/data/Game.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 411 "../src/data/Game.vala"
		if (_tmp0_ != NULL) {
#line 3590 "Game.c"
			GameHubDataSourcesGOGGOGGame* _tmp1_;
#line 411 "../src/data/Game.vala"
			_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 411 "../src/data/Game.vala"
			game_hub_data_game_save_overlays ((GameHubDataGame*) _tmp1_);
#line 3596 "Game.c"
		}
#line 412 "../src/data/Game.vala"
		return;
#line 3600 "Game.c"
	}
#line 415 "../src/data/Game.vala"
	_tmp4_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 415 "../src/data/Game.vala"
	_tmp5_ = _tmp4_;
#line 415 "../src/data/Game.vala"
	if (_tmp5_ == NULL) {
#line 415 "../src/data/Game.vala"
		_tmp3_ = TRUE;
#line 3610 "Game.c"
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
#line 415 "../src/data/Game.vala"
		_tmp6_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 415 "../src/data/Game.vala"
		_tmp7_ = _tmp6_;
#line 415 "../src/data/Game.vala"
		_tmp3_ = !g_file_query_exists (_tmp7_, NULL);
#line 3620 "Game.c"
	}
#line 415 "../src/data/Game.vala"
	if (_tmp3_) {
#line 415 "../src/data/Game.vala"
		_tmp2_ = TRUE;
#line 3626 "Game.c"
	} else {
		GeeArrayList* _tmp8_;
#line 415 "../src/data/Game.vala"
		_tmp8_ = self->overlays;
#line 415 "../src/data/Game.vala"
		_tmp2_ = _tmp8_ == NULL;
#line 3633 "Game.c"
	}
#line 415 "../src/data/Game.vala"
	if (_tmp2_) {
#line 415 "../src/data/Game.vala"
		return;
#line 3639 "Game.c"
	}
#line 416 "../src/data/Game.vala"
	_tmp9_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 416 "../src/data/Game.vala"
	_tmp10_ = _tmp9_;
#line 416 "../src/data/Game.vala"
	if (game_hub_utils_fs_overlay_root_path_safety_for (_tmp10_) == GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_RESTRICTED) {
#line 416 "../src/data/Game.vala"
		return;
#line 3649 "Game.c"
	}
#line 418 "../src/data/Game.vala"
	_tmp11_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 418 "../src/data/Game.vala"
	_tmp12_ = _tmp11_;
#line 418 "../src/data/Game.vala"
	_tmp13_ = g_file_get_child (_tmp12_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 418 "../src/data/Game.vala"
	_tmp14_ = _tmp13_;
#line 418 "../src/data/Game.vala"
	_tmp15_ = g_file_get_child (_tmp14_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 418 "../src/data/Game.vala"
	_tmp16_ = _tmp15_;
#line 418 "../src/data/Game.vala"
	_tmp17_ = g_file_get_child (_tmp16_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_LIST);
#line 418 "../src/data/Game.vala"
	_tmp18_ = _tmp17_;
#line 418 "../src/data/Game.vala"
	_g_object_unref0 (_tmp16_);
#line 418 "../src/data/Game.vala"
	_g_object_unref0 (_tmp14_);
#line 418 "../src/data/Game.vala"
	file = _tmp18_;
#line 420 "../src/data/Game.vala"
	_tmp20_ = file;
#line 420 "../src/data/Game.vala"
	if (_tmp20_ == NULL) {
#line 420 "../src/data/Game.vala"
		_tmp19_ = TRUE;
#line 3679 "Game.c"
	} else {
		GFile* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
#line 420 "../src/data/Game.vala"
		_tmp21_ = file;
#line 420 "../src/data/Game.vala"
		_tmp22_ = g_file_get_parent (_tmp21_);
#line 420 "../src/data/Game.vala"
		_tmp23_ = _tmp22_;
#line 420 "../src/data/Game.vala"
		_tmp19_ = !g_file_query_exists (_tmp23_, NULL);
#line 420 "../src/data/Game.vala"
		_g_object_unref0 (_tmp23_);
#line 3694 "Game.c"
	}
#line 420 "../src/data/Game.vala"
	if (_tmp19_) {
#line 420 "../src/data/Game.vala"
		_g_object_unref0 (file);
#line 420 "../src/data/Game.vala"
		return;
#line 3702 "Game.c"
	}
#line 422 "../src/data/Game.vala"
	_tmp24_ = json_node_new (JSON_NODE_OBJECT);
#line 422 "../src/data/Game.vala"
	root_node = _tmp24_;
#line 423 "../src/data/Game.vala"
	_tmp25_ = json_object_new ();
#line 423 "../src/data/Game.vala"
	root = _tmp25_;
#line 425 "../src/data/Game.vala"
	_tmp26_ = json_object_new ();
#line 425 "../src/data/Game.vala"
	overlays_obj = _tmp26_;
#line 3716 "Game.c"
	{
		GeeArrayList* _overlay_list = NULL;
		GeeArrayList* _tmp27_;
		gint _overlay_size = 0;
		GeeArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _overlay_index = 0;
#line 427 "../src/data/Game.vala"
		_tmp27_ = self->overlays;
#line 427 "../src/data/Game.vala"
		_overlay_list = _tmp27_;
#line 427 "../src/data/Game.vala"
		_tmp28_ = _overlay_list;
#line 427 "../src/data/Game.vala"
		_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
#line 427 "../src/data/Game.vala"
		_tmp30_ = _tmp29_;
#line 427 "../src/data/Game.vala"
		_overlay_size = _tmp30_;
#line 427 "../src/data/Game.vala"
		_overlay_index = -1;
#line 427 "../src/data/Game.vala"
		while (TRUE) {
#line 3741 "Game.c"
			gint _tmp31_;
			gint _tmp32_;
			GameHubDataGameOverlay* overlay = NULL;
			GeeArrayList* _tmp33_;
			gpointer _tmp34_;
			GameHubDataGameOverlay* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			JsonObject* obj = NULL;
			JsonObject* _tmp38_;
			JsonObject* _tmp39_;
			GameHubDataGameOverlay* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			JsonObject* _tmp43_;
			GameHubDataGameOverlay* _tmp44_;
			gboolean _tmp45_;
			gboolean _tmp46_;
			JsonObject* _tmp47_;
			GameHubDataGameOverlay* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			JsonObject* _tmp51_;
			JsonObject* _tmp52_;
#line 427 "../src/data/Game.vala"
			_overlay_index = _overlay_index + 1;
#line 427 "../src/data/Game.vala"
			_tmp31_ = _overlay_index;
#line 427 "../src/data/Game.vala"
			_tmp32_ = _overlay_size;
#line 427 "../src/data/Game.vala"
			if (!(_tmp31_ < _tmp32_)) {
#line 427 "../src/data/Game.vala"
				break;
#line 3776 "Game.c"
			}
#line 427 "../src/data/Game.vala"
			_tmp33_ = _overlay_list;
#line 427 "../src/data/Game.vala"
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _overlay_index);
#line 427 "../src/data/Game.vala"
			overlay = (GameHubDataGameOverlay*) _tmp34_;
#line 429 "../src/data/Game.vala"
			_tmp35_ = overlay;
#line 429 "../src/data/Game.vala"
			_tmp36_ = game_hub_data_game_overlay_get_id (_tmp35_);
#line 429 "../src/data/Game.vala"
			_tmp37_ = _tmp36_;
#line 429 "../src/data/Game.vala"
			if (g_strcmp0 (_tmp37_, GAME_HUB_DATA_GAME_OVERLAY_BASE) == 0) {
#line 429 "../src/data/Game.vala"
				_g_object_unref0 (overlay);
#line 429 "../src/data/Game.vala"
				continue;
#line 3796 "Game.c"
			}
#line 430 "../src/data/Game.vala"
			_tmp38_ = json_object_new ();
#line 430 "../src/data/Game.vala"
			obj = _tmp38_;
#line 431 "../src/data/Game.vala"
			_tmp39_ = obj;
#line 431 "../src/data/Game.vala"
			_tmp40_ = overlay;
#line 431 "../src/data/Game.vala"
			_tmp41_ = game_hub_data_game_overlay_get_name (_tmp40_);
#line 431 "../src/data/Game.vala"
			_tmp42_ = _tmp41_;
#line 431 "../src/data/Game.vala"
			json_object_set_string_member (_tmp39_, "name", _tmp42_);
#line 432 "../src/data/Game.vala"
			_tmp43_ = obj;
#line 432 "../src/data/Game.vala"
			_tmp44_ = overlay;
#line 432 "../src/data/Game.vala"
			_tmp45_ = game_hub_data_game_overlay_get_enabled (_tmp44_);
#line 432 "../src/data/Game.vala"
			_tmp46_ = _tmp45_;
#line 432 "../src/data/Game.vala"
			json_object_set_boolean_member (_tmp43_, "enabled", _tmp46_);
#line 433 "../src/data/Game.vala"
			_tmp47_ = overlays_obj;
#line 433 "../src/data/Game.vala"
			_tmp48_ = overlay;
#line 433 "../src/data/Game.vala"
			_tmp49_ = game_hub_data_game_overlay_get_id (_tmp48_);
#line 433 "../src/data/Game.vala"
			_tmp50_ = _tmp49_;
#line 433 "../src/data/Game.vala"
			_tmp51_ = obj;
#line 433 "../src/data/Game.vala"
			_tmp52_ = _json_object_ref0 (_tmp51_);
#line 433 "../src/data/Game.vala"
			json_object_set_object_member (_tmp47_, _tmp50_, _tmp52_);
#line 427 "../src/data/Game.vala"
			_json_object_unref0 (obj);
#line 427 "../src/data/Game.vala"
			_g_object_unref0 (overlay);
#line 3840 "Game.c"
		}
	}
#line 436 "../src/data/Game.vala"
	_tmp53_ = root;
#line 436 "../src/data/Game.vala"
	_tmp54_ = overlays_obj;
#line 436 "../src/data/Game.vala"
	_tmp55_ = _json_object_ref0 (_tmp54_);
#line 436 "../src/data/Game.vala"
	json_object_set_object_member (_tmp53_, "overlays", _tmp55_);
#line 437 "../src/data/Game.vala"
	_tmp56_ = root_node;
#line 437 "../src/data/Game.vala"
	_tmp57_ = root;
#line 437 "../src/data/Game.vala"
	json_node_set_object (_tmp56_, _tmp57_);
#line 439 "../src/data/Game.vala"
	_tmp58_ = root_node;
#line 439 "../src/data/Game.vala"
	_tmp59_ = json_to_string (_tmp58_, TRUE);
#line 439 "../src/data/Game.vala"
	json = _tmp59_;
#line 3863 "Game.c"
	{
		GFile* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
#line 443 "../src/data/Game.vala"
		_tmp60_ = file;
#line 443 "../src/data/Game.vala"
		_tmp61_ = g_file_get_path (_tmp60_);
#line 443 "../src/data/Game.vala"
		_tmp62_ = _tmp61_;
#line 443 "../src/data/Game.vala"
		_tmp63_ = json;
#line 443 "../src/data/Game.vala"
		g_file_set_contents (_tmp62_, _tmp63_, (gssize) -1, &_inner_error0_);
#line 443 "../src/data/Game.vala"
		_g_free0 (_tmp62_);
#line 443 "../src/data/Game.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3883 "Game.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp64_;
		const gchar* _tmp65_;
#line 441 "../src/data/Game.vala"
		e = _inner_error0_;
#line 441 "../src/data/Game.vala"
		_inner_error0_ = NULL;
#line 447 "../src/data/Game.vala"
		_tmp64_ = e;
#line 447 "../src/data/Game.vala"
		_tmp65_ = _tmp64_->message;
#line 447 "../src/data/Game.vala"
		g_warning ("Game.vala:447: [Game.save_overlays] %s", _tmp65_);
#line 441 "../src/data/Game.vala"
		_g_error_free0 (e);
#line 3905 "Game.c"
	}
	__finally0:
#line 441 "../src/data/Game.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 441 "../src/data/Game.vala"
		_g_free0 (json);
#line 441 "../src/data/Game.vala"
		_json_object_unref0 (overlays_obj);
#line 441 "../src/data/Game.vala"
		_json_object_unref0 (root);
#line 441 "../src/data/Game.vala"
		__vala_JsonNode_free0 (root_node);
#line 441 "../src/data/Game.vala"
		_g_object_unref0 (file);
#line 441 "../src/data/Game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 441 "../src/data/Game.vala"
		g_clear_error (&_inner_error0_);
#line 441 "../src/data/Game.vala"
		return;
#line 3926 "Game.c"
	}
#line 450 "../src/data/Game.vala"
	g_object_notify ((GObject*) self, "overlays-enabled");
#line 407 "../src/data/Game.vala"
	_g_free0 (json);
#line 407 "../src/data/Game.vala"
	_json_object_unref0 (overlays_obj);
#line 407 "../src/data/Game.vala"
	_json_object_unref0 (root);
#line 407 "../src/data/Game.vala"
	__vala_JsonNode_free0 (root_node);
#line 407 "../src/data/Game.vala"
	_g_object_unref0 (file);
#line 3940 "Game.c"
}

void
game_hub_data_game_load_overlays (GameHubDataGame* self)
{
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GameHubDataGameOverlay* _tmp6_;
	GameHubDataGameOverlay* _tmp7_;
	JsonNode* root_node = NULL;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	JsonNode* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* overlays_obj = NULL;
	JsonNode* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
	JsonObject* _tmp27_;
	GList* _tmp28_;
#line 453 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 455 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (self)) {
#line 3980 "Game.c"
		GameHubDataSourcesGOGGOGGame* _tmp0_;
#line 457 "../src/data/Game.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 457 "../src/data/Game.vala"
		if (_tmp0_ != NULL) {
#line 3986 "Game.c"
			GameHubDataSourcesGOGGOGGame* _tmp1_;
#line 457 "../src/data/Game.vala"
			_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 457 "../src/data/Game.vala"
			game_hub_data_game_load_overlays ((GameHubDataGame*) _tmp1_);
#line 3992 "Game.c"
		}
#line 458 "../src/data/Game.vala"
		return;
#line 3996 "Game.c"
	}
#line 461 "../src/data/Game.vala"
	_tmp2_ = game_hub_data_game_get_overlays_enabled (self);
#line 461 "../src/data/Game.vala"
	_tmp3_ = _tmp2_;
#line 461 "../src/data/Game.vala"
	if (!_tmp3_) {
#line 461 "../src/data/Game.vala"
		return;
#line 4006 "Game.c"
	}
#line 462 "../src/data/Game.vala"
	_tmp4_ = self->overlays;
#line 462 "../src/data/Game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
#line 463 "../src/data/Game.vala"
	_tmp5_ = self->overlays;
#line 463 "../src/data/Game.vala"
	_tmp6_ = game_hub_data_game_overlay_new (self, GAME_HUB_DATA_GAME_OVERLAY_BASE, NULL, TRUE);
#line 463 "../src/data/Game.vala"
	_tmp7_ = _tmp6_;
#line 463 "../src/data/Game.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
#line 463 "../src/data/Game.vala"
	_g_object_unref0 (_tmp7_);
#line 465 "../src/data/Game.vala"
	_tmp8_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 465 "../src/data/Game.vala"
	_tmp9_ = _tmp8_;
#line 465 "../src/data/Game.vala"
	_tmp10_ = g_file_get_child (_tmp9_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 465 "../src/data/Game.vala"
	_tmp11_ = _tmp10_;
#line 465 "../src/data/Game.vala"
	_tmp12_ = g_file_get_child (_tmp11_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 465 "../src/data/Game.vala"
	_tmp13_ = _tmp12_;
#line 465 "../src/data/Game.vala"
	_tmp14_ = g_file_get_child (_tmp13_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_LIST);
#line 465 "../src/data/Game.vala"
	_tmp15_ = _tmp14_;
#line 465 "../src/data/Game.vala"
	_tmp16_ = g_file_get_path (_tmp15_);
#line 465 "../src/data/Game.vala"
	_tmp17_ = _tmp16_;
#line 465 "../src/data/Game.vala"
	_tmp18_ = game_hub_utils_parser_parse_json_file (_tmp17_, "");
#line 465 "../src/data/Game.vala"
	_tmp19_ = _tmp18_;
#line 465 "../src/data/Game.vala"
	_g_free0 (_tmp17_);
#line 465 "../src/data/Game.vala"
	_g_object_unref0 (_tmp15_);
#line 465 "../src/data/Game.vala"
	_g_object_unref0 (_tmp13_);
#line 465 "../src/data/Game.vala"
	_g_object_unref0 (_tmp11_);
#line 465 "../src/data/Game.vala"
	root_node = _tmp19_;
#line 467 "../src/data/Game.vala"
	_tmp20_ = root_node;
#line 467 "../src/data/Game.vala"
	_tmp21_ = g_strdup ("overlays");
#line 467 "../src/data/Game.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 467 "../src/data/Game.vala"
	_tmp22_[0] = _tmp21_;
#line 467 "../src/data/Game.vala"
	_tmp23_ = _tmp22_;
#line 467 "../src/data/Game.vala"
	_tmp23__length1 = 1;
#line 467 "../src/data/Game.vala"
	_tmp24_ = game_hub_utils_parser_json_object (_tmp20_, _tmp23_, (gint) 1);
#line 467 "../src/data/Game.vala"
	_tmp25_ = _tmp24_;
#line 467 "../src/data/Game.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 467 "../src/data/Game.vala"
	overlays_obj = _tmp25_;
#line 468 "../src/data/Game.vala"
	_tmp26_ = overlays_obj;
#line 468 "../src/data/Game.vala"
	if (_tmp26_ == NULL) {
#line 468 "../src/data/Game.vala"
		_json_object_unref0 (overlays_obj);
#line 468 "../src/data/Game.vala"
		__vala_JsonNode_free0 (root_node);
#line 468 "../src/data/Game.vala"
		return;
#line 4086 "Game.c"
	}
#line 470 "../src/data/Game.vala"
	_tmp27_ = overlays_obj;
#line 470 "../src/data/Game.vala"
	_tmp28_ = json_object_get_members (_tmp27_);
#line 4092 "Game.c"
	{
		GList* id_collection = NULL;
		GList* id_it = NULL;
#line 470 "../src/data/Game.vala"
		id_collection = _tmp28_;
#line 470 "../src/data/Game.vala"
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
#line 4100 "Game.c"
			const gchar* id = NULL;
#line 470 "../src/data/Game.vala"
			id = (const gchar*) id_it->data;
#line 4104 "Game.c"
			{
				JsonObject* obj = NULL;
				JsonObject* _tmp29_;
				const gchar* _tmp30_;
				JsonObject* _tmp31_;
				JsonObject* _tmp32_;
				GeeArrayList* _tmp33_;
				const gchar* _tmp34_;
				JsonObject* _tmp35_;
				const gchar* _tmp36_;
				JsonObject* _tmp37_;
				GameHubDataGameOverlay* _tmp38_;
				GameHubDataGameOverlay* _tmp39_;
#line 472 "../src/data/Game.vala"
				_tmp29_ = overlays_obj;
#line 472 "../src/data/Game.vala"
				_tmp30_ = id;
#line 472 "../src/data/Game.vala"
				_tmp31_ = json_object_get_object_member (_tmp29_, _tmp30_);
#line 472 "../src/data/Game.vala"
				_tmp32_ = _json_object_ref0 (_tmp31_);
#line 472 "../src/data/Game.vala"
				obj = _tmp32_;
#line 473 "../src/data/Game.vala"
				_tmp33_ = self->overlays;
#line 473 "../src/data/Game.vala"
				_tmp34_ = id;
#line 473 "../src/data/Game.vala"
				_tmp35_ = obj;
#line 473 "../src/data/Game.vala"
				_tmp36_ = json_object_get_string_member (_tmp35_, "name");
#line 473 "../src/data/Game.vala"
				_tmp37_ = obj;
#line 473 "../src/data/Game.vala"
				_tmp38_ = game_hub_data_game_overlay_new (self, _tmp34_, _tmp36_, json_object_get_boolean_member (_tmp37_, "enabled"));
#line 473 "../src/data/Game.vala"
				_tmp39_ = _tmp38_;
#line 473 "../src/data/Game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp39_);
#line 473 "../src/data/Game.vala"
				_g_object_unref0 (_tmp39_);
#line 470 "../src/data/Game.vala"
				_json_object_unref0 (obj);
#line 4148 "Game.c"
			}
		}
#line 470 "../src/data/Game.vala"
		(id_collection == NULL) ? NULL : (id_collection = (g_list_free (id_collection), NULL));
#line 4153 "Game.c"
	}
#line 453 "../src/data/Game.vala"
	_json_object_unref0 (overlays_obj);
#line 453 "../src/data/Game.vala"
	__vala_JsonNode_free0 (root_node);
#line 4159 "Game.c"
}

static void
game_hub_data_game_mount_overlays_data_free (gpointer _data)
{
	GameHubDataGameMountOverlaysData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->persist);
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameMountOverlaysData, _data_);
#line 4173 "Game.c"
}

void
game_hub_data_game_mount_overlays (GameHubDataGame* self,
                                   GFile* persist,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GameHubDataGameMountOverlaysData* _data_;
	GameHubDataGame* _tmp0_;
	GFile* _tmp1_;
#line 28 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameMountOverlaysData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_mount_overlays_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	_tmp1_ = _g_object_ref0 (persist);
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->persist);
#line 28 "../src/data/Game.vala"
	_data_->persist = _tmp1_;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_mount_overlays_co (_data_);
#line 4205 "Game.c"
}

void
game_hub_data_game_mount_overlays_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_)
{
	GameHubDataGameMountOverlaysData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4215 "Game.c"
}

static void
game_hub_data_game_mount_overlays_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GameHubDataGameMountOverlaysData* _data_;
#line 481 "../src/data/Game.vala"
	_data_ = _user_data_;
#line 481 "../src/data/Game.vala"
	_data_->_source_object_ = source_object;
#line 481 "../src/data/Game.vala"
	_data_->_res_ = _res_;
#line 481 "../src/data/Game.vala"
	game_hub_data_game_mount_overlays_co (_data_);
#line 4232 "Game.c"
}

static gboolean
game_hub_data_game_mount_overlays_co (GameHubDataGameMountOverlaysData* _data_)
{
#line 477 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 477 "../src/data/Game.vala"
		case 0:
#line 4242 "Game.c"
		goto _state_0;
#line 477 "../src/data/Game.vala"
		case 1:
#line 4246 "Game.c"
		goto _state_1;
#line 477 "../src/data/Game.vala"
		case 2:
#line 4250 "Game.c"
		goto _state_2;
		default:
#line 477 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 4255 "Game.c"
	}
	_state_0:
#line 479 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (_data_->self)) {
#line 481 "../src/data/Game.vala"
		_data_->_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 481 "../src/data/Game.vala"
		if (_data_->_tmp0_ != NULL) {
#line 481 "../src/data/Game.vala"
			_data_->_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 481 "../src/data/Game.vala"
			_data_->_state_ = 1;
#line 481 "../src/data/Game.vala"
			game_hub_data_game_mount_overlays ((GameHubDataGame*) _data_->_tmp1_, _data_->persist, game_hub_data_game_mount_overlays_ready, _data_);
#line 481 "../src/data/Game.vala"
			return FALSE;
#line 4272 "Game.c"
			_state_1:
#line 481 "../src/data/Game.vala"
			game_hub_data_game_mount_overlays_finish ((GameHubDataGame*) _data_->_tmp1_, _data_->_res_);
#line 4276 "Game.c"
		}
#line 482 "../src/data/Game.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 482 "../src/data/Game.vala"
		if (_data_->_state_ != 0) {
#line 482 "../src/data/Game.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 482 "../src/data/Game.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4286 "Game.c"
			}
		}
#line 482 "../src/data/Game.vala"
		g_object_unref (_data_->_async_result);
#line 482 "../src/data/Game.vala"
		return FALSE;
#line 4293 "Game.c"
	}
#line 485 "../src/data/Game.vala"
	_data_->_tmp2_ = game_hub_data_game_get_overlays_enabled (_data_->self);
#line 485 "../src/data/Game.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 485 "../src/data/Game.vala"
	if (!_data_->_tmp3_) {
#line 485 "../src/data/Game.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 485 "../src/data/Game.vala"
		if (_data_->_state_ != 0) {
#line 485 "../src/data/Game.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 485 "../src/data/Game.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4309 "Game.c"
			}
		}
#line 485 "../src/data/Game.vala"
		g_object_unref (_data_->_async_result);
#line 485 "../src/data/Game.vala"
		return FALSE;
#line 4316 "Game.c"
	}
#line 486 "../src/data/Game.vala"
	game_hub_data_game_load_overlays (_data_->self);
#line 488 "../src/data/Game.vala"
	_data_->_tmp4_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 488 "../src/data/Game.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 488 "../src/data/Game.vala"
	_data_->_tmp6_ = g_file_get_child (_data_->_tmp5_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 488 "../src/data/Game.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 488 "../src/data/Game.vala"
	_data_->_tmp8_ = g_file_get_child (_data_->_tmp7_, "_overlay");
#line 488 "../src/data/Game.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 488 "../src/data/Game.vala"
	_g_object_unref0 (_data_->_tmp7_);
#line 488 "../src/data/Game.vala"
	_data_->overlay_dir = _data_->_tmp9_;
#line 489 "../src/data/Game.vala"
	_data_->_tmp10_ = _data_->overlay_dir;
#line 489 "../src/data/Game.vala"
	_data_->_tmp11_ = g_file_get_child (_data_->_tmp10_, "merged");
#line 489 "../src/data/Game.vala"
	_data_->merged_dir = _data_->_tmp11_;
#line 490 "../src/data/Game.vala"
	_data_->_tmp13_ = _g_object_ref0 (_data_->persist);
#line 490 "../src/data/Game.vala"
	_data_->_tmp12_ = _data_->_tmp13_;
#line 490 "../src/data/Game.vala"
	if (_data_->_tmp12_ == NULL) {
#line 490 "../src/data/Game.vala"
		_data_->_tmp14_ = _data_->overlay_dir;
#line 490 "../src/data/Game.vala"
		_data_->_tmp15_ = g_file_get_child (_data_->_tmp14_, "persist");
#line 490 "../src/data/Game.vala"
		_g_object_unref0 (_data_->_tmp12_);
#line 490 "../src/data/Game.vala"
		_data_->_tmp12_ = _data_->_tmp15_;
#line 4356 "Game.c"
	}
#line 490 "../src/data/Game.vala"
	_data_->_tmp16_ = _data_->_tmp12_;
#line 490 "../src/data/Game.vala"
	_data_->_tmp12_ = NULL;
#line 490 "../src/data/Game.vala"
	_data_->persist_dir = _data_->_tmp16_;
#line 491 "../src/data/Game.vala"
	_data_->_tmp17_ = _data_->overlay_dir;
#line 491 "../src/data/Game.vala"
	_data_->_tmp18_ = g_file_get_child (_data_->_tmp17_, "workdir");
#line 491 "../src/data/Game.vala"
	_data_->work_dir = _data_->_tmp18_;
#line 493 "../src/data/Game.vala"
	_data_->_tmp19_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 493 "../src/data/Game.vala"
	_data_->dirs = _data_->_tmp19_;
#line 4374 "Game.c"
	{
#line 495 "../src/data/Game.vala"
		_data_->_tmp20_ = _data_->self->overlays;
#line 495 "../src/data/Game.vala"
		_data_->_overlay_list = _data_->_tmp20_;
#line 495 "../src/data/Game.vala"
		_data_->_tmp21_ = _data_->_overlay_list;
#line 495 "../src/data/Game.vala"
		_data_->_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp21_);
#line 495 "../src/data/Game.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 495 "../src/data/Game.vala"
		_data_->_overlay_size = _data_->_tmp23_;
#line 495 "../src/data/Game.vala"
		_data_->_overlay_index = -1;
#line 495 "../src/data/Game.vala"
		while (TRUE) {
#line 495 "../src/data/Game.vala"
			_data_->_overlay_index = _data_->_overlay_index + 1;
#line 495 "../src/data/Game.vala"
			_data_->_tmp24_ = _data_->_overlay_index;
#line 495 "../src/data/Game.vala"
			_data_->_tmp25_ = _data_->_overlay_size;
#line 495 "../src/data/Game.vala"
			if (!(_data_->_tmp24_ < _data_->_tmp25_)) {
#line 495 "../src/data/Game.vala"
				break;
#line 4402 "Game.c"
			}
#line 495 "../src/data/Game.vala"
			_data_->_tmp26_ = _data_->_overlay_list;
#line 495 "../src/data/Game.vala"
			_data_->_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp26_, _data_->_overlay_index);
#line 495 "../src/data/Game.vala"
			_data_->overlay = (GameHubDataGameOverlay*) _data_->_tmp27_;
#line 497 "../src/data/Game.vala"
			_data_->_tmp28_ = _data_->overlay;
#line 497 "../src/data/Game.vala"
			_data_->_tmp29_ = game_hub_data_game_overlay_get_enabled (_data_->_tmp28_);
#line 497 "../src/data/Game.vala"
			_data_->_tmp30_ = _data_->_tmp29_;
#line 497 "../src/data/Game.vala"
			if (_data_->_tmp30_) {
#line 499 "../src/data/Game.vala"
				_data_->_tmp31_ = _data_->dirs;
#line 499 "../src/data/Game.vala"
				_data_->_tmp32_ = _data_->overlay;
#line 499 "../src/data/Game.vala"
				_data_->_tmp33_ = _data_->_tmp32_->directory;
#line 499 "../src/data/Game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp31_, _data_->_tmp33_);
#line 4426 "Game.c"
			}
#line 495 "../src/data/Game.vala"
			_g_object_unref0 (_data_->overlay);
#line 4430 "Game.c"
		}
	}
#line 503 "../src/data/Game.vala"
	_data_->_tmp34_ = _data_->merged_dir;
#line 503 "../src/data/Game.vala"
	_data_->_tmp35_ = _data_->dirs;
#line 503 "../src/data/Game.vala"
	_data_->_tmp36_ = _data_->persist_dir;
#line 503 "../src/data/Game.vala"
	_data_->_tmp37_ = _data_->work_dir;
#line 503 "../src/data/Game.vala"
	_data_->_tmp38_ = game_hub_utils_fs_overlay_new (_data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_);
#line 503 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self->priv->fs_overlay);
#line 503 "../src/data/Game.vala"
	_data_->self->priv->fs_overlay = _data_->_tmp38_;
#line 504 "../src/data/Game.vala"
	_data_->_tmp39_ = _data_->self->priv->fs_overlay;
#line 504 "../src/data/Game.vala"
	_data_->_tmp40_ = game_hub_utils_fs_overlay_get_options (_data_->_tmp39_);
#line 504 "../src/data/Game.vala"
	_data_->_tmp41_ = _data_->_tmp40_;
#line 504 "../src/data/Game.vala"
	_data_->_tmp42_ = _data_->self->priv->fs_overlay_last_options;
#line 504 "../src/data/Game.vala"
	if (g_strcmp0 (_data_->_tmp41_, _data_->_tmp42_) != 0) {
#line 506 "../src/data/Game.vala"
		_data_->_tmp43_ = _data_->self->priv->fs_overlay;
#line 506 "../src/data/Game.vala"
		_data_->_tmp44_ = game_hub_utils_fs_overlay_get_options (_data_->_tmp43_);
#line 506 "../src/data/Game.vala"
		_data_->_tmp45_ = _data_->_tmp44_;
#line 506 "../src/data/Game.vala"
		_data_->_tmp46_ = g_strdup (_data_->_tmp45_);
#line 506 "../src/data/Game.vala"
		_g_free0 (_data_->self->priv->fs_overlay_last_options);
#line 506 "../src/data/Game.vala"
		_data_->self->priv->fs_overlay_last_options = _data_->_tmp46_;
#line 507 "../src/data/Game.vala"
		_data_->_tmp47_ = _data_->self->priv->fs_overlay;
#line 507 "../src/data/Game.vala"
		_data_->_state_ = 2;
#line 507 "../src/data/Game.vala"
		game_hub_utils_fs_overlay_mount (_data_->_tmp47_, game_hub_data_game_mount_overlays_ready, _data_);
#line 507 "../src/data/Game.vala"
		return FALSE;
#line 4477 "Game.c"
		_state_2:
#line 507 "../src/data/Game.vala"
		game_hub_utils_fs_overlay_mount_finish (_data_->_tmp47_, _data_->_res_);
#line 4481 "Game.c"
	}
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->dirs);
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->work_dir);
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->persist_dir);
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->_tmp12_);
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->merged_dir);
#line 477 "../src/data/Game.vala"
	_g_object_unref0 (_data_->overlay_dir);
#line 477 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 477 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 477 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 477 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4503 "Game.c"
		}
	}
#line 477 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 477 "../src/data/Game.vala"
	return FALSE;
#line 4510 "Game.c"
}

static void
game_hub_data_game_umount_overlays_data_free (gpointer _data)
{
	GameHubDataGameUmountOverlaysData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameUmountOverlaysData, _data_);
#line 4522 "Game.c"
}

void
game_hub_data_game_umount_overlays (GameHubDataGame* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GameHubDataGameUmountOverlaysData* _data_;
	GameHubDataGame* _tmp0_;
#line 28 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameUmountOverlaysData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_umount_overlays_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_umount_overlays_co (_data_);
#line 4546 "Game.c"
}

void
game_hub_data_game_umount_overlays_finish (GameHubDataGame* self,
                                           GAsyncResult* _res_)
{
	GameHubDataGameUmountOverlaysData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4556 "Game.c"
}

static void
game_hub_data_game_umount_overlays_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GameHubDataGameUmountOverlaysData* _data_;
#line 515 "../src/data/Game.vala"
	_data_ = _user_data_;
#line 515 "../src/data/Game.vala"
	_data_->_source_object_ = source_object;
#line 515 "../src/data/Game.vala"
	_data_->_res_ = _res_;
#line 515 "../src/data/Game.vala"
	game_hub_data_game_umount_overlays_co (_data_);
#line 4573 "Game.c"
}

static gboolean
game_hub_data_game_umount_overlays_co (GameHubDataGameUmountOverlaysData* _data_)
{
#line 511 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 511 "../src/data/Game.vala"
		case 0:
#line 4583 "Game.c"
		goto _state_0;
#line 511 "../src/data/Game.vala"
		case 1:
#line 4587 "Game.c"
		goto _state_1;
#line 511 "../src/data/Game.vala"
		case 2:
#line 4591 "Game.c"
		goto _state_2;
		default:
#line 511 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 4596 "Game.c"
	}
	_state_0:
#line 513 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (_data_->self)) {
#line 515 "../src/data/Game.vala"
		_data_->_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 515 "../src/data/Game.vala"
		if (_data_->_tmp0_ != NULL) {
#line 515 "../src/data/Game.vala"
			_data_->_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 515 "../src/data/Game.vala"
			_data_->_state_ = 1;
#line 515 "../src/data/Game.vala"
			game_hub_data_game_umount_overlays ((GameHubDataGame*) _data_->_tmp1_, game_hub_data_game_umount_overlays_ready, _data_);
#line 515 "../src/data/Game.vala"
			return FALSE;
#line 4613 "Game.c"
			_state_1:
#line 515 "../src/data/Game.vala"
			game_hub_data_game_umount_overlays_finish ((GameHubDataGame*) _data_->_tmp1_, _data_->_res_);
#line 4617 "Game.c"
		}
#line 516 "../src/data/Game.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 516 "../src/data/Game.vala"
		if (_data_->_state_ != 0) {
#line 516 "../src/data/Game.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 516 "../src/data/Game.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4627 "Game.c"
			}
		}
#line 516 "../src/data/Game.vala"
		g_object_unref (_data_->_async_result);
#line 516 "../src/data/Game.vala"
		return FALSE;
#line 4634 "Game.c"
	}
#line 519 "../src/data/Game.vala"
	_data_->_tmp3_ = game_hub_data_game_get_overlays_enabled (_data_->self);
#line 519 "../src/data/Game.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 519 "../src/data/Game.vala"
	if (!_data_->_tmp4_) {
#line 519 "../src/data/Game.vala"
		_data_->_tmp2_ = TRUE;
#line 4644 "Game.c"
	} else {
#line 519 "../src/data/Game.vala"
		_data_->_tmp5_ = _data_->self->priv->fs_overlay;
#line 519 "../src/data/Game.vala"
		_data_->_tmp2_ = _data_->_tmp5_ == NULL;
#line 4650 "Game.c"
	}
#line 519 "../src/data/Game.vala"
	if (_data_->_tmp2_) {
#line 519 "../src/data/Game.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 519 "../src/data/Game.vala"
		if (_data_->_state_ != 0) {
#line 519 "../src/data/Game.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 519 "../src/data/Game.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4662 "Game.c"
			}
		}
#line 519 "../src/data/Game.vala"
		g_object_unref (_data_->_async_result);
#line 519 "../src/data/Game.vala"
		return FALSE;
#line 4669 "Game.c"
	}
#line 520 "../src/data/Game.vala"
	_data_->_tmp6_ = _data_->self->priv->fs_overlay;
#line 520 "../src/data/Game.vala"
	_data_->_state_ = 2;
#line 520 "../src/data/Game.vala"
	game_hub_utils_fs_overlay_umount (_data_->_tmp6_, game_hub_data_game_umount_overlays_ready, _data_);
#line 520 "../src/data/Game.vala"
	return FALSE;
#line 4679 "Game.c"
	_state_2:
#line 520 "../src/data/Game.vala"
	game_hub_utils_fs_overlay_umount_finish (_data_->_tmp6_, _data_->_res_);
#line 511 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 511 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 511 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 511 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4691 "Game.c"
		}
	}
#line 511 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 511 "../src/data/Game.vala"
	return FALSE;
#line 4698 "Game.c"
}

static void
game_hub_data_game_real_load_achievements_data_free (gpointer _data)
{
	GameHubDataGameLoadAchievementsData* _data_;
	_data_ = _data;
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->result);
#line 28 "../src/data/Game.vala"
	_g_object_unref0 (_data_->self);
#line 28 "../src/data/Game.vala"
	g_slice_free (GameHubDataGameLoadAchievementsData, _data_);
#line 4712 "Game.c"
}

static void
game_hub_data_game_real_load_achievements (GameHubDataGame* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GameHubDataGameLoadAchievementsData* _data_;
	GameHubDataGame* _tmp0_;
#line 28 "../src/data/Game.vala"
	_data_ = g_slice_new0 (GameHubDataGameLoadAchievementsData);
#line 28 "../src/data/Game.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 28 "../src/data/Game.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_game_real_load_achievements_data_free);
#line 28 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "../src/data/Game.vala"
	_data_->self = _tmp0_;
#line 28 "../src/data/Game.vala"
	game_hub_data_game_real_load_achievements_co (_data_);
#line 4734 "Game.c"
}

static GeeArrayList*
game_hub_data_game_real_load_achievements_finish (GameHubDataGame* self,
                                                  GAsyncResult* _res_)
{
	GeeArrayList* result;
	GameHubDataGameLoadAchievementsData* _data_;
#line 28 "../src/data/Game.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 28 "../src/data/Game.vala"
	result = _data_->result;
#line 28 "../src/data/Game.vala"
	_data_->result = NULL;
#line 28 "../src/data/Game.vala"
	return result;
#line 4751 "Game.c"
}

static gboolean
game_hub_data_game_real_load_achievements_co (GameHubDataGameLoadAchievementsData* _data_)
{
#line 524 "../src/data/Game.vala"
	switch (_data_->_state_) {
#line 524 "../src/data/Game.vala"
		case 0:
#line 4761 "Game.c"
		goto _state_0;
		default:
#line 524 "../src/data/Game.vala"
		g_assert_not_reached ();
#line 4766 "Game.c"
	}
	_state_0:
#line 524 "../src/data/Game.vala"
	_data_->result = NULL;
#line 524 "../src/data/Game.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 524 "../src/data/Game.vala"
	if (_data_->_state_ != 0) {
#line 524 "../src/data/Game.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 524 "../src/data/Game.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4779 "Game.c"
		}
	}
#line 524 "../src/data/Game.vala"
	g_object_unref (_data_->_async_result);
#line 524 "../src/data/Game.vala"
	return FALSE;
#line 4786 "Game.c"
}

void
game_hub_data_game_load_achievements (GameHubDataGame* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->load_achievements) {
#line 28 "../src/data/Game.vala"
		_klass_->load_achievements (self, _callback_, _user_data_);
#line 4801 "Game.c"
	}
}

GeeArrayList*
game_hub_data_game_load_achievements_finish (GameHubDataGame* self,
                                             GAsyncResult* _res_)
{
	GameHubDataGameClass* _klass_;
#line 28 "../src/data/Game.vala"
	_klass_ = GAME_HUB_DATA_GAME_GET_CLASS (self);
#line 28 "../src/data/Game.vala"
	if (_klass_->load_achievements_finish) {
#line 28 "../src/data/Game.vala"
		return _klass_->load_achievements_finish (self, _res_);
#line 4816 "Game.c"
	}
#line 28 "../src/data/Game.vala"
	return NULL;
#line 4820 "Game.c"
}

gboolean
game_hub_data_game_is_equal (GameHubDataGame* first,
                             GameHubDataGame* second)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 526 "../src/data/Game.vala"
	g_return_val_if_fail (first != NULL, FALSE);
#line 526 "../src/data/Game.vala"
	g_return_val_if_fail (second != NULL, FALSE);
#line 528 "../src/data/Game.vala"
	if (first == second) {
#line 528 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 4837 "Game.c"
	} else {
		gboolean _tmp1_ = FALSE;
		GameHubDataGameSource* _tmp2_;
		GameHubDataGameSource* _tmp3_;
#line 528 "../src/data/Game.vala"
		_tmp2_ = first->priv->_source;
#line 528 "../src/data/Game.vala"
		_tmp3_ = second->priv->_source;
#line 528 "../src/data/Game.vala"
		if (_tmp2_ == _tmp3_) {
#line 4848 "Game.c"
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
#line 528 "../src/data/Game.vala"
			_tmp4_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) first);
#line 528 "../src/data/Game.vala"
			_tmp5_ = _tmp4_;
#line 528 "../src/data/Game.vala"
			_tmp6_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) second);
#line 528 "../src/data/Game.vala"
			_tmp7_ = _tmp6_;
#line 528 "../src/data/Game.vala"
			_tmp1_ = g_strcmp0 (_tmp5_, _tmp7_) == 0;
#line 4863 "Game.c"
		} else {
#line 528 "../src/data/Game.vala"
			_tmp1_ = FALSE;
#line 4867 "Game.c"
		}
#line 528 "../src/data/Game.vala"
		_tmp0_ = _tmp1_;
#line 4871 "Game.c"
	}
#line 528 "../src/data/Game.vala"
	result = _tmp0_;
#line 528 "../src/data/Game.vala"
	return result;
#line 4877 "Game.c"
}

guint
game_hub_data_game_hash (GameHubDataGame* game)
{
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint _tmp4_;
	guint result;
#line 531 "../src/data/Game.vala"
	g_return_val_if_fail (game != NULL, 0U);
#line 533 "../src/data/Game.vala"
	_tmp0_ = g_str_hash;
#line 533 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_game_get_full_id (game);
#line 533 "../src/data/Game.vala"
	_tmp2_ = _tmp1_;
#line 533 "../src/data/Game.vala"
	_tmp3_ = _tmp2_;
#line 533 "../src/data/Game.vala"
	_tmp4_ = _tmp0_ (_tmp3_);
#line 533 "../src/data/Game.vala"
	_g_free0 (_tmp3_);
#line 533 "../src/data/Game.vala"
	result = _tmp4_;
#line 533 "../src/data/Game.vala"
	return result;
#line 4907 "Game.c"
}

GameHubDataGame*
game_hub_data_game_construct (GType object_type)
{
	GameHubDataGame * self = NULL;
#line 28 "../src/data/Game.vala"
	self = (GameHubDataGame*) game_hub_data_runnable_construct (object_type);
#line 28 "../src/data/Game.vala"
	return self;
#line 4918 "Game.c"
}

GameHubDataGameSource*
game_hub_data_game_get_source (GameHubDataGame* self)
{
	GameHubDataGameSource* result;
	GameHubDataGameSource* _tmp0_;
#line 30 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "../src/data/Game.vala"
	_tmp0_ = self->priv->_source;
#line 30 "../src/data/Game.vala"
	result = _tmp0_;
#line 30 "../src/data/Game.vala"
	return result;
#line 4934 "Game.c"
}

static gpointer
_game_hub_data_game_source_ref0 (gpointer self)
{
#line 30 "../src/data/Game.vala"
	return self ? game_hub_data_game_source_ref (self) : NULL;
#line 4942 "Game.c"
}

void
game_hub_data_game_set_source (GameHubDataGame* self,
                               GameHubDataGameSource* value)
{
	GameHubDataGameSource* old_value;
#line 30 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 30 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_source (self);
#line 30 "../src/data/Game.vala"
	if (old_value != value) {
#line 4956 "Game.c"
		GameHubDataGameSource* _tmp0_;
#line 30 "../src/data/Game.vala"
		_tmp0_ = _game_hub_data_game_source_ref0 (value);
#line 30 "../src/data/Game.vala"
		_game_hub_data_game_source_unref0 (self->priv->_source);
#line 30 "../src/data/Game.vala"
		self->priv->_source = _tmp0_;
#line 30 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_SOURCE_PROPERTY]);
#line 4966 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_description (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 32 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "../src/data/Game.vala"
	_tmp0_ = self->priv->_description;
#line 32 "../src/data/Game.vala"
	result = _tmp0_;
#line 32 "../src/data/Game.vala"
	return result;
#line 4983 "Game.c"
}

void
game_hub_data_game_set_description (GameHubDataGame* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 32 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 32 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_description (self);
#line 32 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 4997 "Game.c"
		gchar* _tmp0_;
#line 32 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 32 "../src/data/Game.vala"
		_g_free0 (self->priv->_description);
#line 32 "../src/data/Game.vala"
		self->priv->_description = _tmp0_;
#line 32 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY]);
#line 5007 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_icon (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 34 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../src/data/Game.vala"
	_tmp0_ = self->priv->_icon;
#line 34 "../src/data/Game.vala"
	result = _tmp0_;
#line 34 "../src/data/Game.vala"
	return result;
#line 5024 "Game.c"
}

void
game_hub_data_game_set_icon (GameHubDataGame* self,
                             const gchar* value)
{
	gchar* old_value;
#line 34 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 34 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_icon (self);
#line 34 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5038 "Game.c"
		gchar* _tmp0_;
#line 34 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../src/data/Game.vala"
		_g_free0 (self->priv->_icon);
#line 34 "../src/data/Game.vala"
		self->priv->_icon = _tmp0_;
#line 34 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_ICON_PROPERTY]);
#line 5048 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_image (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 35 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "../src/data/Game.vala"
	_tmp0_ = self->priv->_image;
#line 35 "../src/data/Game.vala"
	result = _tmp0_;
#line 35 "../src/data/Game.vala"
	return result;
#line 5065 "Game.c"
}

void
game_hub_data_game_set_image (GameHubDataGame* self,
                              const gchar* value)
{
	gchar* old_value;
#line 35 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 35 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_image (self);
#line 35 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5079 "Game.c"
		gchar* _tmp0_;
#line 35 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 35 "../src/data/Game.vala"
		_g_free0 (self->priv->_image);
#line 35 "../src/data/Game.vala"
		self->priv->_image = _tmp0_;
#line 35 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IMAGE_PROPERTY]);
#line 5089 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_image_vertical (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 36 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "../src/data/Game.vala"
	_tmp0_ = self->priv->_image_vertical;
#line 36 "../src/data/Game.vala"
	result = _tmp0_;
#line 36 "../src/data/Game.vala"
	return result;
#line 5106 "Game.c"
}

void
game_hub_data_game_set_image_vertical (GameHubDataGame* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 36 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 36 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_image_vertical (self);
#line 36 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5120 "Game.c"
		gchar* _tmp0_;
#line 36 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 36 "../src/data/Game.vala"
		_g_free0 (self->priv->_image_vertical);
#line 36 "../src/data/Game.vala"
		self->priv->_image_vertical = _tmp0_;
#line 36 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY]);
#line 5130 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_info (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 38 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../src/data/Game.vala"
	_tmp0_ = self->priv->_info;
#line 38 "../src/data/Game.vala"
	result = _tmp0_;
#line 38 "../src/data/Game.vala"
	return result;
#line 5147 "Game.c"
}

void
game_hub_data_game_set_info (GameHubDataGame* self,
                             const gchar* value)
{
	gchar* old_value;
#line 38 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 38 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_info (self);
#line 38 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5161 "Game.c"
		gchar* _tmp0_;
#line 38 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 38 "../src/data/Game.vala"
		_g_free0 (self->priv->_info);
#line 38 "../src/data/Game.vala"
		self->priv->_info = _tmp0_;
#line 38 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INFO_PROPERTY]);
#line 5171 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_info_detailed (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 39 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../src/data/Game.vala"
	_tmp0_ = self->priv->_info_detailed;
#line 39 "../src/data/Game.vala"
	result = _tmp0_;
#line 39 "../src/data/Game.vala"
	return result;
#line 5188 "Game.c"
}

void
game_hub_data_game_set_info_detailed (GameHubDataGame* self,
                                      const gchar* value)
{
	gchar* old_value;
#line 39 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 39 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_info_detailed (self);
#line 39 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5202 "Game.c"
		gchar* _tmp0_;
#line 39 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 39 "../src/data/Game.vala"
		_g_free0 (self->priv->_info_detailed);
#line 39 "../src/data/Game.vala"
		self->priv->_info_detailed = _tmp0_;
#line 39 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY]);
#line 5212 "Game.c"
	}
}

gchar*
game_hub_data_game_get_full_id (GameHubDataGame* self)
{
	gchar* result;
	GameHubDataGameSource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 41 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "../src/data/Game.vala"
	_tmp0_ = self->priv->_source;
#line 41 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_game_source_get_id (_tmp0_);
#line 41 "../src/data/Game.vala"
	_tmp2_ = _tmp1_;
#line 41 "../src/data/Game.vala"
	_tmp3_ = g_strconcat (_tmp2_, ":", NULL);
#line 41 "../src/data/Game.vala"
	_tmp4_ = _tmp3_;
#line 41 "../src/data/Game.vala"
	_tmp5_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 41 "../src/data/Game.vala"
	_tmp6_ = _tmp5_;
#line 41 "../src/data/Game.vala"
	_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
#line 41 "../src/data/Game.vala"
	_tmp8_ = _tmp7_;
#line 41 "../src/data/Game.vala"
	_g_free0 (_tmp4_);
#line 41 "../src/data/Game.vala"
	result = _tmp8_;
#line 41 "../src/data/Game.vala"
	return result;
#line 5255 "Game.c"
}

const gchar*
game_hub_data_game_get_version (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 43 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "../src/data/Game.vala"
	_tmp0_ = self->priv->_version;
#line 43 "../src/data/Game.vala"
	result = _tmp0_;
#line 43 "../src/data/Game.vala"
	return result;
#line 5271 "Game.c"
}

void
game_hub_data_game_set_version (GameHubDataGame* self,
                                const gchar* value)
{
	gchar* old_value;
#line 43 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_version (self);
#line 43 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5285 "Game.c"
		gchar* _tmp0_;
#line 43 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 43 "../src/data/Game.vala"
		_g_free0 (self->priv->_version);
#line 43 "../src/data/Game.vala"
		self->priv->_version = _tmp0_;
#line 43 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_VERSION_PROPERTY]);
#line 5295 "Game.c"
	}
}

GeeArrayList*
game_hub_data_game_get_tags (GameHubDataGame* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 45 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "../src/data/Game.vala"
	_tmp0_ = self->priv->_tags;
#line 45 "../src/data/Game.vala"
	result = _tmp0_;
#line 45 "../src/data/Game.vala"
	return result;
#line 5312 "Game.c"
}

void
game_hub_data_game_set_tags (GameHubDataGame* self,
                             GeeArrayList* value)
{
	GeeArrayList* old_value;
#line 45 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 45 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_tags (self);
#line 45 "../src/data/Game.vala"
	if (old_value != value) {
#line 5326 "Game.c"
		GeeArrayList* _tmp0_;
#line 45 "../src/data/Game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 45 "../src/data/Game.vala"
		_g_object_unref0 (self->priv->_tags);
#line 45 "../src/data/Game.vala"
		self->priv->_tags = _tmp0_;
#line 45 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_TAGS_PROPERTY]);
#line 5336 "Game.c"
	}
}

GFile*
game_hub_data_game_get_installers_dir (GameHubDataGame* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 101 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "../src/data/Game.vala"
	_tmp0_ = self->priv->_installers_dir;
#line 101 "../src/data/Game.vala"
	result = _tmp0_;
#line 101 "../src/data/Game.vala"
	return result;
#line 5353 "Game.c"
}

void
game_hub_data_game_set_installers_dir (GameHubDataGame* self,
                                       GFile* value)
{
	GFile* old_value;
#line 101 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 101 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_installers_dir (self);
#line 101 "../src/data/Game.vala"
	if (old_value != value) {
#line 5367 "Game.c"
		GFile* _tmp0_;
#line 101 "../src/data/Game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 101 "../src/data/Game.vala"
		_g_object_unref0 (self->priv->_installers_dir);
#line 101 "../src/data/Game.vala"
		self->priv->_installers_dir = _tmp0_;
#line 101 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY]);
#line 5377 "Game.c"
	}
}

gboolean
game_hub_data_game_get_is_installable (GameHubDataGame* self)
{
	gboolean result;
#line 102 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 102 "../src/data/Game.vala"
	result = self->priv->_is_installable;
#line 102 "../src/data/Game.vala"
	return result;
#line 5391 "Game.c"
}

void
game_hub_data_game_set_is_installable (GameHubDataGame* self,
                                       gboolean value)
{
	gboolean old_value;
#line 102 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 102 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_is_installable (self);
#line 102 "../src/data/Game.vala"
	if (old_value != value) {
#line 102 "../src/data/Game.vala"
		self->priv->_is_installable = value;
#line 102 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY]);
#line 5409 "Game.c"
	}
}

const gchar*
game_hub_data_game_get_store_page (GameHubDataGame* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 104 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "../src/data/Game.vala"
	_tmp0_ = self->priv->_store_page;
#line 104 "../src/data/Game.vala"
	result = _tmp0_;
#line 104 "../src/data/Game.vala"
	return result;
#line 5426 "Game.c"
}

void
game_hub_data_game_set_store_page (GameHubDataGame* self,
                                   const gchar* value)
{
	gchar* old_value;
#line 104 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 104 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_store_page (self);
#line 104 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 5440 "Game.c"
		gchar* _tmp0_;
#line 104 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 104 "../src/data/Game.vala"
		_g_free0 (self->priv->_store_page);
#line 104 "../src/data/Game.vala"
		self->priv->_store_page = _tmp0_;
#line 104 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY]);
#line 5450 "Game.c"
	}
}

gint64
game_hub_data_game_get_last_launch (GameHubDataGame* self)
{
	gint64 result;
#line 106 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 106 "../src/data/Game.vala"
	result = self->priv->_last_launch;
#line 106 "../src/data/Game.vala"
	return result;
#line 5464 "Game.c"
}

void
game_hub_data_game_set_last_launch (GameHubDataGame* self,
                                    gint64 value)
{
	gint64 old_value;
#line 106 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 106 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_last_launch (self);
#line 106 "../src/data/Game.vala"
	if (old_value != value) {
#line 106 "../src/data/Game.vala"
		self->priv->_last_launch = value;
#line 106 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY]);
#line 5482 "Game.c"
	}
}

GameHubDataGameStatus*
game_hub_data_game_get_status (GameHubDataGame* self)
{
	GameHubDataGameStatus* result;
	GameHubDataGameStatus* _tmp0_;
#line 232 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 232 "../src/data/Game.vala"
	_tmp0_ = self->_status;
#line 232 "../src/data/Game.vala"
	result = _tmp0_;
#line 232 "../src/data/Game.vala"
	return result;
#line 5499 "Game.c"
}

static gpointer
_game_hub_data_game_status_ref0 (gpointer self)
{
#line 233 "../src/data/Game.vala"
	return self ? game_hub_data_game_status_ref (self) : NULL;
#line 5507 "Game.c"
}

void
game_hub_data_game_set_status (GameHubDataGame* self,
                               GameHubDataGameStatus* value)
{
	GameHubDataGameStatus* _tmp0_;
	GameHubDataGameStatus* _tmp1_;
#line 233 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 233 "../src/data/Game.vala"
	_tmp0_ = _game_hub_data_game_status_ref0 (value);
#line 233 "../src/data/Game.vala"
	_game_hub_data_game_status_unref0 (self->_status);
#line 233 "../src/data/Game.vala"
	self->_status = _tmp0_;
#line 233 "../src/data/Game.vala"
	_tmp1_ = self->_status;
#line 233 "../src/data/Game.vala"
	g_signal_emit (self, game_hub_data_game_signals[GAME_HUB_DATA_GAME_STATUS_CHANGE_SIGNAL], 0, _tmp1_);
#line 233 "../src/data/Game.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_STATUS_PROPERTY]);
#line 5530 "Game.c"
}

gint64
game_hub_data_game_get_playtime_source (GameHubDataGame* self)
{
	gint64 result;
#line 236 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 236 "../src/data/Game.vala"
	result = self->priv->_playtime_source;
#line 236 "../src/data/Game.vala"
	return result;
#line 5543 "Game.c"
}

void
game_hub_data_game_set_playtime_source (GameHubDataGame* self,
                                        gint64 value)
{
	gint64 old_value;
#line 236 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 236 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_playtime_source (self);
#line 236 "../src/data/Game.vala"
	if (old_value != value) {
#line 236 "../src/data/Game.vala"
		self->priv->_playtime_source = value;
#line 236 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY]);
#line 5561 "Game.c"
	}
}

gint64
game_hub_data_game_get_playtime_tracked (GameHubDataGame* self)
{
	gint64 result;
#line 237 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 237 "../src/data/Game.vala"
	result = self->priv->_playtime_tracked;
#line 237 "../src/data/Game.vala"
	return result;
#line 5575 "Game.c"
}

void
game_hub_data_game_set_playtime_tracked (GameHubDataGame* self,
                                         gint64 value)
{
	gint64 old_value;
#line 237 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 237 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_playtime_tracked (self);
#line 237 "../src/data/Game.vala"
	if (old_value != value) {
#line 237 "../src/data/Game.vala"
		self->priv->_playtime_tracked = value;
#line 237 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY]);
#line 5593 "Game.c"
	}
}

gint64
game_hub_data_game_get_playtime (GameHubDataGame* self)
{
	gint64 result;
	gint64 _tmp0_;
	gint64 _tmp1_;
#line 239 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 239 "../src/data/Game.vala"
	_tmp0_ = self->priv->_playtime_source;
#line 239 "../src/data/Game.vala"
	_tmp1_ = self->priv->_playtime_tracked;
#line 239 "../src/data/Game.vala"
	result = _tmp0_ + _tmp1_;
#line 239 "../src/data/Game.vala"
	return result;
#line 5613 "Game.c"
}

static GFile*
game_hub_data_game_real_get_executable (GameHubDataRunnable* base)
{
	GFile* result;
	GameHubDataGame* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
#line 287 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 289 "../src/data/Game.vala"
	_tmp2_ = self->executable_path;
#line 289 "../src/data/Game.vala"
	if (_tmp2_ == NULL) {
#line 289 "../src/data/Game.vala"
		_tmp1_ = TRUE;
#line 5634 "Game.c"
	} else {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 289 "../src/data/Game.vala"
		_tmp3_ = self->executable_path;
#line 289 "../src/data/Game.vala"
		_tmp4_ = strlen (_tmp3_);
#line 289 "../src/data/Game.vala"
		_tmp5_ = _tmp4_;
#line 289 "../src/data/Game.vala"
		_tmp1_ = _tmp5_ == 0;
#line 5647 "Game.c"
	}
#line 289 "../src/data/Game.vala"
	if (_tmp1_) {
#line 289 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 5653 "Game.c"
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
#line 289 "../src/data/Game.vala"
		_tmp6_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 289 "../src/data/Game.vala"
		_tmp7_ = _tmp6_;
#line 289 "../src/data/Game.vala"
		_tmp0_ = _tmp7_ == NULL;
#line 5663 "Game.c"
	}
#line 289 "../src/data/Game.vala"
	if (_tmp0_) {
#line 289 "../src/data/Game.vala"
		result = NULL;
#line 289 "../src/data/Game.vala"
		return result;
#line 5671 "Game.c"
	}
#line 290 "../src/data/Game.vala"
	_tmp8_ = self->executable_path;
#line 290 "../src/data/Game.vala"
	_tmp9_ = game_hub_data_game_get_file (self, _tmp8_, TRUE);
#line 290 "../src/data/Game.vala"
	result = _tmp9_;
#line 290 "../src/data/Game.vala"
	return result;
#line 5681 "Game.c"
}

static void
game_hub_data_game_real_set_executable (GameHubDataRunnable* base,
                                        GFile* value)
{
	GameHubDataGame* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 292 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 294 "../src/data/Game.vala"
	if (value != NULL) {
#line 294 "../src/data/Game.vala"
		_tmp2_ = g_file_query_exists (value, NULL);
#line 5698 "Game.c"
	} else {
#line 294 "../src/data/Game.vala"
		_tmp2_ = FALSE;
#line 5702 "Game.c"
	}
#line 294 "../src/data/Game.vala"
	if (_tmp2_) {
#line 5706 "Game.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 294 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 294 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 294 "../src/data/Game.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 5715 "Game.c"
	} else {
#line 294 "../src/data/Game.vala"
		_tmp1_ = FALSE;
#line 5719 "Game.c"
	}
#line 294 "../src/data/Game.vala"
	if (_tmp1_) {
#line 5723 "Game.c"
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 294 "../src/data/Game.vala"
		_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 294 "../src/data/Game.vala"
		_tmp6_ = _tmp5_;
#line 294 "../src/data/Game.vala"
		_tmp0_ = g_file_query_exists (_tmp6_, NULL);
#line 5732 "Game.c"
	} else {
#line 294 "../src/data/Game.vala"
		_tmp0_ = FALSE;
#line 5736 "Game.c"
	}
#line 294 "../src/data/Game.vala"
	if (_tmp0_) {
#line 5740 "Game.c"
		GFile** dirs = NULL;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile** _tmp10_;
		gint dirs_length1;
		gint _dirs_size_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		GFile** _tmp31_;
		gint _tmp31__length1;
#line 296 "../src/data/Game.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 296 "../src/data/Game.vala"
		_tmp8_ = _tmp7_;
#line 296 "../src/data/Game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 296 "../src/data/Game.vala"
		_tmp10_ = g_new0 (GFile*, 1 + 1);
#line 296 "../src/data/Game.vala"
		_tmp10_[0] = _tmp9_;
#line 296 "../src/data/Game.vala"
		dirs = _tmp10_;
#line 296 "../src/data/Game.vala"
		dirs_length1 = 1;
#line 296 "../src/data/Game.vala"
		_dirs_size_ = dirs_length1;
#line 297 "../src/data/Game.vala"
		_tmp11_ = game_hub_data_game_get_overlays_enabled (self);
#line 297 "../src/data/Game.vala"
		_tmp12_ = _tmp11_;
#line 297 "../src/data/Game.vala"
		if (_tmp12_) {
#line 5774 "Game.c"
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			GFile* _tmp29_;
			GFile** _tmp30_;
#line 299 "../src/data/Game.vala"
			_tmp13_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 299 "../src/data/Game.vala"
			_tmp14_ = _tmp13_;
#line 299 "../src/data/Game.vala"
			_tmp15_ = g_file_get_child (_tmp14_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 299 "../src/data/Game.vala"
			_tmp16_ = _tmp15_;
#line 299 "../src/data/Game.vala"
			_tmp17_ = g_file_get_child (_tmp16_, "_overlay");
#line 299 "../src/data/Game.vala"
			_tmp18_ = _tmp17_;
#line 299 "../src/data/Game.vala"
			_tmp19_ = g_file_get_child (_tmp18_, "merged");
#line 299 "../src/data/Game.vala"
			_tmp20_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 299 "../src/data/Game.vala"
			_tmp21_ = _tmp20_;
#line 299 "../src/data/Game.vala"
			_tmp22_ = g_file_get_child (_tmp21_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 299 "../src/data/Game.vala"
			_tmp23_ = _tmp22_;
#line 299 "../src/data/Game.vala"
			_tmp24_ = g_file_get_child (_tmp23_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 299 "../src/data/Game.vala"
			_tmp25_ = _tmp24_;
#line 299 "../src/data/Game.vala"
			_tmp26_ = g_file_get_child (_tmp25_, GAME_HUB_DATA_GAME_OVERLAY_BASE);
#line 299 "../src/data/Game.vala"
			_tmp27_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 299 "../src/data/Game.vala"
			_tmp28_ = _tmp27_;
#line 299 "../src/data/Game.vala"
			_tmp29_ = _g_object_ref0 (_tmp28_);
#line 299 "../src/data/Game.vala"
			_tmp30_ = g_new0 (GFile*, 3 + 1);
#line 299 "../src/data/Game.vala"
			_tmp30_[0] = _tmp19_;
#line 299 "../src/data/Game.vala"
			_tmp30_[1] = _tmp26_;
#line 299 "../src/data/Game.vala"
			_tmp30_[2] = _tmp29_;
#line 299 "../src/data/Game.vala"
			dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 299 "../src/data/Game.vala"
			dirs = _tmp30_;
#line 299 "../src/data/Game.vala"
			dirs_length1 = 3;
#line 299 "../src/data/Game.vala"
			_dirs_size_ = dirs_length1;
#line 299 "../src/data/Game.vala"
			_g_object_unref0 (_tmp25_);
#line 299 "../src/data/Game.vala"
			_g_object_unref0 (_tmp23_);
#line 299 "../src/data/Game.vala"
			_g_object_unref0 (_tmp18_);
#line 299 "../src/data/Game.vala"
			_g_object_unref0 (_tmp16_);
#line 5851 "Game.c"
		}
#line 305 "../src/data/Game.vala"
		_tmp31_ = dirs;
#line 305 "../src/data/Game.vala"
		_tmp31__length1 = dirs_length1;
#line 5857 "Game.c"
		{
			GFile** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
#line 305 "../src/data/Game.vala"
			dir_collection = _tmp31_;
#line 305 "../src/data/Game.vala"
			dir_collection_length1 = _tmp31__length1;
#line 305 "../src/data/Game.vala"
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 5869 "Game.c"
				GFile* _tmp32_;
				GFile* dir = NULL;
#line 305 "../src/data/Game.vala"
				_tmp32_ = _g_object_ref0 (dir_collection[dir_it]);
#line 305 "../src/data/Game.vala"
				dir = _tmp32_;
#line 5876 "Game.c"
				{
					gchar* _tmp33_;
					gchar* _tmp34_;
					GFile* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gboolean _tmp38_;
#line 307 "../src/data/Game.vala"
					_tmp33_ = g_file_get_path (value);
#line 307 "../src/data/Game.vala"
					_tmp34_ = _tmp33_;
#line 307 "../src/data/Game.vala"
					_tmp35_ = dir;
#line 307 "../src/data/Game.vala"
					_tmp36_ = g_file_get_path (_tmp35_);
#line 307 "../src/data/Game.vala"
					_tmp37_ = _tmp36_;
#line 307 "../src/data/Game.vala"
					_tmp38_ = g_str_has_prefix (_tmp34_, _tmp37_);
#line 307 "../src/data/Game.vala"
					_g_free0 (_tmp37_);
#line 307 "../src/data/Game.vala"
					_g_free0 (_tmp34_);
#line 307 "../src/data/Game.vala"
					if (_tmp38_) {
#line 5902 "Game.c"
						gchar* _tmp39_;
						gchar* _tmp40_;
						GFile* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
#line 309 "../src/data/Game.vala"
						_tmp39_ = g_file_get_path (value);
#line 309 "../src/data/Game.vala"
						_tmp40_ = _tmp39_;
#line 309 "../src/data/Game.vala"
						_tmp41_ = dir;
#line 309 "../src/data/Game.vala"
						_tmp42_ = g_file_get_path (_tmp41_);
#line 309 "../src/data/Game.vala"
						_tmp43_ = _tmp42_;
#line 309 "../src/data/Game.vala"
						_tmp44_ = string_replace (_tmp40_, _tmp43_, "$game_dir");
#line 309 "../src/data/Game.vala"
						_g_free0 (self->executable_path);
#line 309 "../src/data/Game.vala"
						self->executable_path = _tmp44_;
#line 309 "../src/data/Game.vala"
						_g_free0 (_tmp43_);
#line 309 "../src/data/Game.vala"
						_g_free0 (_tmp40_);
#line 310 "../src/data/Game.vala"
						_g_object_unref0 (dir);
#line 310 "../src/data/Game.vala"
						break;
#line 5933 "Game.c"
					}
#line 305 "../src/data/Game.vala"
					_g_object_unref0 (dir);
#line 5937 "Game.c"
				}
			}
		}
#line 294 "../src/data/Game.vala"
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 5943 "Game.c"
	} else {
#line 316 "../src/data/Game.vala"
		_g_free0 (self->executable_path);
#line 316 "../src/data/Game.vala"
		self->executable_path = NULL;
#line 5949 "Game.c"
	}
#line 318 "../src/data/Game.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 292 "../src/data/Game.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY]);
#line 5955 "Game.c"
}

static GFile*
game_hub_data_game_real_get_work_dir (GameHubDataRunnable* base)
{
	GFile* result;
	GameHubDataGame* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
#line 325 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 327 "../src/data/Game.vala"
	_tmp0_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 327 "../src/data/Game.vala"
	_tmp1_ = _tmp0_;
#line 327 "../src/data/Game.vala"
	if (_tmp1_ == NULL) {
#line 327 "../src/data/Game.vala"
		result = NULL;
#line 327 "../src/data/Game.vala"
		return result;
#line 5981 "Game.c"
	}
#line 328 "../src/data/Game.vala"
	_tmp3_ = self->work_dir_path;
#line 328 "../src/data/Game.vala"
	if (_tmp3_ == NULL) {
#line 328 "../src/data/Game.vala"
		_tmp2_ = TRUE;
#line 5989 "Game.c"
	} else {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 328 "../src/data/Game.vala"
		_tmp4_ = self->work_dir_path;
#line 328 "../src/data/Game.vala"
		_tmp5_ = strlen (_tmp4_);
#line 328 "../src/data/Game.vala"
		_tmp6_ = _tmp5_;
#line 328 "../src/data/Game.vala"
		_tmp2_ = _tmp6_ == 0;
#line 6002 "Game.c"
	}
#line 328 "../src/data/Game.vala"
	if (_tmp2_) {
#line 6006 "Game.c"
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
#line 328 "../src/data/Game.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 328 "../src/data/Game.vala"
		_tmp8_ = _tmp7_;
#line 328 "../src/data/Game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 328 "../src/data/Game.vala"
		result = _tmp9_;
#line 328 "../src/data/Game.vala"
		return result;
#line 6020 "Game.c"
	}
#line 329 "../src/data/Game.vala"
	_tmp10_ = self->work_dir_path;
#line 329 "../src/data/Game.vala"
	_tmp11_ = game_hub_data_game_get_file (self, _tmp10_, TRUE);
#line 329 "../src/data/Game.vala"
	result = _tmp11_;
#line 329 "../src/data/Game.vala"
	return result;
#line 6030 "Game.c"
}

static void
game_hub_data_game_real_set_work_dir (GameHubDataRunnable* base,
                                      GFile* value)
{
	GameHubDataGame* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 331 "../src/data/Game.vala"
	self = (GameHubDataGame*) base;
#line 333 "../src/data/Game.vala"
	if (value != NULL) {
#line 333 "../src/data/Game.vala"
		_tmp2_ = g_file_query_exists (value, NULL);
#line 6047 "Game.c"
	} else {
#line 333 "../src/data/Game.vala"
		_tmp2_ = FALSE;
#line 6051 "Game.c"
	}
#line 333 "../src/data/Game.vala"
	if (_tmp2_) {
#line 6055 "Game.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 333 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 333 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 333 "../src/data/Game.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 6064 "Game.c"
	} else {
#line 333 "../src/data/Game.vala"
		_tmp1_ = FALSE;
#line 6068 "Game.c"
	}
#line 333 "../src/data/Game.vala"
	if (_tmp1_) {
#line 6072 "Game.c"
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 333 "../src/data/Game.vala"
		_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 333 "../src/data/Game.vala"
		_tmp6_ = _tmp5_;
#line 333 "../src/data/Game.vala"
		_tmp0_ = g_file_query_exists (_tmp6_, NULL);
#line 6081 "Game.c"
	} else {
#line 333 "../src/data/Game.vala"
		_tmp0_ = FALSE;
#line 6085 "Game.c"
	}
#line 333 "../src/data/Game.vala"
	if (_tmp0_) {
#line 6089 "Game.c"
		GFile** dirs = NULL;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile** _tmp10_;
		gint dirs_length1;
		gint _dirs_size_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		GFile** _tmp31_;
		gint _tmp31__length1;
#line 335 "../src/data/Game.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 335 "../src/data/Game.vala"
		_tmp8_ = _tmp7_;
#line 335 "../src/data/Game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 335 "../src/data/Game.vala"
		_tmp10_ = g_new0 (GFile*, 1 + 1);
#line 335 "../src/data/Game.vala"
		_tmp10_[0] = _tmp9_;
#line 335 "../src/data/Game.vala"
		dirs = _tmp10_;
#line 335 "../src/data/Game.vala"
		dirs_length1 = 1;
#line 335 "../src/data/Game.vala"
		_dirs_size_ = dirs_length1;
#line 336 "../src/data/Game.vala"
		_tmp11_ = game_hub_data_game_get_overlays_enabled (self);
#line 336 "../src/data/Game.vala"
		_tmp12_ = _tmp11_;
#line 336 "../src/data/Game.vala"
		if (_tmp12_) {
#line 6123 "Game.c"
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			GFile* _tmp29_;
			GFile** _tmp30_;
#line 338 "../src/data/Game.vala"
			_tmp13_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 338 "../src/data/Game.vala"
			_tmp14_ = _tmp13_;
#line 338 "../src/data/Game.vala"
			_tmp15_ = g_file_get_child (_tmp14_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 338 "../src/data/Game.vala"
			_tmp16_ = _tmp15_;
#line 338 "../src/data/Game.vala"
			_tmp17_ = g_file_get_child (_tmp16_, "_overlay");
#line 338 "../src/data/Game.vala"
			_tmp18_ = _tmp17_;
#line 338 "../src/data/Game.vala"
			_tmp19_ = g_file_get_child (_tmp18_, "merged");
#line 338 "../src/data/Game.vala"
			_tmp20_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 338 "../src/data/Game.vala"
			_tmp21_ = _tmp20_;
#line 338 "../src/data/Game.vala"
			_tmp22_ = g_file_get_child (_tmp21_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 338 "../src/data/Game.vala"
			_tmp23_ = _tmp22_;
#line 338 "../src/data/Game.vala"
			_tmp24_ = g_file_get_child (_tmp23_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 338 "../src/data/Game.vala"
			_tmp25_ = _tmp24_;
#line 338 "../src/data/Game.vala"
			_tmp26_ = g_file_get_child (_tmp25_, GAME_HUB_DATA_GAME_OVERLAY_BASE);
#line 338 "../src/data/Game.vala"
			_tmp27_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 338 "../src/data/Game.vala"
			_tmp28_ = _tmp27_;
#line 338 "../src/data/Game.vala"
			_tmp29_ = _g_object_ref0 (_tmp28_);
#line 338 "../src/data/Game.vala"
			_tmp30_ = g_new0 (GFile*, 3 + 1);
#line 338 "../src/data/Game.vala"
			_tmp30_[0] = _tmp19_;
#line 338 "../src/data/Game.vala"
			_tmp30_[1] = _tmp26_;
#line 338 "../src/data/Game.vala"
			_tmp30_[2] = _tmp29_;
#line 338 "../src/data/Game.vala"
			dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 338 "../src/data/Game.vala"
			dirs = _tmp30_;
#line 338 "../src/data/Game.vala"
			dirs_length1 = 3;
#line 338 "../src/data/Game.vala"
			_dirs_size_ = dirs_length1;
#line 338 "../src/data/Game.vala"
			_g_object_unref0 (_tmp25_);
#line 338 "../src/data/Game.vala"
			_g_object_unref0 (_tmp23_);
#line 338 "../src/data/Game.vala"
			_g_object_unref0 (_tmp18_);
#line 338 "../src/data/Game.vala"
			_g_object_unref0 (_tmp16_);
#line 6200 "Game.c"
		}
#line 344 "../src/data/Game.vala"
		_tmp31_ = dirs;
#line 344 "../src/data/Game.vala"
		_tmp31__length1 = dirs_length1;
#line 6206 "Game.c"
		{
			GFile** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
#line 344 "../src/data/Game.vala"
			dir_collection = _tmp31_;
#line 344 "../src/data/Game.vala"
			dir_collection_length1 = _tmp31__length1;
#line 344 "../src/data/Game.vala"
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 6218 "Game.c"
				GFile* _tmp32_;
				GFile* dir = NULL;
#line 344 "../src/data/Game.vala"
				_tmp32_ = _g_object_ref0 (dir_collection[dir_it]);
#line 344 "../src/data/Game.vala"
				dir = _tmp32_;
#line 6225 "Game.c"
				{
					gchar* _tmp33_;
					gchar* _tmp34_;
					GFile* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gboolean _tmp38_;
#line 346 "../src/data/Game.vala"
					_tmp33_ = g_file_get_path (value);
#line 346 "../src/data/Game.vala"
					_tmp34_ = _tmp33_;
#line 346 "../src/data/Game.vala"
					_tmp35_ = dir;
#line 346 "../src/data/Game.vala"
					_tmp36_ = g_file_get_path (_tmp35_);
#line 346 "../src/data/Game.vala"
					_tmp37_ = _tmp36_;
#line 346 "../src/data/Game.vala"
					_tmp38_ = g_str_has_prefix (_tmp34_, _tmp37_);
#line 346 "../src/data/Game.vala"
					_g_free0 (_tmp37_);
#line 346 "../src/data/Game.vala"
					_g_free0 (_tmp34_);
#line 346 "../src/data/Game.vala"
					if (_tmp38_) {
#line 6251 "Game.c"
						gchar* _tmp39_;
						gchar* _tmp40_;
						GFile* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
#line 348 "../src/data/Game.vala"
						_tmp39_ = g_file_get_path (value);
#line 348 "../src/data/Game.vala"
						_tmp40_ = _tmp39_;
#line 348 "../src/data/Game.vala"
						_tmp41_ = dir;
#line 348 "../src/data/Game.vala"
						_tmp42_ = g_file_get_path (_tmp41_);
#line 348 "../src/data/Game.vala"
						_tmp43_ = _tmp42_;
#line 348 "../src/data/Game.vala"
						_tmp44_ = string_replace (_tmp40_, _tmp43_, "$game_dir/");
#line 348 "../src/data/Game.vala"
						_g_free0 (self->work_dir_path);
#line 348 "../src/data/Game.vala"
						self->work_dir_path = _tmp44_;
#line 348 "../src/data/Game.vala"
						_g_free0 (_tmp43_);
#line 348 "../src/data/Game.vala"
						_g_free0 (_tmp40_);
#line 349 "../src/data/Game.vala"
						_g_object_unref0 (dir);
#line 349 "../src/data/Game.vala"
						break;
#line 6282 "Game.c"
					}
#line 344 "../src/data/Game.vala"
					_g_object_unref0 (dir);
#line 6286 "Game.c"
				}
			}
		}
#line 333 "../src/data/Game.vala"
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 6292 "Game.c"
	} else {
#line 355 "../src/data/Game.vala"
		_g_free0 (self->work_dir_path);
#line 355 "../src/data/Game.vala"
		self->work_dir_path = NULL;
#line 6298 "Game.c"
	}
#line 357 "../src/data/Game.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 331 "../src/data/Game.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY]);
#line 6304 "Game.c"
}

gboolean
game_hub_data_game_get_overlays_enabled (GameHubDataGame* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GFile* _tmp9_;
	GFile* _tmp10_;
#line 363 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 365 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_IS_DLC (self)) {
#line 6322 "Game.c"
		GameHubDataSourcesGOGGOGGame* _tmp1_;
#line 365 "../src/data/Game.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 365 "../src/data/Game.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 6328 "Game.c"
	} else {
#line 365 "../src/data/Game.vala"
		_tmp0_ = FALSE;
#line 6332 "Game.c"
	}
#line 365 "../src/data/Game.vala"
	if (_tmp0_) {
#line 6336 "Game.c"
		GameHubDataSourcesGOGGOGGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 365 "../src/data/Game.vala"
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, GAME_HUB_DATA_SOURCES_GOG_GOG_GAME_TYPE_DLC, GameHubDataSourcesGOGGOGGameDLC)->game;
#line 365 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_game_get_overlays_enabled ((GameHubDataGame*) _tmp2_);
#line 365 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 365 "../src/data/Game.vala"
		result = _tmp4_;
#line 365 "../src/data/Game.vala"
		return result;
#line 6350 "Game.c"
	}
#line 366 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME (self)) {
#line 366 "../src/data/Game.vala"
		result = FALSE;
#line 366 "../src/data/Game.vala"
		return result;
#line 6358 "Game.c"
	}
#line 367 "../src/data/Game.vala"
	_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 367 "../src/data/Game.vala"
	_tmp6_ = _tmp5_;
#line 367 "../src/data/Game.vala"
	if (game_hub_utils_fs_overlay_root_path_safety_for (_tmp6_) == GAME_HUB_UTILS_FS_OVERLAY_ROOT_PATH_SAFETY_RESTRICTED) {
#line 367 "../src/data/Game.vala"
		result = FALSE;
#line 367 "../src/data/Game.vala"
		return result;
#line 6370 "Game.c"
	}
#line 368 "../src/data/Game.vala"
	_tmp9_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 368 "../src/data/Game.vala"
	_tmp10_ = _tmp9_;
#line 368 "../src/data/Game.vala"
	if (_tmp10_ != NULL) {
#line 6378 "Game.c"
		GFile* _tmp11_;
		GFile* _tmp12_;
#line 368 "../src/data/Game.vala"
		_tmp11_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 368 "../src/data/Game.vala"
		_tmp12_ = _tmp11_;
#line 368 "../src/data/Game.vala"
		_tmp8_ = g_file_query_exists (_tmp12_, NULL);
#line 6387 "Game.c"
	} else {
#line 368 "../src/data/Game.vala"
		_tmp8_ = FALSE;
#line 6391 "Game.c"
	}
#line 368 "../src/data/Game.vala"
	if (_tmp8_) {
#line 6395 "Game.c"
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
#line 369 "../src/data/Game.vala"
		_tmp13_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 369 "../src/data/Game.vala"
		_tmp14_ = _tmp13_;
#line 369 "../src/data/Game.vala"
		_tmp15_ = g_file_get_child (_tmp14_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 369 "../src/data/Game.vala"
		_tmp16_ = _tmp15_;
#line 369 "../src/data/Game.vala"
		_tmp17_ = g_file_get_child (_tmp16_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 369 "../src/data/Game.vala"
		_tmp18_ = _tmp17_;
#line 369 "../src/data/Game.vala"
		_tmp19_ = g_file_get_child (_tmp18_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_LIST);
#line 369 "../src/data/Game.vala"
		_tmp20_ = _tmp19_;
#line 369 "../src/data/Game.vala"
		_tmp7_ = g_file_query_exists (_tmp20_, NULL);
#line 369 "../src/data/Game.vala"
		_g_object_unref0 (_tmp20_);
#line 369 "../src/data/Game.vala"
		_g_object_unref0 (_tmp18_);
#line 369 "../src/data/Game.vala"
		_g_object_unref0 (_tmp16_);
#line 6428 "Game.c"
	} else {
#line 368 "../src/data/Game.vala"
		_tmp7_ = FALSE;
#line 6432 "Game.c"
	}
#line 368 "../src/data/Game.vala"
	result = _tmp7_;
#line 368 "../src/data/Game.vala"
	return result;
#line 6438 "Game.c"
}

GeeArrayList*
game_hub_data_game_get_achievements (GameHubDataGame* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 523 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 523 "../src/data/Game.vala"
	_tmp0_ = self->priv->_achievements;
#line 523 "../src/data/Game.vala"
	result = _tmp0_;
#line 523 "../src/data/Game.vala"
	return result;
#line 6454 "Game.c"
}

void
game_hub_data_game_set_achievements (GameHubDataGame* self,
                                     GeeArrayList* value)
{
	GeeArrayList* old_value;
#line 523 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 523 "../src/data/Game.vala"
	old_value = game_hub_data_game_get_achievements (self);
#line 523 "../src/data/Game.vala"
	if (old_value != value) {
#line 6468 "Game.c"
		GeeArrayList* _tmp0_;
#line 523 "../src/data/Game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 523 "../src/data/Game.vala"
		_g_object_unref0 (self->priv->_achievements);
#line 523 "../src/data/Game.vala"
		self->priv->_achievements = _tmp0_;
#line 523 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_properties[GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY]);
#line 6478 "Game.c"
	}
}

static void
g_cclosure_user_marshal_VOID__GAME_HUB_DATA_GAME_STATUS (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__GAME_HUB_DATA_GAME_STATUS) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GAME_HUB_DATA_GAME_STATUS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "../src/data/Game.vala"
	g_return_if_fail (n_param_values == 2);
#line 28 "../src/data/Game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "../src/data/Game.vala"
		data1 = closure->data;
#line 28 "../src/data/Game.vala"
		data2 = param_values->data[0].v_pointer;
#line 6504 "Game.c"
	} else {
#line 28 "../src/data/Game.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "../src/data/Game.vala"
		data2 = closure->data;
#line 6510 "Game.c"
	}
#line 28 "../src/data/Game.vala"
	callback = (GMarshalFunc_VOID__GAME_HUB_DATA_GAME_STATUS) (marshal_data ? marshal_data : cc->callback);
#line 28 "../src/data/Game.vala"
	callback (data1, game_hub_data_game_value_get_status (param_values + 1), data2);
#line 6516 "Game.c"
}

static inline gpointer
game_hub_data_game_overlay_get_instance_private (GameHubDataGameOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataGameOverlay_private_offset);
}

GameHubDataGameOverlay*
game_hub_data_game_overlay_construct (GType object_type,
                                      GameHubDataGame* game,
                                      const gchar* id,
                                      const gchar* name,
                                      gboolean enabled)
{
	GameHubDataGameOverlay * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 563 "../src/data/Game.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 563 "../src/data/Game.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 565 "../src/data/Game.vala"
	_tmp0_ = name;
#line 565 "../src/data/Game.vala"
	if (_tmp0_ == NULL) {
#line 6543 "Game.c"
		const gchar* _tmp1_ = NULL;
#line 565 "../src/data/Game.vala"
		if (g_strcmp0 (id, GAME_HUB_DATA_GAME_OVERLAY_BASE) == 0) {
#line 6547 "Game.c"
			const gchar* _tmp2_;
			const gchar* _tmp3_;
#line 565 "../src/data/Game.vala"
			_tmp2_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) game);
#line 565 "../src/data/Game.vala"
			_tmp3_ = _tmp2_;
#line 565 "../src/data/Game.vala"
			_tmp1_ = _tmp3_;
#line 6556 "Game.c"
		} else {
#line 565 "../src/data/Game.vala"
			_tmp1_ = id;
#line 6560 "Game.c"
		}
#line 565 "../src/data/Game.vala"
		_tmp0_ = _tmp1_;
#line 6564 "Game.c"
	}
#line 565 "../src/data/Game.vala"
	self = (GameHubDataGameOverlay*) g_object_new (object_type, "game", game, "id", id, "name", _tmp0_, NULL);
#line 566 "../src/data/Game.vala"
	if (g_strcmp0 (id, GAME_HUB_DATA_GAME_OVERLAY_BASE) == 0) {
#line 566 "../src/data/Game.vala"
		_tmp4_ = TRUE;
#line 6572 "Game.c"
	} else {
#line 566 "../src/data/Game.vala"
		_tmp4_ = enabled;
#line 6576 "Game.c"
	}
#line 566 "../src/data/Game.vala"
	game_hub_data_game_overlay_set_enabled (self, _tmp4_);
#line 563 "../src/data/Game.vala"
	return self;
#line 6582 "Game.c"
}

GameHubDataGameOverlay*
game_hub_data_game_overlay_new (GameHubDataGame* game,
                                const gchar* id,
                                const gchar* name,
                                gboolean enabled)
{
#line 563 "../src/data/Game.vala"
	return game_hub_data_game_overlay_construct (GAME_HUB_DATA_GAME_TYPE_OVERLAY, game, id, name, enabled);
#line 6593 "Game.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 6606 "Game.c"
}

static void
__lambda23_ (GameHubDataGameOverlay* self,
             GObject* obj,
             GAsyncResult* res)
{
	GameHubDataGame* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 580 "../src/data/Game.vala"
	g_return_if_fail (res != NULL);
#line 581 "../src/data/Game.vala"
	_tmp0_ = self->priv->_game;
#line 581 "../src/data/Game.vala"
	game_hub_data_game_umount_overlays_finish (_tmp0_, res);
#line 583 "../src/data/Game.vala"
	_tmp1_ = self->priv->_id;
#line 583 "../src/data/Game.vala"
	if (g_strcmp0 (_tmp1_, GAME_HUB_DATA_GAME_OVERLAY_BASE) != 0) {
#line 6627 "Game.c"
		gboolean _tmp2_ = FALSE;
		GFile* _tmp3_;
		GameHubDataGame* _tmp8_;
		GeeArrayList* _tmp9_;
		GameHubDataGame* _tmp10_;
#line 585 "../src/data/Game.vala"
		_tmp3_ = self->directory;
#line 585 "../src/data/Game.vala"
		if (_tmp3_ != NULL) {
#line 6637 "Game.c"
			GFile* _tmp4_;
#line 585 "../src/data/Game.vala"
			_tmp4_ = self->directory;
#line 585 "../src/data/Game.vala"
			_tmp2_ = g_file_query_exists (_tmp4_, NULL);
#line 6643 "Game.c"
		} else {
#line 585 "../src/data/Game.vala"
			_tmp2_ = FALSE;
#line 6647 "Game.c"
		}
#line 585 "../src/data/Game.vala"
		if (_tmp2_) {
#line 6651 "Game.c"
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
#line 587 "../src/data/Game.vala"
			_tmp5_ = self->directory;
#line 587 "../src/data/Game.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 587 "../src/data/Game.vala"
			_tmp7_ = _tmp6_;
#line 587 "../src/data/Game.vala"
			game_hub_utils_fs_utils_rm (_tmp7_, NULL, "-rf", NULL);
#line 587 "../src/data/Game.vala"
			_g_free0 (_tmp7_);
#line 6665 "Game.c"
		}
#line 589 "../src/data/Game.vala"
		_tmp8_ = self->priv->_game;
#line 589 "../src/data/Game.vala"
		_tmp9_ = _tmp8_->overlays;
#line 589 "../src/data/Game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, self);
#line 590 "../src/data/Game.vala"
		_tmp10_ = self->priv->_game;
#line 590 "../src/data/Game.vala"
		game_hub_data_game_save_overlays (_tmp10_);
#line 6677 "Game.c"
	} else {
		{
			GameHubDataGame* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GameHubDataGame* _tmp19_;
			GeeArrayList* _tmp20_;
			GameHubDataGame* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			GFile* _tmp29_;
			GameHubDataGame* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			GFile* _tmp35_;
			GFile* _tmp36_;
			GameHubDataGame* _tmp37_;
#line 596 "../src/data/Game.vala"
			_tmp11_ = self->priv->_game;
#line 596 "../src/data/Game.vala"
			_tmp12_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp11_);
#line 596 "../src/data/Game.vala"
			_tmp13_ = _tmp12_;
#line 596 "../src/data/Game.vala"
			_tmp14_ = string_to_string (GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 596 "../src/data/Game.vala"
			_tmp15_ = string_to_string (GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 596 "../src/data/Game.vala"
			_tmp16_ = string_to_string (GAME_HUB_DATA_GAME_OVERLAY_BASE);
#line 596 "../src/data/Game.vala"
			_tmp17_ = g_strconcat (_tmp14_, "/", _tmp15_, "/", _tmp16_, NULL);
#line 596 "../src/data/Game.vala"
			_tmp18_ = _tmp17_;
#line 596 "../src/data/Game.vala"
			game_hub_utils_fs_utils_mv_up (_tmp13_, _tmp18_);
#line 596 "../src/data/Game.vala"
			_g_free0 (_tmp18_);
#line 597 "../src/data/Game.vala"
			_tmp19_ = self->priv->_game;
#line 597 "../src/data/Game.vala"
			_tmp20_ = _tmp19_->overlays;
#line 597 "../src/data/Game.vala"
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp20_);
#line 598 "../src/data/Game.vala"
			_tmp21_ = self->priv->_game;
#line 598 "../src/data/Game.vala"
			_tmp22_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp21_);
#line 598 "../src/data/Game.vala"
			_tmp23_ = _tmp22_;
#line 598 "../src/data/Game.vala"
			_tmp24_ = g_file_get_child (_tmp23_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 598 "../src/data/Game.vala"
			_tmp25_ = _tmp24_;
#line 598 "../src/data/Game.vala"
			_tmp26_ = g_file_get_child (_tmp25_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 598 "../src/data/Game.vala"
			_tmp27_ = _tmp26_;
#line 598 "../src/data/Game.vala"
			_tmp28_ = g_file_get_child (_tmp27_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_LIST);
#line 598 "../src/data/Game.vala"
			_tmp29_ = _tmp28_;
#line 598 "../src/data/Game.vala"
			g_file_delete (_tmp29_, NULL, &_inner_error0_);
#line 598 "../src/data/Game.vala"
			_g_object_unref0 (_tmp29_);
#line 598 "../src/data/Game.vala"
			_g_object_unref0 (_tmp27_);
#line 598 "../src/data/Game.vala"
			_g_object_unref0 (_tmp25_);
#line 598 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6761 "Game.c"
				goto __catch0_g_error;
			}
#line 599 "../src/data/Game.vala"
			_tmp30_ = self->priv->_game;
#line 599 "../src/data/Game.vala"
			_tmp31_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp30_);
#line 599 "../src/data/Game.vala"
			_tmp32_ = _tmp31_;
#line 599 "../src/data/Game.vala"
			_tmp33_ = g_file_get_child (_tmp32_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 599 "../src/data/Game.vala"
			_tmp34_ = _tmp33_;
#line 599 "../src/data/Game.vala"
			_tmp35_ = g_file_get_child (_tmp34_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 599 "../src/data/Game.vala"
			_tmp36_ = _tmp35_;
#line 599 "../src/data/Game.vala"
			g_file_delete (_tmp36_, NULL, &_inner_error0_);
#line 599 "../src/data/Game.vala"
			_g_object_unref0 (_tmp36_);
#line 599 "../src/data/Game.vala"
			_g_object_unref0 (_tmp34_);
#line 599 "../src/data/Game.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6786 "Game.c"
				goto __catch0_g_error;
			}
#line 600 "../src/data/Game.vala"
			_tmp37_ = self->priv->_game;
#line 600 "../src/data/Game.vala"
			g_object_notify ((GObject*) _tmp37_, "overlays-enabled");
#line 6793 "Game.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp38_;
			const gchar* _tmp39_;
#line 594 "../src/data/Game.vala"
			e = _inner_error0_;
#line 594 "../src/data/Game.vala"
			_inner_error0_ = NULL;
#line 604 "../src/data/Game.vala"
			_tmp38_ = e;
#line 604 "../src/data/Game.vala"
			_tmp39_ = _tmp38_->message;
#line 604 "../src/data/Game.vala"
			g_warning ("Game.vala:604: [Game.Overlay.remove] %s", _tmp39_);
#line 594 "../src/data/Game.vala"
			_g_error_free0 (e);
#line 6813 "Game.c"
		}
		__finally0:
#line 594 "../src/data/Game.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 594 "../src/data/Game.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 594 "../src/data/Game.vala"
			g_clear_error (&_inner_error0_);
#line 594 "../src/data/Game.vala"
			return;
#line 6824 "Game.c"
		}
	}
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 580 "../src/data/Game.vala"
	__lambda23_ ((GameHubDataGameOverlay*) self, source_object, res);
#line 580 "../src/data/Game.vala"
	g_object_unref (self);
#line 6838 "Game.c"
}

void
game_hub_data_game_overlay_remove (GameHubDataGameOverlay* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GameHubDataGame* _tmp2_;
#line 576 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 578 "../src/data/Game.vala"
	_tmp0_ = game_hub_data_game_overlay_get_removable (self);
#line 578 "../src/data/Game.vala"
	_tmp1_ = _tmp0_;
#line 578 "../src/data/Game.vala"
	if (!_tmp1_) {
#line 578 "../src/data/Game.vala"
		return;
#line 6857 "Game.c"
	}
#line 580 "../src/data/Game.vala"
	_tmp2_ = self->priv->_game;
#line 580 "../src/data/Game.vala"
	game_hub_data_game_umount_overlays (_tmp2_, ___lambda23__gasync_ready_callback, g_object_ref (self));
#line 6863 "Game.c"
}

GameHubDataGame*
game_hub_data_game_overlay_get_game (GameHubDataGameOverlay* self)
{
	GameHubDataGame* result;
	GameHubDataGame* _tmp0_;
#line 540 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 540 "../src/data/Game.vala"
	_tmp0_ = self->priv->_game;
#line 540 "../src/data/Game.vala"
	result = _tmp0_;
#line 540 "../src/data/Game.vala"
	return result;
#line 6879 "Game.c"
}

static void
game_hub_data_game_overlay_set_game (GameHubDataGameOverlay* self,
                                     GameHubDataGame* value)
{
	GameHubDataGame* old_value;
#line 540 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 540 "../src/data/Game.vala"
	old_value = game_hub_data_game_overlay_get_game (self);
#line 540 "../src/data/Game.vala"
	if (old_value != value) {
#line 6893 "Game.c"
		GameHubDataGame* _tmp0_;
#line 540 "../src/data/Game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 540 "../src/data/Game.vala"
		_g_object_unref0 (self->priv->_game);
#line 540 "../src/data/Game.vala"
		self->priv->_game = _tmp0_;
#line 540 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY]);
#line 6903 "Game.c"
	}
}

const gchar*
game_hub_data_game_overlay_get_id (GameHubDataGameOverlay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 542 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 542 "../src/data/Game.vala"
	_tmp0_ = self->priv->_id;
#line 542 "../src/data/Game.vala"
	result = _tmp0_;
#line 542 "../src/data/Game.vala"
	return result;
#line 6920 "Game.c"
}

static void
game_hub_data_game_overlay_set_id (GameHubDataGameOverlay* self,
                                   const gchar* value)
{
	gchar* old_value;
#line 542 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 542 "../src/data/Game.vala"
	old_value = game_hub_data_game_overlay_get_id (self);
#line 542 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 6934 "Game.c"
		gchar* _tmp0_;
#line 542 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 542 "../src/data/Game.vala"
		_g_free0 (self->priv->_id);
#line 542 "../src/data/Game.vala"
		self->priv->_id = _tmp0_;
#line 542 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY]);
#line 6944 "Game.c"
	}
}

const gchar*
game_hub_data_game_overlay_get_name (GameHubDataGameOverlay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 543 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 543 "../src/data/Game.vala"
	_tmp0_ = self->priv->_name;
#line 543 "../src/data/Game.vala"
	result = _tmp0_;
#line 543 "../src/data/Game.vala"
	return result;
#line 6961 "Game.c"
}

static void
game_hub_data_game_overlay_set_name (GameHubDataGameOverlay* self,
                                     const gchar* value)
{
	gchar* old_value;
#line 543 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 543 "../src/data/Game.vala"
	old_value = game_hub_data_game_overlay_get_name (self);
#line 543 "../src/data/Game.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 6975 "Game.c"
		gchar* _tmp0_;
#line 543 "../src/data/Game.vala"
		_tmp0_ = g_strdup (value);
#line 543 "../src/data/Game.vala"
		_g_free0 (self->priv->_name);
#line 543 "../src/data/Game.vala"
		self->priv->_name = _tmp0_;
#line 543 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY]);
#line 6985 "Game.c"
	}
}

gboolean
game_hub_data_game_overlay_get_enabled (GameHubDataGameOverlay* self)
{
	gboolean result;
#line 544 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 544 "../src/data/Game.vala"
	result = self->priv->_enabled;
#line 544 "../src/data/Game.vala"
	return result;
#line 6999 "Game.c"
}

void
game_hub_data_game_overlay_set_enabled (GameHubDataGameOverlay* self,
                                        gboolean value)
{
	gboolean old_value;
#line 544 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 544 "../src/data/Game.vala"
	old_value = game_hub_data_game_overlay_get_enabled (self);
#line 544 "../src/data/Game.vala"
	if (old_value != value) {
#line 544 "../src/data/Game.vala"
		self->priv->_enabled = value;
#line 544 "../src/data/Game.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY]);
#line 7017 "Game.c"
	}
}

gboolean
game_hub_data_game_overlay_get_removable (GameHubDataGameOverlay* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
#line 550 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 552 "../src/data/Game.vala"
	_tmp1_ = self->priv->_id;
#line 552 "../src/data/Game.vala"
	if (g_strcmp0 (_tmp1_, GAME_HUB_DATA_GAME_OVERLAY_BASE) == 0) {
#line 7033 "Game.c"
		GameHubDataGame* _tmp2_;
		GeeArrayList* _tmp3_;
#line 552 "../src/data/Game.vala"
		_tmp2_ = self->priv->_game;
#line 552 "../src/data/Game.vala"
		_tmp3_ = _tmp2_->overlays;
#line 552 "../src/data/Game.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 7042 "Game.c"
	} else {
#line 552 "../src/data/Game.vala"
		_tmp0_ = FALSE;
#line 7046 "Game.c"
	}
#line 552 "../src/data/Game.vala"
	if (_tmp0_) {
#line 7050 "Game.c"
		{
			GeeArrayList* _overlay_list = NULL;
			GameHubDataGame* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _overlay_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _overlay_index = 0;
#line 554 "../src/data/Game.vala"
			_tmp4_ = self->priv->_game;
#line 554 "../src/data/Game.vala"
			_tmp5_ = _tmp4_->overlays;
#line 554 "../src/data/Game.vala"
			_overlay_list = _tmp5_;
#line 554 "../src/data/Game.vala"
			_tmp6_ = _overlay_list;
#line 554 "../src/data/Game.vala"
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 554 "../src/data/Game.vala"
			_tmp8_ = _tmp7_;
#line 554 "../src/data/Game.vala"
			_overlay_size = _tmp8_;
#line 554 "../src/data/Game.vala"
			_overlay_index = -1;
#line 554 "../src/data/Game.vala"
			while (TRUE) {
#line 7078 "Game.c"
				gint _tmp9_;
				gint _tmp10_;
				GameHubDataGameOverlay* overlay = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				GameHubDataGameOverlay* _tmp13_;
				const gchar* _tmp14_;
#line 554 "../src/data/Game.vala"
				_overlay_index = _overlay_index + 1;
#line 554 "../src/data/Game.vala"
				_tmp9_ = _overlay_index;
#line 554 "../src/data/Game.vala"
				_tmp10_ = _overlay_size;
#line 554 "../src/data/Game.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 554 "../src/data/Game.vala"
					break;
#line 7096 "Game.c"
				}
#line 554 "../src/data/Game.vala"
				_tmp11_ = _overlay_list;
#line 554 "../src/data/Game.vala"
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _overlay_index);
#line 554 "../src/data/Game.vala"
				overlay = (GameHubDataGameOverlay*) _tmp12_;
#line 556 "../src/data/Game.vala"
				_tmp13_ = overlay;
#line 556 "../src/data/Game.vala"
				_tmp14_ = _tmp13_->priv->_id;
#line 556 "../src/data/Game.vala"
				if (g_strcmp0 (_tmp14_, GAME_HUB_DATA_GAME_OVERLAY_BASE) != 0) {
#line 556 "../src/data/Game.vala"
					result = FALSE;
#line 556 "../src/data/Game.vala"
					_g_object_unref0 (overlay);
#line 556 "../src/data/Game.vala"
					return result;
#line 7116 "Game.c"
				}
#line 554 "../src/data/Game.vala"
				_g_object_unref0 (overlay);
#line 7120 "Game.c"
			}
		}
	}
#line 559 "../src/data/Game.vala"
	result = TRUE;
#line 559 "../src/data/Game.vala"
	return result;
#line 7128 "Game.c"
}

static GObject *
game_hub_data_game_overlay_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameHubDataGameOverlay * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GameHubDataGame* _tmp2_;
	GameHubDataGame* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GFile* _tmp21_;
#line 569 "../src/data/Game.vala"
	parent_class = G_OBJECT_CLASS (game_hub_data_game_overlay_parent_class);
#line 569 "../src/data/Game.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 569 "../src/data/Game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay);
#line 571 "../src/data/Game.vala"
	_tmp2_ = self->priv->_game;
#line 571 "../src/data/Game.vala"
	if (GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME (_tmp2_)) {
#line 571 "../src/data/Game.vala"
		_tmp1_ = TRUE;
#line 7167 "Game.c"
	} else {
		GameHubDataGame* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 571 "../src/data/Game.vala"
		_tmp3_ = self->priv->_game;
#line 571 "../src/data/Game.vala"
		_tmp4_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp3_);
#line 571 "../src/data/Game.vala"
		_tmp5_ = _tmp4_;
#line 571 "../src/data/Game.vala"
		_tmp1_ = _tmp5_ == NULL;
#line 7180 "Game.c"
	}
#line 571 "../src/data/Game.vala"
	if (_tmp1_) {
#line 571 "../src/data/Game.vala"
		_tmp0_ = TRUE;
#line 7186 "Game.c"
	} else {
		GameHubDataGame* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 571 "../src/data/Game.vala"
		_tmp6_ = self->priv->_game;
#line 571 "../src/data/Game.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp6_);
#line 571 "../src/data/Game.vala"
		_tmp8_ = _tmp7_;
#line 571 "../src/data/Game.vala"
		_tmp0_ = !g_file_query_exists (_tmp8_, NULL);
#line 7199 "Game.c"
	}
#line 571 "../src/data/Game.vala"
	if (_tmp0_) {
#line 571 "../src/data/Game.vala"
		return obj;
#line 7205 "Game.c"
	}
#line 573 "../src/data/Game.vala"
	_tmp9_ = self->priv->_game;
#line 573 "../src/data/Game.vala"
	_tmp10_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _tmp9_);
#line 573 "../src/data/Game.vala"
	_tmp11_ = _tmp10_;
#line 573 "../src/data/Game.vala"
	_tmp12_ = g_file_get_child (_tmp11_, GAME_HUB_UTILS_FS_UTILS_GAMEHUB_DIR);
#line 573 "../src/data/Game.vala"
	_tmp13_ = _tmp12_;
#line 573 "../src/data/Game.vala"
	_tmp14_ = g_file_get_child (_tmp13_, GAME_HUB_UTILS_FS_UTILS_OVERLAYS_DIR);
#line 573 "../src/data/Game.vala"
	_tmp15_ = _tmp14_;
#line 573 "../src/data/Game.vala"
	_tmp16_ = self->priv->_id;
#line 573 "../src/data/Game.vala"
	_tmp17_ = g_file_get_child (_tmp15_, _tmp16_);
#line 573 "../src/data/Game.vala"
	_tmp18_ = _tmp17_;
#line 573 "../src/data/Game.vala"
	_tmp19_ = g_file_get_path (_tmp18_);
#line 573 "../src/data/Game.vala"
	_tmp20_ = _tmp19_;
#line 573 "../src/data/Game.vala"
	_tmp21_ = game_hub_utils_fs_utils_mkdir (_tmp20_, NULL, NULL);
#line 573 "../src/data/Game.vala"
	_g_object_unref0 (self->directory);
#line 573 "../src/data/Game.vala"
	self->directory = _tmp21_;
#line 573 "../src/data/Game.vala"
	_g_free0 (_tmp20_);
#line 573 "../src/data/Game.vala"
	_g_object_unref0 (_tmp18_);
#line 573 "../src/data/Game.vala"
	_g_object_unref0 (_tmp15_);
#line 573 "../src/data/Game.vala"
	_g_object_unref0 (_tmp13_);
#line 569 "../src/data/Game.vala"
	return obj;
#line 7247 "Game.c"
}

static void
game_hub_data_game_overlay_class_init (GameHubDataGameOverlayClass * klass,
                                       gpointer klass_data)
{
#line 536 "../src/data/Game.vala"
	game_hub_data_game_overlay_parent_class = g_type_class_peek_parent (klass);
#line 536 "../src/data/Game.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataGameOverlay_private_offset);
#line 536 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_game_overlay_get_property;
#line 536 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_data_game_overlay_set_property;
#line 536 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->constructor = game_hub_data_game_overlay_constructor;
#line 536 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_game_overlay_finalize;
#line 536 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", GAME_HUB_DATA_TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 536 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 536 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 536 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 536 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAY_REMOVABLE_PROPERTY, game_hub_data_game_overlay_properties[GAME_HUB_DATA_GAME_OVERLAY_REMOVABLE_PROPERTY] = g_param_spec_boolean ("removable", "removable", "removable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 7276 "Game.c"
}

static void
game_hub_data_game_overlay_instance_init (GameHubDataGameOverlay * self,
                                          gpointer klass)
{
#line 536 "../src/data/Game.vala"
	self->priv = game_hub_data_game_overlay_get_instance_private (self);
#line 7285 "Game.c"
}

static void
game_hub_data_game_overlay_finalize (GObject * obj)
{
	GameHubDataGameOverlay * self;
#line 536 "../src/data/Game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay);
#line 540 "../src/data/Game.vala"
	_g_object_unref0 (self->priv->_game);
#line 542 "../src/data/Game.vala"
	_g_free0 (self->priv->_id);
#line 543 "../src/data/Game.vala"
	_g_free0 (self->priv->_name);
#line 546 "../src/data/Game.vala"
	_g_object_unref0 (self->directory);
#line 536 "../src/data/Game.vala"
	G_OBJECT_CLASS (game_hub_data_game_overlay_parent_class)->finalize (obj);
#line 7304 "Game.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_game_overlay_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataGameOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_game_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataGameOverlay), 0, (GInstanceInitFunc) game_hub_data_game_overlay_instance_init, NULL };
	GType game_hub_data_game_overlay_type_id;
	game_hub_data_game_overlay_type_id = g_type_register_static (G_TYPE_OBJECT, "GameHubDataGameOverlay", &g_define_type_info, 0);
	GameHubDataGameOverlay_private_offset = g_type_add_instance_private (game_hub_data_game_overlay_type_id, sizeof (GameHubDataGameOverlayPrivate));
	return game_hub_data_game_overlay_type_id;
}

GType
game_hub_data_game_overlay_get_type (void)
{
	static volatile gsize game_hub_data_game_overlay_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_game_overlay_type_id__once)) {
		GType game_hub_data_game_overlay_type_id;
		game_hub_data_game_overlay_type_id = game_hub_data_game_overlay_get_type_once ();
		g_once_init_leave (&game_hub_data_game_overlay_type_id__once, game_hub_data_game_overlay_type_id);
	}
	return game_hub_data_game_overlay_type_id__once;
}

static void
_vala_game_hub_data_game_overlay_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GameHubDataGameOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay);
#line 536 "../src/data/Game.vala"
	switch (property_id) {
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY:
#line 536 "../src/data/Game.vala"
		g_value_set_object (value, game_hub_data_game_overlay_get_game (self));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY:
#line 536 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_overlay_get_id (self));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY:
#line 536 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_overlay_get_name (self));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY:
#line 536 "../src/data/Game.vala"
		g_value_set_boolean (value, game_hub_data_game_overlay_get_enabled (self));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_REMOVABLE_PROPERTY:
#line 536 "../src/data/Game.vala"
		g_value_set_boolean (value, game_hub_data_game_overlay_get_removable (self));
#line 536 "../src/data/Game.vala"
		break;
#line 7369 "Game.c"
		default:
#line 536 "../src/data/Game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 536 "../src/data/Game.vala"
		break;
#line 7375 "Game.c"
	}
}

static void
_vala_game_hub_data_game_overlay_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GameHubDataGameOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay);
#line 536 "../src/data/Game.vala"
	switch (property_id) {
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_GAME_PROPERTY:
#line 536 "../src/data/Game.vala"
		game_hub_data_game_overlay_set_game (self, g_value_get_object (value));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_ID_PROPERTY:
#line 536 "../src/data/Game.vala"
		game_hub_data_game_overlay_set_id (self, g_value_get_string (value));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_NAME_PROPERTY:
#line 536 "../src/data/Game.vala"
		game_hub_data_game_overlay_set_name (self, g_value_get_string (value));
#line 536 "../src/data/Game.vala"
		break;
#line 536 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAY_ENABLED_PROPERTY:
#line 536 "../src/data/Game.vala"
		game_hub_data_game_overlay_set_enabled (self, g_value_get_boolean (value));
#line 536 "../src/data/Game.vala"
		break;
#line 7413 "Game.c"
		default:
#line 536 "../src/data/Game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 536 "../src/data/Game.vala"
		break;
#line 7419 "Game.c"
	}
}

static gpointer
_game_hub_utils_downloader_download_ref0 (gpointer self)
{
#line 621 "../src/data/Game.vala"
	return self ? game_hub_utils_downloader_download_ref (self) : NULL;
#line 7428 "Game.c"
}

GameHubDataGameStatus*
game_hub_data_game_status_construct (GType object_type,
                                     GameHubDataGameState state,
                                     GameHubDataGame* game,
                                     GameHubUtilsDownloaderDownload* download)
{
	GameHubDataGameStatus* self = NULL;
	GameHubDataGame* _tmp0_;
	GameHubUtilsDownloaderDownload* _tmp1_;
#line 617 "../src/data/Game.vala"
	self = (GameHubDataGameStatus*) g_type_create_instance (object_type);
#line 619 "../src/data/Game.vala"
	self->state = state;
#line 620 "../src/data/Game.vala"
	_tmp0_ = _g_object_ref0 (game);
#line 620 "../src/data/Game.vala"
	_g_object_unref0 (self->game);
#line 620 "../src/data/Game.vala"
	self->game = _tmp0_;
#line 621 "../src/data/Game.vala"
	_tmp1_ = _game_hub_utils_downloader_download_ref0 (download);
#line 621 "../src/data/Game.vala"
	_game_hub_utils_downloader_download_unref0 (self->download);
#line 621 "../src/data/Game.vala"
	self->download = _tmp1_;
#line 617 "../src/data/Game.vala"
	return self;
#line 7458 "Game.c"
}

GameHubDataGameStatus*
game_hub_data_game_status_new (GameHubDataGameState state,
                               GameHubDataGame* game,
                               GameHubUtilsDownloaderDownload* download)
{
#line 617 "../src/data/Game.vala"
	return game_hub_data_game_status_construct (GAME_HUB_DATA_GAME_TYPE_STATUS, state, game, download);
#line 7468 "Game.c"
}

gchar*
game_hub_data_game_status_get_description (GameHubDataGameStatus* self)
{
	gchar* result;
	gboolean _tmp0_ = FALSE;
	GameHubDataGame* _tmp1_;
	gchar* _tmp40_;
#line 626 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 628 "../src/data/Game.vala"
	_tmp1_ = self->game;
#line 628 "../src/data/Game.vala"
	if (_tmp1_ != NULL) {
#line 7484 "Game.c"
		GameHubDataGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 628 "../src/data/Game.vala"
		_tmp2_ = self->game;
#line 628 "../src/data/Game.vala"
		_tmp3_ = game_hub_data_runnable_get_is_running ((GameHubDataRunnable*) _tmp2_);
#line 628 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 628 "../src/data/Game.vala"
		_tmp0_ = _tmp4_;
#line 7496 "Game.c"
	} else {
#line 628 "../src/data/Game.vala"
		_tmp0_ = FALSE;
#line 7500 "Game.c"
	}
#line 628 "../src/data/Game.vala"
	if (_tmp0_) {
#line 7504 "Game.c"
		gchar* _tmp5_;
#line 628 "../src/data/Game.vala"
		_tmp5_ = g_strdup (C_ ("status", "Running"));
#line 628 "../src/data/Game.vala"
		result = _tmp5_;
#line 628 "../src/data/Game.vala"
		return result;
#line 7512 "Game.c"
	}
#line 629 "../src/data/Game.vala"
	switch (self->state) {
#line 629 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_INSTALLED:
#line 7518 "Game.c"
		{
			gchar* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GameHubDataGame* _tmp8_;
			gchar* _tmp18_;
#line 631 "../src/data/Game.vala"
			_tmp8_ = self->game;
#line 631 "../src/data/Game.vala"
			if (_tmp8_ != NULL) {
#line 7528 "Game.c"
				GameHubDataGame* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
#line 631 "../src/data/Game.vala"
				_tmp9_ = self->game;
#line 631 "../src/data/Game.vala"
				_tmp10_ = game_hub_data_game_get_version (_tmp9_);
#line 631 "../src/data/Game.vala"
				_tmp11_ = _tmp10_;
#line 631 "../src/data/Game.vala"
				_tmp7_ = _tmp11_ != NULL;
#line 7540 "Game.c"
			} else {
#line 631 "../src/data/Game.vala"
				_tmp7_ = FALSE;
#line 7544 "Game.c"
			}
#line 631 "../src/data/Game.vala"
			if (_tmp7_) {
#line 7548 "Game.c"
				GameHubDataGame* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
#line 631 "../src/data/Game.vala"
				_tmp12_ = self->game;
#line 631 "../src/data/Game.vala"
				_tmp13_ = game_hub_data_game_get_version (_tmp12_);
#line 631 "../src/data/Game.vala"
				_tmp14_ = _tmp13_;
#line 631 "../src/data/Game.vala"
				_tmp15_ = string_to_string (_tmp14_);
#line 631 "../src/data/Game.vala"
				_tmp16_ = g_strconcat (": ", _tmp15_, NULL);
#line 631 "../src/data/Game.vala"
				_g_free0 (_tmp6_);
#line 631 "../src/data/Game.vala"
				_tmp6_ = _tmp16_;
#line 7568 "Game.c"
			} else {
				gchar* _tmp17_;
#line 631 "../src/data/Game.vala"
				_tmp17_ = g_strdup ("");
#line 631 "../src/data/Game.vala"
				_g_free0 (_tmp6_);
#line 631 "../src/data/Game.vala"
				_tmp6_ = _tmp17_;
#line 7577 "Game.c"
			}
#line 631 "../src/data/Game.vala"
			_tmp18_ = g_strconcat (C_ ("status", "Installed"), _tmp6_, NULL);
#line 631 "../src/data/Game.vala"
			result = _tmp18_;
#line 631 "../src/data/Game.vala"
			_g_free0 (_tmp6_);
#line 631 "../src/data/Game.vala"
			return result;
#line 7587 "Game.c"
		}
#line 629 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_INSTALLING:
#line 7591 "Game.c"
		{
			gchar* _tmp19_;
#line 632 "../src/data/Game.vala"
			_tmp19_ = g_strdup (C_ ("status", "Installing"));
#line 632 "../src/data/Game.vala"
			result = _tmp19_;
#line 632 "../src/data/Game.vala"
			return result;
#line 7600 "Game.c"
		}
#line 629 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY:
#line 7604 "Game.c"
		{
			gchar* _tmp20_;
#line 633 "../src/data/Game.vala"
			_tmp20_ = g_strdup (C_ ("status", "Verifying installer integrity"));
#line 633 "../src/data/Game.vala"
			result = _tmp20_;
#line 633 "../src/data/Game.vala"
			return result;
#line 7613 "Game.c"
		}
#line 629 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_DOWNLOADING:
#line 7617 "Game.c"
		{
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			GameHubUtilsDownloaderDownload* _tmp24_;
#line 634 "../src/data/Game.vala"
			_tmp24_ = self->download;
#line 634 "../src/data/Game.vala"
			if (_tmp24_ != NULL) {
#line 7627 "Game.c"
				GameHubUtilsDownloaderDownload* _tmp25_;
				GameHubUtilsDownloaderDownloadStatus* _tmp26_;
				GameHubUtilsDownloaderDownloadStatus* _tmp27_;
#line 634 "../src/data/Game.vala"
				_tmp25_ = self->download;
#line 634 "../src/data/Game.vala"
				_tmp26_ = game_hub_utils_downloader_download_get_status (_tmp25_);
#line 634 "../src/data/Game.vala"
				_tmp27_ = _tmp26_;
#line 634 "../src/data/Game.vala"
				_tmp23_ = _tmp27_ != NULL;
#line 7639 "Game.c"
			} else {
#line 634 "../src/data/Game.vala"
				_tmp23_ = FALSE;
#line 7643 "Game.c"
			}
#line 634 "../src/data/Game.vala"
			if (_tmp23_) {
#line 7647 "Game.c"
				GameHubUtilsDownloaderDownload* _tmp28_;
				GameHubUtilsDownloaderDownloadStatus* _tmp29_;
				GameHubUtilsDownloaderDownloadStatus* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
#line 634 "../src/data/Game.vala"
				_tmp28_ = self->download;
#line 634 "../src/data/Game.vala"
				_tmp29_ = game_hub_utils_downloader_download_get_status (_tmp28_);
#line 634 "../src/data/Game.vala"
				_tmp30_ = _tmp29_;
#line 634 "../src/data/Game.vala"
				_tmp31_ = game_hub_utils_downloader_download_status_get_description (_tmp30_);
#line 634 "../src/data/Game.vala"
				_tmp32_ = _tmp31_;
#line 634 "../src/data/Game.vala"
				_tmp33_ = _tmp32_;
#line 634 "../src/data/Game.vala"
				_tmp22_ = _tmp33_ != NULL;
#line 634 "../src/data/Game.vala"
				_g_free0 (_tmp33_);
#line 7670 "Game.c"
			} else {
#line 634 "../src/data/Game.vala"
				_tmp22_ = FALSE;
#line 7674 "Game.c"
			}
#line 634 "../src/data/Game.vala"
			if (_tmp22_) {
#line 7678 "Game.c"
				GameHubUtilsDownloaderDownload* _tmp34_;
				GameHubUtilsDownloaderDownloadStatus* _tmp35_;
				GameHubUtilsDownloaderDownloadStatus* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
#line 634 "../src/data/Game.vala"
				_tmp34_ = self->download;
#line 634 "../src/data/Game.vala"
				_tmp35_ = game_hub_utils_downloader_download_get_status (_tmp34_);
#line 634 "../src/data/Game.vala"
				_tmp36_ = _tmp35_;
#line 634 "../src/data/Game.vala"
				_tmp37_ = game_hub_utils_downloader_download_status_get_description (_tmp36_);
#line 634 "../src/data/Game.vala"
				_tmp38_ = _tmp37_;
#line 634 "../src/data/Game.vala"
				_g_free0 (_tmp21_);
#line 634 "../src/data/Game.vala"
				_tmp21_ = _tmp38_;
#line 7698 "Game.c"
			} else {
				gchar* _tmp39_;
#line 634 "../src/data/Game.vala"
				_tmp39_ = g_strdup (C_ ("status", "Download started"));
#line 634 "../src/data/Game.vala"
				_g_free0 (_tmp21_);
#line 634 "../src/data/Game.vala"
				_tmp21_ = _tmp39_;
#line 7707 "Game.c"
			}
#line 634 "../src/data/Game.vala"
			result = _tmp21_;
#line 634 "../src/data/Game.vala"
			return result;
#line 7713 "Game.c"
		}
		default:
#line 629 "../src/data/Game.vala"
		break;
#line 7718 "Game.c"
	}
#line 636 "../src/data/Game.vala"
	_tmp40_ = g_strdup (C_ ("status", "Not installed"));
#line 636 "../src/data/Game.vala"
	result = _tmp40_;
#line 636 "../src/data/Game.vala"
	return result;
#line 7726 "Game.c"
}

gchar*
game_hub_data_game_status_get_header (GameHubDataGameStatus* self)
{
	gchar* result;
	gchar* _tmp3_;
#line 642 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 644 "../src/data/Game.vala"
	switch (self->state) {
#line 644 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_INSTALLED:
#line 7740 "Game.c"
		{
			gchar* _tmp0_;
#line 646 "../src/data/Game.vala"
			_tmp0_ = g_strdup (C_ ("status_header", "Installed"));
#line 646 "../src/data/Game.vala"
			result = _tmp0_;
#line 646 "../src/data/Game.vala"
			return result;
#line 7749 "Game.c"
		}
#line 644 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_INSTALLING:
#line 7753 "Game.c"
		{
			gchar* _tmp1_;
#line 647 "../src/data/Game.vala"
			_tmp1_ = g_strdup (C_ ("status_header", "Installing"));
#line 647 "../src/data/Game.vala"
			result = _tmp1_;
#line 647 "../src/data/Game.vala"
			return result;
#line 7762 "Game.c"
		}
#line 644 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY:
#line 644 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATE_DOWNLOADING:
#line 7768 "Game.c"
		{
			gchar* _tmp2_;
#line 649 "../src/data/Game.vala"
			_tmp2_ = g_strdup (C_ ("status_header", "Downloading"));
#line 649 "../src/data/Game.vala"
			result = _tmp2_;
#line 649 "../src/data/Game.vala"
			return result;
#line 7777 "Game.c"
		}
		default:
#line 644 "../src/data/Game.vala"
		break;
#line 7782 "Game.c"
	}
#line 651 "../src/data/Game.vala"
	_tmp3_ = g_strdup (C_ ("status_header", "Not installed"));
#line 651 "../src/data/Game.vala"
	result = _tmp3_;
#line 651 "../src/data/Game.vala"
	return result;
#line 7790 "Game.c"
}

static void
game_hub_data_game_value_status_init (GValue* value)
{
#line 611 "../src/data/Game.vala"
	value->data[0].v_pointer = NULL;
#line 7798 "Game.c"
}

static void
game_hub_data_game_value_status_free_value (GValue* value)
{
#line 611 "../src/data/Game.vala"
	if (value->data[0].v_pointer) {
#line 611 "../src/data/Game.vala"
		game_hub_data_game_status_unref (value->data[0].v_pointer);
#line 7808 "Game.c"
	}
}

static void
game_hub_data_game_value_status_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
#line 611 "../src/data/Game.vala"
	if (src_value->data[0].v_pointer) {
#line 611 "../src/data/Game.vala"
		dest_value->data[0].v_pointer = game_hub_data_game_status_ref (src_value->data[0].v_pointer);
#line 7820 "Game.c"
	} else {
#line 611 "../src/data/Game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7824 "Game.c"
	}
}

static gpointer
game_hub_data_game_value_status_peek_pointer (const GValue* value)
{
#line 611 "../src/data/Game.vala"
	return value->data[0].v_pointer;
#line 7833 "Game.c"
}

static gchar*
game_hub_data_game_value_status_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
#line 611 "../src/data/Game.vala"
	if (collect_values[0].v_pointer) {
#line 7844 "Game.c"
		GameHubDataGameStatus * object;
		object = collect_values[0].v_pointer;
#line 611 "../src/data/Game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 611 "../src/data/Game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7851 "Game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 611 "../src/data/Game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7855 "Game.c"
		}
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = game_hub_data_game_status_ref (object);
#line 7859 "Game.c"
	} else {
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 7863 "Game.c"
	}
#line 611 "../src/data/Game.vala"
	return NULL;
#line 7867 "Game.c"
}

static gchar*
game_hub_data_game_value_status_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GameHubDataGameStatus ** object_p;
	object_p = collect_values[0].v_pointer;
#line 611 "../src/data/Game.vala"
	if (!object_p) {
#line 611 "../src/data/Game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7882 "Game.c"
	}
#line 611 "../src/data/Game.vala"
	if (!value->data[0].v_pointer) {
#line 611 "../src/data/Game.vala"
		*object_p = NULL;
#line 7888 "Game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 611 "../src/data/Game.vala"
		*object_p = value->data[0].v_pointer;
#line 7892 "Game.c"
	} else {
#line 611 "../src/data/Game.vala"
		*object_p = game_hub_data_game_status_ref (value->data[0].v_pointer);
#line 7896 "Game.c"
	}
#line 611 "../src/data/Game.vala"
	return NULL;
#line 7900 "Game.c"
}

GParamSpec*
game_hub_data_game_param_spec_status (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GameHubDataGameParamSpecStatus* spec;
#line 611 "../src/data/Game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_DATA_GAME_TYPE_STATUS), NULL);
#line 611 "../src/data/Game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 611 "../src/data/Game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 611 "../src/data/Game.vala"
	return G_PARAM_SPEC (spec);
#line 7919 "Game.c"
}

gpointer
game_hub_data_game_value_get_status (const GValue* value)
{
#line 611 "../src/data/Game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_STATUS), NULL);
#line 611 "../src/data/Game.vala"
	return value->data[0].v_pointer;
#line 7929 "Game.c"
}

void
game_hub_data_game_value_set_status (GValue* value,
                                     gpointer v_object)
{
	GameHubDataGameStatus * old;
#line 611 "../src/data/Game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_STATUS));
#line 611 "../src/data/Game.vala"
	old = value->data[0].v_pointer;
#line 611 "../src/data/Game.vala"
	if (v_object) {
#line 611 "../src/data/Game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_DATA_GAME_TYPE_STATUS));
#line 611 "../src/data/Game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = v_object;
#line 611 "../src/data/Game.vala"
		game_hub_data_game_status_ref (value->data[0].v_pointer);
#line 7951 "Game.c"
	} else {
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 7955 "Game.c"
	}
#line 611 "../src/data/Game.vala"
	if (old) {
#line 611 "../src/data/Game.vala"
		game_hub_data_game_status_unref (old);
#line 7961 "Game.c"
	}
}

void
game_hub_data_game_value_take_status (GValue* value,
                                      gpointer v_object)
{
	GameHubDataGameStatus * old;
#line 611 "../src/data/Game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_STATUS));
#line 611 "../src/data/Game.vala"
	old = value->data[0].v_pointer;
#line 611 "../src/data/Game.vala"
	if (v_object) {
#line 611 "../src/data/Game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_DATA_GAME_TYPE_STATUS));
#line 611 "../src/data/Game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = v_object;
#line 7982 "Game.c"
	} else {
#line 611 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 7986 "Game.c"
	}
#line 611 "../src/data/Game.vala"
	if (old) {
#line 611 "../src/data/Game.vala"
		game_hub_data_game_status_unref (old);
#line 7992 "Game.c"
	}
}

static void
game_hub_data_game_status_class_init (GameHubDataGameStatusClass * klass,
                                      gpointer klass_data)
{
#line 611 "../src/data/Game.vala"
	game_hub_data_game_status_parent_class = g_type_class_peek_parent (klass);
#line 611 "../src/data/Game.vala"
	((GameHubDataGameStatusClass *) klass)->finalize = game_hub_data_game_status_finalize;
#line 8004 "Game.c"
}

static void
game_hub_data_game_status_instance_init (GameHubDataGameStatus * self,
                                         gpointer klass)
{
#line 611 "../src/data/Game.vala"
	self->ref_count = 1;
#line 8013 "Game.c"
}

static void
game_hub_data_game_status_finalize (GameHubDataGameStatus * obj)
{
	GameHubDataGameStatus * self;
#line 611 "../src/data/Game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatus);
#line 611 "../src/data/Game.vala"
	g_signal_handlers_destroy (self);
#line 614 "../src/data/Game.vala"
	_g_object_unref0 (self->game);
#line 615 "../src/data/Game.vala"
	_game_hub_utils_downloader_download_unref0 (self->download);
#line 8028 "Game.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_game_status_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_data_game_value_status_init, game_hub_data_game_value_status_free_value, game_hub_data_game_value_status_copy_value, game_hub_data_game_value_status_peek_pointer, "p", game_hub_data_game_value_status_collect_value, "p", game_hub_data_game_value_status_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataGameStatusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_game_status_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataGameStatus), 0, (GInstanceInitFunc) game_hub_data_game_status_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_data_game_status_type_id;
	game_hub_data_game_status_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubDataGameStatus", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return game_hub_data_game_status_type_id;
}

GType
game_hub_data_game_status_get_type (void)
{
	static volatile gsize game_hub_data_game_status_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_game_status_type_id__once)) {
		GType game_hub_data_game_status_type_id;
		game_hub_data_game_status_type_id = game_hub_data_game_status_get_type_once ();
		g_once_init_leave (&game_hub_data_game_status_type_id__once, game_hub_data_game_status_type_id);
	}
	return game_hub_data_game_status_type_id__once;
}

gpointer
game_hub_data_game_status_ref (gpointer instance)
{
	GameHubDataGameStatus * self;
	self = instance;
#line 611 "../src/data/Game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 611 "../src/data/Game.vala"
	return instance;
#line 8063 "Game.c"
}

void
game_hub_data_game_status_unref (gpointer instance)
{
	GameHubDataGameStatus * self;
	self = instance;
#line 611 "../src/data/Game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 611 "../src/data/Game.vala"
		GAME_HUB_DATA_GAME_STATUS_GET_CLASS (self)->finalize (self);
#line 611 "../src/data/Game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8077 "Game.c"
	}
}

static inline gpointer
game_hub_data_game_achievement_get_instance_private (GameHubDataGameAchievement* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataGameAchievement_private_offset);
}

GameHubDataGameAchievement*
game_hub_data_game_achievement_construct (GType object_type)
{
	GameHubDataGameAchievement* self = NULL;
#line 661 "../src/data/Game.vala"
	self = (GameHubDataGameAchievement*) g_type_create_instance (object_type);
#line 661 "../src/data/Game.vala"
	return self;
#line 8095 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_id (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 663 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 663 "../src/data/Game.vala"
	_tmp0_ = self->priv->_id;
#line 663 "../src/data/Game.vala"
	result = _tmp0_;
#line 663 "../src/data/Game.vala"
	return result;
#line 8111 "Game.c"
}

void
game_hub_data_game_achievement_set_id (GameHubDataGameAchievement* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
#line 663 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 663 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 663 "../src/data/Game.vala"
	_g_free0 (self->priv->_id);
#line 663 "../src/data/Game.vala"
	self->priv->_id = _tmp0_;
#line 8127 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_name (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 664 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 664 "../src/data/Game.vala"
	_tmp0_ = self->priv->_name;
#line 664 "../src/data/Game.vala"
	result = _tmp0_;
#line 664 "../src/data/Game.vala"
	return result;
#line 8143 "Game.c"
}

void
game_hub_data_game_achievement_set_name (GameHubDataGameAchievement* self,
                                         const gchar* value)
{
	gchar* _tmp0_;
#line 664 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 664 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 664 "../src/data/Game.vala"
	_g_free0 (self->priv->_name);
#line 664 "../src/data/Game.vala"
	self->priv->_name = _tmp0_;
#line 8159 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_description (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 665 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 665 "../src/data/Game.vala"
	_tmp0_ = self->priv->_description;
#line 665 "../src/data/Game.vala"
	result = _tmp0_;
#line 665 "../src/data/Game.vala"
	return result;
#line 8175 "Game.c"
}

void
game_hub_data_game_achievement_set_description (GameHubDataGameAchievement* self,
                                                const gchar* value)
{
	gchar* _tmp0_;
#line 665 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 665 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 665 "../src/data/Game.vala"
	_g_free0 (self->priv->_description);
#line 665 "../src/data/Game.vala"
	self->priv->_description = _tmp0_;
#line 8191 "Game.c"
}

gboolean
game_hub_data_game_achievement_get_unlocked (GameHubDataGameAchievement* self)
{
	gboolean result;
#line 666 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 666 "../src/data/Game.vala"
	result = self->priv->_unlocked;
#line 666 "../src/data/Game.vala"
	return result;
#line 8204 "Game.c"
}

void
game_hub_data_game_achievement_set_unlocked (GameHubDataGameAchievement* self,
                                             gboolean value)
{
#line 666 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 666 "../src/data/Game.vala"
	self->priv->_unlocked = value;
#line 8215 "Game.c"
}

GDateTime*
game_hub_data_game_achievement_get_unlock_date (GameHubDataGameAchievement* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
#line 667 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 667 "../src/data/Game.vala"
	_tmp0_ = self->priv->_unlock_date;
#line 667 "../src/data/Game.vala"
	result = _tmp0_;
#line 667 "../src/data/Game.vala"
	return result;
#line 8231 "Game.c"
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
#line 667 "../src/data/Game.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 8239 "Game.c"
}

void
game_hub_data_game_achievement_set_unlock_date (GameHubDataGameAchievement* self,
                                                GDateTime* value)
{
	GDateTime* _tmp0_;
#line 667 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 667 "../src/data/Game.vala"
	_tmp0_ = _g_date_time_ref0 (value);
#line 667 "../src/data/Game.vala"
	_g_date_time_unref0 (self->priv->_unlock_date);
#line 667 "../src/data/Game.vala"
	self->priv->_unlock_date = _tmp0_;
#line 8255 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_unlock_time (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 668 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 668 "../src/data/Game.vala"
	_tmp0_ = self->priv->_unlock_time;
#line 668 "../src/data/Game.vala"
	result = _tmp0_;
#line 668 "../src/data/Game.vala"
	return result;
#line 8271 "Game.c"
}

void
game_hub_data_game_achievement_set_unlock_time (GameHubDataGameAchievement* self,
                                                const gchar* value)
{
	gchar* _tmp0_;
#line 668 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 668 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 668 "../src/data/Game.vala"
	_g_free0 (self->priv->_unlock_time);
#line 668 "../src/data/Game.vala"
	self->priv->_unlock_time = _tmp0_;
#line 8287 "Game.c"
}

gfloat
game_hub_data_game_achievement_get_global_percentage (GameHubDataGameAchievement* self)
{
	gfloat result;
#line 669 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 669 "../src/data/Game.vala"
	result = self->priv->_global_percentage;
#line 669 "../src/data/Game.vala"
	return result;
#line 8300 "Game.c"
}

void
game_hub_data_game_achievement_set_global_percentage (GameHubDataGameAchievement* self,
                                                      gfloat value)
{
#line 669 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 669 "../src/data/Game.vala"
	self->priv->_global_percentage = value;
#line 8311 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_image_locked (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 670 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 670 "../src/data/Game.vala"
	_tmp0_ = self->priv->_image_locked;
#line 670 "../src/data/Game.vala"
	result = _tmp0_;
#line 670 "../src/data/Game.vala"
	return result;
#line 8327 "Game.c"
}

void
game_hub_data_game_achievement_set_image_locked (GameHubDataGameAchievement* self,
                                                 const gchar* value)
{
	gchar* _tmp0_;
#line 670 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 670 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 670 "../src/data/Game.vala"
	_g_free0 (self->priv->_image_locked);
#line 670 "../src/data/Game.vala"
	self->priv->_image_locked = _tmp0_;
#line 8343 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_image_unlocked (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 671 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 671 "../src/data/Game.vala"
	_tmp0_ = self->priv->_image_unlocked;
#line 671 "../src/data/Game.vala"
	result = _tmp0_;
#line 671 "../src/data/Game.vala"
	return result;
#line 8359 "Game.c"
}

void
game_hub_data_game_achievement_set_image_unlocked (GameHubDataGameAchievement* self,
                                                   const gchar* value)
{
	gchar* _tmp0_;
#line 671 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 671 "../src/data/Game.vala"
	_tmp0_ = g_strdup (value);
#line 671 "../src/data/Game.vala"
	_g_free0 (self->priv->_image_unlocked);
#line 671 "../src/data/Game.vala"
	self->priv->_image_unlocked = _tmp0_;
#line 8375 "Game.c"
}

const gchar*
game_hub_data_game_achievement_get_image (GameHubDataGameAchievement* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
#line 672 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "../src/data/Game.vala"
	_tmp1_ = self->priv->_unlocked;
#line 672 "../src/data/Game.vala"
	if (_tmp1_) {
#line 8390 "Game.c"
		const gchar* _tmp2_;
#line 672 "../src/data/Game.vala"
		_tmp2_ = self->priv->_image_unlocked;
#line 672 "../src/data/Game.vala"
		_tmp0_ = _tmp2_;
#line 8396 "Game.c"
	} else {
		const gchar* _tmp3_;
#line 672 "../src/data/Game.vala"
		_tmp3_ = self->priv->_image_locked;
#line 672 "../src/data/Game.vala"
		_tmp0_ = _tmp3_;
#line 8403 "Game.c"
	}
#line 672 "../src/data/Game.vala"
	result = _tmp0_;
#line 672 "../src/data/Game.vala"
	return result;
#line 8409 "Game.c"
}

static void
game_hub_data_game_value_achievement_init (GValue* value)
{
#line 661 "../src/data/Game.vala"
	value->data[0].v_pointer = NULL;
#line 8417 "Game.c"
}

static void
game_hub_data_game_value_achievement_free_value (GValue* value)
{
#line 661 "../src/data/Game.vala"
	if (value->data[0].v_pointer) {
#line 661 "../src/data/Game.vala"
		game_hub_data_game_achievement_unref (value->data[0].v_pointer);
#line 8427 "Game.c"
	}
}

static void
game_hub_data_game_value_achievement_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
#line 661 "../src/data/Game.vala"
	if (src_value->data[0].v_pointer) {
#line 661 "../src/data/Game.vala"
		dest_value->data[0].v_pointer = game_hub_data_game_achievement_ref (src_value->data[0].v_pointer);
#line 8439 "Game.c"
	} else {
#line 661 "../src/data/Game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8443 "Game.c"
	}
}

static gpointer
game_hub_data_game_value_achievement_peek_pointer (const GValue* value)
{
#line 661 "../src/data/Game.vala"
	return value->data[0].v_pointer;
#line 8452 "Game.c"
}

static gchar*
game_hub_data_game_value_achievement_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
#line 661 "../src/data/Game.vala"
	if (collect_values[0].v_pointer) {
#line 8463 "Game.c"
		GameHubDataGameAchievement * object;
		object = collect_values[0].v_pointer;
#line 661 "../src/data/Game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 661 "../src/data/Game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8470 "Game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 661 "../src/data/Game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8474 "Game.c"
		}
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = game_hub_data_game_achievement_ref (object);
#line 8478 "Game.c"
	} else {
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 8482 "Game.c"
	}
#line 661 "../src/data/Game.vala"
	return NULL;
#line 8486 "Game.c"
}

static gchar*
game_hub_data_game_value_achievement_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	GameHubDataGameAchievement ** object_p;
	object_p = collect_values[0].v_pointer;
#line 661 "../src/data/Game.vala"
	if (!object_p) {
#line 661 "../src/data/Game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8501 "Game.c"
	}
#line 661 "../src/data/Game.vala"
	if (!value->data[0].v_pointer) {
#line 661 "../src/data/Game.vala"
		*object_p = NULL;
#line 8507 "Game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 661 "../src/data/Game.vala"
		*object_p = value->data[0].v_pointer;
#line 8511 "Game.c"
	} else {
#line 661 "../src/data/Game.vala"
		*object_p = game_hub_data_game_achievement_ref (value->data[0].v_pointer);
#line 8515 "Game.c"
	}
#line 661 "../src/data/Game.vala"
	return NULL;
#line 8519 "Game.c"
}

GParamSpec*
game_hub_data_game_param_spec_achievement (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	GameHubDataGameParamSpecAchievement* spec;
#line 661 "../src/data/Game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT), NULL);
#line 661 "../src/data/Game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 661 "../src/data/Game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 661 "../src/data/Game.vala"
	return G_PARAM_SPEC (spec);
#line 8538 "Game.c"
}

gpointer
game_hub_data_game_value_get_achievement (const GValue* value)
{
#line 661 "../src/data/Game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT), NULL);
#line 661 "../src/data/Game.vala"
	return value->data[0].v_pointer;
#line 8548 "Game.c"
}

void
game_hub_data_game_value_set_achievement (GValue* value,
                                          gpointer v_object)
{
	GameHubDataGameAchievement * old;
#line 661 "../src/data/Game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT));
#line 661 "../src/data/Game.vala"
	old = value->data[0].v_pointer;
#line 661 "../src/data/Game.vala"
	if (v_object) {
#line 661 "../src/data/Game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT));
#line 661 "../src/data/Game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = v_object;
#line 661 "../src/data/Game.vala"
		game_hub_data_game_achievement_ref (value->data[0].v_pointer);
#line 8570 "Game.c"
	} else {
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 8574 "Game.c"
	}
#line 661 "../src/data/Game.vala"
	if (old) {
#line 661 "../src/data/Game.vala"
		game_hub_data_game_achievement_unref (old);
#line 8580 "Game.c"
	}
}

void
game_hub_data_game_value_take_achievement (GValue* value,
                                           gpointer v_object)
{
	GameHubDataGameAchievement * old;
#line 661 "../src/data/Game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT));
#line 661 "../src/data/Game.vala"
	old = value->data[0].v_pointer;
#line 661 "../src/data/Game.vala"
	if (v_object) {
#line 661 "../src/data/Game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT));
#line 661 "../src/data/Game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = v_object;
#line 8601 "Game.c"
	} else {
#line 661 "../src/data/Game.vala"
		value->data[0].v_pointer = NULL;
#line 8605 "Game.c"
	}
#line 661 "../src/data/Game.vala"
	if (old) {
#line 661 "../src/data/Game.vala"
		game_hub_data_game_achievement_unref (old);
#line 8611 "Game.c"
	}
}

static void
game_hub_data_game_achievement_class_init (GameHubDataGameAchievementClass * klass,
                                           gpointer klass_data)
{
#line 661 "../src/data/Game.vala"
	game_hub_data_game_achievement_parent_class = g_type_class_peek_parent (klass);
#line 661 "../src/data/Game.vala"
	((GameHubDataGameAchievementClass *) klass)->finalize = game_hub_data_game_achievement_finalize;
#line 661 "../src/data/Game.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataGameAchievement_private_offset);
#line 8625 "Game.c"
}

static void
game_hub_data_game_achievement_instance_init (GameHubDataGameAchievement * self,
                                              gpointer klass)
{
#line 661 "../src/data/Game.vala"
	self->priv = game_hub_data_game_achievement_get_instance_private (self);
#line 666 "../src/data/Game.vala"
	self->priv->_unlocked = FALSE;
#line 669 "../src/data/Game.vala"
	self->priv->_global_percentage = (gfloat) 0;
#line 661 "../src/data/Game.vala"
	self->ref_count = 1;
#line 8640 "Game.c"
}

static void
game_hub_data_game_achievement_finalize (GameHubDataGameAchievement * obj)
{
	GameHubDataGameAchievement * self;
#line 661 "../src/data/Game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievement);
#line 661 "../src/data/Game.vala"
	g_signal_handlers_destroy (self);
#line 663 "../src/data/Game.vala"
	_g_free0 (self->priv->_id);
#line 664 "../src/data/Game.vala"
	_g_free0 (self->priv->_name);
#line 665 "../src/data/Game.vala"
	_g_free0 (self->priv->_description);
#line 667 "../src/data/Game.vala"
	_g_date_time_unref0 (self->priv->_unlock_date);
#line 668 "../src/data/Game.vala"
	_g_free0 (self->priv->_unlock_time);
#line 670 "../src/data/Game.vala"
	_g_free0 (self->priv->_image_locked);
#line 671 "../src/data/Game.vala"
	_g_free0 (self->priv->_image_unlocked);
#line 8665 "Game.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_game_achievement_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_data_game_value_achievement_init, game_hub_data_game_value_achievement_free_value, game_hub_data_game_value_achievement_copy_value, game_hub_data_game_value_achievement_peek_pointer, "p", game_hub_data_game_value_achievement_collect_value, "p", game_hub_data_game_value_achievement_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataGameAchievementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_game_achievement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataGameAchievement), 0, (GInstanceInitFunc) game_hub_data_game_achievement_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_data_game_achievement_type_id;
	game_hub_data_game_achievement_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubDataGameAchievement", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	GameHubDataGameAchievement_private_offset = g_type_add_instance_private (game_hub_data_game_achievement_type_id, sizeof (GameHubDataGameAchievementPrivate));
	return game_hub_data_game_achievement_type_id;
}

GType
game_hub_data_game_achievement_get_type (void)
{
	static volatile gsize game_hub_data_game_achievement_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_game_achievement_type_id__once)) {
		GType game_hub_data_game_achievement_type_id;
		game_hub_data_game_achievement_type_id = game_hub_data_game_achievement_get_type_once ();
		g_once_init_leave (&game_hub_data_game_achievement_type_id__once, game_hub_data_game_achievement_type_id);
	}
	return game_hub_data_game_achievement_type_id__once;
}

gpointer
game_hub_data_game_achievement_ref (gpointer instance)
{
	GameHubDataGameAchievement * self;
	self = instance;
#line 661 "../src/data/Game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 661 "../src/data/Game.vala"
	return instance;
#line 8701 "Game.c"
}

void
game_hub_data_game_achievement_unref (gpointer instance)
{
	GameHubDataGameAchievement * self;
	self = instance;
#line 661 "../src/data/Game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 661 "../src/data/Game.vala"
		GAME_HUB_DATA_GAME_ACHIEVEMENT_GET_CLASS (self)->finalize (self);
#line 661 "../src/data/Game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8715 "Game.c"
	}
}

static void
game_hub_data_game_class_init (GameHubDataGameClass * klass,
                               gpointer klass_data)
{
#line 28 "../src/data/Game.vala"
	game_hub_data_game_parent_class = g_type_class_peek_parent (klass);
#line 28 "../src/data/Game.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataGame_private_offset);
#line 28 "../src/data/Game.vala"
	((GameHubDataRunnableClass *) klass)->save = (void (*) (GameHubDataRunnable*)) game_hub_data_game_real_save;
#line 28 "../src/data/Game.vala"
	((GameHubDataRunnableClass *) klass)->run = (void (*) (GameHubDataRunnable*, GAsyncReadyCallback, gpointer)) game_hub_data_game_real_run;
#line 28 "../src/data/Game.vala"
	((GameHubDataRunnableClass *) klass)->run_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_game_run_finish;
#line 28 "../src/data/Game.vala"
	((GameHubDataGameClass *) klass)->update_game_info = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_game_real_update_game_info;
#line 28 "../src/data/Game.vala"
	((GameHubDataGameClass *) klass)->update_game_info_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_game_real_update_game_info_finish;
#line 28 "../src/data/Game.vala"
	((GameHubDataGameClass *) klass)->load_achievements = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_game_real_load_achievements;
#line 28 "../src/data/Game.vala"
	((GameHubDataGameClass *) klass)->load_achievements_finish = (GeeArrayList* (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_game_real_load_achievements_finish;
#line 28 "../src/data/Game.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->get_executable = (GFile* (*) (GameHubDataRunnable*)) game_hub_data_game_real_get_executable;
#line 28 "../src/data/Game.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->set_executable = (void (*) (GameHubDataRunnable*, GFile*)) game_hub_data_game_real_set_executable;
#line 28 "../src/data/Game.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->get_work_dir = (GFile* (*) (GameHubDataRunnable*)) game_hub_data_game_real_get_work_dir;
#line 28 "../src/data/Game.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->set_work_dir = (void (*) (GameHubDataRunnable*, GFile*)) game_hub_data_game_real_set_work_dir;
#line 28 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_game_get_property;
#line 28 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_data_game_set_property;
#line 28 "../src/data/Game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_game_finalize;
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_SOURCE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_SOURCE_PROPERTY] = game_hub_data_param_spec_game_source ("source", "source", "source", GAME_HUB_DATA_TYPE_GAME_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_ICON_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_IMAGE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IMAGE_PROPERTY] = g_param_spec_string ("image", "image", "image", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY] = g_param_spec_string ("image-vertical", "image-vertical", "image-vertical", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_INFO_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INFO_PROPERTY] = g_param_spec_string ("info", "info", "info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY] = g_param_spec_string ("info-detailed", "info-detailed", "info-detailed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_FULL_ID_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_FULL_ID_PROPERTY] = g_param_spec_string ("full-id", "full-id", "full-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_VERSION_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_TAGS_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_TAGS_PROPERTY] = g_param_spec_object ("tags", "tags", "tags", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY] = g_param_spec_object ("installers-dir", "installers-dir", "installers-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY] = g_param_spec_boolean ("is-installable", "is-installable", "is-installable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY] = g_param_spec_string ("store-page", "store-page", "store-page", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY] = g_param_spec_int64 ("last-launch", "last-launch", "last-launch", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_STATUS_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_STATUS_PROPERTY] = game_hub_data_game_param_spec_status ("status", "status", "status", GAME_HUB_DATA_GAME_TYPE_STATUS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY] = g_param_spec_int64 ("playtime-source", "playtime-source", "playtime-source", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY] = g_param_spec_int64 ("playtime-tracked", "playtime-tracked", "playtime-tracked", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_PLAYTIME_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_PLAYTIME_PROPERTY] = g_param_spec_int64 ("playtime", "playtime", "playtime", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY] = g_param_spec_object ("executable", "executable", "executable", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY] = g_param_spec_object ("work-dir", "work-dir", "work-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_OVERLAYS_ENABLED_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_OVERLAYS_ENABLED_PROPERTY] = g_param_spec_boolean ("overlays-enabled", "overlays-enabled", "overlays-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 28 "../src/data/Game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY, game_hub_data_game_properties[GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY] = g_param_spec_object ("achievements", "achievements", "achievements", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../src/data/Game.vala"
	game_hub_data_game_signals[GAME_HUB_DATA_GAME_STATUS_CHANGE_SIGNAL] = g_signal_new ("status-change", GAME_HUB_DATA_TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__GAME_HUB_DATA_GAME_STATUS, G_TYPE_NONE, 1, GAME_HUB_DATA_GAME_TYPE_STATUS);
#line 28 "../src/data/Game.vala"
	game_hub_data_game_signals[GAME_HUB_DATA_GAME_TAGS_UPDATE_SIGNAL] = g_signal_new ("tags-update", GAME_HUB_DATA_TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 8803 "Game.c"
}

static void
game_hub_data_game_instance_init (GameHubDataGame * self,
                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
	GameHubDataGameStatus* _tmp1_;
	GeeArrayList* _tmp2_;
#line 28 "../src/data/Game.vala"
	self->priv = game_hub_data_game_get_instance_private (self);
#line 45 "../src/data/Game.vala"
	_tmp0_ = gee_array_list_new (GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _game_hub_data_db_tables_tags_tag_is_equal_gee_equal_data_func, NULL, NULL);
#line 45 "../src/data/Game.vala"
	self->priv->_tags = _tmp0_;
#line 101 "../src/data/Game.vala"
	self->priv->_installers_dir = NULL;
#line 102 "../src/data/Game.vala"
	self->priv->_is_installable = TRUE;
#line 104 "../src/data/Game.vala"
	self->priv->_store_page = NULL;
#line 106 "../src/data/Game.vala"
	self->priv->_last_launch = (gint64) 0;
#line 226 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_game_status_new (GAME_HUB_DATA_GAME_STATE_UNINSTALLED, NULL, NULL);
#line 226 "../src/data/Game.vala"
	self->_status = _tmp1_;
#line 236 "../src/data/Game.vala"
	self->priv->_playtime_source = (gint64) 0;
#line 237 "../src/data/Game.vala"
	self->priv->_playtime_tracked = (gint64) 0;
#line 241 "../src/data/Game.vala"
	_tmp2_ = gee_array_list_new (GAME_HUB_DATA_GAME_TYPE_OVERLAY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 241 "../src/data/Game.vala"
	self->overlays = _tmp2_;
#line 523 "../src/data/Game.vala"
	self->priv->_achievements = NULL;
#line 8841 "Game.c"
}

static void
game_hub_data_game_finalize (GObject * obj)
{
	GameHubDataGame * self;
#line 28 "../src/data/Game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_TYPE_GAME, GameHubDataGame);
#line 30 "../src/data/Game.vala"
	_game_hub_data_game_source_unref0 (self->priv->_source);
#line 32 "../src/data/Game.vala"
	_g_free0 (self->priv->_description);
#line 34 "../src/data/Game.vala"
	_g_free0 (self->priv->_icon);
#line 35 "../src/data/Game.vala"
	_g_free0 (self->priv->_image);
#line 36 "../src/data/Game.vala"
	_g_free0 (self->priv->_image_vertical);
#line 38 "../src/data/Game.vala"
	_g_free0 (self->priv->_info);
#line 39 "../src/data/Game.vala"
	_g_free0 (self->priv->_info_detailed);
#line 43 "../src/data/Game.vala"
	_g_free0 (self->priv->_version);
#line 45 "../src/data/Game.vala"
	_g_object_unref0 (self->priv->_tags);
#line 101 "../src/data/Game.vala"
	_g_object_unref0 (self->priv->_installers_dir);
#line 104 "../src/data/Game.vala"
	_g_free0 (self->priv->_store_page);
#line 226 "../src/data/Game.vala"
	_game_hub_data_game_status_unref0 (self->_status);
#line 241 "../src/data/Game.vala"
	_g_object_unref0 (self->overlays);
#line 242 "../src/data/Game.vala"
	_g_object_unref0 (self->priv->fs_overlay);
#line 243 "../src/data/Game.vala"
	_g_free0 (self->priv->fs_overlay_last_options);
#line 284 "../src/data/Game.vala"
	_g_free0 (self->executable_path);
#line 322 "../src/data/Game.vala"
	_g_free0 (self->work_dir_path);
#line 523 "../src/data/Game.vala"
	_g_object_unref0 (self->priv->_achievements);
#line 28 "../src/data/Game.vala"
	G_OBJECT_CLASS (game_hub_data_game_parent_class)->finalize (obj);
#line 8888 "Game.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataGame), 0, (GInstanceInitFunc) game_hub_data_game_instance_init, NULL };
	GType game_hub_data_game_type_id;
	game_hub_data_game_type_id = g_type_register_static (GAME_HUB_DATA_TYPE_RUNNABLE, "GameHubDataGame", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GameHubDataGame_private_offset = g_type_add_instance_private (game_hub_data_game_type_id, sizeof (GameHubDataGamePrivate));
	return game_hub_data_game_type_id;
}

GType
game_hub_data_game_get_type (void)
{
	static volatile gsize game_hub_data_game_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_game_type_id__once)) {
		GType game_hub_data_game_type_id;
		game_hub_data_game_type_id = game_hub_data_game_get_type_once ();
		g_once_init_leave (&game_hub_data_game_type_id__once, game_hub_data_game_type_id);
	}
	return game_hub_data_game_type_id__once;
}

static void
_vala_game_hub_data_game_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GameHubDataGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_TYPE_GAME, GameHubDataGame);
#line 28 "../src/data/Game.vala"
	switch (property_id) {
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_SOURCE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_value_set_game_source (value, game_hub_data_game_get_source (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_description (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_ICON_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_icon (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IMAGE_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_image (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_image_vertical (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INFO_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_info (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_info_detailed (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_FULL_ID_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_take_string (value, game_hub_data_game_get_full_id (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_VERSION_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_version (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_TAGS_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_object (value, game_hub_data_game_get_tags (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_object (value, game_hub_data_game_get_installers_dir (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_boolean (value, game_hub_data_game_get_is_installable (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_string (value, game_hub_data_game_get_store_page (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_int64 (value, game_hub_data_game_get_last_launch (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATUS_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_value_set_status (value, game_hub_data_game_get_status (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_int64 (value, game_hub_data_game_get_playtime_source (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_int64 (value, game_hub_data_game_get_playtime_tracked (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_PLAYTIME_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_int64 (value, game_hub_data_game_get_playtime (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_take_object (value, game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_take_object (value, game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_OVERLAYS_ENABLED_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_boolean (value, game_hub_data_game_get_overlays_enabled (self));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY:
#line 28 "../src/data/Game.vala"
		g_value_set_object (value, game_hub_data_game_get_achievements (self));
#line 28 "../src/data/Game.vala"
		break;
#line 9055 "Game.c"
		default:
#line 28 "../src/data/Game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../src/data/Game.vala"
		break;
#line 9061 "Game.c"
	}
}

static void
_vala_game_hub_data_game_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GameHubDataGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_TYPE_GAME, GameHubDataGame);
#line 28 "../src/data/Game.vala"
	switch (property_id) {
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_SOURCE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_source (self, game_hub_data_value_get_game_source (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_DESCRIPTION_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_description (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_ICON_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_icon (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IMAGE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_image (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IMAGE_VERTICAL_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_image_vertical (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INFO_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_info (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INFO_DETAILED_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_info_detailed (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_VERSION_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_version (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_TAGS_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_tags (self, g_value_get_object (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_INSTALLERS_DIR_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_installers_dir (self, g_value_get_object (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_IS_INSTALLABLE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_is_installable (self, g_value_get_boolean (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STORE_PAGE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_store_page (self, g_value_get_string (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_LAST_LAUNCH_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_last_launch (self, g_value_get_int64 (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_STATUS_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_status (self, game_hub_data_game_value_get_status (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_PLAYTIME_SOURCE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_playtime_source (self, g_value_get_int64 (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_PLAYTIME_TRACKED_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_playtime_tracked (self, g_value_get_int64 (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_EXECUTABLE_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_runnable_set_executable ((GameHubDataRunnable*) self, g_value_get_object (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_WORK_DIR_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_runnable_set_work_dir ((GameHubDataRunnable*) self, g_value_get_object (value));
#line 28 "../src/data/Game.vala"
		break;
#line 28 "../src/data/Game.vala"
		case GAME_HUB_DATA_GAME_ACHIEVEMENTS_PROPERTY:
#line 28 "../src/data/Game.vala"
		game_hub_data_game_set_achievements (self, g_value_get_object (value));
#line 28 "../src/data/Game.vala"
		break;
#line 9189 "Game.c"
		default:
#line 28 "../src/data/Game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../src/data/Game.vala"
		break;
#line 9195 "Game.c"
	}
}

static void
_vala_array_add9 (GameHubDataTweaksTweak** * array,
                  gint* length,
                  gint* size,
                  GameHubDataTweaksTweak* value)
{
#line 688 "../src/data/Game.vala"
	if ((*length) == (*size)) {
#line 688 "../src/data/Game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 688 "../src/data/Game.vala"
		*array = g_renew (GameHubDataTweaksTweak*, *array, (*size) + 1);
#line 9211 "Game.c"
	}
#line 688 "../src/data/Game.vala"
	(*array)[(*length)++] = value;
#line 688 "../src/data/Game.vala"
	(*array)[*length] = NULL;
#line 9217 "Game.c"
}

GameHubDataTweaksTweak**
game_hub_data_tweakable_game_get_enabled_tweaks (GameHubDataTweakableGame* self,
                                                 GameHubDataCompatTool* tool,
                                                 gint* result_length1)
{
	GameHubDataTweaksTweak** enabled_tweaks = NULL;
	GameHubDataTweaksTweak** _tmp0_;
	gint enabled_tweaks_length1;
	gint _enabled_tweaks_size_;
	GeeHashMap* all_tweaks = NULL;
	GeeHashMap* _tmp1_;
	GameHubDataTweaksTweak** _tmp16_;
	gint _tmp16__length1;
	GameHubDataTweaksTweak** result;
#line 682 "../src/data/Game.vala"
	_tmp0_ = g_new0 (GameHubDataTweaksTweak*, 0 + 1);
#line 682 "../src/data/Game.vala"
	enabled_tweaks = _tmp0_;
#line 682 "../src/data/Game.vala"
	enabled_tweaks_length1 = 0;
#line 682 "../src/data/Game.vala"
	_enabled_tweaks_size_ = enabled_tweaks_length1;
#line 683 "../src/data/Game.vala"
	_tmp1_ = game_hub_data_tweaks_tweak_load_tweaks (FALSE);
#line 683 "../src/data/Game.vala"
	all_tweaks = _tmp1_;
#line 9246 "Game.c"
	{
		GeeIterator* _tweak_it = NULL;
		GeeHashMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
#line 684 "../src/data/Game.vala"
		_tmp2_ = all_tweaks;
#line 684 "../src/data/Game.vala"
		_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
#line 684 "../src/data/Game.vala"
		_tmp4_ = _tmp3_;
#line 684 "../src/data/Game.vala"
		_tmp5_ = _tmp4_;
#line 684 "../src/data/Game.vala"
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
#line 684 "../src/data/Game.vala"
		_tmp7_ = _tmp6_;
#line 684 "../src/data/Game.vala"
		_g_object_unref0 (_tmp5_);
#line 684 "../src/data/Game.vala"
		_tweak_it = _tmp7_;
#line 684 "../src/data/Game.vala"
		while (TRUE) {
#line 9273 "Game.c"
			GeeIterator* _tmp8_;
			GameHubDataTweaksTweak* tweak = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			GameHubDataTweaksTweak* _tmp12_;
#line 684 "../src/data/Game.vala"
			_tmp8_ = _tweak_it;
#line 684 "../src/data/Game.vala"
			if (!gee_iterator_next (_tmp8_)) {
#line 684 "../src/data/Game.vala"
				break;
#line 9286 "Game.c"
			}
#line 684 "../src/data/Game.vala"
			_tmp9_ = _tweak_it;
#line 684 "../src/data/Game.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 684 "../src/data/Game.vala"
			tweak = (GameHubDataTweaksTweak*) _tmp10_;
#line 686 "../src/data/Game.vala"
			_tmp12_ = tweak;
#line 686 "../src/data/Game.vala"
			if (game_hub_data_tweaks_tweak_is_enabled (_tmp12_, self)) {
#line 9298 "Game.c"
				GameHubDataTweaksTweak* _tmp13_;
#line 686 "../src/data/Game.vala"
				_tmp13_ = tweak;
#line 686 "../src/data/Game.vala"
				_tmp11_ = game_hub_data_tweaks_tweak_is_applicable_to (_tmp13_, self, tool);
#line 9304 "Game.c"
			} else {
#line 686 "../src/data/Game.vala"
				_tmp11_ = FALSE;
#line 9308 "Game.c"
			}
#line 686 "../src/data/Game.vala"
			if (_tmp11_) {
#line 9312 "Game.c"
				GameHubDataTweaksTweak* _tmp14_;
				GameHubDataTweaksTweak* _tmp15_;
#line 688 "../src/data/Game.vala"
				_tmp14_ = tweak;
#line 688 "../src/data/Game.vala"
				_tmp15_ = _g_object_ref0 (_tmp14_);
#line 688 "../src/data/Game.vala"
				_vala_array_add9 (&enabled_tweaks, &enabled_tweaks_length1, &_enabled_tweaks_size_, _tmp15_);
#line 9321 "Game.c"
			}
#line 684 "../src/data/Game.vala"
			_g_object_unref0 (tweak);
#line 9325 "Game.c"
		}
#line 684 "../src/data/Game.vala"
		_g_object_unref0 (_tweak_it);
#line 9329 "Game.c"
	}
#line 691 "../src/data/Game.vala"
	_tmp16_ = enabled_tweaks;
#line 691 "../src/data/Game.vala"
	_tmp16__length1 = enabled_tweaks_length1;
#line 691 "../src/data/Game.vala"
	if (result_length1) {
#line 691 "../src/data/Game.vala"
		*result_length1 = _tmp16__length1;
#line 9339 "Game.c"
	}
#line 691 "../src/data/Game.vala"
	result = _tmp16_;
#line 691 "../src/data/Game.vala"
	_g_object_unref0 (all_tweaks);
#line 691 "../src/data/Game.vala"
	return result;
#line 9347 "Game.c"
}

gchar**
game_hub_data_tweakable_game_get_tweaks (GameHubDataTweakableGame* self,
                                         gint* result_length1)
{
	GameHubDataTweakableGameIface* _iface_;
#line 678 "../src/data/Game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 678 "../src/data/Game.vala"
	_iface_ = GAME_HUB_DATA_TWEAKABLE_GAME_GET_INTERFACE (self);
#line 678 "../src/data/Game.vala"
	if (_iface_->get_tweaks) {
#line 678 "../src/data/Game.vala"
		return _iface_->get_tweaks (self, result_length1);
#line 9363 "Game.c"
	}
#line 678 "../src/data/Game.vala"
	return NULL;
#line 9367 "Game.c"
}

void
game_hub_data_tweakable_game_set_tweaks (GameHubDataTweakableGame* self,
                                         gchar** value,
                                         gint value_length1)
{
	GameHubDataTweakableGameIface* _iface_;
#line 678 "../src/data/Game.vala"
	g_return_if_fail (self != NULL);
#line 678 "../src/data/Game.vala"
	_iface_ = GAME_HUB_DATA_TWEAKABLE_GAME_GET_INTERFACE (self);
#line 678 "../src/data/Game.vala"
	if (_iface_->set_tweaks) {
#line 678 "../src/data/Game.vala"
		_iface_->set_tweaks (self, value, value_length1);
#line 9384 "Game.c"
	}
}

static void
game_hub_data_tweakable_game_default_init (GameHubDataTweakableGameIface * iface,
                                           gpointer iface_data)
{
#line 676 "../src/data/Game.vala"
	g_object_interface_install_property (iface, g_param_spec_boxed ("tweaks", "tweaks", "tweaks", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 9394 "Game.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_tweakable_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataTweakableGameIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_tweakable_game_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType game_hub_data_tweakable_game_type_id;
	game_hub_data_tweakable_game_type_id = g_type_register_static (G_TYPE_INTERFACE, "GameHubDataTweakableGame", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (game_hub_data_tweakable_game_type_id, GAME_HUB_DATA_TYPE_GAME);
	return game_hub_data_tweakable_game_type_id;
}

GType
game_hub_data_tweakable_game_get_type (void)
{
	static volatile gsize game_hub_data_tweakable_game_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_tweakable_game_type_id__once)) {
		GType game_hub_data_tweakable_game_type_id;
		game_hub_data_tweakable_game_type_id = game_hub_data_tweakable_game_get_type_once ();
		g_once_init_leave (&game_hub_data_tweakable_game_type_id__once, game_hub_data_tweakable_game_type_id);
	}
	return game_hub_data_tweakable_game_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

