/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.lang.reflect.Constructor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ElementFactoryUtil {
    public static DesignElementHandle newElement(Module module, String elementTypeName, String name, boolean reName) {
        DesignElementHandle extension;
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null && (extension = ElementFactoryUtil.newExtensionElement(module, elementTypeName, name, reName)) != null) {
            return extension;
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ElementFactoryUtil.newElementExceptExtensionElement(module, elementTypeName, name, reName);
            if (element == null) {
                return null;
            }
            return element.getHandle(module);
        }
        return null;
    }

    public static DesignElement newElementExceptExtendedItem(Module module, String elementTypeName, String name) {
        return ElementFactoryUtil.newElementExceptExtensionElement(module, elementTypeName, name, true);
    }

    public static DesignElement newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        String javaClass = elemDefn.getJavaClass();
        if (javaClass == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(javaClass);
            DesignElement element = null;
            try {
                Constructor<?> constructor = c.getConstructor(String.class);
                element = (DesignElement)constructor.newInstance(name);
                return element;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                element = (DesignElement)c.newInstance();
                element.setName(name);
                return element;
            }
        }
        catch (Exception exception) {
            assert (false);
            return null;
        }
    }

    public static DesignElement newElementExceptExtensionElement(Module module, String elementTypeName, String name, boolean reName) {
        DesignElement element = ElementFactoryUtil.newElement(elementTypeName, name);
        if (element != null && module != null && reName) {
            module.makeUniqueName(element);
        }
        return element;
    }

    private static DesignElementHandle newExtensionElement(Module module, String elementTypeName, String name, boolean reName) {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(elementTypeName);
        if (extDefn == null) {
            return null;
        }
        String extensionPoint = extDefn.getExtensionPoint();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(extensionPoint)) {
            return ElementFactoryUtil.newExtendedItem(module, name, elementTypeName, reName);
        }
        return null;
    }

    private static ExtendedItemHandle newExtendedItem(Module module, String name, String extensionName, boolean reName) {
        try {
            return ElementFactoryUtil.newExtendedItem(module, name, extensionName, null, reName);
        }
        catch (ExtendsException extendsException) {
            assert (false);
            return null;
        }
    }

    private static ExtendedItemHandle newExtendedItem(Module module, String name, String extensionName, ExtendedItemHandle parent, boolean reName) throws ExtendsException {
        ExtendedItemHandle handle;
        block7: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null) assert (((ExtendedItem)parent.getElement()).getExtDefn() == extDefn);
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            element.setProperty("extensionName", (Object)extensionName);
            if (parent != null) {
                element.getHandle(module).setExtends(parent);
            }
            if (reName) {
                module.makeUniqueName(element);
            }
            handle = element.handle(module);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException extendedElementException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return handle;
    }
}

