/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultCriticalPath;
import com.nvidia.viper.analysis.IAnalysis;
import com.nvidia.viper.jni.ChironException;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeChiron;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.CriticalPath;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.run.TimelineRunner;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CriticalPathAnalysis
implements IAnalysis {
    private CriticalPath path = null;

    private CriticalPath computeCriticalPath(long hPdm, String pdmFilename) {
        CriticalPath criticalPath = null;
        try {
            if (NativeChiron.runAnalysis(hPdm, pdmFilename)) {
                criticalPath = NativeChiron.getCriticalPath(hPdm);
            }
        }
        catch (ChironException | CuptiException exception) {
            criticalPath = null;
        }
        return criticalPath;
    }

    private boolean missingHostThreadData(Session session) {
        if (!session.getTimelines(TimelineKind.PTHREAD).isEmpty()) {
            return false;
        }
        List<Timeline> processes = session.getTimelines(TimelineKind.PROCESS);
        return session.getTimelines(TimelineKind.RUNTIME).size() > processes.size() || session.getTimelines(TimelineKind.DRIVER).size() > processes.size();
    }

    private boolean updateTimelines(Session session) {
        IWorkbench workbench;
        if (session.getTimelines().isEmpty() && (workbench = PlatformUI.getWorkbench()) != null && workbench.getActiveWorkbenchWindow() != null) {
            final TimelineRunner runner = new TimelineRunner(session);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        runner.runWithMonitor(monitor);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                dialog.close();
            }
        }
        return !session.getTimelines().isEmpty();
    }

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        AnalysisResultCriticalPath analysisResult = new AnalysisResultCriticalPath(AnalysisDescriptor.DEPENDENCY_ANALYSIS_NO_DATA, null);
        if (!this.updateTimelines(session)) {
            results.add(analysisResult);
            return true;
        }
        if (session.getNumTimelinePdms() > 1) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.LoadExpertEvents_Fail_Title, "Analysis is not supported for multi-process application");
                }
            });
            results.add(analysisResult);
            return true;
        }
        if (session.getNumTimelinePdms() == 1) {
            List<ProfileDataModel> pdms = session.getTimelinePdms();
            try {
                final long pdmHandle = pdms.get(0).getNativeHandle();
                final String pdmFilename = pdms.get(0).getPdmFilePath();
                int version = NativeCupti.cuptiPDMGetVersion(pdmHandle);
                if (version < 9) {
                    analysisResult = new AnalysisResultCriticalPath(AnalysisDescriptor.DEPENDENCY_ANALYSIS_OLD_PDM, null);
                } else {
                    this.path = null;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell());
                        try {
                            dialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.beginTask(ViperMessages.Dependency_Analysis_InProgress_Message, 100);
                                    Thread computeThread = new Thread("Dependency Analysis"){

                                        @Override
                                        public void run() {
                                            CriticalPathAnalysis.this.path = CriticalPathAnalysis.this.computeCriticalPath(pdmHandle, pdmFilename);
                                        }
                                    };
                                    computeThread.start();
                                    long lastProgress = 0L;
                                    boolean analysisCanceled = false;
                                    while (computeThread != null && computeThread.isAlive()) {
                                        long chironProgress;
                                        if (monitor.isCanceled()) {
                                            analysisCanceled = true;
                                            NativeChiron.getAnalysisProgress(pdmHandle, analysisCanceled);
                                            monitor.setTaskName(ViperMessages.Dependency_Analysis_Cancel_Message);
                                        }
                                        if ((chironProgress = NativeChiron.getAnalysisProgress(pdmHandle, analysisCanceled)) <= lastProgress) continue;
                                        monitor.worked((int)(chironProgress - lastProgress));
                                        lastProgress = chironProgress;
                                    }
                                    if (analysisCanceled) {
                                        throw new InterruptedException();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            this.path = null;
                            dialog.close();
                            if (e instanceof InterruptedException) {
                                NativeChiron.discardAnalysis(pdmHandle);
                            }
                        }
                    } else {
                        this.path = this.computeCriticalPath(pdmHandle, pdmFilename);
                    }
                    if (this.path != null) {
                        this.path.addOtherCpuActivities();
                        analysisResult = new AnalysisResultCriticalPath(AnalysisDescriptor.DEPENDENCY_ANALYSIS, this.path);
                        if (this.missingHostThreadData(session)) {
                            results.add(new AnalysisResult(AnalysisDescriptor.DEPENDENCY_ANALYSIS_NO_THREAD_DATA){

                                @Override
                                public Action getMoreAction() {
                                    return new Action(){

                                        public void run() {
                                            ViperHelp.displayHelp(ViperHelp.DEPENDENCY_ANALYSIS_NO_THREAD_DATA);
                                        }
                                    };
                                }
                            });
                        }
                    }
                }
            }
            catch (CuptiException cuptiException) {}
        }
        results.add(analysisResult);
        return true;
    }
}

