/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.CsvKeys;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CsvReader {
    public static final String NV_WARNING_LABEL = "NV_Warning";
    public static final String NV_ERROR_LABEL = "NV_Error";
    public static final String CUDA_DEVICE_LABEL = "CUDA_DEVICE";
    public static final String CUDA_CONTEXT_LABEL = "CUDA_CONTEXT";
    public static final String OPENCL_DEVICE_LABEL = "OPENCL_DEVICE";
    public static final String OPENCL_CONTEXT_LABEL = "OPENCL_CONTEXT";
    public static final String TIMESTAMPFACTOR_LABEL = "TIMESTAMPFACTOR";
    private static final String GPUSTARTTIMESTAMP_KEY = CsvKeys.gpustarttimestamp.name().toLowerCase();
    private static final String GPUENDTIMESTAMP_KEY = CsvKeys.gpuendtimestamp.name().toLowerCase();
    private static final String METHOD_KEY = CsvKeys.method.name().toLowerCase();
    private static final String GPUTIME_KEY = CsvKeys.gputime.name().toLowerCase();
    private static final String STREAM_KEY = CsvKeys.streamid.name().toLowerCase();
    private static final String GRIDSIZEX_KEY = CsvKeys.gridsizeX.name().toLowerCase();
    private static final String GRIDSIZEY_KEY = CsvKeys.gridsizeY.name().toLowerCase();
    private static final String GRIDSIZEZ_KEY = CsvKeys.gridsizeZ.name().toLowerCase();
    private static final String BLOCKSIZEX_KEY = CsvKeys.threadblocksizeX.name().toLowerCase();
    private static final String BLOCKSIZEY_KEY = CsvKeys.threadblocksizeY.name().toLowerCase();
    private static final String BLOCKSIZEZ_KEY = CsvKeys.threadblocksizeZ.name().toLowerCase();
    private static final String REGSPERTHREAD_KEY = CsvKeys.regperthread.name().toLowerCase();
    private static final String STATICSHAREDMEM_KEY = CsvKeys.stasmemperblock.name().toLowerCase();
    private static final String DYNASHAREDMEM_KEY = CsvKeys.dynsmemperblock.name().toLowerCase();
    private static final String MEM_TRANSFERSIZE_KEY = CsvKeys.memtransfersize.name().toLowerCase();
    private static final String PARENT_GRIDID_KEY = CsvKeys.parentgridid.name().toLowerCase();
    private static final String GRIDID_KEY = CsvKeys.gridid.name().toLowerCase();
    private BufferedReader reader;
    private int defaultContextNum;
    private Set<String> currentEvents = new HashSet<String>();
    private CuptiActivityComputeApiKind currentComputeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
    private int currentDeviceNum = -1;
    private String currentDeviceName = null;
    private int currentContextNum = -1;
    private Long timestampFactor = 0L;
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private String[] current = null;

    public CsvReader(InputStream inputStream, String filename) throws ViperException {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        Pattern contextP = Pattern.compile(".*_([0-9]+)\\..*");
        this.defaultContextNum = 0;
        Matcher contextM = contextP.matcher(filename);
        if (contextM.find() && contextM.groupCount() == 1) {
            this.defaultContextNum = Integer.parseInt(contextM.group(1));
        }
    }

    protected String getNextCsvLine() throws IOException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return line;
        } while (line.startsWith(NV_WARNING_LABEL) || line.startsWith(NV_ERROR_LABEL));
        if (line.charAt(0) != '#') {
            return line;
        }
        this.currentDeviceNum = -1;
        this.currentDeviceName = null;
        this.currentContextNum = this.defaultContextNum;
        Pattern cudaDevP = Pattern.compile("^# CUDA_DEVICE ([0-9]+) (.*)");
        Pattern cudaCtxP = Pattern.compile("^# CUDA_CONTEXT ([0-9]+)");
        Pattern oclDevP = Pattern.compile("^# OPENCL_DEVICE ([0-9]+) (.*)");
        Pattern oclCtxP = Pattern.compile("^# OPENCL_CONTEXT ([0-9]+)");
        Pattern tsP = Pattern.compile("^# TIMESTAMPFACTOR ([abcdefABCDEF0-9]+)");
        while (line != null) {
            if (!line.startsWith(NV_WARNING_LABEL) && !line.startsWith(NV_ERROR_LABEL)) {
                if (line.charAt(0) != '#') break;
                Matcher cudaDevM = cudaDevP.matcher(line);
                if (cudaDevM.find() && cudaDevM.groupCount() == 2) {
                    this.currentComputeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
                    this.currentDeviceNum = Integer.parseInt(cudaDevM.group(1));
                    this.currentDeviceName = cudaDevM.group(2);
                } else {
                    Matcher oclDevM = oclDevP.matcher(line);
                    if (oclDevM.find() && oclDevM.groupCount() == 2) {
                        this.currentComputeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN;
                        this.currentDeviceNum = Integer.parseInt(oclDevM.group(1));
                        this.currentDeviceName = oclDevM.group(2);
                    } else {
                        Matcher cudaCtxM = cudaCtxP.matcher(line);
                        if (cudaCtxM.find() && cudaCtxM.groupCount() == 1) {
                            this.currentContextNum = Integer.parseInt(cudaCtxM.group(1));
                        } else {
                            Matcher oclCtxM = oclCtxP.matcher(line);
                            if (oclCtxM.find() && oclCtxM.groupCount() == 1) {
                                this.currentContextNum = Integer.parseInt(oclCtxM.group(1));
                            } else {
                                Matcher tsM = tsP.matcher(line);
                                if (tsM.find() && tsM.groupCount() == 1) {
                                    this.timestampFactor = new BigInteger(tsM.group(1), 16).longValue();
                                }
                            }
                        }
                    }
                }
            }
            line = this.reader.readLine();
        }
        this.indexMap.clear();
        this.currentEvents.clear();
        while (line != null) {
            if (!line.startsWith(NV_WARNING_LABEL) && !line.startsWith(NV_ERROR_LABEL)) {
                String[] entries;
                int index = 0;
                String[] stringArray = entries = line.split(",");
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    this.indexMap.put(entry.toLowerCase(), index);
                    ++index;
                    if (CsvKeys.isEvent(entry)) {
                        this.currentEvents.add(entry);
                    }
                    ++n2;
                }
                break;
            }
            line = this.reader.readLine();
        }
        line = this.reader.readLine();
        while (line != null) {
            if (!line.startsWith(NV_WARNING_LABEL) && !line.startsWith(NV_ERROR_LABEL)) break;
            line = this.reader.readLine();
        }
        return line;
    }

    public boolean step() throws ViperException {
        this.current = null;
        try {
            String line = this.getNextCsvLine();
            if (line != null) {
                this.current = line.split(",");
            }
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            throw (ViperException)e2;
        }
        return this.current != null;
    }

    public Set<String> getCurrentEvents() {
        return Collections.unmodifiableSet(this.currentEvents);
    }

    public CuptiActivityComputeApiKind getCurrentComputeKind() {
        return this.currentComputeKind;
    }

    public int getCurrentDeviceNum() {
        return this.currentDeviceNum;
    }

    public String getCurrentDeviceName() {
        return this.currentDeviceName;
    }

    public int getCurrentContextNum() {
        return this.currentContextNum;
    }

    protected Long getGpuStartTimestamp(boolean normalize) {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(GPUSTARTTIMESTAMP_KEY);
        if (index == null) {
            return null;
        }
        if (this.currentDeviceNum == -1) {
            return null;
        }
        try {
            String val = this.current[index];
            Long ts = Long.parseLong(val, 16);
            if (!normalize) {
                return ts;
            }
            return ts - this.timestampFactor;
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
            return null;
        }
    }

    public Long getGpuStartTimestamp() {
        return this.getGpuStartTimestamp(true);
    }

    protected Long getGpuEndTimestamp(boolean normalize) {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(GPUENDTIMESTAMP_KEY);
        if (index == null) {
            return null;
        }
        if (this.currentDeviceNum == -1) {
            return null;
        }
        try {
            String val = this.current[index];
            Long ts = Long.parseLong(val, 16);
            if (!normalize) {
                return ts;
            }
            return ts - this.timestampFactor;
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
            return null;
        }
    }

    public Long getGpuEndTimestamp() {
        return this.getGpuEndTimestamp(true);
    }

    public Long getGpuTime() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(GPUTIME_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            double time = Double.parseDouble(val) * 1000.0;
            return Math.round(time);
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
            return null;
        }
    }

    public String getMethod() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(METHOD_KEY);
        if (index == null) {
            return null;
        }
        return this.current[index];
    }

    public String getStreamName() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(STREAM_KEY);
        if (index == null) {
            return null;
        }
        return this.current[index];
    }

    public Long getGridId() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(GRIDID_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Long.parseLong(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Long getParentGridId() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(PARENT_GRIDID_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Long.parseLong(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Integer[] getGridSize() {
        if (this.current == null) {
            return null;
        }
        String[] gridSizeKeys = new String[]{GRIDSIZEX_KEY, GRIDSIZEY_KEY, GRIDSIZEZ_KEY};
        Integer[] gridSize = new Integer[3];
        int i = 0;
        while (i < 3) {
            gridSize[i] = null;
            Integer index = this.indexMap.get(gridSizeKeys[i]);
            if (index != null) {
                try {
                    String val = this.current[index];
                    if (val != null && !val.isEmpty()) {
                        gridSize[i] = Integer.parseInt(val);
                    }
                }
                catch (Exception e) {
                    ViperExceptionHandler.logError(null, e);
                    return null;
                }
            }
            ++i;
        }
        return gridSize;
    }

    public Integer[] getBlockSize() {
        if (this.current == null) {
            return null;
        }
        String[] blockSizeKeys = new String[]{BLOCKSIZEX_KEY, BLOCKSIZEY_KEY, BLOCKSIZEZ_KEY};
        Integer[] blockSize = new Integer[3];
        int i = 0;
        while (i < 3) {
            blockSize[i] = null;
            Integer index = this.indexMap.get(blockSizeKeys[i]);
            if (index != null) {
                try {
                    String val = this.current[index];
                    if (val != null && !val.isEmpty()) {
                        blockSize[i] = Integer.parseInt(val);
                    }
                }
                catch (Exception e) {
                    ViperExceptionHandler.logError(null, e);
                    return null;
                }
            }
            ++i;
        }
        return blockSize;
    }

    public Integer getRegistersPerThread() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(REGSPERTHREAD_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Integer.parseInt(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Integer getStaticSharedMemory() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(STATICSHAREDMEM_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Integer.parseInt(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Integer getDynamicSharedMemory() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(DYNASHAREDMEM_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Integer.parseInt(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Long getMemTransferSize() {
        if (this.current == null) {
            return null;
        }
        Integer index = this.indexMap.get(MEM_TRANSFERSIZE_KEY);
        if (index == null) {
            return null;
        }
        try {
            String val = this.current[index];
            if (val != null && !val.isEmpty()) {
                return Long.parseLong(val);
            }
        }
        catch (Exception e) {
            ViperExceptionHandler.logError(null, e);
        }
        return null;
    }

    public Long getEventValue(String eventName) {
        String val;
        block5: {
            if (this.current == null || !CsvKeys.isEvent(eventName)) {
                return null;
            }
            Integer index = this.indexMap.get(eventName);
            if (index == null) {
                return null;
            }
            try {
                val = this.current[index];
                if (!val.isEmpty()) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return Long.parseLong(val);
    }
}

