/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.IRemoteContainer;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.services.clientserver.StringComparePatternMatcher;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileChildrenContentsType;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEncodingManager;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSchedulingRule;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFolderChildrenContentsType;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;

public abstract class RemoteFile
implements IRemoteFile,
IAdaptable,
Comparable {
    protected IRemoteFileContext _context;
    protected String _label;
    protected Object remoteObj;
    protected IRemoteFile _parentFile;
    protected boolean isContainer = false;
    protected HashMap _contents = new HashMap();
    protected boolean _isStale = true;
    protected HashMap properties = new HashMap();
    protected HashMap propertyStates = new HashMap();

    public RemoteFile(IRemoteFileContext context) {
        this._context = context;
        if (context != null && context.getParentRemoteFileSubSystem() != null && !context.getParentRemoteFileSubSystem().isConnected()) {
            try {
                IRemoteFileSubSystem ss = context.getParentRemoteFileSubSystem();
                if (Display.getCurrent() == null) {
                    ss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                } else {
                    ss.connect(false, null);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setFilterString(RemoteFileFilterString filterString) {
        this._context.setFilterString(filterString);
    }

    public void setLabel(String newLabel) {
        this._label = newLabel;
    }

    public IRemoteFileContext getContext() {
        return this._context;
    }

    public IRemoteFileSubSystem getParentRemoteFileSubSystem() {
        return this._context.getParentRemoteFileSubSystem();
    }

    public IRemoteFileSubSystemConfiguration getParentRemoteFileSubSystemConfiguration() {
        IRemoteFileSubSystem ss = this._context.getParentRemoteFileSubSystem();
        if (ss == null) {
            return null;
        }
        return ss.getParentRemoteFileSubSystemConfiguration();
    }

    public void setParentRemoteFile(IRemoteFile parentFile) {
        this._parentFile = parentFile;
    }

    public IRemoteFile getParentRemoteFile() {
        if (this._parentFile == null) {
            IRemoteFileSubSystem ss;
            if (this.isRoot()) {
                return null;
            }
            IRemoteFile parentFile = null;
            String pathOnly = this.getParentPath();
            if (pathOnly != null && (ss = this._context.getParentRemoteFileSubSystem()) != null) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    char sep = this.getSeparatorChar();
                    if (pathOnly.length() == 0) {
                        parentFile = ss.getRemoteFileObject(pathOnly, (IProgressMonitor)monitor);
                    } else if (pathOnly.length() == 1) {
                        if (pathOnly.charAt(0) == sep) {
                            parentFile = ss.getRemoteFileObject(pathOnly, (IProgressMonitor)monitor);
                        }
                    } else {
                        parentFile = pathOnly.charAt(pathOnly.length() - 1) != sep ? ss.getRemoteFileObject(String.valueOf(pathOnly) + sep, (IProgressMonitor)monitor) : ss.getRemoteFileObject(pathOnly, (IProgressMonitor)monitor);
                    }
                }
                catch (SystemMessageException e) {
                    SystemBasePlugin.logError((String)"RemoteFileImpl.getParentRemoteFile()", (Throwable)e);
                }
            }
            this._parentFile = parentFile;
        }
        return this._parentFile;
    }

    public RemoteFileFilterString getFilterString() {
        return this._context.getFilterString();
    }

    public RemoteFileFilterString[] getAllFilterStrings() {
        return this._context.getAllFilterStrings();
    }

    public char getSeparatorChar() {
        IRemoteFileSubSystemConfiguration ssf = this.getParentRemoteFileSubSystemConfiguration();
        if (ssf != null) {
            return ssf.getSeparatorChar();
        }
        return File.separatorChar;
    }

    public String getSeparator() {
        IRemoteFileSubSystemConfiguration ssf = this.getParentRemoteFileSubSystemConfiguration();
        if (ssf != null) {
            return ssf.getSeparator();
        }
        return File.separator;
    }

    public String getLineSeparator() {
        IRemoteFileSubSystemConfiguration ssf = this.getParentRemoteFileSubSystemConfiguration();
        if (ssf != null) {
            return ssf.getLineSeparator();
        }
        return System.getProperty("line.separator");
    }

    public boolean isUnix() {
        IRemoteFileSubSystemConfiguration ssf = this.getParentRemoteFileSubSystemConfiguration();
        if (ssf != null) {
            return ssf.isUnixStyle();
        }
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public boolean isLink() {
        String classifyString = this.getClassification();
        if (classifyString == null) {
            return false;
        }
        return classifyString.indexOf("symbolic link") > -1;
    }

    public boolean isExecutable() {
        String classifyString = this.getClassification();
        if (classifyString == null) {
            return false;
        }
        return classifyString.indexOf("executable") > -1;
    }

    public boolean isArchive() {
        File file = new File(this.getAbsolutePath());
        return this.isFile() && ArchiveHandlerManager.getInstance().isArchive(file);
    }

    public IHost getHost() {
        IRemoteFileSubSystem ss = this._context.getParentRemoteFileSubSystem();
        if (ss == null) {
            return null;
        }
        return ss.getHost();
    }

    public String getAbsolutePathPlusConnection() {
        IHost conn = this.getHost();
        if (conn == null) {
            return this.getAbsolutePath();
        }
        return String.valueOf(conn.getSystemProfileName()) + '.' + conn.getAliasName() + ':' + this.getAbsolutePath();
    }

    public String getLabel() {
        if (this._label != null) {
            return this._label;
        }
        return this.getName();
    }

    public boolean isBinary() {
        if (this.isDirectory()) {
            return false;
        }
        ISystemFileTransferModeRegistry reg = RemoteFileUtility.getSystemFileTransferModeRegistry();
        return reg.isBinary(this) || reg.isXML(this);
    }

    public boolean isText() {
        if (this.isDirectory()) {
            return false;
        }
        return RemoteFileUtility.getSystemFileTransferModeRegistry().isText(this);
    }

    public Date getLastModifiedDate() {
        return new Date(this.getLastModified());
    }

    public String getExtension() {
        String nameOnly = this.getName();
        if (nameOnly == null) {
            return null;
        }
        int idx = nameOnly.lastIndexOf(46);
        if (idx >= 0) {
            return nameOnly.substring(idx + 1);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public int compareTo(Object other) throws ClassCastException {
        IRemoteFile otherFile = (IRemoteFile)other;
        if (this.isDirectory() && !otherFile.isDirectory()) {
            return -1;
        }
        if (!this.isDirectory() && otherFile.isDirectory()) {
            return 1;
        }
        String comp1 = this.getName();
        String comp2 = otherFile.getName();
        if (comp2 == null) {
            comp2 = otherFile.getParentPath();
        }
        return comp1.toLowerCase().compareTo(comp2.toLowerCase());
    }

    public void setFile(Object obj) {
        this.remoteObj = obj;
    }

    public Object getFile() {
        return this.remoteObj;
    }

    public boolean isAncestorOf(IRemoteFile file) {
        String separator = this.getSeparator();
        if (this instanceof IVirtualRemoteFile) {
            separator = "/";
        }
        if (this.isArchive()) {
            separator = "#virtual#/";
        }
        return file.getAbsolutePathPlusConnection().startsWith(String.valueOf(this.getAbsolutePathPlusConnection()) + separator);
    }

    public boolean isDescendantOf(IRemoteFile file) {
        String separator = file.getSeparator();
        if (this instanceof IVirtualRemoteFile) {
            separator = "/";
        }
        if (file.isArchive()) {
            separator = "#virtual#/";
        }
        return this.getAbsolutePathPlusConnection().startsWith(String.valueOf(file.getAbsolutePathPlusConnection()) + separator);
    }

    public boolean hasContents(ISystemContentsType contentsType) {
        boolean result = this._contents.containsKey(contentsType);
        return result;
    }

    public boolean hasContents(ISystemContentsType contentsType, String filter) {
        HashMap filters = (HashMap)this._contents.get(contentsType);
        if (filters == null) {
            return false;
        }
        if (filter == null) {
            filter = "*";
        }
        boolean result = this.containsFilterKey(filters, filter);
        return result;
    }

    protected boolean containsFilterKey(HashMap filters, String filter) {
        if (filters.containsKey(filter)) {
            return true;
        }
        Set keySet = filters.keySet();
        Object[] keyArray = keySet.toArray();
        int i = 0;
        while (i < keyArray.length) {
            String key = (String)keyArray[i];
            StringComparePatternMatcher matcher = new StringComparePatternMatcher(key);
            if (matcher.stringMatches(filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getContents(ISystemContentsType contentsType) {
        return this.getContents(contentsType, "*");
    }

    private Object[] combine(Object[] set1, Object[] set2) {
        ArrayList<Object> result = new ArrayList<Object>(set1.length + set2.length);
        int i = 0;
        while (i < set1.length) {
            result.add(set1[i]);
            ++i;
        }
        int j = 0;
        while (j < set2.length) {
            result.add(set2[j]);
            ++j;
        }
        return result.toArray(new IRemoteFile[result.size()]);
    }

    private Object[] getFolders(Object[] filesAndFolders) {
        ArrayList<IRemoteFile> results = new ArrayList<IRemoteFile>();
        int i = 0;
        while (i < filesAndFolders.length) {
            IRemoteFile fileOrFolder = (IRemoteFile)filesAndFolders[i];
            boolean supportsArchiveManagement = fileOrFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
            if (!fileOrFolder.isFile() || fileOrFolder.isArchive() && supportsArchiveManagement) {
                results.add(fileOrFolder);
            }
            ++i;
        }
        return results.toArray();
    }

    public Object[] getContents(ISystemContentsType contentsType, String filter) {
        HashMap filters = (HashMap)this._contents.get(contentsType);
        Object[] results = null;
        if (filters == null || filters.isEmpty()) {
            if (contentsType == RemoteChildrenContentsType.getInstance()) {
                if (this.hasContents(RemoteFileChildrenContentsType.getInstance()) && this.hasContents(RemoteFolderChildrenContentsType.getInstance())) {
                    Object[] folders = this.getContents(RemoteFolderChildrenContentsType.getInstance(), filter);
                    Object[] files = this.getContents(RemoteFileChildrenContentsType.getInstance(), filter);
                    return this.combine(folders, files);
                }
            } else if (contentsType == RemoteFileChildrenContentsType.getInstance()) {
                if (this.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance())) {
                    Object[] filesAndFolders = this.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
                    return filesAndFolders;
                }
            } else if (contentsType == RemoteFolderChildrenContentsType.getInstance() && this.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance())) {
                Object[] filesAndFolders = this.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
                return this.getFolders(filesAndFolders);
            }
            return null;
        }
        if (filter == null) {
            filter = "*";
        }
        if (filters.containsKey(filter)) {
            Object[] filterResults;
            results = filterResults = (Object[])filters.get(filter);
        } else {
            ArrayList<Object> calculatedResults = new ArrayList<Object>();
            StringComparePatternMatcher fmatcher = new StringComparePatternMatcher(filter);
            Object[] keySet = filters.keySet().toArray();
            int i = 0;
            while (i < keySet.length) {
                Object[] all;
                String key = (String)keySet[i];
                StringComparePatternMatcher matcher = new StringComparePatternMatcher(key);
                if (matcher.stringMatches(filter) && (all = (Object[])filters.get(key)) != null) {
                    int s = 0;
                    while (s < all.length) {
                        Object subContent = all[s];
                        if (!calculatedResults.contains(subContent)) {
                            if (subContent instanceof IRemoteFile) {
                                IRemoteFile temp = (IRemoteFile)subContent;
                                if (temp.isFile()) {
                                    String compareTo = null;
                                    boolean filterForFileTypes = this.isFilterForFileTypes(filter);
                                    compareTo = !filterForFileTypes ? temp.getName() : temp.getExtension();
                                    if (compareTo != null && fmatcher.stringMatches(compareTo)) {
                                        calculatedResults.add(subContent);
                                    }
                                } else {
                                    calculatedResults.add(subContent);
                                }
                            } else {
                                calculatedResults.add(subContent);
                            }
                        }
                        ++s;
                    }
                }
                ++i;
            }
            results = calculatedResults.toArray();
        }
        if (!this.isFile()) {
            try {
                Arrays.sort(results);
            }
            catch (Exception exception) {}
        }
        return results;
    }

    private boolean isFilterForFileTypes(String filter) {
        return filter.endsWith(",");
    }

    public void setIsContainer(boolean con) {
        this.isContainer = con;
    }

    public void replaceContent(Object oldObject, Object newObject) {
        HashMap filters = (HashMap)this._contents.get(RemoteChildrenContentsType.getInstance());
        if (filters != null) {
            Collection values = filters.values();
            Object[] valuesArray = values.toArray();
            int i = 0;
            while (i < valuesArray.length) {
                Object[] children = (Object[])valuesArray[i];
                int j = 0;
                while (j < children.length) {
                    if (children[j] == oldObject) {
                        children[j] = newObject;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setContents(ISystemContentsType contentsType, String filter, Object[] con) {
        if (filter == null) {
            filter = "*";
        }
        this.isContainer = true;
        HashMap<String, Object[]> filters = (HashMap<String, Object[]>)this._contents.get(contentsType);
        if (filters == null) {
            filters = new HashMap<String, Object[]>();
        }
        if (this.isContainer) {
            filters.put(filter, con);
            this._contents.put(contentsType, filters);
        }
        if (this.isContainer && con != null) {
            int i = 0;
            while (i < con.length) {
                if (con[i] instanceof RemoteFile) {
                    RemoteFile rFile = (RemoteFile)con[i];
                    rFile.setParentRemoteFile(this);
                }
                ++i;
            }
        }
    }

    public boolean isStale() {
        return this._isStale || !this.exists();
    }

    public void markStale(boolean isStale) {
        this.markStale(isStale, true);
    }

    public void markStale(boolean isStale, boolean clearCache) {
        this._isStale = isStale;
        if (isStale && clearCache) {
            for (Object contentsType : this._contents.keySet()) {
                HashMap filters;
                if (!(contentsType instanceof ISystemContentsType) || ((ISystemContentsType)contentsType).isPersistent() || (filters = (HashMap)this._contents.get(contentsType)) == null) continue;
                filters.clear();
            }
            if (this._parentFile != null) {
                this._parentFile.markStale(true, false);
            }
        }
    }

    public void copyContentsTo(IRemoteContainer target) {
        for (Object contentsType : this._contents.keySet()) {
            ISystemContentsType ct;
            if (!(contentsType instanceof ISystemContentsType) || !(ct = (ISystemContentsType)contentsType).isPersistent()) continue;
            HashMap filters = (HashMap)this._contents.get(ct);
            for (Object filter : filters.keySet()) {
                Object fcontents = filters.get(filter);
                if (fcontents == null || !(fcontents instanceof Object[])) continue;
                target.setContents(ct, (String)filter, (Object[])fcontents);
            }
        }
    }

    public Object[] getProperties(String[] keys) {
        Object[] values = new Object[keys.length];
        int i = 0;
        while (i < keys.length) {
            values[i] = this.properties.get(keys[i]);
            ++i;
        }
        return values;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean isPropertyStale(String key) {
        Boolean b = (Boolean)this.propertyStates.get(key);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void markAllPropertiesStale() {
        for (String key : this.propertyStates.keySet()) {
            this.markPropertyStale(key);
        }
    }

    public void markPropertyStale(String key) {
        this.propertyStates.put(key, Boolean.FALSE);
    }

    public void setProperties(String[] keys, Object[] values) {
        int i = 0;
        while (i < keys.length) {
            this.setProperty(keys[i], values[i]);
            ++i;
        }
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
        this.propertyStates.put(key, Boolean.TRUE);
    }

    public String getComment() {
        return "";
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (rule instanceof IResource) {
            return true;
        }
        if (rule instanceof IRemoteFile) {
            RemoteFile rf = (RemoteFile)rule;
            return this.getHostName().equals(rf.getHostName()) && rf.getAbsolutePath().startsWith(this.getAbsolutePath());
        }
        if (rule instanceof RemoteFileSchedulingRule) {
            return this.getHostName().equals(((RemoteFileSchedulingRule)rule).getHostName()) && ((RemoteFileSchedulingRule)rule).getAbsolutePath().startsWith(this.getAbsolutePath());
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof RemoteFile) {
            String otherPath = ((RemoteFile)rule).getAbsolutePath();
            String path = this.getAbsolutePath();
            String otherHost = ((RemoteFile)rule).getHostName();
            return this.getHostName().equals(otherHost) && path.startsWith(otherPath) || otherPath.startsWith(path);
        }
        if (rule instanceof RemoteFileSchedulingRule) {
            String otherPath = ((RemoteFileSchedulingRule)rule).getAbsolutePath();
            String path = this.getAbsolutePath();
            String otherHost = ((RemoteFileSchedulingRule)rule).getHostName();
            return this.getHostName().equals(otherHost) && path.startsWith(otherPath) || otherPath.startsWith(path);
        }
        return false;
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof RemoteFile) {
            RemoteFile other = (RemoteFile)otherObj;
            if (this == other) {
                return true;
            }
            String otherPath = other.getAbsolutePath();
            String path = this.getAbsolutePath();
            IRemoteFileSubSystem ss1 = this.getParentRemoteFileSubSystem();
            IRemoteFileSubSystem ss2 = other.getParentRemoteFileSubSystem();
            String alias1 = "";
            if (ss1 != null) {
                alias1 = ss1.getHostAliasName();
            }
            String alias2 = "";
            if (ss2 != null) {
                alias2 = ss2.getHostAliasName();
            }
            return alias1.equals(alias2) && path.equals(otherPath);
        }
        return false;
    }

    public String getHostName() {
        return this.getHost().getHostName();
    }

    private String getParentPathFor(String path) {
        String separator = this.getSeparator();
        if (path.equals(separator)) {
            return null;
        }
        int lastSep = path.lastIndexOf(separator);
        if (lastSep == 0) {
            return separator;
        }
        if (path.equals("\\")) {
            return null;
        }
        if (lastSep > 0) {
            return path.substring(0, lastSep);
        }
        return null;
    }

    public String getEncoding() {
        String hostName = this.getParentRemoteFileSubSystem().getHost().getHostName();
        String path = this.getAbsolutePath();
        String encoding = RemoteFileEncodingManager.getInstance().getEncoding(hostName, path);
        if (encoding == null) {
            if (this._parentFile != null) {
                encoding = this._parentFile.getEncoding();
            } else {
                String parentPath = this.getParentPathFor(path);
                while (parentPath != null && encoding == null) {
                    encoding = RemoteFileEncodingManager.getInstance().getEncoding(hostName, parentPath);
                    parentPath = this.getParentPathFor(parentPath);
                }
                if (encoding == null) {
                    encoding = this.getParentRemoteFileSubSystem().getRemoteEncoding();
                }
            }
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        RemoteFileEncodingManager.getInstance().setEncoding(this.getHostName(), this.getAbsolutePath(), encoding);
    }

    public IHostFilePermissions getPermissions() {
        IHostFile hostFile = this.getHostFile();
        if (hostFile instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)hostFile).getPermissions();
        }
        return null;
    }
}

