/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ResourceNode
extends BufferedContent
implements IEncodedStreamContentAccessor,
IStructureComparator,
ITypedElement,
IEditableContent,
IModificationDate,
IResourceProvider,
IEditableContentExtension {
    private IResource fResource;
    private ArrayList fChildren;

    public ResourceNode(IResource resource) {
        this.fResource = resource;
        Assert.isNotNull((Object)resource);
    }

    public IResource getResource() {
        return this.fResource;
    }

    public InputStream getContents() throws CoreException {
        if (this.fResource instanceof IStorage) {
            return super.getContents();
        }
        return null;
    }

    public long getModificationDate() {
        return this.fResource.getLocalTimeStamp();
    }

    public String getName() {
        if (this.fResource != null) {
            return this.fResource.getName();
        }
        return null;
    }

    public String getType() {
        String s;
        if (this.fResource instanceof IContainer) {
            return "FOLDER";
        }
        if (this.fResource != null && (s = this.fResource.getFileExtension()) != null) {
            return s;
        }
        return "???";
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.fResource);
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
            if (this.fResource instanceof IContainer) {
                try {
                    IResource[] members = ((IContainer)this.fResource).members();
                    int i = 0;
                    while (i < members.length) {
                        IStructureComparator child = this.createChild(members[i]);
                        if (child != null) {
                            this.fChildren.add(child);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return this.fChildren.toArray();
    }

    protected IStructureComparator createChild(IResource child) {
        return new ResourceNode(child);
    }

    protected InputStream createStream() throws CoreException {
        if (this.fResource instanceof IStorage) {
            InputStream is = null;
            IStorage storage = (IStorage)this.fResource;
            try {
                is = storage.getContents();
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 274) {
                    this.fResource.refreshLocal(2, null);
                    is = storage.getContents();
                }
                throw e;
            }
            if (is != null) {
                return new BufferedInputStream(is);
            }
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return child;
    }

    public String getCharset() {
        return Utilities.getCharset(this.fResource);
    }

    public boolean isReadOnly() {
        ResourceAttributes attrs;
        if (this.fResource.getType() == 1 && (attrs = this.fResource.getResourceAttributes()) != null) {
            return attrs.isReadOnly();
        }
        return false;
    }

    public IStatus validateEdit(Shell shell) {
        if (this.isReadOnly()) {
            return ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{(IFile)this.fResource}, (Object)shell);
        }
        return Status.OK_STATUS;
    }
}

