/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    IArchiveFile archive;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
    }

    public ArchiveWriter(IArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    @Override
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.createEntry(relativePath);
        return new ArchiveEntryOutputStream(entry);
    }

    @Override
    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.exists(relativePath) ? this.archive.openEntry(relativePath) : this.archive.createEntry(relativePath);
        return new ArchiveEntryOutputStream(entry);
    }

    @Override
    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    @Override
    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    @Override
    public RAInputStream getInputStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.openEntry(relativePath);
        return new ArchiveEntryInputStream(entry);
    }

    @Override
    public boolean dropStream(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        try {
            return this.archive.removeEntry(relativePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean exists(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        return this.archive.exists(relativePath);
    }

    @Override
    public void finish() throws IOException {
        try {
            this.archive.flush();
        }
        finally {
            if (!this.shareArchive) {
                this.archive.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.archive.flush();
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    @Override
    public Object lock(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        return this.archive.lockEntry(relativePath);
    }

    @Override
    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {}
    }

    @Override
    public List<String> listAllStreams() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.archive.listEntries("/"));
        return list;
    }

    @Override
    public List<String> listStreams(String namePattern) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        List<String> archiveEntries = this.archive.listEntries(namePattern);
        for (String name : archiveEntries) {
            String diffString;
            if (!name.startsWith(namePattern) || name.equalsIgnoreCase(namePattern) || (diffString = ArchiveUtil.generateRelativePath(namePattern, name)).lastIndexOf(ArchiveUtil.UNIX_SEPERATOR) != 0) continue;
            list.add(name);
        }
        return list;
    }
}

