/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPClassTemplateSpecialization
extends CPPClassSpecialization
implements ICPPClassTemplate,
ICPPInternalClassTemplate {
    private ObjectMap instances;
    private ICPPDeferredClassInstance fDeferredInstance;
    private ICPPClassTemplatePartialSpecialization[] fPartialSpecs;
    private ICPPTemplateParameter[] fTemplateParameters;

    public CPPClassTemplateSpecialization(ICPPClassTemplate orig, ICPPClassSpecialization owner, ICPPTemplateParameterMap argumentMap) {
        super(orig, (IBinding)owner, argumentMap);
    }

    public void setTemplateParameters(ICPPTemplateParameter[] templateParameters) {
        this.fTemplateParameters = templateParameters;
    }

    @Override
    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        if (this.fPartialSpecs == null) {
            IASTNode point = null;
            ICPPClassTemplate origTemplate = this.getSpecializedBinding();
            ICPPClassTemplatePartialSpecialization[] orig = origTemplate.getPartialSpecializations();
            ICPPClassTemplatePartialSpecialization[] spec = new ICPPClassTemplatePartialSpecialization[orig.length];
            ICPPClassSpecialization owner = this.getOwner();
            int i = 0;
            while (i < orig.length) {
                spec[i] = (ICPPClassTemplatePartialSpecialization)owner.specializeMember(orig[i], point);
                ++i;
            }
            this.fPartialSpecs = spec;
        }
        return this.fPartialSpecs;
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        return this.fTemplateParameters;
    }

    @Override
    public final synchronized void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        if (this.instances == null) {
            this.instances = new ObjectMap(2);
        }
        String key = ASTTypeUtil.getArgumentListString(arguments, true);
        this.instances.put(key, instance);
    }

    @Override
    public final synchronized ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        if (this.instances != null) {
            String key = ASTTypeUtil.getArgumentListString(arguments, true);
            return (ICPPTemplateInstance)this.instances.get(key);
        }
        return null;
    }

    @Override
    public synchronized ICPPTemplateInstance[] getAllInstances() {
        if (this.instances != null) {
            ICPPTemplateInstance[] result = new ICPPTemplateInstance[this.instances.size()];
            int i = 0;
            while (i < this.instances.size()) {
                result[i] = (ICPPTemplateInstance)this.instances.getAt(i);
                ++i;
            }
            return result;
        }
        return ICPPTemplateInstance.EMPTY_TEMPLATE_INSTANCE_ARRAY;
    }

    @Override
    public void addPartialSpecialization(ICPPClassTemplatePartialSpecialization spec) {
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public IBinding resolveTemplateParameter(ICPPTemplateParameter param) {
        return param;
    }

    @Override
    public final ICPPDeferredClassInstance asDeferredInstance() {
        if (this.fDeferredInstance == null) {
            this.fDeferredInstance = CPPTemplates.createDeferredInstance(this);
        }
        return this.fDeferredInstance;
    }

    @Override
    public ICPPTemplateArgument getDefaultArgFromIndex(int paramPos) throws DOMException {
        return null;
    }

    @Override
    public ICPPClassSpecialization getOwner() {
        return (ICPPClassSpecialization)super.getOwner();
    }

    @Override
    public ICPPClassTemplate getSpecializedBinding() {
        return (ICPPClassTemplate)super.getSpecializedBinding();
    }
}

