#!/usr/bin/env bash

# SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -euxo pipefail

CONTAINER_NAME="${CONTAINER_NAME:=nvidia-devtools-streamer}"

if [ "$(docker ps -a | grep $CONTAINER_NAME)" ];
then
    CONTAINER_REMOVAL_NAME=${CONTAINER_NAME}-removal
    # Docker container removal takes some time and proceed asynchroniously.
    # Rename the container so that we do not have to wait for its removal.
    docker rename ${CONTAINER_NAME} ${CONTAINER_REMOVAL_NAME}
    docker stop ${CONTAINER_REMOVAL_NAME}
fi
