#!/usr/bin/env bash

# SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -euxo pipefail

SCRIPT=$(readlink -f $0)
HERE=$(dirname $SCRIPT)

export CONTAINER_NAME="${CONTAINER_NAME:-nvidia-devtools-streamer}"

"$HERE/stop-base.sh"

CONTAINER_IMAGE="${CONTAINER_IMAGE:-nvidia/devtools-streamer-base:1.0}"

HOST_LAN_IP=$(hostname -I | awk '{print $1}')

# external ip to map to be aware of
# may want to upgrade this to some sort of check-ip service
HOST_IP="${HOST_IP:=$HOST_LAN_IP}"

# external port to map to outside container for HTTP access
HTTP_PORT="${HTTP_PORT:=8080}"

# external port to map to outside container for video/audio stream access
TURN_PORT="${MEDIA_PORT:=3478}"

# username and password for client authentification
# if WEB_USERNAME is set to empty string, authentification is disabled
WEB_USERNAME="${WEB_USERNAME:=nvidia}"
WEB_PASSWORD="${WEB_PASSWORD:=nvidia}"

# Resolution after startup.
MAX_RESOLUTION="${MAX_RESOLUTION:=1920x1080}"

if [ -z "$DEVTOOL_DIR" ] || [ -z "$DEVTOOL_CMD" ]; then
    echo "Set DEVTOOL_DIR and DEVTOOL_CMD to map a devtool into the container!"
else
    DEVTOOL_DOCKER_ARGS=(
        "-v" "$DEVTOOL_DIR:/mnt/host/devtool"
        "-e" "DEVTOOL_CMD=$DEVTOOL_CMD"
    )
fi

echo -e "Starting container $CONTAINER_NAME"

set -x

docker run -d --rm -it --name $CONTAINER_NAME \
    -p $HTTP_PORT:8080 \
    -p $TURN_PORT:3478 \
    -e "HOST_IP=$HOST_IP" \
    -e "MAX_RESOLUTION=$MAX_RESOLUTION" \
    -e "WEB_USERNAME=$WEB_USERNAME" \
    -e "WEB_PASSWORD=$WEB_PASSWORD" \
    "${DEVTOOL_DOCKER_ARGS[@]}" \
    "$@" \
    $CONTAINER_IMAGE

echo -e "Browse to http://$HOST_LAN_IP:$HTTP_PORT for WebRTC session!"
