/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.value.IValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public abstract class AnalysisResultTimeline<T>
extends AnalysisResult {
    protected Map<Timeline, T> timelines = new HashMap<Timeline, T>();

    public AnalysisResultTimeline(AnalysisDescriptor desc) {
        super(desc);
    }

    public int getTimelineCount() {
        return this.timelines.size();
    }

    public T getData(Timeline timeline) {
        return this.timelines.get(timeline);
    }

    public abstract IValue getValue(Timeline var1);

    public abstract String getValueDescription(Timeline var1);

    public boolean containsTimeline(Timeline timeline) {
        return this.timelines.keySet().contains(timeline);
    }

    public void addTimeline(Timeline timeline, T data) {
        this.timelines.put(timeline, data);
    }

    public void removeTimeline(Timeline timeline) {
        this.timelines.remove(timeline);
    }

    @Override
    public boolean isValid() {
        for (Timeline timeline : this.timelines.keySet()) {
            if (!timeline.isVisible() || timeline.isFiltered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(this.timelines.size());
        for (Timeline timeline : this.timelines.keySet()) {
            TimelineIntervalPair pair = new TimelineIntervalPair(timeline, null);
            pairs.add(pair);
        }
        return pairs;
    }

    @Override
    public Action getMoreAction() {
        if (this.getSeverity() != AnalysisDescriptor.Severity.INFO && this.getSeverity() != AnalysisDescriptor.Severity.NODATA) {
            return new MoreAction();
        }
        return null;
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        }
    }
}

