/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonViewerAdvisor;
import org.eclipse.team.internal.ui.mapping.DiffTreeChangesSection;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.AbstractViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.ChangesSection;
import org.eclipse.team.internal.ui.synchronize.actions.RefreshActionContribution;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class ModelSynchronizePage
extends AbstractSynchronizePage {
    private ModelSynchronizeParticipant participant;

    public ModelSynchronizePage(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.participant = (ModelSynchronizeParticipant)configuration.getParticipant();
        configuration.setComparisonType(this.isThreeWay() ? "three-way" : "two-way");
        configuration.addActionContribution(new RefreshActionContribution());
    }

    private boolean isThreeWay() {
        return this.getParticipant().getContext().getType() == 3;
    }

    public void reset() {
    }

    protected void updateMode(int mode) {
    }

    protected ModelSynchronizeParticipant getParticipant() {
        return this.participant;
    }

    protected AbstractViewerAdvisor createViewerAdvisor(Composite parent) {
        CommonViewerAdvisor commonViewerAdvisor = new CommonViewerAdvisor(parent, this.getConfiguration());
        commonViewerAdvisor.addEmptyTreeListener((DiffTreeChangesSection)this.getChangesSection());
        this.updateMode(this.getConfiguration().getMode());
        return commonViewerAdvisor;
    }

    protected ChangesSection createChangesSection(Composite parent) {
        return new DiffTreeChangesSection(parent, this, this.getConfiguration());
    }

    public void init(ISynchronizePageSite site) {
        super.init(site);
        IDialogSettings pageSettings = site.getPageSettings();
        if (pageSettings != null) {
            String layout;
            String savedId = pageSettings.get("org.eclipse.team.ui.activeModelProvider");
            if (savedId != null && !savedId.equals("org.eclipse.team.ui.activeModelProvider")) {
                this.getConfiguration().setProperty("org.eclipse.team.ui.activeModelProvider", savedId);
            }
            if ((layout = pageSettings.get("org.eclipse.team.ui.pageLayout")) != null) {
                this.getConfiguration().setProperty("org.eclipse.team.ui.pageLayout", layout);
            }
        }
    }

    public boolean aboutToChangeProperty(ISynchronizePageConfiguration configuration, String key, Object newValue) {
        if (key.equals("org.eclipse.team.ui.activeModelProvider")) {
            if (!(newValue instanceof String)) {
                return false;
            }
            String currentSetting = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
            if (currentSetting != null && currentSetting.equals(newValue)) {
                return false;
            }
            Object input = ModelSynchronizePage.getViewerInput(configuration, (String)newValue);
            if (input instanceof ModelProvider) {
                ModelProvider provider = (ModelProvider)input;
                configuration.setProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION", NLS.bind((String)TeamUIMessages.ShowModelProviderAction_0, (Object[])new String[]{Utils.getLabel(provider), Utils.shortenText(100, configuration.getParticipant().getName())}));
            } else if (input != null) {
                configuration.setProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION", Utils.shortenText(100, configuration.getParticipant().getName()));
            }
            if (input != null) {
                IDialogSettings pageSettings = configuration.getSite().getPageSettings();
                if (pageSettings != null) {
                    pageSettings.put("org.eclipse.team.ui.activeModelProvider", (String)newValue);
                }
                return true;
            }
            return false;
        }
        if (key.equals("org.eclipse.team.ui.pageLayout")) {
            if (!(newValue instanceof String)) {
                return false;
            }
            String currentSetting = (String)configuration.getProperty("org.eclipse.team.ui.pageLayout");
            if (currentSetting != null && currentSetting.equals(newValue)) {
                return false;
            }
            IDialogSettings pageSettings = configuration.getSite().getPageSettings();
            if (pageSettings != null) {
                pageSettings.put("org.eclipse.team.ui.pageLayout", (String)newValue);
            }
            return true;
        }
        return super.aboutToChangeProperty(configuration, key, newValue);
    }

    public static Object getViewerInput(ISynchronizePageConfiguration configuration, String providerId) {
        ISynchronizationContext input = null;
        if (!providerId.equals("org.eclipse.team.ui.activeModelProvider")) {
            ModelProvider provider = ModelSynchronizePage.getModelProvider(providerId);
            if (provider != null) {
                input = provider;
            }
        } else {
            input = (ISynchronizationContext)configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
        }
        return input;
    }

    private static ModelProvider getModelProvider(String id) {
        try {
            IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
            if (desc != null) {
                return desc.getModelProvider();
            }
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
        return null;
    }
}

