/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.util.List;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.pages.Messages;
import org.eclipse.cdt.ui.templateengine.pages.TemplateInputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EditButton = Messages.getString("TemplatePreferencePage.8");
    private static final String DeleteButton = Messages.getString("TemplatePreferencePage.9");
    private static final String PageDescription = Messages.getString("TemplatePreferencePage.0");
    public static final String Blank = "";
    public static final String Message = Messages.getString("TemplatePreferencePage.1");
    protected static final String DuplicateEntry = Messages.getString("TemplatePreferencePage.2");
    private static final String DeleteValidator = Messages.getString("TemplatePreferencePage.3");
    private static final String DeleteShellMessage = Messages.getString("TemplatePreferencePage.4");
    private static final String TableToolTip = Messages.getString("TemplatePreferencePage.5");
    private static final String EditToolTip = Messages.getString("TemplatePreferencePage.6");
    private static final String DeleteToolTip = Messages.getString("TemplatePreferencePage.7");
    private static TemplateInputDialog inputDialog;
    private static SharedDefaults sharedDefaults;
    private int columnWidth = 100;
    private int columnWeight = 50;
    private String[] columnNames;
    private static List<Element> sharedElementList;
    private int attrListSize;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(this.columnWeight, this.columnWidth), new ColumnWeightData(this.columnWeight, this.columnWidth)};
    private String pageID;
    private String SharedContextHelpID = "shared_defaults_help";
    private Button editButton;
    private Button deleteButton;
    private static boolean isDeleted;
    private boolean isRedundant;
    public static boolean isDup;
    private static String[] delItemNames;
    private static Table table;
    protected static final int OPTION_ADD = 0;
    protected static final int OPTION_EDIT = 1;
    private String name;
    private String value;

    static {
        sharedDefaults = SharedDefaults.getInstance();
        delItemNames = null;
    }

    public TemplatePreferencePage() {
        this.noDefaultAndApplyButton();
        this.initializeDefaults();
    }

    public TemplatePreferencePage(String aName, String aValue) {
        this.name = aName;
        this.value = aValue;
    }

    private void initializeDefaults() {
        this.columnNames = new String[]{Messages.getString("TemplatePreferencePage.10"), Messages.getString("TemplatePreferencePage.11")};
        this.pageID = String.valueOf(CUIPlugin.getPluginId()) + "." + this.SharedContextHelpID;
        this.setTableAttributes();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label pageLabel = new Label(composite, 0);
        pageLabel.setText(PageDescription);
        Composite subComposite = new Composite(parent, 0);
        GridLayout subLayout = new GridLayout(2, false);
        GridData gridData = new GridData(1808);
        subComposite.setLayout((Layout)subLayout);
        subComposite.setLayoutData((Object)gridData);
        this.addFirstSection(subComposite);
        this.addSecondSection(subComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), this.pageID);
        return subComposite;
    }

    private void addFirstSection(Composite parent) {
        this.createTable(parent);
        this.setTableAttributes();
        this.addXMLDataIntoTable();
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.addButtonControls(composite);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void createTable(Composite composite) {
        table = new Table(composite, 1116930);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setToolTipText(TableToolTip);
        if (this.attrListSize == 0) {
            this.attrListSize = 2;
        }
        int nCols = 0;
        while (nCols < this.attrListSize) {
            layout.addColumnData(this.columnLayouts[nCols]);
            TableColumn tColumn = new TableColumn(table, 16384, nCols);
            tColumn.setWidth(this.columnWidth);
            tColumn.setText(this.columnNames[nCols]);
            ++nCols;
        }
        this.addTableListener();
    }

    private void addTableListener() {
        SelectionAdapter sListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = table.isSelected(table.getSelectionIndex());
                int selectionCount = table.getSelectionCount();
                if (isSelected) {
                    TemplatePreferencePage.this.editButton.setEnabled(true);
                    TemplatePreferencePage.this.deleteButton.setEnabled(true);
                }
                if (selectionCount > 1) {
                    TemplatePreferencePage.this.editButton.setEnabled(false);
                }
            }
        };
        table.addSelectionListener((SelectionListener)sListener);
    }

    private void addXMLDataIntoTable() {
        int i = 0;
        int l = sharedElementList.size();
        while (i < l) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("id");
            String value = xmlElement.getAttribute("value");
            if (name.equals(Blank) && value.equals(Blank)) {
                return;
            }
            String[] backEndData = new String[]{name, value};
            TableItem backEndItem = new TableItem(table, 0);
            int data = 0;
            while (data < backEndData.length) {
                if (backEndData[data] != null) {
                    backEndItem.setText(data, backEndData[data]);
                }
                ++data;
            }
            ++i;
        }
    }

    private void addButtonControls(Composite composite) {
        this.editButton = new Button(composite, 8);
        this.editButton.setText(EditButton);
        this.editButton.setEnabled(false);
        this.editButton.setToolTipText(EditToolTip);
        this.addButtonListener(this.editButton);
        this.deleteButton = new Button(composite, 8);
        this.deleteButton.setText(DeleteButton);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(DeleteToolTip);
        this.addButtonListener(this.deleteButton);
    }

    public void addButtonListener(Button button) {
        inputDialog = new TemplateInputDialog(this.getShell());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String editItemString;
                if (e.getSource().equals(TemplatePreferencePage.this.editButton) && (editItemString = TemplatePreferencePage.getSelectedItemNameFromTable()) != null && editItemString != TemplatePreferencePage.Blank) {
                    inputDialog.open(inputDialog, 1);
                }
                if (e.getSource().equals(TemplatePreferencePage.this.deleteButton)) {
                    TemplatePreferencePage.this.deleteRow();
                    TemplatePreferencePage.this.editButton.setEnabled(false);
                    TemplatePreferencePage.this.deleteButton.setEnabled(false);
                }
            }
        };
        button.addSelectionListener((SelectionListener)listener);
    }

    public void addNewDataIntoTable() {
        String[] addData = new String[]{this.name, this.value};
        if (!isDeleted) {
            TableItem[] duplicateItems = table.getItems();
            TableItem duplicateItem = null;
            TableItem[] tableItemArray = duplicateItems;
            int n = duplicateItems.length;
            int n2 = 0;
            while (n2 < n) {
                int result;
                TableItem duplicateItem2 = tableItemArray[n2];
                duplicateItem = duplicateItem2;
                String duplicateString = duplicateItem.getText();
                if (duplicateString.equals(this.name) && (result = inputDialog.popDuplicate()) == 32) {
                    isDup = this.isRedundant = true;
                    break;
                }
                ++n2;
            }
            if (!this.isRedundant) {
                TableItem tableItem = new TableItem(table, 0);
                int data = 0;
                while (data < addData.length) {
                    tableItem.setText(data, addData[data]);
                    ++data;
                }
                this.isRedundant = false;
            }
        }
        sharedDefaults.addToBackEndStorage(this.name, this.value);
    }

    private int getAttributeSize() {
        try {
            int listSize = sharedElementList.size();
            int i = 0;
            while (i < listSize) {
                Element xmlElement = sharedElementList.get(i++);
                this.attrListSize = xmlElement.getAttributes().getLength();
            }
        }
        catch (Exception exp) {
            TemplateEngineUtil.log((Throwable)exp);
        }
        return this.attrListSize;
    }

    private void setTableAttributes() {
        try {
            SharedDefaults sharedTemp = new SharedDefaults();
            sharedElementList = TemplateEngine.getChildrenOfElement((Element)sharedTemp.document.getDocumentElement());
            this.attrListSize = this.getAttributeSize();
            sharedDefaults.putAll(sharedTemp.getSharedDefaultsMap());
        }
        catch (Exception exp) {
            TemplateEngineUtil.log((Throwable)exp);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void updateDataInTheTable() {
        try {
            int selectedItemIndex = table.getSelectionIndex();
            TableItem selectedItem = table.getItem(selectedItemIndex);
            String[] updateString = new String[]{this.name, this.value};
            selectedItem.setText(updateString);
            sharedDefaults.updateToBackEndStorage(this.name, this.value);
        }
        catch (Exception exp) {
            TemplateEngineUtil.log((Throwable)exp);
        }
    }

    public static String getSelectedItemNameFromTable() {
        String selectedItemName = null;
        int selectedItemIndex = 0;
        try {
            selectedItemIndex = table.getSelectionIndex();
        }
        catch (Exception exp) {
            TemplateEngineUtil.log((Throwable)exp);
        }
        TableItem selectedItem = table.getItem(selectedItemIndex);
        selectedItemName = selectedItem.getText();
        return selectedItemName;
    }

    private void deleteRow() {
        int result = 0;
        String nonEmptyItemString = TemplatePreferencePage.getSelectedItemNameFromTable();
        if (nonEmptyItemString != null) {
            result = this.confirmdeleteContents(nonEmptyItemString);
        }
        if (result == 32) {
            int[] itemSelected = table.getSelectionIndices();
            table.remove(itemSelected);
            if (delItemNames != null) {
                sharedDefaults.deleteBackEndStorage(delItemNames);
            }
        } else if (result == 256) {
            isDeleted = false;
        }
    }

    private int confirmdeleteContents(String selectedItems) {
        int result = 0;
        TableItem[] deleteItems = null;
        if (selectedItems != Blank) {
            deleteItems = table.getSelection();
            delItemNames = new String[deleteItems.length];
            int nDel = 0;
            while (nDel < deleteItems.length) {
                TableItem item = deleteItems[nDel];
                TemplatePreferencePage.delItemNames[nDel] = item.getText();
                ++nDel;
            }
            MessageBox mBox = new MessageBox(this.getShell(), 292);
            mBox.setText(DeleteShellMessage);
            mBox.setMessage(DeleteValidator);
            result = mBox.open();
        }
        return result;
    }
}

