const searchData = {"envversion": {"sphinx.domains.c": 2, "sphinx.domains.changeset": 1, "sphinx.domains.citation": 1, "sphinx.domains.cpp": 5, "sphinx.domains.index": 1, "sphinx.domains.javascript": 2, "sphinx.domains.math": 2, "sphinx.domains.python": 3, "sphinx.domains.rst": 2, "sphinx.domains.std": 2, "sphinx.ext.intersphinx": 1, "repo_docs.ext.toctree": 2, "repo_docs.ext.mermaid": 1, "repo_docs.ext.enhanced_search": 2, "sphinx": 56}, "data": [{"id": 0, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#about-compute-sanitizer", "display_name": "About Compute Sanitizer", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "about-compute-sanitizer", "priority": -1, "content": "Compute Sanitizer is a functional correctness checking suite included in the CUDA toolkit. This suite contains multiple tools that can perform different type of checks. The memcheck tool is capable of precisely detecting and attributing out of bounds and misaligned memory access errors in CUDA applications. The tool can also report hardware exceptions encountered by the GPU. The racecheck tool can report shared memory data access hazards that can cause data races. The initcheck tool can report cases where the GPU performs uninitialized accesses to global memory. The synccheck tool can report cases where the application is attempting invalid usages of synchronization primitives. This document describes the usage of these tools.", "keywords": []}, {"id": 1, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#api-error-suppression", "display_name": "API error suppression", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "api-error-suppression", "priority": -1, "content": "The API error application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make In this example, we have a simple loop where the application attempts to allocate a large decreasing size. We can expect the cudaMalloc API to fail several times before the size is small enough to fit on the GPU. $ make run_memcheck /usr/local/cuda/compute-sanitizer/compute-sanitizer suppressions_demo ========= COMPUTE-SANITIZER ========= Program hit cudaErrorMemoryAllocation (error 2) due to &quot;out of memory&quot; on CUDA API call to cudaMalloc. In order to generate a suppressions file, we need to use the --xml option combined with the --save option for the output file name. Running that command still prints out error as before, but it also creates an XML file and populates it with a record of the output. $ make gen_supp /usr/local/cuda/compute-sanitizer/compute-sanitizer --save supp.xml --xml suppressions_demo ========= COMPUTE-SANITIZER ========= Program hit cudaErrorMemoryAllocation (error 2) due to &quot;out of memory&quot; on CUDA API call to cudaMalloc. [...] $ cat supp.xml &lt;![CDATA[ &lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt; &lt;ComputeSanitizerOutput&gt; &lt;record&gt; &lt;kind&gt;Api&lt;/kind&gt; &lt;what&gt; &lt;text&gt;Program hit cudaErrorMemoryAllocation (error 2) due to out of memory on CUDA API call to cudaMalloc.&lt;/text&gt; &lt;api&gt;cudaMalloc&lt;/api&gt; &lt;error&gt;cudaErrorMemoryAllocation&lt;/error&gt; &lt;message&gt;out of memory&lt;/message&gt; &lt;result&gt;2&lt;/result&gt; &lt;/what&gt; &lt;hostStack&gt; [...] &lt;/hostStack&gt; ]]&gt; Now, we can use that file as input to run the tool, along with the --suppressions option to ignore that error. $ make run_memcheck_with_supp /usr/local/cuda/compute-sanitizer/compute-sanitizer --suppressions supp.xml suppressions_demo ========= COMPUTE-SANITIZER ========= ERROR SUMMARY: 0 errors The XML file can be edited to change which errors are ignored. For instance, a regular expression can be used in the api tag to suppress a range of API calls. For instance cuda.* will ignore any errors related to an API starting with cuda. Other tags that can be edited are the result and hoststack ones. Note that the host stack appears in reverse order and the suppressions feature will compare every stack frame that was recorded.", "keywords": []}, {"id": 2, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#block-level-hazards", "display_name": "Block-level Hazards", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "block-level-hazards", "priority": -1, "content": "The application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make dbg=1 Each kernel thread write some element in shared memory. Afterward, thread 0 computes the sum of all elements in shared memory and stores the result in global memory variable sum_out . Running this application under the racecheck tool with the --racecheck-report analysis option, the following error is reported: $ make run_block_error ========= COMPUTE-SANITIZER ========= Error: Race reported between Write access at sumKernel(int *, int *)+0x90 in /home/cuda/github/compute-sanitizer-samples/Racecheck/block_error.cu:41 ========= and Read access at sumKernel(int *, int *)+0x100 in /home/cuda/github/compute-sanitizer-samples/Racecheck/block_error.cu:51 [508 hazards] ========= ========= RACECHECK SUMMARY: 1 hazard displayed (1 error, 0 warnings) Racecheck reports races between thread 0 reading all shared memory elements in line 51 and each individual thread writing its shared memory entry in line 41. Accesses to shared memory between multiple threads, where at least one access is a write, can potentially race with each other. Since the races are between threads of different warps, the block-level synchronization barrier __syncthreads() is required in line 42. Note that a total of 508 hazards are reported: the kernel uses a single block of 128 threads. The data size written or read, respectively, by each thread is four bytes (one int ) and hazards are reported at the byte level. The writes by all threads race with the reads by thread 0, except for the four writes by thread 0 itself.", "keywords": []}, {"id": 3, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#command-line-options", "display_name": "Command Line Options", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "command-line-options", "priority": -1, "content": "Command line options can be specified to compute-sanitizer . With some exceptions, the options are usually of the form --option value . The option list can be terminated by specifying -- . All subsequent words are treated as the application being run and its arguments. The table below describes the supported options in detail. The first column is the option name passed to compute-sanitizer . Some options have a one character short form, which is given in parentheses. These options can be invoked using a single hyphen. For example, the help option can be invoked as -h . The options that have a short form do not take a value. The second column contains the permissible values for the option. In case the value is user defined, it is shown below in braces {} . An option that can accept any numerical value is represented as {number}. The third column contains the default value of the option. Some options have different default values depending on the architecture they are being run on. Option Values Default Description check-device-heap yes, no yes Enables checking of device heap allocations. This applies to both error checking and leak checking. check-bulk-copy yes, no yes Enables checks related to the PTX cp.async.bulk instructions on Hopper. check-exit-code yes, no yes Checks the application exit code and print an error if it is different than 0. check-optix-leaks N/A disabled Detects and reports OptiX resources that were created and were not destroyed at OptixDeviceContextDestroy time. For more information, see OptiX support . check-warpgroup-mma yes, no yes Enables memcheck and synccheck support for PTX wgmma instructions (requires sm_90a). For memcheck, the tool checks that the matrices loaded by wgmma.mma_async are in shared memory range. For synccheck, see Synccheck support for wgmma . coredump-behavior full, exit full Controls the behavior of the target application after generating a CUDA coredump. full: Abort the target application and generate a CPU coredump. exit: Exit the target application without generating a CPU coredump. coredump-name {filename} N/A Name to use for the generated coredump file. demangle full, simple, no full Enables the demangling of device function names. For more information, see Name Demangling . destroy-on-device-error context, kernel context This controls how the application proceeds on hitting a memory access error. For more information, see Error Actions . error-exitcode {number} 0 The exit code Compute Sanitizer will return if the original application succeeded but the tool detected that errors were present. This is meant to allow Compute Sanitizer to be integrated into automated test suites. force-blocking-launches N/A disabled This forces all host kernel launches to be sequential. When enabled, the number and precision of reported errors will decrease. force-synchronization-limit {number} 0 This forces a synchronization after a stream reaches the given number of launches without synchronizing. This is meant to reduce the memory usage of the Compute Sanitizer tools, but it can affect performances. generate-coredump N/A disabled When this is set, a coredump will be generated for the first error encountered and program execution will be stopped. For more information, see Coredump support . help (h) N/A N/A Displays the help message ignore-getprocaddress-notfound N/A disabled Ignore CUDA_ERROR_NOT_FOUND API errors for cuGetProcAddress. injection-path {path} N/A Sets the path to injection libraries. injection-path32 {path} N/A Sets the path to 32bit injection libraries. kernel-name {key1=val1}[{,key2=val2}] N/A Controls which application kernels will be checked by the running the Compute Sanitizer tool. For more information, see Specifying Filters . kernel-name-exclude {key1=val1}[{,key2=val2}] N/A Controls which application kernels will be checked by the running the Compute Sanitizer tool. For more information, see Specifying Filters . language c, fortran c This controls the application source language specific behavior in Compute Sanitizer tools. For fortran specific behavior, see CUDA Fortran Specific Behavior . launch-count (c) {number} 0 Limit the number of kernel launches to check. The count is only incremented for launches that match the kernel filters. Use 0 for unlimited. launch-skip (s) {number} 0 Set the number of kernel launches to skip before starting to check. The count is only incremented for launches that match the kernel filters. launch-timeout {number} 10 for single process, 60 for multi-process Timeout in seconds for the connection to the target process. A value of zero forces compute-sanitizer to wait infinitely. log-file {filename} N/A This is the file Compute Sanitizer will write all of its text output to. By default, Compute Sanitizer will print all output to stdout. For more information, see Escape Sequences . max-connections {number} 10 Maximum number of ports for connecting to the target application. kill N/A disabled Makes the compute-sanitizer kill the target application when a communication error is met. By default, the compute-sanitizer will instead await for the normal completion of the program without reporting potential errors. mode launch-and-attach, launch, attach launch-and-attach Select the mode of interaction with the target application launch-and-attach: Launch the target application and immediately attach. launch: Launch the target application and suspend it, waiting for tool to attach. attach: Attach to a previously launched application to which no other tool is attached. num-callers-device {number} 0 Set the number of callers to print in device stack traces. Use 0 for unlimited. num-callers-host {number} 0 Set the number of callers to print in host stack traces. Use 0 for unlimited. num-cuda-barriers {number} 0 Set the number of cuda::barriers that the target application will use per block. Use 0 for automatic detection. nvtx true,false true Enable NVTX support. port {number} 49152 Base port for connecting to the target application. prefix {string} ======== The string prepended to Compute Sanitizer output lines. preload-library {lib1}[{,lib2}] N/A Prepend a shared library(ies) to be loaded by the application before the injection libraries. print-level info, warn, error, fatal warn The minimum print level of messages from Compute Sanitizer. print-limit {number} 100 When this option is set, Compute Sanitizer will stop printing errors after reaching the given number of errors. Use 0 for unlimited printing. print-session-details N/A disabled Print details about the sanitizer session for each target application such as process ID, command line, target system etc. quiet (q) N/A disabled Controls whether to run silently and only print error messages. read {filename} N/A The input Compute Sanitizer file to read data from. This can be used in conjunction with the \u2013save option to allow processing records after a run. require-cuda-init yes, no yes Controls whether Compute Sanitizer should return an error if the target application does not use CUDA. save {filename} N/A Filename where Compute Sanitizer will save the output from the current run. For more information, see Escape Sequences . save-session-details N/A disabled Save details about the sanitizer session for each target application in the file specified by --save . This option has no effect if the --save option is not used. strip-paths yes, no yes Print only filenames instead of full paths. support-32bit N/A disabled This option only exists on Linux x86_64. Enables the support for tracking application that includes 32-bit processes. On Windows, the support is always enabled if the 32bit injection libraries are found. Note: Only the 64bit processes are supported for actual checking, the purpose of the option is to allow tracking of the children process of a 32bit process. suppressions {filename} N/A Input XML file containing a list of reports that should be filtered out by the tool if detected. For more information, see Error suppression . target-processes application-only, all all Select which processes are to be tracked by compute-sanitizer: The root application process, or the root application and all its child processes. target-processes-filter {string} N/A Set the comma separated expressions to filter which processes are tracked. &lt;process name&gt; Set the process name to filter by. Only exactly matched processes are tracked. regex:&lt;expression&gt; Set the regex to filter matching process name profiling. On shells that recognize regular expression symbols as special characters (e.g. Linux bash), the expression needs to be escaped with quotes, e.g. --target-processes-filter regex:&quot;.*Process&quot; . The executable name will be considered as process name to match. If the process name or the provided expression match, the process will be tracked. Examples --target-processes-filter MatrixMul Filter all processes having executable name exactly as \u201cMatrixMul\u201d. --target-processes-filter regex:Matrix Filter all processes that include the string \u201cMatrix\u201d in their executable name, e.g. \u201cMatrixMul\u201d and \u201cMatrixAdd\u201d. --target-processes-filter MatrixMul,MatrixAdd Filter all processes having executable name exactly as \u201cMatrixMul\u201d or \u201cMatrixAdd\u201d. tool memcheck, racecheck, initcheck, synccheck memcheck Controls which Compute Sanitizer tool is actively running. version (v) N/A N/A Prints the version of Compute Sanitizer. xml N/A disabled Emit error output to file in XML format. When used, \u2013save must also be set to specify the file to save to. Option Values Default Description show-backtrace yes, host, device, no yes Displays a backtrace for most types of errors. \u201cno\u201d disables all backtraces, \u201cyes\u201d enables all backtraces. \u201chost\u201d enables only host side backtraces. \u201cdevice\u201d enables only device side backtraces. For more information, see Stack Backtraces . backtrace-short yes, no yes Short version of backtrace is used. CUDART frames and frames below main() are not printed. Option Values Default Description check-cache-control N/A disabled Check cache control memory accesses. detect-missing-module-unload N/A disabled Detect leaks caused by missing module unload calls. This option can report false positives if the application uses the CUDA runtime as it depends on the destruction order between runtime and driver when the application exits which is not guaranteed. leak-check full, no no Prints information about all allocations that have not been freed via cudaFree at the point when the context was destroyed. For more information, see Leak Checking . padding {number} 0 Makes the compute-sanitizer allocate padding buffers after every CUDA allocation. number is the size in bytes of a padding buffer. Fore more information, see Padding . report-api-errors all, explicit, no explicit Reports errors if any CUDA API call fails. For more information, see CUDA API Error Checking . track-stream-ordered-races all, use-before-alloc, use-after-free, no no Track CUDA stream-ordered allocations races. For more information, see Stream-ordered race detection . Option Values Default Description racecheck-continue-on-deadlock yes, no yes Enables to continue past a detected deadlock. racecheck-deadlock-timeout {number} 0 Set the timeout in milliseconds for synchronization instruction hang to be considered a deadlock. Use 0 for no deadlock detection. racecheck-detect-level info, warn, error warn Set the minimum level of race conditions to detect. racecheck-memcpy-async yes, no yes Enables check for asynchronous memory copy operations. For more information, see Racecheck support for asynchronous copy . racecheck-num-workers {number} 0 Number of CPU worker threads used by the tool. Use 0 for automatic. racecheck-report hazard, analysis, all analysis Controls how racecheck reports information. For more information, see Racecheck Report Modes . racecheck-trace-sync yes, no no Enables tracing of synchronization operations (implies print level info). Option Values Default Description check-api-memory-access yes,no yes Enables checking of cudaMemcpy/cudaMemset check-optix N/A disabled Check OptiX kernel launches with initcheck. For more information, see OptiX support . track-unused-memory N/A disabled Check for unused memory allocations. unused-memory-threshold {number} 0 Threshold in percentage under which unused memory reports are silenced. The value needs to be a number between 0 and 100. Option Values Default Description missing-barrier-init-is-fatal yes, no yes Controls whether a missing cuda::barrier initialization will exit the warp.", "keywords": []}, {"id": 4, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#compilation-options", "display_name": "Compilation Options", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "compilation-options", "priority": -1, "content": "The Compute Sanitizer tools do not need any special compilation flags to function. The output displayed by the Compute Sanitizer tools is more useful with some extra compiler flags. The -G option to nvcc forces the compiler to generate debug information for the CUDA application. To generate line number information for applications without affecting the optimization level of the output, the -lineinfo nvcc option can be used. The Compute Sanitizer tools fully support both of these options and can display source attribution of errors for applications compiled with line information. The stack backtrace feature of the Compute Sanitizer tools is more useful when the application contains function symbol names. For the host backtrace, this varies based on the host OS. On Linux, the host compiler must be given the -rdynamic option to retain function symbols. On Windows, the application must be compiled for debugging, i.e. the /Zi option. When using nvcc, flags to the host compiler can be specified using the -Xcompiler option. For the device backtrace, the full frame information is only available when the application is compiled with device debug information. The compiler can skip generation of frame information when building with optimizations. Sample command line to build with function symbols and device side line information on Linux: nvcc -Xcompiler -rdynamic -lineinfo -o out in.cu", "keywords": []}, {"id": 5, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#compute-sanitizer-tools", "display_name": "Compute Sanitizer Tools", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "compute-sanitizer-tools", "priority": -1, "content": "Compute Sanitizer provides different checking mechanisms through different tools. Currently the supported tools are: Memcheck \u2013 The memory access error and leak detection tool. See Memcheck Tool Racecheck \u2013 The shared memory data access hazard detection tool. See Racecheck Tool Initcheck \u2013 The uninitialized device global memory access detection tool. See Initcheck Tool Synccheck \u2013 The thread synchronization hazard detection tool. See Synccheck Tool", "keywords": []}, {"id": 6, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#coredump-support", "display_name": "Coredump support", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "coredump-support", "priority": -1, "content": "Starting from CUDA 11.6, the compute-sanitizer tool can generate a CUDA coredump once an error is detected by using the --generate-coredump option. Once the coredump is generated, the target application will abort. On Linux, the coredump file can be loaded in cuda-gdb using the following option: (cuda-gdb) target cudacore core.name.nvcudmp See the cuda-gdb documentation for more information. On Windows, the coredump file can be loaded in NVIDIA Nsight Visual Studio Edition with the File &gt; Open menu, or by dragging and dropping the file in Visual Studio. See the NVIDIA Nsight Visual Studio Edition documentation for more information. The --coredump-name option can be used to specify the file name of the coredump. See the \u201cNaming of GPU core dump files\u201d section of the cuda-gdb documentation for more information on template specifiers and default name. The coredump feature has the following restrictions: Only threads that encountered an error can be inspected in the generated coredump The racecheck tool is not supported.", "keywords": []}, {"id": 7, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#cuda-api-error-checking", "display_name": "CUDA API Error Checking", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "cuda-api-error-checking", "priority": -1, "content": "The memcheck tool supports reporting an error if a CUDA API call made by the user program returned an error. The tool supports this detection for both CUDA run time and CUDA driver API calls. In all cases, if the API function call has a nonzero return value, Compute Sanitizer will print an error message containing the name of the API call that failed and the return value of the API call. CUDA API error reports do not terminate the application, they merely provide extra information. It is up to the application to check the return status of CUDA API calls and handle error conditions appropriately. The following API errors are not reported: cudaErrorNotReady for cudaEventQuery and cudaStreamQuery APIs. cudaErrorPeerAccessAlreadyEnabled for cudaDeviceEnablePeerAccess API. cudaErrorPeerAccessNotEnabled for cudaDeviceDisablePeerAccess API.", "keywords": []}, {"id": 8, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#cuda-fortran-specific-behavior", "display_name": "CUDA Fortran Specific Behavior", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "cuda-fortran-specific-behavior", "priority": -1, "content": "By default, error reports printed by Compute Sanitizer contain 0-based C style values for thread index (threadIdx) and block index (blockIdx). For Compute Sanitizer tools to use Fortran style 1-based offsets, use the --language fortran option. The CUDA Fortran compiler may insert extra padding in shared memory. Accesses hitting this extra padding may not be reported as an error.", "keywords": []}, {"id": 9, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#cuda-fortran-support", "display_name": "CUDA Fortran Support", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "cuda-fortran-support", "priority": -1, "content": "This section describes support for CUDA Fortran.", "keywords": []}, {"id": 10, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#device-side-allocation-checking", "display_name": "Device Side Allocation Checking", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "device-side-allocation-checking", "priority": -1, "content": "The memcheck tool checks accesses to allocations in the device heap. These allocations are created by calling malloc() inside a kernel. This feature is implicitly enabled and can be disabled by specifying the --check-device-heap no option. This feature is only activated for kernels in the application that call malloc() . The tool will report an error if the application calls a free() twice for the same allocation, or if it calls free() on an invalid pointer. Note: Make sure to look at the device side backtrace to find the location in the application where the malloc()/free() call was made.", "keywords": []}, {"id": 11, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#divergent-threads", "display_name": "Divergent Threads", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "divergent-threads", "priority": -1, "content": "The divergent_threads application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make dbg=1 In this example, we launch a kernel with a single block of 64 threads. The kernels loops over DataBlocks blocks of input data data_in . In each iteration, NumThreads elements are added concurrently in shared memory. Finally, a single thread 0 computes the sum of all values in shared memory and writes it to sum_out . Running this application under the synccheck tool, 32 errors like the following are reported: $ make run_divergent_threads ========= Barrier error detected. Divergent thread(s) in block. ========= at [clone myKernel(int *, int *)] outlineSync()+0x11f0 in test.cu:42 ========= by thread (32,0,0) in block (0,0,0) ========= Device Frame: myKernel(int *, int *)+0xe40 in test.cu:60 ========= The issue is with the block-wide synchronization in line 60 when reading the last data block into shared memory. Note that the last data block only has 48 elements (compared to 64 elements for all other blocks). As a result, not all threads of the second warp execute this statement in convergence as required. To learn more about this, please refer to this section of the CUDA C++ Programming Guide that explains when usage of __syncthreads() in conditional code is valid or not.", "keywords": []}, {"id": 12, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#dynamic-parallelism", "display_name": "Dynamic Parallelism", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "dynamic-parallelism", "priority": -1, "content": "The Compute Sanitizer tool suite supports dynamic parallelism. The memcheck tool supports precise error reporting of out of bounds and misaligned accesses on global, local and shared memory accesses, as well as on global atomic instructions for applications using dynamic parallelism. In addition, the imprecise hardware exception reporting mechanism is also fully supported. Error detection on applications using dynamic parallelism requires significantly more memory on the device; as a result, in memory constrained environments, memcheck may fail to initialize with an internal out of memory error. For limitations, see the known limitations in the Release Notes section.", "keywords": []}, {"id": 13, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#environment-variables", "display_name": "Environment Variables", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "environment-variables", "priority": -1, "content": "The following environment variables can be set before launching the compute-sanitizer tool. Name Description Default/Values NV_COMPUTE_SANITIZER_BINARY_PATCHING Controls whether compute-sanitizer will instrument user kernel code. This option is intended for debugging and should not be used by normal users. Default if unset: enabled. Valid values: any positive value between 0 and INT_MAX . NV_COMPUTE_SANITIZER_LOCAL_CONNECTION_OVERRIDE Override the default local connection mechanism between frontend and target processes. The default mechanism is platform-dependent. This should only be used if there are connection problems between frontend and target processes in a local launch. Default: unset (use default mechanism) Set to \u201cuds\u201d to use Unix Domain Socket connections (available on Posix platforms, only). Set to \u201ctcp\u201d to use TCP (available on all platforms). Set to \u201cnamed-pipes\u201d to use Windows Named Pipes (available on Windows, only). NV_COMPUTE_SANITIZER_MAX_RACECHECK_CLUSTER_RECORDS Override the maximum number of racecheck cluster access records for early exit race detection. This option can be used to either increase the number of races the tool can detect, or to suppress early exit races (0 will display no early exit race). Default if unset: 100. Valid values: any positive value between 0 and INT_MAX . NV_COMPUTE_SANITIZER_MAX_RACECHECK_HAZARDS Override the maximum number of racecheck hazards tool will process. This option can be used to either increase the number of races the tool can detect, or to reduce it and save host memory. Default if unset: 10,000,000. Valid values: any positive value between 0 and INT_MAX . NV_COMPUTE_SANITIZER_SHARED_ADDRESSING_SUPPORT Override shared memory addressing support. Default if unset: auto . Set to none to disable shared addressing support. Set to force to force shared addressing support. NV_COMPUTE_SANITIZER_RACECHECK_INDIRECT_BARRIER_TRACKING Override the racecheck indirect barrier dependencies tracking. This option is intended for cases where indirect barrier tracking might severely impact performance. Default if unset: enabled. Valid values: any positive value between 0 and INT_MAX .", "keywords": []}, {"id": 14, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#error-actions", "display_name": "Error Actions", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "error-actions", "priority": -1, "content": "When encountering an error, Compute Sanitizer behavior depends on the type of error. The default behavior of Compute Sanitizer is to continue execution on purely host side errors. Hardware exceptions detected by the memcheck tool cause the CUDA context to be destroyed. Precise errors (such as memory access and malloc/free errors) detected by the memcheck tool cause the kernel to be terminated. This terminates the kernel without running any subsequent instructions and the application continues launching other kernels in the CUDA context. The handling of memory access and malloc/free errors detected by the memcheck tool can be changed using the --destroy-on-device-error option. For racecheck detected hazards, the hazard is reported, but execution is not affected. For a full summary of error action, based on the type of the error see the table below. The error action terminate kernel refers to the cases where the kernel is terminated early, and no subsequent instructions are run. In such cases, the CUDA context is not destroyed and other kernels continue execution and CUDA API calls can still be made. When kernel execution is terminated early, the application may not have completed its computations on data. Any subsequent kernels that depend on this data will have undefined behavior. The action terminate CUDA context refers to the cases where the CUDA context is forcibly terminated. In such cases, all outstanding work for the context is terminated and subsequent CUDA API calls will fail. The action continue application refers to cases where the application execution is not impacted, and the kernel continues executing instructions. Error Type Location Action Comments Memory access error Device Terminate CUDA context User can choose to instead terminate the kernel Hardware exception Device Terminate CUDA context Subsequent calls on the CUDA context will fail Malloc/Free error Device Terminate CUDA context User can choose to instead terminate the kernel cudaMalloc allocation leak Host Continue application Error reported. No other action taken. CUDA API error Host Continue application Error reported. No other action taken. Device heap allocation leak Device Continue application Error reported. No other action taken. Shared memory hazard Device Continue application Error reported. No other action taken. Synchronization error Device Terminate CUDA context User can choose to instead terminate the kernel Compute Sanitizer internal error Host Undefined The application may behave in an undefined fashion", "keywords": []}, {"id": 15, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#error-suppression", "display_name": "Error suppression", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "error-suppression", "priority": -1, "content": "The compute-sanitizer tools can sometimes generate false positive reports. In these cases, a suppression file can be provided as input to the tool to suppress the reporting of these false positives. A suppression file can be generated by using the --xml option of the compute-sanitizer tool on the target application. Once generated, the XML file can be edited manually to be more generic. On subsequent use of the tools, the suppression file can be provided as input using the --suppressions option. The following rules are applied when checking if a detected report should be suppressed: The types of the report must match. If provided in the suppression file, integer fields must match exactly. If provided in the suppression file, a string field can be a regex. When comparing stack traces, the suppression trace needs to have the same number of frames or less than the report one. Stack frame comparisons include the following fields (if provided in the suppression): function name, file name and module name. The following types of error can be suppressed: CUDA API errors Initcheck uninitialized memory accesses Racecheck analysis reports", "keywords": []}, {"id": 16, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#escape-sequences", "display_name": "Escape Sequences", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "escape-sequences", "priority": -1, "content": "The --save and --log-file options to Compute Sanitizer accept the following escape sequences in the file name. %% : Replaced with a literal %. %p : Replaced with the PID of the Compute Sanitizer frontend application. %q{ENVVAR} : Replaced with the contents of the environment variable ENVVAR . If the variable does not exist, this is replaced with an empty string. Any other character following the % causes an error.", "keywords": []}, {"id": 17, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#example-use-of-initcheck", "display_name": "Example Use of Initcheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "example-use-of-initcheck", "priority": -1, "content": "This section presents the usage of the initcheck tool from Compute Sanitizer. The example uses an application called memset_error .", "keywords": []}, {"id": 18, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#example-use-of-memcheck", "display_name": "Example Use of Memcheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "example-use-of-memcheck", "priority": -1, "content": "This section presents a walk-through of running the memcheck tool from Compute Sanitizer on a simple application called memcheck_demo . Depending on the SM type of your GPU, your system output may vary. The application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make", "keywords": []}, {"id": 19, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#example-use-of-racecheck", "display_name": "Example Use of Racecheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "example-use-of-racecheck", "priority": -1, "content": "This section presents two example usages of the racecheck tool from Compute Sanitizer. The first example uses an application called block_error , which has shared memory hazards on the block level. The second example uses an application called warp_error , which has shared memory hazards on the warp level. Depending on the SM type of your GPU, your system output may vary.", "keywords": []}, {"id": 20, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#example-use-of-suppressions", "display_name": "Example Use of Suppressions", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "example-use-of-suppressions", "priority": -1, "content": "This section presents two example usages of the suppressions feature of Compute Sanitizer. The first example displays an API suppression (in the memcheck tool). The second example displays an initcheck report suppression.", "keywords": []}, {"id": 21, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#example-use-of-synccheck", "display_name": "Example Use of Synccheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "example-use-of-synccheck", "priority": -1, "content": "This section presents two example usages of the synccheck tool from Compute Sanitizer. The first example uses an application called divergent_threads . The second example uses an application called illegal_syncwarp . Depending on the SM type of your GPU, your system output may vary.", "keywords": []}, {"id": 22, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#how-to-get-compute-sanitizer", "display_name": "How to Get Compute Sanitizer", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "how-to-get-compute-sanitizer", "priority": -1, "content": "Compute Sanitizer is installed as part of the CUDA toolkit.", "keywords": []}, {"id": 23, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#id1", "display_name": "Compute Sanitizer", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "id1", "priority": -1, "content": "Compute Sanitizer tools can be invoked by running the compute-sanitizer executable as follows: compute-sanitizer [options] app_name [app_options] For a full list of options that can be specified to compute-sanitizer and their default values, see Command Line Options", "keywords": []}, {"id": 24, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#illegal-syncwarp", "display_name": "Illegal Syncwarp", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "illegal-syncwarp", "priority": -1, "content": "The illegal_syncwarp application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make dbg=1 The kernel is launched with a single warp (32 threads), but only thread 0-15 are part of the computation. Each of these threads initializes one shared memory element with its thread index. After the assignment, __syncwarp() is used to ensure that the warp is converged and all writes are visible to other threads. The mask passed to __syncwarp() is computed using __ballot_sync() , which enables the bits for the first 16 threads in mask . Finally, the first thread (index 0) computes the sum over all initialized shared memory elements and writes it to global memory. Building the application with -G to enable debug information and running it under the synccheck tool, multiple errors like the following are reported: $ make run_illegal_syncwarp ========= Barrier error detected. Invalid arguments ========= at __cuda_sm70_warpsync+0x30 ========= by thread (0,0,0) in block (0,0,0) ========= Device Frame:__syncwarp(unsigned int)+0xf0 in /usr/local/cuda/include/sm_30_intrinsics.hpp:110 ========= Device Frame:myKernel(int *)+0x3c0 in /home/cuda/github/compute-sanitizer-samples/Synccheck/illegal_syncwarp.cu:48 The issue is with the __syncwarp(mask) at line 48. All threads for which tx &lt; (NumThreads / 2) holds true are enabled in the mask, which are threads 0-15. However, the if condition evaluates true for threads 0-16. As a result, thread 16 executes the __syncwarp(mask) but does not declare itself in the mask parameter as required.", "keywords": []}, {"id": 25, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#initcheck-error-suppression", "display_name": "Initcheck error suppression", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "initcheck-error-suppression", "priority": -1, "content": "The API error application can be found on the compute-sanitizer github repository make In this example, we have a simple multiplication kernel. A call to cudaMemset is used to initialize the device memory to 0. However, it does not initialize the last byte of the array. The initcheck tool detects the uninitialized access: $ make run_initcheck /usr/local/cuda/compute-sanitizer/compute-sanitizer --tool initcheck suppressions_initcheck_demo ========= COMPUTE-SANITIZER ========= Uninitialized __global__ memory read of size 4 bytes ========= at mult(int *, int *, int)+0x60 ========= by thread (122,0,0) in block (0,0,0) ========= Address 0x7f936fa001e8 [...] ========= ERROR SUMMARY: 1 error In a similar fashion to the previous example, we can use the --xml option to generate a suppression file. $ make initcheck_gen_supp /usr/local/cuda/compute-sanitizer/compute-sanitizer --tool initcheck --save supp.xml --xml suppressions_initcheck_demo ========= COMPUTE-SANITIZER ========= Uninitialized __global__ memory read of size 4 bytes [...] Now, the error can be ignored using the XML file as input to the suppressions feature. $ make run_initcheck_with_supp /usr/local/cuda/compute-sanitizer/compute-sanitizer --tool initcheck --suppressions supp.xml suppressions_initcheck_demo ========= COMPUTE-SANITIZER ========= ERROR SUMMARY: 0 errors As with the API suppressions, the XML file can be edited to make the suppressions detection more generic, by editing or removing the threadId, blockId, size and device stack tags. Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 26, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#leak-checking", "display_name": "Leak Checking", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "leak-checking", "priority": -1, "content": "The memcheck tool can detect leaks of allocated memory. Memory leaks are device side allocations that have not been freed by the time the context is destroyed. The memcheck tool tracks device memory allocations created using the CUDA driver or runtime APIs. The --leak-check full option must be specified to enable leak checking.", "keywords": []}, {"id": 27, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#leak-checking-in-compute-sanitizer", "display_name": "Leak Checking in Compute Sanitizer", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "leak-checking-in-compute-sanitizer", "priority": -1, "content": "To print information about the allocations that have not been freed at the time the CUDA context is destroyed, we can specify the --leak-check full option to Compute Sanitizer. When running the program with the leak check option, the user is presented with a list of allocations that were not destroyed, along with the size of the allocation and the address on the device of the allocation. For allocations made on the host, each leak report will also print a backtrace corresponding to the saved host stack at the time the allocation was first made. Also presented is a summary of the total number of bytes leaked and the corresponding number of allocations. In this example, the program created an allocation using cudaMalloc() and has not called cudaFree() to release it, leaking memory. Notice that Compute Sanitizer still prints errors it encountered while running the application. They are omitted in the output below for the sake of clarity. $ make run_leakcheck ========= COMPUTE-SANITIZER ... ========= Leaked 1,024 bytes at 0x7879c0800000 ========= Saved host backtrace up to driver entry point at allocation time ========= Host Frame: cudaMalloc [0x56624] in memcheck_demo ========= Host Frame: main [0xae5c] in memcheck_demo ========= ========= LEAK SUMMARY: 1024 bytes leaked in 1 allocations ========= ERROR SUMMARY: 3 errors", "keywords": []}, {"id": 28, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#memcheck-demo-output", "display_name": "memcheck_demo Output", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "memcheck-demo-output", "priority": -1, "content": "When a CUDA application causes access violations, the kernel launch may report an illegal memory access or misaligned address. Sticky errors will be reported for all subsequent kernel launches. This sample application is causing two failures but there is no way to detect where the misaligned address access is caused. The second kernel is also not able to run, as illustrated in the following output: $ ./memcheck_demo Mallocing memory Running unaligned_kernel: misaligned address Running out_of_bounds_kernel: misaligned address", "keywords": []}, {"id": 29, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#memcheck-demo-output-with-memcheck-debug-build", "display_name": "memcheck_demo Output with Memcheck (Debug Build)", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "memcheck-demo-output-with-memcheck-debug-build", "priority": -1, "content": "The application can be built with device side debug information and function symbols as: make dbg=1 The source location of the error is now reported in the compute-sanitizer output: $ make run_memcheck ========= COMPUTE-SANITIZER Mallocing memory ========= Invalid __global__ write of size 4 bytes ========= at unaligned_kernel()+0x100 in memcheck_demo.cu:34 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x7cc43aa00001 is misaligned ========= and is inside the nearest allocation at 0x7cc43aa00000 of size 4 bytes ========= Saved host backtrace up to driver entry point at kernel launch time ========= Host Frame: run_unaligned() [0xacd4] in memcheck_demo ========= Host Frame: main [0xae61] in memcheck_demo ========= Running unaligned_kernel: no error ========= Invalid __global__ write of size 4 bytes ========= at out_of_bounds_function()+0xb0 in memcheck_demo.cu:39 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x87654320 is out of bounds ========= and is 137,179,965,340,896 bytes before the nearest allocation at 0x7cc43a800000 of size 1,024 bytes ========= Device Frame: out_of_bounds_kernel()+0x30 in memcheck_demo.cu:44 ========= Saved host backtrace up to driver entry point at kernel launch time ========= Host Frame: run_out_of_bounds() [0xadb6] in memcheck_demo ========= Host Frame: main [0xae66] in memcheck_demo ========= Running out_of_bounds_kernel: no error ========= ERROR SUMMARY: 2 errors", "keywords": []}, {"id": 30, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#memcheck-demo-output-with-memcheck-release-build", "display_name": "memcheck_demo Output with Memcheck (Release Build)", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "memcheck-demo-output-with-memcheck-release-build", "priority": -1, "content": "In this case, since the application is built in release mode, the Compute Sanitizer output contains only the kernel names from the application causing the access violation. Though the kernel name and error type are detected, there is no line number information on the failing kernel. Also included in the output are the host and device backtraces for the call sites where the functions were launched Now run this application with Compute Sanitizer and check the output. By default, the application will run so that the kernel is terminated on memory access errors, but other work in the CUDA context can still proceed. In the output below, the first kernel no longer reports an unspecified launch failure as its execution has been terminated early after Compute Sanitizer detected the error. The application continued to run the second kernel. The error detected in the second kernel causes it to terminate early. $ make run_memcheck /usr/local/cuda/compute-sanitizer/compute-sanitizer --destroy-on-device-error kernel memcheck_demo ========= COMPUTE-SANITIZER Mallocing memory ========= Invalid __global__ write of size 4 bytes ========= at unaligned_kernel()+0x50 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x710fdca00001 is misaligned ========= and is inside the nearest allocation at 0x710fdca00000 of size 4 bytes ========= Saved host backtrace up to driver entry point at kernel launch time ========= Host Frame: run_unaligned() [0xacd4] in memcheck_demo ========= Host Frame: main [0xae61] in memcheck_demo ========= Running unaligned_kernel: no error ========= Invalid __global__ write of size 4 bytes ========= at out_of_bounds_kernel()+0x90 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x87654320 is out of bounds ========= and is 124,310,666,263,776 bytes before the nearest allocation at 0x710fdc800000 of size 1,024 bytes ========= Saved host backtrace up to driver entry point at kernel launch time ========= Host Frame: run_out_of_bounds() [0xadb6] in memcheck_demo ========= Host Frame: main [0xae66] in memcheck_demo ========= Running out_of_bounds_kernel: no error ========= ERROR SUMMARY: 2 errors", "keywords": []}, {"id": 31, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#memory-footprint", "display_name": "Memory Footprint", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "memory-footprint", "priority": -1, "content": "Compute Sanitizer tools can have a large memory footprint due to their tracking data. This can cause out of memory errors on applications performing a large number of concurrent kernel launches. ========= Internal Sanitizer Error: The Sanitizer encountered an error while launching kernel_name and didn&#x27;t track the launch. Errors might go undetected. (Unable to allocate enough memory to perform the requested operation) The tools might also cause a failure to allocate host memory causing the application to crash. ========= Error: process didn&#x27;t terminate successfully ========= Target application returned an error This issue can be resolved using one of the following command line options: --force-synchronization-limit {number} forces a stream synchronization after a stream reaches the given number of launches without synchronizing. --force-blocking-launches forces the serialization of of every kernel launch. This option is equivalent to --force-synchronization-limit 1 . Using CUDA lazy module loading will also help lower the memory footprint of the tools, both for host and device memory.", "keywords": []}, {"id": 32, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#memset-error", "display_name": "Memset Error", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "memset-error", "priority": -1, "content": "The application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make dbg=1 The example implements a very simple vector addition, where the thread index is added to each vector element. The vector contains NumBlocks * NumThreads elements of type int . The vector is allocated on the device and then initialized to 0 using cudaMemset before the kernel is launched. Running this application under the initcheck tool reports multiple errors like the following: $ make run_initcheck ========= Uninitialized __global__ memory read of size 4 bytes ========= at vectorAdd(int *)+0x70 in /home/cuda/github/compute-sanitizer-samples/Initcheck/memset_error.cu:41 ========= by thread (31,0,0) in block (1,0,0) ========= Address 0x7f3c7ec000fc The problem is that the call to cudaMemset expects the size of the to-be set memory in bytes. However, the size is given in elements, as a factor of sizeof(int) is missing while computing the parameter. As a result, 3/4 of the memory will have undefined values during the vector addition.", "keywords": []}, {"id": 33, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#name-demangling", "display_name": "Name Demangling", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "name-demangling", "priority": -1, "content": "The Compute Sanitizer suite supports displaying mangled and demangled names for CUDA kernels and CUDA device functions. By default, tools display the fully demangled name, which contains the name of the kernel as well as its prototype information. In the simple demangle mode, the tools will only display the first part of the name. If demangling is disabled, tools will display the complete mangled name of the kernel.", "keywords": []}, {"id": 34, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#nonblocking-mode", "display_name": "Nonblocking Mode", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "nonblocking-mode", "priority": -1, "content": "By default, the standalone Compute Sanitizer tool will launch kernels in nonblocking mode. This allows the tool to support error reporting in applications running concurrent kernels To force kernels to execute serially, a user can use the --force-blocking-launches option. One side effect is that when in blocking mode, only the first thread to hit an error in a kernel will be reported. Also, using this option or --force-synchronization-limit will disable CUDA reduced API serialization.", "keywords": []}, {"id": 35, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#operating-system-specific-behavior", "display_name": "Operating System Specific Behavior", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "operating-system-specific-behavior", "priority": -1, "content": "This section describes operating system specific behavior.", "keywords": []}, {"id": 36, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#optix-support", "display_name": "OptiX support", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "optix-support", "priority": -1, "content": "Starting from CUDA 11.6, the compute-sanitizer tool support OptiX 7 applications with memcheck and initcheck. The option --check-optix needs to be set for optix launches to be tracked with initcheck. To get full device backtrace information, please make sure your OptiX modules are compiled with OPTIX_COMPILE_DEBUG_LEVEL_FULL set in the debugLevel field in the OptixModuleCompileOptions structure. When using compute-sanitizer on OptiX applciations, it is possible that some or all device frames are located in OptiX internal code. Such frames have their name displayed as NVIDIA Internal . See the example below of an error reported in user code called from an internal OptiX function: ========= Invalid __global__ write of size 1 bytes ========= at __raygen__placeholder_0x67b9a77bb7822a34+0x19b0 in /home/cuda/optixApp.cu:70 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x7f91edf00403 is out of bounds ========= and is 262,132 bytes after the nearest allocation at 0x7f91edec0400 of size 16 bytes ========= Device Frame:NVIDIA Internal [0x520] ========= Saved host backtrace up to driver entry point at kernel launch time [...] Starting from CUDA 11.7, it is possible to detect leaks of OptixModule , optixPipeline , optixProgramGroup and optixDenoiser with compute-sanitizer. This requires using the --check-optix-leaks option. Leaks will only reported if the OptixDeviceContext is destroyed with a call to OptixDeviceContextDestroy . OptixDeviceContext that are leaking will have their associated CUDA buffers reported with a regular use of --leak-check full . See the example below of an optixProgramGroup that was not destroyed being reported: ========= Leaked an OptixProgramGroup with handle 0x55dbffbd9840 ========= Saved host backtrace up to driver entry point at allocation time [...] The following feature set is supported per OptiX API version: OptiX API Version Kernel checks Resource leak check 7.0 - 9.0 Yes Yes", "keywords": []}, {"id": 37, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#padding", "display_name": "Padding", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "padding", "priority": -1, "content": "The memcheck tool can automatically add padding to memory allocations in order to improve out of bounds error detection for global memory. By default, global memory buffers can be allocated back-to-back in the virtual address space. When that happens, an overflow access into the first buffer will simply happen in the second buffer and not be detected as out-of-bounds. Using the --padding option will automatically extend the allocation size, effectively creating a padding buffer after each allocation. This improves the out of bounds error detection as accesses to the padding area will always be considered invalid. The example below displays possible buffer addresses when using --padding 32 . Every allocation is followed by a 32 bytes padding buffer. Writing or reading this buffer will cause an out-of-bounds access to be reported. This option supports allocations created via the cudaMalloc APIs, cudaHostAlloc and cudaMallocHost . This option does not support allocations created via cudaHostRegister or the CUDA virtual memory management APIs. Be aware that using this option will result in an increased device memory pressure, potentially causing additional CUDA out of memory errors.", "keywords": []}, {"id": 38, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-cluster-entry-and-exit-race-detection", "display_name": "Racecheck cluster entry and exit race detection", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-cluster-entry-and-exit-race-detection", "priority": -1, "content": "Racecheck supports race detection on remote shared memory accesses without appropriate cluster-wide synchronization. When a kernel makes a remote shared memory access from one block to another (in the same cluster), it needs to guarantee that the target block exists, otherwise error cudaErrorLaunchFailure is raised. One way to achieve this is using cluster.sync() from the Cluster Group API . Refer to the CUDA documentation about distributed shared memory for more information. When running a program under Racecheck, instead of failing, the tool will report these two types of illegal accesses: Late entry race detection: a block is trying to access shared memory from another block in the cluster without an appropriate cluster-wide synchronization beforehand. Early exit race detection: a block is trying to access shared memory from another block in the cluster without an appropriate cluster-wide synchronization before the target block exits. A sample report for both races is below: ========= Potential invalid __shared__ read of size 4 bytes ========= at RemoteAccess(int *, int)+0x170 in RaceCluster.cu:10 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x1000400 is located in a block that might not have entered yet ========= ========= Potential invalid __shared__ read of size 4 bytes ========= at RemoteAccess(int *, int)+0x170 in RaceCluster.cu:10 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x1000400 is located in a block that might have already exited =========", "keywords": []}, {"id": 39, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-deadlock-detection", "display_name": "Racecheck Deadlock Detection", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-deadlock-detection", "priority": -1, "content": "Racecheck supports the detection of some types of deadlocks. To enable this feature, use the --racecheck-deadlock-timeout n option together with the Racecheck tool. Here, n is the number of milliseconds after which the deadlock detection is triggered. The default value is 0, which means that deadlock detection is disabled. Very small values of n may lead to false positives. If you experience false positives, try increasing the value of n . Currently, deadlock detection is supported for: cuda::barriers When a deadlock is detected, the tool prints a message similar to the following: ========= Deadlock detected in Cuda::barrier wait called by threads starting at (0,0,0) in block (0,0,0), (active mask: 0xffffffff), barrier address: 0x0 at kernel+0x1190 in app.cu:98 There is also an option to terminate an application upon deadlock. To enable this feature, use the --racecheck-continue-on-deadlock no option together with enabled deadlock detection and the Racecheck tool.", "keywords": []}, {"id": 40, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-report-modes", "display_name": "Racecheck Report Modes", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-report-modes", "priority": -1, "content": "The racecheck tool can produce two types of output: Hazard reports These reports contain detailed information about one particular hazard. Each hazard report is byte accurate and represents information about conflicting accesses between two threads that affect this byte of shared memory. Analysis reports These reports contain a post analysis set of reports. These reports are produced by the racecheck tool by analysing multiple hazard reports and examining active device state. For example usage of analysis reports, see Understanding Racecheck Analysis Reports .", "keywords": []}, {"id": 41, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-severity-levels", "display_name": "Racecheck Severity Levels", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-severity-levels", "priority": -1, "content": "Problems reported by racecheck can be of different severity levels. Depending on the level, different actions are required from developers. By default, only issues of severity level WARNING and ERROR are shown. The command line option --print-level can be used to set the lowest severity level that should be reported. Racecheck reports have one of the following severity levels: INFO: The lowest level of severity. This is for hazards that have no impact on program execution and hence are not contributing to data access hazards. It is still a good idea to find and eliminate such hazards. WARNING: Hazards at this level of severity are determined to be programming model hazards, however may be intentionally created by the programmer. An example of this are hazards due to warp level programming that make the assumption that threads are proceeding in groups. Such hazards are typically only encountered by advanced programmers. In cases where a beginner programmer encounters such errors, he should treat them as sources of hazards. ERROR : The highest level of severity. This corresponds to hazards that are very likely candidates for causing data access races. Programmers would be well advised to examine errors at this level of severity. On modern GPU architectures, programmers cannot rely on the assumption that threads within a warp execute in lock-step unconditionally. This assumption used to be true on legacy GPU code (pre-Volta architectures, like Kepler, Maxwell and Pascal). As a result, warnings due to warp-synchronous programming without explicit synchronization must be fixed when developing or porting applications from pre-Volta architectures to newer ones. Developers can use the __syncwarp() intrinsic or the Cooperative Groups API.", "keywords": []}, {"id": 42, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-support-for-asynchronous-copy", "display_name": "Racecheck support for asynchronous copy", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-support-for-asynchronous-copy", "priority": -1, "content": "Racecheck supports race detection on shared memory for asynchronous memory copy operations from global to shared memory introduced in compute capability 8.0. These can take the form of CUDA C++ cuda::memcpy_async or the PTX cp.async . Specifically, racecheck is able to detect when the target of a asynchronous copy tracked by a pipeline (CUDA C++) or async-group (PTX) was accessed before the required commit/wait to guarantee its completion. In these cases, individual hazards when using --racecheck-report hazard will bear the mention (invalid memcpy_async synchronization) . These checks can be disabled by using --racecheck-memcpy-async no .", "keywords": []}, {"id": 43, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-support-for-cuda-barrier", "display_name": "Racecheck support for cuda::barrier", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-support-for-cuda-barrier", "priority": -1, "content": "Racecheck supports synchronization through cuda::barrier on Ampere GPUs and newer. The number of barriers tracked by the tool is based on the number of barriers present in the source code as reported by compiler information. In some cases, the compiler may undercount this number. Racecheck will report the following warning if more barriers are used than expected: ========= Warning: Detected overflow of tracked cuda::barrier structures. Results might be incorrect. Try using --num-cuda-barriers to fix the issue The --num-cuda-barriers option can be used to indicate the number of expected barriers in the source code and workaround this issue.", "keywords": []}, {"id": 44, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#racecheck-synchronization-tracing", "display_name": "Racecheck synchronization tracing", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "racecheck-synchronization-tracing", "priority": -1, "content": "Racecheck supports logging of synchronization operations primarily to aid in debugging synchronization issues. To enable this feature, use the --racecheck-trace-sync yes option together with the Racecheck tool. Note: Turning on the --racecheck-trace-sync option automatically sets the reported severity level to INFO. See Racecheck Severity Levels . Currently, the logging of the following synchronization operations is supported: syncwarp barrier cuda::barrier cluster barrier asynchronous bulk copy A general form of a log entry is as follows: ========= Barrier called by threads starting at (32,0,0) in block (1,0,0), (active mask: 0xffffffff) at kernel()+0x2b0 in app.cu:36 It consists of the type of instruction, a set of threads executing the instruction (this is the combination of the starting thread index, block index, and active thread mask), and the call site. Different instruction types may have different sets of extra information. For example, for cuda::barrier , the barrier address is also printed. In the case of syncwarp , the format differs significantly: ========= Syncwarp called by threads starting at (0,0,0) in block (0,0,0), (active mask: 0xffff0000) at kernel()+0x3c0 in app.cu:42 ========= Sync mask of thread 16: 0xffff0000 ========= Sync mask of thread 17: 0xffff0000 ========= Sync mask of thread 18: 0xffff0000 ========= Sync mask of thread 19: 0xffff0000 ========= Sync mask of thread 20: 0xffff0000 ========= Sync mask of thread 21: 0xffff0000 ========= Sync mask of thread 22: 0xffff0000 ========= Sync mask of thread 23: 0xffff0000 ========= Sync mask of thread 24: 0xffff0000 ========= Sync mask of thread 25: 0xffff0000 ========= Sync mask of thread 26: 0xffff0000 ========= Sync mask of thread 27: 0xffff0000 ========= Sync mask of thread 28: 0xffff0000 ========= Sync mask of thread 29: 0xffff0000 ========= Sync mask of thread 30: 0xffff0000 ========= Sync mask of thread 31: 0xffff0000 Here, besides the usual information, the mask of each thread is printed. This type of information is useful for debugging syncwarp hangs caused by an incorrect mask or missing thread.", "keywords": []}, {"id": 45, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#specifying-filters", "display_name": "Specifying Filters", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "specifying-filters", "priority": -1, "content": "Compute Sanitizer tools support filtering the choice of kernels which should be checked. When a filter is specified, only kernels matching the filter will be checked. Filters are specified using the --kernel-name and --kernel-name-exclude options. By default, the Compute Sanitizer tools will check all kernels in the application. The --kernel-name and --kernel-name-exclude options can be specified multiple times. If a kernel satisfies any filter, it will be checked by the running the Compute Sanitizer tool. The --kernel-name and --kernel-name-exclude options take a filter specification consisting of a list of comma separated key value pairs, specified as key=value . When using the regex filter key, multiple key value pairs need to be specified through multiple use of the option instead. In order for a filter to be matched, all components of the filter specification must be satisfied. If a filter is incorrectly specified in any component, the entire filter is ignored. For a full summary of valid key values, see the table below. If a key has multiple strings, any of the strings can be used to specify that filter component. Name Key String Value Comments Kernel Name kernel_name, kne Complete mangled kernel name User specifies the complete mangled kernel name. Kernel Substring kernel_substring, kns Any substring in mangled kernel name User specifies a substring in the mangled kernel name. Regex regex Any regex that can be matched in a substring of the mangled kernel name User specifies a regular expression searched in the mangled kernel name. When using the kernel-name filters, the Compute Sanitizer tools will check all device function calls made by the kernel. When using CUDA Dynamic Parallelism (CDP), the Compute Sanitizer tools will not check child kernels launched from a checked kernel unless the child kernel matches a filter. If a GPU launched kernel that does not match a filter calls a device function that is reachable from a kernel that does match a filter, the device function behaves as though it was checked. In the case of some tools, this can result in undefined behavior. Filter usage example We consider an application that launches three different kernels declared below. __global__ void gamma(int *bufer); __global__ void delta(int *bufer); __global__ void epsilon(int *bufer); Their respective mangled names are _Z5gammaPi , _Z5deltaPi and _Z7epsilonPi . We only want to check the launches of the kernel epsilon. Here are different means to achieve it: compute-sanitizer --kernel-name kne=_Z7epsilonPi Only epsilon is matching the specified filter, so only kernel launches of epsilon will be checked. compute-sanitizer --kernel-name kns=epsilon Since \u201cepsilon\u201d is a substring of \u201c_Z7epsilonPi\u201d, and also happens to be the only kernel having this substring in its mangled name, only epsilon will be matched and checked. compute-sanitizer --kernel-name-exclude kns=delta,kne=_Z5gammaPi This time, we are using the exclude options. Only epsilon is not matched by the exclude option in this scenario, which means it will be the only one checked. We specified multiple filter separating them with a comma: this can be used with both kernel-name and kernel-name-exclude . compute-sanitizer --kernel-name-exclude kns=delta --kernel-name-exclude kne=_Z5gammaPi Same as above, except we used the exclude option twice to specify multiple filters instead of specifying them all at once. If needed, kernel-name and kernel-name-exclude can be used at the same time. compute-sanitizer --kernel-name regex=&#x27;[a-z]{7}&#x27; For this example we are using the regex filter. It matches any kernel for which the regular expression can be matched anywhere inside the mangle named. The specified regex matches any 7 consecutive lowercase letter. Only _Z7epsilonPi has 7 consecutive lowercase letter, and therefore is the only kernel matched by --kernel-name .", "keywords": []}, {"id": 46, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#stack-backtraces", "display_name": "Stack Backtraces", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "stack-backtraces", "priority": -1, "content": "Compute Sanitizer can generate backtraces when given --show-backtrace option. Backtraces usually consist of two sections \u2013 a saved host backtrace that leads up to the CUDA driver call site, and a device backtrace at the time of the error. Each backtrace contains a list of frames showing the state of the stack at the time the backtrace was created. To get function names in the host backtraces, the user application must be built with support for symbol information in the host application. For more information, see Compilation Options Backtraces are printed for most Compute Sanitizer tool outputs, and the information generated varies depending on the type of output. The table below explains the kind of host and device backtrace seen under different conditions. Output Type Host Backtrace Device Backtrace Memory access error Kernel launch on host Precise backtrace on device Hardware exception Kernel launch on host Imprecise backtrace on device 1 Malloc/Free error Kernel launch on host Precise backtrace on device cudaMalloc allocation leak Callsite of cudaMalloc N/A CUDA API error Callsite of CUDA API call N/A Compute Sanitizer internal error Callsite leading to internal error N/A Device heap allocation leak N/A N/A Shared memory hazard Kernel launch on host N/A Note that for OptiX applications, the name of OptiX internal device functions will be displayed as \u201cNVIDIA Internal\u201d. 1 In some cases, there may be no device backtrace", "keywords": []}, {"id": 47, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#stream-ordered-race-detection", "display_name": "Stream-ordered race detection", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "stream-ordered-race-detection", "priority": -1, "content": "The memcheck tool can detect stream-ordered allocations races using the --track-stream-ordered-races all option. It will report accesses to stream-ordered allocations used outside of their lifespan. The tool is capable of detecting 2 types of races: Use-before-alloc races ( --track-stream-ordered-races use-before-alloc ) This race occurs when an allocation is used before it is available: an allocation created using cudaMallocAsync on a stream cannot be used on another stream without a prior synchronization event after the allocation. It also includes cases where an allocation is freed before it is available using cudaFreeAsync . Use-after-free races ( --track-stream-ordered-races use-after-free ) This race occurs when an allocation is used after it is freed: an allocation freed using cudaFreeAsync on a stream cannot be used on another stream without a following synchronization event before the free.", "keywords": []}, {"id": 48, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#supported-error-detection", "display_name": "Supported Error Detection", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "supported-error-detection", "priority": -1, "content": "The errors that can be reported by the memcheck tool are summarized in the table below. The location column indicates whether the report originates from the host or from the device. The precision of an error is explained in the paragraph below. Name Description Location Precision See also Memory access error Errors due to out of bounds or misaligned accesses to memory by a global, local, shared or global atomic access. Device Precise Hardware exception Errors that are reported by the hardware error reporting mechanism. Device Imprecise Malloc/Free errors Errors that occur due to incorrect use of malloc()/free() in CUDA kernels. Device Precise Device Side Allocation Checking CUDA API errors Reported when a CUDA API call in the application returns a failure. Host Precise CUDA API Error Checking cudaMalloc memory leaks Allocations of device memory using cudaMalloc() that have not been freed by the application. Host Precise Leak Checking Device Heap Memory Leaks Allocations of device memory using malloc() in device code that have not been freed by the application. Device Imprecise Device Side Allocation Checking The memcheck tool reports two classes of errors precise and imprecise. Precise errors in memcheck are those that the tool can uniquely identify and gather all information for. For these errors, memcheck can report the block and thread coordinates of the thread causing the failure, the program counter (PC) of the instruction performing the access, as well as the address being accessed and its size and type. If the CUDA application contains line number information (by either being compiled with device side debugging information, or with line information), then the tool will also print the source file and line number of the erroneous access. Imprecise errors are errors reported by the hardware error reporting mechanism that could not be precisely attributed to a particular thread. The precision of the error varies based on the type of the error and in many cases, memcheck may not be able to attribute the cause of the error back to the source file and line.", "keywords": []}, {"id": 49, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#synccheck-support-for-cuda-barrier", "display_name": "Synccheck support for cuda::barrier", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "synccheck-support-for-cuda-barrier", "priority": -1, "content": "Synccheck supports synchronization through cuda::barrier on Ampere GPUs and newer. The number of barriers tracked by the tool is based on the number of barriers present in the source code as reported by compiler information. In some cases, the compiler may undercount this number. Synccheck will report the following warning if more barriers are used than expected: ========= Warning: Detected overflow of tracked cuda::barrier structures. Results might be incorrect. Try using --num-cuda-barriers to fix the issue The --num-cuda-barriers option can be used to indicate the number of expected barriers in the source code and workaround this issue.", "keywords": []}, {"id": 50, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#synccheck-support-for-wgmma", "display_name": "Synccheck support for wgmma", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "synccheck-support-for-wgmma", "priority": -1, "content": "Synccheck supports additional checks related to PTX wgmma instructions for Hopper sm_90a architecture. wgmma instructions are executed across a warpgroup . Each warp in the warpgroup are expected to execute the same wgmma instructions in the same order with the same predicates, with all threads active or none. Synccheck can detect and report cases where these rules are not respected, and will exit the entire warpgroup when detected. In such cases, the report will start with \u201cWarpgroup MMA sequence error detected\u201d instead of \u201cBarrier error detected\u201d, followed by a description of the specific error encountered. The error is reported once per warp encountering the error. The --check-warpgroup-mma option can be used to enable or disable these checks.", "keywords": []}, {"id": 51, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#tensor-core-mma-guardrails", "display_name": "Tensor Core MMA guardrails", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "tensor-core-mma-guardrails", "priority": -1, "content": "On Blackwell GPUs, if a program is using the PTX Tensor Core 5th generation family instructions ( tcgen05.* ), the PTX optimizing assembler can be instructed to insert guardrails around TCMMA instructions using PTXAS flag -g-tmem-access-check . Running a program with TCMMA guardrails enabled under compute-sanitizer\u2019s memcheck will lead the tool to report any invalid TCMMA operation, such as an out-of-bounds or misaligned access to tensor memory, or allocation after call to relinquish. Example of TCMMA error reported by memcheck: ========= Tensor Memory column 32 being accessed by instruction tcgen05.ld is not allocated. Columns allocated are: 0-31. ========= at $__internal_8_$__cuda_sm10x_tcgen05_guardrail_trap_unallocated_columns_access+0x1250 in TcmmaGuardrails.cu:99 ========= by thread (0,0,0) in block (0,0,0)", "keywords": []}, {"id": 52, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#understanding-memcheck-errors", "display_name": "Understanding Memcheck Errors", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "understanding-memcheck-errors", "priority": -1, "content": "The memcheck tool can produce a variety of different errors. This is a short guide showing some samples of errors and explaining how the information in each error report can be interpreted. Memory access error: Memory access errors are generated for errors that the memcheck tool can correctly attribute and identify the erroneous instruction. Below is an example of a precise memory access error. ========= Invalid __global__ write of size 4 bytes ========= at unaligned_kernel():0x160 in memcheck_demo.cu:6 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x7f6510c00001 is misaligned Let us examine this error line by line: Invalid __global__ write of size 4 bytes The first line shows the memory segment, type and size being accessed. The memory segment is one of: __global__ : for device global memory __shared__ : for per block shared memory __local__ : for per thread local memory In this case, the access was to device global memory. The next field contains information about the type of access, whether it was a read or a write. In this case, the access is a write. Finally, the last item is the size of the access in bytes. In this example, the access was 4 bytes in size. at unaligned_kernel():0x160 in memcheck_demo.cu:6 The second line contains the CUDA kernel name, offset of the instruction, the source file and line number (if available). In this example, the instruction causing the access was at offset 0x160 inside the unaligned_kernel CUDA kernel. Additionally, since the application was compiled with line number information, this instruction corresponds to line 6 in the memcheck_demo.cu source file. by thread (0,0,0) in block (0,0,0) The third line contains the thread indices and block indices of the thread on which the error was hit. In this example, the thread doing the erroneous access belonged to the first thread in the first block. Address 0x7f6510c00001 is misaligned The fourth line contains the memory address being accessed and the type of access error. The type of access error can either be out of bounds access or misaligned access. In this example, the access was to address 0x7f6510c00001 and the access error was because this address was not aligned correctly. Hardware exception: Imprecise errors are generated for errors that the hardware reports to the memcheck tool. Hardware exceptions have a variety of formats and messages. Typically, the first line will provide some information about the type of error encountered. Malloc/free error: Malloc/free errors refer to the errors in the invocation of device side malloc()/free() in CUDA kernels. An example of a malloc/free error: ========= Malloc/Free error encountered : Double free ========= at 0x79d8 ========= by thread (0,0,0) in block (0,0,0) ========= Address 0x400aff920 We can examine this line by line. Malloc/Free error encountered : Double free The first line indicates that this is a malloc/free error, and contains the type of error. This type can be: Double free \u2013 This indicates that the thread called free() on an allocation that has already been freed. Invalid pointer to free \u2013 This indicates that free was called on a pointer that was not returned by malloc() . Heap corruption : This indicates generalized heap corruption, or cases where the state of the heap was modified in a way that memcheck did not expect. In this example, the error is due to calling free() on a pointer which had already been freed. at 0x79d8 The second line gives the PC on GPU where the error was reported. This PC is usually inside of system code, and is not interesting to the user. The device frame backtrace will contain the location in user code where the malloc()/free() call was made. by thread (0,0,0) in block (0,0,0) The third line contains the thread and block indices of the thread that caused this error. In this example, the thread has threadIdx = (0,0,0) and blockIdx = (0,0,0) Address 0x400aff920 This line contains the value of the pointer passed to free() or returned by malloc() Leak errors: Errors are reported for allocations created using cudaMalloc and for allocations on the device heap that were not freed before their associated CUDA context was destroyed (i.e. program exit, cudaDeviceReset() or CUDA driver API call to cuCtxDestroy() ). An example of a cudaMalloc allocation leak report is the following: ========= Leaked 64 bytes at 0x400200200 The error message reports information about the size of the allocation that was leaked as well as the address of the allocation on the device. A device heap leak message will be explicitly identified as such: ========= Leaked 16 bytes at 0x4012ffff6 on the device heap CUDA API error: CUDA API errors are reported for CUDA API calls that return an error value. An example of a CUDA API error: ========= Program hit invalid copy direction for memcpy (error 21) on CUDA API call to cudaMemcpy. The message contains the returned value of the CUDA API call, as well as the name of the API function that was called.", "keywords": []}, {"id": 53, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#understanding-racecheck-analysis-reports", "display_name": "Understanding Racecheck Analysis Reports", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "understanding-racecheck-analysis-reports", "priority": -1, "content": "In analysis reports, the racecheck tool produces a series of high-level messages that identify the source locations of a particular race, based on observed hazards and other machine state. A sample racecheck analysis report is below: ========= WARNING: Race reported between Write access at RAW()+0xf0 in raceGroupBasic.cu:40 ========= and Read access at RAW()+0x280 in raceGroupBasic:46 [4 hazards] The analysis record contains high-level information about the hazard that is conveyed to the end user. Each line contains information about a unique location in the application which is participating in the race. The first word on the first line indicates the severity of this report. In this case, the message is at the WARNING level of severity. For more information on the different severity levels, see Racecheck Severity Levels . Analysis reports are composed of one or more racecheck hazards, and the severity level of the report is that of the hazard with the highest severity. The first line additionally contains the type of access. The access can be either: Read Write The next item on the line is the name of the kernel issuing the access and the offset of the location where the access happened from. In this case, the offset is 0xf0 in the RAW() kernel. If the application was compiled with line number information, this line also contains the file name and line number of the access. The next lines contain the location of the other offsets participating in the race condition. In this case, there is only one other location which is the RAW() kernel at offset 0x280. Similarly to the first line, file name and line number are printed if the application was compiled with line number information. Finally, the line also contains the number of hazards detected for this specific race condition. A given analysis report will always contain at least one line which is performing a write access. A common strategy to eliminate races which contain only write accesses is to ensure that the write access is performed by only one thread. In the case of races with multiple readers and one writer, introducing explicit program ordering via a __syncthreads() call can avoid the race condition. For races between threads within the same warp, the __syncwarp() intrinsic can be used to avoid the hazard.", "keywords": []}, {"id": 54, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#understanding-racecheck-hazard-reports", "display_name": "Understanding Racecheck Hazard Reports", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "understanding-racecheck-hazard-reports", "priority": -1, "content": "In hazard reporting mode, the racecheck tool produces a series of messages detailing information about hazards in the application. The tool is byte accurate and produces a message for each byte on which a hazard was detected. Additionally, when enabled, the host backtrace for the launch of the kernel will also be displayed. A sample racecheck hazard is below: ========= ERROR: Potential WAW hazard detected at __shared__ 0x0 in block (0,0,0) : ========= Write Thread (0,0,0) at WAW()+0x2f0 in raceWAW.cu:20 ========= Write Thread (1,0,0) at WAW()+0x2f0 in raceWAW.cu:20 ========= Current Value : 1, Incoming Value : 2 The hazard records are dense and capture a lot of interesting information. In general terms, the first line contains information about the hazard severity, type and address, as well as information about the thread block where it occurred. The next 2 lines contain detailed information about the two threads that were in contention. These two lines are ordered chronologically, so the first entry is for the access that occurred earlier and the second for the access that occurred later. The final line is printed for some hazard types and captures the actual data that was being written. Examining this line by line, we have : ERROR: Potential WAW hazard detected at __shared__ 0x0 in block (0, 0, 0) The first word on this line indicates the severity of this hazard. In this case, the message is at the ERROR level of severity. For more information on the different severity levels, see Racecheck Severity Levels . The next piece of information here is the type of hazard. The racecheck tool detects three types of hazards: WAW or Write-After-Write hazards WAR or Write-After-Read hazards RAW or Read-After-Write hazards The type of hazard indicates the accesses types of the two threads that were in contention. In this example, the hazard is of Write-After-Write type. The next piece of information is the address in shared memory that was being accessed. This is the offset in per block shared memory that was being accessed by both threads. Since the racecheck tool is byte accurate, the message is only for the byte of memory at given address. In this example, the byte being accessed is byte 0x0 in shared memory. Finally, the first line contains the block index of the thread block to which the two racing threads belong. The second line contains information about the first thread to write to this location. Write Thread (0, 0, 0) at WAW()+0x2f0 in raceWAW.cu:20(void) The first item on this line indicates the type of access being performed by this thread to the shared memory address. In this example, the thread was writing to the location. The next component is the index of the thread block. In this case, the thread is at index (0,0,0). Following this, we have the name of the kernel and byte offset of the instruction which did the access in the kernel. In this example, the offset is 0x2f0. This is followed by the source file and line number (if line number information is available). The third line contains similar information about the second thread that was causing this hazard. This line has an identical format to the previous line. The fourth line contains information about the data in the two accesses. Current Value : 1, Incoming Value : 2 If the second thread in the hazard was performing a write access, i.e., the hazard is a Write-After-Write (WAW) or a Write-After-Read (WAR), this line contains the value after the access by the first thread as the Current Value and the value that will be written by the second access as the Incoming Value. In this case, the first thread wrote the value 1 to the shared memory location. The second thread is attempting to write the value 2.", "keywords": []}, {"id": 55, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#understanding-synccheck-reports", "display_name": "Understanding Synccheck Reports", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "understanding-synccheck-reports", "priority": -1, "content": "For each violation, the synccheck tool produces a report message that identifies the source location of the violation and its classification. A sample synccheck report is below: ========= Barrier error detected. Divergent thread(s) in warp ========= at ThreadDivergence(int *, int)+0xf0 in divergence.cu:79 ========= by thread (37,0,0) in block (0,0,0) Each report starts with \u201cBarrier error detected.\u201d In most cases, this is followed by a classification of the detected barrier error. In this message, a CUDA block with divergent threads was found. The following error classes can be reported: Divergent thread(s) in block: Divergence between threads within a block was detected for a barrier that does not support this on the current architecture. For example, this occurs when __syncthreads() is used within conditional code but the conditional does not evaluate equally across all threads in the block. Divergent thread(s) in warp: Divergence between threads within a single warp was detected for a barrier that does not support this on the current architecture. Invalid arguments: A barrier instruction or primitive was used with invalid arguments. This can occur for example if not all threads reaching a __syncwarp() declare themselves in the mask parameter. However, synccheck will not detect cases where not all the threads declared in the mask parameter reach the __syncwarp() . The next line states the offset within the function of the location where the access happened. In this case, the offset is 0xf0. If the application was compiled with line number information, this line would also contain the file name and line number of the access, followed by the name of the kernel issuing the access. The third line contains information on the thread and block for which this violation was detected. In this case, it is thread 37 in block 0.", "keywords": []}, {"id": 56, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#unused-memory-detection", "display_name": "Unused memory detection", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "unused-memory-detection", "priority": -1, "content": "The initcheck tool can also be used to detect unused memory by using the --track-unused-memory option. compute-sanitizer --tool initcheck --track-unused-memory app_name [app_options] A sample unused memory report is below: ========= Unused memory in allocation 0x7fed9f400000 of size 100 bytes ========= Not written 80 bytes at offset 0x14 (0x7fed9f400014) ========= 80% of allocation were unused. This report contains the address and size of the allocation, the number of bytes not used and their location. The location can be a range if all unused bytes are not contiguous. The behavior for this feature can be adjusted with the --unused-memory-threshold option which takes the minimum percentage at which reports should be printed. For instance, using a value of 81 or above would silence the sample report above.", "keywords": []}, {"id": 57, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#using-initcheck", "display_name": "Using Initcheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "using-initcheck", "priority": -1, "content": "The initcheck tool is enabled by running the Compute Sanitizer application with the --tool initcheck option. compute-sanitizer --tool initcheck [sanitizer_options] app_name [app_options] The initcheck tool does not perform any memory access error checking. It is recommended that users first run the memcheck tool to ensure the application is free of errors.", "keywords": []}, {"id": 58, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#using-memcheck", "display_name": "Using Memcheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "using-memcheck", "priority": -1, "content": "The memcheck tool is enabled by default when running the Compute Sanitizer application. It can also be explicitly enabled by using the --tool memcheck option. compute-sanitizer --tool memcheck [sanitizer_options] app_name [app_options] When run in this way, the memcheck tool will look for precise, imprecise, malloc/free and CUDA API errors. The reporting of device leaks must be explicitly enabled. Errors identified by the memcheck tool are displayed on the screen after the application has completed execution. See Understanding Memcheck Errors for more information about how to interpret the messages printed by the tool.", "keywords": []}, {"id": 59, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#using-racecheck", "display_name": "Using Racecheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "using-racecheck", "priority": -1, "content": "The racecheck tool is enabled by running the Compute Sanitizer application with the --tool racecheck option. compute-sanitizer --tool racecheck [sanitizer_options] app_name [app_options] Once racecheck has identified a hazard, the user can make program modifications to ensure this hazard is no longer present. In the case of Write-After-Write hazards, the program should be modified so that multiple writes are not happening to the same location. In the case of Read-After-Write and Write-After-Read hazards, the reading and writing locations should be deterministically ordered. In CUDA kernels, this can be achieved by inserting a __syncthreads() call between the two accesses. To avoid races between threads within a single warp, __syncwarp() can be used. Note: The racecheck tool does not perform any memory access error checking. It is recommended that users first run the memcheck tool to ensure the application is free of errors.", "keywords": []}, {"id": 60, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#using-synccheck", "display_name": "Using Synccheck", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "using-synccheck", "priority": -1, "content": "The synccheck tool is enabled by running the Compute Sanitizer application with the --tool synccheck option. compute-sanitizer --tool synccheck [sanitizer_options] app_name [app_options] The synccheck tool does not perform any memory access error checking. It is recommended that users first run the memcheck tool to ensure the application is free of errors.", "keywords": []}, {"id": 61, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#using-the-compute-sanitizer-on-jetson-and-tegra-devices", "display_name": "Using the Compute Sanitizer on Jetson and Tegra devices", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "using-the-compute-sanitizer-on-jetson-and-tegra-devices", "priority": -1, "content": "By default, on Jetson and Drive Tegra devices, GPU debugging is supported only if compute-sanitizer is launched by a user who is a member of the debug group. To add the current user to the debug group run this command: sudo usermod -a -G debug $USER", "keywords": []}, {"id": 62, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#warp-level-hazards", "display_name": "Warp-level Hazards", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "warp-level-hazards", "priority": -1, "content": "The application can be found on the compute-sanitizer github repository This application can be compiled using the provided Makefile: make dbg=1 The kernel computes the some of all individual elements in shared memory two stages. First, each thread computes its local shared memory value in smem_first . Second, a single thread of each warp is chosen with if (tx % WARP_SIZE == 0) to sum all elements written by its warp, indexed wx , and store the result in smem_second . Finally, thread 0 of the kernel computes the sum of elements in smem_second and writes the value into global memory. Running this application under the racecheck tool with the --racecheck-report hazard option, multiple hazards with WARNING severity are reported: ========= Warning: (Warp Level Programming) Potential RAW hazard detected at __shared__ 0x8c in block (0,0,0) : ========= Write Thread (35,0,0) at sumKernel(int *, int *)+0x90 in /home/cuda/github/compute-sanitizer-samples/Racecheck/warp_error.cu:44 ========= Read Thread (32,0,0) at sumKernel(int *, int *)+0x120 in /home/cuda/github/compute-sanitizer-samples/Racecheck/warp_error.cu:56 ========= Current Value : 35 To avoid the errors demonstrated in the Block-level Hazards example, the kernel uses the block-level barrier __syncthreads() in line 60. However, racecheck still reports read-after-write (RAW) hazards between threads within the same warp, with severity WARNING. In this specific example, there is a race condition on access to shared memory variable smem_first : the memory read at line 56 on thread 32 could be executed before the memory write to on thread 35 at line 44, as there is no synchronization between the two operations. Programmers can use __syncwarp() warp-wide barrier to avoid such hazards. This barrier should be inserted at line 45.", "keywords": []}, {"id": 63, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#what-are-hazards", "display_name": "What are Hazards?", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "what-are-hazards", "priority": -1, "content": "A data access hazard is a case where two threads attempt to access the same location in memory resulting in non-deterministic behavior, based on the relative order of the two accesses. These hazards cause data races where the behavior or the output of the application depends on the order in which all parallel threads are executed by the hardware. Race conditions manifest as intermittent application failures or as failures when attempting to run a working application on a different GPU. The racecheck tool identifies three types of canonical hazards in a program. These are : Write-After-Write (WAW) hazards This hazard occurs when two threads attempt to write data to the same memory location. The resulting value in that location depends on the relative order of the two accesses. Write-After-Read (WAR) hazards This hazard occurs when two threads access the same memory location, with one thread performing a read and another a write. In this case, the writing thread is ordered before the reading thread and the value returned to the reading thread is not the original value at the memory location. Read-After-Write (RAW) hazards This hazard occurs when two threads access the same memory location, with one thread performing a read and the other a write. In this case, the reading thread reads the value before the writing thread commits it.", "keywords": []}, {"id": 64, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#what-is-initcheck", "display_name": "What is Initcheck?", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "what-is-initcheck", "priority": -1, "content": "The initcheck tool is a run time uninitialized device global memory access detector. This tool can identify when device global memory is accessed without it being initialized via device side writes, or via CUDA memcpy and memset API calls. Currently, this tool only supports detecting accesses to device global memory.", "keywords": []}, {"id": 65, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#what-is-memcheck", "display_name": "What is Memcheck?", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "what-is-memcheck", "priority": -1, "content": "The memcheck tool is a run time error detection tool for CUDA applications. The tool can precisely detect and report out of bounds and misaligned memory accesses to global, local and shared memory in CUDA applications. It can also detect and report hardware reported error information. In addition, the memcheck tool can detect and report memory leaks in the user application.", "keywords": []}, {"id": 66, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#what-is-racecheck", "display_name": "What is Racecheck?", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "what-is-racecheck", "priority": -1, "content": "The racecheck tool is a run time shared memory data access hazard detector. The primary use of this tool is to help identify memory access race conditions in CUDA applications that use shared memory. In CUDA applications, storage declared with the __shared__ qualifier is placed on chip shared memory. All threads in a thread block can access this per block shared memory. Shared memory goes out of scope when the thread block completes execution. As shared memory is on chip, it is frequently used for inter-thread communication and as a temporary buffer to hold data being processed. As this data is being accessed by multiple threads in parallel, incorrect program assumptions may result in data races. Racecheck is a tool built to identify these hazards and help users write programs free of shared memory races. Currently, this tool only supports detecting accesses to on-chip shared memory.", "keywords": []}, {"id": 67, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#what-is-synccheck", "display_name": "What is Synccheck?", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "what-is-synccheck", "priority": -1, "content": "The synccheck tool is a runtime tool that can identify whether a CUDA application is correctly using synchronization primitives, specifically __syncthreads() and __syncwarp() intrinsics and their Cooperative Groups API counterparts.", "keywords": []}, {"id": 68, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#why-compute-sanitizer", "display_name": "Why Compute Sanitizer", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "why-compute-sanitizer", "priority": -1, "content": "NVIDIA allows developers to easily harness the power of GPUs to solve problems in parallel using CUDA. CUDA applications often run thousands of threads in parallel. Every programmer invariably encounters memory access errors and thread ordering, hazards that are hard to detect and time consuming to debug. The number of such errors increases substantially when dealing with thousands of threads. The Compute Sanitizer suite is designed to detect those problems in your CUDA application.", "keywords": []}, {"id": 69, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "page", "name": "ComputeSanitizer/index#windows-specific-behavior", "display_name": "Windows Specific Behavior", "type": "section", "display_type": "Page section", "docname": "ComputeSanitizer/index", "anchor": "windows-specific-behavior", "priority": -1, "content": "Debugging interface The registry key HKEY_LOCAL_MACHINE\\SOFTWARE\\NVIDIA Corporation\\GPUDebugger\\EnableInterface must be set to (DWORD) 1 . This is required to enable the debugging interface for the Compute Sanitizer tools. Timeout Detection and Recovery (TDR) On Windows, GPUs have a timeout associated with them. GPU applications that take longer than the threshold (default of 2 seconds) will be killed by the operating system. Since the Compute Sanitizer tools increase the runtime of kernels, it is possible for a CUDA kernel to exceed the timeout and therefore be terminated due to the TDR mechanism. For the purposes of debugging, the number of seconds before which the timeout is hit can be modified by setting the timeout value in seconds in the DWORD registry key TdrDelay at: HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\GraphicsDrivers More information about the registry keys to control the Timeout Detection and Recovery mechanism is available from MSDN at http://msdn.microsoft.com/en-us/library/windows/hardware/ff569918%28v=vs.85%29.aspx .", "keywords": []}, {"id": 70, "doc_id": 70, "filename": "ComputeSanitizer/index.html", "domain_name": "std", "name": "ComputeSanitizer/index", "display_name": "Compute Sanitizer", "type": "doc", "display_type": "Page", "docname": "ComputeSanitizer/index", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 71, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "page", "name": "CopyrightAndLicenses/index#compute-sanitizer-api-nvidia-software-license-agreement", "display_name": "Compute Sanitizer API - NVIDIA SOFTWARE LICENSE AGREEMENT", "type": "section", "display_type": "Page section", "docname": "CopyrightAndLicenses/index", "anchor": "compute-sanitizer-api-nvidia-software-license-agreement", "priority": -1, "content": "IMPORTANT NOTICE \u2013 PLEASE READ AND AGREE BEFORE USING THE SOFTWARE. This license agreement (\u201cAgreement\u201d) is a legal agreement between you, whether an individual or entity (\u201cyou\u201d) and NVIDIA Corporation (\u201cNVIDIA\u201d) and governs the use of the NVIDIA developer software development kit and materials provided under this Agreement (\u201cSoftware\u201d). This Agreement can be accepted only by an adult of legal age of majority in the country in which the Software is used. If you don\u2019t have the required age or authority to accept this Agreement, or if you don\u2019t accept all the terms and conditions of this Agreement, do not use the Software. You agree to use the Software only for purposes that are permitted by this Agreement and any applicable law or regulation in the relevant jurisdictions. License Grant. Subject to the terms of this Agreement, NVIDIA grants you a non-exclusive, revocable, non-transferable, non-sublicensable (except as expressly granted in this Agreement), license to: 1.1 install and use copies of the Software, 1.2 modify and create derivative works of sample or example Software provided by NVIDIA in source code format, 1.3 distribute Software files identified as REDIST or included in a REDIT directory in binary format as incorporated into a software application subject to the following distribution requirements: 1.3.1 Your application must have material additional functionality, beyond the included portions of the Software. 1.3.2 The distributable portions of the Software shall only be accessed by your application. 1.3.3 The following notice shall be included in modifications and derivative works of sample source code distributed: \u201cThis software contains source code provided by NVIDIA Corporation.\u201d 1.3.4 Unless a developer tool is identified in this Agreement as distributable, it is delivered for your internal use only. 1.3.5 The terms under which you distribute your application must be consistent with the terms of this Agreement, including (without limitation) terms relating to the license grant and license restrictions and protection of NVIDIA\u2019s intellectual property rights. Additionally, you agree that you will protect the privacy, security and legal rights of your application users. 1.3.6 You agree to notify NVIDIA in writing of any known or suspected distribution or use of the Software not in compliance with the requirements of this Agreement, and to enforce the terms of your agreements with respect to distributed Software. Limitations. Your license to use the Software is restricted as follows: 2.1 The Software is licensed for you to develop applications only for use in systems with NVIDIA GPUs. 2.2 You may not reverse engineer, decompile or disassemble the Software components provided in binary form, nor attempt in any other manner to obtain source code of the Software. 2.3 You may not change or remove copyright or other proprietary notices in the Software. 2.4 Except as expressly granted in this Agreement, you may not copy, sell, rent, sublicense, transfer, distribute, modify or create derivative works of the Software, or make its functionality available to others. 2.5 You may not bypass, disable or circumvent any technical limitation, encryption, security, digital rights management or authentication mechanism in the Software. 2.6 You may not use the Software in any manner that would cause it to become subject to an open source software license; subject to the terms in the \u201cComponents Under Other Licenses\u201d section below. 2.7 You may not use the Software for the purpose of developing competing products or technologies or assist a third party in such activities. 2.8 You may not indicate that a product or service developed with the Software is sponsored or endorsed by NVIDIA. 2.9 You may not replace any NVIDIA software components in the Software that are governed by this Agreement with other software that implements NVIDIA APIs. 2.10 You may not reverse engineer, decompile or disassemble any portion of the output generated using Software elements for the purpose of translating such output artifacts to target a non-NVIDIA platform. 2.11 You may not distribute or disclose to third parties results of benchmarking, competitive analysis, or regression or performance data relating to the Software or NVIDIA GPUs if comparing directly with non-NVIDIA platforms unless you have prior written permission from NVIDIA. 2.12 Unless you have an explicit warranty from NVIDIA confirming compliance with safety standards, you acknowledge that the Software provided under this Agreement is not designed or tested by NVIDIA for use in any system or application where the use or failure of such system or application developed or deployed with NVIDIA\u2019s Software could result in injury, death or catastrophic damage (each, a \u201cMission Critical Application\u201d), and additionally the use of the NVIDIA Compute Sanitizer tool will not guarantee results with respect to safety or defects in software it analyzes. Examples of Mission Critical Applications include use in avionics, navigation, autonomous vehicle applications, AI solutions for automotive products, military, medical, life support or other mission-critical or life-critical applications. NVIDIA will not be liable to you or any third party, in whole or in part, for any claims or damages arising from these uses. You are solely responsible for ensuring that systems and applications developed with the Software include sufficient safety and redundancy features and comply with all applicable legal and regulatory standards and requirements. 2.13 You agree to defend, indemnify and hold harmless NVIDIA and its affiliates, and their respective employees, contractors, agents, officers and directors, from and against any and all claims, damages, obligations, losses, liabilities, costs or debt, fines, restitutions and expenses (including but not limited to attorney\u2019s fees and costs incident to establishing the right of indemnification) arising out of or related to (i) products or services that have been developed or deployed with or use the Software, or claims that they violate laws, or infringe, violate, or misappropriate any third party right; or (ii) a violation of the terms and conditions of this Agreement. Authorized Users. You may allow employees and contractors of your entity or of your subsidiary(ies) to access and use the Software from your secure network to perform the work authorized by this Agreement on your behalf. If you are an academic institution, you may allow users enrolled or employed by the academic institution to access and use the Software as authorized by this Agreement from your secure network. You are responsible for the compliance with the terms of this Agreement by your authorized users. Any act or omission that if committed by you would constitute a breach of this Agreement will be deemed to constitute a breach of this Agreement if committed by your authorized users. Pre-Release Versions. Software versions or specific features identified as alpha, beta, preview, early access or otherwise as pre-release may not be fully functional, may contain errors or design flaws, and may have reduced or different security, privacy, availability and reliability standards relative to commercial versions of NVIDIA offerings. You may use pre-release Software at your own risk, understanding that such versions are not intended for use in production or business-critical systems. NVIDIA may choose not to make available a commercial version of any pre-release Software. NVIDIA may also choose to abandon development and terminate the availability of pre-release Software at any time without liability. Confidentiality. You agree that you will not use, nor authorize others to use, NVIDIA Confidential Information, except as necessary for the performance of this Agreement, and that you will not disclose NVIDIA Confidential Information to any third party, except to permitted users under this Agreement that have a need to know such Confidential Information for the purpose of this Agreement, provided that each such recipient is subject to a written agreement that includes confidentiality obligations consistent with these terms. You will protect the NVIDIA Confidential Information with at least the same degree of care that you use to protect your own similar confidential and proprietary information, but no less than a reasonable degree of care. \u201cConfidential Information\u201d means the Software identified as \u201cNDA\u201d or \u201cPro\u201d versions together with the output of such Software. Updates. NVIDIA may, at its option, make available patches, workarounds or other updates to the Software. Unless the updates are provided with their separate governing terms, they are deemed part of the Software licensed to you as provided in this Agreement. Components Under Other Licenses. The Software may include or be distributed with components provided with separate legal notices or terms that accompany the components, such as open source software licenses and other license. The components are subject to the applicable other licenses, including any proprietary notices, disclaimers, requirements and extended use rights; except that this Agreement will prevail regarding the use of third-party open source software, unless a third-party open source software license requires its license terms to prevail. Open source software license means any software, data or documentation subject to any license identified as an open source license by the Open Source Initiative ( http://opensource.org ), Free Software Foundation ( http://www.fsf.org ) or other similar open source organization or listed by the Software Package Data Exchange (SPDX) Workgroup under the Linux Foundation ( http://www.spdx.org ). Termination. This Agreement will automatically terminate without notice from NVIDIA if you fail to comply with any of the terms in this Agreement or if you commence or participate in any legal proceeding against NVIDIA with respect to the Software. Additionally, either party may terminate this Agreement at any time with prior written notice to the other party. You agree to cooperate with NVIDIA and provide reasonably requested information to verify your compliance with this Agreement. Upon any termination, you must stop using and destroy all copies of the Software and derivative works. Upon written request, you will certify in writing that you have complied with your commitments under this section. All provisions will survive termination, except for the licenses granted to you. Ownership. 9.1 NVIDIA Ownership. The Software, including all intellectual property rights, is and will remain the sole and exclusive property of NVIDIA or its licensors. Except as expressly granted in this Agreement, (i) NVIDIA reserves all rights, interests and remedies in connection with the Software and (ii) no other license or right is granted to you by implication, estoppel or otherwise. 9.2 Your Ownership. Subject to the rights of NVIDIA and its suppliers in the Software, you hold all rights, title and interest in and to your services, applications and derivative works of samples or examples you develop as permitted in this Agreement including their respective intellectual property rights. 9.3 Non-Assert. You agree that you will not, and will not assist or enable any other party to, assert or threaten to assert any intellectual property rights against NVIDIA or its affiliates with respect to new software samples or examples that NVIDIA or its affiliates may develop and make available in the future. Feedback. You may, but are not obligated to, provide suggestions, requests, fixes, modifications, enhancements or other feedback regarding or in connection with your use of the Software (collectively, \u201cFeedback\u201d). Feedback, even if designated as confidential by you, will not create any confidentiality obligation for NVIDIA or its affiliates. If you provide Feedback, you hereby grant NVIDIA, its affiliates and its designees a non-exclusive, perpetual, irrevocable, sublicensable, worldwide, royalty-free, fully paid-up and transferable license, under your intellectual property rights, to publicly perform, publicly display, reproduce, use, make, have made, sell, offer for sale, distribute (through multiple tiers of distribution), import, create derivative works of and otherwise commercialize and exploit the Feedback at NVIDIA\u2019s discretion. You will not give Feedback (i) that you have reason to believe is subject to any restriction that impairs the exercise of the grant stated in this section, such as third-party intellectual property rights or (ii) subject to license terms which seek to require any product incorporating or developed using such Feedback, or other intellectual property of NVIDIA or its affiliates, to be licensed to or otherwise shared with any third party. Disclaimer of Warranties. THE SOFTWARE IS PROVIDED BY NVIDIA AS-IS AND WITH ALL FAULTS. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, NVIDIA DISCLAIMS ALL WARRANTIES AND REPRESENTATIONS OF ANY KIND, WHETHER EXPRESS, IMPLIED OR STATUTORY, RELATING TO OR ARISING UNDER THIS AGREEMENT, INCLUDING, WITHOUT LIMITATION, THE WARRANTIES OF TITLE, NONINFRINGEMENT, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, USAGE OF TRADE AND COURSE OF DEALING. WITHOUT LIMITING THE FOREGOING, NVIDIA DOES NOT WARRANT THAT THE SOFTWARE WILL MEET YOUR REQUIREMENTS; THAT ANY DEFECTS OR ERRORS WILL BE CORRECTED; THAT ANY CERTAIN CONTENT WILL BE AVAILABLE; OR THAT THE SOFTWARE IS FREE OF VIRUSES OR OTHER HARMFUL COMPONENTS. NO INFORMATION OR ADVICE GIVEN BY NVIDIA WILL IN ANY WAY INCREASE THE SCOPE OF ANY WARRANTY EXPRESSLY PROVIDED IN THIS AGREEMENT. NVIDIA does not warrant or assume responsibility for the accuracy or completeness of any third-party information, text, graphics or links contained in the Software. Limitations of Liability. 12.1 DISCLAIMERS. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, IN NO EVENT WILL NVIDIA BE LIABLE FOR ANY (I) INDIRECT, PUNITIVE, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, OR (II) DAMAGES FOR THE (A) COST OF PROCURING SUBSTITUTE GOODS OR (B) LOSS OF PROFITS, REVENUES, USE, DATA OR GOODWILL ARISING OUT OF OR RELATED TO THIS AGREEMENT, WHETHER BASED ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY, OR OTHERWISE, AND EVEN IF NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES AND EVEN IF A PARTY\u2019S REMEDIES FAIL THEIR ESSENTIAL PURPOSE. 12.2 DAMAGES CAP. ADDITIONALLY, TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, NVIDIA\u2019S TOTAL CUMULATIVE AGGREGATE LIABILITY FOR ANY AND ALL LIABILITIES, OBLIGATIONS OR CLAIMS ARISING OUT OF OR RELATED TO THIS AGREEMENT WILL NOT EXCEED FIVE U.S. DOLLARS (US$5). Governing Law and Jurisdiction. This Agreement will be governed in all respects by the laws of the United States and the laws of the State of Delaware, without regard to conflict of laws principles or the United Nations Convention on Contracts for the International Sale of Goods. The state and federal courts residing in Santa Clara County, California will have exclusive jurisdiction over any dispute or claim arising out of or related to this Agreement, and the parties irrevocably consent to personal jurisdiction and venue in those courts; except that either party may apply for injunctive remedies or an equivalent type of urgent legal relief in any jurisdiction. General. 14.1 No Assignment. NVIDIA may assign, delegate or transfer its rights or obligations under this Agreement by any means or operation of law. You may not, without NVIDIA\u2019s prior written consent, assign, delegate or transfer any of your rights or obligations under this Agreement by any means or operation of law, and any attempt to do so is null and void. 14.2 No Waiver. No waiver of any term of the Agreement will be deemed a further or continuing waiver of such term or any other term, and NVIDIA\u2019s failure to assert any right or provision under the Agreement will not constitute a waiver of such right or provision. 14.3 Trade and Compliance. You agree to comply with all applicable export, import, trade and economic sanctions laws and regulations, as amended, including without limitation U.S. Export Administration Regulations and Office of Foreign Assets Control regulations. You confirm (a) your understanding that export or reexport of certain NVIDIA products or technologies may require a license or other approval from appropriate authorities and (b) that it will not export or reexport any products or technology, directly or indirectly, without first obtaining any required license or other approval from appropriate authorities, (i) to any countries that are subject to any U.S. or local export restrictions (currently including, but not necessarily limited to, Belarus, Cuba, Iran, North Korea, Russia, Syria, the Region of Crimea, Donetsk People\u2019s Republic Region and Luhansk People\u2019s Republic Region); (ii) to any end user who you know or have reason to know will utilize them in the design, development or production of nuclear, chemical or biological weapons, missiles, rocket systems, unmanned air vehicles capable of a maximum range of at least 300 kilometers, regardless of payload, or intended for military end-use, or any weapons of mass destruction; (iii) to any end-user who has been prohibited from participating in the U.S. or local export transactions by any governing authority; or (iv) to any known military or military-intelligence end-user or for any known military or military-intelligence end-use in accordance with U.S. trade compliance laws and regulations. Use of the Software under this Agreement must be consistent with NVIDIA\u2019s HumanRightsPolicy.pdf (nvidia.com) . 14.4 Government Rights. The Software, documentation and technology (\u201cProtected Items\u201d) are \u201cCommercial products\u201d as this term is defined at 48 C.F.R. 2.101, consisting of \u201ccommercial computer software\u201d and \u201ccommercial computer software documentation\u201d as such terms are used in, respectively, 48 C.F.R. 12.212 and 48 C.F.R. 227.7202 &amp; 252.227-7014(a)(1). Before any Protected Items are supplied to the U.S. Government, you will (i) inform the U.S. Government in writing that the Protected Items are and must be treated as commercial computer software and commercial computer software documentation developed at private expense; (ii) inform the U.S. Government that the Protected Items are provided subject to the terms of the Agreement; and (iii) mark the Protected Items as commercial computer software and commercial computer software documentation developed at private expense. In no event will you permit the U.S. Government to acquire rights in Protected Items beyond those specified in 48 C.F.R. 52.227-19(b)(1)-(2) or 252.227-7013(c) except as expressly approved by NVIDIA in writing. 14.5. Notices. Please direct your legal notices or other correspondence to NVIDIA Corporation, 2788 San Tomas Expressway, Santa Clara, California 95051, United States of America, Attention: Legal Department, with a copy emailed to legalnotices@nvidia.com . If NVIDIA needs to contact you about the Software, you consent to receive the notices by email and agree that such notices will satisfy any legal communication requirements. 14.6 Force Majeure. Neither party will be liable during any period where an event or circumstance prevents or delays that party from performing its obligations under this Agreement and that event or circumstance: (i) is not within the reasonable control of that party and is not the result of that party\u2019s negligence, and (ii) cannot be overcome or avoided by that party using reasonably diligent efforts. 14.7 Severability and Amendment. If a court of competent jurisdiction rules that a provision of this Agreement is unenforceable, that provision will be deemed modified to the extent necessary to make it enforceable and the remainder of this Agreement will continue in full force and effect. Any amendment to this Agreement must be in writing and signed by authorized representatives of both parties. 14.8. Independent Contractors. The parties are independent contractors, and this Agreement does not create a joint venture, partnership, agency or other form of business association between the parties. Neither party will have the power to bind the other party or incur any obligation on its behalf without the other party\u2019s prior written consent. 14.9 Construction. The headings in the Agreement are included solely for convenience and are not intended to affect the meaning or interpretation of the Agreement. As required by the context of the Agreement, the singular of a term includes the plural and vice versa. 14.10 Entire Agreement. Regarding the subject matter of this Agreement, the parties agree that (i) this Agreement constitutes the entire and exclusive agreement between the parties and supersedes all prior and contemporaneous communications and (ii) any additional or different terms or conditions, whether contained in purchase orders, order acknowledgments, invoices or otherwise, will not be binding and are null and void. (v. December 2, 2024)", "keywords": []}, {"id": 72, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "page", "name": "CopyrightAndLicenses/index#compute-sanitizer-nvidia-software-license-agreement", "display_name": "Compute Sanitizer - NVIDIA SOFTWARE LICENSE AGREEMENT", "type": "section", "display_type": "Page section", "docname": "CopyrightAndLicenses/index", "anchor": "compute-sanitizer-nvidia-software-license-agreement", "priority": -1, "content": "IMPORTANT NOTICE \u2013 PLEASE READ AND AGREE BEFORE USING THE SOFTWARE. This license agreement (\u201cAgreement\u201d) is a legal agreement between you, whether an individual or entity (\u201cyou\u201d) and NVIDIA Corporation (\u201cNVIDIA\u201d) and governs the use of the NVIDIA software development tool and materials provided under this Agreement (\u201cSoftware\u201d). This Agreement can be accepted only by an adult of legal age of majority in the country in which the Software is used. If you don\u2019t have the required age or authority to accept this Agreement, or if you don\u2019t accept all the terms and conditions of this Agreement, do not use the Software. You agree to use the Software only for purposes that are permitted by this Agreement and any applicable law or regulation in the relevant jurisdictions. License Grant. Subject to the terms of this Agreement, NVIDIA grants you a non-exclusive, revocable, non-transferable, non-sublicensable (except as expressly granted in this Agreement), license to: 1.1 install and use copies of the Software, and 1.2 modify and create derivative works of sample or example Software provided by NVIDIA in source code format. Limitations. Your license to use the Software is restricted as follows: 2.1 Except as otherwise stated, the Software is licensed for you to develop applications only for use in systems with NVIDIA GPUs. The terms in this section do not apply to the following Software licensed under this Agreement: Nsight DL Designer, Nsight Systems, Nsight Graphics and SDK Manager. 2.2 You may not reverse engineer, decompile or disassemble the Software components provided in binary form, nor attempt in any other manner to obtain source code of the Software. 2.3 You may not change or remove copyright or other proprietary notices in the Software. 2.4 Except as expressly granted in this Agreement, you may not copy, sell, rent, sublicense, transfer, distribute, modify or create derivative works of the Software, or make its functionality available to others. 2.5 You may not bypass, disable or circumvent any technical limitation, encryption, security, digital rights management or authentication mechanism in the Software. 2.6 You may not use the Software in any manner that would cause it to become subject to an open source software license; subject to the terms in the \u201cComponents Under Other Licenses\u201d section below. 2.7 You may not use the Software for the purpose of developing competing products or technologies or assist a third party in such activities. 2.8 You may not indicate that a product or service developed with the Software is sponsored or endorsed by NVIDIA. 2.9 You may not replace any NVIDIA software components in the Software that are governed by this Agreement with other software that implements NVIDIA APIs. 2.10 You may not reverse engineer, decompile or disassemble any portion of the output generated using Software elements for the purpose of translating such output artifacts to target a non-NVIDIA platform. 2.11 You may not distribute or disclose to third parties results of benchmarking, competitive analysis, or regression or performance data relating to the Software or NVIDIA GPUs if comparing directly with non-NVIDIA platforms unless you have prior written permission from NVIDIA. 2.12 Unless you have an explicit warranty from NVIDIA confirming compliance with safety standards, you acknowledge that the Software provided under this Agreement is not designed or tested by NVIDIA for use in any system or application where the use or failure of such system or application developed or deployed with NVIDIA\u2019s Software could result in injury, death or catastrophic damage (each, a \u201cMission Critical Application\u201d), and additionally the use of the NVIDIA Compute Sanitizer tool will not guarantee results with respect to safety or defects in software it analyzes. Examples of Mission Critical Applications include use in avionics, navigation, autonomous vehicle applications, AI solutions for automotive products, military, medical, life support or other mission-critical or life-critical applications. NVIDIA will not be liable to you or any third party, in whole or in part, for any claims or damages arising from these uses. You are solely responsible for ensuring that systems and applications developed with the Software include sufficient safety and redundancy features and comply with all applicable legal and regulatory standards and requirements. 2.13 You agree to defend, indemnify and hold harmless NVIDIA and its affiliates, and their respective employees, contractors, agents, officers and directors, from and against any and all claims, damages, obligations, losses, liabilities, costs or debt, fines, restitutions and expenses (including but not limited to attorney\u2019s fees and costs incident to establishing the right of indemnification) arising out of or related to (i) products or services that have been developed or deployed with or use the Software, or claims that they violate laws, or infringe, violate, or misappropriate any third party right; or (ii) a violation of the terms and conditions of this Agreement. Authorized Users. You may allow employees and contractors of your entity or of your subsidiary(ies) to access and use the Software from your secure network to perform the work authorized by this Agreement on your behalf. If you are an academic institution, you may allow users enrolled or employed by the academic institution to access and use the Software as authorized by this Agreement from your secure network. You are responsible for the compliance with the terms of this Agreement by your authorized users. Any act or omission that if committed by you would constitute a breach of this Agreement will be deemed to constitute a breach of this Agreement if committed by your authorized users. Pre-Release Versions. Software versions or specific features identified as alpha, beta, preview, early access or otherwise as pre-release may not be fully functional, may contain errors or design flaws, and may have reduced or different security, privacy, availability and reliability standards relative to commercial versions of NVIDIA offerings. You may use pre-release Software at your own risk, understanding that such versions are not intended for use in production or business-critical systems. NVIDIA may choose not to make available a commercial version of any pre-release Software. NVIDIA may also choose to abandon development and terminate the availability of pre-release Software at any time without liability. Confidentiality. You agree that you will not use, nor authorize others to use, NVIDIA Confidential Information, except as necessary for the performance of this Agreement, and that you will not disclose NVIDIA Confidential Information to any third party, except to permitted users under this Agreement that have a need to know such Confidential Information for the purpose of this Agreement, provided that each such recipient is subject to a written agreement that includes confidentiality obligations consistent with these terms. You will protect the NVIDIA Confidential Information with at least the same degree of care that you use to protect your own similar confidential and proprietary information, but no less than a reasonable degree of care. \u201cConfidential Information\u201d means the Software identified as \u201cNDA\u201d or \u201cPro\u201d versions together with the output of such Software. Updates. NVIDIA may, at its option, make available patches, workarounds or other updates to the Software. Unless the updates are provided with their separate governing terms, they are deemed part of the Software licensed to you as provided in this Agreement. Components Under Other Licenses. The Software may include or be distributed with components provided with separate legal notices or terms that accompany the components, such as open source software licenses and other license. The components are subject to the applicable other licenses, including any proprietary notices, disclaimers, requirements and extended use rights; except that this Agreement will prevail regarding the use of third-party open source software, unless a third-party open source software license requires its license terms to prevail. Open source software license means any software, data or documentation subject to any license identified as an open source license by the Open Source Initiative ( http://opensource.org ), Free Software Foundation ( http://www.fsf.org ) or other similar open source organization or listed by the Software Package Data Exchange (SPDX) Workgroup under the Linux Foundation ( http://www.spdx.org ). Termination. This Agreement will automatically terminate without notice from NVIDIA if you fail to comply with any of the terms in this Agreement or if you commence or participate in any legal proceeding against NVIDIA with respect to the Software. Additionally, either party may terminate this Agreement at any time with prior written notice to the other party. You agree to cooperate with NVIDIA and provide reasonably requested information to verify your compliance with this Agreement. Upon any termination, you must stop using and destroy all copies of the Software and derivative works. Upon written request, you will certify in writing that you have complied with your commitments under this section. All provisions will survive termination, except for the licenses granted to you. Ownership. 9.1 NVIDIA Ownership. The Software, including all intellectual property rights, is and will remain the sole and exclusive property of NVIDIA or its licensors. Except as expressly granted in this Agreement, (i) NVIDIA reserves all rights, interests and remedies in connection with the Software and (ii) no other license or right is granted to you by implication, estoppel or otherwise. 9.2 Your Ownership. Subject to the rights of NVIDIA and its suppliers in the Software, you hold all rights, title and interest in and to your services, applications and derivative works of samples or examples you develop as permitted in this Agreement including their respective intellectual property rights. 9.3 Non-Assert. You agree that you will not, and will not assist or enable any other party to, assert or threaten to assert any intellectual property rights against NVIDIA or its affiliates with respect to new software samples or examples that NVIDIA or its affiliates may develop and make available in the future. Feedback. You may, but are not obligated to, provide suggestions, requests, fixes, modifications, enhancements or other feedback regarding or in connection with your use of the Software (collectively, \u201cFeedback\u201d). Feedback, even if designated as confidential by you, will not create any confidentiality obligation for NVIDIA or its affiliates. If you provide Feedback, you hereby grant NVIDIA, its affiliates and its designees a non-exclusive, perpetual, irrevocable, sublicensable, worldwide, royalty-free, fully paid-up and transferable license, under your intellectual property rights, to publicly perform, publicly display, reproduce, use, make, have made, sell, offer for sale, distribute (through multiple tiers of distribution), import, create derivative works of and otherwise commercialize and exploit the Feedback at NVIDIA\u2019s discretion. You will not give Feedback (i) that you have reason to believe is subject to any restriction that impairs the exercise of the grant stated in this section, such as third-party intellectual property rights or (ii) subject to license terms which seek to require any product incorporating or developed using such Feedback, or other intellectual property of NVIDIA or its affiliates, to be licensed to or otherwise shared with any third party. Disclaimer of Warranties. THE SOFTWARE IS PROVIDED BY NVIDIA AS-IS AND WITH ALL FAULTS. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, NVIDIA DISCLAIMS ALL WARRANTIES AND REPRESENTATIONS OF ANY KIND, WHETHER EXPRESS, IMPLIED OR STATUTORY, RELATING TO OR ARISING UNDER THIS AGREEMENT, INCLUDING, WITHOUT LIMITATION, THE WARRANTIES OF TITLE, NONINFRINGEMENT, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, USAGE OF TRADE AND COURSE OF DEALING. WITHOUT LIMITING THE FOREGOING, NVIDIA DOES NOT WARRANT THAT THE SOFTWARE WILL MEET YOUR REQUIREMENTS; THAT ANY DEFECTS OR ERRORS WILL BE CORRECTED; THAT ANY CERTAIN CONTENT WILL BE AVAILABLE; OR THAT THE SOFTWARE IS FREE OF VIRUSES OR OTHER HARMFUL COMPONENTS. NO INFORMATION OR ADVICE GIVEN BY NVIDIA WILL IN ANY WAY INCREASE THE SCOPE OF ANY WARRANTY EXPRESSLY PROVIDED IN THIS AGREEMENT. NVIDIA does not warrant or assume responsibility for the accuracy or completeness of any third-party information, text, graphics or links contained in the Software. Limitations of Liability. 12.1 DISCLAIMERS. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, IN NO EVENT WILL NVIDIA BE LIABLE FOR ANY (I) INDIRECT, PUNITIVE, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, OR (II) DAMAGES FOR THE (A) COST OF PROCURING SUBSTITUTE GOODS OR (B) LOSS OF PROFITS, REVENUES, USE, DATA OR GOODWILL ARISING OUT OF OR RELATED TO THIS AGREEMENT, WHETHER BASED ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY, OR OTHERWISE, AND EVEN IF NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES AND EVEN IF A PARTY\u2019S REMEDIES FAIL THEIR ESSENTIAL PURPOSE. 12.2 DAMAGES CAP. ADDITIONALLY, TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, NVIDIA\u2019S TOTAL CUMULATIVE AGGREGATE LIABILITY FOR ANY AND ALL LIABILITIES, OBLIGATIONS OR CLAIMS ARISING OUT OF OR RELATED TO THIS AGREEMENT WILL NOT EXCEED FIVE U.S. DOLLARS (US$5). Governing Law and Jurisdiction. This Agreement will be governed in all respects by the laws of the United States and the laws of the State of Delaware, without regard to conflict of laws principles or the United Nations Convention on Contracts for the International Sale of Goods. The state and federal courts residing in Santa Clara County, California will have exclusive jurisdiction over any dispute or claim arising out of or related to this Agreement, and the parties irrevocably consent to personal jurisdiction and venue in those courts; except that either party may apply for injunctive remedies or an equivalent type of urgent legal relief in any jurisdiction. General. 14.1 No Assignment. NVIDIA may assign, delegate or transfer its rights or obligations under this Agreement by any means or operation of law. You may not, without NVIDIA\u2019s prior written consent, assign, delegate or transfer any of your rights or obligations under this Agreement by any means or operation of law, and any attempt to do so is null and void. 14.2 No Waiver. No waiver of any term of the Agreement will be deemed a further or continuing waiver of such term or any other term, and NVIDIA\u2019s failure to assert any right or provision under the Agreement will not constitute a waiver of such right or provision. 14.3 Trade and Compliance. You agree to comply with all applicable export, import, trade and economic sanctions laws and regulations, as amended, including without limitation U.S. Export Administration Regulations and Office of Foreign Assets Control regulations. You confirm (a) your understanding that export or reexport of certain NVIDIA products or technologies may require a license or other approval from appropriate authorities and (b) that it will not export or reexport any products or technology, directly or indirectly, without first obtaining any required license or other approval from appropriate authorities, (i) to any countries that are subject to any U.S. or local export restrictions (currently including, but not necessarily limited to, Belarus, Cuba, Iran, North Korea, Russia, Syria, the Region of Crimea, Donetsk People\u2019s Republic Region and Luhansk People\u2019s Republic Region); (ii) to any end user who you know or have reason to know will utilize them in the design, development or production of nuclear, chemical or biological weapons, missiles, rocket systems, unmanned air vehicles capable of a maximum range of at least 300 kilometers, regardless of payload, or intended for military end-use, or any weapons of mass destruction; (iii) to any end-user who has been prohibited from participating in the U.S. or local export transactions by any governing authority; or (iv) to any known military or military-intelligence end-user or for any known military or military-intelligence end-use in accordance with U.S. trade compliance laws and regulations. Use of the Software under this Agreement must be consistent with NVIDIA\u2019s HumanRightsPolicy.pdf (nvidia.com) . 14.4 Government Rights. The Software, documentation and technology (\u201cProtected Items\u201d) are \u201cCommercial products\u201d as this term is defined at 48 C.F.R. 2.101, consisting of \u201ccommercial computer software\u201d and \u201ccommercial computer software documentation\u201d as such terms are used in, respectively, 48 C.F.R. 12.212 and 48 C.F.R. 227.7202 &amp; 252.227-7014(a)(1). Before any Protected Items are supplied to the U.S. Government, you will (i) inform the U.S. Government in writing that the Protected Items are and must be treated as commercial computer software and commercial computer software documentation developed at private expense; (ii) inform the U.S. Government that the Protected Items are provided subject to the terms of the Agreement; and (iii) mark the Protected Items as commercial computer software and commercial computer software documentation developed at private expense. In no event will you permit the U.S. Government to acquire rights in Protected Items beyond those specified in 48 C.F.R. 52.227-19(b)(1)-(2) or 252.227-7013(c) except as expressly approved by NVIDIA in writing. 14.5. Notices. Please direct your legal notices or other correspondence to NVIDIA Corporation, 2788 San Tomas Expressway, Santa Clara, California 95051, United States of America, Attention: Legal Department, with a copy emailed to legalnotices@nvidia.com . If NVIDIA needs to contact you about the Software, you consent to receive the notices by email and agree that such notices will satisfy any legal communication requirements. 14.6 Force Majeure. Neither party will be liable during any period where an event or circumstance prevents or delays that party from performing its obligations under this Agreement and that event or circumstance: (i) is not within the reasonable control of that party and is not the result of that party\u2019s negligence, and (ii) cannot be overcome or avoided by that party using reasonably diligent efforts. 14.7 Severability and Amendment. If a court of competent jurisdiction rules that a provision of this Agreement is unenforceable, that provision will be deemed modified to the extent necessary to make it enforceable and the remainder of this Agreement will continue in full force and effect. Any amendment to this Agreement must be in writing and signed by authorized representatives of both parties. 14.8. Independent Contractors. The parties are independent contractors, and this Agreement does not create a joint venture, partnership, agency or other form of business association between the parties. Neither party will have the power to bind the other party or incur any obligation on its behalf without the other party\u2019s prior written consent. 14.9 Construction. The headings in the Agreement are included solely for convenience and are not intended to affect the meaning or interpretation of the Agreement. As required by the context of the Agreement, the singular of a term includes the plural and vice versa. 14.10 Entire Agreement. Regarding the subject matter of this Agreement, the parties agree that (i) this Agreement constitutes the entire and exclusive agreement between the parties and supersedes all prior and contemporaneous communications and (ii) any additional or different terms or conditions, whether contained in purchase orders, order acknowledgments, invoices or otherwise, will not be binding and are null and void. (v. December 2, 2024)", "keywords": []}, {"id": 73, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "page", "name": "CopyrightAndLicenses/index#libbacktrace", "display_name": "libbacktrace", "type": "section", "display_type": "Page section", "docname": "CopyrightAndLicenses/index", "anchor": "libbacktrace", "priority": -1, "content": "Copyright (C) 2012-2016 Free Software Foundation, Inc. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. The name of the author may not be used to endorse or promote products derived from this software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS\u2019\u2019 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 74, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "page", "name": "CopyrightAndLicenses/index#microsoft-detours", "display_name": "Microsoft Detours", "type": "section", "display_type": "Page section", "docname": "CopyrightAndLicenses/index", "anchor": "microsoft-detours", "priority": -1, "content": "Microsoft Detours is used under the Professional license ( http://research.microsoft.com/en-us/projects/detours/ ). NVIDIA agrees to include in all copies of the NVIDIA Applications a proprietary rights notice that includes a reference to Microsoft software being included in such applications. NVIDIA shall not remove or obscure, but shall retain in the Software, any copyright, trademark, or patent notices that appear in the Software.", "keywords": []}, {"id": 75, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "page", "name": "CopyrightAndLicenses/index#protobuf", "display_name": "Protobuf", "type": "section", "display_type": "Page section", "docname": "CopyrightAndLicenses/index", "anchor": "protobuf", "priority": -1, "content": "Copyright \u00a9 2014, Google Inc. All rights reserved. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. Neither the name of Google Inc. nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \u201cAS IS\u201d AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. Code generated by the Protocol Buffer compiler is owned by the owner of the input file used when generating it. This code is not standalone and requires a support library to be linked with it. This support library is itself covered by the above license.", "keywords": []}, {"id": 76, "doc_id": 76, "filename": "CopyrightAndLicenses/index.html", "domain_name": "std", "name": "CopyrightAndLicenses/index", "display_name": "Copyright and Licenses", "type": "doc", "display_type": "Page", "docname": "CopyrightAndLicenses/index", "anchor": "", "priority": -1, "content": "Information on the NVIDIA Software License Agreement as well as third party software and tools used by Compute Sanitizer.", "keywords": []}, {"id": 77, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#gpu-support", "display_name": "GPU Support", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "gpu-support", "priority": -1, "content": "The compute-sanitizer tools are supported on all CUDA capable GPUs with SM versions 7.5 and above. Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 78, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#id2", "display_name": "Updates in 2023.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "id2", "priority": -1, "content": "Fixed bug where memcheck would report out-of-bound accesses when loading user parameter values using a ternary operator. Fixed potential crash when using leakcheck with applications using CUBLAS. Fixed potential false positives when using synccheck or racecheck with applications using CUDA barriers.", "keywords": []}, {"id": 79, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#known-issues", "display_name": "Known Issues", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "known-issues", "priority": -1, "content": "The synccheck tool may incorrectly emit divergence in block errors in applications compiled with the 13.0 CUDA toolkit using cooperative group synchronizations. The issue can be avoided by using the compiler provided in the CUDA toolkit 13.0 Update 1 or more recent. The racecheck tool may print incorrect data for \u201cCurrent value\u201d when reporting a hazard on a shared memory location where the last access was an atomic operation. This can also impact the severity of this hazard. On QNX, when using the --target-processes all option, analyzing shell scripts may hang after the script has completed. End the application using Ctrl-C on the command line in that case. The initcheck tool might report false positives for device-to-host cudaMemcpy operations on padded structs that were initialized by a CUDA kernel. The #pragma pack directive can be used to disable the padding as a workaround. When a hardware exception occur during a kernel launch that was skipped due to the usage of the kernel-name , kernel-name-exclude , launch-count or launch-skip options, the memcheck tool will not be able to report additional details as an imprecise error. The leakcheck feature is disabled under Confidential Computing.", "keywords": []}, {"id": 80, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#known-limitations", "display_name": "Known Limitations", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "known-limitations", "priority": -1, "content": "Applications run much slower under the Compute Sanitizer tools. This may cause some kernel launches to fail with a launch timeout error when running with the Compute Sanitizer enabled. Compute Sanitizer does not support checking host-side memory access violations and leaks for accesses made outside of CUDA API calls (e.g. accessing a buffer from the CPU). Compute Sanitizer tools do not support coredumps on WSL2. The memcheck tool does not support CUDA API error checking for API calls made on the GPU using dynamic parallelism. The racecheck, synccheck and initcheck tools do not support CUDA dynamic parallelism. CUDA dynamic parallelism is not supported when Windows Hardware-accelerated GPU scheduling is enabled. Compute Sanitizer tools cannot interoperate with other CUDA developer tools. This includes CUDA coredumps which are automatically disabled by the Compute Sanitizer. They can be enabled instead by using the --generate-coredump option. The initcheck tool does not support IPC allocations. Using it will result in false positives. Compute Sanitizer tools are not supported when SLI is enabled. The racecheck tool is not supported under Confidential Computing. The memcheck tool does not detect out-of-bounds accesses into the reserved shared memory region. For more information on reserved shared memory, refer to the Special Registers Reserved for Shared Memory section of the PTX documentation. Some tensormap and tcgen05 instructions accessing global memory are not currently supported, which may result in initcheck false positives.", "keywords": []}, {"id": 81, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#platform-support", "display_name": "Platform Support", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "platform-support", "priority": -1, "content": "Platform Support Windows Yes Linux (x86_64) Yes Linux (ppc64le) No Linux (aarch64sbsa) Yes Linux (aarch64) Yes QNX Yes MacOSX No", "keywords": []}, {"id": 82, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#support", "display_name": "Support", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "support", "priority": -1, "content": "Information on supported platforms and GPUs.", "keywords": []}, {"id": 83, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2019-1", "display_name": "Updates in 2019.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2019-1", "priority": -1, "content": "Initial release of the Compute Sanitizer API (with CUDA 10.1)", "keywords": []}, {"id": 84, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-1", "display_name": "Updates in 2020.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-1", "priority": -1, "content": "Initial release of the Compute Sanitizer (with CUDA 11.0) Updates to the Sanitizer API : Added support for per-thread streams Added APIs to retrieve the PC and size of a CUDA function or patch Added callback for cudaStreamAttachMemAsync Added direction to memcpy callback data Added stream to memcpy and memset callbacks data Added launch callback after syscall setup Added visibility field to allocation callback data Added PC argument to block entry callback Added incoming value to memory access callbacks Added threadCount to barrier callbacks Added cooperative group flags for barrier and function callbacks", "keywords": []}, {"id": 85, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-1-1", "display_name": "Updates in 2020.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-1-1", "priority": -1, "content": "Added support for Windows Hardware-accelerated GPU scheduling Added support for tracking child processes spawned by the application launched under the tool via the --target-processes CLI option.", "keywords": []}, {"id": 86, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-1-2", "display_name": "Updates in 2020.1.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-1-2", "priority": -1, "content": "Added sanitizer stream API. This fixes tool crashes when per-thread streams are being used.", "keywords": []}, {"id": 87, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-2", "display_name": "Updates in 2020.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-2", "priority": -1, "content": "Added support for CUDA graphs and CUDA memmap APIs. The memory access callback of the sanitizer API has been split into three distinct callbacks corresponding to global, shared and local memory accesses.", "keywords": []}, {"id": 88, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-2-1", "display_name": "Updates in 2020.2.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-2-1", "priority": -1, "content": "Fixed crash when loading cubins of size larger than 2 GiB. Fixed error detection on systems with multiple GPUs. Fixed issue when using CUDA Virtual Memory Management API cuMemSetAccess to remove access to a subset of devices on a system with multiple GPUs. Added sanitizer API to translate between sanitizer and CUDA stream handles.", "keywords": []}, {"id": 89, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-3", "display_name": "Updates in 2020.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-3", "priority": -1, "content": "Added support for CUDA memory pools and CUDA API reduced serialization. Added host backtrace for unused memory reports.", "keywords": []}, {"id": 90, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2020-3-1", "display_name": "Updates in 2020.3.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2020-3-1", "priority": -1, "content": "Fixed issue when launching a CUDA graph multiple times. Fixed false positives when using cooperative groups synchronization primitives with initcheck and synccheck.", "keywords": []}, {"id": 91, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-1", "display_name": "Updates in 2021.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-1", "priority": -1, "content": "Added support for allocation padding via the --padding option. Added experimental support for NVTX memory API using option --nvtx yes . Please refer to NVTX API for Compute Sanitizer Reference Manual for more information.", "keywords": []}, {"id": 92, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-1-1", "display_name": "Updates in 2021.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-1-1", "priority": -1, "content": "Fixed an issue where incorrect line numbers could be shown in errors reports.", "keywords": []}, {"id": 93, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-2", "display_name": "Updates in 2021.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-2", "priority": -1, "content": "Added racecheck and synccheck support for cuda::barrier on Ampere GPUs or newer. Added racecheck support for __syncwarp with partial mask. Added --launch-count and --launch-skip filtering options. See the Command Line Options documentation for more information. --filter and --exclude options have been respectively renamed to --kernel-regex and --kernel-regex-exclude . Added support for QNX and Linux aarch64 platforms. Added support for CUDA graphs memory nodes.", "keywords": []}, {"id": 94, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-2-1", "display_name": "Updates in 2021.2.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-2-1", "priority": -1, "content": "Added device backtrace for malloc/free errors in CUDA kernels. Improved racecheck host memory footprint.", "keywords": []}, {"id": 95, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-2-2", "display_name": "Updates in 2021.2.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-2-2", "priority": -1, "content": "Enabled stack canaries with random canary values for L4T builds.", "keywords": []}, {"id": 96, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-2-3", "display_name": "Updates in 2021.2.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-2-3", "priority": -1, "content": "Enabled SLS hardening and branch protection for L4T builds.", "keywords": []}, {"id": 97, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-3", "display_name": "Updates in 2021.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-3", "priority": -1, "content": "Improved Linux host backtrace. Removed requirement to call cudaDeviceReset() for accurate reporting of memory leaks and unused memory features. Fixed synccheck potential hang when calling __syncthreads in divergent code paths on Volta GPUs or newer. Added print of nearest allocation information for memcheck precise errors in global memory. Added warning when calling device-side malloc with an empty size. Added separate sanitizer API device callback for cuda::memcpy_async . Added new command-line option --num-cuda-barriers to override the expected number of cuda::barrier used by the target application. Added new command-line options --print-session-details to print session information and --save-session-details to save it to the output file. Added support for WSL2.", "keywords": []}, {"id": 98, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2021-3-1", "display_name": "Updates in 2021.3.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2021-3-1", "priority": -1, "content": "Fixed intermittent issue on vGPU where synccheck would incorrectly detect divergent threads. Fixed potential hang when tracking several graph launches.", "keywords": []}, {"id": 99, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-1", "display_name": "Updates in 2022.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-1", "priority": -1, "content": "Added support for generating coredumps. Improved support for stack overflow detection. Added new option --target-processes-filter to filter the processes being tracked by name. Added initcheck support for asynchronous allocations. Requires CUDA driver version 510 or newer. Added initcheck support for accesses on peer devices. Requires CUDA driver version 510 or newer. Added support for OptiX 7 applications. Added support for tracking the child processes of 32-bit processes in multi-process applications on Linux and Windows x86_64.", "keywords": []}, {"id": 100, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-1-1", "display_name": "Updates in 2022.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-1-1", "priority": -1, "content": "Fixed initcheck issue where the tool would incorrectly abort a CUDA kernel launch after reporting an uninitialized access on Windows with hardware scheduling enabled.", "keywords": []}, {"id": 101, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-2", "display_name": "Updates in 2022.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-2", "priority": -1, "content": "Added memcheck support for use-before-alloc and use-after-free race detection. See the stream-ordered race detection documentation for more information. Added leakcheck support for asynchronous allocations, OptiX resources and CUDA memmap (on Linux only for the latter). Added option to ignore CUDA_ERROR_NOT_FOUND error codes returned by the cuGetProcAddress API. Added new sanitizer API functions to allocate and free page-locked host memory. Added sanitizer API callbacks for the event management API.", "keywords": []}, {"id": 102, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-2-1", "display_name": "Updates in 2022.2.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-2-1", "priority": -1, "content": "Fixed incorrect device backtrace for applications compiled with -lineinfo .", "keywords": []}, {"id": 103, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-3", "display_name": "Updates in 2022.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-3", "priority": -1, "content": "Added support for the NVIDIA GH100/SM 9.x GPU architecture. Added support for the NVIDIA AD10x/SM 8.9 GPU architecture. Added support for lazy kernel loading. Added memcheck support for distributed shared memory. Added new options --num-callers-device and --num-callers-host to control the number of callers to print in stack traces. Added support for OptiX 7.6 applications. Fix bug on Linux ppc64le where the host stack trace was incomplete.", "keywords": []}, {"id": 104, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-4", "display_name": "Updates in 2022.4", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-4", "priority": -1, "content": "Added support for __nv_aligned_device_malloc . Added support for ldmatrix and stmatrix instructions. Added support for cache control operations when using the --check-cache-control command-line option. Added new command-line option --unused-memory-threshold to control the threshold for unused memory reports. Improved support for CUDA pipeline memcpy-async related hazards in racecheck.", "keywords": []}, {"id": 105, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2022-4-1", "display_name": "Updates in 2022.4.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2022-4-1", "priority": -1, "content": "Fixed bug where synccheck would incorrectly report illegal instructions for code using cluster.sync() and compiled with --device-debug Fixed incorrect address reports in SanitizerCallbackMemcpyAsync in some specific cases, leading to potential invalid results in memcheck and racecheck. Fixed potential hangs and invalid results with racecheck on OptiX applications. Fixed potential crash or invalid results when using CUDA Lazy Module Loading with memcheck or initcheck if --check-device-heap is enabled. Lazy Module Loading will be automatically disabled in these cases.", "keywords": []}, {"id": 106, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-1", "display_name": "Updates in 2023.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-1", "priority": -1, "content": "Added racecheck support for distributed shared memory. Extended stream-ordered race detection to cudaMemcpy APIs. Added memcheck, synccheck and patching API support for warpgroup operations. Added --coredump-name CLI option to set the coredump file name. Added support for Unicode file paths. Added support for OptiX 7.7.", "keywords": []}, {"id": 107, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-1-1", "display_name": "Updates in 2023.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-1-1", "priority": -1, "content": "Fixed error output for WGMMA instructions.", "keywords": []}, {"id": 108, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-2", "display_name": "Updates in 2023.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-2", "priority": -1, "content": "Added support for CUDA device graph launches. Added racecheck support for cluster entry and exit race detection for remote shared memory accesses. See the cluster entry and exit race detection documentation for more information. Added support for CUDA lazy loading when device heap checking is enabled. Requires CUDA driver version 535 or newer. Added support for tracking child processes launched with system() or posix_spawn(p) when using --target-processes all . Added support for st.async and red.async instructions. Improved support for partial warp synchronization using cooperative groups in racecheck. Improved support for cuda::barrier::wait() on SM 9.x. Added coredump support for Pascal architecture and multi-context applications. Added support for OptiX 8.0. Improved performance when using initcheck in OptiX applications in some cases. Using initcheck to track OptiX applications now requires the option --check-optix yes .", "keywords": []}, {"id": 109, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-2-1", "display_name": "Updates in 2023.2.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-2-1", "priority": -1, "content": "Fixed potential racecheck hang on H100 when using thread block clusters. Compute Sanitizer 2023.2.1 is incorrectly versioned as 2023.2.0 and need to be differentiated by its build ID 33053471.", "keywords": []}, {"id": 110, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-2-2", "display_name": "Updates in 2023.2.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-2-2", "priority": -1, "content": "Updated version print output to include build and config information. Fix potential hang on QNX when capturing the host backtrace.", "keywords": []}, {"id": 111, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2023-3", "display_name": "Updates in 2023.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2023-3", "priority": -1, "content": "Added support for Heterogeneous Memory Management (HMM) and Address Translation Service (ATS). The feature is opt-in using the --hmm-support command-line option. Added racecheck support for device graph launches. Added the ability to suppress known issues using the --suppressions command-line option. See the suppressions documentation for more information. Added support for external memory objects . This effectively adds support for Vulkan and D3D12 interop. Added device backtrace support for WSL. Improve PC offset output. It is now printed next to the function name to clarify it is an assembly offset within that function. Several command-line options no longer require to explicitly specify \u201cyes\u201d or \u201cno\u201d when they are used. Renamed the options --kernel-regex and --kernel-regex-exclude to --kernel-name and --kernel-name-exclude . Added the regex filtering key to --kernel-name and --kernel-name-exclude . Added new command-line option --racecheck-indirect-barrier-dependency to enable indirect cuda::barrier tracking in racecheck. Added new command-line option --coredump-behavior to control the target application behavior after generating a GPU coredump. Added new command-line option --detect-missing-module-unload to detect missing calls to the cuModuleUnload driver API. Added new command-line option --preload-library to make the target application load a shared library before the injection libraries. Fix initcheck false positive when memory loads are widened and include padding bytes. Fix potential hang in racecheck and synccheck tools when the bar.arrive instruction is used. Added patching API support for the setsmemsize instruction. Added patching API support for __syncthreads() after the barrier is released.", "keywords": []}, {"id": 112, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2024-1", "display_name": "Updates in 2024.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2024-1", "priority": -1, "content": "Enable shared addressing support by default: removed option --hmm-support and replaced it with environment variable NV_COMPUTE_SANITIZER_SHARED_ADDRESSING_SUPPORT . See the environment variables documentation for more information. Changed default value for option --target-processes to all . Added detection for cuda::barrier initialization race conditions in racecheck on Hopper. Added support for initcheck API errors suppression. Added memcheck support for cuMemPoolImportPointer . Added support for CUDA green contexts. Added support for CUDA graph device-side node update. Fixed potential false positives with synccheck when using different cuda::barrier in a single warp. Fixed potential false negatives with memcheck when using floating point atomics on Hopper.", "keywords": []}, {"id": 113, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2024-1-1", "display_name": "Updates in 2024.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2024-1-1", "priority": -1, "content": "Fixed an issue where errors would not be reported in libraries called from .NET applications.", "keywords": []}, {"id": 114, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2024-2", "display_name": "Updates in 2024.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2024-2", "priority": -1, "content": "Added public API and memcheck support for PTX cp.async.bulk operations from global to shared memory on Hopper. Added support for OptiX 8.1. Dropped support for Linux ppc64le: this platform is no longer supported. Fixed an issue where memcheck would report misaligned or out of bounds false positives with accesses of a larger size than the actual operation in specific cases. Fixed potential issues when using Heterogeneous Memory Management. Fixed potential crashes or false results in racecheck when using clusters on Hopper. Added a warning when clearing unsupported coredump-related environment variables. Clarified in documentation when leak errors are reported.", "keywords": []}, {"id": 115, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2024-3", "display_name": "Updates in 2024.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2024-3", "priority": -1, "content": "Fixed potential invalid results on Ampere with synccheck and racecheck relating to cuda::barrier . cuda::barrier wait events are now called after the wait as completed in the same fashion as Hopper. This may require target applications to be recompiled with a CUDA 12.4 or more recent compiler. Fixed multiple issues with coredump generation that resulted in failures or hangs. Fixed potential false positives in memcheck with the PTX instruction st.async on the barrier address. Fixed a potential hang when using per-thread default streams or green contexts and synchronous cudaMemcpy from device to host. Fixed potential issues with host backtraces on Windows. Fixed potential false positives misaligned accesses in memcheck with the PTX instruction cp.async.bulk .", "keywords": []}, {"id": 116, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2024-4", "display_name": "Updates in 2024.4", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2024-4", "priority": -1, "content": "Added support for the Blackwell architecture. Added support for Tensor core barriers. Added public API and memcheck support for the st.bulk PTX instruction. Added racecheck support for the cp.async.bulk PTX instruction from global to shared memory. Improved performance of racecheck indirect barrier dependency option and enabled it by default. Fixed issues where device callbacks would in some cases be called with the wrong threads for a limited set of instructions. Fixed racecheck and syncheck issues with cuda::barrier tracking overflow. Fixed racecheck and syncheck issues with cluster barriers. Fixed memcheck and public API issues when importing memory from other processes and having CUDA_VISIBLE_DEVICES set. Fixed potential false positives with initcheck when doing 3D memcpy/memset operations.", "keywords": []}, {"id": 117, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2025-1", "display_name": "Updates in 2025.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2025-1", "priority": -1, "content": "Added support for additional Blackwell GPUs. Modified the way backtraces are displayed: By default, strip paths from files, and avoid displaying frames below main and extra CUDA runtime frames. Added the --strip-path and --backtrace-short options to control this behavior. Added support for native Python host backtraces. Added guardrails support for the PTX tcgen05 instructions. See the Tensor Core MMA guardrails documentation for more information. Added reports when encountering user-issued breakpoints. Added support for OptiX 9.0. Added Sanitizer API patching support for the PTX cp.async.mbarrier.arrive asynchronous join operation. Added Sanitizer API patching support for post-release syncwarp . Fixed a potential false positive in racecheck when using cp.async.mbarrier.arrive to synchronize memcpy async operations and using the same thread to immediately access the copy destination. Fixed a potential false positive in racecheck when using syncwarp . Fixed excessive synccheck and racecheck device and host memory consumption in some circumstances with programs initializing PTX mbarrier in a loop. Fixed potentially wrong block coordinates being displayed in racecheck reports when having multiple clusters.", "keywords": []}, {"id": 118, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2025-1-1", "display_name": "Updates in 2025.1.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2025-1-1", "priority": -1, "content": "Fixed an issue where racecheck on Windows may hang at the end of the program in some cases.", "keywords": []}, {"id": 119, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2025-2", "display_name": "Updates in 2025.2", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2025-2", "priority": -1, "content": "Added public API and memcheck support for all previously unimplemented directions of the PTX cp.async.bulk and cp.reduce.async.bulk . Added racecheck deadlock detection with the --racecheck-deadlock-timeout option. See the racecheck deadlock detection documentation . Added the --racecheck-trace-sync option to trace synchronization information in racecheck. See the racecheck synchronization tracing documentation . Added extra reporting for tensor memory leak detection. Added support for new vector and sizes configurations for ld and st on Blackwell. Added SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT callback to the patching API for all attempts at waiting on PTX mbarrier . Fixed an issue with mbarrier arrive on transactional barrier in racecheck and synccheck in Hopper+. Fixed a crash when using cudaMallocAsync and cuMemmap in the same program with enabled peer-GPU access in memcheck. Fixed issues in racecheck and synccheck when using PTX mbarrier with different addresses in the same warp. Fixed a potential crash with the error suppression option when using reference files without host backtrace.", "keywords": []}, {"id": 120, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2025-2-1", "display_name": "Updates in 2025.2.1", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2025-2-1", "priority": -1, "content": "Fixed an issue where using cp.async.mbarrier.arrive synchronization for cp.async would lead to corruption, crash or invalid results when using racecheck. Fixed potential false positives in memcheck when using a device-side malloc heap size superior to 4GB.", "keywords": []}, {"id": 121, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "page", "name": "ReleaseNotes/index#updates-in-2025-3", "display_name": "Updates in 2025.3", "type": "section", "display_type": "Page section", "docname": "ReleaseNotes/index", "anchor": "updates-in-2025-3", "priority": -1, "content": "Removed support for Maxwell, Pascal and Volta GPUs. Added support for PTX instructions st.async and red.async with .release semantics on Blackwell. Added additional types of deadlock detection with the --racecheck-deadlock-timeout . Fixed potential false positives in racecheck related to warpsync on Blackwell. Fixed an issue where some events were not reported when the first lane of a warp was not active when using the racecheck-trace-sync option. Fixed potential false positives or negatives in racecheck when using mbarrier with different addresses within a warp. Fixed potential false negatives in synccheck when using a barrier from different function calls across warps. Fixed an issue on Blackwell where --num-cuda-barriers would require a larger number than expected to function properly.", "keywords": []}, {"id": 122, "doc_id": 122, "filename": "ReleaseNotes/index.html", "domain_name": "std", "name": "ReleaseNotes/index", "display_name": "Release Notes", "type": "doc", "display_type": "Page", "docname": "ReleaseNotes/index", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 123, "doc_id": 123, "filename": "SanitizerApi/table-of-contents.html", "domain_name": "std", "name": "SanitizerApi/table-of-contents", "display_name": "Sanitizer API", "type": "doc", "display_type": "Page", "docname": "SanitizerApi/table-of-contents", "anchor": "", "priority": -1, "content": "The reference guide for the NVIDIA Compute Sanitizer API. The NVIDIA Compute Sanitizer API. Table of Contents 1. Modules 1.1. Sanitizer Barrier API 1.2. Sanitizer Callback API 1.3. Sanitizer Memory API 1.4. Sanitizer Patching API 1.5. Sanitizer Result Codes 1.6. Sanitizer Stream API 2. Data Structures Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 124, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#batch-memory-operations-callbacks", "display_name": "Batch Memory Operations Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "batch-memory-operations-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_BATCH_MEMOP domain, a callback function can be associated with CUDA batch memory operations. For example, when a cuStreamWriteValue API function is called, the callback function is invoked with a callback ID equal to SANITIZER_CBID_BATCH_MEMOP_WRITE . For this domain, the cbdata argument is of the type Sanitizer_BatchMemopData .", "keywords": []}, {"id": 125, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#callback-api", "display_name": "Callback API", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "callback-api", "priority": -1, "content": "The Compute Sanitizer Callback API allows you to register a callback into user code. The callback is invoked when the application calls a CUDA runtime or driver function, or when certain events occur in the CUDA driver. The following terminology is used by the Callback API. Callback domain: Callbacks are grouped into domains to make it easier to associate callback functions with groups of related CUDA functions or events. The following callback domains are defined by Sanitizer_CallbackDomain . CUDA driver functions CUDA runtime functions CUDA resource tracking CUDA synchronization notification CUDA grid launches CUDA memcpy operations CUDA memset operations CUDA batch memory operations Callback ID: Each callback is given a unique ID within the corresponding callback domain in order to identify it within the callback function. The CUDA driver API IDs are defined in sanitizer_driver_cbid.h and the CUDA runtime API IDs are defined in sanitizer_runtime_cbid.h . Other callback IDs are defined in sanitizer_callbacks.h . All of these headers are included as part of sanitizer.h . Callback Function: The callback function must be of the type Sanitizer_CallbackFunc . This function type has two arguments that specify the callback: the domain and the ID that identifies why the callback is occurring. The type also has a cbdata argument that is used to pass data specific to the callback. Subscriber: A subscriber is used to associate each of the callback functions with one or more CUDA API functions. There can be at most one subscriber initialized with sanitizerSubscribe at any time. Before initializing a new subscriber, the existing one must be finalized with sanitizerUnsubscribe . The subscriber should be initialized prior to making any CUDA API call to ensure correctness of the reported data. Each callback domain is described in detail below. Unless explicitly stated, it is not supported to call any CUDA runtime or driver API from within a callback function. Doing so may cause the application to hang. However, it is supported to call Compute Sanitizer Memory APIs from within callback functions.", "keywords": []}, {"id": 126, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#compatibility-and-requirements", "display_name": "Compatibility and Requirements", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "compatibility-and-requirements", "priority": -1, "content": "The Compute Sanitizer tools require CUDA 11.0 or newer. The Compute Sanitizer API requires CUDA 10.1 or newer. Compute Sanitizer API calls will fail with SANITIZER_ERROR_NOT_INITIALIZED if the CUDA driver version is not compatible with the Compute Sanitizer version.", "keywords": []}, {"id": 127, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#device-graph-launch", "display_name": "Device graph launch", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "device-graph-launch", "priority": -1, "content": "When the application instrumented by the Compute Sanitizer API makes use of device launched CUDA graphs, the following behaviors are to be taken into account: No callbacks will be called from the host when a CUDA graph is launched from the device. However, graph launch-related callbacks are still called when a device launchable graph is launched from the host, or uploaded. Patching API issued callbacks on the device when inside a device launched CUDA graph may have a userdata from a different node if different userdata pointers were set per node. To compensate these limitations, it is possible to set a device launched graph specific data using sanitizerSetDeviceGraphData . It can be called during the launch on the host of a device launchable graph or of a graph containing device graph launches. The data set with sanitizerSetDeviceGraphData will then be retrievable from any device graph launched from this host launched graph. To retrieve this data from a patching API device callback, the following code can be used: void* userdata = **((void***)cudaGetCurrentGraphExec()); It is however recommended to perform NULL checks at each dereferencing.", "keywords": []}, {"id": 128, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#driver-and-runtime-api-callbacks", "display_name": "Driver and Runtime API Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "driver-and-runtime-api-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_DRIVER_API or SANITIZER_CB_DOMAIN_RUNTIME_API domains, a callback function can be associated with one or more CUDA API functions. When those CUDA functions are called in the application, the callback function is invoked as well. For these domains, the cbdata argument to the callback function will be of the type Sanitizer_CallbackData . You can call cudaDeviceSynchronize , cudaStreamSynchronize , cuCtxSynchronize and cuStreamSynchronize from within a driver or runtime API callback function. The following code shows a typical sequence used to associate a callback function with one or more CUDA API functions. For simplicity, error checking code was removed. Sanitizer_SubscriberHandle handle; MyDataStruct *my_data = ...; ... sanitizerSubscribe(&amp;handle, my_callback, my_data); sanitizerEnableDomain(1, handle, SANITIZER_CB_DOMAIN_RUNTIME_API); First, sanitizerSubscribe is used to initialize a subscriber with the my_callback callback function. Next, sanitizerEnableDomain is used to associate that callback with all the CUDA runtime functions. Using this code sequence will cause my_callback to be called twice each time any of the CUDA runtime API functions are invoked, once on entry to the CUDA function and once just before the CUDA function exits. Compute Sanitizer callback API functions sanitizerEnableCallback and sanitizerEnableAllDomains can also be used to associate CUDA API functions with a callback. The following code shows a typical callback function. void SANITIZERAPI my_callback(void *userdata, Sanitizer_CallbackDomain domain, Sanitizer_CallbackId cbid, const void *cbdata) { const Sanitizer_CallbackData *cbInfo = (Sanitizer_CallbackData *)cbdata; MyDataStruct *my_data = (MyDataStruct *)userdata; if ((domain == SANITIZER_CB_DOMAIN_RUNTIME_API) &amp;&amp; (cbid == SANITIZER_RUNTIME_TRACE_CBID_cudaMemcpy_v3020) &amp;&amp; (cbInfo-&gt;callbackSite == SANITIZER_API_ENTER)) { cudaMemcpy_v3020_params *funcParams = (cudaMemcpy_v3020_params *)(cbInfo-&gt;functionParams); size_t count = funcParams-&gt;count; enum cudaMemcpyKind kind = funcParams-&gt;kind ... } ... } In the callback function, Sanitizer_CallbackDomain and Sanitizer_CallbackId parameters can be used to determine which CUDA API function invocation is triggering this callback. In the example above, we are checking for the CUDA runtime cudaMemcpy function. The cbdata parameter holds a structure of useful information that can be used within the callback. In this case, we use the callbackSite member of the structure to detect that the callback is occurring on entry to cudaMemcpy , and we use the functionParams member to access the parameters to cudaMemcpy . To access the parameters, we first cast functionParams to a structure type corresponding to the cudaMemcpy function. These parameter structures are contained in generated_cuda_runtime_api_meta.h , generated_cuda_meta.h and a number of other files.", "keywords": []}, {"id": 129, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#insert-a-patch", "display_name": "Insert a Patch", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "insert-a-patch", "priority": -1, "content": "Once the patch has been generated, it can be inserted into user code by using the following procedure: Load the patch . There are two APIs used to load the patch: sanitizerAddPatchesFromFile and sanitizerAddPatches . They use the same input format as cuModuleLoad and cuModuleLoadData , respectively. Select which instructions to patch by using the sanitizerPatchInstructions API. Patch user code by using the sanitizerPatchModule API. Optionally, set the callback data for patches by using the sanitizerSetCallbackData API. The following code shows a typical sequence using these APIs. For simplicity, error checking was removed. CUcontext ctx = ... // current CUDA context sanitizerAddPatchesFromFile(&quot;MySanitizerPatches.cubin&quot;, ctx); CUmodule module = ... // module containing the user code sanitizerPatchInstructions(SANITIZER_INSTRUCTION_MEMORY_ACCESS, module, &quot;my_memory_access_callback&quot;); sanitizerPatchModule(module); MyDeviceDataTracker *deviceDataTracker; cudaMalloc(&amp;deviceDataTracker, sizeof(*deviceDataTracker)); CUfunction function = ... // kernel to be launched for which we want to set the callbackdata for the patches sanitizerSetCallbackData(function, deviceDataTracker); All subsequent launches using code from this CUDA module will be instrumented and my_memory_access_callback will be invoked before every memory access. However, the callback data is only set for all subsequent launches of the given kernel. An easy way to have a kernel CUfunction , is through the Sanitizer launch callbacks. Instrumentation can be removed by using the sanitizerUnpatchModule API.", "keywords": []}, {"id": 130, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#launch-callbacks", "display_name": "Launch Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "launch-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_LAUNCH domain, a callback function can be associated with CUDA kernel launches. For example, when a CUDA kernel launch has started, the callback function is invoked with a callback ID equal to SANITIZER_CBID_LAUNCH_BEGIN . For this domain, the cbdata argument is of the type Sanitizer_LaunchData .", "keywords": []}, {"id": 131, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#limitations", "display_name": "Limitations", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "limitations", "priority": -1, "content": "No known issues at this time. Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 132, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#memcpy-callbacks", "display_name": "Memcpy Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "memcpy-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_MEMCPY domain, a callback function can be associated with CUDA memcpy operations. For example, when a cudaMemcpy API function is called, the callback function is invoked with a callback ID equal to SANITIZER_CBID_MEMCPY_STARTING . For this domain, the cbdata argument is of the type Sanitizer_MemcpyData .", "keywords": []}, {"id": 133, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#memory-api", "display_name": "Memory API", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "memory-api", "priority": -1, "content": "The Compute Sanitizer Memory API provides replacement functions for the CUDA Memory API that can be safely called from within Compute Sanitizer callbacks . sanitizerAlloc is a replacement for cudaMalloc . sanitizerFree is a replacement for cudaFree . sanitizerMemcpyHostToDeviceAsync is a replacement for cudaMemcpyAsync for host-to-device copies. sanitizerMemcpyDeviceToHost is a replacement for cudaMemcpy for device-to-host copies. sanitizerMemset is a replacement for cudaMemset . These functions can also be called in normal user code, where they can be mixed with the CUDA API. For instance, memory allocated with sanitizerAlloc can be freed with cudaFree . However, since only CUDA API calls will cause callbacks to be invoked, this can lead to an incoherent tracking state and should be avoided.", "keywords": []}, {"id": 134, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#memset-callbacks", "display_name": "Memset Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "memset-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_MEMSET domain, a callback function can be associated with CUDA memset operations. For example, when a cudaMemset API function is called, the callback function is invoked with a callback ID equal to SANITIZER_CBID_MEMSET_STARTING . For this domain, the cbdata argument is of the type Sanitizer_MemsetData .", "keywords": []}, {"id": 135, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#overview", "display_name": "Overview", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "overview", "priority": -1, "content": "The Compute Sanitizer API enables the creation of sanitizing and tracing tools that target CUDA applications. Examples of such tools are memory and race condition checkers. The Compute Sanitizer API is composed of three APIs: the callback API, the patching API and the memory API. It is delivered as a dynamic library on supported platforms.", "keywords": []}, {"id": 136, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#patching-api", "display_name": "Patching API", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "patching-api", "priority": -1, "content": "The Compute Sanitizer Patching API allows you to load patch functions and insert them into user code. Patch functions will be invoked when the application\u2019s CUDA code executes certain instructions or calls certain CUDA device functions. The following terminology is used by the Patching API: Instruction ID : Each patchable event is given a unique ID than can be passed to patching API functions to specify that these events should be patched. Instruction IDs are defined by Sanitizer_InstructionId . Instrumentation point : A location in the original CUDA code that is being instrumented by the Compute Sanitizer API. Upon execution, the user code path is modified so that a patch gets executed either before or after the patched event. All patches are executed prior to the event, with the exception of device-side malloc. Patch : A CUDA __device__ function that the Compute Sanitizer will insert into another existing CUDA code. Patch function signatures must match the one expected by the API (see below for the expected signature types).", "keywords": []}, {"id": 137, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#resource-callbacks", "display_name": "Resource Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "resource-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_RESOURCE domain, a callback function can be associated with some CUDA resource creation and destruction events. For example, when a CUDA context is created, the callback function is invoked with a callback ID equal to SANITIZER_CBID_RESOURCE_CONTEXT_CREATED . For this domain, the cbdata argument is one of the following types: Sanitizer_ResourceContextData for CUDA context creation and destruction Sanitizer_ResourceStreamData for CUDA stream creation and destruction Sanitizer_ResourceModuleData for CUDA module load and unload Sanitizer_ResourceMemoryData for CUDA memory allocation and de-allocation", "keywords": []}, {"id": 138, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#special-cases", "display_name": "Special cases", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "special-cases", "priority": -1, "content": "In some specific scenarios, the Compute Sanitizer API may behave differently from the general cases. These scenarios are listed in this section.", "keywords": []}, {"id": 139, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#synchronization-callbacks", "display_name": "Synchronization Callbacks", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "synchronization-callbacks", "priority": -1, "content": "Using the Callback API with the SANITIZER_CB_DOMAIN_SYNCHRONIZE domain, a callback function can be associated with CUDA context and stream synchronizations. For example, when a CUDA context is synchronized, the callback function is invoked with a callback ID equal to SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED . For this domain, the cbdata argument is of the type Sanitizer_SynchronizeData .", "keywords": []}, {"id": 140, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "page", "name": "SanitizerApiGuide/index#writing-a-patch", "display_name": "Writing a Patch", "type": "section", "display_type": "Page section", "docname": "SanitizerApiGuide/index", "anchor": "writing-a-patch", "priority": -1, "content": "The patch must follow the function signature required by the Compute Sanitizer API for a given instruction ID. The mapping of instruction ID to function signature is documented in the comments of Sanitizer_InstructionId in sanitizer_patching.h . For instance, if we wish to patch a memory access using the instruction ID SANITIZER_INSTRUCTION_MEMORY_ACCESS , we need to use the SanitizerCallbackMemoryAccess type. extern &quot;C&quot; __device__ SanitizerPatchResult SANITIZERAPI my_memory_access_callback( void* userdata, uint64_t pc, void* ptr, uint32_t accessSize, uint32_t flags) { MyDeviceDataStruct *my_data = (MyDeviceDataStruct *)userdata if ((flags &amp; SANITIZER_MEMORY_DEVICE_FLAG_WRITE) != 0) // log write else // log read return SANITIZER_PATCH_SUCCESS; } In this patch, we log write and read accesses to a structure we allocated previously. extern &quot;C&quot; ensures that the patch name will not be mangled, allowing us to use its name as a string directly in calls to sanitizerPatchInstructions (see below ). There can be multiple patches defined in a single CUDA file. This file must then be compiled using the following nvcc options: $ nvcc --cubin --compile-as-tools-patch MySanitizerPatches.cu -o MySanitizerPatches.cubin The --cubin option can be replaced by --fatbin if a fatbin is preferred over a cubin as the output file.", "keywords": []}, {"id": 141, "doc_id": 141, "filename": "SanitizerApiGuide/index.html", "domain_name": "std", "name": "SanitizerApiGuide/index", "display_name": "Compute Sanitizer API Reference Manual", "type": "doc", "display_type": "Page", "docname": "SanitizerApiGuide/index", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 142, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#advanced-permissions-management", "display_name": "Advanced Permissions Management", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "advanced-permissions-management", "priority": -1, "content": "Permissions can be assigned to a specific stream scope thanks to custom permissions objects. You can create one using nvtxMemPermissionsCreate , and bind it to a scope using nvtxMemPermissionsBind . The following example restricts the allocation at address ptr to read-only permissions. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; and &lt;nvtx3/nvToolsExtMemCudaRt.h&gt; // Create new permissions object. auto permHandle = nvtxMemPermissionsCreate(nvtxDomain, NVTX_MEM_PERMISSIONS_CREATE_FLAGS_NONE); nvtxMemPermissionsAssignRegionDesc_t nvtxPermDesc; nvtxPermDesc.flags = NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ; nvtxPermDesc.regionRefType = NVTX_MEM_REGION_REF_TYPE_POINTER; nvtxPermDesc.region.pointer = ptr; nvtxMemPermissionsAssignBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemPermissionsAssignBatch_t); nvtxRegionsDesc.permissions = permHandle; nvtxRegionsDesc.regionCount = 1; nvtxRegionsDesc.regionElementSize = sizeof(nvtxMemPermissionsAssignRegionDesc_t); nvtxRegionsDesc.regionElements = &amp;nvtxPermDesc; // Assign read-only permissions to allocation at address ptr. // Permissions will be applied on scope bound to permHandle. nvtxMemPermissionsAssign(nvtxDomain, &amp;nvtxRegionsDesc); // Binding will happen on next kernel launch on this CPU thread, meaning the // stream for this launch will be the one bound to this permissions object. nvtxMemPermissionsBind( nvtxDomain, permHandle, NVTX_MEM_PERMISSIONS_BIND_SCOPE_CUDA_STREAM, NVTX_MEM_PERMISSIONS_BIND_FLAGS_NONE); // permHandle is now bound to stream. MyKernel&lt;&lt;&lt;BlocksNb, ThreadsNb, 0, stream&gt;&gt;&gt;(ptr); On permissions object creation or binding, you can specify inheritance restriction flags. For example, excluding write permissions will block access for all allocations with unassigned permissions on that scope. These are applied: nvtxMemPermissionsCreate : applied for kernel launches on stream bound to the created object. nvtxMemPermissionsBind : applied for next kernel launch (on this CPU thread) and others using the same stream. Please note that Compute Sanitizer only supports nvtxMemPermissionsBind with parameter scope = NVTX_MEM_PERMISSIONS_BIND_SCOPE_CUDA_STREAM . Permissions objects currently bound can be unbound using nvtxMemPermissionsUnbind and destroyed using nvtxMemPermissionsDestroy . Permissions object destruction will result in an unbinding. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemPermissionsUnbind(nvtxDomain, NVTX_MEM_PERMISSIONS_BIND_SCOPE_CUDA_STREAM) nvtxMemPermissionsDestroy(nvtxDomain, permHandle); Please note that Compute Sanitizer only supports nvtxMemPermissionsUnbind with parameter scope = NVTX_MEM_PERMISSIONS_BIND_SCOPE_CUDA_STREAM . Peer devices access can be restricted for all allocations using nvtxMemCudaSetPeerAccess . If no permissions are set on an active scope for an allocation using nvtxMemPermissionsAssign , then default permissions set using nvtxMemCudaSetPeerAccess are applied. The following example restricts accesses to read-only on all devices except device . // Requires &lt;nvtx3/nvToolsExtMem.h&gt; auto permHandle = nvtxMemCudaGetDeviceWidePermissions(nvtxDomain, device); nvtxMemCudaSetPeerAccess( nvtxDomain, permHandle, NVTX_MEM_CUDA_PEER_ALL_DEVICES, NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ); nvtxMemCudaSetPeerAccess( nvtxDomain, permHandle, device, NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ | NVTX_MEM_PERMISSIONS_REGION_FLAGS_WRITE | NVTX_MEM_PERMISSIONS_REGION_FLAGS_ATOMIC);", "keywords": []}, {"id": 143, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#basic-permissions-management", "display_name": "Basic Permissions Management", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "basic-permissions-management", "priority": -1, "content": "NVTX Permissions API allows any allocation permissions to be restricted using nvtxMemPermissionsAssign . For this example, we use the global program scope (by calling nvtxMemCudaGetProcessWidePermissions ), meaning permissions are applied on all kernel launches. This example restricts the allocation at address ptr to read-only permissions. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; and &lt;nvtx3/nvToolsExtMemCudaRt.h&gt; auto processPermHandle = nvtxMemCudaGetProcessWidePermissions(nvtxDomain); nvtxMemPermissionsAssignRegionDesc_t nvtxPermDesc; nvtxPermDesc.flags = NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ; nvtxPermDesc.regionRefType = NVTX_MEM_REGION_REF_TYPE_POINTER; nvtxPermDesc.region.pointer = ptr; nvtxMemPermissionsAssignBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemPermissionsAssignBatch_t); nvtxRegionsDesc.permissions = processPermHandle; nvtxRegionsDesc.regionCount = 1; nvtxRegionsDesc.regionElementSize = sizeof(nvtxMemPermissionsAssignRegionDesc_t); nvtxRegionsDesc.regionElements = &amp;nvtxPermDesc; nvtxMemPermissionsAssign(nvtxDomain, &amp;nvtxRegionsDesc); Valid permissions are: Read: NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ Write: NVTX_MEM_PERMISSIONS_REGION_FLAGS_WRITE Atomic: NVTX_MEM_PERMISSIONS_REGION_FLAGS_ATOMIC A combination of read, write and atomic (using XORs). Reset: NVTX_MEM_PERMISSIONS_REGION_FLAGS_RESET Using special permission NVTX_MEM_PERMISSIONS_REGION_FLAGS_RESET resets assigned permissions for the specified allocation on the specified scope. Allocations permissions can be restricted on a per-device basis, using nvtxMemCudaGetDeviceWidePermissions . The following example gets the permissions handle from device device , a handle that is used with nvtxMemPermissionsAssign to change permissions for the allocation at address ptr , previously restricted to read-only on the global scope, and now read-write for kernel launched on device (no atomic allowed). // Requires &lt;nvtx3/nvToolsExtMem.h&gt; and &lt;nvtx3/nvToolsExtMemCudaRt.h&gt; auto devicePermHandle = nvtxMemCudaGetDeviceWidePermissions(nvtxDomain, device); nvtxMemPermissionsAssignRegionDesc_t nvtxPermDesc; nvtxPermDesc.flags = NVTX_MEM_PERMISSIONS_REGION_FLAGS_READ | NVTX_MEM_PERMISSIONS_REGION_FLAGS_WRITE; nvtxPermDesc.regionRefType = NVTX_MEM_REGION_REF_TYPE_POINTER; nvtxPermDesc.region.pointer = ptr; nvtxMemPermissionsAssignBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemPermissionsAssignBatch_t); nvtxRegionsDesc.permissions = devicePermHandle; nvtxRegionsDesc.regionCount = 1; nvtxRegionsDesc.regionElementSize = sizeof(nvtxMemPermissionsAssignRegionDesc_t); nvtxRegionsDesc.regionElements = &amp;nvtxPermDesc; nvtxMemPermissionsAssign(nvtxDomain, &amp;nvtxRegionsDesc);", "keywords": []}, {"id": 144, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#compatibility-and-requirements", "display_name": "Compatibility and Requirements", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "compatibility-and-requirements", "priority": -1, "content": "The Compute Sanitizer tools require CUDA 11.0 or newer. The NVTX Memory API is supported by Compute Sanitizer starting CUDA 11.3, using the --nvtx yes option. Starting CUDA 12.0, this option is enabled by default. Compute Sanitizer requires the CUDA runtime to be initialized before calling NVTX. // NVTX calls are not allowed before CUDA runtime initialization. // Forces CUDA runtime initialization. cudaFree(0); // NVTX calls are now allowed. NVTX structures must be zero-initialized. Examples on this page use C++ empty initializer ( {} ). If you are using C, you can use memset or use the intializer syntax with at least one field (C does not support empty initalizers).", "keywords": []}, {"id": 145, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#limitations", "display_name": "Limitations", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "limitations", "priority": -1, "content": "Please note the Compute Sanitizer support for NVTX Memory API has the following limitations: Allocation names are visible on leak and unused memory reports, but not on other error reports for now. Allocation names must be encoded in ASCII, contain only printable characters, and contain between 1 and 49 characters (must comply to the following regex: ^[:print:]{1,49}$ ) Permissions are only applied to kernel launches. Other operations, such as cudaMemcpy or cudaMemset , are not supported for now. Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 146, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#mark-initialized-api", "display_name": "Mark initialized API", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "mark-initialized-api", "priority": -1, "content": "Any memory range can be marked as initialized to exclude it from checks performed by the Initcheck tool. The typical use case is when some structure includes padding bytes and user wants to exclude padding bytes from checks. The following example demonstrates marking padding bytes of o Object as initialized. // Requires &lt;nvtx3/nvToolsExtMemCudaRt.h&gt; struct Object { char a; int b; }; __global__ void kernel(Object* o) { o-&gt;a = 0; // 3 bytes of padding after `a` are uninitialized. o-&gt;b = 0; } int main(void) { Object* d_o; Object* h_o; cudaMalloc(&amp;d_o, sizeof(*d_o)); cudaMallocHost(&amp;h_o, sizeof(*h_o)); kernel&lt;&lt;&lt;1, 1&gt;&gt;&gt;(d_o); // Mark the padding bytes of `o` as initialized. { auto nvtxDomain = nvtxDomainCreateA(&quot;my-domain&quot;); nvtxMemVirtualRangeDesc_t nvtxRangeDesc = {}; // 3 bytes at offset 1 nvtxRangeDesc.ptr = reinterpret_cast&lt;char*&gt;(d_o) + 1; nvtxRangeDesc.size = 3; nvtxMemMarkInitializedBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxRegionsDesc); nvtxRegionsDesc.regionType = NVTX_MEM_TYPE_VIRTUAL_ADDRESS; nvtxRegionsDesc.regionDescCount = 1; nvtxRegionsDesc.regionDescElementSize = sizeof(nvtxRangeDesc); nvtxRegionsDesc.regionDescElements = &amp;nvtxRangeDesc; nvtxMemCudaMarkInitialized(nvtxDomain, 0, false, &amp;nvtxRegionsDesc); } cudaMemcpy(h_o, d_o, sizeof(*h_o), cudaMemcpyDeviceToHost); cudaDeviceSynchronize(); }", "keywords": []}, {"id": 147, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#naming-api", "display_name": "Naming API", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "naming-api", "priority": -1, "content": "Any allocation can be assigned a name, so future Compute Sanitizer error reports can refer to an allocation by its name. This example names the allocation at address ptr : \u201cMy Allocation\u201d. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemRegionNameDesc_t nvtxLabelDesc; nvtxLabelDesc.regionRefType = NVTX_MEM_REGION_REF_TYPE_POINTER; nvtxLabelDesc.nameType = NVTX_MESSAGE_TYPE_ASCII; nvtxLabelDesc.region.pointer = ptr; nvtxLabelDesc.name.ascii = &quot;My Allocation&quot;; nvtxMemRegionsNameBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemRegionsNameBatch_t); nvtxRegionsDesc.regionCount = 1; nvtxRegionsDesc.regionElementSize = sizeof(nvtxMemRegionNameDesc_t); nvtxRegionsDesc.regionElements = &amp;nvtxLabelDesc; nvtxMemRegionsName(nvtxDomain, &amp;nvtxRegionsDesc); Please note that Compute Sanitizer only supports nvtxMemRegionsName with parameter nameType = NVTX_MESSAGE_TYPE_ASCII for all region elements in regionElements . As of now, only leak and unused memory reporting features allocation names.", "keywords": []}, {"id": 148, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#nvtx-domain", "display_name": "NVTX Domain", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "nvtx-domain", "priority": -1, "content": "All NVTX calls requires you to create a NVTX domain. This can be achieved using nvtxDomainCreateA . // Requires &lt;nvtx3/nvToolsExt.h&gt; auto nvtxDomain = nvtxDomainCreateA(&quot;my-domain&quot;); For now, NVTX domains have no specific usage, but will have one in a future Compute Sanitizer version.", "keywords": []}, {"id": 149, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#overview", "display_name": "Overview", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "overview", "priority": -1, "content": "The NVTX Memory API for Compute Sanitizer allows CUDA programs to notify Compute Sanitizer about memory restrictions: memory pools management or permissions restrictions, in addition to memory labeling. The tools are notified through NVTX (NVIDIA Tools Extension), a header-only C library used by various NVIDIA tools. The latest NVTX headers can be downloaded from the NVTX GitHub repository . This API has the following main goals: Programs can mark allocations as memory pools, allowing Compute Sanitizer to be aware of which parts of this specific allocation are actually used. When using the Memcheck tool, you are notified if unregistered parts of the pool are accessed by the program, errors that could have been missed otherwise. When using the Initcheck tool, in combination with option --track-unused-memory , you are not notified for unused memory in non-registered regions, therefore avoiding false positives. Programs can label allocations with meaningful names, allowing you to identify an allocation associated to a specific error by its name (e.g., allocation that is leaking, or unused). Programs can restrict some allocations to a specific set of permissions (e.g., read-only or write-only) applicable for a specific scope (e.g., CUDA stream, device or whole program). When using the Memcheck tool, violation of these restrictions will result in an error. Programs can mark memory ranges as initialized to exclude them from checks performed by the Initcheck tool. This is useful to handle properly memory padding.", "keywords": []}, {"id": 150, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#pools-management", "display_name": "Pools Management", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "pools-management", "priority": -1, "content": "Any allocation created with cudaMalloc can be registered as a memory pool using nvtxMemHeapRegister . The following code example allocates 64 bytes and registers the allocation as a memory pool. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; void *ptr; cudaMalloc(&amp;ptr, 64); nvtxMemVirtualRangeDesc_t nvtxRangeDesc = {}; nvtxRangeDesc.size = 64; nvtxRangeDesc.ptr = ptr; nvtxMemHeapDesc_t nvtxHeapDesc = {}; nvtxHeapDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxHeapDesc.structSize = sizeof(nvtxMemHeapDesc_t); nvtxHeapDesc.usage = NVTX_MEM_HEAP_USAGE_TYPE_SUB_ALLOCATOR; nvtxHeapDesc.type = NVTX_MEM_TYPE_VIRTUAL_ADDRESS; nvtxHeapDesc.typeSpecificDescSize = sizeof(nvtxMemVirtualRangeDesc_t); nvtxHeapDesc.typeSpecificDesc = &amp;nvtxRangeDesc; auto nvtxPool = nvtxMemHeapRegister( nvtxDomain, &amp;nvtxHeapDesc); Please note that Compute Sanitizer only supports nvtxMemHeapRegister with parameters usage = NVTX_MEM_HEAP_USAGE_TYPE_SUB_ALLOCATOR and type = NVTX_MEM_TYPE_VIRTUAL_ADDRESS . If you are using the CUDA runtime API, nvtxMemHeapRegister can be used with allocations created with cuMemAlloc . An existing pool can be reset to its initial state using nvtxMemHeapReset . The following example resets the pool previously allocated. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemHeapReset(nvtxDomain, nvtxPool); In a similar fashion, a pool can be unregistered using nvtxMemHeapUnregister . An allocation cannot be used after it is unregistered, but the allocation must be freed using cudaFree to dispose of it. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemHeapUnregister(nvtxDomain, nvtxPool); For your convenience, calling cudaFree on a memory pool causes Compute Sanitizer to automatically unregister it.", "keywords": []}, {"id": 151, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "page", "name": "SanitizerNvtxGuide/index#suballocations-management", "display_name": "Suballocations Management", "type": "section", "display_type": "Page section", "docname": "SanitizerNvtxGuide/index", "anchor": "suballocations-management", "priority": -1, "content": "Once a pool is created, users can create suballocations within this pool using nvtxMemRegionsRegister . For your convenience, you can register multiple regions at the same time. The following example creates a suballocation of 16 bytes at address ptr . Both ptr and ptr + 16 bytes must be part of the pool. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemVirtualRangeDesc_t nvtxRangeDesc = {}; nvtxRangeDesc.size = 16; nvtxRangeDesc.ptr = ptr; nvtxMemRegionsRegisterBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemRegionsRegisterBatch_t); nvtxRegionsDesc.regionType = NVTX_MEM_TYPE_VIRTUAL_ADDRESS; nvtxRegionsDesc.heap = nvtxPool; nvtxRegionsDesc.regionCount = 1; nvtxRegionsDesc.regionDescElementSize = sizeof(nvtxMemVirtualRangeDesc_t); nvtxRegionsDesc.regionDescElements = &amp;nvtxRangeDesc; nvtxMemRegionsRegister(nvtxDomain, &amp;nvtxRegionsDesc); For your convenience, Initcheck assumes that a new suballocation is uninitialized, meaning failure to initialize it might result in error reports. Please note that Compute Sanitizer only supports nvtxMemRegionsRegister with parameter regionType = NVTX_MEM_TYPE_VIRTUAL_ADDRESS . Suballocations are considered as regular allocations for NVTX naming and permissions API, therefore it is possible to label them or change their permissions. Existing suballocations can be resized using nvtxMemRegionsResize . The following example resizes our previous suballocation at address ptr from 16 bytes to 32. // Requires &lt;nvtx3/nvToolsExtMem.h&gt; nvtxMemVirtualRangeDesc_t nvtxRangeDesc = {}; nvtxRangeDesc.size = 32; nvtxRangeDesc.ptr = ptr; nvtxMemRegionsResizeBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemRegionsResizeBatch_t); nvtxRegionsDesc.regionType = NVTX_MEM_TYPE_VIRTUAL_ADDRESS; nvtxRegionsDesc.regionDescCount = 1; nvtxRegionsDesc.regionDescElementSize = sizeof(nvtxMemVirtualRangeDesc_t); nvtxRegionsDesc.regionDescElements = &amp;nvtxRangeDesc; nvtxMemRegionsResize(nvtxDomain, &amp;nvtxRegionsDesc); In a similar fashion, existing allocations can be removed using nvtxMemRegionsUnregister . The following example removes our previous suballocation at address ptr . nvtxMemRegionRef_t nvtxRegionRef; nvtxRegionRef.pointer = ptr; nvtxMemRegionsUnregisterBatch_t nvtxRegionsDesc = {}; nvtxRegionsDesc.extCompatID = NVTX_EXT_COMPATID_MEM; nvtxRegionsDesc.structSize = sizeof(nvtxMemRegionsUnregisterBatch_t); nvtxRegionsDesc.refType = NVTX_MEM_REGION_REF_TYPE_POINTER; nvtxRegionsDesc.refCount = 1; nvtxRegionsDesc.refElementSize = sizeof(nvtxMemRegionRef_t); nvtxRegionsDesc.refElements = &amp;nvtxRegionRef; nvtxMemRegionsUnregister(nvtxDomain, &amp;nvtxRegionsDesc); Omitting to unregister a suballocation is reported as a memory leak if Compute Sanitizer is used in combination with option --leak-check=full .", "keywords": []}, {"id": 152, "doc_id": 152, "filename": "SanitizerNvtxGuide/index.html", "domain_name": "std", "name": "SanitizerNvtxGuide/index", "display_name": "NVTX API for Compute Sanitizer Reference Manual", "type": "doc", "display_type": "Page", "docname": "SanitizerNvtxGuide/index", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 153, "doc_id": 156, "filename": "api/group__SANITIZER__BARRIER__API.html", "domain_name": "cpp", "name": "sanitizerGetCudaBarrierCount", "display_name": "sanitizerGetCudaBarrierCount", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__BARRIER__API", "anchor": "_CPPv428sanitizerGetCudaBarrierCount10CUfunctionP8uint32_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCudaBarrierCount CUfunction  kernel uint32_t  * numBarriers Get number of CUDA barriers used by a function. The module where kernel resides must have been instrumented using sanitizerPatchModule prior to calling this function. This function is only available for modules built with nvcc 11.2 or newer, it will return 0 otherwise. Thread-safety : this function is thread safe. Parameters kernel \u2013 [in]  CUDA function. numBarriers \u2013 [out]  Number of CUDA barriers in the input CUDA function.", "keywords": []}, {"id": 154, "doc_id": 156, "filename": "api/group__SANITIZER__BARRIER__API.html", "domain_name": "cpp", "name": "sanitizerGetCudaBarrierCount::kernel", "display_name": "sanitizerGetCudaBarrierCount::kernel", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__BARRIER__API", "anchor": "_CPPv428sanitizerGetCudaBarrierCount10CUfunctionP8uint32_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCudaBarrierCount CUfunction  kernel uint32_t  * numBarriers Get number of CUDA barriers used by a function. The module where kernel resides must have been instrumented using sanitizerPatchModule prior to calling this function. This function is only available for modules built with nvcc 11.2 or newer, it will return 0 otherwise. Thread-safety : this function is thread safe. Parameters kernel \u2013 [in]  CUDA function. numBarriers \u2013 [out]  Number of CUDA barriers in the input CUDA function.", "keywords": []}, {"id": 155, "doc_id": 156, "filename": "api/group__SANITIZER__BARRIER__API.html", "domain_name": "cpp", "name": "sanitizerGetCudaBarrierCount::numBarriers", "display_name": "sanitizerGetCudaBarrierCount::numBarriers", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__BARRIER__API", "anchor": "_CPPv428sanitizerGetCudaBarrierCount10CUfunctionP8uint32_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCudaBarrierCount CUfunction  kernel uint32_t  * numBarriers Get number of CUDA barriers used by a function. The module where kernel resides must have been instrumented using sanitizerPatchModule prior to calling this function. This function is only available for modules built with nvcc 11.2 or newer, it will return 0 otherwise. Thread-safety : this function is thread safe. Parameters kernel \u2013 [in]  CUDA function. numBarriers \u2013 [out]  Number of CUDA barriers in the input CUDA function.", "keywords": []}, {"id": 156, "doc_id": 156, "filename": "api/group__SANITIZER__BARRIER__API.html", "domain_name": "std", "name": "api/group__SANITIZER__BARRIER__API", "display_name": "Sanitizer Barrier API", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__BARRIER__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the Sanitizer Barrier API. Functions SanitizerResult  sanitizerGetCudaBarrierCount (CUfunction kernel, uint32_t *numBarriers) Get number of CUDA barriers used by a function.", "keywords": []}, {"id": 157, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_API_CBSITE_FORCE_INT", "display_name": "SANITIZER_API_CBSITE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite30SANITIZER_API_CBSITE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_API_CBSITE_FORCE_INT", "keywords": []}, {"id": 158, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_API_ENTER", "display_name": "SANITIZER_API_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite19SANITIZER_API_ENTERE", "priority": 1, "content": "enumerator  SANITIZER_API_ENTER This callback is at API entry.", "keywords": []}, {"id": 159, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_API_EXIT", "display_name": "SANITIZER_API_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite18SANITIZER_API_EXITE", "priority": 1, "content": "enumerator  SANITIZER_API_EXIT This callback is at API exit.", "keywords": []}, {"id": 160, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_BATCH_MEMOP_TYPE_32B", "display_name": "SANITIZER_BATCH_MEMOP_TYPE_32B", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType30SANITIZER_BATCH_MEMOP_TYPE_32BE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_32B Batch memory operation size is 32 bits.", "keywords": []}, {"id": 161, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_BATCH_MEMOP_TYPE_64B", "display_name": "SANITIZER_BATCH_MEMOP_TYPE_64B", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType30SANITIZER_BATCH_MEMOP_TYPE_64BE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_64B Batch memory operation size is 64 bits.", "keywords": []}, {"id": 162, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "display_name": "SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType36SANITIZER_BATCH_MEMOP_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "keywords": []}, {"id": 163, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "display_name": "SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop36SANITIZER_CBID_BATCH_MEMOP_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "keywords": []}, {"id": 164, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_BATCH_MEMOP_INVALID", "display_name": "SANITIZER_CBID_BATCH_MEMOP_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop34SANITIZER_CBID_BATCH_MEMOP_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_INVALID Invalid batch memop callback ID.", "keywords": []}, {"id": 165, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_BATCH_MEMOP_SIZE", "display_name": "SANITIZER_CBID_BATCH_MEMOP_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop31SANITIZER_CBID_BATCH_MEMOP_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_SIZE", "keywords": []}, {"id": 166, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_BATCH_MEMOP_WRITE", "display_name": "SANITIZER_CBID_BATCH_MEMOP_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop32SANITIZER_CBID_BATCH_MEMOP_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_WRITE A batch memory operation was initiated.", "keywords": []}, {"id": 167, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_CREATED", "display_name": "SANITIZER_CBID_EVENTS_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents29SANITIZER_CBID_EVENTS_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_CREATED An event was created.", "keywords": []}, {"id": 168, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_DESTROYED", "display_name": "SANITIZER_CBID_EVENTS_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents31SANITIZER_CBID_EVENTS_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_DESTROYED An event was destroyed.", "keywords": []}, {"id": 169, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_FORCE_INT", "display_name": "SANITIZER_CBID_EVENTS_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents31SANITIZER_CBID_EVENTS_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_FORCE_INT", "keywords": []}, {"id": 170, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_INVALID", "display_name": "SANITIZER_CBID_EVENTS_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents29SANITIZER_CBID_EVENTS_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_INVALID Invalid event callback ID.", "keywords": []}, {"id": 171, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_RECORD", "display_name": "SANITIZER_CBID_EVENTS_RECORD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents28SANITIZER_CBID_EVENTS_RECORDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_RECORD An event was recorded.", "keywords": []}, {"id": 172, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_SIZE", "display_name": "SANITIZER_CBID_EVENTS_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents26SANITIZER_CBID_EVENTS_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_SIZE", "keywords": []}, {"id": 173, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_STREAM_WAIT", "display_name": "SANITIZER_CBID_EVENTS_STREAM_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents33SANITIZER_CBID_EVENTS_STREAM_WAITE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_STREAM_WAIT A stream was synchronized to an event.", "keywords": []}, {"id": 174, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EVENTS_SYNCHRONIZE", "display_name": "SANITIZER_CBID_EVENTS_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents33SANITIZER_CBID_EVENTS_SYNCHRONIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_SYNCHRONIZE An event was synchronized.", "keywords": []}, {"id": 175, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory40SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED External memory was destroyed.", "keywords": []}, {"id": 176, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory40SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "keywords": []}, {"id": 177, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory37SANITIZER_CBID_EXTERNAL_MEMORY_IMPORTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT External memory was imported.", "keywords": []}, {"id": 178, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_INVALID", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory38SANITIZER_CBID_EXTERNAL_MEMORY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_INVALID Invalid external memory callback ID.", "keywords": []}, {"id": 179, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory37SANITIZER_CBID_EXTERNAL_MEMORY_MAPPEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED External memory was mapped.", "keywords": []}, {"id": 180, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "display_name": "SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory35SANITIZER_CBID_EXTERNAL_MEMORY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "keywords": []}, {"id": 181, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_FORCE_INT", "display_name": "SANITIZER_CBID_GRAPHS_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs31SANITIZER_CBID_GRAPHS_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_FORCE_INT", "keywords": []}, {"id": 182, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED", "display_name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs39SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED A new graphexec is created.", "keywords": []}, {"id": 183, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING", "display_name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs40SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING A new graphexec is being created.", "keywords": []}, {"id": 184, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING", "display_name": "SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs42SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING A graphexec is being destroyed.", "keywords": []}, {"id": 185, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_INVALID", "display_name": "SANITIZER_CBID_GRAPHS_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs29SANITIZER_CBID_GRAPHS_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_INVALID Invalid graphs callback ID.", "keywords": []}, {"id": 186, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN", "display_name": "SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs34SANITIZER_CBID_GRAPHS_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN A graph launch was initiated.", "keywords": []}, {"id": 187, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_LAUNCH_END", "display_name": "SANITIZER_CBID_GRAPHS_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs32SANITIZER_CBID_GRAPHS_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_LAUNCH_END A graph launch is complete.", "keywords": []}, {"id": 188, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN", "display_name": "SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs39SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN A node launch was initiated.", "keywords": []}, {"id": 189, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END", "display_name": "SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs37SANITIZER_CBID_GRAPHS_NODE_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END A node launch is complete.", "keywords": []}, {"id": 190, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_GRAPHS_SIZE", "display_name": "SANITIZER_CBID_GRAPHS_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs26SANITIZER_CBID_GRAPHS_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_SIZE", "keywords": []}, {"id": 191, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP", "display_name": "SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch41SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUPE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP A grid launch has completed syscalls setup.", "keywords": []}, {"id": 192, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_BEGIN", "display_name": "SANITIZER_CBID_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch27SANITIZER_CBID_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_BEGIN A grid launch was initiated.", "keywords": []}, {"id": 193, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_END", "display_name": "SANITIZER_CBID_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch25SANITIZER_CBID_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_END The grid launch is complete.", "keywords": []}, {"id": 194, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_FORCE_INT", "display_name": "SANITIZER_CBID_LAUNCH_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch31SANITIZER_CBID_LAUNCH_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_FORCE_INT", "keywords": []}, {"id": 195, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_INVALID", "display_name": "SANITIZER_CBID_LAUNCH_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch29SANITIZER_CBID_LAUNCH_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_INVALID Invalid launch callback ID.", "keywords": []}, {"id": 196, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_LAUNCH_SIZE", "display_name": "SANITIZER_CBID_LAUNCH_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch26SANITIZER_CBID_LAUNCH_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_SIZE", "keywords": []}, {"id": 197, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMCPY_FORCE_INT", "display_name": "SANITIZER_CBID_MEMCPY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy31SANITIZER_CBID_MEMCPY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_FORCE_INT", "keywords": []}, {"id": 198, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMCPY_INVALID", "display_name": "SANITIZER_CBID_MEMCPY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy29SANITIZER_CBID_MEMCPY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_INVALID Invalid memcpy callback ID.", "keywords": []}, {"id": 199, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMCPY_SIZE", "display_name": "SANITIZER_CBID_MEMCPY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy26SANITIZER_CBID_MEMCPY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_SIZE", "keywords": []}, {"id": 200, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMCPY_STARTING", "display_name": "SANITIZER_CBID_MEMCPY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy30SANITIZER_CBID_MEMCPY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_STARTING A memcpy operation was initiated.", "keywords": []}, {"id": 201, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMSET_FORCE_INT", "display_name": "SANITIZER_CBID_MEMSET_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset31SANITIZER_CBID_MEMSET_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_FORCE_INT", "keywords": []}, {"id": 202, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMSET_INVALID", "display_name": "SANITIZER_CBID_MEMSET_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset29SANITIZER_CBID_MEMSET_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_INVALID Invalid memset callback ID.", "keywords": []}, {"id": 203, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMSET_SIZE", "display_name": "SANITIZER_CBID_MEMSET_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset26SANITIZER_CBID_MEMSET_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_SIZE", "keywords": []}, {"id": 204, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_MEMSET_STARTING", "display_name": "SANITIZER_CBID_MEMSET_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset30SANITIZER_CBID_MEMSET_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_STARTING A memset operation was initiated.", "keywords": []}, {"id": 205, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_ARRAY_CREATED", "display_name": "SANITIZER_CBID_RESOURCE_ARRAY_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_ARRAY_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_ARRAY_CREATED A CUDA array was created.", "keywords": []}, {"id": 206, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED", "display_name": "SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_ARRAY_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED A CUDA array was destroyed.", "keywords": []}, {"id": 207, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED", "display_name": "SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource49SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED A new context was created.", "keywords": []}, {"id": 208, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING", "display_name": "SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource49SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING A new context is about to be created.", "keywords": []}, {"id": 209, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED", "display_name": "SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource48SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED A context was destroyed.", "keywords": []}, {"id": 210, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "display_name": "SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource48SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING A context is about to be destroyed.", "keywords": []}, {"id": 211, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC", "display_name": "SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource43SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC Device memory was allocated.", "keywords": []}, {"id": 212, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE", "display_name": "SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE Device memory was freed.", "keywords": []}, {"id": 213, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_FORCE_INT", "display_name": "SANITIZER_CBID_RESOURCE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource33SANITIZER_CBID_RESOURCE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FORCE_INT", "keywords": []}, {"id": 214, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED", "display_name": "SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource45SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED CUDA functions were loaded lazily and are fully loaded.", "keywords": []}, {"id": 215, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED", "display_name": "SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED CUDA lazily loaded functions were patched.", "keywords": []}, {"id": 216, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC", "display_name": "SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource41SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC Pinned host memory was allocated.", "keywords": []}, {"id": 217, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE", "display_name": "SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource40SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE Pinned host memory was freed.", "keywords": []}, {"id": 218, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_INIT_FINISHED", "display_name": "SANITIZER_CBID_RESOURCE_INIT_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_INIT_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_INIT_FINISHED Driver initialization is finished.", "keywords": []}, {"id": 219, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_INVALID", "display_name": "SANITIZER_CBID_RESOURCE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource31SANITIZER_CBID_RESOURCE_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_INVALID Invalid resource callback ID.", "keywords": []}, {"id": 220, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC", "display_name": "SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC Memory was allocated asynchronously.", "keywords": []}, {"id": 221, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC", "display_name": "SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource41SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC Memory was freed asynchronously.", "keywords": []}, {"id": 222, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE", "display_name": "SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE Memory freed asynchronously was released, only happens if a regular allocation (cudaMalloc) is free\u2019d asynchronously (cudaFreeAsync). See CUDA runtime documentation for cudaFreeAsync.", "keywords": []}, {"id": 223, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED", "display_name": "SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_MEMPOOL_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED A new mempool was created.", "keywords": []}, {"id": 224, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING", "display_name": "SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING A mempool is about to be destroyed.", "keywords": []}, {"id": 225, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER", "display_name": "SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTERE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER A memory pool allocation was imported.", "keywords": []}, {"id": 226, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING", "display_name": "SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource53SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING A mempool is no longer accessible from a peer device.", "keywords": []}, {"id": 227, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED", "display_name": "SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource51SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED A mempool is now accessible from a peer device.", "keywords": []}, {"id": 228, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MODULE_LOADED", "display_name": "SANITIZER_CBID_RESOURCE_MODULE_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_MODULE_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MODULE_LOADED A module was loaded.", "keywords": []}, {"id": 229, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "display_name": "SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING A module is about to be unloaded.", "keywords": []}, {"id": 230, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_SIZE", "display_name": "SANITIZER_CBID_RESOURCE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource28SANITIZER_CBID_RESOURCE_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_SIZE", "keywords": []}, {"id": 231, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_STREAM_CREATED", "display_name": "SANITIZER_CBID_RESOURCE_STREAM_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource38SANITIZER_CBID_RESOURCE_STREAM_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_CREATED A new stream was created.", "keywords": []}, {"id": 232, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED", "display_name": "SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource47SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED A stream was destroyed.", "keywords": []}, {"id": 233, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING", "display_name": "SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource47SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING A stream is about to be destroyed.", "keywords": []}, {"id": 234, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE", "display_name": "SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE The CUDA driver released a virtual address range.", "keywords": []}, {"id": 235, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE", "display_name": "SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE The CUDA driver reserved a virtual address range.", "keywords": []}, {"id": 236, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "display_name": "SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync47SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED Context synchronization has completed for a given context.", "keywords": []}, {"id": 237, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "display_name": "SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync36SANITIZER_CBID_SYNCHRONIZE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "keywords": []}, {"id": 238, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_SYNCHRONIZE_INVALID", "display_name": "SANITIZER_CBID_SYNCHRONIZE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync34SANITIZER_CBID_SYNCHRONIZE_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_INVALID Invalid synchronize callback ID.", "keywords": []}, {"id": 239, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_SYNCHRONIZE_SIZE", "display_name": "SANITIZER_CBID_SYNCHRONIZE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync31SANITIZER_CBID_SYNCHRONIZE_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_SIZE", "keywords": []}, {"id": 240, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "display_name": "SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync46SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED Stream synchronization has completed for a given stream.", "keywords": []}, {"id": 241, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_UVM_ATTACH_MEM", "display_name": "SANITIZER_CBID_UVM_ATTACH_MEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm29SANITIZER_CBID_UVM_ATTACH_MEME", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_ATTACH_MEM Modify the stream association of an allocation (see cudaStreamAttachMemAsync)", "keywords": []}, {"id": 242, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_UVM_FORCE_ITN", "display_name": "SANITIZER_CBID_UVM_FORCE_ITN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm28SANITIZER_CBID_UVM_FORCE_ITNE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_FORCE_ITN", "keywords": []}, {"id": 243, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_UVM_INVALID", "display_name": "SANITIZER_CBID_UVM_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm26SANITIZER_CBID_UVM_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_INVALID Invalid managed memory callback ID.", "keywords": []}, {"id": 244, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CBID_UVM_SIZE", "display_name": "SANITIZER_CBID_UVM_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm23SANITIZER_CBID_UVM_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_SIZE", "keywords": []}, {"id": 245, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_BATCH_MEMOP", "display_name": "SANITIZER_CB_DOMAIN_BATCH_MEMOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_BATCH_MEMOPE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_BATCH_MEMOP Domain containing callback points for CUDA batch memop operations.", "keywords": []}, {"id": 246, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_DRIVER_API", "display_name": "SANITIZER_CB_DOMAIN_DRIVER_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain30SANITIZER_CB_DOMAIN_DRIVER_APIE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_DRIVER_API Domain containing callback points for all driver API functions.", "keywords": []}, {"id": 247, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_EVENTS", "display_name": "SANITIZER_CB_DOMAIN_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_EVENTSE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_EVENTS Domain containing callback points for CUDA events.", "keywords": []}, {"id": 248, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY", "display_name": "SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain35SANITIZER_CB_DOMAIN_EXTERNAL_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY Domain containing callback points for CUDA external memory.", "keywords": []}, {"id": 249, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_FORCE_INT", "display_name": "SANITIZER_CB_DOMAIN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain29SANITIZER_CB_DOMAIN_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_FORCE_INT", "keywords": []}, {"id": 250, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_GRAPHS", "display_name": "SANITIZER_CB_DOMAIN_GRAPHS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_GRAPHSE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_GRAPHS Domain containing callback points for CUDA graphs operations.", "keywords": []}, {"id": 251, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_INVALID", "display_name": "SANITIZER_CB_DOMAIN_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain27SANITIZER_CB_DOMAIN_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_INVALID Invalid domain.", "keywords": []}, {"id": 252, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_LAUNCH", "display_name": "SANITIZER_CB_DOMAIN_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_LAUNCHE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_LAUNCH Domain containing callback points for CUDA grid launches.", "keywords": []}, {"id": 253, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_MEMCPY", "display_name": "SANITIZER_CB_DOMAIN_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_MEMCPYE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_MEMCPY Domain containing callback points for CUDA memcpy operations.", "keywords": []}, {"id": 254, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_MEMSET", "display_name": "SANITIZER_CB_DOMAIN_MEMSET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_MEMSETE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_MEMSET Domain containing callback points for CUDA memset operations.", "keywords": []}, {"id": 255, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_RESOURCE", "display_name": "SANITIZER_CB_DOMAIN_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain28SANITIZER_CB_DOMAIN_RESOURCEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_RESOURCE Domain containing callback points for CUDA resource tracking.", "keywords": []}, {"id": 256, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_RUNTIME_API", "display_name": "SANITIZER_CB_DOMAIN_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_RUNTIME_APIE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_RUNTIME_API Domain containing callback points for all runtime API functions.", "keywords": []}, {"id": 257, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_SIZE", "display_name": "SANITIZER_CB_DOMAIN_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain24SANITIZER_CB_DOMAIN_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_SIZE", "keywords": []}, {"id": 258, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_SYNCHRONIZE", "display_name": "SANITIZER_CB_DOMAIN_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_SYNCHRONIZEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_SYNCHRONIZE Domain containing callback points for CUDA synchronization.", "keywords": []}, {"id": 259, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_CB_DOMAIN_UVM", "display_name": "SANITIZER_CB_DOMAIN_UVM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain23SANITIZER_CB_DOMAIN_UVME", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_UVM Domain containing callback points for CUDA managed memory operations.", "keywords": []}, {"id": 260, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE", "display_name": "SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection43SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE Memcpy from device to device.", "keywords": []}, {"id": 261, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST", "display_name": "SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection41SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST Memcpy from device to host.", "keywords": []}, {"id": 262, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "display_name": "SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection36SANITIZER_MEMCPY_DIRECTION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "keywords": []}, {"id": 263, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE", "display_name": "SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection41SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE Memcpy from host to device.", "keywords": []}, {"id": 264, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST", "display_name": "SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection39SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST Memcpy from host to host.", "keywords": []}, {"id": 265, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_SIZE", "display_name": "SANITIZER_MEMCPY_DIRECTION_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection31SANITIZER_MEMCPY_DIRECTION_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_SIZE", "keywords": []}, {"id": 266, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMCPY_DIRECTION_UNKNOWN", "display_name": "SANITIZER_MEMCPY_DIRECTION_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection34SANITIZER_MEMCPY_DIRECTION_UNKNOWNE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_UNKNOWN Unknown memcpy direction.", "keywords": []}, {"id": 267, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_CG_RUNTIME", "display_name": "SANITIZER_MEMORY_FLAG_CG_RUNTIME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags32SANITIZER_MEMORY_FLAG_CG_RUNTIMEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_CG_RUNTIME Specifies that the allocation is used by the Cooperative Groups runtime functions.", "keywords": []}, {"id": 268, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_CNP", "display_name": "SANITIZER_MEMORY_FLAG_CNP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags25SANITIZER_MEMORY_FLAG_CNPE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_CNP Specifies that this is an allocation used for CUDA Dynamic Parallelism purposes.", "keywords": []}, {"id": 269, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_FORCE_INT", "display_name": "SANITIZER_MEMORY_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags31SANITIZER_MEMORY_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_FORCE_INT", "keywords": []}, {"id": 270, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_HOST_MAPPED", "display_name": "SANITIZER_MEMORY_FLAG_HOST_MAPPED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_HOST_MAPPEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_HOST_MAPPED Species that the allocation accessible from the host.", "keywords": []}, {"id": 271, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_HOST_PINNED", "display_name": "SANITIZER_MEMORY_FLAG_HOST_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_HOST_PINNEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_HOST_PINNED Specifies that the allocation is pinned on the host.", "keywords": []}, {"id": 272, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_MANAGED", "display_name": "SANITIZER_MEMORY_FLAG_MANAGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags29SANITIZER_MEMORY_FLAG_MANAGEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_MANAGED Specifies that the allocation is managed memory.", "keywords": []}, {"id": 273, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_MODULE", "display_name": "SANITIZER_MEMORY_FLAG_MODULE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags28SANITIZER_MEMORY_FLAG_MODULEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_MODULE Specifies that the allocation is static scoped to a module.", "keywords": []}, {"id": 274, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_NONE", "display_name": "SANITIZER_MEMORY_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags26SANITIZER_MEMORY_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_NONE Empty flag.", "keywords": []}, {"id": 275, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_PEER", "display_name": "SANITIZER_MEMORY_FLAG_PEER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags26SANITIZER_MEMORY_FLAG_PEERE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_PEER Specifies that the allocation is located on a peer GPU.", "keywords": []}, {"id": 276, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_FLAG_PEER_ATOMIC", "display_name": "SANITIZER_MEMORY_FLAG_PEER_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_PEER_ATOMICE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_PEER_ATOMIC Specifies that the allocation is located on a peer GPU supporting native atomics. This implies that SANITIZER_MEMORY_FLAG_PEER is set as well.", "keywords": []}, {"id": 277, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_ALL", "display_name": "SANITIZER_MEMORY_PERMISSION_ALL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions31SANITIZER_MEMORY_PERMISSION_ALLE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_ALL Specifies that the allocation has all permissions.", "keywords": []}, {"id": 278, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_ATOMIC", "display_name": "SANITIZER_MEMORY_PERMISSION_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions34SANITIZER_MEMORY_PERMISSION_ATOMICE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_ATOMIC Specifies that the allocation is readable/writable with atomic operations.", "keywords": []}, {"id": 279, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_FORCE_INT", "display_name": "SANITIZER_MEMORY_PERMISSION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions37SANITIZER_MEMORY_PERMISSION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_FORCE_INT", "keywords": []}, {"id": 280, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_NONE", "display_name": "SANITIZER_MEMORY_PERMISSION_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions32SANITIZER_MEMORY_PERMISSION_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_NONE No permissions.", "keywords": []}, {"id": 281, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_READ", "display_name": "SANITIZER_MEMORY_PERMISSION_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions32SANITIZER_MEMORY_PERMISSION_READE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_READ Specifies that the allocation is readable.", "keywords": []}, {"id": 282, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_PERMISSION_WRITE", "display_name": "SANITIZER_MEMORY_PERMISSION_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions33SANITIZER_MEMORY_PERMISSION_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_WRITE Specifies that the allocation is writable.", "keywords": []}, {"id": 283, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "display_name": "SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility37SANITIZER_MEMORY_VISIBILITY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "keywords": []}, {"id": 284, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_VISIBILITY_GLOBAL", "display_name": "SANITIZER_MEMORY_VISIBILITY_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility34SANITIZER_MEMORY_VISIBILITY_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_GLOBAL Memory can be accessed by any stream on any device (see cudaMemAttachGlobal).", "keywords": []}, {"id": 285, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_VISIBILITY_HOST", "display_name": "SANITIZER_MEMORY_VISIBILITY_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility32SANITIZER_MEMORY_VISIBILITY_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_HOST Memory cannot be accessed by any stream on any device (see cudaMemAttachHost).", "keywords": []}, {"id": 286, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_VISIBILITY_INVALID", "display_name": "SANITIZER_MEMORY_VISIBILITY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility35SANITIZER_MEMORY_VISIBILITY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_INVALID Invalid memory visibility.", "keywords": []}, {"id": 287, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_VISIBILITY_STREAM", "display_name": "SANITIZER_MEMORY_VISIBILITY_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility34SANITIZER_MEMORY_VISIBILITY_STREAME", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_STREAM Memory can only be accessed by a single stream on the associated device (see cudaMemAttachSingle).", "keywords": []}, {"id": 288, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ApiCallbackSite", "display_name": "Sanitizer_ApiCallbackSite", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425Sanitizer_ApiCallbackSite", "priority": 1, "content": "enum  Sanitizer_ApiCallbackSite Specifies the point in an API call that a callback is issued. Specifies the point in an API that a callback is issued. This value is communicated to the callback function via Sanitizer_CallbackData::CallbackSize. Values:", "keywords": []}, {"id": 289, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ApiCallbackSite::SANITIZER_API_CBSITE_FORCE_INT", "display_name": "Sanitizer_ApiCallbackSite::SANITIZER_API_CBSITE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite30SANITIZER_API_CBSITE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_API_CBSITE_FORCE_INT", "keywords": []}, {"id": 290, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ApiCallbackSite::SANITIZER_API_ENTER", "display_name": "Sanitizer_ApiCallbackSite::SANITIZER_API_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite19SANITIZER_API_ENTERE", "priority": 1, "content": "enumerator  SANITIZER_API_ENTER This callback is at API entry.", "keywords": []}, {"id": 291, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ApiCallbackSite::SANITIZER_API_EXIT", "display_name": "Sanitizer_ApiCallbackSite::SANITIZER_API_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_ApiCallbackSite18SANITIZER_API_EXITE", "priority": 1, "content": "enumerator  SANITIZER_API_EXIT This callback is at API exit.", "keywords": []}, {"id": 292, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopType", "display_name": "Sanitizer_BatchMemopType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv424Sanitizer_BatchMemopType", "priority": 1, "content": "enum  Sanitizer_BatchMemopType Specifies the type of batch memory operation. Specifies the type of batch memory operation reported by a callback in domain SANITIZER_CB_DOMAIN_BATCH_MEMOP. This value is communicated to the callback function via Sanitizer_BatchMemopData::type . Values:", "keywords": []}, {"id": 293, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_32B", "display_name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_32B", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType30SANITIZER_BATCH_MEMOP_TYPE_32BE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_32B Batch memory operation size is 32 bits.", "keywords": []}, {"id": 294, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_64B", "display_name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_64B", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType30SANITIZER_BATCH_MEMOP_TYPE_64BE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_64B Batch memory operation size is 64 bits.", "keywords": []}, {"id": 295, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "display_name": "Sanitizer_BatchMemopType::SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_BatchMemopType36SANITIZER_BATCH_MEMOP_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_BATCH_MEMOP_TYPE_FORCE_INT", "keywords": []}, {"id": 296, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync", "display_name": "Sanitizer_CallackIdSync", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423Sanitizer_CallackIdSync", "priority": 1, "content": "enum  Sanitizer_CallackIdSync Callback IDs for synchronization domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_SYNCHRONIZE. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 297, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "display_name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync47SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED Context synchronization has completed for a given context.", "keywords": []}, {"id": 298, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "display_name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync36SANITIZER_CBID_SYNCHRONIZE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_FORCE_INT", "keywords": []}, {"id": 299, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_INVALID", "display_name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync34SANITIZER_CBID_SYNCHRONIZE_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_INVALID Invalid synchronize callback ID.", "keywords": []}, {"id": 300, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_SIZE", "display_name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync31SANITIZER_CBID_SYNCHRONIZE_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_SIZE", "keywords": []}, {"id": 301, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "display_name": "Sanitizer_CallackIdSync::SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallackIdSync46SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED Stream synchronization has completed for a given stream.", "keywords": []}, {"id": 302, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain", "display_name": "Sanitizer_CallbackDomain", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv424Sanitizer_CallbackDomain", "priority": 1, "content": "enum  Sanitizer_CallbackDomain Callback domains. Callback domain. Each domain represents callback points for a group of related API functions or CUDA driver activity. Values:", "keywords": []}, {"id": 303, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_BATCH_MEMOP", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_BATCH_MEMOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_BATCH_MEMOPE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_BATCH_MEMOP Domain containing callback points for CUDA batch memop operations.", "keywords": []}, {"id": 304, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_DRIVER_API", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_DRIVER_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain30SANITIZER_CB_DOMAIN_DRIVER_APIE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_DRIVER_API Domain containing callback points for all driver API functions.", "keywords": []}, {"id": 305, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_EVENTS", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_EVENTSE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_EVENTS Domain containing callback points for CUDA events.", "keywords": []}, {"id": 306, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain35SANITIZER_CB_DOMAIN_EXTERNAL_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY Domain containing callback points for CUDA external memory.", "keywords": []}, {"id": 307, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_FORCE_INT", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain29SANITIZER_CB_DOMAIN_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_FORCE_INT", "keywords": []}, {"id": 308, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_GRAPHS", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_GRAPHS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_GRAPHSE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_GRAPHS Domain containing callback points for CUDA graphs operations.", "keywords": []}, {"id": 309, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_INVALID", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain27SANITIZER_CB_DOMAIN_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_INVALID Invalid domain.", "keywords": []}, {"id": 310, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_LAUNCH", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_LAUNCHE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_LAUNCH Domain containing callback points for CUDA grid launches.", "keywords": []}, {"id": 311, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_MEMCPY", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_MEMCPYE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_MEMCPY Domain containing callback points for CUDA memcpy operations.", "keywords": []}, {"id": 312, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_MEMSET", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_MEMSET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain26SANITIZER_CB_DOMAIN_MEMSETE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_MEMSET Domain containing callback points for CUDA memset operations.", "keywords": []}, {"id": 313, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_RESOURCE", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain28SANITIZER_CB_DOMAIN_RESOURCEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_RESOURCE Domain containing callback points for CUDA resource tracking.", "keywords": []}, {"id": 314, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_RUNTIME_API", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_RUNTIME_APIE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_RUNTIME_API Domain containing callback points for all runtime API functions.", "keywords": []}, {"id": 315, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_SIZE", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain24SANITIZER_CB_DOMAIN_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_SIZE", "keywords": []}, {"id": 316, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_SYNCHRONIZE", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain31SANITIZER_CB_DOMAIN_SYNCHRONIZEE", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_SYNCHRONIZE Domain containing callback points for CUDA synchronization.", "keywords": []}, {"id": 317, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_UVM", "display_name": "Sanitizer_CallbackDomain::SANITIZER_CB_DOMAIN_UVM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N24Sanitizer_CallbackDomain23SANITIZER_CB_DOMAIN_UVME", "priority": 1, "content": "enumerator  SANITIZER_CB_DOMAIN_UVM Domain containing callback points for CUDA managed memory operations.", "keywords": []}, {"id": 318, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackFunc", "display_name": "Sanitizer_CallbackFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv422Sanitizer_CallbackFunc", "priority": 1, "content": "typedef  void  ( * Sanitizer_CallbackFunc ) ( void  * userdata ,  Sanitizer_CallbackDomain  domain ,  Sanitizer_CallbackId  cbid ,  const  void  * cbdata ) Function type for a callback. Function type for a callback. The type of the data passed to the callback in cbdata depends on the domain. If domain is SANITIZER_CB_DOMAIN_DRIVER_API or SANITIZER_CB_DOMAIN_RUNTIME_API the type of cbdata will be Sanitizer_CallbackData . If domain is SANITIZER_CB_DOMAIN_RESOURCE the type of cbdata will be dependent on cbid. Refer to Sanitizer_ResourceContextData , Sanitizer_ResourceStreamData , Sanitizer_ResourceModuleData and Sanitizer_ResourceMemoryFlags documentations. If domain is SANITIZER_CB_DOMAIN_SYNCHRONIZE the type of cbdata will be Sanitizer_SynchronizeData . If domain is SANITIZER_CB_DOMAIN_LAUNCH the type of cbdata will be Sanitizer_LaunchData . If domain is SANITIZER_CB_DOMAIN_MEMCPY the type of cbdata will be Sanitizer_MemcpyData . If domain is SANITIZER_CB_DOMAIN_MEMSET the type of cbdata will be Sanitizer_MemsetData . If domain is SANITIZER_CB_DOMAIN_BATCH_MEMOP the type of cbdata will be Sanitizer_BatchMemopData .", "keywords": []}, {"id": 319, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackId", "display_name": "Sanitizer_CallbackId", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv420Sanitizer_CallbackId", "priority": 1, "content": "typedef  uint32_t  Sanitizer_CallbackId Callback ID.", "keywords": []}, {"id": 320, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdBatchMemop", "display_name": "Sanitizer_CallbackIdBatchMemop", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv430Sanitizer_CallbackIdBatchMemop", "priority": 1, "content": "enum  Sanitizer_CallbackIdBatchMemop Callback IDs for batch memop domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_BATCH_MEMOP. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 321, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "display_name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop36SANITIZER_CBID_BATCH_MEMOP_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_FORCE_INT", "keywords": []}, {"id": 322, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_INVALID", "display_name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop34SANITIZER_CBID_BATCH_MEMOP_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_INVALID Invalid batch memop callback ID.", "keywords": []}, {"id": 323, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_SIZE", "display_name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop31SANITIZER_CBID_BATCH_MEMOP_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_SIZE", "keywords": []}, {"id": 324, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_WRITE", "display_name": "Sanitizer_CallbackIdBatchMemop::SANITIZER_CBID_BATCH_MEMOP_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N30Sanitizer_CallbackIdBatchMemop32SANITIZER_CBID_BATCH_MEMOP_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_BATCH_MEMOP_WRITE A batch memory operation was initiated.", "keywords": []}, {"id": 325, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents", "display_name": "Sanitizer_CallbackIdEvents", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_CallbackIdEvents", "priority": 1, "content": "enum  Sanitizer_CallbackIdEvents Callback IDs for events domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_EVENTS. This value is communicated to the callback function via the cbid parameter. Available with a driver version of 515 or newer. Values:", "keywords": []}, {"id": 326, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_CREATED", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents29SANITIZER_CBID_EVENTS_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_CREATED An event was created.", "keywords": []}, {"id": 327, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_DESTROYED", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents31SANITIZER_CBID_EVENTS_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_DESTROYED An event was destroyed.", "keywords": []}, {"id": 328, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_FORCE_INT", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents31SANITIZER_CBID_EVENTS_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_FORCE_INT", "keywords": []}, {"id": 329, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_INVALID", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents29SANITIZER_CBID_EVENTS_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_INVALID Invalid event callback ID.", "keywords": []}, {"id": 330, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_RECORD", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_RECORD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents28SANITIZER_CBID_EVENTS_RECORDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_RECORD An event was recorded.", "keywords": []}, {"id": 331, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_SIZE", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents26SANITIZER_CBID_EVENTS_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_SIZE", "keywords": []}, {"id": 332, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_STREAM_WAIT", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_STREAM_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents33SANITIZER_CBID_EVENTS_STREAM_WAITE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_STREAM_WAIT A stream was synchronized to an event.", "keywords": []}, {"id": 333, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_SYNCHRONIZE", "display_name": "Sanitizer_CallbackIdEvents::SANITIZER_CBID_EVENTS_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdEvents33SANITIZER_CBID_EVENTS_SYNCHRONIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EVENTS_SYNCHRONIZE An event was synchronized.", "keywords": []}, {"id": 334, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory", "display_name": "Sanitizer_CallbackIdExternalMemory", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv434Sanitizer_CallbackIdExternalMemory", "priority": 1, "content": "enum  Sanitizer_CallbackIdExternalMemory Callback IDs for external memory domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_EXTERNA_MEMORY. This value is communicated to the callback function via the cbid parameter. Available with a driver version of 535 or newer. Values:", "keywords": []}, {"id": 335, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory40SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_DESTROYED External memory was destroyed.", "keywords": []}, {"id": 336, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory40SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_FORCE_INT", "keywords": []}, {"id": 337, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory37SANITIZER_CBID_EXTERNAL_MEMORY_IMPORTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT External memory was imported.", "keywords": []}, {"id": 338, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_INVALID", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory38SANITIZER_CBID_EXTERNAL_MEMORY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_INVALID Invalid external memory callback ID.", "keywords": []}, {"id": 339, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory37SANITIZER_CBID_EXTERNAL_MEMORY_MAPPEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED External memory was mapped.", "keywords": []}, {"id": 340, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "display_name": "Sanitizer_CallbackIdExternalMemory::SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N34Sanitizer_CallbackIdExternalMemory35SANITIZER_CBID_EXTERNAL_MEMORY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_EXTERNAL_MEMORY_SIZE", "keywords": []}, {"id": 341, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs", "display_name": "Sanitizer_CallbackIdGraphs", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_CallbackIdGraphs", "priority": 1, "content": "enum  Sanitizer_CallbackIdGraphs Callback IDs for graphs domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_GRAPHS. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 342, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_FORCE_INT", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs31SANITIZER_CBID_GRAPHS_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_FORCE_INT", "keywords": []}, {"id": 343, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs39SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED A new graphexec is created.", "keywords": []}, {"id": 344, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs40SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING A new graphexec is being created.", "keywords": []}, {"id": 345, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs42SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_GRAPHEXEC_DESTROYING A graphexec is being destroyed.", "keywords": []}, {"id": 346, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_INVALID", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs29SANITIZER_CBID_GRAPHS_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_INVALID Invalid graphs callback ID.", "keywords": []}, {"id": 347, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs34SANITIZER_CBID_GRAPHS_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN A graph launch was initiated.", "keywords": []}, {"id": 348, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_LAUNCH_END", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs32SANITIZER_CBID_GRAPHS_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_LAUNCH_END A graph launch is complete.", "keywords": []}, {"id": 349, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs39SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_NODE_LAUNCH_BEGIN A node launch was initiated.", "keywords": []}, {"id": 350, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs37SANITIZER_CBID_GRAPHS_NODE_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_NODE_LAUNCH_END A node launch is complete.", "keywords": []}, {"id": 351, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_SIZE", "display_name": "Sanitizer_CallbackIdGraphs::SANITIZER_CBID_GRAPHS_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdGraphs26SANITIZER_CBID_GRAPHS_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_GRAPHS_SIZE", "keywords": []}, {"id": 352, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch", "display_name": "Sanitizer_CallbackIdLaunch", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_CallbackIdLaunch", "priority": 1, "content": "enum  Sanitizer_CallbackIdLaunch Callback IDs for launch domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_LAUNCH. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 353, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch41SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUPE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_AFTER_SYSCALL_SETUP A grid launch has completed syscalls setup.", "keywords": []}, {"id": 354, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_BEGIN", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_BEGIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch27SANITIZER_CBID_LAUNCH_BEGINE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_BEGIN A grid launch was initiated.", "keywords": []}, {"id": 355, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_END", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch25SANITIZER_CBID_LAUNCH_ENDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_END The grid launch is complete.", "keywords": []}, {"id": 356, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_FORCE_INT", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch31SANITIZER_CBID_LAUNCH_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_FORCE_INT", "keywords": []}, {"id": 357, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_INVALID", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch29SANITIZER_CBID_LAUNCH_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_INVALID Invalid launch callback ID.", "keywords": []}, {"id": 358, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_SIZE", "display_name": "Sanitizer_CallbackIdLaunch::SANITIZER_CBID_LAUNCH_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdLaunch26SANITIZER_CBID_LAUNCH_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_LAUNCH_SIZE", "keywords": []}, {"id": 359, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemcpy", "display_name": "Sanitizer_CallbackIdMemcpy", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_CallbackIdMemcpy", "priority": 1, "content": "enum  Sanitizer_CallbackIdMemcpy Callback IDs for memcpy domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_MEMCPY. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 360, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_FORCE_INT", "display_name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy31SANITIZER_CBID_MEMCPY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_FORCE_INT", "keywords": []}, {"id": 361, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_INVALID", "display_name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy29SANITIZER_CBID_MEMCPY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_INVALID Invalid memcpy callback ID.", "keywords": []}, {"id": 362, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_SIZE", "display_name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy26SANITIZER_CBID_MEMCPY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_SIZE", "keywords": []}, {"id": 363, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_STARTING", "display_name": "Sanitizer_CallbackIdMemcpy::SANITIZER_CBID_MEMCPY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemcpy30SANITIZER_CBID_MEMCPY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMCPY_STARTING A memcpy operation was initiated.", "keywords": []}, {"id": 364, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemset", "display_name": "Sanitizer_CallbackIdMemset", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_CallbackIdMemset", "priority": 1, "content": "enum  Sanitizer_CallbackIdMemset Callback IDs for memset domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_MEMSET. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 365, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_FORCE_INT", "display_name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset31SANITIZER_CBID_MEMSET_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_FORCE_INT", "keywords": []}, {"id": 366, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_INVALID", "display_name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset29SANITIZER_CBID_MEMSET_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_INVALID Invalid memset callback ID.", "keywords": []}, {"id": 367, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_SIZE", "display_name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset26SANITIZER_CBID_MEMSET_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_SIZE", "keywords": []}, {"id": 368, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_STARTING", "display_name": "Sanitizer_CallbackIdMemset::SANITIZER_CBID_MEMSET_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_CallbackIdMemset30SANITIZER_CBID_MEMSET_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_MEMSET_STARTING A memset operation was initiated.", "keywords": []}, {"id": 369, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource", "display_name": "Sanitizer_CallbackIdResource", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv428Sanitizer_CallbackIdResource", "priority": 1, "content": "enum  Sanitizer_CallbackIdResource Callback IDs for resource domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_RESOURCE. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 370, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_ARRAY_CREATED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_ARRAY_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_ARRAY_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_ARRAY_CREATED A CUDA array was created.", "keywords": []}, {"id": 371, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_ARRAY_DESTROYEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED A CUDA array was destroyed.", "keywords": []}, {"id": 372, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource49SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED A new context was created.", "keywords": []}, {"id": 373, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource49SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING A new context is about to be created.", "keywords": []}, {"id": 374, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource48SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED A context was destroyed.", "keywords": []}, {"id": 375, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource48SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING A context is about to be destroyed.", "keywords": []}, {"id": 376, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource43SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC Device memory was allocated.", "keywords": []}, {"id": 377, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE Device memory was freed.", "keywords": []}, {"id": 378, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FORCE_INT", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource33SANITIZER_CBID_RESOURCE_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FORCE_INT", "keywords": []}, {"id": 379, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource45SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED CUDA functions were loaded lazily and are fully loaded.", "keywords": []}, {"id": 380, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED CUDA lazily loaded functions were patched.", "keywords": []}, {"id": 381, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource41SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC Pinned host memory was allocated.", "keywords": []}, {"id": 382, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource40SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE Pinned host memory was freed.", "keywords": []}, {"id": 383, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_INIT_FINISHED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_INIT_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_INIT_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_INIT_FINISHED Driver initialization is finished.", "keywords": []}, {"id": 384, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_INVALID", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource31SANITIZER_CBID_RESOURCE_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_INVALID Invalid resource callback ID.", "keywords": []}, {"id": 385, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC Memory was allocated asynchronously.", "keywords": []}, {"id": 386, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource41SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC Memory was freed asynchronously.", "keywords": []}, {"id": 387, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE Memory freed asynchronously was released, only happens if a regular allocation (cudaMalloc) is free\u2019d asynchronously (cudaFreeAsync). See CUDA runtime documentation for cudaFreeAsync.", "keywords": []}, {"id": 388, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_MEMPOOL_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED A new mempool was created.", "keywords": []}, {"id": 389, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource42SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING A mempool is about to be destroyed.", "keywords": []}, {"id": 390, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTERE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER A memory pool allocation was imported.", "keywords": []}, {"id": 391, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource53SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING A mempool is no longer accessible from a peer device.", "keywords": []}, {"id": 392, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource51SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED A mempool is now accessible from a peer device.", "keywords": []}, {"id": 393, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MODULE_LOADED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MODULE_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource37SANITIZER_CBID_RESOURCE_MODULE_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MODULE_LOADED A module was loaded.", "keywords": []}, {"id": 394, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource46SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING A module is about to be unloaded.", "keywords": []}, {"id": 395, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_SIZE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource28SANITIZER_CBID_RESOURCE_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_SIZE", "keywords": []}, {"id": 396, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_CREATED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource38SANITIZER_CBID_RESOURCE_STREAM_CREATEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_CREATED A new stream was created.", "keywords": []}, {"id": 397, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource47SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHEDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED A stream was destroyed.", "keywords": []}, {"id": 398, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource47SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING A stream is about to be destroyed.", "keywords": []}, {"id": 399, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE The CUDA driver released a virtual address range.", "keywords": []}, {"id": 400, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE", "display_name": "Sanitizer_CallbackIdResource::SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N28Sanitizer_CallbackIdResource39SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE The CUDA driver reserved a virtual address range.", "keywords": []}, {"id": 401, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdUvm", "display_name": "Sanitizer_CallbackIdUvm", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423Sanitizer_CallbackIdUvm", "priority": 1, "content": "enum  Sanitizer_CallbackIdUvm Callback IDs for managed memory domain. Callback IDs for resource domain SANITIZER_CB_DOMAIN_UVM. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 402, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_ATTACH_MEM", "display_name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_ATTACH_MEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm29SANITIZER_CBID_UVM_ATTACH_MEME", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_ATTACH_MEM Modify the stream association of an allocation (see cudaStreamAttachMemAsync)", "keywords": []}, {"id": 403, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_FORCE_ITN", "display_name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_FORCE_ITN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm28SANITIZER_CBID_UVM_FORCE_ITNE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_FORCE_ITN", "keywords": []}, {"id": 404, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_INVALID", "display_name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm26SANITIZER_CBID_UVM_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_INVALID Invalid managed memory callback ID.", "keywords": []}, {"id": 405, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_SIZE", "display_name": "Sanitizer_CallbackIdUvm::SANITIZER_CBID_UVM_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N23Sanitizer_CallbackIdUvm23SANITIZER_CBID_UVM_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_CBID_UVM_SIZE", "keywords": []}, {"id": 406, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection", "display_name": "Sanitizer_MemcpyDirection", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425Sanitizer_MemcpyDirection", "priority": 1, "content": "enum  Sanitizer_MemcpyDirection Memcpy direction. Indicates the direction of a memcpy, passed inside Sanitizer_Memcpydata . Values:", "keywords": []}, {"id": 407, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection43SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_DEVICE Memcpy from device to device.", "keywords": []}, {"id": 408, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection41SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_DEVICE_TO_HOST Memcpy from device to host.", "keywords": []}, {"id": 409, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection36SANITIZER_MEMCPY_DIRECTION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_FORCE_INT", "keywords": []}, {"id": 410, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection41SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_HOST_TO_DEVICE Memcpy from host to device.", "keywords": []}, {"id": 411, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection39SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_HOST_TO_HOST Memcpy from host to host.", "keywords": []}, {"id": 412, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_SIZE", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection31SANITIZER_MEMCPY_DIRECTION_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_SIZE", "keywords": []}, {"id": 413, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_UNKNOWN", "display_name": "Sanitizer_MemcpyDirection::SANITIZER_MEMCPY_DIRECTION_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N25Sanitizer_MemcpyDirection34SANITIZER_MEMCPY_DIRECTION_UNKNOWNE", "priority": 1, "content": "enumerator  SANITIZER_MEMCPY_DIRECTION_UNKNOWN Unknown memcpy direction.", "keywords": []}, {"id": 414, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility", "display_name": "Sanitizer_MemoryVisibility", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_MemoryVisibility", "priority": 1, "content": "enum  Sanitizer_MemoryVisibility Specifies the visibility of an allocation. Specifies the visibility of an allocation. This is typically GLOBAL on allocations made via cudaMalloc, cudaHostAlloc and similar APIs. This can be GLOBAL or HOST for cudaMallocManaged allocations depending on the flags parameter. This can be changed after allocation time using cudaMemAttachSingle API (see SANITIZER_CBID_UVM_ATTACH_MEM for the corresponding callback). Values:", "keywords": []}, {"id": 415, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "display_name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility37SANITIZER_MEMORY_VISIBILITY_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_FORCE_INT", "keywords": []}, {"id": 416, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_GLOBAL", "display_name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility34SANITIZER_MEMORY_VISIBILITY_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_GLOBAL Memory can be accessed by any stream on any device (see cudaMemAttachGlobal).", "keywords": []}, {"id": 417, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_HOST", "display_name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_HOST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility32SANITIZER_MEMORY_VISIBILITY_HOSTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_HOST Memory cannot be accessed by any stream on any device (see cudaMemAttachHost).", "keywords": []}, {"id": 418, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_INVALID", "display_name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility35SANITIZER_MEMORY_VISIBILITY_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_INVALID Invalid memory visibility.", "keywords": []}, {"id": 419, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_STREAM", "display_name": "Sanitizer_MemoryVisibility::SANITIZER_MEMORY_VISIBILITY_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N26Sanitizer_MemoryVisibility34SANITIZER_MEMORY_VISIBILITY_STREAME", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_VISIBILITY_STREAM Memory can only be accessed by a single stream on the associated device (see cudaMemAttachSingle).", "keywords": []}, {"id": 420, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags", "display_name": "Sanitizer_ResourceMemoryFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv429Sanitizer_ResourceMemoryFlags", "priority": 1, "content": "enum  Sanitizer_ResourceMemoryFlags Flags describing a memory allocation. Flags describing a memory allocation. These values are to be used in order to interpret the value of Sanitizer_ResourceMemoryData::flags . Values:", "keywords": []}, {"id": 421, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_CG_RUNTIME", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_CG_RUNTIME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags32SANITIZER_MEMORY_FLAG_CG_RUNTIMEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_CG_RUNTIME Specifies that the allocation is used by the Cooperative Groups runtime functions.", "keywords": []}, {"id": 422, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_CNP", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_CNP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags25SANITIZER_MEMORY_FLAG_CNPE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_CNP Specifies that this is an allocation used for CUDA Dynamic Parallelism purposes.", "keywords": []}, {"id": 423, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_FORCE_INT", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags31SANITIZER_MEMORY_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_FORCE_INT", "keywords": []}, {"id": 424, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_HOST_MAPPED", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_HOST_MAPPED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_HOST_MAPPEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_HOST_MAPPED Species that the allocation accessible from the host.", "keywords": []}, {"id": 425, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_HOST_PINNED", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_HOST_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_HOST_PINNEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_HOST_PINNED Specifies that the allocation is pinned on the host.", "keywords": []}, {"id": 426, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_MANAGED", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_MANAGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags29SANITIZER_MEMORY_FLAG_MANAGEDE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_MANAGED Specifies that the allocation is managed memory.", "keywords": []}, {"id": 427, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_MODULE", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_MODULE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags28SANITIZER_MEMORY_FLAG_MODULEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_MODULE Specifies that the allocation is static scoped to a module.", "keywords": []}, {"id": 428, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_NONE", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags26SANITIZER_MEMORY_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_NONE Empty flag.", "keywords": []}, {"id": 429, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_PEER", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_PEER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags26SANITIZER_MEMORY_FLAG_PEERE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_PEER Specifies that the allocation is located on a peer GPU.", "keywords": []}, {"id": 430, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_PEER_ATOMIC", "display_name": "Sanitizer_ResourceMemoryFlags::SANITIZER_MEMORY_FLAG_PEER_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N29Sanitizer_ResourceMemoryFlags33SANITIZER_MEMORY_FLAG_PEER_ATOMICE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_FLAG_PEER_ATOMIC Specifies that the allocation is located on a peer GPU supporting native atomics. This implies that SANITIZER_MEMORY_FLAG_PEER is set as well.", "keywords": []}, {"id": 431, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions", "display_name": "Sanitizer_ResourceMemoryPermissions", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv435Sanitizer_ResourceMemoryPermissions", "priority": 1, "content": "enum  Sanitizer_ResourceMemoryPermissions Permissions for a memory allocation. Permissions for a memory allocation. These values are to be used in order to interpret the value of Sanitizer_ResourceMemoryData::permissions . Values:", "keywords": []}, {"id": 432, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_ALL", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_ALL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions31SANITIZER_MEMORY_PERMISSION_ALLE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_ALL Specifies that the allocation has all permissions.", "keywords": []}, {"id": 433, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_ATOMIC", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions34SANITIZER_MEMORY_PERMISSION_ATOMICE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_ATOMIC Specifies that the allocation is readable/writable with atomic operations.", "keywords": []}, {"id": 434, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_FORCE_INT", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions37SANITIZER_MEMORY_PERMISSION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_FORCE_INT", "keywords": []}, {"id": 435, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_NONE", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions32SANITIZER_MEMORY_PERMISSION_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_NONE No permissions.", "keywords": []}, {"id": 436, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_READ", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions32SANITIZER_MEMORY_PERMISSION_READE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_READ Specifies that the allocation is readable.", "keywords": []}, {"id": 437, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_WRITE", "display_name": "Sanitizer_ResourceMemoryPermissions::SANITIZER_MEMORY_PERMISSION_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv4N35Sanitizer_ResourceMemoryPermissions33SANITIZER_MEMORY_PERMISSION_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_PERMISSION_WRITE Specifies that the allocation is writable.", "keywords": []}, {"id": 438, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "Sanitizer_SubscriberHandle", "display_name": "Sanitizer_SubscriberHandle", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv426Sanitizer_SubscriberHandle", "priority": 1, "content": "typedef  struct  Sanitizer_Subscriber_st  * Sanitizer_SubscriberHandle A callback subscriber.", "keywords": []}, {"id": 439, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableAllDomains", "display_name": "sanitizerEnableAllDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerEnableAllDomains8uint32_t26Sanitizer_SubscriberHandle", "priority": 1, "content": "SanitizerResult  sanitizerEnableAllDomains uint32_t  enable Sanitizer_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, *) and sanitizerEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domains. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid.", "keywords": []}, {"id": 440, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableAllDomains::enable", "display_name": "sanitizerEnableAllDomains::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerEnableAllDomains8uint32_t26Sanitizer_SubscriberHandle", "priority": 1, "content": "SanitizerResult  sanitizerEnableAllDomains uint32_t  enable Sanitizer_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, *) and sanitizerEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domains. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid.", "keywords": []}, {"id": 441, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableAllDomains::subscriber", "display_name": "sanitizerEnableAllDomains::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerEnableAllDomains8uint32_t26Sanitizer_SubscriberHandle", "priority": 1, "content": "SanitizerResult  sanitizerEnableAllDomains uint32_t  enable Sanitizer_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, *) and sanitizerEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domains. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid.", "keywords": []}, {"id": 442, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableCallback", "display_name": "sanitizerEnableCallback", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423sanitizerEnableCallback8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerEnableCallback uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Enable or disable callbacks for a specific domain and callback ID. Enable or disable callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 443, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableCallback::cbid", "display_name": "sanitizerEnableCallback::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423sanitizerEnableCallback8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerEnableCallback uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Enable or disable callbacks for a specific domain and callback ID. Enable or disable callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 444, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableCallback::domain", "display_name": "sanitizerEnableCallback::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423sanitizerEnableCallback8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerEnableCallback uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Enable or disable callbacks for a specific domain and callback ID. Enable or disable callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 445, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableCallback::enable", "display_name": "sanitizerEnableCallback::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423sanitizerEnableCallback8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerEnableCallback uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Enable or disable callbacks for a specific domain and callback ID. Enable or disable callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 446, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableCallback::subscriber", "display_name": "sanitizerEnableCallback::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv423sanitizerEnableCallback8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerEnableCallback uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Enable or disable callbacks for a specific domain and callback ID. Enable or disable callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 447, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableDomain", "display_name": "sanitizerEnableDomain", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv421sanitizerEnableDomain8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain", "priority": 1, "content": "SanitizerResult  sanitizerEnableDomain uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Enable or disable all callbacks for a specific domain. Enable or disable all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackEnabled(sub, d, *) and sanitizerEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid.", "keywords": []}, {"id": 448, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableDomain::domain", "display_name": "sanitizerEnableDomain::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv421sanitizerEnableDomain8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain", "priority": 1, "content": "SanitizerResult  sanitizerEnableDomain uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Enable or disable all callbacks for a specific domain. Enable or disable all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackEnabled(sub, d, *) and sanitizerEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid.", "keywords": []}, {"id": 449, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableDomain::enable", "display_name": "sanitizerEnableDomain::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv421sanitizerEnableDomain8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain", "priority": 1, "content": "SanitizerResult  sanitizerEnableDomain uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Enable or disable all callbacks for a specific domain. Enable or disable all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackEnabled(sub, d, *) and sanitizerEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid.", "keywords": []}, {"id": 450, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerEnableDomain::subscriber", "display_name": "sanitizerEnableDomain::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv421sanitizerEnableDomain8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain", "priority": 1, "content": "SanitizerResult  sanitizerEnableDomain uint32_t  enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Enable or disable all callbacks for a specific domain. Enable or disable all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackEnabled(sub, d, *) and sanitizerEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle of the initialized subscriber. domain \u2013 The domain of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid.", "keywords": []}, {"id": 451, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackState", "display_name": "sanitizerGetCallbackState", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerGetCallbackStateP8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackState uint32_t  * enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled. subscriber \u2013 Handle to the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 452, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackState::cbid", "display_name": "sanitizerGetCallbackState::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerGetCallbackStateP8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackState uint32_t  * enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled. subscriber \u2013 Handle to the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 453, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackState::domain", "display_name": "sanitizerGetCallbackState::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerGetCallbackStateP8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackState uint32_t  * enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled. subscriber \u2013 Handle to the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 454, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackState::enable", "display_name": "sanitizerGetCallbackState::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerGetCallbackStateP8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackState uint32_t  * enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled. subscriber \u2013 Handle to the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 455, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackState::subscriber", "display_name": "sanitizerGetCallbackState::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv425sanitizerGetCallbackStateP8uint32_t26Sanitizer_SubscriberHandle24Sanitizer_CallbackDomain20Sanitizer_CallbackId", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackState uint32_t  * enable Sanitizer_SubscriberHandle  subscriber Sanitizer_CallbackDomain  domain Sanitizer_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to sanitizerGetCallbackState, sanitizerEnableCallback, sanitizerEnableDomain, and sanitizerEnableAllDomains. For example, if sanitizerGetCallbackState(sub, d, c) and sanitizerEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled. subscriber \u2013 Handle to the initialized subscriber. domain \u2013 The domain of the callback. cbid \u2013 The ID of the callback. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 456, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerSubscribe", "display_name": "sanitizerSubscribe", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv418sanitizerSubscribeP26Sanitizer_SubscriberHandle22Sanitizer_CallbackFuncPv", "priority": 1, "content": "SanitizerResult  sanitizerSubscribe Sanitizer_SubscriberHandle  * subscriber Sanitizer_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initialize a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only one subscriber can be registered at a time. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber. callback \u2013 The callback function. userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_MAX_LIMIT_RACHED \u2013 if there is already a sanitizer subscriber. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL.", "keywords": []}, {"id": 457, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerSubscribe::callback", "display_name": "sanitizerSubscribe::callback", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv418sanitizerSubscribeP26Sanitizer_SubscriberHandle22Sanitizer_CallbackFuncPv", "priority": 1, "content": "SanitizerResult  sanitizerSubscribe Sanitizer_SubscriberHandle  * subscriber Sanitizer_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initialize a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only one subscriber can be registered at a time. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber. callback \u2013 The callback function. userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_MAX_LIMIT_RACHED \u2013 if there is already a sanitizer subscriber. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL.", "keywords": []}, {"id": 458, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerSubscribe::subscriber", "display_name": "sanitizerSubscribe::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv418sanitizerSubscribeP26Sanitizer_SubscriberHandle22Sanitizer_CallbackFuncPv", "priority": 1, "content": "SanitizerResult  sanitizerSubscribe Sanitizer_SubscriberHandle  * subscriber Sanitizer_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initialize a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only one subscriber can be registered at a time. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber. callback \u2013 The callback function. userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_MAX_LIMIT_RACHED \u2013 if there is already a sanitizer subscriber. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL.", "keywords": []}, {"id": 459, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerSubscribe::userdata", "display_name": "sanitizerSubscribe::userdata", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv418sanitizerSubscribeP26Sanitizer_SubscriberHandle22Sanitizer_CallbackFuncPv", "priority": 1, "content": "SanitizerResult  sanitizerSubscribe Sanitizer_SubscriberHandle  * subscriber Sanitizer_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initialize a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only one subscriber can be registered at a time. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber. callback \u2013 The callback function. userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_MAX_LIMIT_RACHED \u2013 if there is already a sanitizer subscriber. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL.", "keywords": []}, {"id": 460, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerUnsubscribe", "display_name": "sanitizerUnsubscribe", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv420sanitizerUnsubscribe26Sanitizer_SubscriberHandle", "priority": 1, "content": "SanitizerResult  sanitizerUnsubscribe Sanitizer_SubscriberHandle  subscriber Unregister a callback subscriber. Removes a callback subscriber so that no future callback will be issued to that subscriber. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Handle to the initialized subscriber. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL or not initialized.", "keywords": []}, {"id": 461, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "cpp", "name": "sanitizerUnsubscribe::subscriber", "display_name": "sanitizerUnsubscribe::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "_CPPv420sanitizerUnsubscribe26Sanitizer_SubscriberHandle", "priority": 1, "content": "SanitizerResult  sanitizerUnsubscribe Sanitizer_SubscriberHandle  subscriber Unregister a callback subscriber. Removes a callback subscriber so that no future callback will be issued to that subscriber. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Handle to the initialized subscriber. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL or not initialized.", "keywords": []}, {"id": 462, "doc_id": 462, "filename": "api/group__SANITIZER__CALLBACK__API.html", "domain_name": "std", "name": "api/group__SANITIZER__CALLBACK__API", "display_name": "Sanitizer Callback API", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__CALLBACK__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the Sanitizer Callback API. Enumerations Sanitizer_ApiCallbackSite  Specifies the point in an API call that a callback is issued. Sanitizer_BatchMemopType  Specifies the type of batch memory operation. Sanitizer_CallackIdSync  Callback IDs for synchronization domain. Sanitizer_CallbackDomain  Callback domains. Sanitizer_CallbackIdBatchMemop  Callback IDs for batch memop domain. Sanitizer_CallbackIdEvents  Callback IDs for events domain. Sanitizer_CallbackIdExternalMemory  Callback IDs for external memory domain. Sanitizer_CallbackIdGraphs  Callback IDs for graphs domain. Sanitizer_CallbackIdLaunch  Callback IDs for launch domain. Sanitizer_CallbackIdMemcpy  Callback IDs for memcpy domain. Sanitizer_CallbackIdMemset  Callback IDs for memset domain. Sanitizer_CallbackIdResource  Callback IDs for resource domain. Sanitizer_CallbackIdUvm  Callback IDs for managed memory domain. Sanitizer_MemcpyDirection  Memcpy direction. Sanitizer_MemoryVisibility  Specifies the visibility of an allocation. Sanitizer_ResourceMemoryFlags  Flags describing a memory allocation. Sanitizer_ResourceMemoryPermissions  Permissions for a memory allocation. Functions SanitizerResult  sanitizerEnableAllDomains (uint32_t enable, Sanitizer_SubscriberHandle subscriber) Enable or disable all callbacks in all domains. SanitizerResult  sanitizerEnableCallback (uint32_t enable, Sanitizer_SubscriberHandle subscriber, Sanitizer_CallbackDomain domain, Sanitizer_CallbackId cbid) Enable or disable callbacks for a specific domain and callback ID. SanitizerResult  sanitizerEnableDomain (uint32_t enable, Sanitizer_SubscriberHandle subscriber, Sanitizer_CallbackDomain domain) Enable or disable all callbacks for a specific domain. SanitizerResult  sanitizerGetCallbackState (uint32_t *enable, Sanitizer_SubscriberHandle subscriber, Sanitizer_CallbackDomain domain, Sanitizer_CallbackId cbid) Get the current enabled/disabled state of a callback for a specific domain and function ID. SanitizerResult  sanitizerSubscribe (Sanitizer_SubscriberHandle *subscriber, Sanitizer_CallbackFunc callback, void *userdata) Initialize a callback subscriber with a callback function and user data. SanitizerResult  sanitizerUnsubscribe (Sanitizer_SubscriberHandle subscriber) Unregister a callback subscriber. Structs Sanitizer_BatchMemopData  Data passed into a batch memop callback function. Sanitizer_CallbackData  Data passed into a runtime or driver API callback function. Sanitizer_EventData  Data passed into an event callback function. Sanitizer_ExternalMemoryData  Data passed into an external memory callback function. Sanitizer_GraphExecData  Data passed into a graphexec creation callback function. Sanitizer_GraphLaunchData  Data passed into a graph launch callback function. Sanitizer_GraphNodeLaunchData  Data passed into a graph node launch callback function. Sanitizer_LaunchData  Data passed into a launch callback function. Sanitizer_MemcpyData  Data passed into a memcpy callback function. Sanitizer_MemsetData  Data passed into a memset callback function. Sanitizer_ResourceArrayData  Data passed into a CUDA array callback function. Sanitizer_ResourceContextData  Data passed into a context resource callback function. Sanitizer_ResourceFunctionsLazyLoadedData  Data passed into a CUDA function callback function. Sanitizer_ResourceMemoryData  Data passed into a memory resource callback function. Sanitizer_ResourceMempoolData  Data passed into a mempool resource callback function. Sanitizer_ResourceModuleData  Data passed into a module resource callback function. Sanitizer_ResourceStreamData  Data passed into a stream resource callback function. Sanitizer_ResourceVirtualRange  Data passed into a VA reservation callback function. Sanitizer_SynchronizeData  Data passed into a synchronization callback function. Sanitizer_UvmData  Data passed into a managed memory callback function. Typedefs Sanitizer_CallbackFunc  Function type for a callback. Sanitizer_CallbackId  Callback ID. Sanitizer_SubscriberHandle  A callback subscriber.", "keywords": []}, {"id": 463, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAlloc", "display_name": "sanitizerAlloc", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv414sanitizerAlloc9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAlloc CUcontext  ctx void  * * devPtr size_t  size Allocate memory on the device. Equivalent of cudaMalloc that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated device memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 464, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAlloc::ctx", "display_name": "sanitizerAlloc::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv414sanitizerAlloc9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAlloc CUcontext  ctx void  * * devPtr size_t  size Allocate memory on the device. Equivalent of cudaMalloc that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated device memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 465, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAlloc::devPtr", "display_name": "sanitizerAlloc::devPtr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv414sanitizerAlloc9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAlloc CUcontext  ctx void  * * devPtr size_t  size Allocate memory on the device. Equivalent of cudaMalloc that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated device memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 466, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAlloc::size", "display_name": "sanitizerAlloc::size", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv414sanitizerAlloc9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAlloc CUcontext  ctx void  * * devPtr size_t  size Allocate memory on the device. Equivalent of cudaMalloc that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated device memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 467, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAllocHost", "display_name": "sanitizerAllocHost", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv418sanitizerAllocHost9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAllocHost CUcontext  ctx void  * * devPtr size_t  size Allocate host pinned memory. Equivalent of cudaMallocHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated host memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 468, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAllocHost::ctx", "display_name": "sanitizerAllocHost::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv418sanitizerAllocHost9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAllocHost CUcontext  ctx void  * * devPtr size_t  size Allocate host pinned memory. Equivalent of cudaMallocHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated host memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 469, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAllocHost::devPtr", "display_name": "sanitizerAllocHost::devPtr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv418sanitizerAllocHost9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAllocHost CUcontext  ctx void  * * devPtr size_t  size Allocate host pinned memory. Equivalent of cudaMallocHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated host memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 470, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerAllocHost::size", "display_name": "sanitizerAllocHost::size", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv418sanitizerAllocHost9CUcontextPPv6size_t", "priority": 1, "content": "SanitizerResult  sanitizerAllocHost CUcontext  ctx void  * * devPtr size_t  size Allocate host pinned memory. Equivalent of cudaMallocHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Pointer to allocated host memory. size \u2013 Allocation size in bytes.", "keywords": []}, {"id": 471, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFree", "display_name": "sanitizerFree", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv413sanitizerFree9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFree CUcontext  ctx void  * devPtr Frees memory on the device. Equivalent of cudaFree that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Device pointer to memory to free.", "keywords": []}, {"id": 472, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFree::ctx", "display_name": "sanitizerFree::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv413sanitizerFree9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFree CUcontext  ctx void  * devPtr Frees memory on the device. Equivalent of cudaFree that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Device pointer to memory to free.", "keywords": []}, {"id": 473, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFree::devPtr", "display_name": "sanitizerFree::devPtr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv413sanitizerFree9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFree CUcontext  ctx void  * devPtr Frees memory on the device. Equivalent of cudaFree that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Device pointer to memory to free.", "keywords": []}, {"id": 474, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFreeHost", "display_name": "sanitizerFreeHost", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv417sanitizerFreeHost9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFreeHost CUcontext  ctx void  * devPtr Frees host memory. Equivalent of cudaFreeHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Host pointer to memory to free.", "keywords": []}, {"id": 475, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFreeHost::ctx", "display_name": "sanitizerFreeHost::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv417sanitizerFreeHost9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFreeHost CUcontext  ctx void  * devPtr Frees host memory. Equivalent of cudaFreeHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Host pointer to memory to free.", "keywords": []}, {"id": 476, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerFreeHost::devPtr", "display_name": "sanitizerFreeHost::devPtr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv417sanitizerFreeHost9CUcontextPv", "priority": 1, "content": "SanitizerResult  sanitizerFreeHost CUcontext  ctx void  * devPtr Frees host memory. Equivalent of cudaFreeHost that can be called within a callback function. Thread-safety : this function is thread safe. Parameters ctx \u2013 Context for the allocation. If NULL, the current context will be used. devPtr \u2013 Host pointer to memory to free.", "keywords": []}, {"id": 477, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyDeviceToHost", "display_name": "sanitizerMemcpyDeviceToHost", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv427sanitizerMemcpyDeviceToHostPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyDeviceToHost void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from device to host. Equivalent of cudaMemcpy that can be called within a callback function. The function will return once the copy has completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 478, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyDeviceToHost::count", "display_name": "sanitizerMemcpyDeviceToHost::count", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv427sanitizerMemcpyDeviceToHostPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyDeviceToHost void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from device to host. Equivalent of cudaMemcpy that can be called within a callback function. The function will return once the copy has completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 479, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyDeviceToHost::dst", "display_name": "sanitizerMemcpyDeviceToHost::dst", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv427sanitizerMemcpyDeviceToHostPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyDeviceToHost void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from device to host. Equivalent of cudaMemcpy that can be called within a callback function. The function will return once the copy has completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 480, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyDeviceToHost::src", "display_name": "sanitizerMemcpyDeviceToHost::src", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv427sanitizerMemcpyDeviceToHostPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyDeviceToHost void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from device to host. Equivalent of cudaMemcpy that can be called within a callback function. The function will return once the copy has completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 481, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyDeviceToHost::stream", "display_name": "sanitizerMemcpyDeviceToHost::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv427sanitizerMemcpyDeviceToHostPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyDeviceToHost void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from device to host. Equivalent of cudaMemcpy that can be called within a callback function. The function will return once the copy has completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 482, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyHostToDeviceAsync", "display_name": "sanitizerMemcpyHostToDeviceAsync", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv432sanitizerMemcpyHostToDeviceAsyncPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyHostToDeviceAsync void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from host to device. Equivalent of cudaMemcpyAsync that can be called within a callback function. The function will return once the pageable buffer has been copied to the staging memory for DMA transfer to device memory, but the DMA to final destination may not have completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 483, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyHostToDeviceAsync::count", "display_name": "sanitizerMemcpyHostToDeviceAsync::count", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv432sanitizerMemcpyHostToDeviceAsyncPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyHostToDeviceAsync void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from host to device. Equivalent of cudaMemcpyAsync that can be called within a callback function. The function will return once the pageable buffer has been copied to the staging memory for DMA transfer to device memory, but the DMA to final destination may not have completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 484, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyHostToDeviceAsync::dst", "display_name": "sanitizerMemcpyHostToDeviceAsync::dst", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv432sanitizerMemcpyHostToDeviceAsyncPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyHostToDeviceAsync void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from host to device. Equivalent of cudaMemcpyAsync that can be called within a callback function. The function will return once the pageable buffer has been copied to the staging memory for DMA transfer to device memory, but the DMA to final destination may not have completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 485, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyHostToDeviceAsync::src", "display_name": "sanitizerMemcpyHostToDeviceAsync::src", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv432sanitizerMemcpyHostToDeviceAsyncPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyHostToDeviceAsync void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from host to device. Equivalent of cudaMemcpyAsync that can be called within a callback function. The function will return once the pageable buffer has been copied to the staging memory for DMA transfer to device memory, but the DMA to final destination may not have completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 486, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemcpyHostToDeviceAsync::stream", "display_name": "sanitizerMemcpyHostToDeviceAsync::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv432sanitizerMemcpyHostToDeviceAsyncPvPv6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemcpyHostToDeviceAsync void  * dst void  * src size_t  count Sanitizer_StreamHandle  stream Copies data from host to device. Equivalent of cudaMemcpyAsync that can be called within a callback function. The function will return once the pageable buffer has been copied to the staging memory for DMA transfer to device memory, but the DMA to final destination may not have completed. Thread-safety : this function is thread safe. Parameters dst \u2013 Destination memory address. src \u2013 Source memory address. count \u2013 Size in bytes to copy. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 487, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemset", "display_name": "sanitizerMemset", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv415sanitizerMemsetPvi6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemset void  * devPtr int  value size_t  count Sanitizer_StreamHandle  stream Initializes or sets device memory to a value. Equivalent of cudaMemset that can be called within a callback function. Thread-safety : this function is thread safe. Parameters devPtr \u2013 Pointer to device memory. value \u2013 value to set for each byte of specified memory. count \u2013 Size in bytes to set. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 488, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemset::count", "display_name": "sanitizerMemset::count", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv415sanitizerMemsetPvi6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemset void  * devPtr int  value size_t  count Sanitizer_StreamHandle  stream Initializes or sets device memory to a value. Equivalent of cudaMemset that can be called within a callback function. Thread-safety : this function is thread safe. Parameters devPtr \u2013 Pointer to device memory. value \u2013 value to set for each byte of specified memory. count \u2013 Size in bytes to set. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 489, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemset::devPtr", "display_name": "sanitizerMemset::devPtr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv415sanitizerMemsetPvi6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemset void  * devPtr int  value size_t  count Sanitizer_StreamHandle  stream Initializes or sets device memory to a value. Equivalent of cudaMemset that can be called within a callback function. Thread-safety : this function is thread safe. Parameters devPtr \u2013 Pointer to device memory. value \u2013 value to set for each byte of specified memory. count \u2013 Size in bytes to set. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 490, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemset::stream", "display_name": "sanitizerMemset::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv415sanitizerMemsetPvi6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemset void  * devPtr int  value size_t  count Sanitizer_StreamHandle  stream Initializes or sets device memory to a value. Equivalent of cudaMemset that can be called within a callback function. Thread-safety : this function is thread safe. Parameters devPtr \u2013 Pointer to device memory. value \u2013 value to set for each byte of specified memory. count \u2013 Size in bytes to set. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 491, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "cpp", "name": "sanitizerMemset::value", "display_name": "sanitizerMemset::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "_CPPv415sanitizerMemsetPvi6size_t22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerMemset void  * devPtr int  value size_t  count Sanitizer_StreamHandle  stream Initializes or sets device memory to a value. Equivalent of cudaMemset that can be called within a callback function. Thread-safety : this function is thread safe. Parameters devPtr \u2013 Pointer to device memory. value \u2013 value to set for each byte of specified memory. count \u2013 Size in bytes to set. stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 492, "doc_id": 492, "filename": "api/group__SANITIZER__MEMORY__API.html", "domain_name": "std", "name": "api/group__SANITIZER__MEMORY__API", "display_name": "Sanitizer Memory API", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__MEMORY__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the Sanitizer Memory API. Functions SanitizerResult  sanitizerAlloc (CUcontext ctx, void **devPtr, size_t size) Allocate memory on the device. SanitizerResult  sanitizerAllocHost (CUcontext ctx, void **devPtr, size_t size) Allocate host pinned memory. SanitizerResult  sanitizerFree (CUcontext ctx, void *devPtr) Frees memory on the device. SanitizerResult  sanitizerFreeHost (CUcontext ctx, void *devPtr) Frees host memory. SanitizerResult  sanitizerMemcpyDeviceToHost (void *dst, void *src, size_t count, Sanitizer_StreamHandle stream) Copies data from device to host. SanitizerResult  sanitizerMemcpyHostToDeviceAsync (void *dst, void *src, size_t count, Sanitizer_StreamHandle stream) Copies data from host to device. SanitizerResult  sanitizerMemset (void *devPtr, int value, size_t count, Sanitizer_StreamHandle stream) Initializes or sets device memory to a value.", "keywords": []}, {"id": 493, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_BARRIER_FLAG_FORCE_INT", "display_name": "SANITIZER_BARRIER_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags32SANITIZER_BARRIER_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_FORCE_INT", "keywords": []}, {"id": 494, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_BARRIER_FLAG_NONE", "display_name": "SANITIZER_BARRIER_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags27SANITIZER_BARRIER_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_NONE Empty flag.", "keywords": []}, {"id": 495, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED", "display_name": "SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags40SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWEDE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED Specifies that the barrier can be called unaligned. This flag is only valid on SM 7.0 and above.", "keywords": []}, {"id": 496, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CACHE_CONTROL_FORCE_INT", "display_name": "SANITIZER_CACHE_CONTROL_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind33SANITIZER_CACHE_CONTROL_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_FORCE_INT", "keywords": []}, {"id": 497, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CACHE_CONTROL_INVALID", "display_name": "SANITIZER_CACHE_CONTROL_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind31SANITIZER_CACHE_CONTROL_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_INVALID Invalid action ID.", "keywords": []}, {"id": 498, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CACHE_CONTROL_L1_PREFETCH", "display_name": "SANITIZER_CACHE_CONTROL_L1_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind35SANITIZER_CACHE_CONTROL_L1_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_L1_PREFETCH Prefetch to L1.", "keywords": []}, {"id": 499, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CACHE_CONTROL_L2_PREFETCH", "display_name": "SANITIZER_CACHE_CONTROL_L2_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind35SANITIZER_CACHE_CONTROL_L2_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_L2_PREFETCH Prefetch to L2.", "keywords": []}, {"id": 500, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CALL_FLAG_FORCE_INT", "display_name": "SANITIZER_CALL_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags29SANITIZER_CALL_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_FORCE_INT", "keywords": []}, {"id": 501, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CALL_FLAG_NONE", "display_name": "SANITIZER_CALL_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags24SANITIZER_CALL_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_NONE Empty flag.", "keywords": []}, {"id": 502, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED", "display_name": "SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags37SANITIZER_CALL_FLAG_UNALIGNED_ALLOWEDE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED Specifies that barriers within this function call can be called unaligned. This flag is only valid on SM 7.0 and above.", "keywords": []}, {"id": 503, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_ARRIVE", "display_name": "SANITIZER_CUDA_BARRIER_ARRIVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind29SANITIZER_CUDA_BARRIER_ARRIVEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE Barrier arrive operation. On Hopper and newer architectures, barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 504, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_ARRIVE_DROP", "display_name": "SANITIZER_CUDA_BARRIER_ARRIVE_DROP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind34SANITIZER_CUDA_BARRIER_ARRIVE_DROPE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_DROP Barrier arrive and drop operation. On Hopper and newer architectures, barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 505, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE", "display_name": "SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind45SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE Barrier arrive and drop operation without phase completion. Barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 506, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE", "display_name": "SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind40SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE Barrier arrive operation without phase completion. Barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 507, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_FORCE_INT", "display_name": "SANITIZER_CUDA_BARRIER_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind32SANITIZER_CUDA_BARRIER_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_FORCE_INT", "keywords": []}, {"id": 508, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_INIT", "display_name": "SANITIZER_CUDA_BARRIER_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind27SANITIZER_CUDA_BARRIER_INITE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INIT Barrier initialization.", "keywords": []}, {"id": 509, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_INVALID", "display_name": "SANITIZER_CUDA_BARRIER_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind30SANITIZER_CUDA_BARRIER_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INVALID Invalid action ID.", "keywords": []}, {"id": 510, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_INVALIDATE", "display_name": "SANITIZER_CUDA_BARRIER_INVALIDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind33SANITIZER_CUDA_BARRIER_INVALIDATEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INVALIDATE Barrier invalidation.", "keywords": []}, {"id": 511, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_CUDA_BARRIER_WAIT", "display_name": "SANITIZER_CUDA_BARRIER_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind27SANITIZER_CUDA_BARRIER_WAITE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_WAIT Barrier wait operation.", "keywords": []}, {"id": 512, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_FUNCTION_LOADED", "display_name": "SANITIZER_FUNCTION_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus25SANITIZER_FUNCTION_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_LOADED The function is fully loaded.", "keywords": []}, {"id": 513, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_FUNCTION_LOADED_FORCE_INT", "display_name": "SANITIZER_FUNCTION_LOADED_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus35SANITIZER_FUNCTION_LOADED_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_LOADED_FORCE_INT", "keywords": []}, {"id": 514, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_FUNCTION_NOT_LOADED", "display_name": "SANITIZER_FUNCTION_NOT_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus29SANITIZER_FUNCTION_NOT_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_NOT_LOADED The function is not loaded.", "keywords": []}, {"id": 515, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_FUNCTION_PARTIALLY_LOADED", "display_name": "SANITIZER_FUNCTION_PARTIALLY_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus35SANITIZER_FUNCTION_PARTIALLY_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_PARTIALLY_LOADED The function is being loaded.", "keywords": []}, {"id": 516, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_ASYNC_REDUCTION", "display_name": "SANITIZER_INSTRUCTION_ASYNC_REDUCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_ASYNC_REDUCTIONE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_ASYNC_REDUCTION Asynchronous reduction instruction. The type of the callback must be SanitizerCallbackAsyncReduction.", "keywords": []}, {"id": 517, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_ASYNC_STORE", "display_name": "SANITIZER_INSTRUCTION_ASYNC_STORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId33SANITIZER_INSTRUCTION_ASYNC_STOREE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_ASYNC_STORE Asynchronous store instruction. The type of the callback must be SanitizerCallbackAsyncStore.", "keywords": []}, {"id": 518, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BARRIER", "display_name": "SANITIZER_INSTRUCTION_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId29SANITIZER_INSTRUCTION_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BARRIER Barrier. The type of the callback must be SanitizerCallbackBarrier.", "keywords": []}, {"id": 519, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BARRIER_RELEASE", "display_name": "SANITIZER_INSTRUCTION_BARRIER_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_BARRIER_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BARRIER_RELEASE Barrier after it is released. The type of the callback must be SanitizerCallbackBarrier.", "keywords": []}, {"id": 520, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BLOCK_ENTER", "display_name": "SANITIZER_INSTRUCTION_BLOCK_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId33SANITIZER_INSTRUCTION_BLOCK_ENTERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BLOCK_ENTER CUDA block enter. This is called prior to any user code. The type of the callback must be SanitizerCallbackBlockEnter.", "keywords": []}, {"id": 521, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BLOCK_EXIT", "display_name": "SANITIZER_INSTRUCTION_BLOCK_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId32SANITIZER_INSTRUCTION_BLOCK_EXITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BLOCK_EXIT CUDA block exit. This is called after all user code has executed. The type of the callback must be SanitizerCallbackBlockExit.", "keywords": []}, {"id": 522, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED", "display_name": "SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED Bulk copy instruction from global to shared memory. The type of the callback must be SanitizerCallbackBulkCopyGlobalToShared.", "keywords": []}, {"id": 523, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL", "display_name": "SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL Bulk copy instruction from shared to global memory. The type of the callback must be SanitizerCallbackBulkCopyGSharedToGlobal.", "keywords": []}, {"id": 524, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED", "display_name": "SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED Bulk copy instruction from shared to shared memory. The type of the callback must be SanitizerCallbackBulkCopySharedToShared.", "keywords": []}, {"id": 525, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL", "display_name": "SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId53SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL Bulk reduction instruction from shared to global memory. The type of the callback must be SanitizerCallbackBulkReductionSharedToGlobal.", "keywords": []}, {"id": 526, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED", "display_name": "SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId53SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED Bulk reduction instruction from shared to shared memory. The type of the callback must be SanitizerCallbackBulkReductionSharedToShared.", "keywords": []}, {"id": 527, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CACHE_CONTROL", "display_name": "SANITIZER_INSTRUCTION_CACHE_CONTROL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_CACHE_CONTROLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CACHE_CONTROL Cache control instruction. The type of the callback must be SanitizerCallbackCacheControl.", "keywords": []}, {"id": 528, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CALL", "display_name": "SANITIZER_INSTRUCTION_CALL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId26SANITIZER_INSTRUCTION_CALLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CALL Function call. The type of the callback must be SanitizerCallbackCall.", "keywords": []}, {"id": 529, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE", "display_name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId44SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE Cluster barrier arrive instruction. The type of the callback must be SanitizerCallbackClusterBarrierArrive.", "keywords": []}, {"id": 530, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT", "display_name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT Cluster barrier wait instruction. The type of the callback must be SanitizerCallbackClusterBarrierWait.", "keywords": []}, {"id": 531, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY", "display_name": "SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRYE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY Entering cluster barrier wait instruction. The type of the callback must be SanitizerCallbackClusterBarrierWait.", "keywords": []}, {"id": 532, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CUDA_BARRIER", "display_name": "SANITIZER_INSTRUCTION_CUDA_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId34SANITIZER_INSTRUCTION_CUDA_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CUDA_BARRIER CUDA Barrier operation. The type of the callback must be SanitizerCallbackCudaBarrier.", "keywords": []}, {"id": 533, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT", "display_name": "SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPTE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT CUDA Barrier operation (potentially unsuccessful). The type of the callback must be SanitizerCallbackCudaBarrierAttempt.", "keywords": []}, {"id": 534, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC", "display_name": "SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId43SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC Device-side aligned malloc. The type of the callback must be SanitizerCallbackDeviceSideMalloc.", "keywords": []}, {"id": 535, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE", "display_name": "SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId38SANITIZER_INSTRUCTION_DEVICE_SIDE_FREEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE Device-side free. The type of the callback must be SanitizerCallbackDeviceSideFree.", "keywords": []}, {"id": 536, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC", "display_name": "SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId40SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC Device-side malloc. The type of the callback must be SanitizerCallbackDeviceSideMalloc.", "keywords": []}, {"id": 537, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_FORCE_INT", "display_name": "SANITIZER_INSTRUCTION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId31SANITIZER_INSTRUCTION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_FORCE_INT", "keywords": []}, {"id": 538, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS", "display_name": "SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS Global Memory Access. This can be a store, load or atomic operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 539, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_INVALID", "display_name": "SANITIZER_INSTRUCTION_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId29SANITIZER_INSTRUCTION_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_INVALID Invalid instruction ID.", "keywords": []}, {"id": 540, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS", "display_name": "SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS Local Memory Access. This can be a store or load operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 541, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS", "display_name": "SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS Matrix shared memory access. The type of the callback must be SanitizerCallbackMatrixMemoryAccess.", "keywords": []}, {"id": 542, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_MEMCPY_ASYNC", "display_name": "SANITIZER_INSTRUCTION_MEMCPY_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId34SANITIZER_INSTRUCTION_MEMCPY_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMCPY_ASYNC Global to shared memory asynchronous copy. The type of the callback must be SanitizerCallbackMemcpyAsync.", "keywords": []}, {"id": 543, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER", "display_name": "SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER Usage of a Cuda Barrier for memcpy async completion. The type of the callback must be SanitizerCallbackMemcpyAsyncBarrier.", "keywords": []}, {"id": 544, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_MEMSET_SHARED", "display_name": "SANITIZER_INSTRUCTION_MEMSET_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_MEMSET_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMSET_SHARED Bulk copy instruction from global to shared memory. The type of the callback must be SanitizerCallbackMemsetShared.", "keywords": []}, {"id": 545, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_PIPELINE_COMMIT", "display_name": "SANITIZER_INSTRUCTION_PIPELINE_COMMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_PIPELINE_COMMITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_PIPELINE_COMMIT Pipeline commit. The type of the callback must be SanitizerCallbackPipelineCommit.", "keywords": []}, {"id": 546, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_PIPELINE_WAIT", "display_name": "SANITIZER_INSTRUCTION_PIPELINE_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_PIPELINE_WAITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_PIPELINE_WAIT Pipeline wait. The type of the callback must be SanitizerCallbackPipelineWait.", "keywords": []}, {"id": 547, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS", "display_name": "SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId49SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS Remote Shared Memory Access. This can be a store or load operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 548, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_RET", "display_name": "SANITIZER_INSTRUCTION_RET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId25SANITIZER_INSTRUCTION_RETE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_RET Function return. The type of the callback must be SanitizerCallbackRet.", "keywords": []}, {"id": 549, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE", "display_name": "SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId44SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE Set the shared memory size allocated to a block instruction. The type of the callback must be SanitizerCallbackSetSmemSize.", "keywords": []}, {"id": 550, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS", "display_name": "SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS Shared Memory Access. This can be a store, load or atomic operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 551, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_SHFL", "display_name": "SANITIZER_INSTRUCTION_SHFL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId26SANITIZER_INSTRUCTION_SHFLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SHFL Shfl. The type of the callback must be SanitizerCallbackShfl.", "keywords": []}, {"id": 552, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_SYNCWARP", "display_name": "SANITIZER_INSTRUCTION_SYNCWARP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId30SANITIZER_INSTRUCTION_SYNCWARPE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SYNCWARP Syncwarp. The type of the callback must be SanitizerCallbackSyncwarp.", "keywords": []}, {"id": 553, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_SYNCWARP_RELEASE", "display_name": "SANITIZER_INSTRUCTION_SYNCWARP_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId38SANITIZER_INSTRUCTION_SYNCWARP_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SYNCWARP_RELEASE Syncwarp after it is released. The type of the callback must be SanitizerCallbackSyncwarp.", "keywords": []}, {"id": 554, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER", "display_name": "SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER Tensor Core barrier. The type of the callback must be SanitizerCallbackTensorCoreBarrier.", "keywords": []}, {"id": 555, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_WARPGROUP_FENCE", "display_name": "SANITIZER_INSTRUCTION_WARPGROUP_FENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_WARPGROUP_FENCEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_FENCE Warpgroup fence instruction. The type of the callback must be SanitizerCallbackWarpgroupFence.", "keywords": []}, {"id": 556, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC", "display_name": "SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC Warpgroup aligned async MMA instruction. The type of the callback must be SanitizerCallbackWarpgroupMMAAsync.", "keywords": []}, {"id": 557, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP", "display_name": "SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUPE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP Warpgroup wait MMA group instruction. The type of the callback must be SanitizerCallbackWarpgroupWaitGroup.", "keywords": []}, {"id": 558, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags36SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYSE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS Specifies that the access is a system-scoped atomic.", "keywords": []}, {"id": 559, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags38SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "keywords": []}, {"id": 560, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_NONE", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags33SANITIZER_MEMORY_DEVICE_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_NONE Empty flag.", "keywords": []}, {"id": 561, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags37SANITIZER_MEMORY_DEVICE_FLAG_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH Specifies that the access is a cache prefetch.", "keywords": []}, {"id": 562, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_READ", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags33SANITIZER_MEMORY_DEVICE_FLAG_READE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_READ Specifies that the access is a read.", "keywords": []}, {"id": 563, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_MEMORY_DEVICE_FLAG_WRITE", "display_name": "SANITIZER_MEMORY_DEVICE_FLAG_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags34SANITIZER_MEMORY_DEVICE_FLAG_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_WRITE Specifies that the access is a write.", "keywords": []}, {"id": 564, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_PATCH_ERROR", "display_name": "SANITIZER_PATCH_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult21SANITIZER_PATCH_ERRORE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_ERROR An error was detected in the patch.", "keywords": []}, {"id": 565, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_PATCH_FORCE_INT", "display_name": "SANITIZER_PATCH_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult25SANITIZER_PATCH_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_FORCE_INT", "keywords": []}, {"id": 566, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_PATCH_SUCCESS", "display_name": "SANITIZER_PATCH_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult23SANITIZER_PATCH_SUCCESSE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_SUCCESS No error.", "keywords": []}, {"id": 567, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP", "display_name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags47SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUPE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP Specifies that the MMA async delimits a MMA async group of which it is the last instruction. Please refer to the PTX documentation for wgmma_async.commit_group for more details. This property is valid even if the warpMask is zero.", "keywords": []}, {"id": 568, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "display_name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags44SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "keywords": []}, {"id": 569, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE", "display_name": "SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags39SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE Empty flag.", "keywords": []}, {"id": 570, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackAsyncReduction", "display_name": "SanitizerCallbackAsyncReduction", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv431SanitizerCallbackAsyncReduction", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackAsyncReduction ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  address ,  uint32_t  mbarAddress ,  uint32_t  accessSize ) Function type for an asynchronous reduction operation on shared memory. This can be generated by a red.async PTX instruction. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param address Destination address in shared memory. Param mbarAddress Address of the mbarrier object. Param accessSize Size of the access in bytes. Valid values are 4 and 8.", "keywords": []}, {"id": 571, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackAsyncStore", "display_name": "SanitizerCallbackAsyncStore", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427SanitizerCallbackAsyncStore", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackAsyncStore ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  address ,  uint32_t  mbarAddress ,  void  * pNewValue ,  uint32_t  accessSize ) Function type for an asynchronous store operation on shared memory. This can be generated by a st.async PTX instruction. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param address Destination address in shared memory. Param mbarAddress Address of the mbarrier object. Param pNewValue Pointer to the new value being written. Param accessSize Size of the access in bytes. Valid values are 4 and 8.", "keywords": []}, {"id": 572, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBarrier", "display_name": "SanitizerCallbackBarrier", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv424SanitizerCallbackBarrier", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBarrier ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  barIndex ,  uint32_t  threadCount ,  uint32_t  flags ) Function type for a barrier callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param barIndex Barrier index. Param threadCount Number of expected threads (must be a multiple of the warp size). Param flags Contains information about the barrier. See Sanitizer_BarrierFlags to interpret this value. 0 means that all threads are participating in the barrier.", "keywords": []}, {"id": 573, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBlockEnter", "display_name": "SanitizerCallbackBlockEnter", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427SanitizerCallbackBlockEnter", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBlockEnter ) ( void  * userdata ,  uint64_t  pc ) Function type for a CUDA block enter callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the entry point of the block.", "keywords": []}, {"id": 574, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBlockExit", "display_name": "SanitizerCallbackBlockExit", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv426SanitizerCallbackBlockExit", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBlockExit ) ( void  * userdata ,  uint64_t  pc ) Function type for a CUDA block exit callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction.", "keywords": []}, {"id": 575, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBulkCopyGlobalToShared", "display_name": "SanitizerCallbackBulkCopyGlobalToShared", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv439SanitizerCallbackBulkCopyGlobalToShared", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBulkCopyGlobalToShared ) ( void  * userdata ,  uint64_t  pc ,  uint64_t  src ,  uint32_t  dst ,  uint32_t  barrier ,  uint32_t  data ,  uint32_t  isMulticast ) Function type for a async bulk copy from global to shared memory. This can be generated by a cp.async.bulk.shared::cluster.global instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param src Source global memory address. Param dst Destination DSMEM address. Param barrier DSMEM address for the associated mbarrier completion mechanism. Param data Contains in bits 0:15 the number of 16 bytes blocks requested and in bits 16:31 the multicast mask. Param isMulticast Boolean value indicating if the operation is a multicast.", "keywords": []}, {"id": 576, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBulkCopySharedToGlobal", "display_name": "SanitizerCallbackBulkCopySharedToGlobal", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv439SanitizerCallbackBulkCopySharedToGlobal", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBulkCopySharedToGlobal ) ( void  * userdata ,  uint64_t  pc ,  uint64_t  dst ,  uint32_t  src ,  uint32_t  numBlocks ) Function type for a async bulk copy from shared to global memory. This can be generated by a cp.async.bulk.global.shared::cta instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param dst Destination global memory address. Param src Source DSMEM address. Param numBlocks Contains the number of 16 bytes blocks requested to be copied.", "keywords": []}, {"id": 577, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBulkCopySharedToShared", "display_name": "SanitizerCallbackBulkCopySharedToShared", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv439SanitizerCallbackBulkCopySharedToShared", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBulkCopySharedToShared ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  src ,  uint32_t  dst ,  uint32_t  barrier ,  uint32_t  numBlocks ) Function type for a async bulk copy from shared to shered memory. This can be generated by a cp.async.bulk.shared::cluster.shared::cta instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param src Source DSMEM address. Param dst Destination DSMEM address. Param barrier DSMEM address for the associated mbarrier completion mechanism. Param numBlocks Contains the number of 16 bytes blocks requested to be copied.", "keywords": []}, {"id": 578, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBulkReductionSharedToGlobal", "display_name": "SanitizerCallbackBulkReductionSharedToGlobal", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv444SanitizerCallbackBulkReductionSharedToGlobal", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBulkReductionSharedToGlobal ) ( void  * userdata ,  uint64_t  pc ,  uint64_t  dst ,  uint32_t  src ,  uint32_t  numBlocks ) Function type for a async bulk reduction from shared to global memory. This can be generated by a cp.reduce.async.bulk.global.shared::cta.bulk_group instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param dst Destination DSMEM address. Param src Source DSMEM address. Param barrier DSMEM address for the associated mbarrier completion mechanism. Param numBlocks Contains the number of 16 bytes blocks requested to be copied.", "keywords": []}, {"id": 579, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackBulkReductionSharedToShared", "display_name": "SanitizerCallbackBulkReductionSharedToShared", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv444SanitizerCallbackBulkReductionSharedToShared", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackBulkReductionSharedToShared ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  src ,  uint32_t  dst ,  uint32_t  barrier ,  uint32_t  numBlocks ) Function type for a async bulk reduction from shared to shered memory. This can be generated by a cp.reduce.async.bulk.shared::cluster.shared::cta.mbarrier::complete_tx::bytes instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param src Source DSMEM address. Param dst Destination DSMEM address. Param barrier DSMEM address for the associated mbarrier completion mechanism. Param numBlocks Contains the number of 16 bytes blocks requested to be copied.", "keywords": []}, {"id": 580, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackCacheControl", "display_name": "SanitizerCallbackCacheControl", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429SanitizerCallbackCacheControl", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackCacheControl ) ( void  * userdata ,  uint64_t  pc ,  void  * address ,  Sanitizer_CacheControlInstructionKind  kind ) Function type for a cache control instruction callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param address Address of the memory being controlled. Param kind Type of cache control. See Sanitizer_CacheControlInstructionKind .", "keywords": []}, {"id": 581, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackCall", "display_name": "SanitizerCallbackCall", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv421SanitizerCallbackCall", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackCall ) ( void  * userdata ,  uint64_t  pc ,  uint64_t  targetPc ,  uint32_t  flags ) Function type for a function call callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param targetPc PC where the called function is located. Param flags Contains information about the function call.", "keywords": []}, {"id": 582, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackClusterBarrierArrive", "display_name": "SanitizerCallbackClusterBarrierArrive", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv437SanitizerCallbackClusterBarrierArrive", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackClusterBarrierArrive ) ( void  * userdata ,  uint64_t  pc ) Function type for a cluster barrier arrive. This can be generated by a cg::this_cluster().sync() (C++ API), or a barrier.cluster.arrive (PTX API). Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction.", "keywords": []}, {"id": 583, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackClusterBarrierWait", "display_name": "SanitizerCallbackClusterBarrierWait", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv435SanitizerCallbackClusterBarrierWait", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackClusterBarrierWait ) ( void  * userdata ,  uint64_t  pc ) Function type for a cluster barrier wait. This can be generated by a cg::this_cluster().sync() (C++ API), or a barrier.cluster.wait (PTX API). Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Retval SANITIZER_PATCH_SUCCESS Warp execution continues. Retval SANITIZER_PATCH_ERROR Warp should be exited.", "keywords": []}, {"id": 584, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackCudaBarrier", "display_name": "SanitizerCallbackCudaBarrier", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv428SanitizerCallbackCudaBarrier", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackCudaBarrier ) ( void  * userdata ,  uint64_t  pc ,  void  * barrier ,  uint32_t  kind ,  uint32_t  data ) Function type for a CUDA Barrier action callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param barrier Barrier address which can be used as a unique identifier. Param kind Barrier action type. See Sanitizer_CudaBarrierInstructionKind . Param data Barrier data. This is specific to each action type, refer to Sanitizer_CudaBarrierInstructionKind .", "keywords": []}, {"id": 585, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackCudaBarrierAttempt", "display_name": "SanitizerCallbackCudaBarrierAttempt", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv435SanitizerCallbackCudaBarrierAttempt", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackCudaBarrierAttempt ) ( void  * userdata ,  uint64_t  pc ,  void  * barrier ,  uint32_t  kind ,  uint32_t  data ,  uint32_t  result ) Function type for a CUDA Barrier action callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param barrier Barrier address which can be used as a unique identifier. Param kind Barrier action type. See Sanitizer_CudaBarrierInstructionKind . Param data Barrier data. This is specific to each action type, refer to Sanitizer_CudaBarrierInstructionKind . Param result In case of a barrier wait, this indicates whether the wait was successful or not.", "keywords": []}, {"id": 586, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackDeviceSideFree", "display_name": "SanitizerCallbackDeviceSideFree", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv431SanitizerCallbackDeviceSideFree", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackDeviceSideFree ) ( void  * userdata ,  uint64_t  pc ,  void  * ptr ) Function type for a device-side free call. This is called prior to the actual call. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param ptr Pointer passed to device-side free.", "keywords": []}, {"id": 587, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackDeviceSideMalloc", "display_name": "SanitizerCallbackDeviceSideMalloc", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv433SanitizerCallbackDeviceSideMalloc", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackDeviceSideMalloc ) ( void  * userdata ,  uint64_t  pc ,  void  * allocatedPtr ,  uint64_t  allocatedSize ) Function type for a device-side malloc call. This is called after the call has completed. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param allocatedPtr Pointer returned by device-side malloc. Param allocatedSize Size requested by the user to device-side malloc.", "keywords": []}, {"id": 588, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackMatrixMemoryAccess", "display_name": "SanitizerCallbackMatrixMemoryAccess", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv435SanitizerCallbackMatrixMemoryAccess", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackMatrixMemoryAccess ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  address ,  uint32_t  accessSize ,  uint32_t  flags ,  uint32_t  count ,  const  void  * pNewValue ) Function type for a matrix shared memory access callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param address Address of the shared memory being read or written. This is an offset within the shared memory window. Param accessSize Size of the access in bytes. Valid value is 16. Param flags Contains information about the type of access. See Sanitizer_DeviceMemoryFlags to interpret this value. Param count Number of matrices accessed. Param pNewValue Pointer to the new value being written if the access is a write. If the access is a read or an atomic, the pointer will be NULL.", "keywords": []}, {"id": 589, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackMemcpyAsync", "display_name": "SanitizerCallbackMemcpyAsync", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv428SanitizerCallbackMemcpyAsync", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackMemcpyAsync ) ( void  * userdata ,  uint64_t  pc ,  void  * src ,  uint32_t  dst ,  uint32_t  accessSize ) Function type for a global to shared memory asynchronous copy. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param src Address of the global memory being read. This can be NULL if src-size is 0. Param dst Address of the shared memory being written. This is an offset within the shared memory window. Param accessSize Size of the access in bytes. Valid values are 4, 8 and 16.", "keywords": []}, {"id": 590, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackMemcpyAsyncBarrier", "display_name": "SanitizerCallbackMemcpyAsyncBarrier", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv435SanitizerCallbackMemcpyAsyncBarrier", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackMemcpyAsyncBarrier ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  barrier ) Function type for a cuda barrier used for mbarrier completion. This can be generated by cp.async.mbarrier.arrive. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param barrier Shared memory address of the barrier.", "keywords": []}, {"id": 591, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackMemoryAccess", "display_name": "SanitizerCallbackMemoryAccess", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429SanitizerCallbackMemoryAccess", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackMemoryAccess ) ( void  * userdata ,  uint64_t  pc ,  void  * ptr ,  uint32_t  accessSize ,  uint32_t  flags ,  const  void  * pData ) Function type for a memory access callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param ptr Address of the memory being accessed. For local or shared memory access, this is the offset within the local or shared memory window. Param accessSize Size of the access in bytes. Valid values are 1, 2, 4, 8, and 16. Param flags Contains information about the type of access. See Sanitizer_DeviceMemoryFlags to interpret this value. Param pData Pointer which value depends on the type of access: If the access is a write, pData points to the new value being written. If the access is a read and pData is not NULL , then it points to a 32-bit mask of loaded bytes being used (padding bytes will not appear). If the access is an atomic, the pointer will be NULL .", "keywords": []}, {"id": 592, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackMemsetShared", "display_name": "SanitizerCallbackMemsetShared", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429SanitizerCallbackMemsetShared", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackMemsetShared ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  dst ,  uint32_t  numBlocks ) Function type for a memset on shared memory. This can be generated by st.bulk. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param dst Destination shared memory address. Param numBlocks Number of 8 byte blocks to be set to zero.", "keywords": []}, {"id": 593, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackPipelineCommit", "display_name": "SanitizerCallbackPipelineCommit", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv431SanitizerCallbackPipelineCommit", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackPipelineCommit ) ( void  * userdata ,  uint64_t  pc ) Function type for a pipeline commit. This can be generated by a pipeline::producer_commit (C++ API), a pipeline_commit (C API) or a cp.async.commit_group (PTX API). Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction.", "keywords": []}, {"id": 594, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackPipelineWait", "display_name": "SanitizerCallbackPipelineWait", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429SanitizerCallbackPipelineWait", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackPipelineWait ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  groups ) Function type for a pipeline wait. This can be generated by a pipeline::consumer_wait (C++ API), a pipeline_wait_prior (C API), cp.async.wait_group or cp.async.wait_all (PTX API). Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param groups Number of groups the pipeline will wait for. 0 is used to wait for all groups.", "keywords": []}, {"id": 595, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackRet", "display_name": "SanitizerCallbackRet", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv420SanitizerCallbackRet", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackRet ) ( void  * userdata ,  uint64_t  pc ) Function type for a function return callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction.", "keywords": []}, {"id": 596, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackSetSmemSize", "display_name": "SanitizerCallbackSetSmemSize", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv428SanitizerCallbackSetSmemSize", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackSetSmemSize ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  size ) Function type for setting the shared memory size allocated to a block. This can be generated by a setsmemsize.sync instruction. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param size Requested size in bytes.", "keywords": []}, {"id": 597, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackShfl", "display_name": "SanitizerCallbackShfl", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv421SanitizerCallbackShfl", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackShfl ) ( void  * userdata ,  uint64_t  pc ) Function type for a shfl callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction.", "keywords": []}, {"id": 598, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackSyncwarp", "display_name": "SanitizerCallbackSyncwarp", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv425SanitizerCallbackSyncwarp", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackSyncwarp ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  mask ) Function type for a syncwarp callback. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param mask Thread mask passed to __syncwarp().", "keywords": []}, {"id": 599, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackTensorCoreBarrier", "display_name": "SanitizerCallbackTensorCoreBarrier", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv434SanitizerCallbackTensorCoreBarrier", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackTensorCoreBarrier ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  barrier ,  uint32_t  isMulticast ,  uint32_t  multicastMask ) Function type for a Blackwell tensor core barrier. This can be generated by a tcgen05.commit instruction. All the active threads in a warp have the same parameter values. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param barrier DSMEM address for the associated mbarrier completion mechanism. Param isMulticast Boolean value indicating if the operation is a multicast. Param multicastMask Multicast mask, if isMulticast is true.", "keywords": []}, {"id": 600, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackWarpgroupFence", "display_name": "SanitizerCallbackWarpgroupFence", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv431SanitizerCallbackWarpgroupFence", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackWarpgroupFence ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  warpMask ) Function type for a warpgroup MMA fence. This can be generated by a wgmma.fence in PTX. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param warpMask Mask of threads that will perform the fence operation. Expected values are either 0x0 or 0xffffffff (full). The value is expected to be the same across the warpgroup. Other values can be reported but signal a programming error in the target application.", "keywords": []}, {"id": 601, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackWarpgroupMMAAsync", "display_name": "SanitizerCallbackWarpgroupMMAAsync", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv434SanitizerCallbackWarpgroupMMAAsync", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackWarpgroupMMAAsync ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  addressMatrixA ,  uint32_t  sizeMatrixA ,  uint32_t  addressMatrixB ,  uint32_t  sizeMatrixB ,  uint32_t  flags ,  uint32_t  warpMask ) Function type for a warpgroup aligned async MMA. This can be generated by a wgmma.mma_async in PTX. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param addressMatrixA Address in shared memory of the matrix A being read. This field is only valid if sizeMatrixA is non-zero and warpMask is full. Param sizeMatrixA Size of the matrix A in shared memory. A value of 0 means that the matrix A is read from registers instead. Param addressMatrixB Address in shared memory of the matrix B being read. This field is only valid if warpMask is full. Param sizeMatrixB Size of the matrix B in shared memory. The value will always be non-zero. Param flags Type is Sanitizer_WarpgroupMMAAsyncFlags . Provide information about the access. These flags are to be taken into account even if the warpMask is zero. Param warpMask Mask of threads that will perform the operation and read the operands. Expected values are either 0x0 or 0xffffffff (full). The value is expected to be the same across the warpgroup. Other values can be reported but signal a programming error in the target application.", "keywords": []}, {"id": 602, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerCallbackWarpgroupWaitGroup", "display_name": "SanitizerCallbackWarpgroupWaitGroup", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv435SanitizerCallbackWarpgroupWaitGroup", "priority": 1, "content": "typedef  SanitizerPatchResult  ( * SanitizerCallbackWarpgroupWaitGroup ) ( void  * userdata ,  uint64_t  pc ,  uint32_t  numGroups ,  uint32_t  warpMask ) Function type for a warpgroup MMA wait group. This can be generated by a wgmma.wait_group in PTX. Param userdata Pointer to user data. See sanitizerPatchModule . Param pc Program counter of the patched instruction. Param numGroups Maximum number of group that will be left pending after the operation. A value of zero means that all MMA async of the warpgroup are guaranteed to have completed after the operation. Param warpMask Mask of threads for which the expected values are either 0x0 or 0xffffffff (full). The value is expected to be the same across the warpgroup. Other values can be reported but signal a programming error in the target application. If the value is valid, the value has no influence on the operation.", "keywords": []}, {"id": 603, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerPatchResult", "display_name": "SanitizerPatchResult", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv420SanitizerPatchResult", "priority": 1, "content": "enum  SanitizerPatchResult Sanitizer patch result codes. Error and result codes returned by Sanitizer patches. If a patch returns SANITIZER_PATCH_ERROR, the full warp which the thread belongs to will be exited. Values:", "keywords": []}, {"id": 604, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerPatchResult::SANITIZER_PATCH_ERROR", "display_name": "SanitizerPatchResult::SANITIZER_PATCH_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult21SANITIZER_PATCH_ERRORE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_ERROR An error was detected in the patch.", "keywords": []}, {"id": 605, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerPatchResult::SANITIZER_PATCH_FORCE_INT", "display_name": "SanitizerPatchResult::SANITIZER_PATCH_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult25SANITIZER_PATCH_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_FORCE_INT", "keywords": []}, {"id": 606, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "SanitizerPatchResult::SANITIZER_PATCH_SUCCESS", "display_name": "SanitizerPatchResult::SANITIZER_PATCH_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N20SanitizerPatchResult23SANITIZER_PATCH_SUCCESSE", "priority": 1, "content": "enumerator  SANITIZER_PATCH_SUCCESS No error.", "keywords": []}, {"id": 607, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_BarrierFlags", "display_name": "Sanitizer_BarrierFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv422Sanitizer_BarrierFlags", "priority": 1, "content": "enum  Sanitizer_BarrierFlags Flags describing a barrier. Flags describing a barrier. These values are to be or-combined in the value of flags for a SanitizerCallbackBarrier callback. Values:", "keywords": []}, {"id": 608, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_FORCE_INT", "display_name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags32SANITIZER_BARRIER_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_FORCE_INT", "keywords": []}, {"id": 609, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_NONE", "display_name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags27SANITIZER_BARRIER_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_NONE Empty flag.", "keywords": []}, {"id": 610, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED", "display_name": "Sanitizer_BarrierFlags::SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N22Sanitizer_BarrierFlags40SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWEDE", "priority": 1, "content": "enumerator  SANITIZER_BARRIER_FLAG_UNALIGNED_ALLOWED Specifies that the barrier can be called unaligned. This flag is only valid on SM 7.0 and above.", "keywords": []}, {"id": 611, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CacheControlInstructionKind", "display_name": "Sanitizer_CacheControlInstructionKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv437Sanitizer_CacheControlInstructionKind", "priority": 1, "content": "enum  Sanitizer_CacheControlInstructionKind Cache control action. Values:", "keywords": []}, {"id": 612, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_FORCE_INT", "display_name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind33SANITIZER_CACHE_CONTROL_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_FORCE_INT", "keywords": []}, {"id": 613, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_INVALID", "display_name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind31SANITIZER_CACHE_CONTROL_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_INVALID Invalid action ID.", "keywords": []}, {"id": 614, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_L1_PREFETCH", "display_name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_L1_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind35SANITIZER_CACHE_CONTROL_L1_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_L1_PREFETCH Prefetch to L1.", "keywords": []}, {"id": 615, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_L2_PREFETCH", "display_name": "Sanitizer_CacheControlInstructionKind::SANITIZER_CACHE_CONTROL_L2_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N37Sanitizer_CacheControlInstructionKind35SANITIZER_CACHE_CONTROL_L2_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_CACHE_CONTROL_L2_PREFETCH Prefetch to L2.", "keywords": []}, {"id": 616, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CallFlags", "display_name": "Sanitizer_CallFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv419Sanitizer_CallFlags", "priority": 1, "content": "enum  Sanitizer_CallFlags Flags describing a function call. Flags describing a function call. These values are to be or-combined in the value of flags for a SanitizerCallbackCall callback. Values:", "keywords": []}, {"id": 617, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_FORCE_INT", "display_name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags29SANITIZER_CALL_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_FORCE_INT", "keywords": []}, {"id": 618, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_NONE", "display_name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags24SANITIZER_CALL_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_NONE Empty flag.", "keywords": []}, {"id": 619, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED", "display_name": "Sanitizer_CallFlags::SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N19Sanitizer_CallFlags37SANITIZER_CALL_FLAG_UNALIGNED_ALLOWEDE", "priority": 1, "content": "enumerator  SANITIZER_CALL_FLAG_UNALIGNED_ALLOWED Specifies that barriers within this function call can be called unaligned. This flag is only valid on SM 7.0 and above.", "keywords": []}, {"id": 620, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind", "display_name": "Sanitizer_CudaBarrierInstructionKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv436Sanitizer_CudaBarrierInstructionKind", "priority": 1, "content": "enum  Sanitizer_CudaBarrierInstructionKind CUDA Barrier action kind. Refer to the CUDA Barrier interface section of the CUDA toolkit documentation for a more extensive description of these actions. Values:", "keywords": []}, {"id": 621, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind29SANITIZER_CUDA_BARRIER_ARRIVEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE Barrier arrive operation. On Hopper and newer architectures, barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 622, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_DROP", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_DROP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind34SANITIZER_CUDA_BARRIER_ARRIVE_DROPE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_DROP Barrier arrive and drop operation. On Hopper and newer architectures, barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 623, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind45SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_DROP_NOCOMPLETE Barrier arrive and drop operation without phase completion. Barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 624, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind40SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_ARRIVE_NOCOMPLETE Barrier arrive operation without phase completion. Barrier data is the count argument to the arrive-on operation.", "keywords": []}, {"id": 625, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_FORCE_INT", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind32SANITIZER_CUDA_BARRIER_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_FORCE_INT", "keywords": []}, {"id": 626, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INIT", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind27SANITIZER_CUDA_BARRIER_INITE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INIT Barrier initialization.", "keywords": []}, {"id": 627, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INVALID", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind30SANITIZER_CUDA_BARRIER_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INVALID Invalid action ID.", "keywords": []}, {"id": 628, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INVALIDATE", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_INVALIDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind33SANITIZER_CUDA_BARRIER_INVALIDATEE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_INVALIDATE Barrier invalidation.", "keywords": []}, {"id": 629, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_WAIT", "display_name": "Sanitizer_CudaBarrierInstructionKind::SANITIZER_CUDA_BARRIER_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N36Sanitizer_CudaBarrierInstructionKind27SANITIZER_CUDA_BARRIER_WAITE", "priority": 1, "content": "enumerator  SANITIZER_CUDA_BARRIER_WAIT Barrier wait operation.", "keywords": []}, {"id": 630, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags", "display_name": "Sanitizer_DeviceMemoryFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427Sanitizer_DeviceMemoryFlags", "priority": 1, "content": "enum  Sanitizer_DeviceMemoryFlags Flags describing a memory access. Flags describing a memory access. These values are to be or-combined in the value of flags for a SanitizerCallbackMemoryAccess callback. Values:", "keywords": []}, {"id": 631, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags36SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYSE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_ATOMSYS Specifies that the access is a system-scoped atomic.", "keywords": []}, {"id": 632, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags38SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_FORCE_INT", "keywords": []}, {"id": 633, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_NONE", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags33SANITIZER_MEMORY_DEVICE_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_NONE Empty flag.", "keywords": []}, {"id": 634, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags37SANITIZER_MEMORY_DEVICE_FLAG_PREFETCHE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_PREFETCH Specifies that the access is a cache prefetch.", "keywords": []}, {"id": 635, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_READ", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags33SANITIZER_MEMORY_DEVICE_FLAG_READE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_READ Specifies that the access is a read.", "keywords": []}, {"id": 636, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_WRITE", "display_name": "Sanitizer_DeviceMemoryFlags::SANITIZER_MEMORY_DEVICE_FLAG_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N27Sanitizer_DeviceMemoryFlags34SANITIZER_MEMORY_DEVICE_FLAG_WRITEE", "priority": 1, "content": "enumerator  SANITIZER_MEMORY_DEVICE_FLAG_WRITE Specifies that the access is a write.", "keywords": []}, {"id": 637, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_FunctionLoadedStatus", "display_name": "Sanitizer_FunctionLoadedStatus", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430Sanitizer_FunctionLoadedStatus", "priority": 1, "content": "enum  Sanitizer_FunctionLoadedStatus Values:", "keywords": []}, {"id": 638, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_LOADED", "display_name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus25SANITIZER_FUNCTION_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_LOADED The function is fully loaded.", "keywords": []}, {"id": 639, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_LOADED_FORCE_INT", "display_name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_LOADED_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus35SANITIZER_FUNCTION_LOADED_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_LOADED_FORCE_INT", "keywords": []}, {"id": 640, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_NOT_LOADED", "display_name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_NOT_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus29SANITIZER_FUNCTION_NOT_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_NOT_LOADED The function is not loaded.", "keywords": []}, {"id": 641, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_PARTIALLY_LOADED", "display_name": "Sanitizer_FunctionLoadedStatus::SANITIZER_FUNCTION_PARTIALLY_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N30Sanitizer_FunctionLoadedStatus35SANITIZER_FUNCTION_PARTIALLY_LOADEDE", "priority": 1, "content": "enumerator  SANITIZER_FUNCTION_PARTIALLY_LOADED The function is being loaded.", "keywords": []}, {"id": 642, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId", "display_name": "Sanitizer_InstructionId", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv423Sanitizer_InstructionId", "priority": 1, "content": "enum  Sanitizer_InstructionId Instrumentation. Instrumentation. Every entry represent an instruction type or a function call where a callback patch can be inserted. Values:", "keywords": []}, {"id": 643, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_ASYNC_REDUCTION", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_ASYNC_REDUCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_ASYNC_REDUCTIONE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_ASYNC_REDUCTION Asynchronous reduction instruction. The type of the callback must be SanitizerCallbackAsyncReduction.", "keywords": []}, {"id": 644, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_ASYNC_STORE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_ASYNC_STORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId33SANITIZER_INSTRUCTION_ASYNC_STOREE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_ASYNC_STORE Asynchronous store instruction. The type of the callback must be SanitizerCallbackAsyncStore.", "keywords": []}, {"id": 645, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BARRIER", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId29SANITIZER_INSTRUCTION_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BARRIER Barrier. The type of the callback must be SanitizerCallbackBarrier.", "keywords": []}, {"id": 646, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BARRIER_RELEASE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BARRIER_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_BARRIER_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BARRIER_RELEASE Barrier after it is released. The type of the callback must be SanitizerCallbackBarrier.", "keywords": []}, {"id": 647, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BLOCK_ENTER", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BLOCK_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId33SANITIZER_INSTRUCTION_BLOCK_ENTERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BLOCK_ENTER CUDA block enter. This is called prior to any user code. The type of the callback must be SanitizerCallbackBlockEnter.", "keywords": []}, {"id": 648, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BLOCK_EXIT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BLOCK_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId32SANITIZER_INSTRUCTION_BLOCK_EXITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BLOCK_EXIT CUDA block exit. This is called after all user code has executed. The type of the callback must be SanitizerCallbackBlockExit.", "keywords": []}, {"id": 649, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_GLOBAL_TO_SHARED Bulk copy instruction from global to shared memory. The type of the callback must be SanitizerCallbackBulkCopyGlobalToShared.", "keywords": []}, {"id": 650, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_GLOBAL Bulk copy instruction from shared to global memory. The type of the callback must be SanitizerCallbackBulkCopyGSharedToGlobal.", "keywords": []}, {"id": 651, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_COPY_SHARED_TO_SHARED Bulk copy instruction from shared to shared memory. The type of the callback must be SanitizerCallbackBulkCopySharedToShared.", "keywords": []}, {"id": 652, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId53SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBALE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_GLOBAL Bulk reduction instruction from shared to global memory. The type of the callback must be SanitizerCallbackBulkReductionSharedToGlobal.", "keywords": []}, {"id": 653, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId53SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_BULK_REDUCTION_SHARED_TO_SHARED Bulk reduction instruction from shared to shared memory. The type of the callback must be SanitizerCallbackBulkReductionSharedToShared.", "keywords": []}, {"id": 654, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CACHE_CONTROL", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CACHE_CONTROL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_CACHE_CONTROLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CACHE_CONTROL Cache control instruction. The type of the callback must be SanitizerCallbackCacheControl.", "keywords": []}, {"id": 655, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CALL", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CALL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId26SANITIZER_INSTRUCTION_CALLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CALL Function call. The type of the callback must be SanitizerCallbackCall.", "keywords": []}, {"id": 656, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId44SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_ARRIVE Cluster barrier arrive instruction. The type of the callback must be SanitizerCallbackClusterBarrierArrive.", "keywords": []}, {"id": 657, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT Cluster barrier wait instruction. The type of the callback must be SanitizerCallbackClusterBarrierWait.", "keywords": []}, {"id": 658, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId48SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRYE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CLUSTER_BARRIER_WAIT_ENTRY Entering cluster barrier wait instruction. The type of the callback must be SanitizerCallbackClusterBarrierWait.", "keywords": []}, {"id": 659, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CUDA_BARRIER", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CUDA_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId34SANITIZER_INSTRUCTION_CUDA_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CUDA_BARRIER CUDA Barrier operation. The type of the callback must be SanitizerCallbackCudaBarrier.", "keywords": []}, {"id": 660, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPTE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_CUDA_BARRIER_ATTEMPT CUDA Barrier operation (potentially unsuccessful). The type of the callback must be SanitizerCallbackCudaBarrierAttempt.", "keywords": []}, {"id": 661, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId43SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_ALIGNED_MALLOC Device-side aligned malloc. The type of the callback must be SanitizerCallbackDeviceSideMalloc.", "keywords": []}, {"id": 662, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId38SANITIZER_INSTRUCTION_DEVICE_SIDE_FREEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_SIDE_FREE Device-side free. The type of the callback must be SanitizerCallbackDeviceSideFree.", "keywords": []}, {"id": 663, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId40SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_DEVICE_SIDE_MALLOC Device-side malloc. The type of the callback must be SanitizerCallbackDeviceSideMalloc.", "keywords": []}, {"id": 664, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_FORCE_INT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId31SANITIZER_INSTRUCTION_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_FORCE_INT", "keywords": []}, {"id": 665, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_GLOBAL_MEMORY_ACCESS Global Memory Access. This can be a store, load or atomic operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 666, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_INVALID", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId29SANITIZER_INSTRUCTION_INVALIDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_INVALID Invalid instruction ID.", "keywords": []}, {"id": 667, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_LOCAL_MEMORY_ACCESS Local Memory Access. This can be a store or load operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 668, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MATRIX_MEMORY_ACCESS Matrix shared memory access. The type of the callback must be SanitizerCallbackMatrixMemoryAccess.", "keywords": []}, {"id": 669, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMCPY_ASYNC", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMCPY_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId34SANITIZER_INSTRUCTION_MEMCPY_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMCPY_ASYNC Global to shared memory asynchronous copy. The type of the callback must be SanitizerCallbackMemcpyAsync.", "keywords": []}, {"id": 670, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMCPY_ASYNC_BARRIER Usage of a Cuda Barrier for memcpy async completion. The type of the callback must be SanitizerCallbackMemcpyAsyncBarrier.", "keywords": []}, {"id": 671, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMSET_SHARED", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_MEMSET_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_MEMSET_SHAREDE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_MEMSET_SHARED Bulk copy instruction from global to shared memory. The type of the callback must be SanitizerCallbackMemsetShared.", "keywords": []}, {"id": 672, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_PIPELINE_COMMIT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_PIPELINE_COMMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_PIPELINE_COMMITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_PIPELINE_COMMIT Pipeline commit. The type of the callback must be SanitizerCallbackPipelineCommit.", "keywords": []}, {"id": 673, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_PIPELINE_WAIT", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_PIPELINE_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId35SANITIZER_INSTRUCTION_PIPELINE_WAITE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_PIPELINE_WAIT Pipeline wait. The type of the callback must be SanitizerCallbackPipelineWait.", "keywords": []}, {"id": 674, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId49SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_REMOTE_SHARED_MEMORY_ACCESS Remote Shared Memory Access. This can be a store or load operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 675, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_RET", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_RET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId25SANITIZER_INSTRUCTION_RETE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_RET Function return. The type of the callback must be SanitizerCallbackRet.", "keywords": []}, {"id": 676, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId44SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SET_SHARED_MEMORY_SIZE Set the shared memory size allocated to a block instruction. The type of the callback must be SanitizerCallbackSetSmemSize.", "keywords": []}, {"id": 677, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESSE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SHARED_MEMORY_ACCESS Shared Memory Access. This can be a store, load or atomic operation. The type of the callback must be SanitizerCallbackMemoryAccess.", "keywords": []}, {"id": 678, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SHFL", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SHFL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId26SANITIZER_INSTRUCTION_SHFLE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SHFL Shfl. The type of the callback must be SanitizerCallbackShfl.", "keywords": []}, {"id": 679, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SYNCWARP", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SYNCWARP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId30SANITIZER_INSTRUCTION_SYNCWARPE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SYNCWARP Syncwarp. The type of the callback must be SanitizerCallbackSyncwarp.", "keywords": []}, {"id": 680, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SYNCWARP_RELEASE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_SYNCWARP_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId38SANITIZER_INSTRUCTION_SYNCWARP_RELEASEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_SYNCWARP_RELEASE Syncwarp after it is released. The type of the callback must be SanitizerCallbackSyncwarp.", "keywords": []}, {"id": 681, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIERE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_TENSOR_CORE_BARRIER Tensor Core barrier. The type of the callback must be SanitizerCallbackTensorCoreBarrier.", "keywords": []}, {"id": 682, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_FENCE", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_FENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId37SANITIZER_INSTRUCTION_WARPGROUP_FENCEE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_FENCE Warpgroup fence instruction. The type of the callback must be SanitizerCallbackWarpgroupFence.", "keywords": []}, {"id": 683, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId41SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNCE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_MMA_ASYNC Warpgroup aligned async MMA instruction. The type of the callback must be SanitizerCallbackWarpgroupMMAAsync.", "keywords": []}, {"id": 684, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP", "display_name": "Sanitizer_InstructionId::SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N23Sanitizer_InstructionId42SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUPE", "priority": 1, "content": "enumerator  SANITIZER_INSTRUCTION_WARPGROUP_WAIT_GROUP Warpgroup wait MMA group instruction. The type of the callback must be SanitizerCallbackWarpgroupWaitGroup.", "keywords": []}, {"id": 685, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_LaunchHandle", "display_name": "Sanitizer_LaunchHandle", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv422Sanitizer_LaunchHandle", "priority": 1, "content": "typedef  struct  Sanitizer_Launch_st  * Sanitizer_LaunchHandle", "keywords": []}, {"id": 686, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_WarpgroupMMAAsyncFlags", "display_name": "Sanitizer_WarpgroupMMAAsyncFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv432Sanitizer_WarpgroupMMAAsyncFlags", "priority": 1, "content": "enum  Sanitizer_WarpgroupMMAAsyncFlags Flags describing a warpgroup aligned MMA async. Flags describing a warpgroup aligned MMA async. These values are to be or-combined in the value of flags for a SanitizerCallbackWarpgroupMMAAsync callback. Values:", "keywords": []}, {"id": 687, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP", "display_name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags47SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUPE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_COMMIT_GROUP Specifies that the MMA async delimits a MMA async group of which it is the last instruction. Please refer to the PTX documentation for wgmma_async.commit_group for more details. This property is valid even if the warpMask is zero.", "keywords": []}, {"id": 688, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "display_name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags44SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_FORCE_INT", "keywords": []}, {"id": 689, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE", "display_name": "Sanitizer_WarpgroupMMAAsyncFlags::SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv4N32Sanitizer_WarpgroupMMAAsyncFlags39SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONEE", "priority": 1, "content": "enumerator  SANITIZER_WARPGROUP_MMA_ASYNC_FLAG_NONE Empty flag.", "keywords": []}, {"id": 690, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatches", "display_name": "sanitizerAddPatches", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv419sanitizerAddPatchesPKv9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatches const  void  * image CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(image) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded image, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters image \u2013 Pointer to module data to load. This API supports the same module formats as the cuModuleLoadData and cuModuleLoadFatBinary functions from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if image does not point to a valid CUDA module.", "keywords": []}, {"id": 691, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatches::ctx", "display_name": "sanitizerAddPatches::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv419sanitizerAddPatchesPKv9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatches const  void  * image CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(image) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded image, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters image \u2013 Pointer to module data to load. This API supports the same module formats as the cuModuleLoadData and cuModuleLoadFatBinary functions from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if image does not point to a valid CUDA module.", "keywords": []}, {"id": 692, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatches::image", "display_name": "sanitizerAddPatches::image", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv419sanitizerAddPatchesPKv9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatches const  void  * image CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(image) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded image, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters image \u2013 Pointer to module data to load. This API supports the same module formats as the cuModuleLoadData and cuModuleLoadFatBinary functions from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if image does not point to a valid CUDA module.", "keywords": []}, {"id": 693, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatchesFromFile", "display_name": "sanitizerAddPatchesFromFile", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerAddPatchesFromFilePKc9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatchesFromFile const  char  * filename CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatchesFromFile(filename) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters filename \u2013 Path to the module file. This API supports the same module formats as the cuModuleLoad function from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer SANITIZER_ERROR_INVALID_PARAMETER \u2013 if filename is not a path to a valid CUDA module.", "keywords": []}, {"id": 694, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatchesFromFile::ctx", "display_name": "sanitizerAddPatchesFromFile::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerAddPatchesFromFilePKc9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatchesFromFile const  char  * filename CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatchesFromFile(filename) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters filename \u2013 Path to the module file. This API supports the same module formats as the cuModuleLoad function from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer SANITIZER_ERROR_INVALID_PARAMETER \u2013 if filename is not a path to a valid CUDA module.", "keywords": []}, {"id": 695, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerAddPatchesFromFile::filename", "display_name": "sanitizerAddPatchesFromFile::filename", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerAddPatchesFromFilePKc9CUcontext", "priority": 1, "content": "SanitizerResult  sanitizerAddPatchesFromFile const  char  * filename CUcontext  ctx Load a module containing patches that can be used by the patching API. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatchesFromFile(filename) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. The patches loaded are only valid for the specified CUDA context. Parameters filename \u2013 Path to the module file. This API supports the same module formats as the cuModuleLoad function from the CUDA driver API. ctx \u2013 CUDA context in which to load the patches. If ctx is NULL, the current context will be used. Return values SANITIZER_SUCCESS \u2013 on success SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer SANITIZER_ERROR_INVALID_PARAMETER \u2013 if filename is not a path to a valid CUDA module.", "keywords": []}, {"id": 696, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackPcAndSize", "display_name": "sanitizerGetCallbackPcAndSize", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetCallbackPcAndSize9CUcontextPKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackPcAndSize CUcontext  ctx const  char  * deviceCallbackName uint64_t  * pc uint64_t  * size Get PC and size of a device callback. Parameters ctx \u2013 [in]  CUDA context in which the patches were loaded. If ctx is NULL, the current context will be used. deviceCallbackName \u2013 [in]  device function callback name. pc \u2013 [out]  Callback PC returned. size \u2013 [out]  Callback size returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if deviceCallbackName function cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 697, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackPcAndSize::ctx", "display_name": "sanitizerGetCallbackPcAndSize::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetCallbackPcAndSize9CUcontextPKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackPcAndSize CUcontext  ctx const  char  * deviceCallbackName uint64_t  * pc uint64_t  * size Get PC and size of a device callback. Parameters ctx \u2013 [in]  CUDA context in which the patches were loaded. If ctx is NULL, the current context will be used. deviceCallbackName \u2013 [in]  device function callback name. pc \u2013 [out]  Callback PC returned. size \u2013 [out]  Callback size returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if deviceCallbackName function cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 698, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackPcAndSize::deviceCallbackName", "display_name": "sanitizerGetCallbackPcAndSize::deviceCallbackName", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetCallbackPcAndSize9CUcontextPKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackPcAndSize CUcontext  ctx const  char  * deviceCallbackName uint64_t  * pc uint64_t  * size Get PC and size of a device callback. Parameters ctx \u2013 [in]  CUDA context in which the patches were loaded. If ctx is NULL, the current context will be used. deviceCallbackName \u2013 [in]  device function callback name. pc \u2013 [out]  Callback PC returned. size \u2013 [out]  Callback size returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if deviceCallbackName function cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 699, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackPcAndSize::pc", "display_name": "sanitizerGetCallbackPcAndSize::pc", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetCallbackPcAndSize9CUcontextPKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackPcAndSize CUcontext  ctx const  char  * deviceCallbackName uint64_t  * pc uint64_t  * size Get PC and size of a device callback. Parameters ctx \u2013 [in]  CUDA context in which the patches were loaded. If ctx is NULL, the current context will be used. deviceCallbackName \u2013 [in]  device function callback name. pc \u2013 [out]  Callback PC returned. size \u2013 [out]  Callback size returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if deviceCallbackName function cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 700, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetCallbackPcAndSize::size", "display_name": "sanitizerGetCallbackPcAndSize::size", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetCallbackPcAndSize9CUcontextPKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetCallbackPcAndSize CUcontext  ctx const  char  * deviceCallbackName uint64_t  * pc uint64_t  * size Get PC and size of a device callback. Parameters ctx \u2013 [in]  CUDA context in which the patches were loaded. If ctx is NULL, the current context will be used. deviceCallbackName \u2013 [in]  device function callback name. pc \u2013 [out]  Callback PC returned. size \u2013 [out]  Callback size returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if deviceCallbackName function cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 701, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionLoadedStatus", "display_name": "sanitizerGetFunctionLoadedStatus", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv432sanitizerGetFunctionLoadedStatus10CUfunctionP30Sanitizer_FunctionLoadedStatus", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionLoadedStatus CUfunction  func Sanitizer_FunctionLoadedStatus  * loadingStatus Get the loading status of a function. Requires a driver version &gt;=515. Parameters func \u2013 [in]  CUDA function for which the loading status is queried. loadingStatus \u2013 [out]  Loading status returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if func is NULL or if loadingStatus is NULL. SANITIZER_ERROR_NOT_SUPPORTED \u2013 if the loading status cannot be queried with this driver version.", "keywords": []}, {"id": 702, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionLoadedStatus::func", "display_name": "sanitizerGetFunctionLoadedStatus::func", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv432sanitizerGetFunctionLoadedStatus10CUfunctionP30Sanitizer_FunctionLoadedStatus", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionLoadedStatus CUfunction  func Sanitizer_FunctionLoadedStatus  * loadingStatus Get the loading status of a function. Requires a driver version &gt;=515. Parameters func \u2013 [in]  CUDA function for which the loading status is queried. loadingStatus \u2013 [out]  Loading status returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if func is NULL or if loadingStatus is NULL. SANITIZER_ERROR_NOT_SUPPORTED \u2013 if the loading status cannot be queried with this driver version.", "keywords": []}, {"id": 703, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionLoadedStatus::loadingStatus", "display_name": "sanitizerGetFunctionLoadedStatus::loadingStatus", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv432sanitizerGetFunctionLoadedStatus10CUfunctionP30Sanitizer_FunctionLoadedStatus", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionLoadedStatus CUfunction  func Sanitizer_FunctionLoadedStatus  * loadingStatus Get the loading status of a function. Requires a driver version &gt;=515. Parameters func \u2013 [in]  CUDA function for which the loading status is queried. loadingStatus \u2013 [out]  Loading status returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if func is NULL or if loadingStatus is NULL. SANITIZER_ERROR_NOT_SUPPORTED \u2013 if the loading status cannot be queried with this driver version.", "keywords": []}, {"id": 704, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionPcAndSize", "display_name": "sanitizerGetFunctionPcAndSize", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetFunctionPcAndSize8CUmodulePKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionPcAndSize CUmodule  module const  char  * functionName uint64_t  * pc uint64_t  * size Get PC and size of a CUDA function. Parameters module \u2013 [in]  CUDA module containing the function. deviceCallbackName \u2013 [in]  CUDA function name. pc \u2013 [out]  Function start program counter (PC) returned. size \u2013 [out]  Function size in bytes returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if functionName function. cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 705, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionPcAndSize::functionName", "display_name": "sanitizerGetFunctionPcAndSize::functionName", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetFunctionPcAndSize8CUmodulePKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionPcAndSize CUmodule  module const  char  * functionName uint64_t  * pc uint64_t  * size Get PC and size of a CUDA function. Parameters module \u2013 [in]  CUDA module containing the function. deviceCallbackName \u2013 [in]  CUDA function name. pc \u2013 [out]  Function start program counter (PC) returned. size \u2013 [out]  Function size in bytes returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if functionName function. cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 706, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionPcAndSize::module", "display_name": "sanitizerGetFunctionPcAndSize::module", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetFunctionPcAndSize8CUmodulePKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionPcAndSize CUmodule  module const  char  * functionName uint64_t  * pc uint64_t  * size Get PC and size of a CUDA function. Parameters module \u2013 [in]  CUDA module containing the function. deviceCallbackName \u2013 [in]  CUDA function name. pc \u2013 [out]  Function start program counter (PC) returned. size \u2013 [out]  Function size in bytes returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if functionName function. cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 707, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionPcAndSize::pc", "display_name": "sanitizerGetFunctionPcAndSize::pc", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetFunctionPcAndSize8CUmodulePKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionPcAndSize CUmodule  module const  char  * functionName uint64_t  * pc uint64_t  * size Get PC and size of a CUDA function. Parameters module \u2013 [in]  CUDA module containing the function. deviceCallbackName \u2013 [in]  CUDA function name. pc \u2013 [out]  Function start program counter (PC) returned. size \u2013 [out]  Function size in bytes returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if functionName function. cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 708, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerGetFunctionPcAndSize::size", "display_name": "sanitizerGetFunctionPcAndSize::size", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv429sanitizerGetFunctionPcAndSize8CUmodulePKcP8uint64_tP8uint64_t", "priority": 1, "content": "SanitizerResult  sanitizerGetFunctionPcAndSize CUmodule  module const  char  * functionName uint64_t  * pc uint64_t  * size Get PC and size of a CUDA function. Parameters module \u2013 [in]  CUDA module containing the function. deviceCallbackName \u2013 [in]  CUDA function name. pc \u2013 [out]  Function start program counter (PC) returned. size \u2013 [out]  Function size in bytes returned. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if functionName function. cannot be located, if pc is NULL or if size is NULL.", "keywords": []}, {"id": 709, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchInstructions", "display_name": "sanitizerPatchInstructions", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv426sanitizerPatchInstructionsK23Sanitizer_InstructionId8CUmodulePKc", "priority": 1, "content": "SanitizerResult  sanitizerPatchInstructions const  Sanitizer_InstructionId  instructionId CUmodule  module const  char  * deviceCallbackName Set instrumentation points and patches to be applied in a module. Mark that all instrumentation points matching instructionId are to be patched in order to call the device function identified by deviceCallbackName. It is up to the API client to ensure that this device callback exists and match the correct callback format for this instrumentation point. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(fileName) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. Parameters instructionId \u2013 Instrumentation point for which to insert patches module \u2013 CUDA module to instrument deviceCallbackName \u2013 Name of the device function callback that the inserted patch will call at the instrumented points. This function is expected to be found in code previously loaded by sanitizerAddPatchesFromFile or sanitizerAddPatches. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module or if deviceCallbackName function cannot be located.", "keywords": []}, {"id": 710, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchInstructions::deviceCallbackName", "display_name": "sanitizerPatchInstructions::deviceCallbackName", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv426sanitizerPatchInstructionsK23Sanitizer_InstructionId8CUmodulePKc", "priority": 1, "content": "SanitizerResult  sanitizerPatchInstructions const  Sanitizer_InstructionId  instructionId CUmodule  module const  char  * deviceCallbackName Set instrumentation points and patches to be applied in a module. Mark that all instrumentation points matching instructionId are to be patched in order to call the device function identified by deviceCallbackName. It is up to the API client to ensure that this device callback exists and match the correct callback format for this instrumentation point. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(fileName) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. Parameters instructionId \u2013 Instrumentation point for which to insert patches module \u2013 CUDA module to instrument deviceCallbackName \u2013 Name of the device function callback that the inserted patch will call at the instrumented points. This function is expected to be found in code previously loaded by sanitizerAddPatchesFromFile or sanitizerAddPatches. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module or if deviceCallbackName function cannot be located.", "keywords": []}, {"id": 711, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchInstructions::instructionId", "display_name": "sanitizerPatchInstructions::instructionId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv426sanitizerPatchInstructionsK23Sanitizer_InstructionId8CUmodulePKc", "priority": 1, "content": "SanitizerResult  sanitizerPatchInstructions const  Sanitizer_InstructionId  instructionId CUmodule  module const  char  * deviceCallbackName Set instrumentation points and patches to be applied in a module. Mark that all instrumentation points matching instructionId are to be patched in order to call the device function identified by deviceCallbackName. It is up to the API client to ensure that this device callback exists and match the correct callback format for this instrumentation point. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(fileName) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. Parameters instructionId \u2013 Instrumentation point for which to insert patches module \u2013 CUDA module to instrument deviceCallbackName \u2013 Name of the device function callback that the inserted patch will call at the instrumented points. This function is expected to be found in code previously loaded by sanitizerAddPatchesFromFile or sanitizerAddPatches. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module or if deviceCallbackName function cannot be located.", "keywords": []}, {"id": 712, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchInstructions::module", "display_name": "sanitizerPatchInstructions::module", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv426sanitizerPatchInstructionsK23Sanitizer_InstructionId8CUmodulePKc", "priority": 1, "content": "SanitizerResult  sanitizerPatchInstructions const  Sanitizer_InstructionId  instructionId CUmodule  module const  char  * deviceCallbackName Set instrumentation points and patches to be applied in a module. Mark that all instrumentation points matching instructionId are to be patched in order to call the device function identified by deviceCallbackName. It is up to the API client to ensure that this device callback exists and match the correct callback format for this instrumentation point. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerAddPatches(fileName) and sanitizerPatchInstruction(*, *, cbName) are called concurrently and cbName is intended to be found in the loaded module, the results are undefined. Parameters instructionId \u2013 Instrumentation point for which to insert patches module \u2013 CUDA module to instrument deviceCallbackName \u2013 Name of the device function callback that the inserted patch will call at the instrumented points. This function is expected to be found in code previously loaded by sanitizerAddPatchesFromFile or sanitizerAddPatches. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_NOT_INITIALIZED \u2013 if unable to initialize the sanitizer. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module or if deviceCallbackName function cannot be located.", "keywords": []}, {"id": 713, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchModule", "display_name": "sanitizerPatchModule", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv420sanitizerPatchModule8CUmodule", "priority": 1, "content": "SanitizerResult  sanitizerPatchModule CUmodule  module Perform the actual instrumentation of a module. Perform the instrumentation of a CUDA module based on previous calls to sanitizerPatchInstructions. This function also specifies the device memory buffer to be passed in as userdata to all callback functions. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerPatchModule(mod, *) and sanitizerPatchInstruction(*, mod, *) are called concurrently, the results are undefined. Parameters module \u2013 CUDA module to instrument. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module.", "keywords": []}, {"id": 714, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerPatchModule::module", "display_name": "sanitizerPatchModule::module", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv420sanitizerPatchModule8CUmodule", "priority": 1, "content": "SanitizerResult  sanitizerPatchModule CUmodule  module Perform the actual instrumentation of a module. Perform the instrumentation of a CUDA module based on previous calls to sanitizerPatchInstructions. This function also specifies the device memory buffer to be passed in as userdata to all callback functions. Thread-safety : an API user must serialize access to sanitizerAddPatchesFromFile, sanitizerAddPatches, sanitizerPatchInstructions, and sanitizerPatchModule. For example if sanitizerPatchModule(mod, *) and sanitizerPatchInstruction(*, mod, *) are called concurrently, the results are undefined. Parameters module \u2013 CUDA module to instrument. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if module is not a CUDA module.", "keywords": []}, {"id": 715, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetCallbackData", "display_name": "sanitizerSetCallbackData", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv424sanitizerSetCallbackData10CUfunctionPKv", "priority": 1, "content": "SanitizerResult  sanitizerSetCallbackData CUfunction  kernel const  void  * userdata Specifies the user data pointer for callbacks. Mark all subsequent launches of kernel to use userdata pointer as the device memory buffer to pass in to callback functions. Parameters kernel \u2013 CUDA function to link to user data. Callbacks in subsequent launches on this kernel will use userdata as callback data. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 716, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetCallbackData::kernel", "display_name": "sanitizerSetCallbackData::kernel", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv424sanitizerSetCallbackData10CUfunctionPKv", "priority": 1, "content": "SanitizerResult  sanitizerSetCallbackData CUfunction  kernel const  void  * userdata Specifies the user data pointer for callbacks. Mark all subsequent launches of kernel to use userdata pointer as the device memory buffer to pass in to callback functions. Parameters kernel \u2013 CUDA function to link to user data. Callbacks in subsequent launches on this kernel will use userdata as callback data. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 717, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetCallbackData::userdata", "display_name": "sanitizerSetCallbackData::userdata", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv424sanitizerSetCallbackData10CUfunctionPKv", "priority": 1, "content": "SanitizerResult  sanitizerSetCallbackData CUfunction  kernel const  void  * userdata Specifies the user data pointer for callbacks. Mark all subsequent launches of kernel to use userdata pointer as the device memory buffer to pass in to callback functions. Parameters kernel \u2013 CUDA function to link to user data. Callbacks in subsequent launches on this kernel will use userdata as callback data. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 718, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetDeviceGraphData", "display_name": "sanitizerSetDeviceGraphData", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerSetDeviceGraphData11CUgraphExec22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetDeviceGraphData CUgraphExec  graphExec Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer accessible from callbacks in the device-launched graphs launched by the specified host-launched graphExec. Mark all subsequent launch of graphExec to make available userdata in device callbacks from device-launched graphs. userdata will not be set in the callback userdata parameter but must be accessed through another mean instead. Please refer to the Sanitizer API reference manual. This function is only available if the driver version is 535 or newer. Parameters graphExec \u2013 CUDA graphExec that will launch CUDA graphs from the device. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 719, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetDeviceGraphData::graphExec", "display_name": "sanitizerSetDeviceGraphData::graphExec", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerSetDeviceGraphData11CUgraphExec22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetDeviceGraphData CUgraphExec  graphExec Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer accessible from callbacks in the device-launched graphs launched by the specified host-launched graphExec. Mark all subsequent launch of graphExec to make available userdata in device callbacks from device-launched graphs. userdata will not be set in the callback userdata parameter but must be accessed through another mean instead. Please refer to the Sanitizer API reference manual. This function is only available if the driver version is 535 or newer. Parameters graphExec \u2013 CUDA graphExec that will launch CUDA graphs from the device. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 720, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetDeviceGraphData::stream", "display_name": "sanitizerSetDeviceGraphData::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerSetDeviceGraphData11CUgraphExec22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetDeviceGraphData CUgraphExec  graphExec Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer accessible from callbacks in the device-launched graphs launched by the specified host-launched graphExec. Mark all subsequent launch of graphExec to make available userdata in device callbacks from device-launched graphs. userdata will not be set in the callback userdata parameter but must be accessed through another mean instead. Please refer to the Sanitizer API reference manual. This function is only available if the driver version is 535 or newer. Parameters graphExec \u2013 CUDA graphExec that will launch CUDA graphs from the device. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 721, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetDeviceGraphData::userdata", "display_name": "sanitizerSetDeviceGraphData::userdata", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv427sanitizerSetDeviceGraphData11CUgraphExec22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetDeviceGraphData CUgraphExec  graphExec Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer accessible from callbacks in the device-launched graphs launched by the specified host-launched graphExec. Mark all subsequent launch of graphExec to make available userdata in device callbacks from device-launched graphs. userdata will not be set in the callback userdata parameter but must be accessed through another mean instead. Please refer to the Sanitizer API reference manual. This function is only available if the driver version is 535 or newer. Parameters graphExec \u2013 CUDA graphExec that will launch CUDA graphs from the device. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 722, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetLaunchCallbackData", "display_name": "sanitizerSetLaunchCallbackData", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430sanitizerSetLaunchCallbackData22Sanitizer_LaunchHandle10CUfunction22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetLaunchCallbackData Sanitizer_LaunchHandle  launch CUfunction  kernel Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer for callbacks. Mark launch to use userdata pointer as the device memory buffer to pass in to callback functions. This function is only available if the driver version is 455 or newer. Parameters launch \u2013 Kernel launch to link to user data. Callbacks in this kernel launch will use userdata as callback data. kernel \u2013 CUDA function associated with the kernel launch. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 723, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetLaunchCallbackData::kernel", "display_name": "sanitizerSetLaunchCallbackData::kernel", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430sanitizerSetLaunchCallbackData22Sanitizer_LaunchHandle10CUfunction22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetLaunchCallbackData Sanitizer_LaunchHandle  launch CUfunction  kernel Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer for callbacks. Mark launch to use userdata pointer as the device memory buffer to pass in to callback functions. This function is only available if the driver version is 455 or newer. Parameters launch \u2013 Kernel launch to link to user data. Callbacks in this kernel launch will use userdata as callback data. kernel \u2013 CUDA function associated with the kernel launch. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 724, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetLaunchCallbackData::launch", "display_name": "sanitizerSetLaunchCallbackData::launch", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430sanitizerSetLaunchCallbackData22Sanitizer_LaunchHandle10CUfunction22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetLaunchCallbackData Sanitizer_LaunchHandle  launch CUfunction  kernel Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer for callbacks. Mark launch to use userdata pointer as the device memory buffer to pass in to callback functions. This function is only available if the driver version is 455 or newer. Parameters launch \u2013 Kernel launch to link to user data. Callbacks in this kernel launch will use userdata as callback data. kernel \u2013 CUDA function associated with the kernel launch. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 725, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetLaunchCallbackData::stream", "display_name": "sanitizerSetLaunchCallbackData::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430sanitizerSetLaunchCallbackData22Sanitizer_LaunchHandle10CUfunction22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetLaunchCallbackData Sanitizer_LaunchHandle  launch CUfunction  kernel Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer for callbacks. Mark launch to use userdata pointer as the device memory buffer to pass in to callback functions. This function is only available if the driver version is 455 or newer. Parameters launch \u2013 Kernel launch to link to user data. Callbacks in this kernel launch will use userdata as callback data. kernel \u2013 CUDA function associated with the kernel launch. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 726, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerSetLaunchCallbackData::userdata", "display_name": "sanitizerSetLaunchCallbackData::userdata", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv430sanitizerSetLaunchCallbackData22Sanitizer_LaunchHandle10CUfunction22Sanitizer_StreamHandlePKv", "priority": 1, "content": "SanitizerResult  sanitizerSetLaunchCallbackData Sanitizer_LaunchHandle  launch CUfunction  kernel Sanitizer_StreamHandle  stream const  void  * userdata Specifies the user data pointer for callbacks. Mark launch to use userdata pointer as the device memory buffer to pass in to callback functions. This function is only available if the driver version is 455 or newer. Parameters launch \u2013 Kernel launch to link to user data. Callbacks in this kernel launch will use userdata as callback data. kernel \u2013 CUDA function associated with the kernel launch. stream \u2013 CUDA stream associated with the stream launch. userdata \u2013 Device memory buffer. This data will be passed to callback functions via the userdata parameter. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 727, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerUnpatchModule", "display_name": "sanitizerUnpatchModule", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv422sanitizerUnpatchModule8CUmodule", "priority": 1, "content": "SanitizerResult  sanitizerUnpatchModule CUmodule  module Remove existing instrumentation of a module. Remove any instrumentation of a CUDA module performed by previous calls to sanitizerPatchModule. Thread-safety : an API user must serialize access to sanitizerPatchModule and sanitizerUnpatchModule on the same module. For example, if sanitizerPatchModule(mod) and sanitizerUnpatchModule(mod) are called concurrently, the results are undefined. Parameters module \u2013 CUDA module on which to remove instrumentation. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 728, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "cpp", "name": "sanitizerUnpatchModule::module", "display_name": "sanitizerUnpatchModule::module", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "_CPPv422sanitizerUnpatchModule8CUmodule", "priority": 1, "content": "SanitizerResult  sanitizerUnpatchModule CUmodule  module Remove existing instrumentation of a module. Remove any instrumentation of a CUDA module performed by previous calls to sanitizerPatchModule. Thread-safety : an API user must serialize access to sanitizerPatchModule and sanitizerUnpatchModule on the same module. For example, if sanitizerPatchModule(mod) and sanitizerUnpatchModule(mod) are called concurrently, the results are undefined. Parameters module \u2013 CUDA module on which to remove instrumentation. Return values SANITIZER_SUCCESS \u2013 on success.", "keywords": []}, {"id": 729, "doc_id": 729, "filename": "api/group__SANITIZER__PATCHING__API.html", "domain_name": "std", "name": "api/group__SANITIZER__PATCHING__API", "display_name": "Sanitizer Patching API", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__PATCHING__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the Sanitizer Patching API. Enumerations SanitizerPatchResult  Sanitizer patch result codes. Sanitizer_BarrierFlags  Flags describing a barrier. Sanitizer_CacheControlInstructionKind  Cache control action. Sanitizer_CallFlags  Flags describing a function call. Sanitizer_CudaBarrierInstructionKind  CUDA Barrier action kind. Sanitizer_DeviceMemoryFlags  Flags describing a memory access. Sanitizer_FunctionLoadedStatus   Sanitizer_InstructionId  Instrumentation. Sanitizer_WarpgroupMMAAsyncFlags  Flags describing a warpgroup aligned MMA async. Functions SanitizerResult  sanitizerAddPatches (const void *image, CUcontext ctx) Load a module containing patches that can be used by the patching API. SanitizerResult  sanitizerAddPatchesFromFile (const char *filename, CUcontext ctx) Load a module containing patches that can be used by the patching API. SanitizerResult  sanitizerGetCallbackPcAndSize (CUcontext ctx, const char *deviceCallbackName, uint64_t *pc, uint64_t *size) Get PC and size of a device callback. SanitizerResult  sanitizerGetFunctionLoadedStatus (CUfunction func, Sanitizer_FunctionLoadedStatus *loadingStatus) Get the loading status of a function. SanitizerResult  sanitizerGetFunctionPcAndSize (CUmodule module, const char *functionName, uint64_t *pc, uint64_t *size) Get PC and size of a CUDA function. SanitizerResult  sanitizerPatchInstructions (const Sanitizer_InstructionId instructionId, CUmodule module, const char *deviceCallbackName) Set instrumentation points and patches to be applied in a module. SanitizerResult  sanitizerPatchModule (CUmodule module) Perform the actual instrumentation of a module. SanitizerResult  sanitizerSetCallbackData (CUfunction kernel, const void *userdata) Specifies the user data pointer for callbacks. SanitizerResult  sanitizerSetDeviceGraphData (CUgraphExec graphExec, Sanitizer_StreamHandle stream, const void *userdata) Specifies the user data pointer accessible from callbacks in the device-launched graphs launched by the specified host-launched graphExec. SanitizerResult  sanitizerSetLaunchCallbackData (Sanitizer_LaunchHandle launch, CUfunction kernel, Sanitizer_StreamHandle stream, const void *userdata) Specifies the user data pointer for callbacks. SanitizerResult  sanitizerUnpatchModule (CUmodule module) Remove existing instrumentation of a module. Typedefs SanitizerCallbackAsyncReduction  Function type for an asynchronous reduction operation on shared memory. SanitizerCallbackAsyncStore  Function type for an asynchronous store operation on shared memory. SanitizerCallbackBarrier  Function type for a barrier callback. SanitizerCallbackBlockEnter  Function type for a CUDA block enter callback. SanitizerCallbackBlockExit  Function type for a CUDA block exit callback. SanitizerCallbackBulkCopyGlobalToShared  Function type for a async bulk copy from global to shared memory. SanitizerCallbackBulkCopySharedToGlobal  Function type for a async bulk copy from shared to global memory. SanitizerCallbackBulkCopySharedToShared  Function type for a async bulk copy from shared to shered memory. SanitizerCallbackBulkReductionSharedToGlobal  Function type for a async bulk reduction from shared to global memory. SanitizerCallbackBulkReductionSharedToShared  Function type for a async bulk reduction from shared to shered memory. SanitizerCallbackCacheControl  Function type for a cache control instruction callback. SanitizerCallbackCall  Function type for a function call callback. SanitizerCallbackClusterBarrierArrive  Function type for a cluster barrier arrive. SanitizerCallbackClusterBarrierWait  Function type for a cluster barrier wait. SanitizerCallbackCudaBarrier  Function type for a CUDA Barrier action callback. SanitizerCallbackCudaBarrierAttempt  Function type for a CUDA Barrier action callback. SanitizerCallbackDeviceSideFree  Function type for a device-side free call. SanitizerCallbackDeviceSideMalloc  Function type for a device-side malloc call. SanitizerCallbackMatrixMemoryAccess  Function type for a matrix shared memory access callback. SanitizerCallbackMemcpyAsync  Function type for a global to shared memory asynchronous copy. SanitizerCallbackMemcpyAsyncBarrier  Function type for a cuda barrier used for mbarrier completion. SanitizerCallbackMemoryAccess  Function type for a memory access callback. SanitizerCallbackMemsetShared  Function type for a memset on shared memory. SanitizerCallbackPipelineCommit  Function type for a pipeline commit. SanitizerCallbackPipelineWait  Function type for a pipeline wait. SanitizerCallbackRet  Function type for a function return callback. SanitizerCallbackSetSmemSize  Function type for setting the shared memory size allocated to a block. SanitizerCallbackShfl  Function type for a shfl callback. SanitizerCallbackSyncwarp  Function type for a syncwarp callback. SanitizerCallbackTensorCoreBarrier  Function type for a Blackwell tensor core barrier. SanitizerCallbackWarpgroupFence  Function type for a warpgroup MMA fence. SanitizerCallbackWarpgroupMMAAsync  Function type for a warpgroup aligned async MMA. SanitizerCallbackWarpgroupWaitGroup  Function type for a warpgroup MMA wait group. Sanitizer_LaunchHandle", "keywords": []}, {"id": 730, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY", "display_name": "SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult44SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY The attempted device operation has a parameter not in device memory.", "keywords": []}, {"id": 731, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_API_NOT_IMPLEMENTED", "display_name": "SANITIZER_ERROR_API_NOT_IMPLEMENTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult35SANITIZER_ERROR_API_NOT_IMPLEMENTEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_API_NOT_IMPLEMENTED API is not implemented.", "keywords": []}, {"id": 732, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_FORCE_INT", "display_name": "SANITIZER_ERROR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult25SANITIZER_ERROR_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_FORCE_INT", "keywords": []}, {"id": 733, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_CALLBACK_ID", "display_name": "SANITIZER_ERROR_INVALID_CALLBACK_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult35SANITIZER_ERROR_INVALID_CALLBACK_IDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_CALLBACK_ID The callback ID is invalid.", "keywords": []}, {"id": 734, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_CONTEXT", "display_name": "SANITIZER_ERROR_INVALID_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult31SANITIZER_ERROR_INVALID_CONTEXTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_CONTEXT The context is NULL or not valid.", "keywords": []}, {"id": 735, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_DEVICE", "display_name": "SANITIZER_ERROR_INVALID_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult30SANITIZER_ERROR_INVALID_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_DEVICE The device does not correspond to a valid CUDA device.", "keywords": []}, {"id": 736, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_DOMAIN_ID", "display_name": "SANITIZER_ERROR_INVALID_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_DOMAIN_IDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_DOMAIN_ID The domain ID is invalid.", "keywords": []}, {"id": 737, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_OPERATION", "display_name": "SANITIZER_ERROR_INVALID_OPERATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_OPERATIONE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_OPERATION The current operation cannot be performed due to dependency on other factors.", "keywords": []}, {"id": 738, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_INVALID_PARAMETER", "display_name": "SANITIZER_ERROR_INVALID_PARAMETER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_PARAMETERE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_PARAMETER One or more of the parameters is invalid.", "keywords": []}, {"id": 739, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_MAX_LIMIT_REACHED", "display_name": "SANITIZER_ERROR_MAX_LIMIT_REACHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_MAX_LIMIT_REACHEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_MAX_LIMIT_REACHED The maximum limit is reached.", "keywords": []}, {"id": 740, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_NOT_COMPATIBLE", "display_name": "SANITIZER_ERROR_NOT_COMPATIBLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult30SANITIZER_ERROR_NOT_COMPATIBLEE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_COMPATIBLE The current operation is not compatible with the current state of the object.", "keywords": []}, {"id": 741, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_NOT_INITIALIZED", "display_name": "SANITIZER_ERROR_NOT_INITIALIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult31SANITIZER_ERROR_NOT_INITIALIZEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_INITIALIZED Sanitizer is unable to initialize its connection to the CUDA driver.", "keywords": []}, {"id": 742, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_NOT_READY", "display_name": "SANITIZER_ERROR_NOT_READY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult25SANITIZER_ERROR_NOT_READYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_READY The object is not ready to perform the requested operation.", "keywords": []}, {"id": 743, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_NOT_SUPPORTED", "display_name": "SANITIZER_ERROR_NOT_SUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult29SANITIZER_ERROR_NOT_SUPPORTEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_SUPPORTED The attempted operation is not supported on the current system or device.", "keywords": []}, {"id": 744, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_OUT_OF_MEMORY", "display_name": "SANITIZER_ERROR_OUT_OF_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult29SANITIZER_ERROR_OUT_OF_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_OUT_OF_MEMORY Unable to allocate enough memory to perform the requested operation.", "keywords": []}, {"id": 745, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT", "display_name": "SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult45SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT The output buffer size is not sufficient to return all requested data.", "keywords": []}, {"id": 746, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_ERROR_UNKNOWN", "display_name": "SANITIZER_ERROR_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult23SANITIZER_ERROR_UNKNOWNE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_UNKNOWN An unknown internal error has occurred.", "keywords": []}, {"id": 747, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SANITIZER_SUCCESS", "display_name": "SANITIZER_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult17SANITIZER_SUCCESSE", "priority": 1, "content": "enumerator  SANITIZER_SUCCESS No error.", "keywords": []}, {"id": 748, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult", "display_name": "SanitizerResult", "type": "enum", "display_type": "C++ enum", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv415SanitizerResult", "priority": 1, "content": "enum  SanitizerResult Sanitizer result codes. Error and result codes returned by Sanitizer functions. Values:", "keywords": []}, {"id": 749, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY", "display_name": "SanitizerResult::SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult44SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_ADDRESS_NOT_IN_DEVICE_MEMORY The attempted device operation has a parameter not in device memory.", "keywords": []}, {"id": 750, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_API_NOT_IMPLEMENTED", "display_name": "SanitizerResult::SANITIZER_ERROR_API_NOT_IMPLEMENTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult35SANITIZER_ERROR_API_NOT_IMPLEMENTEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_API_NOT_IMPLEMENTED API is not implemented.", "keywords": []}, {"id": 751, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_FORCE_INT", "display_name": "SanitizerResult::SANITIZER_ERROR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult25SANITIZER_ERROR_FORCE_INTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_FORCE_INT", "keywords": []}, {"id": 752, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_CALLBACK_ID", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_CALLBACK_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult35SANITIZER_ERROR_INVALID_CALLBACK_IDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_CALLBACK_ID The callback ID is invalid.", "keywords": []}, {"id": 753, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_CONTEXT", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult31SANITIZER_ERROR_INVALID_CONTEXTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_CONTEXT The context is NULL or not valid.", "keywords": []}, {"id": 754, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_DEVICE", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult30SANITIZER_ERROR_INVALID_DEVICEE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_DEVICE The device does not correspond to a valid CUDA device.", "keywords": []}, {"id": 755, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_DOMAIN_ID", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_DOMAIN_IDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_DOMAIN_ID The domain ID is invalid.", "keywords": []}, {"id": 756, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_OPERATION", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_OPERATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_OPERATIONE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_OPERATION The current operation cannot be performed due to dependency on other factors.", "keywords": []}, {"id": 757, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_INVALID_PARAMETER", "display_name": "SanitizerResult::SANITIZER_ERROR_INVALID_PARAMETER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_INVALID_PARAMETERE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_INVALID_PARAMETER One or more of the parameters is invalid.", "keywords": []}, {"id": 758, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_MAX_LIMIT_REACHED", "display_name": "SanitizerResult::SANITIZER_ERROR_MAX_LIMIT_REACHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult33SANITIZER_ERROR_MAX_LIMIT_REACHEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_MAX_LIMIT_REACHED The maximum limit is reached.", "keywords": []}, {"id": 759, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_NOT_COMPATIBLE", "display_name": "SanitizerResult::SANITIZER_ERROR_NOT_COMPATIBLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult30SANITIZER_ERROR_NOT_COMPATIBLEE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_COMPATIBLE The current operation is not compatible with the current state of the object.", "keywords": []}, {"id": 760, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_NOT_INITIALIZED", "display_name": "SanitizerResult::SANITIZER_ERROR_NOT_INITIALIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult31SANITIZER_ERROR_NOT_INITIALIZEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_INITIALIZED Sanitizer is unable to initialize its connection to the CUDA driver.", "keywords": []}, {"id": 761, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_NOT_READY", "display_name": "SanitizerResult::SANITIZER_ERROR_NOT_READY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult25SANITIZER_ERROR_NOT_READYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_READY The object is not ready to perform the requested operation.", "keywords": []}, {"id": 762, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_NOT_SUPPORTED", "display_name": "SanitizerResult::SANITIZER_ERROR_NOT_SUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult29SANITIZER_ERROR_NOT_SUPPORTEDE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_NOT_SUPPORTED The attempted operation is not supported on the current system or device.", "keywords": []}, {"id": 763, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_OUT_OF_MEMORY", "display_name": "SanitizerResult::SANITIZER_ERROR_OUT_OF_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult29SANITIZER_ERROR_OUT_OF_MEMORYE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_OUT_OF_MEMORY Unable to allocate enough memory to perform the requested operation.", "keywords": []}, {"id": 764, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT", "display_name": "SanitizerResult::SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult45SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENTE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT The output buffer size is not sufficient to return all requested data.", "keywords": []}, {"id": 765, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_ERROR_UNKNOWN", "display_name": "SanitizerResult::SANITIZER_ERROR_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult23SANITIZER_ERROR_UNKNOWNE", "priority": 1, "content": "enumerator  SANITIZER_ERROR_UNKNOWN An unknown internal error has occurred.", "keywords": []}, {"id": 766, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "SanitizerResult::SANITIZER_SUCCESS", "display_name": "SanitizerResult::SANITIZER_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv4N15SanitizerResult17SANITIZER_SUCCESSE", "priority": 1, "content": "enumerator  SANITIZER_SUCCESS No error.", "keywords": []}, {"id": 767, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "sanitizerGetResultString", "display_name": "sanitizerGetResultString", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv424sanitizerGetResultString15SanitizerResultPPKc", "priority": 1, "content": "SanitizerResult  sanitizerGetResultString SanitizerResult  result const  char  * * str Get the descriptive string for a SanitizerResult. Return the descriptive string for a SanitizerResult in *str . Thread-safety : this function is thread-safe. Parameters result \u2013 The result to get the string for. str \u2013 Returns the string. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if str is NULL or result is not a valid SanitizerResult.", "keywords": []}, {"id": 768, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "sanitizerGetResultString::result", "display_name": "sanitizerGetResultString::result", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv424sanitizerGetResultString15SanitizerResultPPKc", "priority": 1, "content": "SanitizerResult  sanitizerGetResultString SanitizerResult  result const  char  * * str Get the descriptive string for a SanitizerResult. Return the descriptive string for a SanitizerResult in *str . Thread-safety : this function is thread-safe. Parameters result \u2013 The result to get the string for. str \u2013 Returns the string. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if str is NULL or result is not a valid SanitizerResult.", "keywords": []}, {"id": 769, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "cpp", "name": "sanitizerGetResultString::str", "display_name": "sanitizerGetResultString::str", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "_CPPv424sanitizerGetResultString15SanitizerResultPPKc", "priority": 1, "content": "SanitizerResult  sanitizerGetResultString SanitizerResult  result const  char  * * str Get the descriptive string for a SanitizerResult. Return the descriptive string for a SanitizerResult in *str . Thread-safety : this function is thread-safe. Parameters result \u2013 The result to get the string for. str \u2013 Returns the string. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if str is NULL or result is not a valid SanitizerResult.", "keywords": []}, {"id": 770, "doc_id": 770, "filename": "api/group__SANITIZER__RESULT__API.html", "domain_name": "std", "name": "api/group__SANITIZER__RESULT__API", "display_name": "Sanitizer Result Codes", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__RESULT__API", "anchor": "", "priority": -1, "content": "Error and result codes returned by Sanitizer functions. Enumerations SanitizerResult  Sanitizer result codes. Functions SanitizerResult  sanitizerGetResultString (SanitizerResult result, const char **str) Get the descriptive string for a SanitizerResult.", "keywords": []}, {"id": 771, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "Sanitizer_StreamHandle", "display_name": "Sanitizer_StreamHandle", "type": "type", "display_type": "C++ type", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv422Sanitizer_StreamHandle", "priority": 1, "content": "typedef  struct  Sanitizer_Stream_st  * Sanitizer_StreamHandle", "keywords": []}, {"id": 772, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStream", "display_name": "sanitizerGetStream", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv418sanitizerGetStream22Sanitizer_StreamHandleP8CUstream", "priority": 1, "content": "SanitizerResult  sanitizerGetStream Sanitizer_StreamHandle  hStream CUstream  * stream Retrieve a CUstream handle from a Sanitizer_StreamHandle handle. Thread-safety : this function is thread safe. Parameters hStream \u2013 [in]  Sanitizer Stream handle. stream \u2013 [out]  Output CUstream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if hStream is not a valid Sanitizer stream handle or if stream is NULL.", "keywords": []}, {"id": 773, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStream::hStream", "display_name": "sanitizerGetStream::hStream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv418sanitizerGetStream22Sanitizer_StreamHandleP8CUstream", "priority": 1, "content": "SanitizerResult  sanitizerGetStream Sanitizer_StreamHandle  hStream CUstream  * stream Retrieve a CUstream handle from a Sanitizer_StreamHandle handle. Thread-safety : this function is thread safe. Parameters hStream \u2013 [in]  Sanitizer Stream handle. stream \u2013 [out]  Output CUstream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if hStream is not a valid Sanitizer stream handle or if stream is NULL.", "keywords": []}, {"id": 774, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStream::stream", "display_name": "sanitizerGetStream::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv418sanitizerGetStream22Sanitizer_StreamHandleP8CUstream", "priority": 1, "content": "SanitizerResult  sanitizerGetStream Sanitizer_StreamHandle  hStream CUstream  * stream Retrieve a CUstream handle from a Sanitizer_StreamHandle handle. Thread-safety : this function is thread safe. Parameters hStream \u2013 [in]  Sanitizer Stream handle. stream \u2013 [out]  Output CUstream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if hStream is not a valid Sanitizer stream handle or if stream is NULL.", "keywords": []}, {"id": 775, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStreamHandle", "display_name": "sanitizerGetStreamHandle", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv424sanitizerGetStreamHandle9CUcontext8CUstreamP22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerGetStreamHandle CUcontext  ctx CUstream  stream Sanitizer_StreamHandle  * hStream Retrieve a Sanitizer_StreamHandle handle from a CUstream handle. Thread-safety : this function is thread safe. Parameters ctx \u2013 [in]  Context owning the stream. If NULL, the current context will be used. stream \u2013 [in]  CUstream handle. If NULL, the NULL stream will be used. hStream \u2013 [out]  Output Sanitizer Stream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if stream is not a valid CUstream handle or if hStream is NULL.", "keywords": []}, {"id": 776, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStreamHandle::ctx", "display_name": "sanitizerGetStreamHandle::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv424sanitizerGetStreamHandle9CUcontext8CUstreamP22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerGetStreamHandle CUcontext  ctx CUstream  stream Sanitizer_StreamHandle  * hStream Retrieve a Sanitizer_StreamHandle handle from a CUstream handle. Thread-safety : this function is thread safe. Parameters ctx \u2013 [in]  Context owning the stream. If NULL, the current context will be used. stream \u2013 [in]  CUstream handle. If NULL, the NULL stream will be used. hStream \u2013 [out]  Output Sanitizer Stream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if stream is not a valid CUstream handle or if hStream is NULL.", "keywords": []}, {"id": 777, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStreamHandle::hStream", "display_name": "sanitizerGetStreamHandle::hStream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv424sanitizerGetStreamHandle9CUcontext8CUstreamP22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerGetStreamHandle CUcontext  ctx CUstream  stream Sanitizer_StreamHandle  * hStream Retrieve a Sanitizer_StreamHandle handle from a CUstream handle. Thread-safety : this function is thread safe. Parameters ctx \u2013 [in]  Context owning the stream. If NULL, the current context will be used. stream \u2013 [in]  CUstream handle. If NULL, the NULL stream will be used. hStream \u2013 [out]  Output Sanitizer Stream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if stream is not a valid CUstream handle or if hStream is NULL.", "keywords": []}, {"id": 778, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerGetStreamHandle::stream", "display_name": "sanitizerGetStreamHandle::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv424sanitizerGetStreamHandle9CUcontext8CUstreamP22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerGetStreamHandle CUcontext  ctx CUstream  stream Sanitizer_StreamHandle  * hStream Retrieve a Sanitizer_StreamHandle handle from a CUstream handle. Thread-safety : this function is thread safe. Parameters ctx \u2013 [in]  Context owning the stream. If NULL, the current context will be used. stream \u2013 [in]  CUstream handle. If NULL, the NULL stream will be used. hStream \u2013 [out]  Output Sanitizer Stream handle. Return values SANITIZER_SUCCESS \u2013 on success. SANITIZER_ERROR_INVALID_PARAMETER \u2013 if stream is not a valid CUstream handle or if hStream is NULL.", "keywords": []}, {"id": 779, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerStreamSynchronize", "display_name": "sanitizerStreamSynchronize", "type": "function", "display_type": "C++ function", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv426sanitizerStreamSynchronize22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerStreamSynchronize Sanitizer_StreamHandle  stream Synchronize a given stream. Equivalent of cudaStreamSynchronize that can be called with a sanitizer stream handle Thread-safety : this function is thread safe. Parameters stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 780, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "cpp", "name": "sanitizerStreamSynchronize::stream", "display_name": "sanitizerStreamSynchronize::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "_CPPv426sanitizerStreamSynchronize22Sanitizer_StreamHandle", "priority": 1, "content": "SanitizerResult  sanitizerStreamSynchronize Sanitizer_StreamHandle  stream Synchronize a given stream. Equivalent of cudaStreamSynchronize that can be called with a sanitizer stream handle Thread-safety : this function is thread safe. Parameters stream \u2013 Stream handle. If NULL, the NULL stream will be used.", "keywords": []}, {"id": 781, "doc_id": 781, "filename": "api/group__SANITIZER__STREAM__API.html", "domain_name": "std", "name": "api/group__SANITIZER__STREAM__API", "display_name": "Sanitizer Stream API", "type": "doc", "display_type": "Page", "docname": "api/group__SANITIZER__STREAM__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the Sanitizer Stream API. Functions SanitizerResult  sanitizerGetStream (Sanitizer_StreamHandle hStream, CUstream *stream) Retrieve a CUstream handle from a Sanitizer_StreamHandle handle. SanitizerResult  sanitizerGetStreamHandle (CUcontext ctx, CUstream stream, Sanitizer_StreamHandle *hStream) Retrieve a Sanitizer_StreamHandle handle from a CUstream handle. SanitizerResult  sanitizerStreamSynchronize (Sanitizer_StreamHandle stream) Synchronize a given stream. Typedefs Sanitizer_StreamHandle", "keywords": []}, {"id": 782, "doc_id": 782, "filename": "api/modules.html", "domain_name": "std", "name": "api/modules", "display_name": "Modules", "type": "doc", "display_type": "Page", "docname": "api/modules", "anchor": "", "priority": -1, "content": "Sanitizer Barrier API  Functions, types, and enums that implement the Sanitizer Barrier API. Sanitizer Callback API  Functions, types, and enums that implement the Sanitizer Callback API. Sanitizer Memory API  Functions, types, and enums that implement the Sanitizer Memory API. Sanitizer Patching API  Functions, types, and enums that implement the Sanitizer Patching API. Sanitizer Result Codes  Error and result codes returned by Sanitizer functions. Sanitizer Stream API  Functions, types, and enums that implement the Sanitizer Stream API.", "keywords": []}, {"id": 783, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData", "display_name": "Sanitizer_BatchMemopData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv424Sanitizer_BatchMemopData", "priority": 1, "content": "struct  Sanitizer_BatchMemopData Data passed into a batch memop callback function. Data passed into a batch memop callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_BATCH_MEMOP. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 784, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::address", "display_name": "Sanitizer_BatchMemopData::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData7addressE", "priority": 1, "content": "uint64_t  address The address to be written.", "keywords": []}, {"id": 785, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::context", "display_name": "Sanitizer_BatchMemopData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData7contextE", "priority": 1, "content": "CUcontext  context The context where the allocation is located.", "keywords": []}, {"id": 786, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::hStream", "display_name": "Sanitizer_BatchMemopData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 787, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::stream", "display_name": "Sanitizer_BatchMemopData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData6streamE", "priority": 1, "content": "CUstream  stream The stream where the batch memop is executed.", "keywords": []}, {"id": 788, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::type", "display_name": "Sanitizer_BatchMemopData::type", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData4typeE", "priority": 1, "content": "Sanitizer_BatchMemopType  type Type of batch memory operation.", "keywords": []}, {"id": 789, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "cpp", "name": "Sanitizer_BatchMemopData::value", "display_name": "Sanitizer_BatchMemopData::value", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__BatchMemopData", "anchor": "_CPPv4N24Sanitizer_BatchMemopData5valueE", "priority": 1, "content": "uint64_t  value The value to be written.", "keywords": []}, {"id": 790, "doc_id": 790, "filename": "api/structSanitizer__BatchMemopData.html", "domain_name": "std", "name": "api/structSanitizer__BatchMemopData", "display_name": "Sanitizer_BatchMemopData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__BatchMemopData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 791, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData", "display_name": "Sanitizer_CallbackData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv422Sanitizer_CallbackData", "priority": 1, "content": "struct  Sanitizer_CallbackData Data passed into a runtime or driver API callback function. Data passed into a runtime or driver API callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_DRIVER_API or SANITIZER_CB_DOMAIN_RUNTIME_API. The callback data is valid only within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make of a copy of that data. For example, if you make a shallow copy of Sanitizer_CallbackData within a callback, you cannot dereference functionParams outside of that callback to access the function parameters. functionName is an exception: the string pointed to by functionName is a global constant and so may be accessed outside of the callback. Public Members", "keywords": []}, {"id": 792, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::callbackSite", "display_name": "Sanitizer_CallbackData::callbackSite", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData12callbackSiteE", "priority": 1, "content": "Sanitizer_ApiCallbackSite  callbackSite Point in the runtime or driver function from where the callback was issued.", "keywords": []}, {"id": 793, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::context", "display_name": "Sanitizer_CallbackData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData7contextE", "priority": 1, "content": "CUcontext  context Driver context current to the thread, or null if no context is current. This value can change from the entry to exit callback of a runtime API function if the runtime initialized a context.", "keywords": []}, {"id": 794, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::functionName", "display_name": "Sanitizer_CallbackData::functionName", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData12functionNameE", "priority": 1, "content": "const  char  * functionName Name of the runtime or driver API function which issued the callback. This string is a global constant and so may be accessed outside of the callback.", "keywords": []}, {"id": 795, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::functionParams", "display_name": "Sanitizer_CallbackData::functionParams", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData14functionParamsE", "priority": 1, "content": "const  void  * functionParams Pointer to the arguments passed to the runtime or driver API call. See generated_cuda_runtime_api_meta.h and generated_cuda_meta.h for structure definitions for the parameters for each runtime and driver API function.", "keywords": []}, {"id": 796, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::functionReturnValue", "display_name": "Sanitizer_CallbackData::functionReturnValue", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData19functionReturnValueE", "priority": 1, "content": "const  void  * functionReturnValue Pointer to the return value of the runtime or driver API call. This field is only valid within the SANITIZER_API_EXIT callback. For a runtime API functionReturnValue points to a cudaError_t . For a driver API functionReturnValue points to a CUresult .", "keywords": []}, {"id": 797, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "cpp", "name": "Sanitizer_CallbackData::symbolName", "display_name": "Sanitizer_CallbackData::symbolName", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__CallbackData", "anchor": "_CPPv4N22Sanitizer_CallbackData10symbolNameE", "priority": 1, "content": "const  char  * symbolName Name of the symbol operated on by the runtime or driver API function which issued the callback. This entry is valid only for driver and runtime launch callbacks, where it returns the name of the kernel.", "keywords": []}, {"id": 798, "doc_id": 798, "filename": "api/structSanitizer__CallbackData.html", "domain_name": "std", "name": "api/structSanitizer__CallbackData", "display_name": "Sanitizer_CallbackData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__CallbackData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 799, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "cpp", "name": "Sanitizer_EventData", "display_name": "Sanitizer_EventData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__EventData", "anchor": "_CPPv419Sanitizer_EventData", "priority": 1, "content": "struct  Sanitizer_EventData Data passed into an event callback function. Data passed into an event callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal tp SANITIZER_CB_DOMAIN_EVENTS. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 800, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "cpp", "name": "Sanitizer_EventData::context", "display_name": "Sanitizer_EventData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__EventData", "anchor": "_CPPv4N19Sanitizer_EventData7contextE", "priority": 1, "content": "CUcontext  context For SANITIZER_CBID_EVENTS_CREATED, SANITIZER_CBID_EVENTS_DESTROYED, and SANITIZER_CBID_EVENTS_SYNCHNONIZED, this is the context containing the event. For SANITIZER_CBID_EVENTS_RECORD and SANITIZER_CBID_EVENTS_STREAM_WAIT, this is the context containing the stream being recorded or waiting.", "keywords": []}, {"id": 801, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "cpp", "name": "Sanitizer_EventData::event", "display_name": "Sanitizer_EventData::event", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__EventData", "anchor": "_CPPv4N19Sanitizer_EventData5eventE", "priority": 1, "content": "CUevent  event The event recording or being waited.", "keywords": []}, {"id": 802, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "cpp", "name": "Sanitizer_EventData::hStream", "display_name": "Sanitizer_EventData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__EventData", "anchor": "_CPPv4N19Sanitizer_EventData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 803, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "cpp", "name": "Sanitizer_EventData::stream", "display_name": "Sanitizer_EventData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__EventData", "anchor": "_CPPv4N19Sanitizer_EventData6streamE", "priority": 1, "content": "CUstream  stream The stream being recorded or waiting. Available if cbid is SANITIZER_CBID_EVENTS_RECORD or SANITIZER_CBID_EVENTS_STREAM_WAIT.", "keywords": []}, {"id": 804, "doc_id": 804, "filename": "api/structSanitizer__EventData.html", "domain_name": "std", "name": "api/structSanitizer__EventData", "display_name": "Sanitizer_EventData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__EventData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 805, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData", "display_name": "Sanitizer_ExternalMemoryData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv428Sanitizer_ExternalMemoryData", "priority": 1, "content": "struct  Sanitizer_ExternalMemoryData Data passed into an external memory callback function. Data passed into an event callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal tp SANITIZER_CB_DOMAIN_EXTERNAL_MEMORY. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 806, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData::address", "display_name": "Sanitizer_ExternalMemoryData::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv4N28Sanitizer_ExternalMemoryData7addressE", "priority": 1, "content": "uint64_t  address Address of the mapped memory. This field is only valid for SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED.", "keywords": []}, {"id": 807, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData::context", "display_name": "Sanitizer_ExternalMemoryData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv4N28Sanitizer_ExternalMemoryData7contextE", "priority": 1, "content": "CUcontext  context Context containing the external memory.", "keywords": []}, {"id": 808, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData::device", "display_name": "Sanitizer_ExternalMemoryData::device", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv4N28Sanitizer_ExternalMemoryData6deviceE", "priority": 1, "content": "CUdevice  device Device containing the external memory.", "keywords": []}, {"id": 809, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData::extMemory", "display_name": "Sanitizer_ExternalMemoryData::extMemory", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv4N28Sanitizer_ExternalMemoryData9extMemoryE", "priority": 1, "content": "CUexternalMemory  extMemory External memory object.", "keywords": []}, {"id": 810, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ExternalMemoryData::size", "display_name": "Sanitizer_ExternalMemoryData::size", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "_CPPv4N28Sanitizer_ExternalMemoryData4sizeE", "priority": 1, "content": "uint64_t  size Size of the memory imported or mapped. This field is only valid for SANITIZER_CBID_EXTERNAL_MEMORY_IMPORT and SANITIZER_CBID_EXTERNAL_MEMORY_MAPPED.", "keywords": []}, {"id": 811, "doc_id": 811, "filename": "api/structSanitizer__ExternalMemoryData.html", "domain_name": "std", "name": "api/structSanitizer__ExternalMemoryData", "display_name": "Sanitizer_ExternalMemoryData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ExternalMemoryData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 812, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData", "display_name": "Sanitizer_GraphExecData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv423Sanitizer_GraphExecData", "priority": 1, "content": "struct  Sanitizer_GraphExecData Data passed into a graphexec creation callback function. Data passed into a graphs callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_GRAPHS and cbid equal to SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 813, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData::containsDeviceGraphLaunches", "display_name": "Sanitizer_GraphExecData::containsDeviceGraphLaunches", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv4N23Sanitizer_GraphExecData27containsDeviceGraphLaunchesE", "priority": 1, "content": "uint32_t  containsDeviceGraphLaunches Boolean value indicating if the graphexec may launch device graphs. Only valid in the SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED callback with driver version of 535 or newer.", "keywords": []}, {"id": 814, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData::deviceGraphLaunchesContext", "display_name": "Sanitizer_GraphExecData::deviceGraphLaunchesContext", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv4N23Sanitizer_GraphExecData26deviceGraphLaunchesContextE", "priority": 1, "content": "CUcontext  deviceGraphLaunchesContext Context where the graphexec can launch device graphs. NULL if the graphExec doesn\u2019t launch device graphs. Only valid in the SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATED callback with driver version of 535 or newer.", "keywords": []}, {"id": 815, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData::graph", "display_name": "Sanitizer_GraphExecData::graph", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv4N23Sanitizer_GraphExecData5graphE", "priority": 1, "content": "CUgraph  graph CUDA graph being instantiated.", "keywords": []}, {"id": 816, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData::graphExec", "display_name": "Sanitizer_GraphExecData::graphExec", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv4N23Sanitizer_GraphExecData9graphExecE", "priority": 1, "content": "CUgraphExec  graphExec Instance of the CUDA graph. Can be NULL for device graph launches in the SANITIZER_CBID_GRAPHS_GRAPHEXEC_CREATING callback.", "keywords": []}, {"id": 817, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "cpp", "name": "Sanitizer_GraphExecData::isDeviceLaunch", "display_name": "Sanitizer_GraphExecData::isDeviceLaunch", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphExecData", "anchor": "_CPPv4N23Sanitizer_GraphExecData14isDeviceLaunchE", "priority": 1, "content": "uint32_t  isDeviceLaunch Boolean value indicating if the graphexec is for a device graph launch.", "keywords": []}, {"id": 818, "doc_id": 818, "filename": "api/structSanitizer__GraphExecData.html", "domain_name": "std", "name": "api/structSanitizer__GraphExecData", "display_name": "Sanitizer_GraphExecData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__GraphExecData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 819, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData", "display_name": "Sanitizer_GraphLaunchData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv425Sanitizer_GraphLaunchData", "priority": 1, "content": "struct  Sanitizer_GraphLaunchData Data passed into a graph launch callback function. Data passed into a graphs callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_GRAPHS and cbid equal to SANITIZER_CBID_GRAPHS_LAUNCH_BEGIN or SANITIZER_CBID_GRAPHS_LAUNCH_END. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 820, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData::context", "display_name": "Sanitizer_GraphLaunchData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv4N25Sanitizer_GraphLaunchData7contextE", "priority": 1, "content": "CUcontext  context The context where the graph is launched.", "keywords": []}, {"id": 821, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData::graphExec", "display_name": "Sanitizer_GraphLaunchData::graphExec", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv4N25Sanitizer_GraphLaunchData9graphExecE", "priority": 1, "content": "CUgraphExec  graphExec Instance of the CUDA graph being launched.", "keywords": []}, {"id": 822, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData::hStream", "display_name": "Sanitizer_GraphLaunchData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv4N25Sanitizer_GraphLaunchData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 823, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData::isGraphUpload", "display_name": "Sanitizer_GraphLaunchData::isGraphUpload", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv4N25Sanitizer_GraphLaunchData13isGraphUploadE", "priority": 1, "content": "uint32_t  isGraphUpload Boolean value indicating if the launch callback is part of a graph upload. This field is only valid if the driver version is 510 or newer.", "keywords": []}, {"id": 824, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphLaunchData::stream", "display_name": "Sanitizer_GraphLaunchData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "_CPPv4N25Sanitizer_GraphLaunchData6streamE", "priority": 1, "content": "CUstream  stream The stream where the graph is launched.", "keywords": []}, {"id": 825, "doc_id": 825, "filename": "api/structSanitizer__GraphLaunchData.html", "domain_name": "std", "name": "api/structSanitizer__GraphLaunchData", "display_name": "Sanitizer_GraphLaunchData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__GraphLaunchData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 826, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData", "display_name": "Sanitizer_GraphNodeLaunchData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv429Sanitizer_GraphNodeLaunchData", "priority": 1, "content": "struct  Sanitizer_GraphNodeLaunchData Data passed into a graph node launch callback function. Data passed into a graphs callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_GRAPHS and cbid equal to SANITIZER_CBID_GRAPHS_LAUNCH_NODE_BEGIN or SANITIZER_CBID_GRAPHS_LAUNCH_NODE_END. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 827, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::@1", "display_name": "Sanitizer_GraphNodeLaunchData::[anonymous]", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchDataUt1_1E", "priority": 1, "content": "union  Sanitizer_GraphNodeLaunchData :: [anonymous]  [anonymous] Data for this node launch.", "keywords": []}, {"id": 828, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::graphExec", "display_name": "Sanitizer_GraphNodeLaunchData::graphExec", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData9graphExecE", "priority": 1, "content": "CUgraphExec  graphExec Instance of the CUDA graph being launched.", "keywords": []}, {"id": 829, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::isGraphUpload", "display_name": "Sanitizer_GraphNodeLaunchData::isGraphUpload", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData13isGraphUploadE", "priority": 1, "content": "uint32_t  isGraphUpload Boolean value indicating if the node launch callback is part of a graph upload.", "keywords": []}, {"id": 830, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::launchData", "display_name": "Sanitizer_GraphNodeLaunchData::launchData", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData10launchDataE", "priority": 1, "content": "Sanitizer_LaunchData  launchData This is only valid if nodeType is CU_GRAPH_NODE_TYPE_KERNEL.", "keywords": []}, {"id": 831, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::launchId", "display_name": "Sanitizer_GraphNodeLaunchData::launchId", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData8launchIdE", "priority": 1, "content": "uint32_t  launchId Launch ID for this CUDA graph instance.", "keywords": []}, {"id": 832, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::memAllocData", "display_name": "Sanitizer_GraphNodeLaunchData::memAllocData", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData12memAllocDataE", "priority": 1, "content": "Sanitizer_ResourceMemoryData  memAllocData This is only valid if nodeType is CU_GRAPH_NODE_TYPE_MEM_ALLOC.", "keywords": []}, {"id": 833, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::memFreeAddress", "display_name": "Sanitizer_GraphNodeLaunchData::memFreeAddress", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData14memFreeAddressE", "priority": 1, "content": "uint64_t  memFreeAddress The freed device pointer This is only valid if nodeType is CU_GRAPH_NODE_TYPE_MEM_FREE.", "keywords": []}, {"id": 834, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::memcpyData", "display_name": "Sanitizer_GraphNodeLaunchData::memcpyData", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData10memcpyDataE", "priority": 1, "content": "Sanitizer_MemcpyData  memcpyData This is only valid if nodeType is CU_GRAPH_NODE_TYPE_MEMCPY.", "keywords": []}, {"id": 835, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::memsetData", "display_name": "Sanitizer_GraphNodeLaunchData::memsetData", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData10memsetDataE", "priority": 1, "content": "Sanitizer_MemsetData  memsetData This is only valid if nodeType is CU_GRAPH_NODE_TYPE_MEMSET.", "keywords": []}, {"id": 836, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::node", "display_name": "Sanitizer_GraphNodeLaunchData::node", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData4nodeE", "priority": 1, "content": "CUgraphNode  node CUDA graphs node being launched.", "keywords": []}, {"id": 837, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "cpp", "name": "Sanitizer_GraphNodeLaunchData::nodeType", "display_name": "Sanitizer_GraphNodeLaunchData::nodeType", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "_CPPv4N29Sanitizer_GraphNodeLaunchData8nodeTypeE", "priority": 1, "content": "CUgraphNodeType  nodeType CUDA graphs node type.", "keywords": []}, {"id": 838, "doc_id": 838, "filename": "api/structSanitizer__GraphNodeLaunchData.html", "domain_name": "std", "name": "api/structSanitizer__GraphNodeLaunchData", "display_name": "Sanitizer_GraphNodeLaunchData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__GraphNodeLaunchData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 839, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData", "display_name": "Sanitizer_LaunchData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv420Sanitizer_LaunchData", "priority": 1, "content": "struct  Sanitizer_LaunchData Data passed into a launch callback function. Data passed into a launch callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_LAUNCH. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Unnamed Group", "keywords": []}, {"id": 840, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::apiContext", "display_name": "Sanitizer_LaunchData::apiContext", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData10apiContextE", "priority": 1, "content": "CUcontext  apiContext Only valid for graph node launches. This is the context of the stream used in the graph launch API call.", "keywords": []}, {"id": 841, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::apiStream", "display_name": "Sanitizer_LaunchData::apiStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData9apiStreamE", "priority": 1, "content": "CUstream  apiStream Only valid for graph node launches. This is the stream used in the graph launch API call.", "keywords": []}, {"id": 842, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::blockDim_x", "display_name": "Sanitizer_LaunchData::blockDim_x", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData10blockDim_xE", "priority": 1, "content": "uint32_t  blockDim_x", "keywords": []}, {"id": 843, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::blockDim_y", "display_name": "Sanitizer_LaunchData::blockDim_y", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData10blockDim_yE", "priority": 1, "content": "uint32_t  blockDim_y", "keywords": []}, {"id": 844, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::blockDim_z", "display_name": "Sanitizer_LaunchData::blockDim_z", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData10blockDim_zE", "priority": 1, "content": "uint32_t  blockDim_z", "keywords": []}, {"id": 845, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::clusterDim_x", "display_name": "Sanitizer_LaunchData::clusterDim_x", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData12clusterDim_xE", "priority": 1, "content": "uint32_t  clusterDim_x", "keywords": []}, {"id": 846, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::clusterDim_y", "display_name": "Sanitizer_LaunchData::clusterDim_y", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData12clusterDim_yE", "priority": 1, "content": "uint32_t  clusterDim_y", "keywords": []}, {"id": 847, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::clusterDim_z", "display_name": "Sanitizer_LaunchData::clusterDim_z", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData12clusterDim_zE", "priority": 1, "content": "uint32_t  clusterDim_z Public Members", "keywords": []}, {"id": 848, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::context", "display_name": "Sanitizer_LaunchData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData7contextE", "priority": 1, "content": "CUcontext  context The context where the grid is launched. For graph node launches, this is the context in which the kernel will run.", "keywords": []}, {"id": 849, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::device", "display_name": "Sanitizer_LaunchData::device", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData6deviceE", "priority": 1, "content": "CUdevice  device The device where the grid is launched.", "keywords": []}, {"id": 850, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::function", "display_name": "Sanitizer_LaunchData::function", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData8functionE", "priority": 1, "content": "CUfunction  function The function of the grid launch.", "keywords": []}, {"id": 851, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::functionName", "display_name": "Sanitizer_LaunchData::functionName", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData12functionNameE", "priority": 1, "content": "const  char  * functionName The name of the launched function.", "keywords": []}, {"id": 852, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::gridDim_x", "display_name": "Sanitizer_LaunchData::gridDim_x", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData9gridDim_xE", "priority": 1, "content": "uint32_t  gridDim_x Launch properties of the grid. These values are only valid for SANITIZER_CBID_LAUNCH_BEGIN and graph node launch callbacks", "keywords": []}, {"id": 853, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::gridDim_y", "display_name": "Sanitizer_LaunchData::gridDim_y", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData9gridDim_yE", "priority": 1, "content": "uint32_t  gridDim_y", "keywords": []}, {"id": 854, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::gridDim_z", "display_name": "Sanitizer_LaunchData::gridDim_z", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData9gridDim_zE", "priority": 1, "content": "uint32_t  gridDim_z", "keywords": []}, {"id": 855, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::gridId", "display_name": "Sanitizer_LaunchData::gridId", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData6gridIdE", "priority": 1, "content": "uint64_t  gridId Unique identifier of the grid launch. For graph node launches, this is only unique within the graphexec launch.", "keywords": []}, {"id": 856, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::hApiStream", "display_name": "Sanitizer_LaunchData::hApiStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData10hApiStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hApiStream Unique handle for the API stream.", "keywords": []}, {"id": 857, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::hLaunch", "display_name": "Sanitizer_LaunchData::hLaunch", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData7hLaunchE", "priority": 1, "content": "Sanitizer_LaunchHandle  hLaunch Handle of the grid launch. This is only valid between the launch begin and end callbacks.", "keywords": []}, {"id": 858, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::hStream", "display_name": "Sanitizer_LaunchData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 859, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::module", "display_name": "Sanitizer_LaunchData::module", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData6moduleE", "priority": 1, "content": "CUmodule  module The module containing the grid code.", "keywords": []}, {"id": 860, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "cpp", "name": "Sanitizer_LaunchData::stream", "display_name": "Sanitizer_LaunchData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__LaunchData", "anchor": "_CPPv4N20Sanitizer_LaunchData6streamE", "priority": 1, "content": "CUstream  stream The stream where the grid is launched.", "keywords": []}, {"id": 861, "doc_id": 861, "filename": "api/structSanitizer__LaunchData.html", "domain_name": "std", "name": "api/structSanitizer__LaunchData", "display_name": "Sanitizer_LaunchData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__LaunchData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 862, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData", "display_name": "Sanitizer_MemcpyData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv420Sanitizer_MemcpyData", "priority": 1, "content": "struct  Sanitizer_MemcpyData Data passed into a memcpy callback function. Data passed into a launch callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_MEMCPY. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 863, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::apiContext", "display_name": "Sanitizer_MemcpyData::apiContext", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10apiContextE", "priority": 1, "content": "CUcontext  apiContext The context on which the operation was requested.", "keywords": []}, {"id": 864, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::apiStream", "display_name": "Sanitizer_MemcpyData::apiStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData9apiStreamE", "priority": 1, "content": "CUstream  apiStream The stream on which the operation was requested.", "keywords": []}, {"id": 865, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::depth", "display_name": "Sanitizer_MemcpyData::depth", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData5depthE", "priority": 1, "content": "uint64_t  depth", "keywords": []}, {"id": 866, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::direction", "display_name": "Sanitizer_MemcpyData::direction", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData9directionE", "priority": 1, "content": "Sanitizer_MemcpyDirection  direction The direction of the transfer.", "keywords": []}, {"id": 867, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::dstAddress", "display_name": "Sanitizer_MemcpyData::dstAddress", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10dstAddressE", "priority": 1, "content": "uint64_t  dstAddress The destination allocation address.", "keywords": []}, {"id": 868, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::dstContext", "display_name": "Sanitizer_MemcpyData::dstContext", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10dstContextE", "priority": 1, "content": "CUcontext  dstContext The context where the destination allocation is located.", "keywords": []}, {"id": 869, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::dstPitch", "display_name": "Sanitizer_MemcpyData::dstPitch", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData8dstPitchE", "priority": 1, "content": "uint64_t  dstPitch The destination allocation pitch.", "keywords": []}, {"id": 870, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::dstStream", "display_name": "Sanitizer_MemcpyData::dstStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData9dstStreamE", "priority": 1, "content": "CUstream  dstStream The stream where the memcpy is executed on the destination context.", "keywords": []}, {"id": 871, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::hApiStream", "display_name": "Sanitizer_MemcpyData::hApiStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10hApiStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hApiStream Unique handle for the API stream.", "keywords": []}, {"id": 872, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::hDstStream", "display_name": "Sanitizer_MemcpyData::hDstStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10hDstStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hDstStream Unique handle for the destination context stream.", "keywords": []}, {"id": 873, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::hSrcStream", "display_name": "Sanitizer_MemcpyData::hSrcStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10hSrcStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hSrcStream Unique handle for the source context stream.", "keywords": []}, {"id": 874, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::height", "display_name": "Sanitizer_MemcpyData::height", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData6heightE", "priority": 1, "content": "uint64_t  height", "keywords": []}, {"id": 875, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::isAsync", "display_name": "Sanitizer_MemcpyData::isAsync", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData7isAsyncE", "priority": 1, "content": "uint32_t  isAsync Boolean value indicating if the transfer is asynchronous.", "keywords": []}, {"id": 876, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::size", "display_name": "Sanitizer_MemcpyData::size", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData4sizeE", "priority": 1, "content": "uint64_t  size Size of the transfer in bytes.", "keywords": []}, {"id": 877, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::srcAddress", "display_name": "Sanitizer_MemcpyData::srcAddress", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10srcAddressE", "priority": 1, "content": "uint64_t  srcAddress The source allocation address.", "keywords": []}, {"id": 878, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::srcContext", "display_name": "Sanitizer_MemcpyData::srcContext", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData10srcContextE", "priority": 1, "content": "CUcontext  srcContext The context where the source allocation is located.", "keywords": []}, {"id": 879, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::srcPitch", "display_name": "Sanitizer_MemcpyData::srcPitch", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData8srcPitchE", "priority": 1, "content": "uint64_t  srcPitch The source allocation pitch.", "keywords": []}, {"id": 880, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::srcStream", "display_name": "Sanitizer_MemcpyData::srcStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData9srcStreamE", "priority": 1, "content": "CUstream  srcStream The stream where the memcpy is executed on the source context.", "keywords": []}, {"id": 881, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "cpp", "name": "Sanitizer_MemcpyData::width", "display_name": "Sanitizer_MemcpyData::width", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemcpyData", "anchor": "_CPPv4N20Sanitizer_MemcpyData5widthE", "priority": 1, "content": "uint64_t  width Memcpy size configuration.", "keywords": []}, {"id": 882, "doc_id": 882, "filename": "api/structSanitizer__MemcpyData.html", "domain_name": "std", "name": "api/structSanitizer__MemcpyData", "display_name": "Sanitizer_MemcpyData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__MemcpyData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 883, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData", "display_name": "Sanitizer_MemsetData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv420Sanitizer_MemsetData", "priority": 1, "content": "struct  Sanitizer_MemsetData Data passed into a memset callback function. Data passed into a launch callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_MEMSET. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 884, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::address", "display_name": "Sanitizer_MemsetData::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData7addressE", "priority": 1, "content": "uint64_t  address The address of the memset start.", "keywords": []}, {"id": 885, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::context", "display_name": "Sanitizer_MemsetData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData7contextE", "priority": 1, "content": "CUcontext  context The context where the allocation is located.", "keywords": []}, {"id": 886, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::elementSize", "display_name": "Sanitizer_MemsetData::elementSize", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData11elementSizeE", "priority": 1, "content": "uint32_t  elementSize", "keywords": []}, {"id": 887, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::hStream", "display_name": "Sanitizer_MemsetData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 888, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::height", "display_name": "Sanitizer_MemsetData::height", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData6heightE", "priority": 1, "content": "uint64_t  height", "keywords": []}, {"id": 889, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::isAsync", "display_name": "Sanitizer_MemsetData::isAsync", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData7isAsyncE", "priority": 1, "content": "uint32_t  isAsync Boolean value indicating if the transfer is asynchronous.", "keywords": []}, {"id": 890, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::pitch", "display_name": "Sanitizer_MemsetData::pitch", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData5pitchE", "priority": 1, "content": "uint64_t  pitch", "keywords": []}, {"id": 891, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::stream", "display_name": "Sanitizer_MemsetData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData6streamE", "priority": 1, "content": "CUstream  stream The stream where the memset is executed.", "keywords": []}, {"id": 892, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::value", "display_name": "Sanitizer_MemsetData::value", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData5valueE", "priority": 1, "content": "uint32_t  value Value to be written.", "keywords": []}, {"id": 893, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "cpp", "name": "Sanitizer_MemsetData::width", "display_name": "Sanitizer_MemsetData::width", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__MemsetData", "anchor": "_CPPv4N20Sanitizer_MemsetData5widthE", "priority": 1, "content": "uint64_t  width Memset size configuration.", "keywords": []}, {"id": 894, "doc_id": 894, "filename": "api/structSanitizer__MemsetData.html", "domain_name": "std", "name": "api/structSanitizer__MemsetData", "display_name": "Sanitizer_MemsetData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__MemsetData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 895, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData", "display_name": "Sanitizer_ResourceArrayData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv427Sanitizer_ResourceArrayData", "priority": 1, "content": "struct  Sanitizer_ResourceArrayData Data passed into a CUDA array callback function. Data passed into a CUDA array callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal tp SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_ARRAY_CREATED or SANITIZER_CBID_RESOURCE_ARRAY_DESTROYED. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 896, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData::context", "display_name": "Sanitizer_ResourceArrayData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv4N27Sanitizer_ResourceArrayData7contextE", "priority": 1, "content": "CUcontext  context The context containing the array being created or destroyed.", "keywords": []}, {"id": 897, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData::depth", "display_name": "Sanitizer_ResourceArrayData::depth", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv4N27Sanitizer_ResourceArrayData5depthE", "priority": 1, "content": "uint64_t  depth", "keywords": []}, {"id": 898, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData::hArray", "display_name": "Sanitizer_ResourceArrayData::hArray", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv4N27Sanitizer_ResourceArrayData6hArrayE", "priority": 1, "content": "CUarray  hArray The CUDA array being created or destroyed.", "keywords": []}, {"id": 899, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData::height", "display_name": "Sanitizer_ResourceArrayData::height", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv4N27Sanitizer_ResourceArrayData6heightE", "priority": 1, "content": "uint64_t  height", "keywords": []}, {"id": 900, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceArrayData::width", "display_name": "Sanitizer_ResourceArrayData::width", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "_CPPv4N27Sanitizer_ResourceArrayData5widthE", "priority": 1, "content": "uint64_t  width The CUDA array size.", "keywords": []}, {"id": 901, "doc_id": 901, "filename": "api/structSanitizer__ResourceArrayData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceArrayData", "display_name": "Sanitizer_ResourceArrayData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceArrayData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 902, "doc_id": 905, "filename": "api/structSanitizer__ResourceContextData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceContextData", "display_name": "Sanitizer_ResourceContextData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceContextData", "anchor": "_CPPv429Sanitizer_ResourceContextData", "priority": 1, "content": "struct  Sanitizer_ResourceContextData Data passed into a context resource callback function. Data passed into a context resource callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_STARTING, SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_FINISHED, SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_STARTING or SANITIZER_CBID_RESOURCE_CONTEXT_DESTROY_FINISHED. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 903, "doc_id": 905, "filename": "api/structSanitizer__ResourceContextData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceContextData::context", "display_name": "Sanitizer_ResourceContextData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceContextData", "anchor": "_CPPv4N29Sanitizer_ResourceContextData7contextE", "priority": 1, "content": "CUcontext  context The context being created or destroyed.", "keywords": []}, {"id": 904, "doc_id": 905, "filename": "api/structSanitizer__ResourceContextData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceContextData::device", "display_name": "Sanitizer_ResourceContextData::device", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceContextData", "anchor": "_CPPv4N29Sanitizer_ResourceContextData6deviceE", "priority": 1, "content": "CUdevice  device The device on which the context is being created or destroyed. This field is only valid for SANITIZER_CBID_RESOURCE_CONTEXT_CREATION_* callbacks.", "keywords": []}, {"id": 905, "doc_id": 905, "filename": "api/structSanitizer__ResourceContextData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceContextData", "display_name": "Sanitizer_ResourceContextData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceContextData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 906, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceFunctionsLazyLoadedData", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "_CPPv441Sanitizer_ResourceFunctionsLazyLoadedData", "priority": 1, "content": "struct  Sanitizer_ResourceFunctionsLazyLoadedData Data passed into a CUDA function callback function. Data passed into a CUDA function callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal tp SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_LOADED or SANITIZER_CBID_RESOURCE_FUNCTIONS_LAZY_PATCHED. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 907, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceFunctionsLazyLoadedData::context", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "_CPPv4N41Sanitizer_ResourceFunctionsLazyLoadedData7contextE", "priority": 1, "content": "CUcontext  context The context containing the functions.", "keywords": []}, {"id": 908, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceFunctionsLazyLoadedData::functions", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData::functions", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "_CPPv4N41Sanitizer_ResourceFunctionsLazyLoadedData9functionsE", "priority": 1, "content": "const  CUfunction  * functions An array containing the functions.", "keywords": []}, {"id": 909, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceFunctionsLazyLoadedData::module", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData::module", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "_CPPv4N41Sanitizer_ResourceFunctionsLazyLoadedData6moduleE", "priority": 1, "content": "CUmodule  module The module containing the functions.", "keywords": []}, {"id": 910, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceFunctionsLazyLoadedData::numFunctions", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData::numFunctions", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "_CPPv4N41Sanitizer_ResourceFunctionsLazyLoadedData12numFunctionsE", "priority": 1, "content": "uint32_t  numFunctions The size of the function array.", "keywords": []}, {"id": 911, "doc_id": 911, "filename": "api/structSanitizer__ResourceFunctionsLazyLoadedData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "display_name": "Sanitizer_ResourceFunctionsLazyLoadedData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceFunctionsLazyLoadedData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 912, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData", "display_name": "Sanitizer_ResourceMemoryData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv428Sanitizer_ResourceMemoryData", "priority": 1, "content": "struct  Sanitizer_ResourceMemoryData Data passed into a memory resource callback function. Data passed into a memory resource callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_ALLOC, SANITIZER_CBID_RESOURCE_DEVICE_MEMORY_FREE, SANITIZER_CBID_RESOURCE_HOST_MEMORY_ALLOC, SANITIZER_CBID_RESOURCE_HOST_MEMORY_FREE, SANITIZER_CBID_RESOURCE_MEMORY_ALLOC_ASYNC, SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC or SANITIZER_CBID_RESOURCE_MEMORY_FREE_ASYNC_DONE or SANITIZER_CBID_RESOURCE_MEMPOOL_IMPORT_POINTER. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 913, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::address", "display_name": "Sanitizer_ResourceMemoryData::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData7addressE", "priority": 1, "content": "uint64_t  address Address of the allocation being created or destroyed.", "keywords": []}, {"id": 914, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::context", "display_name": "Sanitizer_ResourceMemoryData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData7contextE", "priority": 1, "content": "CUcontext  context Context containing the allocation being created or destroyed. Can be NULL if the allocation is not attached to a context.", "keywords": []}, {"id": 915, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::device", "display_name": "Sanitizer_ResourceMemoryData::device", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData6deviceE", "priority": 1, "content": "CUdevice  device Device where the allocation is being created. Available for all cbid with a driver version of 455 or newer.", "keywords": []}, {"id": 916, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::flags", "display_name": "Sanitizer_ResourceMemoryData::flags", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData5flagsE", "priority": 1, "content": "uint32_t  flags Allocation details: use Sanitizer_ResourceMemoryFlags to interpret this field.", "keywords": []}, {"id": 917, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::hStream", "display_name": "Sanitizer_ResourceMemoryData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Stream containing the allocation being created or destroyed. Can be NULL if the allocation is not attached to a stream.", "keywords": []}, {"id": 918, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::memoryPool", "display_name": "Sanitizer_ResourceMemoryData::memoryPool", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData10memoryPoolE", "priority": 1, "content": "CUmemoryPool  memoryPool Memory pool containing the allocation being created or destroyed. Can be NULL if the allocation is not attached to a memory pool.", "keywords": []}, {"id": 919, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::permissions", "display_name": "Sanitizer_ResourceMemoryData::permissions", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData11permissionsE", "priority": 1, "content": "uint32_t  permissions Allocation permissions: use Sanitizer_ResourceMemoryPermissions to interpret this field.", "keywords": []}, {"id": 920, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::size", "display_name": "Sanitizer_ResourceMemoryData::size", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData4sizeE", "priority": 1, "content": "uint64_t  size Size of the allocation being created or destroyed.", "keywords": []}, {"id": 921, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::sourceDevice", "display_name": "Sanitizer_ResourceMemoryData::sourceDevice", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData12sourceDeviceE", "priority": 1, "content": "CUdevice  sourceDevice Source device of this allocation (different from device if SANITIZER_MEMORY_FLAG_PEER is set).", "keywords": []}, {"id": 922, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::stream", "display_name": "Sanitizer_ResourceMemoryData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData6streamE", "priority": 1, "content": "CUstream  stream Public handle for the stream.", "keywords": []}, {"id": 923, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMemoryData::visibility", "display_name": "Sanitizer_ResourceMemoryData::visibility", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "_CPPv4N28Sanitizer_ResourceMemoryData10visibilityE", "priority": 1, "content": "Sanitizer_MemoryVisibility  visibility Visibility of the allocation.", "keywords": []}, {"id": 924, "doc_id": 924, "filename": "api/structSanitizer__ResourceMemoryData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceMemoryData", "display_name": "Sanitizer_ResourceMemoryData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceMemoryData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 925, "doc_id": 929, "filename": "api/structSanitizer__ResourceMempoolData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMempoolData", "display_name": "Sanitizer_ResourceMempoolData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceMempoolData", "anchor": "_CPPv429Sanitizer_ResourceMempoolData", "priority": 1, "content": "struct  Sanitizer_ResourceMempoolData Data passed into a mempool resource callback function. Data passed into a mempool resource callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_MEMPOOL_CREATED, SANITIZER_CBID_RESOURCE_MEMPOOL_DESTROYING, SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED or SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 926, "doc_id": 929, "filename": "api/structSanitizer__ResourceMempoolData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMempoolData::device", "display_name": "Sanitizer_ResourceMempoolData::device", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMempoolData", "anchor": "_CPPv4N29Sanitizer_ResourceMempoolData6deviceE", "priority": 1, "content": "CUdevice  device Device that owns the memory pool.", "keywords": []}, {"id": 927, "doc_id": 929, "filename": "api/structSanitizer__ResourceMempoolData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMempoolData::memoryPool", "display_name": "Sanitizer_ResourceMempoolData::memoryPool", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMempoolData", "anchor": "_CPPv4N29Sanitizer_ResourceMempoolData10memoryPoolE", "priority": 1, "content": "CUmemoryPool  memoryPool Memory pool being created or destroyed.", "keywords": []}, {"id": 928, "doc_id": 929, "filename": "api/structSanitizer__ResourceMempoolData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceMempoolData::peerDevice", "display_name": "Sanitizer_ResourceMempoolData::peerDevice", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceMempoolData", "anchor": "_CPPv4N29Sanitizer_ResourceMempoolData10peerDeviceE", "priority": 1, "content": "CUdevice  peerDevice Device that access type changed. Available if cbid is SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_ENABLED or SANITIZER_CBID_RESOURCE_MEMPOOL_PEER_ACCESS_DISABLING.", "keywords": []}, {"id": 929, "doc_id": 929, "filename": "api/structSanitizer__ResourceMempoolData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceMempoolData", "display_name": "Sanitizer_ResourceMempoolData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceMempoolData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 930, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData", "display_name": "Sanitizer_ResourceModuleData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv428Sanitizer_ResourceModuleData", "priority": 1, "content": "struct  Sanitizer_ResourceModuleData Data passed into a module resource callback function. Data passed into a module resource callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_MODULE_LOADED or SANITIZER_CBID_RESOURCE_MODULE_UNLOAD_STARTING. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 931, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData::context", "display_name": "Sanitizer_ResourceModuleData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv4N28Sanitizer_ResourceModuleData7contextE", "priority": 1, "content": "CUcontext  context The context containing the module being loaded or unloaded.", "keywords": []}, {"id": 932, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData::cubinSize", "display_name": "Sanitizer_ResourceModuleData::cubinSize", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv4N28Sanitizer_ResourceModuleData9cubinSizeE", "priority": 1, "content": "size_t  cubinSize The size of the cubin.", "keywords": []}, {"id": 933, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData::library", "display_name": "Sanitizer_ResourceModuleData::library", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv4N28Sanitizer_ResourceModuleData7libraryE", "priority": 1, "content": "CUlibrary  library Library associated with the module.", "keywords": []}, {"id": 934, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData::module", "display_name": "Sanitizer_ResourceModuleData::module", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv4N28Sanitizer_ResourceModuleData6moduleE", "priority": 1, "content": "CUmodule  module The module being loaded or unloaded.", "keywords": []}, {"id": 935, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceModuleData::pCubin", "display_name": "Sanitizer_ResourceModuleData::pCubin", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "_CPPv4N28Sanitizer_ResourceModuleData6pCubinE", "priority": 1, "content": "const  char  * pCubin Pointer to the associated cubin.", "keywords": []}, {"id": 936, "doc_id": 936, "filename": "api/structSanitizer__ResourceModuleData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceModuleData", "display_name": "Sanitizer_ResourceModuleData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceModuleData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 937, "doc_id": 941, "filename": "api/structSanitizer__ResourceStreamData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceStreamData", "display_name": "Sanitizer_ResourceStreamData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceStreamData", "anchor": "_CPPv428Sanitizer_ResourceStreamData", "priority": 1, "content": "struct  Sanitizer_ResourceStreamData Data passed into a stream resource callback function. Data passed into a stream resource callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_STREAM_CREATED, SANITIZER_CBID_RESOURCE_STREAM_DESTROY_STARTING or SANITIZER_CBID_RESOURCE_STREAM_DESTROY_FINISHED. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 938, "doc_id": 941, "filename": "api/structSanitizer__ResourceStreamData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceStreamData::context", "display_name": "Sanitizer_ResourceStreamData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceStreamData", "anchor": "_CPPv4N28Sanitizer_ResourceStreamData7contextE", "priority": 1, "content": "CUcontext  context The context containing the stream being created or destroyed.", "keywords": []}, {"id": 939, "doc_id": 941, "filename": "api/structSanitizer__ResourceStreamData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceStreamData::hStream", "display_name": "Sanitizer_ResourceStreamData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceStreamData", "anchor": "_CPPv4N28Sanitizer_ResourceStreamData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 940, "doc_id": 941, "filename": "api/structSanitizer__ResourceStreamData.html", "domain_name": "cpp", "name": "Sanitizer_ResourceStreamData::stream", "display_name": "Sanitizer_ResourceStreamData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceStreamData", "anchor": "_CPPv4N28Sanitizer_ResourceStreamData6streamE", "priority": 1, "content": "CUstream  stream The stream being created or destroyed. This handle will be NULL for the STREAM_DESTROY_FINISHED cbid.", "keywords": []}, {"id": 941, "doc_id": 941, "filename": "api/structSanitizer__ResourceStreamData.html", "domain_name": "std", "name": "api/structSanitizer__ResourceStreamData", "display_name": "Sanitizer_ResourceStreamData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceStreamData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 942, "doc_id": 945, "filename": "api/structSanitizer__ResourceVirtualRange.html", "domain_name": "cpp", "name": "Sanitizer_ResourceVirtualRange", "display_name": "Sanitizer_ResourceVirtualRange", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__ResourceVirtualRange", "anchor": "_CPPv430Sanitizer_ResourceVirtualRange", "priority": 1, "content": "struct  Sanitizer_ResourceVirtualRange Data passed into a VA reservation callback function. Data passed into a VA reservation callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal tp SANITIZER_CB_DOMAIN_RESOURCE and cbid equal to SANITIZER_CBID_RESOURCE_VIRTUAL_RESERVE. or SANITIZER_CBID_RESOURCE_VIRTUAL_RELEASE. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Available with a driver version of 535 or newer. Public Members", "keywords": []}, {"id": 943, "doc_id": 945, "filename": "api/structSanitizer__ResourceVirtualRange.html", "domain_name": "cpp", "name": "Sanitizer_ResourceVirtualRange::address", "display_name": "Sanitizer_ResourceVirtualRange::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceVirtualRange", "anchor": "_CPPv4N30Sanitizer_ResourceVirtualRange7addressE", "priority": 1, "content": "uint64_t  address Address of the VA range being reserved or released.", "keywords": []}, {"id": 944, "doc_id": 945, "filename": "api/structSanitizer__ResourceVirtualRange.html", "domain_name": "cpp", "name": "Sanitizer_ResourceVirtualRange::size", "display_name": "Sanitizer_ResourceVirtualRange::size", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__ResourceVirtualRange", "anchor": "_CPPv4N30Sanitizer_ResourceVirtualRange4sizeE", "priority": 1, "content": "uint64_t  size Size of the VA range being reserved or released.", "keywords": []}, {"id": 945, "doc_id": 945, "filename": "api/structSanitizer__ResourceVirtualRange.html", "domain_name": "std", "name": "api/structSanitizer__ResourceVirtualRange", "display_name": "Sanitizer_ResourceVirtualRange", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__ResourceVirtualRange", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 946, "doc_id": 950, "filename": "api/structSanitizer__SynchronizeData.html", "domain_name": "cpp", "name": "Sanitizer_SynchronizeData", "display_name": "Sanitizer_SynchronizeData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__SynchronizeData", "anchor": "_CPPv425Sanitizer_SynchronizeData", "priority": 1, "content": "struct  Sanitizer_SynchronizeData Data passed into a synchronization callback function. Data passed into a synchronization callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_SYNCHRONIZE. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 947, "doc_id": 950, "filename": "api/structSanitizer__SynchronizeData.html", "domain_name": "cpp", "name": "Sanitizer_SynchronizeData::context", "display_name": "Sanitizer_SynchronizeData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__SynchronizeData", "anchor": "_CPPv4N25Sanitizer_SynchronizeData7contextE", "priority": 1, "content": "CUcontext  context For SANITIZER_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED, this is the context being synchronized. For SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED, this is the context of the stream being synchronized.", "keywords": []}, {"id": 948, "doc_id": 950, "filename": "api/structSanitizer__SynchronizeData.html", "domain_name": "cpp", "name": "Sanitizer_SynchronizeData::hStream", "display_name": "Sanitizer_SynchronizeData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__SynchronizeData", "anchor": "_CPPv4N25Sanitizer_SynchronizeData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 949, "doc_id": 950, "filename": "api/structSanitizer__SynchronizeData.html", "domain_name": "cpp", "name": "Sanitizer_SynchronizeData::stream", "display_name": "Sanitizer_SynchronizeData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__SynchronizeData", "anchor": "_CPPv4N25Sanitizer_SynchronizeData6streamE", "priority": 1, "content": "CUstream  stream This field is only valid for SANITIZER_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED. This is the stream being synchronized.", "keywords": []}, {"id": 950, "doc_id": 950, "filename": "api/structSanitizer__SynchronizeData.html", "domain_name": "std", "name": "api/structSanitizer__SynchronizeData", "display_name": "Sanitizer_SynchronizeData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__SynchronizeData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 951, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData", "display_name": "Sanitizer_UvmData", "type": "class", "display_type": "C++ class", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv417Sanitizer_UvmData", "priority": 1, "content": "struct  Sanitizer_UvmData Data passed into a managed memory callback function. Data passed into a managed memory callback function as the cbdata argument to Sanitizer_CallbackFunc . The cbdata will be this type for domain equal to SANITIZER_CB_DOMAIN_UVM. The callback data is only valid within the invocation of the callback function that is passed the data. If you need to retain some data for use outside of the callback, you must make a copy of it. Public Members", "keywords": []}, {"id": 952, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData::address", "display_name": "Sanitizer_UvmData::address", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv4N17Sanitizer_UvmData7addressE", "priority": 1, "content": "uint64_t  address The address of the allocation.", "keywords": []}, {"id": 953, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData::context", "display_name": "Sanitizer_UvmData::context", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv4N17Sanitizer_UvmData7contextE", "priority": 1, "content": "CUcontext  context The context where the allocation is located.", "keywords": []}, {"id": 954, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData::hStream", "display_name": "Sanitizer_UvmData::hStream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv4N17Sanitizer_UvmData7hStreamE", "priority": 1, "content": "Sanitizer_StreamHandle  hStream Unique handle for the stream.", "keywords": []}, {"id": 955, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData::stream", "display_name": "Sanitizer_UvmData::stream", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv4N17Sanitizer_UvmData6streamE", "priority": 1, "content": "CUstream  stream The stream on which the memory is attached. This is only valid if visibility is SANITIZER_MEMORY_VISIBILITY_STREAM.", "keywords": []}, {"id": 956, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "cpp", "name": "Sanitizer_UvmData::visibility", "display_name": "Sanitizer_UvmData::visibility", "type": "member", "display_type": "C++ member", "docname": "api/structSanitizer__UvmData", "anchor": "_CPPv4N17Sanitizer_UvmData10visibilityE", "priority": 1, "content": "Sanitizer_MemoryVisibility  visibility New visibility for the allocation.", "keywords": []}, {"id": 957, "doc_id": 957, "filename": "api/structSanitizer__UvmData.html", "domain_name": "std", "name": "api/structSanitizer__UvmData", "display_name": "Sanitizer_UvmData", "type": "doc", "display_type": "Page", "docname": "api/structSanitizer__UvmData", "anchor": "", "priority": -1, "content": "", "keywords": []}, {"id": 958, "doc_id": 958, "filename": "api/structs.html", "domain_name": "std", "name": "api/structs", "display_name": "Structs", "type": "doc", "display_type": "Page", "docname": "api/structs", "anchor": "", "priority": -1, "content": "Sanitizer_BatchMemopData  Data passed into a batch memop callback function. Sanitizer_CallbackData  Data passed into a runtime or driver API callback function. Sanitizer_EventData  Data passed into an event callback function. Sanitizer_ExternalMemoryData  Data passed into an external memory callback function. Sanitizer_GraphExecData  Data passed into a graphexec creation callback function. Sanitizer_GraphLaunchData  Data passed into a graph launch callback function. Sanitizer_GraphNodeLaunchData  Data passed into a graph node launch callback function. Sanitizer_LaunchData  Data passed into a launch callback function. Sanitizer_MemcpyData  Data passed into a memcpy callback function. Sanitizer_MemsetData  Data passed into a memset callback function. Sanitizer_ResourceArrayData  Data passed into a CUDA array callback function. Sanitizer_ResourceContextData  Data passed into a context resource callback function. Sanitizer_ResourceFunctionsLazyLoadedData  Data passed into a CUDA function callback function. Sanitizer_ResourceMemoryData  Data passed into a memory resource callback function. Sanitizer_ResourceMempoolData  Data passed into a mempool resource callback function. Sanitizer_ResourceModuleData  Data passed into a module resource callback function. Sanitizer_ResourceStreamData  Data passed into a stream resource callback function. Sanitizer_ResourceVirtualRange  Data passed into a VA reservation callback function. Sanitizer_SynchronizeData  Data passed into a synchronization callback function. Sanitizer_UvmData  Data passed into a managed memory callback function.", "keywords": []}, {"id": 959, "doc_id": 959, "filename": "content/notices.html", "domain_name": "std", "name": "content/notices", "display_name": "<no title>", "type": "doc", "display_type": "Page", "docname": "content/notices", "anchor": "", "priority": -1, "content": "Notices Notice ALL NVIDIA DESIGN SPECIFICATIONS, REFERENCE BOARDS, FILES, DRAWINGS, DIAGNOSTICS, LISTS, AND OTHER DOCUMENTS (TOGETHER AND SEPARATELY, \u201cMATERIALS\u201d) ARE BEING PROVIDED \u201cAS IS.\u201d NVIDIA MAKES NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE. Information furnished is believed to be accurate and reliable. However, NVIDIA Corporation assumes no responsibility for the consequences of use of such information or for any infringement of patents or other rights of third parties that may result from its use. No license is granted by implication of otherwise under any patent rights of NVIDIA Corporation. Specifications mentioned in this publication are subject to change without notice. This publication supersedes and replaces all other information previously supplied. NVIDIA Corporation products are not authorized as critical components in life support devices or systems without express written approval of NVIDIA Corporation. Trademarks NVIDIA and the NVIDIA logo are trademarks and/or registered trademarks of NVIDIA Corporation in the Unites States and other countries. Other company and product names may be trademarks of the respective companies with which they are associated.", "keywords": []}, {"id": 960, "doc_id": 963, "filename": "index.html", "domain_name": "page", "name": "index#copyright-and-licenses", "display_name": "Copyright And Licenses", "type": "section", "display_type": "Page section", "docname": "index", "anchor": "copyright-and-licenses", "priority": -1, "content": "Copyright and Licenses Information on the NVIDIA Software License Agreement as well as third party software and tools used by Compute Sanitizer.", "keywords": []}, {"id": 961, "doc_id": 963, "filename": "index.html", "domain_name": "page", "name": "index#developer-interfaces", "display_name": "Developer Interfaces", "type": "section", "display_type": "Page section", "docname": "index", "anchor": "developer-interfaces", "priority": -1, "content": "Compute Sanitizer API Reference Manual Sanitizer API The NVIDIA Compute Sanitizer API. NVTX API for Compute Sanitizer Reference Manual", "keywords": []}, {"id": 962, "doc_id": 963, "filename": "index.html", "domain_name": "page", "name": "index#tools", "display_name": "Tools", "type": "section", "display_type": "Page section", "docname": "index", "anchor": "tools", "priority": -1, "content": "Compute Sanitizer", "keywords": []}, {"id": 963, "doc_id": 963, "filename": "index.html", "domain_name": "std", "name": "index", "display_name": "Compute Sanitizer", "type": "doc", "display_type": "Page", "docname": "index", "anchor": "", "priority": -1, "content": "Release Notes Release notes and known issues.", "keywords": []}]};